//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"

function SetOptionenFremdbelueftung_Init(oData) {
  /*
    nn Hilfsmerkmal O_G00_G02_1PH8				Fremdlüfter		da nirgends ausgewertet, unnötig
    O_G00_B_G11_1PH8			Lage des Fremdlüfters
    O_K69_K70_K71_K80_1PH8		Rohranschluss
    O_Q25_1PH8					Lüfteranschluss NDE / oben (M16 x 1,5)
    O_G14_1PH8					mit Luftfilter
    O_L74_1PH8					Lüfterausführung in Schutzart IP65
    O_L75_1PH8					Sonderlüfter 3 AC 400 V in Schutzart IP65
    O_L76_1PH8					EC-Lüfter 3 AC 400 V 50/60 Hz
    O_Q14_1PH8					Filter für Sonderlüfter
    O_L02_1PH8					Schraubensicherung mit Loctite und verstärkte Lüfterausführung		<== nur DI und AH280, nicht relevant!
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_Fremdluefter(oData); // O_G00_B_G11_1PH8				Lage des Fremdlüfters
    Bestimme_K69_K80(oData); // O_K69_K70_K71_K80_1PH8		Rohranschluss
    Bestimme_Q25(oData); // O_Q25_1PH8					Lüfteranschluss NDE / oben (M16 x 1,5)
    Bestimme_G14(oData); // O_G14_1PH8					mit Luftfilter
    Bestimme_L74(oData); // O_L74_1PH8					Lüfterausführung in Schutzart IP65
    Bestimme_L75(oData); // O_L75_1PH8					Sonderlüfter 3 AC 400 V in Schutzart IP65
    Bestimme_L76(oData); // O_L76_1PH8					EC-Lüfter 3 AC 400 V 50/60 Hz
    Bestimme_Q14(oData); // O_Q14_1PH8					Filter für Sonderlüfter
    //Bestimme_L02(oData);				// O_L02_1PH8					Schraubensicherung mit Loctite und verstärkte Lüfterausführung
  } else {
    ExecSetStandardifValueEmpty("O_G00_B_G11_1PH8", "NON"); // Lage des Fremdlüfters
    ExecSetStandardifValueEmpty("O_K69_K70_K71_K80_1PH8", "NON"); //
  }
}

function SetOptionenFremdbelueftung(strchangedAttribute, oData) { }
/**

*/
// #############################################################################################
function Bestimme_Fremdluefter(oData) {
  // O_G00_G02_1PH8				Fremdlüfter				nicht nötig! // Kein vorkommen in VTs
  // O_G00_B_G11_1PH8			Lage des Fremdlüfters

  //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // O_G00_B_G11_1PH8
  var sTargetAttribute = "O_G00_B_G11_1PH8";

  var aKAG = oData.oParsingData.MLFB.KAG || [];
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);
  var bCheck = false;
  if (sKAG != "NON" /*&& oData.IsStartConfig == "1"*/) {
    bCheck = check_FremdluefterKAG(oData, sKAG);
  } /*else{
        bCheck = true;
    }*/
  if (bCheck) {
    ECL_ActivateValue("O_G00_B_G11_1PH8", sKAG);
    ECL_SelectValue("O_G00_B_G11_1PH8", sKAG);
  } else {
    ECL_ActivateValue("O_G00_B_G11_1PH8", "NON");
    ECL_SelectValue("O_G00_B_G11_1PH8", "NON");
  }
  //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
}

function check_FremdluefterKAG(oData, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  if (oData.IsDriveTrain == "true" && sKAG != "G10") return 0;
  // -----------------------------------------------------------------------------------------

  /*
    VT_1PH8_M00304
    MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_G00_B_G11_1PH8

    VT_1PH8_M00345
    O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8

    VT_1PH8_M00354
    O_G00_B_G11_1PH8	O_K18_1PH8

    VT_1PH8_M00358
    O_K09_K10_1PH8	O_G00_B_G11_1PH8

    VT_1PH8_M00536
    MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8

    */
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;
  var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

  var O_L02_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L02_1PH8", "T")) {
    O_L02_1PH8 = "L02";
  }
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");
  var O_K18_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTarget = "O_G00_B_G11_1PH8";

  var sTable = "VT_1PH8_M00304" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "MLFB15_1PH8 = '" +
    MLFB15_1PH8 +
    "' AND " +
    "O_G00_B_G11_1PH8 = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var sTable = "VT_1PH8_M00345" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L02_1PH8 = '" +
    O_L02_1PH8 +
    "' AND " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_G00_B_G11_1PH8 = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var sTable = "VT_1PH8_M00354" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K18_1PH8 = '" +
    O_K18_1PH8 +
    "' AND " +
    "O_G00_B_G11_1PH8 = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var sTable = "VT_1PH8_M00358" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K09_K10_1PH8 = '" +
    O_K09_K10_1PH8 +
    "' AND " +
    "O_G00_B_G11_1PH8 = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  var sTable = "VT_1PH8_M00536" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB12_1PH8 = '" +
    MLFB12_1PH8 +
    "' AND " +
    "O_G14_1PH8 = '" +
    O_G14_1PH8 +
    "' AND " +
    "O_G00_B_G11_1PH8 = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// O_K69_K70_K71_K80_1PH8		Rohranschluss
function Bestimme_K69_K80(oData) {
  // O_K69_K70_K71_K80_1PH8		Rohranschluss
  // KAGs: NON, K69, K70, K71, K80

  var sTargetAttribute = "O_K69_K70_K71_K80_1PH8";
  var bCheck = false;

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var aKAG = oData.oParsingData.MLFB.KAG || [];
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON") {
    bCheck = check_K69_K80(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SelectValue(sTargetAttribute, sKAG);
  } else {
    ECL_ActivateValue(sTargetAttribute, "NON");
    ECL_SelectValue(sTargetAttribute, "NON");
  }
}
function check_K69_K80(oData, sTargetAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  var PMD_AAA136_001_000_1PH8 = ECL_GetValue("PMD_AAA136_001_000_1PH8");

  if (
    oData.IsDriveTrain == "true" &&
    (PMD_AAA136_001_000_1PH8 == "00001" ||
      PMD_AAA136_001_000_1PH8 == "00002") &&
    sKAG != "K10"
  ) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------

  /*
    A: VT_1PH8_M00607	K69-K70-K71-K80-AH-MLFB11-MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K69_K70_K71_K80_1PH8
    B: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    C: VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    D: VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8
    E: VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8
    F: VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
    G: VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8
    
    H: VT_1PH8_M00606	K80-Q25								todo
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;

  /* A: 
    VT_1PH8_M00607	K69-K70-K71-K80-AH-MLFB11-MLFB15
        MLFB05_1PH8	MLFB11_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var sTable = "VT_1PH8_M00607" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "MLFB15_1PH8 = '" +
    MLFB15_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
    VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    */
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00344" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_L74_1PH8 = '" +
    O_L74_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* C: 
    VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");
  var O_L02_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L02_1PH8", "T")) O_L02_1PH8 = "L02";

  var sTable = "VT_1PH8_M00345" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_G00_B_G11_1PH8 = '" +
    O_G00_B_G11_1PH8 +
    "' AND " +
    "O_L02_1PH8 = '" +
    O_L02_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* D: 
    VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8
    */
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00346" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_G14_1PH8 = '" +
    O_G14_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* E: 
    VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00357" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L75_1PH8 = '" +
    O_L75_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* F: 
    VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
    */
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00362" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_Q14_1PH8 = '" +
    O_Q14_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* G: 
    VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00527" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L76_1PH8 = '" +
    O_L76_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  /* 
    H: VT_1PH8_M00606	K80-Q25	
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */
  var O_Q25_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q25_1PH8", "T")) {
    O_Q25_1PH8 = "Q25";
  }

  var sTable = "VT_1PH8_M00606" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_Q25_1PH8 = '" +
    O_Q25_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
//Bestimme_Q25(oData);				// O_Q25_1PH8					Lüfteranschluss NDE / oben (M16 x 1,5)
function Bestimme_Q25(oData) {
  // O_Q25_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("Q25") >= 0) {
    bCheck = check_Q25(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_Q25_1PH8");
    ECL_SelectValue("CB_O_Q25_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_Q25_1PH8");
  }
}
function check_Q25(oData) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  /*
    VT_1PH8_M00569	Q25-AH-MLFB11-MLFB12
        MLFB11_1PH8	MLFB12_1PH8	MLFB05_1PH8	MLFB08_1PH8	O_Q25_1PH8
    */
  // todo Prüfen, ob abzubilden
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

  var sTarget = "O_Q25_1PH8";

  var sTable = "VT_1PH8_M00569" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB08_1PH8 = '" +
    MLFB08_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "MLFB12_1PH8 = '" +
    MLFB12_1PH8 +
    "' AND " +
    "O_Q25_1PH8 = 'Q25';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  /* 
    H: VT_1PH8_M00606	K80-Q25	
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00606" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_Q25_1PH8 = 'Q25';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// #############################################################################################
// Bestimme_G14(oData);				// O_G14_1PH8					mit Luftfilter
function Bestimme_G14(oData) {
  // O_G14_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("G14") >= 0) {
    bCheck = check_G14(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_G14_1PH8");
    ECL_SelectValue("CB_O_G14_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_G14_1PH8");
  }
}
function check_G14(oData) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  if (oData.IsDriveTrain == "true" && MLFB11_1PH8 != "1" && MLFB11_1PH8 != "4")
    return 0;
  // -----------------------------------------------------------------------------------------

  /*
    VT_1PH8_M00538	Q25-AH-MLFB11-MLFB12
        MLFB11_1PH8	MLFB12_1PH8	MLFB05_1PH8	O_Q25_1PH8
    */
  // todo Prüfen, ob abzubilden
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

  /*
    A: VT_1PH8_M00305	G14-AH-MLFB08-MLFB11
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_G14_1PH8

    B: VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8
    
    C: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8

    D: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8

    E: VT_1PH8_M00353	AH-G14-K18
        MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8

    F: VT_1PH8_M00536	MLFB12-G14-G00_B_G11
        MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
    */
  var sTarget = "O_G14_1PH8";

  // A:
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  var sTable = "VT_1PH8_M00305" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB08_1PH8 = '" +
    MLFB08_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00346	K69-K80-G14
  //	O_K69_K70_K71_K80_1PH8	O_G14_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00346" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00350" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = '" +
    O_Q14_1PH8 +
    "' AND " +
    "O_L74_1PH8 = '" +
    O_L74_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00351	M03-M39-G14-L75
  //	O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00351" + sDB_Suffix;
  var sWhere =
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_L75_1PH8 = '" +
    O_L75_1PH8 +
    "';";

  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_L75_1PH8 = '" +
    O_L75_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00353	AH-G14-K18
  //	MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8
  var O_K18_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";

  var sTable = "VT_1PH8_M00353" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "O_K18_1PH8 = '" +
    O_K18_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // F:
  // VT_1PH8_M00536	MLFB12-G14-G00_B_G11
  //	MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");
  var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

  var sTable = "VT_1PH8_M00536" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_G00_B_G11_1PH8 = '" +
    O_G00_B_G11_1PH8 +
    "' AND " +
    "MLFB12_1PH8 = '" +
    MLFB12_1PH8 +
    "' AND " +
    "O_G14_1PH8 = 'G14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
function Bestimme_L74(oData) {
  // O_L74_1PH8					Lüfterausführung in Schutzart IP65
  // O_L74_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("L74") >= 0) {
    bCheck = check_L74(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_L74_1PH8");
    ECL_SelectValue("CB_O_L74_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_L74_1PH8");
  }
}
function check_L74(oData) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------

  var sTarget = "O_L74_1PH8";
  /*
    A: VT_1PH8_M00567	L74-AH-MLFB8-MLFB11
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_L74_1PH8
    B: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    C: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
    D: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    */
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;

  // A:
  var sTable = "VT_1PH8_M00567" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB08_1PH8 = '" +
    MLFB08_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "O_L74_1PH8 = 'L74';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00344	M03-M39-K80-L74
  //	O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00344" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_L74_1PH8 = 'L74';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00350" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "O_G14_1PH8 = '" +
    O_G14_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = '" +
    O_Q14_1PH8 +
    "' AND " +
    "O_L74_1PH8 = 'L74';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //		O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L03_1PH8 = '" +
    O_L03_1PH8 +
    "' AND " +
    "O_L75_1PH8 = '" +
    O_L75_1PH8 +
    "' AND " +
    "O_L76_1PH8 = '" +
    O_L76_1PH8 +
    "' AND " +
    "O_L74_1PH8 = 'L74';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// Bestimme_L75(oData);				// O_L75_1PH8					Sonderlüfter 3 AC 400 V in Schutzart IP65
function Bestimme_L75(oData) {
  // O_L75_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("L75") >= 0) {
    bCheck = check_L75(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_L75_1PH8");
    ECL_SelectValue("CB_O_L75_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_L75_1PH8");
  }
}
function check_L75(oData) {
  // Update 06/2024 nur noch für Direkteingabe
  return 0;

  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  var sTarget = "O_L75_1PH8";

  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  /*
    A: VT_1PH8_M00320	L75-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_L75_1PH8
    B: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
    C: VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8
    D: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    */

  // A:
  var sTable = "VT_1PH8_M00320" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "O_L75_1PH8 = 'L75';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00351	M03-M39-G14-L75
  //	O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00351" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_G14_1PH8 = '" +
    O_G14_1PH8 +
    "' AND " +
    "O_L75_1PH8 = 'L75';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00357	L75-K80
  //	O_L75_1PH8	O_K69_K70_K71_K80_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00357" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_L75_1PH8 = 'L75';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //	O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L03_1PH8 = '" +
    O_L03_1PH8 +
    "' AND " +
    "O_L74_1PH8 = '" +
    O_L74_1PH8 +
    "' AND " +
    "O_L76_1PH8 = '" +
    O_L76_1PH8 +
    "' AND " +
    "O_L75_1PH8 = 'L75';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// Bestimme_L76(oData);				// O_L76_1PH8					EC-Lüfter 3 AC 400 V 50/60 Hz
function Bestimme_L76(oData) {
  // O_L76_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("L76") >= 0) {
    bCheck = check_L76(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_L76_1PH8");
    ECL_SelectValue("CB_O_L76_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_L76_1PH8");
  }
}
function check_L76(oData) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  var sTarget = "O_L76_1PH8";

  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  /*
    A: VT_1PH8_M00524	L76-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_L76_1PH8
    
    B: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    
    C: VT_1PH8_M00526	M03-M39-L76
        O_M03_M39_1PH8	O_L76_1PH8

    D: VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8

    E: VT_1PH8_M00528	L76-Q14
        O_L76_1PH8	O_Q14_1PH8
    */
  var sDTKAttribute = "O_L76_1PH8";
  var sCB_Attribute = "CB_O_L76_1PH8";

  // A:
  var sTable = "VT_1PH8_M00524" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "O_L76_1PH8 = 'L76';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //	O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L03_1PH8 = '" +
    O_L03_1PH8 +
    "' AND " +
    "O_L74_1PH8 = '" +
    O_L74_1PH8 +
    "' AND " +
    "O_L75_1PH8 = '" +
    O_L75_1PH8 +
    "' AND " +
    "O_L76_1PH8 = 'L76';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00526	M03-M39-L76
  //	O_M03_M39_1PH8	O_L76_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00526" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_L76_1PH8 = 'L76';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00527	L76-K80
  //	O_L76_1PH8	O_K69_K70_K71_K80_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00527" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_L76_1PH8 = 'L76';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00528	L76-Q14
  //	O_L76_1PH8	O_Q14_1PH8
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00528" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_Q14_1PH8 = '" +
    O_Q14_1PH8 +
    "' AND " +
    "O_L76_1PH8 = 'L76';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
// #############################################################################################
// Bestimme_Q14(oData);				// O_Q14_1PH8					Filter für Sonderlüfter
function Bestimme_Q14(oData) {
  // O_Q14_1PH8
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("Q14") >= 0) {
    bCheck = check_Q14(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_Q14_1PH8");
    ECL_SelectValue("CB_O_Q14_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_Q14_1PH8");
  }
}
function check_Q14(oData) {
  return 0; // Edit 11/2024 only for direct input, so not supported //

  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  var sTarget = "O_Q14_1PH8";

  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  /*
    A: VT_1PH8_M00328	Q14-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_Q14_1PH8
    B: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
    C: VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
    D: VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
    E: VT_1PH8_M00528	L76-Q14
        O_L76_1PH8	O_Q14_1PH8
    */

  // A:
  var sTable = "VT_1PH8_M00328" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = 'Q14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00345" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "O_G14_1PH8 = '" +
    O_G14_1PH8 +
    "' AND " +
    "O_L74_1PH8 = '" +
    O_L74_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = 'Q14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00361	L03-Q14-M39
  //	O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";

  var sTable = "VT_1PH8_M00361" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L03_1PH8 = '" +
    O_L03_1PH8 +
    "' AND " +
    "O_M03_M39_1PH8 = '" +
    O_M03_M39_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = 'Q14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00362	K80-Q14
  //	O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00362" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K69_K70_K71_K80_1PH8 = '" +
    O_K69_K70_K71_K80_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = 'Q14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00528	L76-Q14
  //	O_L76_1PH8	O_Q14_1PH8
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00528" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTarget +
    " FROM " +
    sTable +
    " WHERE " +
    "O_L76_1PH8 = '" +
    O_L76_1PH8 +
    "' AND " +
    "O_Q14_1PH8 = 'Q14';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
}
// #############################################################################################
// L02 nur bei DI und AH 280, da immer konfig, nicht mehr relevant!
// Bestimme_L02(oData);				// O_L02_1PH8					Schraubensicherung mit Loctite und verstärkte Lüfterausführung
/*
function Bestimme_L02(oData)
{
    // O_L02_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("L02") >= 0){
        bCheck = check_L02(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_L02_1PH8");
        ECL_SelectValue("CB_O_L02_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_L02_1PH8");
    }
}
function check_L02(oData)
{
    // L02 nur bei DI und AH 280, da immer konfig, nicht mehr relevant!
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    var sTarget = "O_L02_1PH8";
    
    
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    
    /*
    A: VT_1PH8_M00597	L02-AH-MLFB11 Konfigtyp
        MLFB05_1PH8	MLFB11_1PH8	O_L02_1PH8	HMK_KONFIG_TYP_1PH8
    B: VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    C: VT_1PH8_M00496	L02 <> Q21
        O_L02_1PH8	O_Q21_1PH8
    * /
    
    // A: 
    var sTable = "VT_1PH8_M00597" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + 
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + 
                "O_L02_1PH8 = 'L02' AND " + 
                "HMK_KONFIG_TYP_1PH8 = 'KONFIG';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    // B:
    // VT_1PH8_M00345	G00-G11-L02-K69-K71
    //	O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    var O_G00_B_G11_1PH8 		= ECL_GetValue("O_G00_B_G11_1PH8");
    var O_K69_K70_K71_K80_1PH8 	= ECL_GetValue("O_K69_K70_K71_K80_1PH8");
    
    var sTable = "VT_1PH8_M00345" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "' AND " + 
                "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "' AND " + 
                "O_L02_1PH8 = 'L02';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    // C:
    // VT_1PH8_M00496	L02 <> Q21
    //	O_L02_1PH8	O_Q21_1PH8
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var O_Q21_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_Q21_1PH8", "T"))
        O_Q21_1PH8 = "Q21";
    
    var sTable = "VT_1PH8_M00496" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_Q21_1PH8 = '" + O_Q21_1PH8 + "' AND " + 
                "O_L02_1PH8 = 'L02';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
}
*/
