//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenGebersystem_Init(oData)
{
    /*
    O_A12_1PH8			Zusätzliche Kaltleiterkette für Warnung und Abschaltung
    O_A25_1PH8			Zusätzlicher Temperatursensor als Reserve
    O_G50_1PH8			Messnippel für SPM, mit M8-Adapter
    O_A72_1002197		2 Widerstandsthermometer PT1000 zur Wälzlagertemperaturüberwachung (DE und NDE)
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_A12(oData);		// CB_O_A12_1PH8
        Bestimme_A25(oData);		// CB_O_A25_1PH8
        Bestimme_G50(oData);		// CB_O_G50_1PH8
        Bestimme_A72(oData);		// CB_O_A72_1002197
        
    } else {
        ECL_DeselectAttribute("CB_O_A12_1PH8");
        ECL_DeselectAttribute("CB_O_A25_1PH8");
        ECL_DeselectAttribute("CB_O_G50_1PH8");
        ECL_DeselectAttribute("CB_O_A72_1002197");
    }
}

function SetOptionenGebersystem(strchangedAttribute, oData)
{
    
}


// #############################################################################################
function Bestimme_A12(oData)
{
    // O_A12_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("A12") >= 0){
        bCheck = Check_A12(oData);
    }
    if (bCheck){
        //ExecSQL_KAG_Standard("O_A12_1PH8", oData.oParsingData.MLFB.KAG, "F");
        // ggf vereinfachen mit 
        ECL_EnableAttribute("CB_O_A12_1PH8");
        ECL_SelectValue("CB_O_A12_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_A12_1PH8");
    }
}

function Check_A12(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00333
    MLFB05_1PH8	MLFB15_1PH8	O_A12_1PH8

    VT_1PH8_M00342
    MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;
    
    var sTarget = "O_A12_1PH8";
    
    var sTable = "VT_1PH8_M00333" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
                "O_A12_1PH8 = 'A12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    var O_Q12_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_Q12_1PH8", "T")){
            O_Q12_1PH8 = "Q12";
        }
    
    var sTable = "VT_1PH8_M00342" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_Q12_1PH8 = '" + O_Q12_1PH8 + "' AND " +
                "O_A12_1PH8 = 'A12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_A25(oData)
{
    // O_A25_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("A25") >= 0){
        bCheck = Check_A25(oData);
    }
    if (bCheck){
        //ExecSQL_KAG_Standard("O_A12_1PH8", oData.oParsingData.MLFB.KAG, "F");
        // ggf vereinfachen mit 
        ECL_EnableAttribute("CB_O_A25_1PH8");
        ECL_SelectValue("CB_O_A25_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_A25_1PH8");
    }
}

function Check_A25(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00369
    O_A25_1PH8	O_M03_M39_1PH8

    VT_1PH8_M00370
    MLFB05_1PH8	MLFB15_1PH8	O_A25_1PH8

    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;

    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_A25_1PH8";
    
    var sTable = "VT_1PH8_M00369" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_A25_1PH8 = 'A25';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00370" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
                "O_A25_1PH8 = 'A25';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_G50(oData)
{
    // O_G50_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("G50") >= 0){
        bCheck = Check_G50(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_G50_1PH8");
        ECL_SelectValue("CB_O_G50_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_G50_1PH8");
    }
}

function Check_G50(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00427
    MLFB05_1PH8	O_G50_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    var sTarget = "O_G50_1PH8";
    
    var sTable = "VT_1PH8_M00427" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_G50_1PH8 = 'G50';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
//O_A72_1002197
function Bestimme_A72(oData)
{
    // O_A72_1002197
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("A72") >= 0){
        bCheck = Check_G50(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_A72_1002197");
        ECL_SelectValue("CB_O_A72_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_A72_1002197");
    }
}

function Check_A72(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00436
    MLFB05_1PH8	O_A72_1002197
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    var sTarget = "O_A72_1002197";
    
    var sTable = "VT_1PH8_M00436" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_A72_1002197 = 'A72';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}

// #############################################################################################
