//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"

function SetOptionenGrundierung_Init(oData) {
  /*
    O_X01__X27_1PH8			Farbe
    O_K23_1PH8				Sonder-Lackierung Worldwide
    O_K24_1PH8				Grundierung
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_Anstrich(oData); // Bestimmung Farbe und Grundierung (K24)
    Bestimme_K23(oData);
  } else {
    ExecSetStandardifValueEmpty("O_X01__X27_1PH8", "STD"); // Farbe
    ECL_DeselectAttribute("CB_O_K23_1PH8"); // Sonder-Lackierung Worldwide
    ECL_DeselectAttribute("CB_O_K23_1PH8"); // Grundierung
  }
}

function SetOptionenGrundierung(strchangedAttribute, oData) {}
/**

*/
function Bestimme_Anstrich(oData) {
  // Farbe aus KAG bestimmen, sonst STD
  var sTargetAttribute = "O_X01__X27_1PH8";
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON") {
    bCheck = checkFarbe(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SetValue(sTargetAttribute, sKAG);
  } else {
    // wenn K24 vorhanden ist, dann Grundierung: O_X01__X27_1PH8 in (OHNE, OHNE2). Unterscheidung über AH (VT500). 80...160 OHNE, 180...355 OHNE2
    if (aKAG.indexOf("K24") >= 0 || oData.IsDriveTrain == "true") {
      ECL_SelectValue("CB_O_K24_1PH8", "T");
      // OHNE oder OHNE2 abhängig von AH
      var PMD_ABP663_001_000_1002197 = ECL_GetValue("PMD_ABP663_001_000_1002197");
      var sTable = "VT_1PH8_M00500" + sDB_Suffix;
      var sSQL =
        "SELECT O_X01__X27_1PH8 FROM " +
        sTable +
        " WHERE " +
        "PMD_ABP663_001_000_1002197 = " +
        PMD_ABP663_001_000_1002197 +
        " AND " +
        "(O_X01__X27_1PH8 = 'OHNE' OR O_X01__X27_1PH8 = 'OHNE2');";
      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        var O_X01__X27_1PH8 = aResult[0].O_X01__X27_1PH8;
      }
      ECL_ActivateValue(sTargetAttribute, O_X01__X27_1PH8);
      ECL_SetValue(sTargetAttribute, O_X01__X27_1PH8);
    } else {
      ECL_ActivateValue(sTargetAttribute, "STD");
      ECL_SetValue(sTargetAttribute, "STD");
    }
  }
}
function checkFarbe(oData, sTargetAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  if (oData.IsDriveTrain == "true") return 0;
  // -----------------------------------------------------------------------------------------

  /*
    VT_1PH8_M00360	K24-X01-X08				nachrangig!
        O_K24_1PH8	O_X01__X27_1PH8

    VT_1PH8_M00500	AH <> Farben
        PMD_ABP663_001_000_1002197	O_X01__X27_1PH8
    */
  var PMD_ABP663_001_000_1002197 = ECL_GetValue("PMD_ABP663_001_000_1002197");

  var sTable = "VT_1PH8_M00500" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "PMD_ABP663_001_000_1002197 = '" +
    PMD_ABP663_001_000_1002197 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------

  //--------------------------------------------------------------------------------------------------------------
  return 1;
}
// #################################################################################################################

function Bestimme_K23(oData) {
  var sTargetAttribute = "O_K23_1PH8";
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  if (aKAG.indexOf("K23") >= 0) {
    bCheck = check_K23(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_K23_1PH8");
    ECL_SelectValue("CB_O_K23_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_K23_1PH8");
  }
}

function check_K23(oData) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  if (oData.IsDriveTrain == "true") return 0;
  // -----------------------------------------------------------------------------------------

  // wenn bereits K24, nicht erlaubt

  if (ECL_ValueSelected("CB_O_K24_1PH8", "T")) {
    return 0;
  }
  //--------------------------------------------------------------------------------------------------------------
  return 1;
}
