//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenLeistungsschild_Init(oData)
{
    /*
    O_Y84_1PH8				Kundenangabe auf dem Leistungsschild
    H_O_Y84_1006333			Kundenangabe auf dem Leistungsschild (Textfeld)
    O_Y82_1002197			Zusatzschild mit Bestellerangaben
    H_O_Y82_1006333			Zusatzschild mit Bestellerangaben (Textfeld)
    O_Q31_1PH8				Metallleistungsschild anstatt Klebeschild
    */
    
    if (oData && !isEmpty(oData)){
        
        Bestimme_Q31(oData);			// O_Q31_1FK2	Metall-Leistungsschild am Motor
        Bestimme_Y84(oData);			// O_Y84_1FK2	Kundenangabe auf dem Leistungsschild
        
    } else {
        ExecSetStandardifValueEmpty("O_Y84_1PH8","F");		// Kundenangabe auf dem Leistungsschild
        ECL_ResetAttribute("H_O_Y84_1006333");
        //ExecSetStandardifValueEmpty("O_Y82_1002197","F");	// Zusatzschild mit Bestellerangaben
        //ECL_DeactivateAttribute("H_O_Y82_1006333");
        ECL_DeselectAttribute("CB_O_Q31_1PH8");				// Metallleistungsschild anstatt Klebeschild
        
    }
}

function SetOptionenLeistungsschild(strchangedAttribute, oData)
{
    
}

// O_Q31_1PH8	Metall-Leistungsschild am Motor
function Bestimme_Q31(oData)
{
    // O_Q31_1PH8 / CB_O_Q31_1PH8
    // KAG: Q31, F
    var parseObj = oData.oParsingData;
    
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q31"; 
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = true; //checkQ31(oData, sTargetAttribute, sKAG);	// EDIT Update 08.2021_22383
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_O_Q31_1PH8");
        ECL_SelectValue("CB_O_Q31_1PH8", "T");
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_DeselectAttribute("CB_O_Q31_1PH8");
    }
}
function checkQ31(oData, sTargetAttribute, sKAG)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// ################################################################################################################
// Bestimme_Y84(oData)
// ################################################################################################################
function Bestimme_Y84(oData)
{
    // O_Y84_1PH8
    // KAG: Y84, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Y84_1PH8";
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1 && oData.IsDriveTrain != "true"){
        // es gibt eine KAG, immer erlaubt, also setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
        
        ECL_ResetAttribute("H_O_Y84_1006333");
    }
}

