//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenPruefbescheinigungen_Init(oData)
{
    /*
    O_B02_1PH8			Prüfbescheinigung 
    O_B35_1002197		Werkprüfbescheinigung für Schwingungsprotokoll
    O_B36_1002197		Werkprüfbescheinigung für Rundlaufprotokoll
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_B02(oData);
        Bestimme_B35(oData);
        Bestimme_B36(oData);
    } else {
        ECL_DeselectAttribute("CB_O_B02_1PH8");		// 
        ECL_DeselectAttribute("CB_O_B35_1002197");	// 
        ECL_DeselectAttribute("CB_O_B36_1002197");	// 
    }
}

function SetOptionenPruefbescheinigungen(strchangedAttribute, oData)
{
    
}

// #############################################################################################
function Bestimme_B02(oData)
{
    var bCheck = false;
    // O_B02_1PH8
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("B02") >= 0){
        bCheck = Check_B02(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_B02_1PH8");
        ECL_SelectValue("CB_O_B02_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_B02_1PH8");
    }
}

function Check_B02(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00426	AH-B02
        MLFB05_1PH8	O_B02_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    var sTarget = "O_B02_1PH8";
    
    var sTable = "VT_1PH8_M00426" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_B02_1PH8 = 'B02';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################

function Bestimme_B35(oData)
{
    var bCheck = false;
    // O_B35_1002197
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("B35") >= 0){
        bCheck = Check_B35(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_B35_1002197");
        ECL_SelectValue("CB_O_B35_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_B35_1002197");
    }
}

function Check_B35(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00495
    MLFB05_1PH8	MLFB14_1PH8	O_B35_1002197
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    
    var sTarget = "O_B35_1002197";
    
    var sTable = "VT_1PH8_M00495" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "O_B35_1002197 = 'B35';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################

function Bestimme_B36(oData)
{
    var bCheck = false;
    // O_B36_1002197
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("B36") >= 0){
        bCheck = Check_B36(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_B36_1002197");
        ECL_SelectValue("CB_O_B36_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_B36_1002197");
    }
}

function Check_B36(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00438
    MLFB05_1PH8	O_B36_1002197

    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    var sTarget = "O_B36_1002197";
    
    var sTable = "VT_1PH8_M00438" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_B36_1002197 = 'B36';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################

