//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenSchmierung_Init(oData)
{
    /*
    O_K40_1PH8			Nachschmiereinrichtung
    O_K18_1PH8			Radialwellendichtring DE
    */
    
    if (oData && !isEmpty(oData)){
        // O_K40_1PH8	Nachschmiereinrichtung:
        Bestimme_Nachschmiereinrichtung(oData);
        
        // O_K18_1PH8	Radialwellendichtring DE:
        Bestimme_Radialwellendichtring(oData);
        
    } else {
        ExecSetStandardifValueEmpty("O_K40_1PH8","NON");	// Nachschmiereinrichtung
        ECL_DeselectAttribute("CB_O_K18_1PH8");				// Radialwellendichtring		
    }
}

function SetOptionenSchmierung(strchangedAttribute, oData)
{
    
}

function Bestimme_Nachschmiereinrichtung(oData)
{
    /*
    VT_1PH8_M00311
    MLFB05_1PH8	O_K40_1PH8
    
    AH  80...160 nur NON
    AH 180...225 wählbar NON, K40
    AH 		 280 ==> STD
    */
    //Wenn 28, dann STD, sonst NON oder wählbar
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    if (MLFB05_1PH8 == "28"){
        // STD
        ECL_DeactivateAllAttributeValues("O_K40_1PH8");
        ECL_ActivateValue("O_K40_1PH8", "STD");
        ECL_SelectValue("O_K40_1PH8", "STD");
    }
    else if (MLFB05_1PH8 == "08" || MLFB05_1PH8 == "10" || MLFB05_1PH8 == "13" || MLFB05_1PH8 == "16"){
        // nur NON
        ECL_DeactivateAllAttributeValues("O_K40_1PH8");
        ECL_ActivateValue("O_K40_1PH8", "NON");
        ECL_SelectValue("O_K40_1PH8", "NON");
    }
    else{
        var aKAG = oData.oParsingData.MLFB.KAG || [];
        ECL_ActivateAllAttributeValues("O_K40_1PH8");
        ECL_DeactivateValue("O_K40_1PH8", "STD");
        if (aKAG.indexOf("K40") >= 0){
            ECL_SelectValue("O_K40_1PH8", "K40");
        }
        else{
            ECL_SelectValue("O_K40_1PH8", "NON");
        }
    }
}


function Bestimme_Radialwellendichtring(oData)
{
    // O_K18_1PH8	Radialwellendichtring DE
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("K18") >= 0){
        bCheck = Check_K18(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_K18_1PH8");
        ECL_SelectValue("CB_O_K18_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_K18_1PH8");
    }
}

function Check_K18(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00343
    // O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8
    
    VT_1PH8_M00353
    MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8

    
    VT_1PH8_M00354
    O_G00_B_G11_1PH8	O_K18_1PH8

    
    VT_1PH8_M00568	K18-AH-MLFB08-11-14
    MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_MLFB_05_11_1PH8	MLFB14_1PH8	O_K18_1PH8

    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    var O_G14_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_G14_1PH8", "T")){
            O_G14_1PH8 = "G14";
        }
    var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");
    //var HMK_RUMPF_MLFB_05_11_1PH8 = ECL_GetValue("HMK_RUMPF_MLFB_05_11_1PH8");
    
    var sTarget = "O_K18_1PH8";
    
    var sTable = "VT_1PH8_M00343" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
                "O_K18_1PH8 = 'K18';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00353" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_G14_1PH8 = '" + O_G14_1PH8 + "' AND " +
                "O_K18_1PH8 = 'K18';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00354" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "' AND " +
                "O_K18_1PH8 = 'K18';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00568" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                //"HMK_RUMPF_MLFB_05_11_1PH8 = '" + HMK_RUMPF_MLFB_05_11_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "O_K18_1PH8 = 'K18';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}

