//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenSonstiges_Init(oData)
{
    /*
    O_M83_1PH8			Zusätzliche Abdrückgewinde an Motorfüßen
    O_K45_1PH8			Stillstandsheizung AC 230 V
    O_Q12_1PH8			Sperrluftanschluss
    O_Q21_1PH8			Schraubensicherung mit Loctite
    O_L12_1PH8			Kondenswasserbohrung
    O_L03_1PH8			Erhöhte Rüttelbeanspruchung
    O_Y64_1PH8			Vorbereitung für lagerlosen Drehverteiler
    O_K17_1002197		Labyrinthdichtung DE für Performance-Ausführung
    O_Q81_1002197		Erhöhte Lageranstellung
    O_L27_1PH8			NDE-Lager in isolierter Ausführung
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_M83(oData);	// O_M83_1PH8	CB_O_M83_1PH8	Zusätzliche Abdrückgewinde an Motorfüßen
        Bestimme_K45(oData);	// O_K45_1PH8	CB_O_K45_1PH8	Stillstandsheizung AC 230 V
        Bestimme_Q12(oData);	// O_Q12_1PH8	CB_O_Q12_1PH8
        Bestimme_Q21(oData);	// O_Q21_1PH8	CB_O_Q21_1PH8
        
        Bestimme_L12(oData);	// O_L12_1PH8	CB_O_L12_1PH8
        Bestimme_L03(oData);	// O_L03_1PH8	CB_O_L03_1PH8
        
        Bestimme_Y64(oData);	// O_Y64_1PH8	CB_O_Y64_1PH8
        
        Bestimme_K17(oData);	// O_K17_1002197	CB_O_K17_1002197
        Bestimme_Q81(oData);	// O_Q81_1002197	CB_O_Q81_1002197
        Bestimme_L27(oData);	// O_L27_1PH8		CB_O_L27_1PH8
    } else {
        ECL_DeselectAttribute("CB_O_M83_1PH8");	
        ECL_DeselectAttribute("CB_O_K45_1PH8");	
        ECL_DeselectAttribute("CB_O_Q12_1PH8");	
        ECL_DeselectAttribute("CB_O_Q21_1PH8");
        
        ECL_DeselectAttribute("CB_O_L12_1PH8");	
        ECL_DeselectAttribute("CB_O_L03_1PH8");	
        
        ECL_DeselectAttribute("CB_O_Y64_1PH8");
        
        ECL_DeselectAttribute("CB_O_K17_1002197");	
        ECL_DeselectAttribute("CB_O_Q81_1002197");	
        ECL_DeselectAttribute("CB_O_L27_1PH8");	
    }
}

function SetOptionenSonstiges(strchangedAttribute, oData)
{
    
}
// #############################################################################################
function Bestimme_M83(oData)
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    //O_M83_1PH8
    if (aKAG.indexOf("M83") >= 0){
        bCheck = Check_M83(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_M83_1PH8");
        ECL_SelectValue("CB_O_M83_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_M83_1PH8");
    }
}
function Check_M83(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00519
    MLFB05_1PH8		MLFB11_1PH8		HMK_RUMPF_MLFB_05_11_1PH8	MLFB12_1PH8		O_M83_1PH8
    */
	var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
	var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
	var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;
    var HMK_RUMPF_MLFB_05_11_1PH8 = ECL_GetValue("HMK_RUMPF_MLFB_05_11_1PH8");
    
    var sTarget = "O_M83_1PH8";
    var sTable = "VT_1PH8_M00519" + sDB_Suffix;
    
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "HMK_RUMPF_MLFB_05_11_1PH8 = '" + HMK_RUMPF_MLFB_05_11_1PH8 + "' AND " +
                "O_M83_1PH8 = 'M83';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_K45(oData)
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    // O_K45_1PH8
    if (aKAG.indexOf("K45") >= 0){
        bCheck = Check_K45(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_K45_1PH8");
        ECL_SelectValue("CB_O_K45_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_K45_1PH8");
    }
}

function Check_K45(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00313
    MLFB05_1PH8		O_K45_1PH8

    VT_1PH8_M00356
    O_K45_1PH8		O_M03_M39_1PH8
    */
    
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_K45_1PH8";
    var sTable = "VT_1PH8_M00313" + sDB_Suffix;
    
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_K45_1PH8 = 'K45';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00356" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_K45_1PH8 = 'K45';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_Q12(oData)	// O_Q12_1PH8
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("Q12") >= 0){
        bCheck = Check_Q12(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_Q12_1PH8");
        ECL_SelectValue("CB_O_Q12_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_Q12_1PH8");
    }
}
function Check_Q12(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00327
    MLFB05_1PH8		O_Q12_1PH8
    
    VT_1PH8_M00342
    MLFB05_1PH8		O_A12_1PH8		O_M03_M39_1PH8		O_Q12_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var O_A12_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_A12_1PH8", "T")){
            O_A12_1PH8 = "A12";
        }
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_Q12_1PH8";
    
    var sTable = "VT_1PH8_M00327" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_Q12_1PH8 = 'Q12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00342" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_A12_1PH8 = '" + O_A12_1PH8 + "' AND " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_Q12_1PH8 = 'Q12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_Q21(oData)	// O_Q21_1PH8
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("Q21") >= 0){
        bCheck = Check_Q21(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_Q21_1PH8");
        ECL_SelectValue("CB_O_Q21_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_Q21_1PH8");
    }
}
function Check_Q21(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00428
    MLFB05_1PH8		O_Q21_1PH8

    VT_1PH8_M00496
    O_L02_1PH8	O_Q21_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var O_L02_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_L02_1PH8", "T")){
            O_L02_1PH8 = "L02";
        }
    
    var sTarget = "O_Q21_1PH8";
    
    var sTable = "VT_1PH8_M00428" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_Q21_1PH8 = 'Q21';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00496" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_L02_1PH8 = '" + O_L02_1PH8 + "' AND " +
                "O_Q21_1PH8 = 'Q21';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_L12(oData)
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("L12") >= 0){
        bCheck = Check_L12(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_L12_1PH8");
        ECL_SelectValue("CB_O_L12_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_L12_1PH8");
    }
}
function Check_L12(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00318
    MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		O_L12_1PH8

    VT_1PH8_M00367
    O_L12_1PH8		O_M03_M39_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_L12_1PH8";
    
    var sTable = "VT_1PH8_M00318" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "O_L12_1PH8 = 'L12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00367" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_L12_1PH8 = 'L12';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
// O_L03_1PH8
function Bestimme_L03(oData)
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("L03") >= 0){
        bCheck = Check_L03(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_L03_1PH8");
        ECL_SelectValue("CB_O_L03_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_L03_1PH8");
    }
}

function Check_L03(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00317
    MLFB05_1PH8		MLFB08_1PH8		MLFB09_1PH8		MLFB11_1PH8		MLFB12_1PH8		O_L03_1PH8
    
    VT_1PH8_M00361
    O_L03_1PH8		O_Q14_1PH8		O_M03_M39_1PH8
    
    VT_1PH8_M00366
    O_L03_1PH8		O_U60_BIS_U68_1PH8
    
    VT_1PH8_M00525
    O_L03_1PH8		O_L74_1PH8		O_L75_1PH8		O_L76_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;
    
    var O_Q14_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_Q14_1PH8", "T"))
            O_Q14_1PH8 = "Q14";
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    var O_L74_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_L74_1PH8", "T"))
            O_L74_1PH8 = "L74";
    var O_L75_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_L75_1PH8", "T"))
            O_L75_1PH8 = "L75";
    var O_L76_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_L76_1PH8", "T"))
            O_L76_1PH8 = "L76";
    
    var sTarget = "O_L03_1PH8";
    
    var sTable = "VT_1PH8_M00317" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "O_L03_1PH8 = 'L03';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00361" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_Q14_1PH8 = '" + O_Q14_1PH8 + "' AND " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_L03_1PH8 = 'L03';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00366" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
                "O_L03_1PH8 = 'L03';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00525" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_L74_1PH8 = '" + O_L74_1PH8 + "' AND " +
                "O_L75_1PH8 = '" + O_L75_1PH8 + "' AND " +
                "O_L76_1PH8 = '" + O_L76_1PH8 + "' AND " +
                "O_L03_1PH8 = 'L03';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_Y64(oData)	// O_Y64_1PH8
{
    var bCheck =    false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("Y64") >= 0){
        bCheck = Check_Y64(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_Y64_1PH8");
        ECL_SelectValue("CB_O_Y64_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_Y64_1PH8");
    }
}
function Check_Y64(oData)
{
   
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00334
    MLFB05_1PH8		MLFB13_1PH8		O_Y64_1PH8
    
    VT_1PH8_M00365
    O_Y64_1PH8	O_M03_M39_1PH8

    VT_1PH8_M00621
    MLFB05_1PH8 O_Y64_1PH8  O_V90_V91_V92_1PH8
    */
	var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
	var MLFB13_1PH8 = oData.oParsingData.MLFB.MLFB13;
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_Y64_1PH8";
    
    var sTable = "VT_1PH8_M00334" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
                "O_Y64_1PH8 = 'Y64';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00365" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_Y64_1PH8 = 'Y64';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");

    var sTable = "VT_1PH8_M00621" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "' AND " +
                "O_Y64_1PH8 = 'Y64';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
// O_K17_1002197
function Bestimme_K17(oData)
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("K17") >= 0){
        bCheck = Check_K17(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_K17_1002197");
        ECL_SelectValue("CB_O_K17_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_K17_1002197");
    }
}

function Check_K17(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00441
    MLFB05_1PH8		MLFB14_1PH8		O_K17_1002197
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    
    var sTarget = "O_K17_1002197";
    
    var sTable = "VT_1PH8_M00441" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "O_K17_1002197 = 'K17';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_Q81(oData)	// O_Q81_1002197
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("Q81") >= 0){
        bCheck = Check_Q81(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_Q81_1002197");
        ECL_SelectValue("CB_O_Q81_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_Q81_1002197");
    }
}

function Check_Q81(oData)
{
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00521
    MLFB05_1PH8		MLFB14_1PH8		O_Q81_1002197
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    
    var sTarget = "O_Q81_1002197";
    
    var sTable = "VT_1PH8_M00521" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "O_Q81_1002197 = 'Q81';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_L27(oData)	// O_L27_1PH8
{
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("L27") >= 0){
        bCheck = Check_L27(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_L27_1PH8");
        ECL_SelectValue("CB_O_L27_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_L27_1PH8");
    }
    
}

function Check_L27(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    /*
    VT_1PH8_M00439
    MLFB05_1PH8		O_L27_1PH8

    
    VT_1PH8_M00540
    O_L27_1PH8		O_M03_M39_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    
    var sTarget = "O_L27_1PH8";
    
    var sTable = "VT_1PH8_M00439" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "O_L27_1PH8 = 'L27';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00540" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
                "O_L27_1PH8 = 'L27';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
