//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenWellenende_Init(oData)
{
    /*
    O_V90_V91_V92_1PH8		Wellenende
    O_K16_1PH8				Zweites Wellenende
    O_K90_1PH8				Ausführung mit Flanschgröße A400
    O_L72_1002197			Welle aus Sonderstahl
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_Wellenende_KAG(oData);
        
        Bestimme_K16(oData);
        Bestimme_K90(oData);
        Bestimme_L72(oData);
        
    } else {
        ExecSetStandardifValueEmpty("O_V90_V91_V92_1PH8","NON");	// 
        ECL_DeselectAttribute("CB_O_K16_1PH8");	
        ECL_DeselectAttribute("CB_O_K90_1PH8","F");	//
        ECL_DeselectAttribute("CB_O_L72_1002197","F");	//
        
    }
}

function SetOptionenWellenende(strchangedAttribute, oData)
{
    
}

// #############################################################################################
function Bestimme_Wellenende_KAG(oData)
{
    /*
    VT_1PH8_M00591	V90-V92 RUMPF_050710_0811
    H_RUMPF_050710_0811_1PH8	O_V90_V91_V92_1PH8	HMK_VALUE_VALID_1PH8

    VT_1PH8_M00563
    MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_V90_V91_V92_1PH8	PMD_AAA069_001_000_1PH8

    VT_1PH8_M00368
    O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8

    */
    
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //O_V90_V91_V92_1PH8
    var sWellenendeKAG = "";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    
    if (aKAG.indexOf("V90") >= 0){
        sWellenendeKAG = "V90";
    }else if (aKAG.indexOf("V91") >= 0){
        sWellenendeKAG = "V91";
    }else if (aKAG.indexOf("V92") >= 0 ){
        sWellenendeKAG = "V92";
    }else{
        sWellenendeKAG = "NON";
    }
    var bCheck = false;
    
    if (sWellenendeKAG != "NON"){
        bCheck = Check_WellenendeKAG(oData, sWellenendeKAG);
    }
    if (bCheck){
        ECL_SelectValue("O_V90_V91_V92_1PH8", sWellenendeKAG);
    }else{
        ECL_SelectValue("O_V90_V91_V92_1PH8", "NON");
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
}

function Check_WellenendeKAG(oData, sWellenendeKAG)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00591	V90-V92 RUMPF_050710_0811
    H_RUMPF_050710_0811_1PH8	O_V90_V91_V92_1PH8	HMK_VALUE_VALID_1PH8

    VT_1PH8_M00563
    MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_V90_V91_V92_1PH8	PMD_AAA069_001_000_1PH8

    VT_1PH8_M00368
    O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8

    VT_1PH8_M00621
    MLFB05_1PH8 O_Y64_1PH8  O_V90_V91_V92_1PH8
    */
    var H_RUMPF_050710_0811_1PH8 = oData.oParsingData.H_RUMPF_050710_0811_1PH8;
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB13_1PH8 = oData.oParsingData.MLFB.MLFB13;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    
    var sTarget = "O_V90_V91_V92_1PH8";
    
    var sTable = "VT_1PH8_M00591" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T' AND " +
                "O_V90_V91_V92_1PH8 = '" + sWellenendeKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
    
    var sTable = "VT_1PH8_M00563" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
                "O_V90_V91_V92_1PH8 = '" + sWellenendeKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00368" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
                "O_V90_V91_V92_1PH8 = '" + sWellenendeKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}

// #############################################################################################
function Bestimme_K16(oData)
{
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // O_K16_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("K16") >= 0){
        bCheck = Check_K16(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_K16_1PH8");
        ECL_SelectValue("CB_O_K16_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_K16_1PH8");
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
}

function Check_K16(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00308
    MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_K16_1PH8

    VT_1PH8_M00348
    O_K16_1PH8	O_G80_H56_H75_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

    var O_G80_H56_H75_1PH8 = ECL_GetValue("O_G80_H56_H75_1PH8");
    
    var sTarget = "O_K16_1PH8";
    
    var sTable = "VT_1PH8_M00308" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "O_K16_1PH8 = 'K16';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00348" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_G80_H56_H75_1PH8 = '" + O_G80_H56_H75_1PH8 + "' AND " +
                "O_K16_1PH8 = 'K16';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
function Bestimme_K90(oData)
{
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // O_K90_1PH8
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("K90") >= 0){
        bCheck = Check_K90(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_K90_1PH8");
        ECL_SelectValue("CB_O_K90_1PH8", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_K90_1PH8");
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
}

function Check_K90(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00315
    MLFB05_1PH8	MLFB08_1PH8	MLFB12_1PH8	O_K90_1PH8

    VT_1PH8_M00364
    O_K90_1PH8	O_U60_BIS_U68_1PH8
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    
    var sTarget = "O_K90_1PH8";
    
    var sTable = "VT_1PH8_M00315" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "O_K90_1PH8 = 'K90';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    var sTable = "VT_1PH8_M00364" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
                "O_K90_1PH8 = 'K90';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################



function Bestimme_L72(oData)
{
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // O_L72_1002197
    var bCheck = false;
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (aKAG.indexOf("L72") >= 0){
        bCheck = Check_L72(oData);
    }
    if (bCheck){
        ECL_EnableAttribute("CB_O_L72_1002197");
        ECL_SelectValue("CB_O_L72_1002197", "T");
    }
    else{
        ECL_DeselectAttribute("CB_O_L72_1002197");
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
}

function Check_L72(oData)
{
    
    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    /*
    VT_1PH8_M00442
    MLFB05_1PH8	MLFB11_1PH8	O_L72_1002197
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
        
    var sTarget = "O_L72_1002197";
    
    var sTable = "VT_1PH8_M00442" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "O_L72_1002197 = 'L72';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // -----------------------------------------------------------------------------------------
    return 1;
}
// #############################################################################################
