//@legacy
//#mode(full-ecma)


//@import "../1PH8_MLFB/Base.misc.js"

//@import "VT_1PH8.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute, HMK_PRODUKT_TRIG_1PH8) {
  var strError = "";

  var HMK_KONFIG_TYP_1PH8 = ECL_GetValue("HMK_KONFIG_TYP_1PH8"); // "KONFIG"
  var HMK_PRODUKT_ALT_AKT_1PH8 = ECL_GetValue("HMK_PRODUKT_ALT_AKT_1PH8"); // "AKT"
  var HMK_PRODUKT_TRIG_1PH8 = ECL_GetValue("HMK_PRODUKT_TRIG_1PH8"); // Produkt	1PH8_S, _L, _LEA

  var sMLFB = ECL_GetValue("ECSI_MLFB");

  var MLFB01_1PH8 = sMLFB.left(4);
  var MLFB05_1PH8 = sMLFB.charAt(4) + sMLFB.charAt(5); //Achshöhe
  var MLFB07_1PH8 = sMLFB.charAt(6);
  var MLFB08_1PH8 = sMLFB.charAt(7);
  var MLFB09_1PH8 = sMLFB.charAt(8);
  var MLFB10_1PH8 = sMLFB.charAt(9);
  var MLFB11_1PH8 = sMLFB.charAt(10);
  var MLFB12_1PH8 = sMLFB.charAt(11);
  var MLFB13_1PH8 = sMLFB.charAt(12);
  var MLFB14_1PH8 = sMLFB.charAt(13);
  var MLFB15_1PH8 = sMLFB.charAt(14);
  var MLFB16_1PH8 = sMLFB.charAt(15);

  var HMK_MLFB09_GRUPPE_1PH8 = ECL_GetValue("HMK_MLFB09_GRUPPE_1PH8"); // definiert über VT_1PH8_M00336, Einschränkung für MLFB09 ??? nicht eindeutig
  var HMK_MLFB15_GRUPPE_1PH8 = ECL_GetValue("HMK_MLFB15_GRUPPE_1PH8"); // definiert über VT_1PH8_M00336, Einschränkung für MLFB15 ??? nicht eindeutig

  var MOTOR_RUMPF_1PH8 = ECL_GetValue("MOTOR_RUMPF_1PH8"); // fix
  var HMK_RUMPF_05_07_1PH8 = ECL_GetValue("HMK_RUMPF_05_07_1PH8"); // fix
  var HMK_RUMPF_05_07_10_1PH8 = ECL_GetValue("HMK_RUMPF_05_07_10_1PH8"); // fix

  //var HMK_RUMPF_05_08_11_1PH8 	= ECL_GetValue("HMK_RUMPF_05_08_11_1PH8");	// bei Änderung der Kühlart, aktualisieren! todo, falls Kühlart MLFB11 fix vorgegeben, kann dies entfallen
  //var HMK_RUMPF_MLFB_05_11_1PH8 	= ECL_GetValue("HMK_RUMPF_MLFB_05_11_1PH8");// bei Änderung der Kühlart, aktualisieren!
  var H_RUMPF_050710_0811_1PH8 = ECL_GetValue("H_RUMPF_050710_0811_1PH8"); // bei Änderung der Kühlart, aktualisieren!

  var HMK_AUSF_KUEHLUNG_1PH8 = ECL_GetValue("HMK_AUSF_KUEHLUNG_1PH8");
  // Achshöhe
  var PMD_ABP663_001_000_1002197 = ECL_GetValue("PMD_ABP663_001_000_1002197");

  var HMK_LAGERG_PERF_1PH8 = ECL_GetValue("HMK_LAGERG_PERF_1PH8");
  var HMK_LAGERG_HPERF_1PH8 = ECL_GetValue("HMK_LAGERG_HPERF_1PH8");

  var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
  if (ECSI_CX_IsDriveTrain == "true" || ECSI_CX_IsDriveTrain == "1") {
    var IsDriveTrain = true;
  }
  var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
  if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
    var IsGearBoxMotorCoupling = true;
  }

  // ################################################################################################################
  // Ausführung HMK_AUSFUEHRUNG_1002197 Sync oder Async (Vorgabe SIZER) / LEA Reluktanz
  // ################################################################################################################
  // Ausführung des Motors PMD_AAA271_001_000_1PH8	Sync/Async + mit/ohne Bremse	MLFB08_1PH8
  // ################################################################################################################
  // Ausführung des Motors
  // (Sync, Async, Reluktanz)
  var PMD_AAA271_001_000_1PH8 = ECL_GetValue("PMD_AAA271_001_000_1PH8"); // Ausführung des Motors

  // ################################################################################################################

  // ################################################################################################################
  // Produktbestandteil / Haltebremse	PMD_ABU276_001_000_1PH8		Abbildung über CB_HALTEBREMSE
  // ################################################################################################################
  /*
    Da von SIZER vorgegeben, verlagerung in Parser. Dort erfolgt die Prüfung, ob möglich. Alle anderen Objekte sind dann abhängig / nachrangig.
    
    CB_HALTEBREMSE_1PH8 Checkbox neu
    */

  // Bremse
  var PMD_ABU276_001_000_1PH8 = "F";
  if (ECL_ValueSelected("CB_HALTEBREMSE_1PH8", "T")) {
    PMD_ABU276_001_000_1PH8 = "T";
  }

  // ################################################################################################################

  // ################################################################################################################
  // Haltebremse (KAG)		O_U60_BIS_U68_1PH8
  // ################################################################################################################
  /*	
    KAG: NON, U60, U65, U61, U66, U62, U67, U63, U68
    Kombination aus HMK_AUSFUEHR_BREMSE_1PH8 und HMK_SPANNUNG_BREMSE_1PH8 ergibt KAG
    O_U60_BIS_U68_1PH8 enhält die Logik für das Auswahlattribut HMK_AUSFUEHR_BREMSE_1PH8, 
        daher muss über Einschränkung des KAG-Attributes HMK_AUSFUEHR_BREMSE_1PH8 eingeschränkt werden
    
    Da Bremse ja/nein vom SIZER vorgegeben wird, erfolgt die Prüfung im Parser gegen die übergebene MLFB. 
    Eine Einschränkung erfolgt anschließend nur in Richtung weitere Attribute und auf die Art der Bremse, wenn vorgegeben.
    
    A: VT_1PH8_M00340	U60-U68-AH-MLFB08-11
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_U60_BIS_U68_1PH8

    B: VT_1PH8_M00341	U60-U68-AH-MLFB12-13-14
        MLFB05_1PH8	MLFB12_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_U60_BIS_U68_1PH8

    C: VT_1PH8_M00343	M03-M39-U60-U68-K18
        O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8
    D: VT_1PH8_M00364	K90-U63
        O_K90_1PH8	O_U60_BIS_U68_1PH8
    E: VT_1PH8_M00366	L03-U63
        O_L03_1PH8	O_U60_BIS_U68_1PH8

    F: VT_1PH8_M00368	U63-V92
        O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8
    G: VT_1PH8_M00423	Haltebremse
        PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8
    */
  if (PMD_ABU276_001_000_1PH8 == "T") {
    //VT_1PH8_M00340	U60-U68-AH-MLFB08-11
    // 	MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_U60_BIS_U68_1PH8
    // A:
    var sTable = "VT_1PH8_M00340" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    // B:
    // VT_1PH8_M00341	U60-U68-AH-MLFB12-13-14
    //	MLFB05_1PH8	MLFB12_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_U60_BIS_U68_1PH8

    var sTable = "VT_1PH8_M00341" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "O_U60_BIS_U68_1PH8 <> 'NON' AND " +
      "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
      "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
      "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------

    var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
    var O_K18_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";

    // C:
    // VT_1PH8_M00343	M03-M39-U60-U68-K18
    //	O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8

    var sTable = "VT_1PH8_M00343" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " + "O_K18_1PH8 = '" + O_K18_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_K90_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_K90_1PH8", "T")) O_K90_1PH8 = "K90";
    // D:
    // VT_1PH8_M00364	K90-U63
    //	O_K90_1PH8	O_U60_BIS_U68_1PH8

    var sTable = "VT_1PH8_M00364" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "O_K90_1PH8 = '" + O_K90_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_L03_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
    // E:
    //	VT_1PH8_M00366	L03-U63
    //		O_L03_1PH8	O_U60_BIS_U68_1PH8

    var sTable = "VT_1PH8_M00366" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");
    // F: VT_1PH8_M00368	U63-V92
    //	O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8

    var sTable = "VT_1PH8_M00368" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere = "O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    // HMK_SPANNUNG_BREMSE anhang noch gültiger Unn einschränken
    var aValidBrakes = ECL_GetAllActiveAttributeValues("O_U60_BIS_U68_1PH8");
    var sWhereUnn = "O_U60_BIS_U68_1PH8 = '" + aValidBrakes[0] + "'";
    if (aValidBrakes.length > 1) {
      for (var i = 1; i < aValidBrakes.length; i++) {
        sWhereUnn += " OR O_U60_BIS_U68_1PH8 = '" + aValidBrakes[i] + "'";
      }
      sWhereUnn = "(" + sWhereUnn + ")";
    }

    var sTable = "VT_1PH8_M00423" + sDB_Suffix;
    var sTargetAttribute = "HMK_SPANNUNG_BREMSE_1PH8";
    var sWhere = "PMD_ABU276_001_000_1PH8 = 'T' AND " + sWhereUnn + " AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_AUSFUEHR_BREMSE_1PH8 = ECL_GetValue("HMK_AUSFUEHR_BREMSE_1PH8");
    var HMK_SPANNUNG_BREMSE_1PH8 = ECL_GetValue("HMK_SPANNUNG_BREMSE_1PH8");
    //G: VT_1PH8_M00423	Haltebremse
    //	PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8

    var sTable = "VT_1PH8_M00423" + sDB_Suffix;
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var sWhere =
      "PMD_ABU276_001_000_1PH8 = 'T' AND " +
      //"HMK_AUSFUEHR_BREMSE_1PH8 = '" + HMK_AUSFUEHR_BREMSE_1PH8 + "' AND " + // Darf nicht einschränken, da sonst keine Umwahl möglich!
      "HMK_SPANNUNG_BREMSE_1PH8 = '" + HMK_SPANNUNG_BREMSE_1PH8 + "' AND " +
      "HMK_VALUE_VALID_1PH8 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___BREMSE_KAG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }


    //--------------------------------------------------------------------------------------------------------------
    // Set n_max brake  HMK_N_MAX_BR_1PH8	Maximale Drehzahl Haltebremse
    // VT_1PH8_M00632	nMax Bremse
    //  MLFB08_1PH8 PMD_ABP663_001_000_1002197  HMK_N_MAX_BR_1PH8
    var HMK_N_MAX_BR_1PH8 = 0;

    var sTable = "VT_1PH8_M00632" + sDB_Suffix;
    var sSQL = "SELECT HMK_N_MAX_BR_1PH8 FROM " + sTable + " WHERE " +
      "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
      "PMD_ABP663_001_000_1002197 = " + PMD_ABP663_001_000_1002197 + " AND " +
      "HMK_N_MAX_BR_1PH8 > 0;";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult && aResult.length > 0) {
      HMK_N_MAX_BR_1PH8 = aResult[0].HMK_N_MAX_BR_1PH8;
    } else {
      strError = "DICT1_ERR_1PH8___BREMSE_N_MAX_NO_DB_RESULT";
      return strError;
    }

    ECL_DeactivateAllAttributeValues("HMK_N_MAX_BR_1PH8");
    ECL_ActivateValue("HMK_N_MAX_BR_1PH8", HMK_N_MAX_BR_1PH8);
    ECL_SelectValue("HMK_N_MAX_BR_1PH8", HMK_N_MAX_BR_1PH8);
    //--------------------------------------------------------------------------------------------------------------

  } else {
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";
    var aValidValues = ["NON"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH8___PL_KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
    // Set n_max brake  HMK_N_MAX_BR_1PH8	Maximale Drehzahl Haltebremse 
    var HMK_N_MAX_BR_1PH8 = 0;

    ECL_DeactivateAllAttributeValues("HMK_N_MAX_BR_1PH8");
    ECL_ActivateValue("HMK_N_MAX_BR_1PH8", HMK_N_MAX_BR_1PH8);
    ECL_SelectValue("HMK_N_MAX_BR_1PH8", HMK_N_MAX_BR_1PH8);
  }
  // ################################################################################################################

  // ################################################################################################################
  // Ausführung Bremse		HMK_AUSFUEHR_BREMSE_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00423	Haltebremse
        PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8
    
    Übertragung der Einschränkung aus KAG-Attribut O_U60_BIS_U68_1PH8
    */
  var test = ECL_GetAllActiveAttributeValues("O_U60_BIS_U68_1PH8");
  var sTargetAttribute = "HMK_AUSFUEHR_BREMSE_1PH8";
  var sRefAttribute = "O_U60_BIS_U68_1PH8";
  var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sRefAttribute, "VT_1PH8_M00423" + sDB_Suffix);

  if (sStatus == "Error") {
    // Fehler
    strError = ECL_Translate("DICT1_ERR_1PH8___LOGIC_TRANSFER_BRAKE");
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Versorgungsspannung Bremse		HMK_SPANNUNG_BREMSE_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00423	Haltebremse
        PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8
    ==> Keine Einschränkung für Spannung!
    */
  if (PMD_ABU276_001_000_1PH8 == "T") {
    ECL_ActivateAttribute("HMK_SPANNUNG_BREMSE_1PH8");
  } else {
    ECL_DeactivateAttribute("HMK_SPANNUNG_BREMSE_1PH8");
  }

  // ################################################################################################################

  // ################################################################################################################
  // Bestimmung KAG Bremse
  // ################################################################################################################
  /* VT_1PH8_M00423	Haltebremse
        PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8
    */
  var oAttributesMapping = { PMD_ABU276_001_000_1PH8: null };
  simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1PH8_M00423" + sDB_Suffix, {
    inferenceType: VariantTables.Inference.RestrictNone,
    mapping: oAttributesMapping,
    operators: {
      O_U60_BIS_U68_1PH8: {
        inferenceType: VariantTables.Inference.RestrictAll,
      },
    },
  });
  ExecSetStandardifValueEmpty("O_U60_BIS_U68_1PH8", "NON");
  // ################################################################################################################

  // ################################################################################################################
  // Art der Kühlung		PMD_AAA136_001_000_1PH8			aus MLFB11
  // ################################################################################################################
  /*  VORGABE AUS SIZER!!!
    A: VT_1PH8_M00246	Kühlung_MLFB11
        MLFB05_1PH8	MLFB11_1PH8	PMD_AAA136_001_000_1PH8	HMK_VALUE_VALID_1PH8

    nn	VT_1PH8_M00455	UI-VT Kuehlung
    nn	VT_1PH8_M00509	Techn.(1) Daten Wasserkühlung
    nn	VT_1PH8_M00512	Techn. Daten Fremdkühlung
    nn	VT_1PH8_M00513	Hilfstabelle Kühlung Datenblatt
    nn	VT_1PH8_M00514	Techn. Daten(2) Wasserkühlung
    */

  // zunächst die gültigen MLFB11 ermitteln
  // VT_1PH8_M00257
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB09_1PH8		HMK_VALUE_VALID_1PH8

  // Wenn Kühlart vorgegeben in BaseType, dann keine Auswahl:
  /*var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    if (sBaseTypeMLFB.charAt(10) == "."){
        ECL_ActivateAllAttributeValues("MLFB11_1PH8");
    }else{
        ECL_DeactivateAllAttributeValues("MLFB11_1PH8");
        ECL_ActivateValue("MLFB11_1PH8", MLFB11_1PH8);
        ECL_SetValue("MLFB11_1PH8", MLFB11_1PH8);
    }
    var sTargetAttribute = "MLFB11_1PH8";
    var sTable = "VT_1PH8_M00257" + sDB_Suffix;
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_KUEHLART_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    
    // -----------------------------------------------------------------------------------
    // VT_1PH8_M00258
    //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
    var sTable = "VT_1PH8_M00258" + sDB_Suffix;
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_KUEHLART_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // -----------------------------------------------------------------------------------
    // VT_1PH8_M00372 Rümpfe
    // MLFB05_1PH8	MLFB07_1PH8	MLFB10_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_05_07_1PH8	HMK_RUMPF_05_07_10_1PH8	H_RUMPF_050710_0811_1PH8	HMK_RUMPF_05_08_11_1PH8	HMK_VALUE_VALID_1PH8
    var sTable = "VT_1PH8_M00372" + sDB_Suffix;
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB07_1PH8 = '" + MLFB07_1PH8 + "' AND " +
                    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                    "MLFB10_1PH8 = '" + MLFB10_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_KUEHLART_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // -----------------------------------------------------------------------------------
    //Übersetzung MLFB11 Where-Klausel
    var aValidValuesMLFB11 = ECL_GetAllActiveAttributeValues("MLFB11_1PH8");
    var sWhereMLFB11 = "MLFB11_1PH8 = '" + aValidValuesMLFB11[0] + "'";
    
    if (aValidValuesMLFB11.length > 1){
        for (var i = 1; i < aValidValuesMLFB11.length; i++){
            sWhereMLFB11 = sWhereMLFB11 + " OR MLFB11_1PH8 = '" + aValidValuesMLFB11[i] + "'";
        }
    }
    sWhereMLFB11 = "(" + sWhereMLFB11 + ") AND ";	
    
    // -----------------------------------------------------------------------------------
    
    
    // A: VT_1PH8_M00246	Kühlung_MLFB11
    //	MLFB05_1PH8	MLFB11_1PH8	PMD_AAA136_001_000_1PH8	HMK_VALUE_VALID_1PH8
    var sTable = "VT_1PH8_M00246" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAA136_001_000_1PH8";
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    //"MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +		// wenn vorgabe aus SIZER, dann verwenden. todo
                    sWhereMLFB11 +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_KUEHLART_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    
    // MLFB11 setzen
    var PMD_AAA136_001_000_1PH8 = ECL_GetValue("PMD_AAA136_001_000_1PH8");
    switch(PMD_AAA136_001_000_1PH8){
        case "00001":
            MLFB11_1PH8 = "0";
        break;
        case "00002":
            MLFB11_1PH8 = "1";
        break;
        case "00003":
            MLFB11_1PH8 = "2";
        break;
        case "00004":
            MLFB11_1PH8 = "3";
        break;
        case "00005":
            MLFB11_1PH8 = "4";
        break;
    }
    var sMLFB_neu = replaceAt(sMLFB, 10, MLFB11_1PH8);
    if (sMLFB_neu !== sMLFB){
        sMLFB = sMLFB_neu;
        ECL_SetValue("ECSI_MLFB", sMLFB);
        // -----------------------------------------------------------------------------------------
        // ==> Rümpfe neu bestimmen
        fSetRuempfe();
    }
    // ################################################################################################################
    */

  // ################################################################################################################
  // Schutzart IP		PMD_ABJ176_001_000_1PH8     durch MLFB11 vorgegeben
  // ################################################################################################################
  /*
    A: VT_1PH8_M00215	Def. Schutzart
        MLFB05_1PH8	MLFB11_1PH8	PMD_ABU276_001_000_1PH8	PMD_ABJ176_001_000_1PH8	HMK_VALUE_VALID_1PH8
    nn	VT_1PH8_M00512	Techn. Daten Fremdkühlung
    */
  // A: VT_1PH8_M00215	Def. Schutzart
  //	MLFB05_1PH8	MLFB11_1PH8	PMD_ABU276_001_000_1PH8	PMD_ABJ176_001_000_1PH8	HMK_VALUE_VALID_1PH8

  /* var sTable = "VT_1PH8_M00215" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1PH8";
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_SCHUTZART_IP_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Ausführung des Lagers		PMD_AAA069_001_000_1PH8
  // ################################################################################################################
  /*
    Abhängigkeit von der Bremse über MLFB14_1PH8 Bremse 
    VT_1PH8_M00447	Bauform-MLFB12		ggf ander VT???
        MLFB05_1PH8	PMD_ABU276_001_000_1PH8	MLFB12_1PH8	MLFB14_1PH8	PMD_AAC949_001_000_1PH8	HMK_VALUE_VALID_1PH8
    */
  /*	var sTable = "VT_1PH8_M00447" + sDB_Suffix;
    var sSQL = "SELECT MLFB14_1PH8 FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                //"PMD_AAC949_001_000_1PH8 = '" + PMD_AAC949_001_000_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aValidValuesMLFB = GetDBDataSetEXT(sSQL);
    if (aValidValuesMLFB.length > 0){
        
        // Übersetzung MLFB14 in Lagerung (PMD_AAA069_001_000_1PH8)
        
        var sTarget = "PMD_AAA069_001_000_1PH8";
        var sTable = "VT_1PH8_M00036" + sDB_Suffix;
        
        ECL_DeactivateAllAttributeValues(sTarget);
        
        var sWhere = "MLFB14_1PH8 = '" + aValidValuesMLFB[0].MLFB14_1PH8 + "'";
        
        if (aValidValuesMLFB.length > 1){
            
            for (var i = 1; i < aValidValuesMLFB.length; i++){
                
                sWhere = sWhere + " OR MLFB14_1PH8 = '" + aValidValuesMLFB[i].MLFB14_1PH8 + "'";
            }
        }
        
        var sSQL = "SELECT DISTINCT " + sTarget + " FROM " + sTable + " WHERE (" + sWhere + ");";
        
        var aResult = GetDBDataSetEXT(sSQL);
        
        if (aResult.length > 0){
            for (var j = 0; j < aResult.length; j++){
                ECL_ActivateValue(sTarget, aResult[j][sTarget]);
            }
        }else{
            strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        
        if (aResult.length == 1){
            ECL_SelectValue(sTarget, aResult[0][sTarget]);
        }else{
            ExecSetStandardifValueEmpty(sTarget, "");
        }
    }else{
        strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
*/
  // Einschränkung MLFB14_1PH8
  /*
    VT_1PH8_M00252	AL BlockB: Rumpf<>MLFB12,MLFB14
        H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8
    
    VT_1PH8_M00253	AL BlockC: 14_13_09
        MLFB05_1PH8		MLFB14_1PH8		MLFB13_1PH8		MLFB09_1PH8		HMK_VALUE_VALID_1PH8
    
    Abhängigkeit von der Bremse über MLFB14_1PH8 Bremse 
    VT_1PH8_M00447	Bauform-MLFB12		ggf ander VT???
        MLFB05_1PH8	PMD_ABU276_001_000_1PH8	MLFB12_1PH8	MLFB14_1PH8	PMD_AAC949_001_000_1PH8	HMK_VALUE_VALID_1PH8
    */

  ECL_ActivateAllAttributeValues("MLFB14_1PH8");
  if (IsDriveTrain) {
    ECL_DeactivateValue("MLFB14_1PH8", "L");
    ECL_DeactivateValue("MLFB14_1PH8", "M");
  }
  var sTargetAttribute = "MLFB14_1PH8";

  var sTable = "VT_1PH8_M00447" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    //"PMD_AAC949_001_000_1PH8 = '" + PMD_AAC949_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  /*
    VT_1PH8_M00252	AL BlockB: Rumpf<>MLFB12,MLFB14
        H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8
    */
  var sTable = "VT_1PH8_M00252" + sDB_Suffix;
  var sWhere = "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8		MLFB14_1PH8		MLFB13_1PH8		MLFB09_1PH8		HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00253" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
    //"MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  //	VT_1PH8_M00323
  //		MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00323" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    //"MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------

  // MLFB14 Where-Klausel
  var aValidValuesMLFB14 = ECL_GetAllActiveAttributeValues("MLFB14_1PH8");
  var sWhereMLFB14 = "MLFB14_1PH8 = '" + aValidValuesMLFB14[0] + "'";

  if (aValidValuesMLFB14.length > 1) {
    for (var i = 1; i < aValidValuesMLFB14.length; i++) {
      sWhereMLFB14 = sWhereMLFB14 + " OR MLFB14_1PH8 = '" + aValidValuesMLFB14[i] + "'";
    }
  }
  sWhereMLFB14 = "(" + sWhereMLFB14 + ") AND ";

  // -----------------------------------------------------------------------------------

  // Performance/HighPerformance Möglichkeit klären
  // VT_1PH8_M00235	maxDrehz <> Lagerung
  //	HMK_RUMPF_05_07_10_1PH8	HMK_AUSF_KUEHLUNG_1PH8	HMK_LAGERG_PERF_1PH8	HMK_LAGERG_HPERF_1PH8	HMK_VALUE_VALID_1PH8
  var HMK_LAGERG_PERF_1PH8 = "F";
  var HMK_LAGERG_HPERF_1PH8 = "F";

  var HMK_AUSF_KUEHLUNG_1PH8 = ECL_GetValue("HMK_AUSF_KUEHLUNG_1PH8");
  var bPerf = false;
  var bHPerf = false;

  var sTable = "VT_1PH8_M00235" + sDB_Suffix;
  var sSQL = "SELECT HMK_LAGERG_PERF_1PH8, HMK_LAGERG_HPERF_1PH8 FROM " + sTable + " WHERE " +
    "HMK_RUMPF_05_07_10_1PH8 = '" + HMK_RUMPF_05_07_10_1PH8 + "' AND " +
    "HMK_AUSF_KUEHLUNG_1PH8 = '" + HMK_AUSF_KUEHLUNG_1PH8 + "' AND " +
    "HMK_LAGERG_PERF_1PH8 = 'T' AND " +
    "HMK_LAGERG_HPERF_1PH8 = 'T' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    bPerf = true;
    bHPerf = true;
  } else {
    var sSQL = "SELECT HMK_LAGERG_PERF_1PH8, HMK_LAGERG_HPERF_1PH8 FROM " + sTable + " WHERE " +
      "HMK_RUMPF_05_07_10_1PH8 = '" + HMK_RUMPF_05_07_10_1PH8 + "' AND " +
      "HMK_AUSF_KUEHLUNG_1PH8 = '" + HMK_AUSF_KUEHLUNG_1PH8 + "' AND " +
      "HMK_LAGERG_PERF_1PH8 = 'T' AND " +
      "HMK_LAGERG_HPERF_1PH8 = 'F' AND " +
      "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      bPerf = true;
      bHPerf = false;
    }
  }
  // bei O_M03_M39_1PH8 != "NON" beide nicht erlaubt!
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  if (O_M03_M39_1PH8 != "NON") {
    bPerf = false;
    bHPerf = false;
  }

  if (bPerf) {
    HMK_LAGERG_PERF_1PH8 = "T";
    var sWhereLagerPerf = "(HMK_LAGERG_PERF_1PH8 = 'F' OR HMK_LAGERG_PERF_1PH8 = 'T') AND ";
  } else {
    HMK_LAGERG_PERF_1PH8 = "F";
    var sWhereLagerPerf = "HMK_LAGERG_PERF_1PH8 = 'F' AND ";
  }
  if (bHPerf) {
    HMK_LAGERG_HPERF_1PH8 = "T";
    var sWhereLagerHPerf = "(HMK_LAGERG_HPERF_1PH8 = 'F' OR HMK_LAGERG_HPERF_1PH8 = 'T') AND ";
  } else {
    HMK_LAGERG_HPERF_1PH8 = "F";
    var sWhereLagerHPerf = "HMK_LAGERG_HPERF_1PH8 = 'F' AND ";
  }
  ECL_SetValue("HMK_LAGERG_PERF_1PH8", HMK_LAGERG_PERF_1PH8);
  ECL_SetValue("HMK_LAGERG_HPERF_1PH8", HMK_LAGERG_HPERF_1PH8);
  /*
    A: VT_1PH8_M00036	Antriebsart_MLFB14
            MLFB05_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8	HMK_VALUE_VALID_1PH8

    B: VT_1PH8_M00236	Lagerung ... möglich
        PMD_AAA069_001_000_1PH8	HMK_LAGERG_PERF_1PH8	HMK_LAGERG_HPERF_1PH8	HMK_VALUE_VALID_1PH8

    nn VT_1PH8_M00432	UI-VT-Lagerung
        PMD_AAA069_001_000_1PH8	UI_VT_LAGERUNG_1PH8
        // prüfen, ob nötig, Übersetzung in UI-Merkmal mit 
        VT 531:
            UI_VT_MOTOR_1PH8	UI_VT_LAGERUNG_1PH8		UI_VT_DREHZAHL_MAX_1002197
    D: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
        MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
    */
  //var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8");	// Schwinggrößenstufe
  //var TAK_AAJ730_001_000_1PH8 = ECL_GetValue("TAK_AAJ730_001_000_1PH8");	// Wellen- und Flanschgenauigkeit
  // Achshöhe
  // A:
  var sTable = "VT_1PH8_M00036" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAA069_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sWhereMLFB14 +
    //"PMD_AAB007_001_000_1PH8 = '" + PMD_AAB007_001_000_1PH8 + "' AND " +
    //"TAK_AAJ730_001_000_1PH8 = '" + TAK_AAJ730_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  //--------------------------------------------------------------------------------------------------------------
  // Performance oder HighPerformance?
  // B:
  // VT_1PH8_M00236	Lagerung ... möglich
  //	PMD_AAA069_001_000_1PH8	HMK_LAGERG_PERF_1PH8	HMK_LAGERG_HPERF_1PH8	HMK_VALUE_VALID_1PH8

  var sTable = "VT_1PH8_M00236" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAA069_001_000_1PH8";
  var sWhere = sWhereLagerPerf + sWhereLagerHPerf + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  //--------------------------------------------------------------------------------------------------------------
  // Wellenende
  // D: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
  //	MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
  var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");

  var sTable = "VT_1PH8_M00563" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAA069_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
    //"MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    sWhereMLFB14 +
    "O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  // Wellen- und Flanschgenauigkeit
  //var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8");	// Schwinggrößenstufe
  var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");

  var sTable = "VT_1PH8_M00036" + sDB_Suffix;
  var sTargetAttribute = "TAK_AAJ730_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sWhereMLFB14 +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
    //"PMD_AAB007_001_000_1PH8 = '" + PMD_AAB007_001_000_1PH8 + "' AND " + // offen lassen, um Zuschnüren zu vermeiden
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_WELLEN_FLANSCH_GENAU_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  //var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
  var TAK_AAJ730_001_000_1PH8 = ECL_GetValue("TAK_AAJ730_001_000_1PH8");
  // Schwinggrößenstufe
  var sTable = "VT_1PH8_M00036" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAB007_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sWhereMLFB14 +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
    "TAK_AAJ730_001_000_1PH8 = '" + TAK_AAJ730_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_SCHWINGGROESSE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################
  /* MLFB14_1PH8 bestimmen
        var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8");	// Schwinggrößenstufe
        var TAK_AAJ730_001_000_1PH8 = ECL_GetValue("TAK_AAJ730_001_000_1PH8");	// Wellen- und Flanschgenauigkeit
    A: VT_1PH8_M00036	Antriebsart_MLFB14
            MLFB05_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8	HMK_VALUE_VALID_1PH8
    */
  //var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
  //var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8");	// Schwinggrößenstufe
  var TAK_AAJ730_001_000_1PH8 = ECL_GetValue("TAK_AAJ730_001_000_1PH8"); // Wellen- und Flanschgenauigkeit
  var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8"); // Schwinggrößenstufe

  var sTable = "VT_1PH8_M00036" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
    "PMD_AAB007_001_000_1PH8 = '" + PMD_AAB007_001_000_1PH8 + "' AND " +
    "TAK_AAJ730_001_000_1PH8 = '" + TAK_AAJ730_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB14_1PH8 = aResult[0].MLFB14_1PH8;

    var sMLFB_neu = replaceAt(sMLFB, 13, MLFB14_1PH8);
    if (sMLFB_neu !== sMLFB) {
      sMLFB = sMLFB_neu;
      ECL_SetValue("ECSI_MLFB", sMLFB);
    }
  } else {
    // Error
    strError = "DICT1_ERR_1PH8___PL_SET_MLFB14";
    return strError;
  }

  //--------------------------------------------------------------------------------------------------------------
  // Set n_max Lagerung  HMK_N_MAX_B_1PH8	Maximale Drehzahl Lagerung aus UI-VT HMK_DZ_MAX_KL_1PH8
  // VT_1PH8_M00618	UI-VT --> nMax Lagerung
  //  MOTOR_RUMPF_1PH8 UI_VT_LAGERUNG_1PH8  HMK_DZ_MAX_KL_1PH8(HMK_N_MAX_B_1PH8)
  /* mit UI_VT_LAGERUNG_1PH8 aus VT_1PH8_M00432
    VT_1PH8_M00432	UI-VT-Lagerung
      PMD_AAA069_001_000_1PH8   UI_VT_LAGERUNG_1PH8
  */
  var sTable = "VT_1PH8_M00432" + sDB_Suffix;
  var sSQL = "SELECT UI_VT_LAGERUNG_1PH8 FROM " + sTable + " WHERE " +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "';";

  var aResult = GetDBDataSetEXT(sSQL);

  if (aResult && aResult.length > 0) {
    var UI_VT_LAGERUNG_1PH8 = aResult[0].UI_VT_LAGERUNG_1PH8;
  } else {
    strError = "DICT1_ERR_1PH8___LAGER_N_MAX_NO_DB_RESULT";
    return strError;
  }

  var HMK_N_MAX_B_1PH8 = 0;

  var sTable = "VT_1PH8_M00618" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT HMK_DZ_MAX_KL_1PH8 AS HMK_N_MAX_B_1PH8 FROM " + sTable + " WHERE " +
    "MOTOR_RUMPF_1PH8 = '" + MOTOR_RUMPF_1PH8 + "' AND " +
    "UI_VT_LAGERUNG_1PH8 = '" + UI_VT_LAGERUNG_1PH8 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult && aResult.length > 0) {
    HMK_N_MAX_B_1PH8 = aResult[0].HMK_N_MAX_B_1PH8;
  } else {
    strError = "DICT1_ERR_1PH8___LAGER_N_MAX_NO_DB_RESULT";
    return strError;
  }

  ECL_DeactivateAllAttributeValues("HMK_N_MAX_B_1PH8");
  ECL_ActivateValue("HMK_N_MAX_B_1PH8", HMK_N_MAX_B_1PH8);
  ECL_SelectValue("HMK_N_MAX_B_1PH8", HMK_N_MAX_B_1PH8);
  //--------------------------------------------------------------------------------------------------------------

  // ################################################################################################################

  // ################################################################################################################
  // Ausführung der Temperaturüberwachung		PMD_AAA717_001_000_1PH8
  // ################################################################################################################
  // fix
  // ################################################################################################################

  // MLFB-Gruppen (09/15) einschränken, um Geberliste einzuschränken aus H_RUMPF_050710_0811_1PH8

  // ----------------------------------------------------------------------------------------------------------------------
  // Einschränkung HMK_MLFB09_GRUPPE_1PH8
  /*  
    VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
    */
  var sTargetAttribute = "HMK_MLFB09_GRUPPE_1PH8";

  var H_RUMPF_050710_0811_1PH8 = ECL_GetValue("H_RUMPF_050710_0811_1PH8");

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sWhere = "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_MLFB09_GRUPPE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------

  var sTargetAttribute = "HMK_MLFB15_GRUPPE_1PH8";

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sWhere = "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_MLFB15_GRUPPE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------

  // ################################################################################################################
  // Gebersystem		MLFB09_1PH8		PMD_ABU278_001_000_1PH8		1:1 übersetzt		Ausführung des Sensors / integriert
  // Änderung führt zu MLFB-Änderung, keine KAG
  // ################################################################################################################
  /*
    Wenn Vorauswahl mit DriveCLiQ, müsssen die Geber darauf gefiltert werden.
    
    // ----------------------------------------------------------------------------------------------------------------
    3 Merkmale:
    1. MLFB09_1PH8 bzw.	PMD_ABU278_001_000_1PH8							Ausführung des Sensors / integriert
    2. CB_DRIVE_CLIQ_1PH8 ==> TAK_ABU215_001_000_1PH8 ==> MLFB16_1PH8	Produktbestandteil / Drive-CLiQ-Schnittstelle	MLFB16=1 mit DQ, 2=ohne DQ	
    3. O_G80_H56_H75_1PH8												Anbau-Gebersystem
    // ----------------------------------------------------------------------------------------------------------------
    0: VT_1PH8_M00624	Geber-MLFB09-KonfigTyp
        MLFB09_1PH8 PMD_ABU278_001_000_1PH8 HMK_KONFIG_TYP_1PH8 HMK_VALUE_VALID_1PH8
    
    A: VT_1PH8_M00253	AL BlockC: 14_13_09	
        MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
    
    B: VT_1PH8_M00254	AL BlockC: 05_08_09
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
    
    C: VT_1PH8_M00256	AL BlockD: 05_09_15
        MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	HMK_VALUE_VALID_1PH8

    D: VT_1PH8_M00257	AL BlockD: 05_11_09
        MLFB05_1PH8	MLFB11_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8

    E: VT_1PH8_M00306	G80_H56_H75-AH-MLFB09-MLFB11
        MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	O_G80_H56_H75_1PH8

    F: VT_1PH8_M00307	K08-AH-MLFB09-MLFB15
        MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	O_K08_1PH8

    G: VT_1PH8_M00308	K16-AH-MLFB09-11-12
        MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_K16_1PH8

    H: VT_1PH8_M00317	L03-AH-MLFB08-09-11-12
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_L03_1PH8

    I: VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8

    J: VT_1PH8_M00337	MLFB09 Gruppe Zuordnungstabelle
        MLFB09_1PH8	HMK_MLFB09_GRUPPE_1PH8

    K: nur zur Bestimmung, ob gewählter Geber mit/ohne DriveCLiQ, bzw. zur Einschränkung der Geber bei vorauswahl mit/ohne DriveCLiQ
    VT_1PH8_M00425	ZO Temperatursensor-MLFB09-MLFB16
        HMK_KONFIG_TYP_1PH8	MLFB09_1PH8	PMD_AAA717_001_000_1PH8	TAK_ABU215_001_000_1PH8	MLFB16_1PH8	HMK_PRODUKT_ALT_AKT_1PH8	HMK_VALUE_VALID_1PH8
    */

  // HMK_KONFIG_TYP_1PH8 = "KONFIG"	im DM angelegt
  // HMK_PRODUKT_ALT_AKT_1PH8 = "AKT" im DM angelegt

  // ----------------------------------------------------------------------------------------------------------------
  /* TAK_ABU215_001_000_1PH8
    VT_1PH8_M00425	ZO Temperatursensor-MLFB09-MLFB16
        HMK_KONFIG_TYP_1PH8	MLFB09_1PH8	PMD_AAA717_001_000_1PH8	TAK_ABU215_001_000_1PH8	MLFB16_1PH8	HMK_PRODUKT_ALT_AKT_1PH8	HMK_VALUE_VALID_1PH8
    */
  // ----------------------------------------------------------------------------------------------------------------
  /* O_G80_H56_H75_1PH8
    VT_1PH8_M00306	G80_H56_H75-AH-MLFB09-MLFB11
        MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	O_G80_H56_H75_1PH8
    VT_1PH8_M00348	K16-G80-H75
        O_K16_1PH8	O_G80_H56_H75_1PH8
    */
  // ----------------------------------------------------------------------------------------------------------------

  // Wenn DriveCLiQ umgewählt wird, nach möglichkeit einen vergleichbaren Geber selektieren
  if (strchangedAttribute == "CB_DRIVE_CLIQ_1PH8") {
    var sGeber_ALT = ECL_GetValue("PMD_ABU278_001_000_1PH8");
    // Wenn sGeber_ALT !== "A", einen Geber auswählen
  }

  /*
    wenn Absolutwertgeber, wähle auch einen Absolutwertgeber
    E,F:	E ohne, F mit DriveCLiQ
    
    wenn inkremental, dann:
    ohne DriveCLiQ
    H	Inkrementalgeber HTL 1024 S/R (Encoder HTL 1024S/R)
    J	Inkrementalgeber HTL 2048 S/R (Encoder HTL 2048S/R)
    M	Inkrementalgeber sin/cos 1 Vpp 2048 S/R mit C- und D-Spur (Encoder IC2048S/R)
    T	Inkrementalgeber sin/cos 1 Vpp 512 S/R ohne C- und D-Spur (Encoder N512S/R)
    C	Inkrementalgeber sin/cos 1 Vpp 256 S/R ohne C- und D-Spur (Encoder IN256S/R)
    G	Inkrementalgeber HTL1024 S/R mit Hohlwelle HOG 22
    K	Inkrementalgeber HTL1024 S/R mit Vollwelle POG 10
    obsolet W	Inkrementalgeber HTL 1024 S/R (Encoder HTL1024S/R) mit Anschluss über zusätzlichen Klemmenkasten
    obsolet Y	Inkrementalgeber HTL 2048 S/R (Encoder HTL2048S/R) mit Anschluss über zusätzlichen Klemmenkasten
    
    mit DriveCLiQ
    D	Inkrementalgeber 22 bit mit Kommutierungslage (Encoder IC22DQ)
    U	Inkrementalgeber 20 bit ohne Kommutierungslage (Encoder IN20DQ)
    S	Inkrementalgeber 19 bit ohne Kommutierungslage (Encoder IN19DQ)
    */

  // Abhängigkeiten von Kontext
  var ECSI_CX_EncoderTypeRough = ECL_GetValue("ECSI_CX_EncoderTypeRough");
  //ECL_ActivateAllAttributeValues("PMD_ABU278_001_000_1PH8");
  if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {
    // nur Absolutwertgeber
    var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
    var aValidValuesGeber = [/*"A",*/ "E", "F"];

    var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValuesGeber);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH8___PL_KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  } else if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 0) {
    // nur Inkrementalgeber
    var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
    var aValidValuesGeber = [/*"A",*/ "H", "J", "M", "T", "C", "D", "U", "S", "G", "K"]; // W, Y obsolet

    var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValuesGeber);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH8___PL_KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  } else {
    ECL_ActivateAllAttributeValues("PMD_ABU278_001_000_1PH8");
  }
  // ----------------------------------------------------------------------------------------------------------------
  // 0: VT_1PH8_M00624	Geber-MLFB09-KonfigTyp
  //	MLFB09_1PH8 PMD_ABU278_001_000_1PH8 HMK_KONFIG_TYP_1PH8 HMK_VALUE_VALID_1PH8

  var sTable = "VT_1PH8_M00624" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "HMK_KONFIG_TYP_1PH8 = 'KONFIG' AND HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // A: VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8

  var sTable = "VT_1PH8_M00253" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // B: VT_1PH8_M00254	AL BlockC: 05_08_09
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00254" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // C: VT_1PH8_M00256	AL BlockD: 05_09_15
  //	MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	HMK_VALUE_VALID_1PH8

  var sTable = "VT_1PH8_M00256" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // D: VT_1PH8_M00257	AL BlockD: 05_11_09
  //	MLFB05_1PH8	MLFB11_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8

  var sTable = "VT_1PH8_M00257" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // E: VT_1PH8_M00306	G80_H56_H75-AH-MLFB09-MLFB11
  //	MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	O_G80_H56_H75_1PH8
  // nur für Achshöhe 280 relevant
  //if (MLFB05_1PH8 == "28"){
  var O_G80_H56_H75_1PH8 = ECL_GetValue("O_G80_H56_H75_1PH8");

  var sTable = "VT_1PH8_M00306" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere =
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "O_G80_H56_H75_1PH8 = '" + O_G80_H56_H75_1PH8 + "';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  //}
  // ----------------------------------------------------------------------------------------------------------------
  // F: VT_1PH8_M00307	K08-AH-MLFB09-MLFB15
  //	MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	O_K08_1PH8

  // nur für AH 180, 225, 280 möglich
  //if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_L"){
  var O_K08_1PH8 = ECL_GetValue("O_K08_1PH8");

  var sTable = "VT_1PH8_M00307" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " + "O_K08_1PH8 = '" + O_K08_1PH8 + "';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  //}
  // ----------------------------------------------------------------------------------------------------------------
  // G: VT_1PH8_M00308	K16-AH-MLFB09-11-12
  //	MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_K16_1PH8
  var O_K16_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K16_1PH8", "T")) O_K16_1PH8 = "K16";

  var sTable = "VT_1PH8_M00308" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "O_K16_1PH8 = '" + O_K16_1PH8 + "';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  //H: VT_1PH8_M00317	L03-AH-MLFB08-09-11-12
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_L03_1PH8
  // nur für AH 180, 225 möglich
  //if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_L"){
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";

  var sTable = "VT_1PH8_M00317" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "O_L03_1PH8 = '" + O_L03_1PH8 + "';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  //}
  // ----------------------------------------------------------------------------------------------------------------
  // I: VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00323" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ----------------------------------------------------------------------------------------------------------------------
  // J: VT_1PH8_M00337	MLFB09 Gruppe Zuordnungstabelle
  //	MLFB09_1PH8	HMK_MLFB09_GRUPPE_1PH8
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch

  // Where-Klausel für MLFB09-Gruppe
  var aValidValuesMLFB09_Gruppe = ECL_GetAllActiveAttributeValues("HMK_MLFB09_GRUPPE_1PH8");
  var sWhereMLFB09_Gruppe = "HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[0] + "'";

  if (aValidValuesMLFB09_Gruppe.length > 1) {
    for (var i = 1; i < aValidValuesMLFB09_Gruppe.length; i++) {
      sWhereMLFB09_Gruppe = sWhereMLFB09_Gruppe + " OR HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[i] + "'";
    }
  }
  sWhereMLFB09_Gruppe = "(" + sWhereMLFB09_Gruppe + ");";

  var sTable = "VT_1PH8_M00337" + sDB_Suffix;
  var sWhere = sWhereMLFB09_Gruppe;

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // K: VT_1PH8_M00425	ZO Temperatursensor-MLFB09-MLFB16
  //	HMK_KONFIG_TYP_1PH8		MLFB09_1PH8		PMD_AAA717_001_000_1PH8		TAK_ABU215_001_000_1PH8		MLFB16_1PH8
  //		HMK_PRODUKT_ALT_AKT_1PH8	HMK_VALUE_VALID_1PH8

  // bis hier ist noch nicht über DriveCLiQ eingeschränkt. Liste gültiger Geber zur evtl. Einschränkung von mit/ohne DriveCLiQ nutzen
  var aValidValuesGeberDQ = ECL_GetAllActiveAttributeValues("PMD_ABU278_001_000_1PH8");

  var PMD_AAA717_001_000_1PH8 = ECL_GetValue("PMD_AAA717_001_000_1PH8");

  // mit/ohne DriveCLiQ
  var TAK_ABU215_001_000_1PH8 = "F";
  if (ECL_ValueSelected("CB_DRIVE_CLIQ_1PH8", "T")) {
    var TAK_ABU215_001_000_1PH8 = "T";
  }

  var sTable = "VT_1PH8_M00425" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
  var sTargetAliasDB = "MLFB09_1PH8"; // mit Alias, da MLFB9 und Geber-Attribut identisch
  var sWhere = "HMK_KONFIG_TYP_1PH8 = '" + HMK_KONFIG_TYP_1PH8 + "' AND " +
    "PMD_AAA717_001_000_1PH8 = '" + PMD_AAA717_001_000_1PH8 + "' AND " +
    "TAK_ABU215_001_000_1PH8 = '" + TAK_ABU215_001_000_1PH8 + "' AND " +
    //"MLFB16_1PH8 = '" + MLFB16_1PH8 + "' AND " +							// doppelt, da über TAK_ABU215_001_000_1PH8 bewertet
    "HMK_PRODUKT_ALT_AKT_1PH8 = '" + HMK_PRODUKT_ALT_AKT_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2ndAlias(sTable, sTargetAttribute, sTargetAliasDB, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB-Stellen aktualisieren 09 -Geber, 16 -DriveCLiQ

  var PMD_ABU278_001_000_1PH8 = ECL_GetValue("PMD_ABU278_001_000_1PH8");

  sMLFB = replaceAt(sMLFB, 8, PMD_ABU278_001_000_1PH8);

  if (ECL_ValueSelected("CB_DRIVE_CLIQ_1PH8", "T")) {
    sMLFB = replaceAt(sMLFB, 15, "1");
  } else {
    sMLFB = replaceAt(sMLFB, 15, "2");
  }
  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ----------------------------------------------------------------------------------------------------------------
  // Bestimmung MLFB09 Gruppe
  // J: VT_1PH8_M00337	MLFB09 Gruppe Zuordnungstabelle
  //	MLFB09_1PH8	HMK_MLFB09_GRUPPE_1PH8
  var sTargetAttribute = "HMK_MLFB09_GRUPPE_1PH8";

  var sTable = "VT_1PH8_M00337" + sDB_Suffix;
  var sWhere = "MLFB09_1PH8 = '" + MLFB09_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_HMK_MLFB09_GRUPPE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // todo new sWhereMLFB09_Gruppe for further queries
  var aValidValuesMLFB09_Gruppe = ECL_GetAllActiveAttributeValues("HMK_MLFB09_GRUPPE_1PH8");
  sWhereMLFB09_Gruppe = "HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[0] + "'";

  if (aValidValuesMLFB09_Gruppe.length > 1) {
    for (var i = 1; i < aValidValuesMLFB09_Gruppe.length; i++) {
      sWhereMLFB09_Gruppe = sWhereMLFB09_Gruppe + " OR HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[i] + "'";
    }
  }
  sWhereMLFB09_Gruppe = "(" + sWhereMLFB09_Gruppe + ");";

  // ################################################################################################################
  // DriveCLiQ einschränken
  // ################################################################################################################
  // K: VT_1PH8_M00425	ZO Temperatursensor-MLFB09-MLFB16
  //	HMK_KONFIG_TYP_1PH8		MLFB09_1PH8		PMD_AAA717_001_000_1PH8		TAK_ABU215_001_000_1PH8		MLFB16_1PH8
  //		HMK_PRODUKT_ALT_AKT_1PH8	HMK_VALUE_VALID_1PH8

  // mit/ohne DriveCLiQ
  var TAK_ABU215_001_000_1PH8 = "F";
  if (ECL_ValueSelected("CB_DRIVE_CLIQ_1PH8", "T")) {
    var TAK_ABU215_001_000_1PH8 = "T";
  }

  var sDTKAttribute = "TAK_ABU215_001_000_1PH8";
  var sCB_Attribute = "CB_DRIVE_CLIQ_1PH8";

  // Where-Klausel für gültige Geber
  // mit aValidValuesGeberDQ
  var sWhereGeber = "MLFB09_1PH8 = '" + aValidValuesGeberDQ[0] + "'";

  if (aValidValuesGeberDQ.length > 1) {
    for (var i = 1; i < aValidValuesGeberDQ.length; i++) {
      sWhereGeber = sWhereGeber + " OR MLFB09_1PH8 = '" + aValidValuesGeberDQ[i] + "'";
    }
  }
  sWhereGeber = "(" + sWhereGeber + ");";

  var sTable = "VT_1PH8_M00425" + sDB_Suffix;
  var sWhere = "HMK_KONFIG_TYP_1PH8 = '" + HMK_KONFIG_TYP_1PH8 + "' AND " +
    "PMD_AAA717_001_000_1PH8 = '" + PMD_AAA717_001_000_1PH8 + "' AND " +
    sWhereGeber +
    "HMK_PRODUKT_ALT_AKT_1PH8 = '" + HMK_PRODUKT_ALT_AKT_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T", "F", sWhere, false);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_GEBERDRIVE_CLIQ_LOGIKFEHLER_NO_DB_RESULT";
  }

  //--------------------------------------------------------------------------------------------------------------
  // Set n_max encoder  HMK_N_MAX_G_1PH8	Maximale Drehzahl Geber
  // VT_1PH8_M00630	nMax Geber
  //  MLFB09_1PH8 PMD_ABP663_001_000_1002197  HMK_N_MAX_G_1PH8
  var HMK_N_MAX_G_1PH8 = 0;
  if (MLFB09_1PH8 !== "A") {
    var sTable = "VT_1PH8_M00630" + sDB_Suffix;
    var sSQL = "SELECT HMK_N_MAX_G_1PH8 FROM " + sTable + " WHERE " +
      "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
      "PMD_ABP663_001_000_1002197 = " + PMD_ABP663_001_000_1002197 + " AND " +
      "HMK_N_MAX_G_1PH8 > 0;";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult && aResult.length > 0) {
      HMK_N_MAX_G_1PH8 = aResult[0].HMK_N_MAX_G_1PH8;
    } else {
      strError = "DICT1_ERR_1PH8___GEBER_N_MAX_NO_DB_RESULT";
      return strError;
    }
  }
  ECL_DeactivateAllAttributeValues("HMK_N_MAX_G_1PH8");
  ECL_ActivateValue("HMK_N_MAX_G_1PH8", HMK_N_MAX_G_1PH8);
  ECL_SelectValue("HMK_N_MAX_G_1PH8", HMK_N_MAX_G_1PH8);

  //--------------------------------------------------------------------------------------------------------------
  // ################################################################################################################

  // ################################################################################################################
  /* O_G80_H56_H75_1PH8	Anbau Gebersystem
    // ################################################################################################################
    VT_1PH8_M00306	G80_H56_H75-AH-MLFB09-MLFB11
        MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	O_G80_H56_H75_1PH8
    VT_1PH8_M00348	K16-G80-H75
        O_K16_1PH8	O_G80_H56_H75_1PH8
    
    NUR für AH 280, also nur Produkt 1PH8_L
    nur für Geber K und G
    MLFB11 1 oder 4
    
    */
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "O_G80_H56_H75_1PH8";

  //if (MLFB05_1PH8 == "28"){

  var sTable = "VT_1PH8_M00306" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANBAU_GEBERSYSTEM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeactivateAllAttributeValues("O_G80_H56_H75_1PH8");
        ECL_ActivateValue("O_G80_H56_H75_1PH8", "NON");
        ECL_SelectValue("O_G80_H56_H75_1PH8", "NON");
        // ECL_DeactivateAttribute("O_G80_H56_H75_1PH8");
    }*/
  // ----------------------------------------------------------------------------------------------------------------
  // VT_1PH8_M00348	K16-G80-H75
  //		O_K16_1PH8	O_G80_H56_H75_1PH8
  var O_K16_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K16_1PH8", "T")) {
    O_K16_1PH8 = "K16";
  }

  var sTable = "VT_1PH8_M00348" + sDB_Suffix;
  var sWhere = "O_K16_1PH8 = '" + O_K16_1PH8 + "';";

  //if (MLFB05_1PH8 == "28"){
  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
  /*}else{
        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    }*/
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANBAU_GEBERSYSTEM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Wellenausführung / Wellenende
  // ################################################################################################################
  /*
    Logik über MLFB13_1PH8 und übersetzung in PMD_AAA506_001_000_1PH8 zum Schluss!
    
    PMD_AAA506_001_000_1PH8			Ausführung des Wellenendes / an der Antriebsseite	MLFB13 übersetzt
        VT_1PH8_M00503	Wellenende_Wuchtung_MLFB13
            MLFB13_1PH8	PMD_AAA506_001_000_1PH8	HMK_VALUE_VALID_1PH8
    MLFB13_1PH8	PMD_AAA506_001_000_1PH8
    0			00001						Glatte Welle
    2			00002						Passfeder mit Halbkeilwuchtung
    3			00003						Glatte Hohlwelle
    1			00004						Passfeder mit Vollkeilwuchtung
    // ---------------------------------------------------
    // MLFB13 als Steuermerkmal
    A: VT_1PH8_M00253	AL BlockC: 14_13_09
        MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
    B: VT_1PH8_M00255	AL BlockC: 05_08_13
        MLFB05_1PH8	MLFB08_1PH8	MLFB13_1PH8	HMK_VALUE_VALID_1PH8
    C: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
        MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
    
    D: VT_1PH8_M00334	Y64-AH-MLFB13
        MLFB05_1PH8	MLFB13_1PH8	O_Y64_1PH8
    E: VT_1PH8_M00341	U60-U68-AH-MLFB12-13-14
        MLFB05_1PH8	MLFB12_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_U60_BIS_U68_1PH8
    Übersetzung: VT_1PH8_M00503	Wellenende_Wuchtung_MLFB13
        MLFB13_1PH8	PMD_AAA506_001_000_1PH8	HMK_VALUE_VALID_1PH8
    G: VT_1PH8_M00523	M03-M39-AH-MLFB10-13
        MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8
    // ---------------------------------------------------
    
    */

  ECL_ActivateAllAttributeValues("MLFB13_1PH8");
  // if GearboxMotorCoupling or isDriveTrain same handling
  if (IsGearBoxMotorCoupling || IsDriveTrain) {
    /* 
        Wellenende - glatte Welle (0), Passfeder Vollkeilwuchtung (1), Passfeder Halbkeilwuchtung (2), glatte Hohlwelle (3)
      0 für AH 80, 100
      2 für AH > 100
        
        Bauform nur IM B5 bzw. IM B35 (MLFB12)
            PMD_AAC949_001_000_1PH8 =>  00005	IM B35 (IM V15, IM V35)
                                        00010	IM B5 (IM V1, IM V3)
    */
    if (MLFB05_1PH8 == "08" || MLFB05_1PH8 == "10") {
      ECL_DeactivateAllAttributeValues("MLFB13_1PH8");
      ECL_ActivateValue("MLFB13_1PH8", "0");
      ECL_SetValue("MLFB13_1PH8", "0");
    } else {
      ECL_DeactivateAllAttributeValues("MLFB13_1PH8");
      ECL_ActivateValue("MLFB13_1PH8", "2");
      ECL_SetValue("MLFB13_1PH8", "2");
    }
  }

  var sTargetAttribute = "MLFB13_1PH8";

  // A: VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00253" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // B: VT_1PH8_M00255	AL BlockC: 05_08_13
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB13_1PH8	HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00255" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // C: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
  //	MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8

  var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");
  var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");

  var sTable = "VT_1PH8_M00563" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
    "O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    var sTable = "VT_1PH8_M00563" + sDB_Suffix;
    var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
      "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "';"; // AND " +
    //"O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
  }
  // ----------------------------------------------------------------------------------------------------------------
  // D: VT_1PH8_M00334	Y64-AH-MLFB13
  //	MLFB05_1PH8	MLFB13_1PH8	O_Y64_1PH8
  /* EDIT09/2023 keine Einschränkung in dieser Richtung
    var O_Y64_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_Y64_1PH8", "T"))
        O_Y64_1PH8 = "Y64";
    
    var sTable = "VT_1PH8_M00334" + sDB_Suffix;
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "O_Y64_1PH8 = '" + O_Y64_1PH8 + "';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    */
  // ----------------------------------------------------------------------------------------------------------------
  //E: VT_1PH8_M00341	U60-U68-AH-MLFB12-13-14
  //	MLFB05_1PH8	MLFB12_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_U60_BIS_U68_1PH8
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");

  var sTable = "VT_1PH8_M00341" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // F: VT_1PH8_M00523	M03-M39-AH-MLFB10-13
  //	MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00523" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB10_1PH8 = '" + MLFB10_1PH8 + "' AND " +
    "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------

  // ----------------------------------------------------------------------------------------------------------------
  // Übersetzung MLFB13 in PMD_AAA506_001_000_1PH8
  // ----------------------------------------------------------------------------------------------------------------
  var sTargetAttribute = "PMD_AAA506_001_000_1PH8";
  var aValidWellenende = ECL_GetAllActiveAttributeValues("MLFB13_1PH8");

  if (aValidWellenende.length > 0) {
    var oldValueOfTargetAttribute = ECL_GetValue(sTargetAttribute); //Alten Wert speichern, da ECL_DeactivateAllAttributeValues alles verwirft
    ECL_DeactivateAllAttributeValues(sTargetAttribute);

    for (var i = 0; i < aValidWellenende.length; i++) {
      var sResultValue = aValidWellenende[i];
      switch (sResultValue) {
        case "0":
          var sTargetValue = "00001"; // glatte Welle
          break;
        case "1":
          var sTargetValue = "00004"; // Passfeder mit Vollkeilwuchtung
          break;
        case "2":
          var sTargetValue = "00002"; // Passfeder mit Halbkeilwuchtung
          break;
        case "3":
          var sTargetValue = "00003"; // Glatte Hohlwelle
          break;
        default:
          var sTargetValue = "00001"; // glatte Welle
      }

      ECL_ActivateValue(sTargetAttribute, sTargetValue);
    }
  } else {
    strError = "DICT1_ERR_1PH8___PL_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  ECL_SelectValue(sTargetAttribute, oldValueOfTargetAttribute); //Alten Wert wieder einsetzen
  ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1PH8", "00001");
  // ################################################################################################################
  //Set MLFB13_1PH8
  var PMD_AAA506_001_000_1PH8 = ECL_GetValue("PMD_AAA506_001_000_1PH8");

  switch (PMD_AAA506_001_000_1PH8) {
    case "00001":
      var MLFB13_1PH8 = "0"; // glatte Welle
      break;
    case "00004":
      var MLFB13_1PH8 = "1"; // Passfeder mit Vollkeilwuchtung
      break;
    case "00002":
      var MLFB13_1PH8 = "2"; // Passfeder mit Halbkeilwuchtung
      break;
    case "00003":
      var MLFB13_1PH8 = "3"; // Glatte Hohlwelle
      break;
    default:
      var MLFB13_1PH8 = "0"; // glatte Welle
  }

  sMLFB = replaceAt(sMLFB, 12, MLFB13_1PH8);

  ECL_SetValue("ECSI_MLFB", sMLFB);
  //-------------------------------------------------------------------------------
  // sWhereMLFB13 für weitere Betrachtungen
  var aValidMLFB13 = ECL_GetAllActiveAttributeValues("MLFB13_1PH8");
  var sWhereMLFB13 = "";
  if (aValidMLFB13 && aValidMLFB13.length > 0) {
    sWhereMLFB13 = "MLFB13_1PH8 = '" + aValidMLFB13[0] + "'";
  }
  if (aValidMLFB13 && aValidMLFB13.length > 1) {
    sWhereMLFB13 = "(" + sWhereMLFB13;
    for (var i = 1; i < aValidMLFB13.length; i++) {
      sWhereMLFB13 += " OR MLFB13_1PH8 = '" + aValidMLFB13[i] + "'";
    }
    sWhereMLFB13 += ")";
  }
  // ################################################################################################################

  // ################################################################################################################
  // Schwinggrößenstufe				PMD_AAB007_001_000_1PH8
  // ################################################################################################################
  /*	==> Siehe Lagerung
    VT_1PH8_M00036	Antriebsart_MLFB14
        MLFB05_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8	HMK_VALUE_VALID_1PH8
    * /
    var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
    var TAK_AAJ730_001_000_1PH8 = ECL_GetValue("TAK_AAJ730_001_000_1PH8");
    
    var sTable = "VT_1PH8_M00036" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAB007_001_000_1PH8";
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
                    "TAK_AAJ730_001_000_1PH8 = '" + TAK_AAJ730_001_000_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_SCHWINGGROESSENSTUFE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    
    // ################################################################################################################
    // Wellen- und Flanschgenauigkeit				TAK_AAJ730_001_000_1PH8
    // ################################################################################################################
    /* ==> Siehe Lagerung
    TAK_AAJ730_001_000_1PH8			
        VT_1PH8_M00036	Antriebsart_MLFB14
            MLFB05_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8	HMK_VALUE_VALID_1PH8

    * /
    var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
    var PMD_AAB007_001_000_1PH8 = ECL_GetValue("PMD_AAB007_001_000_1PH8");
    
    var sTable = "VT_1PH8_M00036" + sDB_Suffix;
    var sTargetAttribute = "TAK_AAJ730_001_000_1PH8";
    var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
                    "PMD_AAB007_001_000_1PH8 = '" + PMD_AAB007_001_000_1PH8 + "' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1PH8___PL_WELLEN_FLANSCH_GENAUIGKEIT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    */
  // ################################################################################################################

  // ################################################################################################################
  // Bauform der drehenden elektrischen Maschine / gemäß Code I		PMD_AAC949_001_000_1PH8
  // ################################################################################################################
  /*
    Bauform MLFB12 übersetzt in PMD_AAC949_001_000_1PH8 nicht immer eindeutig???
    
    VT_1PH8_M00447	Bauform-MLFB12
        MLFB05_1PH8	PMD_ABU276_001_000_1PH8	MLFB12_1PH8	MLFB14_1PH8	PMD_AAC949_001_000_1PH8	HMK_VALUE_VALID_1PH8
    nn	VT_1PH8_M00459	Bauform
        PMD_AAC949_001_000_1PH8	HMK_BAUFORM_1PH8
    */

  // -----------------------------------------------------------------------------------
  // zunächst die gültigen MLFB12 ermitteln
  // VT_1PH8_M00252
  //	H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8

  // -----------------------------------------------------------------------------------
  // DriveTrains 0 - B3 nicht erlaubt
  // -----------------------------------------------------------------------------------
  ECL_ActivateAllAttributeValues("MLFB12_1PH8");

  if (IsGearBoxMotorCoupling || IsDriveTrain) {
    ECL_DeactivateValue("MLFB12_1PH8", "0");
    ECL_DeactivateValue("MLFB12_1PH8", "1");
    ECL_DeactivateValue("MLFB12_1PH8", "5");
  }
  // -----------------------------------------------------------------------------------

  var sTargetAttribute = "MLFB12_1PH8";
  var sTable = "VT_1PH8_M00252" + sDB_Suffix;
  var sWhere =
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " + "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00258
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00258" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  //Übersetzung MLFB12 Where-Klausel
  var aValidValuesMLFB12 = ECL_GetAllActiveAttributeValues("MLFB12_1PH8");
  var sWhereMLFB12 = "MLFB12_1PH8 = '" + aValidValuesMLFB12[0] + "'";

  if (aValidValuesMLFB12.length > 1) {
    for (var i = 1; i < aValidValuesMLFB12.length; i++) {
      sWhereMLFB12 = sWhereMLFB12 + " OR MLFB12_1PH8 = '" + aValidValuesMLFB12[i] + "'";
    }
  }
  sWhereMLFB12 = "(" + sWhereMLFB12 + ") AND ";

  // -----------------------------------------------------------------------------------

  var sTargetAttribute = "PMD_AAC949_001_000_1PH8";

  var sTable = "VT_1PH8_M00447" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sWhereMLFB12 +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  // MLFB12_1PH8 setzen
  var PMD_AAC949_001_000_1PH8 = ECL_GetValue("PMD_AAC949_001_000_1PH8");

  var sTable = "VT_1PH8_M00447" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT MLFB12_1PH8 FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
    "PMD_AAC949_001_000_1PH8 = '" + PMD_AAC949_001_000_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB12_1PH8 = aResult[0].MLFB12_1PH8;

    sMLFB = replaceAt(sMLFB, 11, MLFB12_1PH8);

    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_1PH8___PL_MLFB12_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  //--------------------------------------------------------------------------------------------------------------
  // Set n_max Bauform  HMK_N_MAX_TC_1PH8	Maximale Drehzahl Bauform
  // VT_1PH8_M00631	nMax Bauform
  //  MLFB12_1PH8 PMD_ABP663_001_000_1002197  HMK_N_MAX_TC_1PH8

  var HMK_N_MAX_TC_1PH8 = 0;

  var sTable = "VT_1PH8_M00631" + sDB_Suffix;
  var sSQL = "SELECT HMK_N_MAX_TC_1PH8 FROM " + sTable + " WHERE " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "PMD_ABP663_001_000_1002197 = " + PMD_ABP663_001_000_1002197 + " AND " +
    "HMK_N_MAX_TC_1PH8 > 0;";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult && aResult.length > 0) {
    HMK_N_MAX_TC_1PH8 = aResult[0].HMK_N_MAX_TC_1PH8;
  } else {
    strError = "DICT1_ERR_1PH8___BAUFORM_N_MAX_NO_DB_RESULT";
    return strError;
  }
  ECL_DeactivateAllAttributeValues("HMK_N_MAX_TC_1PH8");
  ECL_ActivateValue("HMK_N_MAX_TC_1PH8", HMK_N_MAX_TC_1PH8);
  ECL_SelectValue("HMK_N_MAX_TC_1PH8", HMK_N_MAX_TC_1PH8);
  //--------------------------------------------------------------------------------------------------------------
  // ################################################################################################################

  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHN
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  // ################################################################################################################
  // Signalanschluss gegenüberliegend		O_K08_1PH8				keine CB, da Auswertung im Hintergrund
  // ################################################################################################################
  /* Auswertung A Einschränkung durch Achshöhe, da nur für AH 180, 225, 280 relevant/möglich
    
    A: VT_1PH8_M00307	K08-AH-MLFB09-MLFB15					==> Auswertung vor Anschlussart
        MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	O_K08_1PH8
    */

  var sTable = "VT_1PH8_M00307" + sDB_Suffix;
  var sTargetAttribute = "O_K08_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB09_1PH8 = '" + MLFB09_1PH8 + "';"; // Geber

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K08_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  if (ECL_ValueActive("O_K08_1PH8", "K08")) {
    if (ECL_ValueSelected("O_K08_1PH8", "K08")) {
      var sWhere_K08 = "O_K08_1PH8 = 'K08' AND ";
    } else {
      var sWhere_K08 = "(O_K08_1PH8 = 'K08' OR O_K08_1PH8 = 'F') AND ";
    }
  } else {
    var sWhere_K08 = "O_K08_1PH8 = 'F' AND ";
  }

  // ################################################################################################################
  // Leistungsanschluss			HMK_ANSCHL_KK_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    
    VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    */
  // -----------------------------------------------------------------------------------
  // zunächst mit VT_1PH8_M00249 die gültigen MLFB15 ermitteln
  //	H_RUMPF_050710_0811_1PH8	MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTargetAttribute = "MLFB15_1PH8";
  var sTable = "VT_1PH8_M00249" + sDB_Suffix;
  var sWhere = "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANSCHL_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00256
  //	MLFB05_1PH8		MLFB09_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00256" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANSCHL_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00258
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00258" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANSCHL_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------
  //Übersetzung MLFB15 in HMK_ANSCHL_KK_1PH8
  // über Where-Klausel
  var aValidValuesMLFB15 = ECL_GetAllActiveAttributeValues("MLFB15_1PH8");
  var sWhereMLFB15 = "MLFB15_1PH8 = '" + aValidValuesMLFB15[0] + "'";

  if (aValidValuesMLFB15.length > 1) {
    for (var i = 1; i < aValidValuesMLFB15.length; i++) {
      sWhereMLFB15 = sWhereMLFB15 + " OR MLFB15_1PH8 = '" + aValidValuesMLFB15[i] + "'";
    }
  }
  sWhereMLFB15 = "(" + sWhereMLFB15 + ") AND ";

  // -----------------------------------------------------------------------------------
  var sTargetAttribute = "HMK_ANSCHL_KK_1PH8";

  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");
  var O_K83_K84_K85_1PH8 = ECL_GetValue("O_K83_K84_K85_1PH8");
  var HMK_LAGE_KK_1PH8 = ECL_GetValue("HMK_LAGE_KK_1PH8");
  var PMD_ABU203_001_000_1PH8 = ECL_GetValue("PMD_ABU203_001_000_1PH8"); // Anordnung des elektrischen Anschlusses / für Signalleitung
  var PMD_ABU208_001_000_1PH8 = ECL_GetValue("PMD_ABU208_001_000_1PH8"); // Position / der Kabeleinführung für Leistungsleitung
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8"); // Klemmenkasten-Hilfsmerkmal

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sWhere_K08 +
    sWhereMLFB15 +
    //"O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANSCHL_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00491	Leistungsstecker<>L00-Q00
  //	HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
  var O_L00_1PH8 = "F"; // Austausch Klemmenkasten durch den nächst Größeren
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) O_L00_1PH8 = "L00";
  var O_Q00_1PH8 = "F"; // Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten
  if (ECL_ValueSelected("CB_O_Q00_1PH8", "T")) O_Q00_1PH8 = "Q00";

  var sTable = "VT_1PH8_M00491" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_L00_1PH8 = '" + O_L00_1PH8 + "' AND " +
    "O_Q00_1PH8 = '" + O_Q00_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_ANSCHL_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Lage des Klemmkasten				O_K09_K10_1PH8			O_K09_K10_UI_1PH8
  // ################################################################################################################
  /*
    Lage des Klemmkasten
    Position of the terminal box

    O_K09_K10_UI_1PH8
        _K09_100	Klemmenkasten oder Leistungsstecker NDE rechts
        _K09_180	Klemmenkasten NDE rechts, Leitungseinführung DE, Signalanschluss oben (möglich, wenn 15. Datenstelle "A")
        _K10_100	Klemmenkasten oder Leistungsstecker NDE links
        _K10_180	Klemmenkasten NDE links, Leitungseinführung DE, Signalanschluss oben (möglich, wenn 15. Datenstelle "A")
        STD			Standard

    O_K09_K10_1PH8
        STD	Klemmenkasten Standard
        K09	Klemmenkasten NDE rechts
        K10	Klemmenkasten NDE links
    
    
    B: VT_1PH8_M00358	K09-K10-G00-G11		// Lage des Fremdlüfters
        O_K09_K10_1PH8	O_G00_B_G11_1PH8
    
    C: VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	HMK_LAGE_KK_1PH8	
        PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	HMK_VALUE_VALID_1PH8

    nn VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
    
    A: VT_1PH8_M00537	AH-MLFB12-K09-K10				Achshöhe und Bauform
        MLFB05_1PH8	MLFB12_1PH8	O_K09_K10_1PH8
    */
  var sTargetAttribute = "O_K09_K10_1PH8";

  /* A: 
    VT_1PH8_M00537	AH-MLFB12-K09-K10				Achshöhe und Bauform
        MLFB05_1PH8	MLFB12_1PH8	O_K09_K10_1PH8
    */
  var sTable = "VT_1PH8_M00537" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K09_K10_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00358	K09-K10-G00-G11
  //	O_K09_K10_1PH8	O_G00_B_G11_1PH8
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");

  var sTable = "VT_1PH8_M00358" + sDB_Suffix;
  var sWhere = "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K09_K10_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  /* C: 
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	HMK_LAGE_KK_1PH8	
        PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	HMK_VALUE_VALID_1PH8
    */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sWhere_K08 +
    sWhereMLFB15 +
    //"O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +		// Drehen des Klemmkastens nachrangig
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    //"PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    //"PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    //"HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K09_K10_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* D: nur zur Bestimmung KK_2
    VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
  */
  // ################################################################################################################

  var aValidValuesK09_K10 = ECL_GetAllActiveAttributeValues("O_K09_K10_1PH8");
  var sWhereK09_K10 = "O_K09_K10_1PH8 = '" + aValidValuesK09_K10[0] + "'";

  if (aValidValuesK09_K10.length > 1) {
    for (var i = 1; i < aValidValuesK09_K10.length; i++) {
      sWhereK09_K10 = sWhereK09_K10 + " OR O_K09_K10_1PH8 = '" + aValidValuesK09_K10[i] + "'";
    }
  }
  sWhereK09_K10 = "(" + sWhereK09_K10 + ") AND ";

  // ################################################################################################################
  // Lage			HMK_LAGE_KK_1PH8		O_K09_K10_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sTargetAttribute = "HMK_LAGE_KK_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sWhere_K08 +
    sWhereK09_K10 +
    //"O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    sWhereMLFB15 +
    //"O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +	// Drehen des Klemmkastens nachrangig
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_LAGE_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // Position / der Kabeleinführung für Leistungsleitung		PMD_ABU208_001_000_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  var HMK_LAGE_KK_1PH8 = ECL_GetValue("HMK_LAGE_KK_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU208_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    sWhereMLFB15 +
    sWhere_K08 +
    sWhereK09_K10 +
    //"O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    //"PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_PMD_ABU208_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Anordnung des elektrischen Anschlusses / für Signalleitung			PMD_ABU203_001_000_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  var PMD_ABU208_001_000_1PH8 = ECL_GetValue("PMD_ABU208_001_000_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sTargetAttribute = "PMD_ABU203_001_000_1PH8";
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    sWhereMLFB15 +
    sWhere_K08 +
    //"O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    sWhereK09_K10 +
    "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_PMD_ABU203_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // BestimmungO_K09_K10_1PH8K09
  var sTargetAttribute = "O_K09_K10_1PH8";
  /* C: 
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	HMK_LAGE_KK_1PH8	
        PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	HMK_VALUE_VALID_1PH8
    */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");
  var HMK_LAGE_KK_1PH8 = ECL_GetValue("HMK_LAGE_KK_1PH8");
  var PMD_ABU203_001_000_1PH8 = ECL_GetValue("PMD_ABU203_001_000_1PH8");
  var PMD_ABU208_001_000_1PH8 = ECL_GetValue("PMD_ABU208_001_000_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sWhere_K08 + "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " + // Drehen des Klemmkastens nachrangig
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    "PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K09_K10_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################
  // Signalanschluss gegenüberliegend		O_K08_1PH8				keine CB, da Auswertung im Hintergrund
  // ################################################################################################################
  /* Auswertung B
    nur für AH 180, 225, 280
    
    A: VT_1PH8_M00307	K08-AH-MLFB09-MLFB15					==> Auswertung vor Anschlussart
        MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	O_K08_1PH8
    
    B: VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
            
    als Ergebnis aus PMD_ABU203_001_000_1PH8 ???
    */
  var sTargetAttribute = "O_K08_1PH8";

  //var PMD_ABU203_001_000_1PH8 = ECL_GetValue("PMD_ABU203_001_000_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    "PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K08_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // todo Bestimmung HMK_KK_1PH8 & HMK_KK_2_1PH8
  /* // todo Bestimmung MLFB15 ???
    B: VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sSQL =
    "SELECT DISTINCT MLFB15_1PH8 FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    "PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var MLFB15_1PH8 = aResult[0].MLFB15_1PH8;
    //var HMK_KK_1PH8 = aResult[0].HMK_KK_1PH8;

    //ECL_SetValue("HMK_KK_1PH8", HMK_KK_1PH8);

    sMLFB = replaceAt(sMLFB, 14, MLFB15_1PH8);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    strError = "DICT1_ERR_1PH8___PL_MLFB15_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // Bestimmung MLFB15 Gruppe
  // VT338
  // MLFB15_1PH8	HMK_MLFB15_GRUPPE_1PH8
  var sTargetAttribute = "HMK_MLFB15_GRUPPE_1PH8";

  var sTable = "VT_1PH8_M00338" + sDB_Suffix;
  var sWhere = "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_HMK_MLFB15_GRUPPE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ----------------------------------------------------------------------------------------------------------------------
  // Where-Klausel für MLFB09-Gruppe
  var aValidValuesMLFB09_Gruppe = ECL_GetAllActiveAttributeValues("HMK_MLFB09_GRUPPE_1PH8");
  var sWhereMLFB09_Gruppe = "HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[0] + "'";

  if (aValidValuesMLFB09_Gruppe.length > 1) {
    for (var i = 1; i < aValidValuesMLFB09_Gruppe.length; i++) {
      sWhereMLFB09_Gruppe = sWhereMLFB09_Gruppe + " OR HMK_MLFB09_GRUPPE_1PH8 = '" + aValidValuesMLFB09_Gruppe[i] + "'";
    }
  }
  sWhereMLFB09_Gruppe = "(" + sWhereMLFB09_Gruppe + ") AND ";
  // ----------------------------------------------------------------------------------------------------------------------
  // Where-Klausel für MLFB15-Gruppe
  var aValidValuesMLFB15_Gruppe = ECL_GetAllActiveAttributeValues("HMK_MLFB15_GRUPPE_1PH8");
  var sWhereMLFB15_Gruppe = "HMK_MLFB15_GRUPPE_1PH8 = '" + aValidValuesMLFB15_Gruppe[0] + "'";

  if (aValidValuesMLFB15_Gruppe.length > 1) {
    for (var i = 1; i < aValidValuesMLFB15_Gruppe.length; i++) {
      sWhereMLFB15_Gruppe = sWhereMLFB15_Gruppe + " OR HMK_MLFB15_GRUPPE_1PH8 = '" + aValidValuesMLFB15_Gruppe[i] + "'";
    }
  }
  sWhereMLFB15_Gruppe = "(" + sWhereMLFB15_Gruppe + ") AND ";

  // ----------------------------------------------------------------------------------------------------------------------
  // Einschränkung KK über VT562
  /* VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
    */
  var sTargetAttribute = "HMK_KK_1PH8";

  var H_RUMPF_050710_0811_1PH8 = ECL_GetValue("H_RUMPF_050710_0811_1PH8");

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sWhere = sWhereMLFB09_Gruppe +
    sWhereMLFB15_Gruppe +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_BESTIMMUNG_KK_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------

  // HMK_KK_2_1PH8
  /*
    D: VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
    */
  var sTargetAttribute = "HMK_KK_2_1PH8";

  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00377" + sDB_Suffix;
  var sWhere = "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " + "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_HMK_KK_2_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /*simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1PH8_M00377" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_KK_2_1PH8": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    ExecSetStandardifValueEmpty("HMK_KK_2_1PH8","NON");
    */

  // ################################################################################################################
  // Drehen des Klemmenkastens			O_K83_K84_K85_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00371	K83-K84-K85-AH-MLFB11-15
        O_K83_K84_K85_1PH8	MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8
    
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  // NICHT LEA (Ausschluss über AH / MLFB05)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sTargetAttribute = "O_K83_K84_K85_1PH8";

  /* A: 
        VT_1PH8_M00371	K83-K84-K85-AH-MLFB11-15
            O_K83_K84_K85_1PH8	MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8
        */
  var sTable = "VT_1PH8_M00371" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K83_K84_K85_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
        VT_1PH8_M00376	Anschlusstechnik_MLFB15
            MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
                HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
                HMK_VALUE_VALID_1PH8
        */
  var O_K08_1PH8 = ECL_GetValue("O_K08_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "O_K08_1PH8 = '" + O_K08_1PH8 + "' AND " +
    "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    "PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    "HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K83_K84_K85_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_SetValue("O_K83_K84_K85_1PH8", "NON");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Klemmenkasten-Hilfsmerkmal		HMK_KK_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8

    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
    */

  // ################################################################################################################

  // ################################################################################################################
  // Klemmenkasten 2. Hilfsmerkmal	HMK_KK_2_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
    
    */
  var sTargetAttribute = "HMK_KK_2_1PH8";

  /* A: 
    VT_1PH8_M00377	Klemmenkasten und Optionen
        HMK_KK_1PH8	O_K09_K10_1PH8	HMK_KK_2_1PH8
    */
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00377" + sDB_Suffix;
  var sWhere = "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " + "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_KK_2_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // Austausch Klemmenkasten durch den nächst Größeren		O_L00_1PH8		CB_O_L00_1PH8
  // ################################################################################################################
  /* nur für AH 180, 225, 280 möglich
    
    VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8

    VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    
    VT_1PH8_M00627	Klemmenkasten, L00, Q00
      HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8
    */
  // nur für AH 180, 225, 280 möglich
  //if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_L"){

  var sDTKAttribute = "O_L00_1PH8";
  var sCB_Attribute = "CB_O_L00_1PH8";

  /* VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
  */
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  //var HMK_REAL_KK_1PH8 = ECL_GetValue("HMK_REAL_KK_1PH8");

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sWhere = "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    sWhereMLFB09_Gruppe +
    sWhereMLFB15_Gruppe +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "F", sWhere, false);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L00_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------------------------------
  /* VT_1PH8_M00491	Leistungsstecker<>L00-Q00
            HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
        */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");
  var O_Q00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q00_1PH8", "T")) O_Q00_1PH8 = "Q00";

  var sTable = "VT_1PH8_M00491" + sDB_Suffix;
  var sWhere = "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " + "O_Q00_1PH8 = '" + O_Q00_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "F", sWhere, true);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L00_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // -----------------------------------------------------------------------------------------
  //VT_1PH8_M00627	Klemmenkasten, L00, Q00
  //    HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8

  var sTable = "VT_1PH8_M00627" + sDB_Suffix;
  var sWhere = "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " + "O_Q00_1PH8 = '" + O_Q00_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L00", "F", sWhere, true);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L00_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L00_1PH8");
    }*/
  // -----------------------------------------------------------------------------------------
  /* BZ_1PH8_00659	L00 setzen, wenn Q00
    RESTRICTIONS:
      c.O_L00_1PH8 = 'L00'
      IF (c.O_Q00_1PH8 = 'Q00'
      AND c.HMK_KK_1PH8 = '_P02')
      *
    INFERENCES:
      c.O_L00_1PH8
  */
  //var bEnabledL00 = ECL_AttributeEnabled(sCB_Attribute);
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_Q00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q00_1PH8", "T")) O_Q00_1PH8 = "Q00";

  if (HMK_KK_1PH8 == "_P02" && O_Q00_1PH8 == "Q00") {
    ECL_SelectValue(sCB_Attribute, "T");
    ECL_DisableAttribute(sCB_Attribute);
  }
  // ################################################################################################################

  // ################################################################################################################
  // HMK_REAL_KK_1PH8 bestimmen
  // ################################################################################################################
  /* VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
  */
  var sTargetAttribute = "HMK_REAL_KK_1PH8";

  /* A: 
    VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
    */
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_L00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) O_L00_1PH8 = "L00";

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sWhere = sWhereMLFB09_Gruppe +
    sWhereMLFB15_Gruppe +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "O_L00_1PH8 = '" + O_L00_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_KK_REAL_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten		O_Q00_1PH8
  // ################################################################################################################
  /* nur AH 280	(also nicht bei HMK_PRODUKT_TRIG_1PH8 == 1PH8_S || 1PH8_LEA)
    VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    */
  //if (MLFB05_1PH8 == "28"){
  //Auswertung VT

  var sDTKAttribute = "O_Q00_1PH8";
  var sCB_Attribute = "CB_O_Q00_1PH8";

  var O_L00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) O_L00_1PH8 = "L00";
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");

  var sTable = "VT_1PH8_M00491" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_L00_1PH8 = '" + O_L00_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q00", "F", sWhere, false);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q00_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // -----------------------------------------------------------------------------------------      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //VT_1PH8_M00627	Klemmenkasten, L00, Q00
  //    HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_L00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) O_L00_1PH8 = "L00";

  var sTable = "VT_1PH8_M00627" + sDB_Suffix;
  var sWhere = "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " + "O_L00_1PH8 = '" + O_L00_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q00", "F", sWhere, false);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q00_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_Q00_1PH8");
        ECL_DisableAttribute("CB_O_Q00_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Leitungseinführungsplatte			O_P00_BIS_P06_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00518	P00-P06-AH
        MLFB05_1PH8	MLFB11_1PH8	HMK_REAL_KK_1PH8	O_P00_BIS_P06_1PH8
    */
  // NICHT LEA Ausschluss über MLFB05 (AH) in VT518
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sTargetAttribute = "O_P00_BIS_P06_1PH8";

  var HMK_REAL_KK_1PH8 = ECL_GetValue("HMK_REAL_KK_1PH8");

  var sTable = "VT_1PH8_M00518" + sDB_Suffix;
  var sWhere =
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "HMK_REAL_KK_1PH8 = '" + HMK_REAL_KK_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_P00_BIS_P06_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_SetValue("O_P00_BIS_P06_1PH8", "NON");
    }*/
  // ################################################################################################################

  // ENDE ANSCHLUSSTECHNIK
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // Optionen
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  // ################################################################################################################
  // Kundenangabe auf dem Leistungsschild			O_Y84_1PH8
  // Kundenangabe auf dem Leistungsschild (Textfeld)		H_O_Y84_1006333
  // ################################################################################################################
  /*
    Kein Vorkommen in VT
    Wenn erlaubt, dann ist das Textfeld eingeblendet. 
    Sobald das Textfeld einen Inhalt hat, wird die Option Y84 automatisch gesetzt.
    */

  if (ECL_ValueEnabled("O_Y84_1PH8", "Y84")) {
    ECL_ActivateAttribute("H_O_Y84_1006333");
  } else {
    ECL_DeactivateAttribute("H_O_Y84_1006333");
  }

  if (strchangedAttribute == "H_O_Y84_1006333") {
    var sValueNorm = normalizeOE_Attribute("H_O_Y84_1006333");
    if (sValueNorm == "") {
      ECL_SetValue("O_Y84_1PH8", "F");
    } else {
      ECL_SetValue("O_Y84_1PH8", "Y84");
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // Zusatzschild mit Bestellerangaben		O_Y82_1002197									todo prüfen, ob abzubilden: scheint nicht benutzt zu werden
  // ################################################################################################################
  /*
    VT_1PH8_M00444	AH-Y82
        MLFB05_1PH8	O_Y82_1002197

    VT_1PH8_M00494	Y82 Bestellangaben
        O_Y82_1002197	H_O_Y82_1006333	HMK_VALUE_VALID_1PH8
    */

  // ################################################################################################################

  // ################################################################################################################
  // Zusatzschild mit Bestellerangaben (Textfeld)		H_O_Y82_1006333						todo prüfen, ob abzubilden:  scheint nicht benutzt zu werden
  // ################################################################################################################
  /*
    Wenn KAG, einblenden, sonst ausblenden
    ACHTUNG: Es gibt feste Werte für das Freitextfeld??!!!??
    * /
    var O_Y82_1002197 = ECL_GetValue("O_Y82_1002197");
    if (O_Y82_1002197 == "Y82"){
        ECL_ActivateAttribute("H_O_Y82_1006333");
    }else{
        ECL_DeactivateAttribute("H_O_Y82_1006333");
    }
    if (strchangedAttribute == "H_O_Y82_1006333"){
        var bOK = normalizeOE_Attribute("H_O_Y82_1006333");
    }
    */
  // ################################################################################################################

  // ################################################################################################################
  // Metallleistungsschild anstatt Klebeschild		O_Q31_1PH8
  // ################################################################################################################
  // kein Vorkommen
  // ################################################################################################################

  // ################################################################################################################
  // Ausführung für explosionsgefährdete Bereiche		O_M03_M39_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8

    B: VT_1PH8_M00324	M03-M39-AH-MLFB15
        MLFB05_1PH8	MLFB15_1PH8	O_M03_M39_1PH8

    C: VT_1PH8_M00342	A12-M03-M39-Q12-AH
        MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8

    D: VT_1PH8_M00343	M03-M39-U60-U68-K18
        O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8

    E: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8

    F: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8

    G: VT_1PH8_M00356	K45-M39
        O_K45_1PH8	O_M03_M39_1PH8

    H: VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8

    I: VT_1PH8_M00363	Q52-M03-M39
        O_Q52_1PH8	O_M03_M39_1PH8

    J: VT_1PH8_M00365	Y64-M03-M39
        O_Y64_1PH8	O_M03_M39_1PH8

    K: VT_1PH8_M00367	L12-M39
        O_L12_1PH8	O_M03_M39_1PH8

    L: VT_1PH8_M00369	A25-M03-M39
        O_A25_1PH8	O_M03_M39_1PH8
    
    M: VT_1PH8_M00523	M03-M39-AH-MLFB10-13
        MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8

    N: VT_1PH8_M00526	M03-M39-L76
        O_M03_M39_1PH8	O_L76_1PH8

    O: VT_1PH8_M00540	L27-M39
        O_L27_1PH8	O_M03_M39_1PH8
    
NEU	P: VT_1PH8_M00564	M03-M39-AH-Konfigtyp
            MLFB05_1PH8	O_M03_M39_1PH8	HMK_KONFIG_TYP_1PH8	HMK_VALUE_VALID_1PH8
    */
  // NICHT LEA Einschränkung über MLFB08 und MLFB13 aus VT255 und VT523
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){

  // --------------------------------------------------------------------------------------------
  var sTargetAttribute = "O_M03_M39_1PH8";
  /* A: 
        VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
            MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8
        */
  var sTable = "VT_1PH8_M00323" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
        VT_1PH8_M00324	M03-M39-AH-MLFB15
            MLFB05_1PH8	MLFB15_1PH8	O_M03_M39_1PH8
        */
  var sTable = "VT_1PH8_M00324" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* C: 
        VT_1PH8_M00342	A12-M03-M39-Q12-AH
            MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
        */
  var O_A12_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_A12_1PH8", "T")) O_A12_1PH8 = "A12";
  var O_Q12_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q12_1PH8", "T")) O_Q12_1PH8 = "Q12";

  var sTable = "VT_1PH8_M00342" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_A12_1PH8 = '" + O_A12_1PH8 + "' AND " + "O_Q12_1PH8 = '" + O_Q12_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* D: 
        VT_1PH8_M00343	M03-M39-U60-U68-K18
            O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8
        */
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
  var O_K18_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";

  var sTable = "VT_1PH8_M00343" + sDB_Suffix;
  var sWhere = "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " + "O_K18_1PH8 = '" + O_K18_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* E: 
        VT_1PH8_M00344	M03-M39-K80-L74
            O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
        */
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00344" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "' AND " + "O_L74_1PH8 = '" + O_L74_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* F: 
        VT_1PH8_M00351	M03-M39-G14-L75
            O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
        */
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00351" + sDB_Suffix;
  var sWhere = "O_G14_1PH8 = '" + O_G14_1PH8 + "' AND " + "O_L75_1PH8 = '" + O_L75_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* G: 
        VT_1PH8_M00356	K45-M39
            O_K45_1PH8	O_M03_M39_1PH8
        */
  var O_K45_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K45_1PH8", "T")) O_K45_1PH8 = "K45";

  var sTable = "VT_1PH8_M00356" + sDB_Suffix;
  var sWhere = "O_K45_1PH8 = '" + O_K45_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* H: 
        VT_1PH8_M00361	L03-Q14-M39
            O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
        */
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00361" + sDB_Suffix;
  var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " + "O_Q14_1PH8 = '" + O_Q14_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* I: 
        VT_1PH8_M00363	Q52-M03-M39
            O_Q52_1PH8	O_M03_M39_1PH8					Q52 nicht aktiv? todo prüfen
        *  /
        var O_Q52_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_Q52_1PH8", "T"))
            O_Q52_1PH8 = "Q52";
        
        var sTable = "VT_1PH8_M00363" + sDB_Suffix;
        var sWhere = "O_Q52_1PH8 = '" + O_Q52_1PH8 + "';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }*/
  // --------------------------------------------------------------------------------------------
  /* J: 
        VT_1PH8_M00365	Y64-M03-M39
            O_Y64_1PH8	O_M03_M39_1PH8
        */
  var O_Y64_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Y64_1PH8", "T")) O_Y64_1PH8 = "Y64";

  var sTable = "VT_1PH8_M00365" + sDB_Suffix;
  var sWhere = "O_Y64_1PH8 = '" + O_Y64_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* K: 
        VT_1PH8_M00367	L12-M39
            O_L12_1PH8	O_M03_M39_1PH8
        */
  var O_L12_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L12_1PH8", "T")) O_L12_1PH8 = "L12";

  var sTable = "VT_1PH8_M00367" + sDB_Suffix;
  var sWhere = "O_L12_1PH8 = '" + O_L12_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* L: 
        VT_1PH8_M00369	A25-M03-M39
            O_A25_1PH8	O_M03_M39_1PH8
        */
  var O_A25_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_A25_1PH8", "T")) O_A25_1PH8 = "A25";

  var sTable = "VT_1PH8_M00369" + sDB_Suffix;
  var sWhere = "O_A25_1PH8 = '" + O_A25_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* M: 
        VT_1PH8_M00523	M03-M39-AH-MLFB10-13
            MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8
        */
  var sTable = "VT_1PH8_M00523" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB10_1PH8 = '" + MLFB10_1PH8 + "' AND " +
    //"MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
    sWhereMLFB13 + " AND " + // todo testen
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* N: 
        VT_1PH8_M00526	M03-M39-L76
            O_M03_M39_1PH8	O_L76_1PH8
        */
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00526" + sDB_Suffix;
  var sWhere = "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* O: 
        VT_1PH8_M00540	L27-M39
            O_L27_1PH8	O_M03_M39_1PH8
        */
  var O_L27_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L27_1PH8", "T")) O_L27_1PH8 = "L27";

  var sTable = "VT_1PH8_M00540" + sDB_Suffix;
  var sWhere = "O_L27_1PH8 = '" + O_L27_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------
  /* P: 
        VT_1PH8_M00564	M03-M39-AH-Konfigtyp
            MLFB05_1PH8	O_M03_M39_1PH8	HMK_KONFIG_TYP_1PH8	HMK_VALUE_VALID_1PH8
        */

  var sTable = "VT_1PH8_M00564" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "HMK_KONFIG_TYP_1PH8 = '" + HMK_KONFIG_TYP_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_O_M03_M39_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  /*}else{
        ECL_SetValue("O_M03_M39_1PH8", "NON");
    }*/


  //--------------------------------------------------------------------------------------------------------------
  // Set n_max M03  HMK_N_MAX_M03_1PH8	Maximale Drehzahl M03
  // VT_1PH8_M00633	nMax M03
  //  O_M03_M39_1PH8  PMD_ABP663_001_000_1002197  HMK_N_MAX_M03_1PH8

  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var HMK_N_MAX_M03_1PH8 = 0;

  var sTable = "VT_1PH8_M00633" + sDB_Suffix;
  var sSQL = "SELECT HMK_N_MAX_M03_1PH8 FROM " + sTable + " WHERE " +
    "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
    "PMD_ABP663_001_000_1002197 = " + PMD_ABP663_001_000_1002197 + " AND " +
    "HMK_N_MAX_M03_1PH8 > 0;";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult && aResult.length > 0) {
    HMK_N_MAX_M03_1PH8 = aResult[0].HMK_N_MAX_M03_1PH8;
  } else {
    strError = "DICT1_ERR_1PH8___BAUFORM_N_MAX_NO_DB_RESULT";
    return strError;
  }

  ECL_DeactivateAllAttributeValues("HMK_N_MAX_M03_1PH8");
  ECL_ActivateValue("HMK_N_MAX_M03_1PH8", HMK_N_MAX_M03_1PH8);
  ECL_SelectValue("HMK_N_MAX_M03_1PH8", HMK_N_MAX_M03_1PH8);
  //--------------------------------------------------------------------------------------------------------------

  // ################################################################################################################

  // ################################################################################################################
  // Farbe		O_X01__X27_1PH8
  // ################################################################################################################
  /* 
    nn. VT_1PH8_M00360	K24-X01-X08		Keine Einschränkung, nur zur Bestimmung KAG
        O_K24_1PH8	O_X01__X27_1PH8

    A: VT_1PH8_M00500	AH <> Farben
        PMD_ABP663_001_000_1002197	O_X01__X27_1PH8
        
        // PMD_ABP663_001_000_1002197	Achshöhe als Zahl
    */
  var sTargetAttribute = "O_X01__X27_1PH8";

  /* A: 
    VT_1PH8_M00500	AH <> Farben
        PMD_ABP663_001_000_1002197	O_X01__X27_1PH8
    */
  var PMD_ABP663_001_000_1002197 = ECL_GetValue("PMD_ABP663_001_000_1002197");

  var sTable = "VT_1PH8_M00500" + sDB_Suffix;
  var sWhere = "PMD_ABP663_001_000_1002197 = '" + PMD_ABP663_001_000_1002197 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_FARBE_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Grundierung						O_K24_1PH8			CB_O_K24_1PH8		Attribut im Hintergrund
  // ################################################################################################################
  // Sonder-Lackierung Worldwide		O_K23_1PH8			CB_O_K23_1PH8
  // ################################################################################################################
  /* 
    VT_1PH8_M00359	K23-K24			Kreuzausschluss K23/K24
        O_K23_1PH8	O_K24_1PH8
    VT_1PH8_M00360	K24-X01-X08		Zuordnung Grundierung--> K24
        O_K24_1PH8	O_X01__X27_1PH8
    
    Eine Unterscheidung der beiden Grundierungen OHNE/OHNE2 ist nicht möglich, da beide mit der KAG K24 abgebildet 
        werden und kein Freitext für den Farbton erzeugt wird.
    */

  var O_X01__X27_1PH8 = ECL_GetValue("O_X01__X27_1PH8");
  if (O_X01__X27_1PH8 == "OHNE" || O_X01__X27_1PH8 == "OHNE2") {
    ECL_SelectValue("CB_O_K24_1PH8", "T");
    // Wenn K24, dann ist K23 nicht erlaubt
    ECL_DeselectAttribute("CB_O_K23_1PH8");
    ECL_DisableAttribute("CB_O_K23_1PH8");
  } else {
    ECL_DeselectAttribute("CB_O_K24_1PH8");
    ECL_EnableAttribute("CB_O_K23_1PH8");
  }
  // ################################################################################################################

  // ################################################################################################################
  // Fremdlüfter			O_G00_G02_1PH8															nicht nötig!
  // ################################################################################################################
  // nicht nötig!
  // ################################################################################################################

  // ################################################################################################################
  // Lage des Fremdlüfters		O_G00_B_G11_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00304	G00_G11-AH-MLFB11-MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_G00_B_G11_1PH8

    B: VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8

    C: VT_1PH8_M00354	G00-G11-K18
        O_G00_B_G11_1PH8	O_K18_1PH8

    D: VT_1PH8_M00358	K09-K10-G00-G11
        O_K09_K10_1PH8	O_G00_B_G11_1PH8

    E: VT_1PH8_M00536	MLFB12-G14-G00_B_G11
        MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sTargetAttribute = "O_G00_B_G11_1PH8";
  /* A: 
        VT_1PH8_M00304	G00_G11-AH-MLFB11-MLFB15
            MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_G00_B_G11_1PH8
        */
  var sTable = "VT_1PH8_M00304" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G00_B_G11_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
        VT_1PH8_M00345	G00-G11-L02-K69-K71
            O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
        */
  var O_L02_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L02_1PH8", "T")) O_L02_1PH8 = "L02";

  var sTable = "VT_1PH8_M00345" + sDB_Suffix;
  var sWhere = "O_L02_1PH8 = '" + O_L02_1PH8 + "' AND " + "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G00_B_G11_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* C: 
        VT_1PH8_M00354	G00-G11-K18
            O_G00_B_G11_1PH8	O_K18_1PH8
        */
  var O_K18_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";

  var sTable = "VT_1PH8_M00354" + sDB_Suffix;
  var sWhere = "O_K18_1PH8 = '" + O_K18_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G00_B_G11_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* D: 
        VT_1PH8_M00358	K09-K10-G00-G11
            O_K09_K10_1PH8	O_G00_B_G11_1PH8
        */
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");

  var sTable = "VT_1PH8_M00358" + sDB_Suffix;
  var sWhere = "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G00_B_G11_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* E: 
        VT_1PH8_M00536	MLFB12-G14-G00_B_G11
            MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
        */
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00536" + sDB_Suffix;
  var sWhere = "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " + "O_G14_1PH8 = '" + O_G14_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G00_B_G11_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_SetValue("O_G00_B_G11_1PH8", "NON");
    }*/
  var aO_G00_B_G11_1PH8 = ECL_GetAllActiveAttributeValues("O_G00_B_G11_1PH8");
  // ################################################################################################################

  // ################################################################################################################
  // Rohranschluss			O_K69_K70_K71_K80_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00607	K69-K70-K71-K80-AH-MLFB11-MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K69_K70_K71_K80_1PH8

    B: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8

    C: VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    
    D: VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8

    E: VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8

    F: VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8

    G: VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8
    
    H: VT_1PH8_M00606	K80-Q25
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */
  var sTargetAttribute = "O_K69_K70_K71_K80_1PH8";
  /* A: 
    VT_1PH8_M00607	K69-K70-K71-K80-AH-MLFB11-MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var sTable = "VT_1PH8_M00607" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
    VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    */
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00344" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
    "O_L74_1PH8 = '" + O_L74_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* C: 
    VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");
  var O_L02_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L02_1PH8", "T")) O_L02_1PH8 = "L02";

  var sTable = "VT_1PH8_M00345" + sDB_Suffix;
  var sWhere = "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "' AND " +
    "O_L02_1PH8 = '" + O_L02_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* D: 
    VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8
    */
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00346" + sDB_Suffix;
  var sWhere = "O_G14_1PH8 = '" + O_G14_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* E: 
    VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00357" + sDB_Suffix;
  var sWhere = "O_L75_1PH8 = '" + O_L75_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* F: 
    VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
    */
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00362" + sDB_Suffix;
  var sWhere = "O_Q14_1PH8 = '" + O_Q14_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* G: 
    VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8
    */
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00527" + sDB_Suffix;
  var sWhere = "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  /* H: 
    VT_1PH8_M00606	K80-Q25
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */
  var O_Q25_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q25_1PH8", "T")) O_Q25_1PH8 = "Q25";

  var sTable = "VT_1PH8_M00606" + sDB_Suffix;
  var sWhere = "O_Q25_1PH8 = '" + O_Q25_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K69_K70_K71_K80_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Lüfteranschluss NDE / oben (M16 x 1,5)		O_Q25_1PH8			CB_O_Q25_1PH8					nicht für LEA
  // ################################################################################################################
  /*
    A: VT_1PH8_M00569	Q25-AH-MLFB11-MLFB12
        MLFB11_1PH8	MLFB12_1PH8	MLFB05_1PH8	MLFB08_1PH8	O_Q25_1PH8
        
    B: VT_1PH8_M00606	K80-Q25
        O_K69_K70_K71_K80_1PH8	O_Q25_1PH8
    */

  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_Q25_1PH8";
  var sCB_Attribute = "CB_O_Q25_1PH8";

  // A:
  var sTable = "VT_1PH8_M00569" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q25", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q25_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // B:
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00606" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q25", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q25_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_Q25_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // mit Luftfilter			O_G14_1PH8		CB_O_G14_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00305	G14-AH-MLFB08-MLFB11
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_G14_1PH8

    B: VT_1PH8_M00346	K69-K80-G14
        O_K69_K70_K71_K80_1PH8	O_G14_1PH8
    
    C: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8

    D: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8

    E: VT_1PH8_M00353	AH-G14-K18
        MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8

    F: VT_1PH8_M00536	MLFB12-G14-G00_B_G11
        MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
    */
  var sDTKAttribute = "O_G14_1PH8";
  var sCB_Attribute = "CB_O_G14_1PH8";

  // A:
  var sTable = "VT_1PH8_M00305" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00346	K69-K80-G14
  //	O_K69_K70_K71_K80_1PH8	O_G14_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00346" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00350" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_Q14_1PH8 = '" + O_Q14_1PH8 + "' AND " + "O_L74_1PH8 = '" + O_L74_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00351	M03-M39-G14-L75
  //	O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00351" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " + "O_L75_1PH8 = '" + O_L75_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00353	AH-G14-K18
  //	MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8
  var O_K18_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K18_1PH8", "T")) O_K18_1PH8 = "K18";

  var sTable = "VT_1PH8_M00353" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_K18_1PH8 = '" + O_K18_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // F:
  // VT_1PH8_M00536	MLFB12-G14-G00_B_G11
  //	MLFB12_1PH8	O_G14_1PH8	O_G00_B_G11_1PH8
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");

  var sTable = "VT_1PH8_M00536" + sDB_Suffix;
  var sWhere = "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " + "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Lüfterausführung in Schutzart IP65			O_L74_1PH8		CB_O_L74_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00567	L74-AH-MLFB8-MLFB11
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	O_L74_1PH8
    B: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    C: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
    D: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){

  var sDTKAttribute = "O_L74_1PH8";
  var sCB_Attribute = "CB_O_L74_1PH8";

  // A:
  var sTable = "VT_1PH8_M00567" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L74", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L74_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00344	M03-M39-K80-L74
  //	O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00344" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " + "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L74", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L74_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00350" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_G14_1PH8 = '" + O_G14_1PH8 + "' AND " + "O_Q14_1PH8 = '" + O_Q14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L74", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L74_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //		O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " + "O_L75_1PH8 = '" + O_L75_1PH8 + "' AND " + "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L74", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L74_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L74_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Sonderlüfter 3 AC 400 V in Schutzart IP65			O_L75_1PH8			CB_O_L75_1PH8				NICHT LEA     nur noch Direkteingabe
  // ################################################################################################################
  /*
    A: VT_1PH8_M00320	L75-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_L75_1PH8
    B: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
    C: VT_1PH8_M00357	L75-K80
        O_L75_1PH8	O_K69_K70_K71_K80_1PH8
    D: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    E: VT_1PH8_M00625	L75 nur Direkteingabe
        O_L75_1PH8  HMK_KONFIG_TYP_1PH8

    */
  // Nur Direkteingabe, daher nicht mehr konfigurierbar!

  ECL_DeselectAttribute("CB_O_L75_1PH8");
  ECL_DisableAttribute("CB_O_L75_1PH8");
  /*
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L75_1PH8";
  var sCB_Attribute = "CB_O_L75_1PH8";

  // A:
  var sTable = "VT_1PH8_M00320" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(
    sTable,
    sDTKAttribute,
    sCB_Attribute,
    "L75",
    "F",
    sWhere,
    false
  );
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L75_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00351	M03-M39-G14-L75
  //	O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00351" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " +
    "O_G14_1PH8 = '" + O_G14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(
    sTable,
    sDTKAttribute,
    sCB_Attribute,
    "L75",
    "F",
    sWhere,
    true
  ); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L75_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00357	L75-K80
  //	O_L75_1PH8	O_K69_K70_K71_K80_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00357" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(
    sTable,
    sDTKAttribute,
    sCB_Attribute,
    "L75",
    "F",
    sWhere,
    true
  ); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L75_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //	O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " +
    "O_L74_1PH8 = '" + O_L74_1PH8 + "' AND " +
    "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(
    sTable,
    sDTKAttribute,
    sCB_Attribute,
    "L75",
    "F",
    sWhere,
    true
  ); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L75_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L75_1PH8");
    }* /
  */
  // ################################################################################################################

  // ################################################################################################################
  // EC-Lüfter 3 AC 400 V 50/60 Hz			O_L76_1PH8			CB_O_L76_1PH8							NICHT LEA
  // ################################################################################################################
  /*
    A: VT_1PH8_M00524	L76-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_L76_1PH8
    
    B: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    
    C: VT_1PH8_M00526	M03-M39-L76
        O_M03_M39_1PH8	O_L76_1PH8

    D: VT_1PH8_M00527	L76-K80
        O_L76_1PH8	O_K69_K70_K71_K80_1PH8

    E: VT_1PH8_M00528	L76-Q14
        O_L76_1PH8	O_Q14_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L76_1PH8";
  var sCB_Attribute = "CB_O_L76_1PH8";

  // A:
  var sTable = "VT_1PH8_M00524" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L76_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //	O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " + "O_L74_1PH8 = '" + O_L74_1PH8 + "' AND " + "O_L75_1PH8 = '" + O_L75_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L76_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00526	M03-M39-L76
  //	O_M03_M39_1PH8	O_L76_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00526" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L76_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00527	L76-K80
  //	O_L76_1PH8	O_K69_K70_K71_K80_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00527" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L76_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00528	L76-Q14
  //	O_L76_1PH8	O_Q14_1PH8
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00528" + sDB_Suffix;
  var sWhere = "O_Q14_1PH8 = '" + O_Q14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L76", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L76_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L76_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Filter für Sonderlüfter								O_Q14_1PH8			CB_O_Q14_1PH8				NICHT LEA
  // ################################################################################################################
  /* EDIT 11/2024 only direct input
    A: VT_1PH8_M00328	Q14-AH-MLFB11
        MLFB05_1PH8	MLFB11_1PH8	O_Q14_1PH8

    B: VT_1PH8_M00350	AH-G14-Q14-L74
        MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8

    C: VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8

    D: VT_1PH8_M00362	K80-Q14
        O_K69_K70_K71_K80_1PH8	O_Q14_1PH8

    E: VT_1PH8_M00528	L76-Q14
        O_L76_1PH8	O_Q14_1PH8
    */
  // NICHT LEA
  /*
  var sDTKAttribute = "O_Q14_1PH8";
  var sCB_Attribute = "CB_O_Q14_1PH8";

  // A:
  var sTable = "VT_1PH8_M00328" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q14", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00350	AH-G14-Q14-L74
  //	MLFB05_1PH8	O_G14_1PH8	O_Q14_1PH8	O_L74_1PH8
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";

  var sTable = "VT_1PH8_M00350" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_G14_1PH8 = '" + O_G14_1PH8 + "' AND " + "O_L74_1PH8 = '" + O_L74_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00361	L03-Q14-M39
  //	O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_L03_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L03_1PH8", "T")) O_L03_1PH8 = "L03";

  var sTable = "VT_1PH8_M00361" + sDB_Suffix;
  var sWhere = "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " + "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00362	K80-Q14
  //	O_K69_K70_K71_K80_1PH8	O_Q14_1PH8
  var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");

  var sTable = "VT_1PH8_M00362" + sDB_Suffix;
  var sWhere = "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // E:
  // VT_1PH8_M00528	L76-Q14
  //	O_L76_1PH8	O_Q14_1PH8
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00528" + sDB_Suffix;
  var sWhere = "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q14", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q14_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  */
  ECL_DeselectAttribute("CB_O_Q14_1PH8");

  // ################################################################################################################

  // ################################################################################################################
  // Schraubensicherung mit Loctite und verstärkte Lüfterausführung		O_L02_1PH8		CB_O_L02_1PH8	NICHT LEA
  // ################################################################################################################
  /*  L02 nur bei DI und AH 280, da immer konfig, nicht mehr relevant!
    
    A: VT_1PH8_M00597	L02-AH-MLFB11 Konfigtyp
        MLFB05_1PH8	MLFB11_1PH8	O_L02_1PH8	HMK_KONFIG_TYP_1PH8

    B: VT_1PH8_M00345	G00-G11-L02-K69-K71
        O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8

    C: VT_1PH8_M00496	L02 <> Q21
        O_L02_1PH8	O_Q21_1PH8
    * /
    // NICHT LEA und dann nur bei Direkteingabe, also nicht relevant. für 1PH8 ?
    if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
        var sDTKAttribute = "O_L02_1PH8";
        var sCB_Attribute = "CB_O_L02_1PH8";
        
        // A: 
        var sTable = "VT_1PH8_M00597" + sDB_Suffix;
        var sWhere = 	"MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + 
                        "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + 
                        "HMK_KONFIG_TYP_1PH8 = 'KONFIG';";
        
        var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L02", "F", sWhere, false);
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1PH8___PL_L02_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        // --------------------------------------------------------------------------------------------
        // B:
        // VT_1PH8_M00345	G00-G11-L02-K69-K71
        //	O_G00_B_G11_1PH8	O_L02_1PH8	O_K69_K70_K71_K80_1PH8
        var O_G00_B_G11_1PH8 		= ECL_GetValue("O_G00_B_G11_1PH8");
        var O_K69_K70_K71_K80_1PH8 	= ECL_GetValue("O_K69_K70_K71_K80_1PH8");
        
        var sTable = "VT_1PH8_M00345" + sDB_Suffix;
        var sWhere = 	"O_G00_B_G11_1PH8 = '" 	+ O_G00_B_G11_1PH8 + "' AND " + 
                        "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "';";
        
        var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L02", "F", sWhere, true);	// bIntersect = true
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1PH8___PL_L02_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        
        // --------------------------------------------------------------------------------------------
        // C:
        // VT_1PH8_M00496	L02 <> Q21
        //	O_L02_1PH8	O_Q21_1PH8
        var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
        
        var O_Q21_1PH8 = "F";
        if (ECL_ValueSelected("CB_O_Q21_1PH8", "T"))
            O_Q21_1PH8 = "Q21";
        
        var sTable = "VT_1PH8_M00496" + sDB_Suffix;
        var sWhere = "O_Q21_1PH8 = '" + O_Q21_1PH8 + "';";
        
        var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L02", "F", sWhere, true);	// bIntersect = true
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1PH8___PL_L02_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }else{
        ECL_DeselectAttribute("CB_O_L02_1PH8");
    }
    */
  // ################################################################################################################

  // ################################################################################################################
  // Prüfbescheinigung (für bestellten Motor)			O_B02_1PH8		CB_O_B02_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00426	AH-B02
        MLFB05_1PH8	O_B02_1PH8
    */
  var sDTKAttribute = "O_B02_1PH8";
  var sCB_Attribute = "CB_O_B02_1PH8";

  var sTable = "VT_1PH8_M00426" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B02", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_B02_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Werkprüfbescheinigung für Schwingungsprotokoll		O_B35_1002197		CB_O_B35_1002197
  // ################################################################################################################
  /*
    VT_1PH8_M00495	AH-MLFB14-B35
        MLFB05_1PH8	MLFB14_1PH8	O_B35_1002197
    */
  var sDTKAttribute = "O_B35_1002197";
  var sCB_Attribute = "CB_O_B35_1002197";

  var sTable = "VT_1PH8_M00495" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B35", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_B35_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Werkprüfbescheinigung für Rundlaufprotokoll			O_B36_1002197		CB_O_B36_1002197
  // ################################################################################################################
  /*
    VT_1PH8_M00438	AH-B36
        MLFB05_1PH8	O_B36_1002197
    */
  var sDTKAttribute = "O_B36_1002197";
  var sCB_Attribute = "CB_O_B36_1002197";

  var sTable = "VT_1PH8_M00438" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "B36", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_B36_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Zusätzliche Kaltleiterkette für Warnung und Abschaltung			O_A12_1PH8		CB_O_A12_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00333	A12-AH-MLFB15
        MLFB05_1PH8	MLFB15_1PH8	O_A12_1PH8

    VT_1PH8_M00342	A12-M03-M39-Q12-AH
        MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8

    */
  var sDTKAttribute = "O_A12_1PH8";
  var sCB_Attribute = "CB_O_A12_1PH8";

  var sTable = "VT_1PH8_M00333" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "A12", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_A12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00342	A12-M03-M39-Q12-AH
  //		MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_Q12_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_Q12_1PH8", "T")) O_Q12_1PH8 = "Q12";

  var sTable = "VT_1PH8_M00342" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " + "O_Q12_1PH8 = '" + O_Q12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "A12", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_A12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Zusätzlicher Temperatursensor als Reserve			O_A25_1PH8		CB_O_A25_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00369	A25-M03-M39
        O_A25_1PH8	O_M03_M39_1PH8

    VT_1PH8_M00370	A25-AH-MLFB15
        MLFB05_1PH8	MLFB15_1PH8	O_A25_1PH8
    */
  var sDTKAttribute = "O_A25_1PH8";
  var sCB_Attribute = "CB_O_A25_1PH8";

  // A:
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00369" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "A25", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_A25_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00370	A25-AH-MLFB15
  //	MLFB05_1PH8	MLFB15_1PH8	O_A25_1PH8

  var sTable = "VT_1PH8_M00370" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB15_1PH8 = '" + MLFB15_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "A25", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_A25_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  /*var O_A25_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_A25_1PH8", "T"))
        O_A25_1PH8 = "A25";
    */

  // ################################################################################################################
  // Messnippel für SPM, mit M8-Adapter			O_G50_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00427	AH-G50
        MLFB05_1PH8	O_G50_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_G50_1PH8";
  var sCB_Attribute = "CB_O_G50_1PH8";

  var sTable = "VT_1PH8_M00427" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G50", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_G50_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_G50_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // 2 Widerstandsthermometer PT1000 zur Wälzlagertemperaturüberwachung (DE und NDE)		O_A72_1002197	NICHT LEA
  // ################################################################################################################
  /* 
    VT_1PH8_M00436	AH-A72
        MLFB05_1PH8	O_A72_1002197
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_A72_1002197";
  var sCB_Attribute = "CB_O_A72_1002197";

  var sTable = "VT_1PH8_M00436" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "A72", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_A72_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_A72_1002197");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Wellenende			O_V90_V91_V92_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00591	V90-V92 RUMPF_050710_0811
        H_RUMPF_050710_0811_1PH8	O_V90_V91_V92_1PH8	HMK_VALUE_VALID_1PH8

    C: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
        MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
    

    B: VT_1PH8_M00368	U63-V92
        O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8

    n.n. keine Einschränkung durch Y64
    VT_1PH8_M00621
        MLFB05_1PH8 O_Y64_1PH8  O_V90_V91_V92_1PH8
    */
  // NICHT LEA (Ausschluss über VT368)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){

  var sTargetAttribute = "O_V90_V91_V92_1PH8";
  /* A: 
        VT_1PH8_M00591	V90-V92 RUMPF_050710_0811
            H_RUMPF_050710_0811_1PH8	O_V90_V91_V92_1PH8	HMK_VALUE_VALID_1PH8
        */
  var sTable = "VT_1PH8_M00591" + sDB_Suffix;
  var sWhere = "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " + "HMK_VALUE_VALID_1PH8 = 'T';";
  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_V90_V92_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
        VT_1PH8_M00368	U63-V92
            O_U60_BIS_U68_1PH8	O_V90_V91_V92_1PH8
        */
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");

  var sTable = "VT_1PH8_M00368" + sDB_Suffix;
  var sWhere = "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_V90_V92_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
        VT_1PH8_M00563	V90-V92-AH-MLFB13-14
            MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
        */
  var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");

  var sTable = "VT_1PH8_M00563" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_V90_V92_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_SetValue("O_V90_V91_V92_1PH8", "NON");
    }*/

  // ################################################################################################################

  // ################################################################################################################
  // Zweites Wellenende			O_K16_1PH8			CB_O_K16_1PH8										NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00308	K16-AH-MLFB09-11-12
        MLFB05_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_K16_1PH8

    VT_1PH8_M00348	K16-G80-H75
        O_K16_1PH8	O_G80_H56_H75_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_K16_1PH8";
  var sCB_Attribute = "CB_O_K16_1PH8";

  var sTable = "VT_1PH8_M00308" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K16", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K16_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00348	K16-G80-H75
  //	O_K16_1PH8	O_G80_H56_H75_1PH8
  var O_G80_H56_H75_1PH8 = ECL_GetValue("O_G80_H56_H75_1PH8");

  var sTable = "VT_1PH8_M00348" + sDB_Suffix;
  var sWhere = "O_G80_H56_H75_1PH8 = '" + O_G80_H56_H75_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K16", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K16_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_K16_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Ausführung mit Flanschgröße A400			O_K90_1PH8 		CB_O_K90_1PH8								NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00315	K90-AH-MLFB08-12
        MLFB05_1PH8	MLFB08_1PH8	MLFB12_1PH8	O_K90_1PH8

    VT_1PH8_M00364	K90-U63
        O_K90_1PH8	O_U60_BIS_U68_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_K90_1PH8";
  var sCB_Attribute = "CB_O_K90_1PH8";

  var sTable = "VT_1PH8_M00315" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " + "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K90", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K90_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00364	K90-U63
  //	O_K90_1PH8	O_U60_BIS_U68_1PH8
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");

  var sTable = "VT_1PH8_M00364" + sDB_Suffix;
  var sWhere = "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K90", "F", sWhere, true); // bIntersect = true
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K90_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_K90_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Welle aus Sonderstahl				O_L72_1002197													NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00442	AH-Kühlart-L72
        MLFB05_1PH8	MLFB11_1PH8	O_L72_1002197
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L72_1002197";
  var sCB_Attribute = "CB_O_L72_1002197";

  var sTable = "VT_1PH8_M00442" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L72", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L72_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L72_1002197");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Erweiterter Korrosionsschutz für Industrie-/Seeluftaufstellung		O_L29_1PH8		CB_O_L29_1PH8	NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00440	AH-Kühlart-L29
        MLFB05_1PH8	MLFB11_1PH8	O_L29_1PH8
    
    nur für AH 280 und Kühlung NDE--> DE (MLFB11 in (1,4)
    
    damit nicht LEA
    todo für 1PH8_L
    */
  // if (MLFB05_1PH8 == "28"){
  var sDTKAttribute = "O_L29_1PH8";
  var sCB_Attribute = "CB_O_L29_1PH8";

  var sTable = "VT_1PH8_M00440" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L29", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L29_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L29_1PH8");
        ECL_DisableAttribute("CB_O_L29_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Nachschmiereinrichtung				O_K40_1PH8												nur L, NICHT LEA
  // ################################################################################################################
  /*
    K40	DE und NDE
    STD DE und NDE (Standard)
    NON Ohne
    
    VT_1PH8_M00311	K40-AH
        MLFB05_1PH8	O_K40_1PH8
    */
  //if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_L"){
  var sTargetAttribute = "O_K40_1PH8";

  var sTable = "VT_1PH8_M00311" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K40_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeactivateAllAttributeValues("O_K40_1PH8");
        ECL_ActivateValue("O_K40_1PH8", "NON");
        ECL_SetValue("O_K40_1PH8", "NON");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Radialwellendichtring DE				O_K18_1PH8
  // ################################################################################################################
  /*
    A: VT_1PH8_M00343	M03-M39-U60-U68-K18
        O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8

    B: VT_1PH8_M00353	AH-G14-K18
        MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8

    C: VT_1PH8_M00354	G00-G11-K18
        O_G00_B_G11_1PH8	O_K18_1PH8

    D: VT_1PH8_M00568	K18-AH-MLFB08-11-14
        MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_MLFB_05_11_1PH8	MLFB14_1PH8	O_K18_1PH8
    */
  var sDTKAttribute = "O_K18_1PH8";
  var sCB_Attribute = "CB_O_K18_1PH8";

  // A:
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");

  var sTable = "VT_1PH8_M00343" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "' AND " + "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K18", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K18_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00353	AH-G14-K18
  //	MLFB05_1PH8	O_G14_1PH8	O_K18_1PH8
  var O_G14_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_G14_1PH8", "T")) O_G14_1PH8 = "G14";

  var sTable = "VT_1PH8_M00353" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_G14_1PH8 = '" + O_G14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K18", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K18_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00354	G00-G11-K18
  //	O_G00_B_G11_1PH8	O_K18_1PH8
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");

  var sTable = "VT_1PH8_M00354" + sDB_Suffix;
  var sWhere = "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K18", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K18_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00568	K18-AH-MLFB08-11-14
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_MLFB_05_11_1PH8	MLFB14_1PH8	O_K18_1PH8

  var sTable = "VT_1PH8_M00568" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"HMK_RUMPF_MLFB_05_11_1PH8 = '" + HMK_RUMPF_MLFB_05_11_1PH8 + "' AND " + // entweder oder
    "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K18", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K18_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Zusätzliche Abdrückgewinde an Motorfüßen			O_M83_1PH8		CB_O_M83_1PH8						NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00519	M83-AH-MLFB12
        MLFB05_1PH8	MLFB11_1PH8	HMK_RUMPF_MLFB_05_11_1PH8	MLFB12_1PH8	O_M83_1PH8
    */
  // NICHT LEA (Ausschluss erfolgt über AH (MLFB05) in VT519)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_M83_1PH8";
  var sCB_Attribute = "CB_O_M83_1PH8";

  var sTable = "VT_1PH8_M00519" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    //"HMK_RUMPF_MLFB_05_11_1PH8 = '" + HMK_RUMPF_MLFB_05_11_1PH8 + "' AND " + // entweder oder
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M83", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_M83_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_M83_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Stillstandsheizung AC 230 V			O_K45_1PH8		CB_O_K45_1PH8									NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00313	K45-AH
        MLFB05_1PH8	O_K45_1PH8

    VT_1PH8_M00356	K45-M39
        O_K45_1PH8	O_M03_M39_1PH8
    */
  // NICHT LEA (Ausschluss erfolgt über AH (MLFB05) in VT313)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_K45_1PH8";
  var sCB_Attribute = "CB_O_K45_1PH8";

  var sTable = "VT_1PH8_M00313" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K45", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K45_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00356	K45-M39
  //	O_K45_1PH8	O_M03_M39_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00356" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K45", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K45_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_K45_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Sperrluftanschluss			O_Q12_1PH8			CB_O_Q12_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00327	Q12-AH
        MLFB05_1PH8	O_Q12_1PH8

    VT_1PH8_M00342	A12-M03-M39-Q12-AH
        MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
    */
  var sDTKAttribute = "O_Q12_1PH8";
  var sCB_Attribute = "CB_O_Q12_1PH8";

  var sTable = "VT_1PH8_M00327" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q12", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00342	A12-M03-M39-Q12-AH
  //	MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
  var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var O_A12_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_A12_1PH8", "T")) O_A12_1PH8 = "A12";

  var sTable = "VT_1PH8_M00342" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_A12_1PH8 = '" + O_A12_1PH8 + "' AND " + "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q12", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Schraubensicherung mit Loctite			O_Q21_1PH8			CB_O_Q21_1PH8
  // ################################################################################################################
  /*
    VT_1PH8_M00428	AH-Q21
        MLFB05_1PH8	O_Q21_1PH8

    VT_1PH8_M00496	L02 <> Q21
        O_L02_1PH8	O_Q21_1PH8
    */
  var sDTKAttribute = "O_Q21_1PH8";
  var sCB_Attribute = "CB_O_Q21_1PH8";

  var sTable = "VT_1PH8_M00428" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q21", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q21_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00496	L02 <> Q21
  //	O_L02_1PH8	O_Q21_1PH8
  var O_L02_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L02_1PH8", "T")) O_L02_1PH8 = "L02";

  var sTable = "VT_1PH8_M00496" + sDB_Suffix;
  var sWhere = "O_L02_1PH8 = '" + O_L02_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q21", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q21_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // Kondenswasserbohrung			O_L12_1PH8		CB_O_L12_1PH8											NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00318	L12-AH-MLFB11-12
        MLFB05_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_L12_1PH8

    VT_1PH8_M00367	L12-M39
        O_L12_1PH8	O_M03_M39_1PH8
    */
  // NICHT LEA (Ausschluss erfolgt über AH (MLFB05) in VT318)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L12_1PH8";
  var sCB_Attribute = "CB_O_L12_1PH8";

  var sTable = "VT_1PH8_M00318" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " + "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L12", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // VT_1PH8_M00367	L12-M39
  //	O_L12_1PH8	O_M03_M39_1PH8
  //var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00367" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L12", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L12_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L12_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Erhöhte Rüttelbeanspruchung			O_L03_1PH8			CB_O_L03_1PH8								NICHT LEA
  // ################################################################################################################
  /*
    A: VT_1PH8_M00317	L03-AH-MLFB08-09-11-12
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB12_1PH8	O_L03_1PH8

    B: VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8

    C: VT_1PH8_M00366	L03-U63
        O_L03_1PH8	O_U60_BIS_U68_1PH8

    D: VT_1PH8_M00525	L03-L74-L75-L76
        O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
    */
  // NICHT LEA (Ausschluss erfolgt über AH (MLFB05) in VT317)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L03_1PH8";
  var sCB_Attribute = "CB_O_L03_1PH8";

  // A:
  var sTable = "VT_1PH8_M00317" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L03_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00361	L03-Q14-M39
  //	O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8

  //var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");
  var O_Q14_1PH8 = "F";
  //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T")) O_Q14_1PH8 = "Q14";

  var sTable = "VT_1PH8_M00361" + sDB_Suffix;
  var sWhere = "O_Q14_1PH8 = '" + O_Q14_1PH8 + "' AND " + "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L03_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00366	L03-U63
  //	O_L03_1PH8	O_U60_BIS_U68_1PH8
  var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");

  var sTable = "VT_1PH8_M00366" + sDB_Suffix;
  var sWhere = "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L03_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // D:
  // VT_1PH8_M00525	L03-L74-L75-L76
  //	O_L03_1PH8	O_L74_1PH8	O_L75_1PH8	O_L76_1PH8
  var O_L74_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L74_1PH8", "T")) O_L74_1PH8 = "L74";
  var O_L75_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L75_1PH8", "T")) O_L75_1PH8 = "L75";
  var O_L76_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L76_1PH8", "T")) O_L76_1PH8 = "L76";

  var sTable = "VT_1PH8_M00525" + sDB_Suffix;
  var sWhere = "O_L74_1PH8 = '" + O_L74_1PH8 + "' AND " + "O_L75_1PH8 = '" + O_L75_1PH8 + "' AND " + "O_L76_1PH8 = '" + O_L76_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L03_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L03_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Vorbereitung für lagerlosen Drehverteiler			O_Y64_1PH8		CB_O_Y64_1PH8					NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00334	Y64-AH-MLFB13
        MLFB05_1PH8	MLFB13_1PH8	O_Y64_1PH8

    VT_1PH8_M00365	Y64-M03-M39
        O_Y64_1PH8	O_M03_M39_1PH8
    
    VT_1PH8_M00621
        MLFB05_1PH8 O_Y64_1PH8  O_V90_V91_V92_1PH8
    */
  // NICHT LEA
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){ //EDIT 9/23 Einscghränkung auch für Synchron über MLFB13 und VT255 (MLRB08+13)
  var sDTKAttribute = "O_Y64_1PH8";
  var sCB_Attribute = "CB_O_Y64_1PH8";

  // A:
  var sTable = "VT_1PH8_M00334" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + sWhereMLFB13 + ";";
  //"MLFB13_1PH8 = '" + MLFB13_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Y64", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Y64_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00365	Y64-M03-M39
  //	O_Y64_1PH8	O_M03_M39_1PH8

  //var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00365" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Y64", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Y64_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // C:
  // VT_1PH8_M00621
  //  MLFB05_1PH8 O_Y64_1PH8  O_V90_V91_V92_1PH8

  var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");

  var sTable = "VT_1PH8_M00621" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Y64", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Y64_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_Y64_1PH8");
    }*/
  // ################################################################################################################

  // ################################################################################################################
  // Labyrinthdichtung DE für Performance-Ausführung			O_K17_1002197								NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00441	AH-Antriebsart-K17
        MLFB05_1PH8	MLFB14_1PH8	O_K17_1002197
    */
  // NICHT LEA (Ausschluss erfolgt über AH in VT441)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_K17_1002197";
  var sCB_Attribute = "CB_O_K17_1002197";

  var sTable = "VT_1PH8_M00441" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K17", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_K17_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_K17_1002197");
    }*/

  // ################################################################################################################

  // ################################################################################################################
  // Erhöhte Lageranstellung			O_Q81_1002197
  // ################################################################################################################
  /*
    VT_1PH8_M00521	AH-MLFB14-Q81
        MLFB05_1PH8	MLFB14_1PH8	O_Q81_1002197
    */
  var sDTKAttribute = "O_Q81_1002197";
  var sCB_Attribute = "CB_O_Q81_1002197";

  var sTable = "VT_1PH8_M00521" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " + "MLFB14_1PH8 = '" + MLFB14_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q81", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_Q81_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################

  // ################################################################################################################
  // NDE-Lager in isolierter Ausführung			O_L27_1PH8		CB_O_L27_1PH8							NICHT LEA
  // ################################################################################################################
  /*
    VT_1PH8_M00439	AH-L27
        MLFB05_1PH8	O_L27_1PH8

    VT_1PH8_M00540	L27-M39
        O_L27_1PH8	O_M03_M39_1PH8
    */
  // NICHT LEA (Ausschluss erfolgt über AH in VT439)
  //if (HMK_PRODUKT_TRIG_1PH8 != "1PH8_LEA"){
  var sDTKAttribute = "O_L27_1PH8";
  var sCB_Attribute = "CB_O_L27_1PH8";

  var sTable = "VT_1PH8_M00439" + sDB_Suffix;
  var sWhere = "MLFB05_1PH8 = '" + MLFB05_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L27", "F", sWhere, false);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L27_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00540	L27-M39
  //	O_L27_1PH8	O_M03_M39_1PH8

  //var O_M03_M39_1PH8 = ECL_GetValue("O_M03_M39_1PH8");

  var sTable = "VT_1PH8_M00540" + sDB_Suffix;
  var sWhere = "O_M03_M39_1PH8 = '" + O_M03_M39_1PH8 + "';";

  var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L27", "F", sWhere, true);
  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH8___PL_L27_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  /*}else{
        ECL_DeselectAttribute("CB_O_L27_1PH8");
    }*/
  // ################################################################################################################
  // ################################################################################################################

  // ################################################################################################################
  // Drive Trains
  // ################################################################################################################
  /*
  AH nicht 22 und nicht 28
	
  Wicklungsausführung nicht 'N'
	
  Kühlung - Fremdbelüftung DE-->NDE (0)/NDE-->DE (1), Wasserkühlung (2); Durchzugsbelüftung DE-->NDE (3); Durchzugsbelüftung NDE-->DE (4)
    nur 0,1
	
  Bauform - B3 (0), B5 (2), B35 (3)
    nicht 0
    siehe oben "Bauform der drehenden elektrischen Maschine / gemäß Code I		PMD_AAC949_001_000_1PH8"
	
  Wellenende - glatte Welle (0), Passfeder Vollkeilwuchtung (1), Passfeder Halbkeilwuchtung (2), glatte Hohlwelle (3)
    0 für AH 80, 100
    2 für AH > 100
	
  Lagerung - Performance (L), High Performance (M), Advanced Lifetime (Q)
    nicht L,M
	
  // -------------------------------------------------
  // OPTIONEN
  // -------------------------------------------------
  A	B02	nein	"Werkprüfbescheinigung nach EN 10204 2.3 (für bestellten Motor)"
  B	B35	nein	Werkprüfbescheinigung für Schwingungsprotokoll
  C	B36	nein	Werkprüfbescheinigung für Rundlaufprotokoll
  D	G00	nein	Fremdlüfteroption; nur bei AH280
    G02	nein	Fremdlüfteroption; nur bei AH280
    G06	nein	Fremdlüfteroption; nur bei AH280
    G07	nein	Fremdlüfteroption; nur bei AH280
    G08	nein	Fremdlüfteroption; nur bei AH280
    G09	nein	Fremdlüfteroption; nur bei AH280
  D	G11	nein	Fremdlüfteroption; nur bei AH280
  E	G80	nein	beigestellter Geber; nur bei AH280
  E	H56	nein	beigestellter Geber; nur bei AH280
  E	H75	nein	beigestellter Geber; nur bei AH280
  F	K16	nein	6 Zweites Wellenende;  nur bei AH280
  G	K69	nein	Rohranschluß; nur beí AH280
  G	K70	nein	Rohranschluß; nur beí AH280
  G	K71	nein	Rohranschluß; nur beí AH280
  G	K80	ja		Axialer Rohranschluss NDE (nur möglich bei Fremdbelüftung)
  W	K90	nein	Ausführung mit Flanschgröße A400; nur bei AH180 möglich
  F	L03	?		Erhöhte Rüttelbeanspruchung
  (G)	L37	nein	Erhöhte Maximaldrehzahl (AH 80: 12.000 min-1, AH 100: 10.000 min-1
  (H)	L29	nein	Erweiterter Korrosionsschutz; nur beí AH280
  I	L72	nein	Welle aus Sonderstah; nur beí AH280
  J	M03	nein	ATEX
  J	M39	nein	ATEX
  K	M83	nein	Zusätzliche Abdrückgewinde an Motorfüßen;  nur beí AH280
  L	Q00	nein	Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten;  nur beí AH280
  (M)	Q52	nein	Flansch für Bauform IM B5 mit 4 x M8 Gewindebohrungen
  N	V90	nein	1PH7-kompatibles Wellenende
  N	V91	nein	1FT6-kompatibles Wellenende 
  N	V92	nein	1PH7184-/1PL6184-kompatibles Wellenende
  (O)	Y94	nein	Hohlwelle vorbereitet für lagerlose Drehverteiler
  P	Y82	nein	Zusatzschild mit Bestellerangaben
  Q	Y84	nein	Kundenangabe auf dem Leistungsschild
  R	X01…X91	nein	Lackierung in RAL…
  S	K23	nein	Sonder-Lackierung Worldwide
  T	K24	ja	Grundierung	muss als Default gesetzt werden und darf nicht abwählbar sein. Keine anderen Lackierungsoptionen auswählbar machen.
	
  U	G14	ja	Mit Luftfilter (nur möglich bei 11. Datenstelle "1" oder "4")
  V	K08	ja	"Geberstecker- oder DRIVE-CLiQ-Anbau gegenüberliegend (nicht möglich bei 15. Datenstelle ""X"")"
	
  */

  if (IsDriveTrain) {
    // ----------------------------------------------------------------------------------------
    // A	B02	nein	"Werkprüfbescheinigung nach EN 10204 2.3 (für bestellten Motor)"
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_B02_1PH8");
    ECL_DisableAttribute("CB_O_B02_1PH8");

    // ----------------------------------------------------------------------------------------
    // B	B35	nein	Werkprüfbescheinigung für Schwingungsprotokoll
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_B35_1002197");
    ECL_DisableAttribute("CB_O_B35_1002197");

    // ----------------------------------------------------------------------------------------
    // C	B36	nein	Werkprüfbescheinigung für Rundlaufprotokoll
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_B36_1002197");
    ECL_DisableAttribute("CB_O_B36_1002197");

    // ----------------------------------------------------------------------------------------
    // D	G00...G11	nein	Fremdlüfteroption; nur bei AH280
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_G00_B_G11_1PH8";
    var aValidValues = ["NON", "G10"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // E	G80	nein	beigestellter Geber; nur bei AH280
    // E	H56	nein	beigestellter Geber; nur bei AH280
    // E	H75	nein	beigestellter Geber; nur bei AH280
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_G80_H56_H75_1PH8";
    var aValidValues = ["NON"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // F	K16	nein	6 Zweites Wellenende;  nur bei AH280
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_K16_1PH8");
    ECL_DisableAttribute("CB_O_K16_1PH8");

    // ----------------------------------------------------------------------------------------
    // G	K69	nein	Rohranschluß; nur beí AH280
    // G	K70	nein	Rohranschluß; nur beí AH280
    // G	K71	nein	Rohranschluß; nur beí AH280
    // G	K80	ja		Axialer Rohranschluss NDE (nur möglich bei Fremdbelüftung)
    //					==> PMD_AAA136_001_000_1PH8 == 00001 || 00002
    // ----------------------------------------------------------------------------------------
    var PMD_AAA136_001_000_1PH8 = ECL_GetValue("PMD_AAA136_001_000_1PH8");

    var sTargetAttribute = "O_K69_K70_K71_K80_1PH8";
    var aValidValues = ["NON"];
    if (PMD_AAA136_001_000_1PH8 == "00001" || PMD_AAA136_001_000_1PH8 == "00002") {
      var aValidValues = ["NON", "K80"];
    }
    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // W	K90	nein	Ausführung mit Flanschgröße A400; nur bei AH180 möglich
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_K90_1PH8");
    ECL_DisableAttribute("CB_O_K90_1PH8");

    // ----------------------------------------------------------------------------------------
    // F	L03	?	Erhöhte Rüttelbeanspruchung
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_L03_1PH8");
    ECL_DisableAttribute("CB_O_L03_1PH8");

    // ----------------------------------------------------------------------------------------
    // (G)	L37	nein	Erhöhte Maximaldrehzahl (AH 80: 12.000 min-1, AH 100: 10.000 min-1
    // ----------------------------------------------------------------------------------------
    // gibt es nicht / nicht abgebildet

    // ----------------------------------------------------------------------------------------
    // (H)	L29	nein	Erweiterter Korrosionsschutz; nur beí AH280
    // ----------------------------------------------------------------------------------------
    // gibt es nicht / nicht abgebildet

    // ----------------------------------------------------------------------------------------
    // I	L72	nein	Welle aus Sonderstah; nur beí AH280
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_L72_1002197");
    ECL_DisableAttribute("CB_O_L72_1002197");

    // ----------------------------------------------------------------------------------------
    // J	M03	nein	ATEX
    // J	M39	nein	ATEX
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_M03_M39_1PH8";
    var aValidValues = ["NON"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // K	M83	nein	Zusätzliche Abdrückgewinde an Motorfüßen;  nur beí AH280
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_M83_1PH8");
    ECL_DisableAttribute("CB_O_M83_1PH8");

    // ----------------------------------------------------------------------------------------
    // L	Q00	nein	Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten;  nur beí AH280
    // ----------------------------------------------------------------------------------------
    ECL_DeselectAttribute("CB_O_Q00_1PH8");
    ECL_DisableAttribute("CB_O_Q00_1PH8");

    // ----------------------------------------------------------------------------------------
    // (M)	Q52	nein	Flansch für Bauform IM B5 mit 4 x M8 Gewindebohrungen
    // ----------------------------------------------------------------------------------------
    // nicht abgebildet
    //ECL_DeselectAttribute("CB_O_Q52_1PH8");
    //ECL_DisableAttribute("CB_O_Q52_1PH8");

    // ----------------------------------------------------------------------------------------
    // N	V90	nein	1PH7-kompatibles Wellenende
    // N	V91	nein	1FT6-kompatibles Wellenende
    // N	V92	nein	1PH7184-/1PL6184-kompatibles Wellenende
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_V90_V91_V92_1PH8";
    var aValidValues = ["NON"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // (O)	Y94	nein	Hohlwelle vorbereitet für lagerlose Drehverteiler
    // ----------------------------------------------------------------------------------------
    // nicht abgebildet / nicht verwendet

    // ----------------------------------------------------------------------------------------
    // (P)	Y82	nein	Zusatzschild mit Bestellerangaben		O_Y82_1002197
    // ----------------------------------------------------------------------------------------
    // nicht abgebildet / nicht verwendet

    // ----------------------------------------------------------------------------------------
    // Q	Y84	nein	Kundenangabe auf dem Leistungsschild		O_Y84_1PH8
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_Y84_1PH8";
    var aValidValues = ["F"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }

    // ----------------------------------------------------------------------------------------
    // R	X01…X91	nein	Lackierung in RAL…
    // S	K23	nein	Sonder-Lackierung Worldwide
    // T	K24	ja	Grundierung	muss als Default gesetzt werden und darf nicht abwählbar sein. Keine anderen Lackierungsoptionen auswählbar machen.
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "O_X01__X27_1PH8";
    var PMD_ABP663_001_000_1002197 = ECL_GetValue("PMD_ABP663_001_000_1002197");
    var sTable = "VT_1PH8_M00500" + sDB_Suffix;
    var sSQL = "SELECT O_X01__X27_1PH8 FROM " + sTable + " WHERE " +
      "PMD_ABP663_001_000_1002197 = " + PMD_ABP663_001_000_1002197 + " AND " +
      "(O_X01__X27_1PH8 = 'OHNE' OR O_X01__X27_1PH8 = 'OHNE2');";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var O_X01__X27_1PH8 = aResult[0].O_X01__X27_1PH8;
    }

    var aValidValues = [O_X01__X27_1PH8];

    var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
    var test = ECL_GetAllActiveAttributeValues("O_X01__X27_1PH8");
    // ----------------------------------------------------------------------------------------
    // S	K23	nein	Sonder-Lackierung Worldwide
    ECL_DeselectAttribute("CB_O_K23_1PH8");
    ECL_DisableAttribute("CB_O_K23_1PH8");
    // ----------------------------------------------------------------------------------------
    // T	K24	ja	Grundierung	muss als Default gesetzt werden und darf nicht abwählbar sein. Keine anderen Lackierungsoptionen auswählbar machen.
    ECL_SelectValue("CB_O_K24_1PH8", "T");
    ECL_DisableAttribute("CB_O_K24_1PH8");

    // ----------------------------------------------------------------------------------------
    // U	G14	ja	Mit Luftfilter (nur möglich bei 11. Datenstelle "1" oder "4")
    // ----------------------------------------------------------------------------------------
    // CB_O_G14_1PH8
    if (MLFB11_1PH8 != "1" && MLFB11_1PH8 != "4") {
      ECL_DeselectAttribute("CB_O_G14_1PH8");
      ECL_DisableAttribute("CB_O_G14_1PH8");
    }
    // ----------------------------------------------------------------------------------------
    // V	K08	ja	"Geberstecker- oder DRIVE-CLiQ-Anbau gegenüberliegend (nicht möglich bei 15. Datenstelle ""X"")"	O_K08_1PH8
    // ----------------------------------------------------------------------------------------
    if (MLFB15_1PH8 == "X") {
      var sTargetAttribute = "O_K08_1PH8";
      var aValidValues = ["F"];

      var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

      if (sStatus == "Error") {
        // Fehler
        strError = ECL_Translate("DICT1_ERR_1LE___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
        return strError;
      }
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // Set n_max_total
  // ################################################################################################################
  /*
  get lowest value of n_max
  HMK_N_MAX_T_1PH8	  Maximale Drehzahl gesamt

  HMK_N_MAX_TC_1PH8	  Maximale Drehzahl Bauform
  HMK_N_MAX_B_1PH8	  Maximale Drehzahl Lagerung
  HMK_N_MAX_BR_1PH8	  Maximale Drehzahl Haltebremse
  HMK_N_MAX_G_1PH8	  Maximale Drehzahl Geber
  HMK_N_MAX_M03_1PH8	Maximale Drehzahl M03
  
  
  
  */
  var HMK_N_MAX_T_1PH8 = 24000;
  var HMK_N_MAX_TC_1PH8 = parseInt(ECL_GetValue("HMK_N_MAX_TC_1PH8"));
  var HMK_N_MAX_B_1PH8 = parseInt(ECL_GetValue("HMK_N_MAX_B_1PH8"));
  var HMK_N_MAX_BR_1PH8 = parseInt(ECL_GetValue("HMK_N_MAX_BR_1PH8"));
  var HMK_N_MAX_G_1PH8 = parseInt(ECL_GetValue("HMK_N_MAX_G_1PH8"));
  var HMK_N_MAX_M03_1PH8 = parseInt(ECL_GetValue("HMK_N_MAX_M03_1PH8"));

  if (HMK_N_MAX_TC_1PH8 > 0 && HMK_N_MAX_TC_1PH8 < HMK_N_MAX_T_1PH8) {
    HMK_N_MAX_T_1PH8 = HMK_N_MAX_TC_1PH8;
  }
  if (HMK_N_MAX_B_1PH8 > 0 && HMK_N_MAX_B_1PH8 < HMK_N_MAX_T_1PH8) {
    HMK_N_MAX_T_1PH8 = HMK_N_MAX_B_1PH8;
  }
  if (HMK_N_MAX_BR_1PH8 > 0 && HMK_N_MAX_BR_1PH8 < HMK_N_MAX_T_1PH8) {
    HMK_N_MAX_T_1PH8 = HMK_N_MAX_BR_1PH8;
  }
  if (HMK_N_MAX_G_1PH8 > 0 && HMK_N_MAX_G_1PH8 < HMK_N_MAX_T_1PH8) {
    HMK_N_MAX_T_1PH8 = HMK_N_MAX_G_1PH8;
  }
  if (HMK_N_MAX_M03_1PH8 > 0 && HMK_N_MAX_M03_1PH8 < HMK_N_MAX_T_1PH8) {
    HMK_N_MAX_T_1PH8 = HMK_N_MAX_M03_1PH8;
  }
  ECL_DeactivateAllAttributeValues("HMK_N_MAX_T_1PH8");
  ECL_ActivateValue("HMK_N_MAX_T_1PH8", HMK_N_MAX_T_1PH8);
  ECL_SelectValue("HMK_N_MAX_T_1PH8", HMK_N_MAX_T_1PH8);

  // ################################################################################################################



  // ################################################################################################################
  // ################################################################################################################

  return "OK";
}
