//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetWellenende_Init(oData)
{
    /*
    MLFB 13 Wellenende
    PMD_AAA506_001_000_1PH8			Ausführung des Wellenendes / an der Antriebsseite
    
    in BasisMotorDaten, Lagerung
    PMD_AAB007_001_000_1PH8			Schwinggrößenstufe									Default A, 00005 
    TAK_AAJ730_001_000_1PH8			Wellen- und Flanschgenauigkeit						Default 00003, N
    
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_Wellenende_MLFB13(oData);
    } else {
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1PH8","00001");	// glatte Welle
    }
}

function SetWellenende(strchangedAttribute, oData)
{
    
}
/**

*/
function Bestimme_Wellenende_MLFB13(oData)
{
    // MLFB 13
    var MLFB13_1PH8 = oData.oParsingData.MLFB.MLFB13;
    
    /*
    VT_1PH8_M00503
    MLFB13_1PH8		PMD_AAA506_001_000_1PH8		HMK_VALUE_VALID_1PH8
    */
    var sTable = "VT_1PH8_M00503" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAA506_001_000_1PH8 FROM "+sTable+" WHERE " +
                "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var sWellenende = aResult[0].PMD_AAA506_001_000_1PH8;
        
        //ECL_DeactivateAllAttributeValues("PMD_AAA506_001_000_1PH8");
        ECL_ActivateValue("PMD_AAA506_001_000_1PH8", sWellenende);
        ECL_SelectValue("PMD_AAA506_001_000_1PH8", sWellenende);
        
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_WELLENENDE");
    }
    
}

/*
VT_1PH8_M00503
MLFB13_1PH8		PMD_AAA506_001_000_1PH8		HMK_VALUE_VALID_1PH8
0				00001						T    
2				00002						T    
3				00003						T    
1				00004						T    
*/