//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1PH8_MLFB/Base.misc.js"

/**
 * @category   1PH8 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2020 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB, HMK_PRODUKT_TRIG_1PH8) {
  vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
  if (ECSI_CX_IsDriveTrain == "true" || ECSI_CX_IsDriveTrain == "1") {
    var IsDriveTrain = true;
  }

  var ECSI_CX_GearboxMotorCoupling = ECL_GetValue(
    "ECSI_CX_GearboxMotorCoupling"
  );
  if (
    ECSI_CX_GearboxMotorCoupling == "true" ||
    ECSI_CX_GearboxMotorCoupling == "1"
  ) {
    var IsGearboxMotorCoupling = true;
  }

  var bBrake = false;

  var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
  if (strwithBrake == "1") {
    bBrake = true;
  }

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  var MLFB05_BT = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
  var MLFB10_BT = strBaseTypeMLFB.charAt(9);

  // DriveTrains AH
  if (IsDriveTrain && (MLFB05_BT == "22" || MLFB05_BT == "22")) {
    // not allowed
    oParsing.strError = "ERRORMSG_MLFB_1PH8___INVALID_AH_DRIVETRAIN";
    return oParsing;
  }
  // DriveTrains Wicklung
  if (IsDriveTrain && MLFB10_BT == "N") {
    // not allowed
    oParsing.strError = "ERRORMSG_MLFB_1PH8___INVALID_MLFB10_N_DRIVETRAIN";
    return oParsing;
  }

  // DriveTrains: Kühlart only 0,1
  var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);
  //var ECSI_CX_CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor") || "";
  if (IsDriveTrain && sBT_MLFB11 !== "0" && sBT_MLFB11 !== "1") {
    oParsing.strError = "DICT1_ERR_1PH8___CX_COOLING_NOT_SUPPORTED_DRIVETRAIN";
    return oParsing;
  }

  // MLFB Freitexte
  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  // Kurzangaben aus MLFB
  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_1PH8___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_1PH8___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (oParsing.strBaseMLFB.indexOf("1PH8") < 0) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_1PH8___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var bCoolingInMLFB = false;

  // fix sind MLFB1-8 + 10, 11
  if (strBaseTypeMLFB.charAt(10) == ".") {
    var strMLFB_fix = strMLFB.substring(0, 8) + "." + strMLFB.substring(9, 10);
    bCoolingInMLFB = false;
  } else {
    var strMLFB_fix = strMLFB.substring(0, 8) + "." + strMLFB.substring(9, 11);
    bCoolingInMLFB = true;
  }

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

  if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
    strStartConfiguration = "1";

  if (strStartConfiguration == "1") {
    // entweder unvollständige MLFB, also Defaults setzen oder KEEP-Configuration-Fall,
    // dann muss die MLFB aber vollständig spezifiziert sein!
    //und eine zur Haupt MLFB unterschiedliche Base Type MLFB übergeben werden.
    //Hier sollen dann möglichst viele Attribute beibehalten werden.
    if (strBaseTypeMLFB != "") {
      /* fixe-BaseTypeMLFB für Abgleich mit MLFB
            1PH81861.D{.,0,1,2???}.....
            */
      if (bCoolingInMLFB) {
        var strBaseTypeMLFB_fix =
          strBaseTypeMLFB.substring(0, 8) +
          "." +
          strBaseTypeMLFB.substring(9, 11);
      } else {
        var strBaseTypeMLFB_fix =
          strBaseTypeMLFB.substring(0, 8) +
          "." +
          strBaseTypeMLFB.substring(9, 10);
      }
    }

    // EDIT RepairConfig added
    if (
      strStartConfiguration == "1" &&
      strBaseTypeMLFB_fix == strMLFB_fix &&
      strBaseTypeMLFB != "" &&
      find(strMLFB.left(16), ".") < 0
    ) {
      // if same motor is selected again
      var bRepairConfig = true;
    }

    // Abgleich BT (BaseTypeMLFB) und MLFB für Keep Configuration
    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if (
      (strBaseTypeMLFB != strMLFB && find(strMLFB.left(16), ".") < 0) ||
      bRepairConfig
    ) {
      // #################################################################################################################
      // KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION
      // #################################################################################################################
      //--------------------------------------------------------------------------------------------------------
      // Base-Type-MLFB aufbereiten
      //--------------------------------------------------------------------------------------------------------

      var aBTComponents = tokenize(strBaseTypeMLFB);
      if (aBTComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
          aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
        }
      }

      strBaseTypeMLFB = aBTComponents[0];

      if (strBaseTypeMLFB.length === 17) {
        // eliminate the -Z
        strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
      }

      // -----------------------------------------------------------------------------------------------
      // KAG abgleichen und ggf übernehmen/entfernen
      // -----------------------------------------------------------------------------------------------
      /* mögliche Platzhalter
                MLFB09		Geber + MLFB16
                MLFB12		Bauform
                MLFB13		Wellenende
                MLFB14		Lagerung
                MLFB15		Anschlusstechnik
                MLFB16		Version + DQ
            */

      // -----------------------------------------------------------------------------------------------
      // Platzhalter aus MLFB in BT übernehmen
      // -----------------------------------------------------------------------------------------------

      // ---------------------------------------------------------------------------------------------------
      // MLFB09 Geber
      // ---------------------------------------------------------------------------------------------------
      /* ECSI_CX_EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0		Incremental
                1		Absolute
                
            A	Ohne Geber
            E	Absolutwertgeber EnDat 2048 S/R (Encoder AM2048S/R)
            F	Absolutwertgeber 22 bit Singleturn + 12 bit Multiturn (Encoder AM22DQ)
            
            ohne DriveCLiQ
            H	Inkrementalgeber HTL 1024 S/R (Encoder HTL 1024S/R)
            J	Inkrementalgeber HTL 2048 S/R (Encoder HTL 2048S/R)
            M	Inkrementalgeber sin/cos 1 Vpp 2048 S/R mit C- und D-Spur (Encoder IC2048S/R)
            T	Inkrementalgeber sin/cos 1 Vpp 512 S/R ohne C- und D-Spur (Encoder N512S/R)
            C	Inkrementalgeber sin/cos 1 Vpp 256 S/R ohne C- und D-Spur (Encoder IN256S/R)
            G	Inkrementalgeber HTL1024 S/R mit Hohlwelle HOG 22
            K	Inkrementalgeber HTL1024 S/R mit Vollwelle POG 10
            W	Inkrementalgeber HTL 1024 S/R (Encoder HTL1024S/R) mit Anschluss über zusätzlichen Klemmenkasten
            Y	Inkrementalgeber HTL 2048 S/R (Encoder HTL2048S/R) mit Anschluss über zusätzlichen Klemmenkasten
            
            mit DriveCLiQ
            D	Inkrementalgeber 22 bit mit Kommutierungslage (Encoder IC22DQ)
            U	Inkrementalgeber 20 bit ohne Kommutierungslage (Encoder IN20DQ)
            S	Inkrementalgeber 19 bit ohne Kommutierungslage (Encoder IN19DQ)
            */

      var sMLFB09 = strMLFB.charAt(8);
      var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);
      var sMLFB16 = strMLFB.charAt(15);
      var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

      if (sBT_MLFB09 == ".") {
        // default ohne
        /* todo keep config: check_MLFB09
         */
        var ECSI_CX_EncoderTypeRough =
          ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
        if (
          ECSI_CX_EncoderTypeRough &&
          parseInt(ECSI_CX_EncoderTypeRough) == 1
        ) {
          // nur Absolutwertgeber
          // E oder F: E ohne, F mit DriveCLiQ
          if (sBT_MLFB16 == "." || sBT_MLFB16 == "2" || sMLFB16 == "2") {
            // Default ohne DriveCLiQ
            var MLFB09_1PH8_BT = "E";
          } else if (sBT_MLFB16 == "1" || sMLFB16 == "1") {
            // mit DriveCLiQ
            var MLFB09_1PH8_BT = "F";
          }
        } else if (
          ECSI_CX_EncoderTypeRough &&
          parseInt(ECSI_CX_EncoderTypeRough) == 0
        ) {
          // nur Inkrementalgeber
          if (strMLFB.charAt(15) == "." || strMLFB.charAt(15) == "2") {
            // ohne DriveCLiQ	H

            // sMLFB09 auf Liste prüfen   (W, Y obsolet)
            var aValidValuesGeber = [
              /*"A",*/ "H",
              "J",
              "M",
              "T",
              "C",
              "G",
              "K",
            ];
            if (aValidValuesGeber.indexOf(sMLFB09) > -1) {
              var MLFB09_1PH8_BT = sMLFB09;
            } else {
              var MLFB09_1PH8_BT = "H";
            }
          } else if (strMLFB.charAt(15) == "1") {
            // mit DriveCLiQ	D

            // sMLFB09 auf Liste prüfen
            var aValidValuesGeber = [/*"A",*/ "D", "U", "S"];
            if (aValidValuesGeber.indexOf(sMLFB09) > -1) {
              var MLFB09_1PH8_BT = sMLFB09;
            } else {
              var MLFB09_1PH8_BT = "D";
            }
          }
        } else {
          // Check Geber
          var bCheck = checkMLFB09_Parser_1PH8(
            strBaseTypeMLFB,
            sMLFB09 /*, strMLFB*/
          );
          if (bCheck) {
            // setzen
            var MLFB09_1PH8_BT = sMLFB09;

            // MLFB16_1PH8 bestimmen

            // VT_1PH8_M00425	ZO Temperatursensor-MLFB09-MLFB16
            //	HMK_KONFIG_TYP_1PH8		MLFB09_1PH8		PMD_AAA717_001_000_1PH8		TAK_ABU215_001_000_1PH8		MLFB16_1PH8
            //		HMK_PRODUKT_ALT_AKT_1PH8	HMK_VALUE_VALID_1PH8

            var sTable = "VT_1PH8_M00425" + sDB_Suffix;
            var sSQL =
              "SELECT MLFB16_1PH8 FROM " +
              sTable +
              " WHERE " +
              "HMK_KONFIG_TYP_1PH8 = 'KONFIG' AND " +
              "MLFB09_1PH8 = '" +
              MLFB09_1PH8_BT +
              "' AND " +
              "HMK_PRODUKT_ALT_AKT_1PH8 = 'AKT' AND " +
              "HMK_VALUE_VALID_1PH8 = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
              sMLFB16 = aResult[0].MLFB16_1PH8;
            } else {
              oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB16";
              return oParsing;
            }
          } else {
            // Default setzen
            // A ???
            var MLFB09_1PH8_BT = "A";
            sMLFB16 = "2";
          }

          //var MLFB09_1PH8_BT = sMLFB09;
        }
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, MLFB09_1PH8_BT);
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
        // MLFB16 Default 1,2 ??? mit /ohne DriveCLiQ?
      }

      // ---------------------------------------------------------------------------------------------------
      // MLFB16_1PH8 Version/DriveCLiQ
      // ---------------------------------------------------------------------------------------------------
      /*
            
            if (sBT_MLFB16 == "."){
                
                // todo, prüfen, ob Geber mit/ohne verfügbar
                /*var bCheck = checkMLFB15(strBaseTypeMLFB, sMLFB15); 
                if (bCheck){
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
                    // Wenn Z, wurde bereits oben die KAG gesetzt
                }else
                {
                * /
                    // nicht zulässig, default setzen
                
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
                
                // MLFB16 Default 1,2 ??? mit /ohne DriveCLiQ?
            }
            */

      // ---------------------------------------------------------------------------------------------------
      // Bauform MLFB12
      // ---------------------------------------------------------------------------------------------------
      // 0,2,3
      // 2 bei Bremse nicht zugelassen (LEA)

      var sMLFB12 = strMLFB.charAt(11);
      var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);

      if (sBT_MLFB12 == ".") {
        // Bauform 0 (B3) bei DriveTrains nicht erlaubt
        if (IsDriveTrain && sMLFB12 == "0") {
          // nicht erlaubt, alternative finden

          if (bBrake && HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "3");
          } else {
            bCheck = checkMLFB12_Parser(strBaseTypeMLFB, "2", bBrake);
            if (bCheck) {
              // setzen
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "2");
            } else {
              bCheck = checkMLFB12_Parser(strBaseTypeMLFB, "3", bBrake);
              if (bCheck) {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "3");
              } else {
                // ERROR
                oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB12";
                return oParsing;
              }
            }
          }
        } else {
          // versuche Wert aus MLFB zu setzen:
          var bCheck = checkMLFB12_Parser(strBaseTypeMLFB, sMLFB12, bBrake);
          if (bCheck) {
            // setzen
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
            // Wenn Z, wurde bereits oben die KAG gesetzt
          } else {
            // Default, falls nicht erlaubt:
            if (bBrake && HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "3");
            } else {
              bCheck = checkMLFB12_Parser(strBaseTypeMLFB, "0", bBrake);
              if (bCheck) {
                // setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "0");
              } else {
                bCheck = checkMLFB12_Parser(strBaseTypeMLFB, "2", bBrake);
                if (bCheck) {
                  // setzen
                  strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "2");
                } else {
                  bCheck = checkMLFB12_Parser(strBaseTypeMLFB, "3", bBrake);
                  if (bCheck) {
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "3");
                  } else {
                    // ERROR
                    oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB12";
                    return oParsing;
                  }
                }
              }
            }
          }
        }
      }
      // ---------------------------------------------------------------------------------------------------
      // Wellenende MLFB13
      // ---------------------------------------------------------------------------------------------------
      // if GearboxMotorCoupling or isDriveTrain same handling
      var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(
        "ECSI_CX_GearboxMotorCoupling"
      );

      if (
        (strECSI_CX_GearboxMotorCoupling &&
          parseInt(strECSI_CX_GearboxMotorCoupling) == 1) ||
        IsDriveTrain
      ) {
        if (MLFB05_BT == "08" || MLFB05_BT == "10") {
          var sMLFB13 = "0";
        } else {
          var sMLFB13 = "2";
        }

        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
      } else {
        var sMLFB13 = strMLFB.charAt(12);
        var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

        if (sBT_MLFB13 == ".") {
          // check Wellenende
          var bCheck = checkMLFB13_Parser(strBaseTypeMLFB, sMLFB13);
          if (bCheck) {
            // setzen
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
          } else {
            // Setze Default:
            sMLFB13 = getMLFB13default_1PH8(strMLFB, bBrake);
            if (sMLFB13 == "ERROR") {
              oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB13";
              return oParsing;
            }
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
          }
        }
      }
      // ---------------------------------------------------------------------------------------------------
      // Lagerung	MLFB14
      // ---------------------------------------------------------------------------------------------------
      /*
            mit Bremse nur A STD bzw P advanced Lifetime LEA nur A DEFAULT A
            00001		00005	00003
            Standard	A		N
            
            ohne Bremse: 
            Default G	
            Ausführung des Lagers	Schwinggrößenstufe		Wellen- und Flanschgenauigkeit
            PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8
            00001					00001					00001
            Standard				R/A						R
            
            LEA 
            Default B
            00006					00001					00001
            Standard mit Festlager	R/A						R
            
            */
      var sMLFB14 = strMLFB.charAt(13);
      var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

      if (sBT_MLFB14 == ".") {
        if (IsDriveTrain && (sMLFB14 == "L" || sMLFB14 == "M")) {
          if (bBrake) {
            // Setze Default:
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "A");
          } else {
            if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "B");
            } else {
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "G");
            }
          }
        } else {
          // Unterscheidung mit/ohne Bremse

          var bCheck = checkMLFB14_Parser(
            strBaseTypeMLFB,
            sMLFB14,
            bBrake,
            true
          );
          if (bCheck) {
            // setzen
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
          } else {
            if (bBrake) {
              // Setze Default:
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "A");
            } else {
              if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "B");
              } else {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "G");
              }
            }
          }
        }
      }

      // ---------------------------------------------------------------------------------------------------
      // Leistungsanschluss MLFB15
      // ---------------------------------------------------------------------------------------------------
      // Default 0
      var sMLFB15 = strMLFB.charAt(14);
      var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

      if (sBT_MLFB15 == ".") {
        // todo Check MLFB15
        var bCheck = checkMLFB15_Parser(strBaseTypeMLFB, sMLFB15);
        if (bCheck) {
          // setzen
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
        } else {
          // Setze Default:

          var sMLFB15default = getMLFB15Default_Parser(strBaseTypeMLFB);
          if (sMLFB15default !== "ERROR") {
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15default);
          } else {
            oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB15";
            return oParsing;
          }
        }
      }

      // ---------------------------------------------------------------------------------------------------
      // MLFB16 siehe Geber (MLFB09)
      // ---------------------------------------------------------------------------------------------------

      // -----------------------------------------------------------------------------------------------
      // Zuweisen der neuen MLFB und KAG-Liste
      strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

      oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
      oParsing.strFullMLFB = strMLFB;
      aComponents[0] = oParsing.strBaseMLFB;
      oParsing.aTokens = aComponents;
      ECL_SetValue("ECSI_MLFB", strMLFB);
    }
    // #######################################################################################################
    // END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END
    // #######################################################################################################
    else {
      // kein KEEP-Configuration, aber MLFB evtl. nicht vollständig spezifiziert
      if (find(strMLFB.left(16), ".") >= 0) {
        //Unvollständige SIZER MLFB

        // Prüfen, ob '.' an Stelle 1 bis 8, 10 oder 11, dann Fehler
        for (var i = 0; i < 8; i++) {
          if (strMLFB.charAt(i) == ".") {
            oParsing.strError = "ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB";
            return oParsing;
          }
        }
        if (strMLFB.charAt(9) == "." || strMLFB.charAt(10) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB";
          return oParsing;
        }

        /*if (strMLFB.charAt(10) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1PH8___INCOMPLETE_MLFB';
                    return( oParsing );
                }*/
        // Wenn an Stelle 9, 12-16 ein Wildcard, dann Default setzen
        /* mögliche Platzhalter
                MLFB09		Geber + MLFB16
                MLFB12		Bauform
                MLFB13		Wellenende
                MLFB14		Lagerung
                MLFB15		Anschlusstechnik
                MLFB16		Version + DQ
                */

        // ---------------------------------------------------------------------------------------------------
        // Bauform MLFB12
        // ---------------------------------------------------------------------------------------------------
        // 0,2,3
        // 2 bei Bremse nicht zugelassen (LEA)

        // Default 0, bei Getriebeanbau und Drivetrains B5 '2' bzw
        if (strMLFB.charAt(11) == ".") {
          // Setze Default: 		abhängig von H_RUMPF_050710_0811 VT252			todo
          if (bBrake && HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
            strMLFB = replaceAt(strMLFB, 11, "3");
          } else {
            // Bauform 0 (B3) bei Getriebekopplung und DriveTrains nicht erlaubt
            if (IsDriveTrain || IsGearboxMotorCoupling) {
              var bCheck = false;
            } else {
              var bCheck = checkMLFB12_Parser(strMLFB, "0", bBrake);
            }
            if (bCheck) {
              strMLFB = replaceAt(strMLFB, 11, "0");
            } else {
              bCheck = checkMLFB12_Parser(strMLFB, "2", bBrake);
              if (bCheck) {
                strMLFB = replaceAt(strMLFB, 11, "2");
              } else {
                bCheck = checkMLFB12_Parser(strMLFB, "3", bBrake);
                if (bCheck) {
                  strMLFB = replaceAt(strMLFB, 11, "3");
                } else {
                  oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB12";
                  return oParsing;
                }
              }
            }
          }
        }

        // ---------------------------------------------------------------------------------------------------
        // Lagerung	MLFB14
        // ---------------------------------------------------------------------------------------------------
        /*
                mit Bremse nur A STD bzw P advanced Lifetime LEA nur A DEFAULT A
                00001		00005	00003
                Standard	A		N
                
                ohne Bremse: 
                Default G	
                Ausführung des Lagers	Schwinggrößenstufe		Wellen- und Flanschgenauigkeit
                PMD_AAA069_001_000_1PH8	PMD_AAB007_001_000_1PH8	TAK_AAJ730_001_000_1PH8
                00001					00001					00001
                Standard				R/A						R
                
                LEA 
                Default B
                00006					00001					00001
                Standard mit Festlager	R/A						R
                
                */

        if (strMLFB.charAt(13) == ".") {
          if (bBrake) {
            // Setze Default:
            var bCheck = checkMLFB14_Parser(strMLFB, "A", true, false);
            if (bCheck) {
              strMLFB = replaceAt(strMLFB, 13, "A");
            } else {
              bCheck = checkMLFB14_Parser(strMLFB, "P", true, false);
              if (bCheck) {
                strMLFB = replaceAt(strMLFB, 13, "P");
              } else {
                var sMLFB14 = getMLFB14Default_Parser(strMLFB, bBrake);
                if (sMLFB14 == "ERROR") {
                  oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB14";
                  return oParsing;
                }
                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
              }
            }
          } else {
            // EDIT 09/23 new default to get hollow shaft, Performance bearing as default
            if (!IsDriveTrain) {
              strMLFB = replaceAt(strMLFB, 13, "L");
              /*var bCheck = checkMLFB14_Parser(strMLFB, "L", false, false);
                            if (bCheck){
                                strMLFB = replaceAt(strMLFB, 13, "L");
                            }*/
            } else {
              var H_RUMPF_050710_0811_1PH8 =
                strMLFB.substring(4, 7) +
                "_" +
                strMLFB.charAt(9) +
                "-" +
                strMLFB.charAt(7) +
                "_" +
                strMLFB.charAt(10);
              var MLFB12_1PH8 = strMLFB.charAt(11);

              var sWhereMLFB14 = "";
              if (IsDriveTrain) {
                sWhereMLFB14 = "MLFB14_1PH8 <> 'L' AND MLFB14_1PH8 <> 'M' AND ";
              }

              var sTable = "VT_1PH8_M00252" + sDB_Suffix;
              var sSQL =
                "SELECT MLFB14_1PH8 FROM " +
                sTable +
                " WHERE " +
                "H_RUMPF_050710_0811_1PH8 = '" +
                H_RUMPF_050710_0811_1PH8 +
                "' AND " +
                "MLFB12_1PH8 = '" +
                MLFB12_1PH8 +
                "' AND " +
                sWhereMLFB14 +
                "HMK_VALUE_VALID_1PH8 = 'T';";

              var aResult = GetDBDataSetEXT(sSQL);
              if (aResult.length > 0) {
                var sMLFB14 = aResult[0].MLFB14_1PH8;
                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
              } else {
                oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB14";
                return oParsing;
              }
            }
          }
        }

        // ---------------------------------------------------------------------------------------------------
        // MLFB09 Geber
        // ---------------------------------------------------------------------------------------------------
        /* ECSI_CX_EncoderTypeRough
                    Null	Any (nothing specific set by the user)
                    0		Incremental
                    1		Absolute
                    
                A	Ohne Geber
                E	Absolutwertgeber EnDat 2048 S/R (Encoder AM2048S/R)
                H	Inkrementalgeber HTL 1024 S/R (Encoder HTL 1024S/R)
                J	Inkrementalgeber HTL 2048 S/R (Encoder HTL 2048S/R)
                M	Inkrementalgeber sin/cos 1 Vpp 2048 S/R mit C- und D-Spur (Encoder IC2048S/R)
                T	Inkrementalgeber sin/cos 1 Vpp 512 S/R ohne C- und D-Spur (Encoder N512S/R)
                C	Inkrementalgeber sin/cos 1 Vpp 256 S/R ohne C- und D-Spur (Encoder IN256S/R)
                F	Absolutwertgeber 22 bit Singleturn + 12 bit Multiturn (Encoder AM22DQ)
                D	Inkrementalgeber 22 bit mit Kommutierungslage (Encoder IC22DQ)
                U	Inkrementalgeber 20 bit ohne Kommutierungslage (Encoder IN20DQ)
                S	Inkrementalgeber 19 bit ohne Kommutierungslage (Encoder IN19DQ)
                G	Inkrementalgeber HTL1024 S/R mit Hohlwelle HOG 22
                K	Inkrementalgeber HTL1024 S/R mit Vollwelle POG 10
                W	Inkrementalgeber HTL 1024 S/R (Encoder HTL1024S/R) mit Anschluss über zusätzlichen Klemmenkasten
                Y	Inkrementalgeber HTL 2048 S/R (Encoder HTL2048S/R) mit Anschluss über zusätzlichen Klemmenkasten
                */

        // default mit , mit DQ
        if (strMLFB.charAt(8) == ".") {
          /* todo keep config: check_MLFB09
           */
          var ECSI_CX_EncoderTypeRough =
            ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
          if (
            ECSI_CX_EncoderTypeRough &&
            parseInt(ECSI_CX_EncoderTypeRough) == 1
          ) {
            // nur Absolutwertgeber
            // E oder F: E ohne, F mit DriveCLiQ
            if (strMLFB.charAt(15) == "2") {
              // ohne DriveCLiQ
              var MLFB09_1PH8 = "E";
              /*var bCheck = checkMLFB09_Parser_1PH8(strMLFB, MLFB09_1PH8); 
                            if (bCheck){
                                //todo
                                
                            }*/
            } else if (strMLFB.charAt(15) == "." || strMLFB.charAt(15) == "1") {
              // Default mit DriveCLiQ
              var MLFB09_1PH8 = "F";
              /*var bCheck = checkMLFB09_Parser_1PH8(strMLFB, MLFB09_1PH8); 
                            if (bCheck){
                                //todo
                                
                            }*/
            }
          } else if (
            ECSI_CX_EncoderTypeRough &&
            parseInt(ECSI_CX_EncoderTypeRough) == 0
          ) {
            // nur Inkrementalgeber
            if (strMLFB.charAt(15) == "2") {
              // ohne DriveCLiQ	H
              var MLFB09_1PH8 = "H";
              /*var bCheck = checkMLFB09_Parser_1PH8(strMLFB, MLFB09_1PH8); 
                            if (bCheck){
                                //todo
                                
                            }*/
            } else if (strMLFB.charAt(15) == "." || strMLFB.charAt(15) == "1") {
              // Default mit DriveCLiQ	S
              var MLFB09_1PH8 = "S";
              /*var bCheck = checkMLFB09_Parser_1PH8(strMLFB, MLFB09_1PH8); 
                            if (bCheck){
                                //todo
                                
                            }*/
            }
          } else {
            var MLFB09_1PH8 = "S"; // default mit DQ und S für Erhalt der Auswahl Hohlwelle
          }
          strMLFB = replaceAt(strMLFB, 8, MLFB09_1PH8);

          // MLFB16 Default 1 mit DriveCLiQ
        }

        // ---------------------------------------------------------------------------------------------------
        // MLFB16_1PH8 Version/DriveCLiQ
        // ---------------------------------------------------------------------------------------------------
        if (strMLFB.charAt(15) == ".") {
          strMLFB = replaceAt(strMLFB, 15, "1");

          // MLFB16 Default 1 mit DriveCLiQ
        }

        // ---------------------------------------------------------------------------------------------------
        // Wellenende MLFB13
        // ---------------------------------------------------------------------------------------------------
        // Default 0
        if (strMLFB.charAt(12) == ".") {
          var sMLFB13 = "0";
          // if GearboxMotorCoupling or isDriveTrain same handling
          var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(
            "ECSI_CX_GearboxMotorCoupling"
          );

          if (
            (strECSI_CX_GearboxMotorCoupling &&
              parseInt(strECSI_CX_GearboxMotorCoupling) == 1) ||
            IsDriveTrain
          ) {
            if (MLFB05_BT == "08" || MLFB05_BT == "10") {
              sMLFB13 = "0";
            } else {
              sMLFB13 = "2";
            }
          } else {
            sMLFB13 = getMLFB13default_1PH8(strMLFB, bBrake);
            if (sMLFB13 == "ERROR") {
              oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB13";
              return oParsing;
            }
          }

          // Setze Default:
          strMLFB = replaceAt(strMLFB, 12, sMLFB13);
        }

        // ---------------------------------------------------------------------------------------------------
        // Leistungsanschluss MLFB15
        // ---------------------------------------------------------------------------------------------------
        // Default 0
        if (strMLFB.charAt(14) == ".") {
          // Setze Default:
          var sMLFB15default = getMLFB15Default_Parser(strMLFB);
          if (sMLFB15default !== "ERROR") {
            strMLFB = replaceAt(strMLFB, 14, sMLFB15default); // checkroutine nötig VT258 besser: 376
          } else {
            oParsing.strError = "DICT1_ERR_1PH8___PARSER_SET_MLFB15";
            return oParsing;
          }
        }

        // MLFB16 siehe Geber (MLFB09)

        // ---------------------------------------------------------------------------------------------------
        ECL_SetValue("ECSI_MLFB", strMLFB);
      }
      // Bremse

      // Motortyp und Bremse MLFB 8:
      // 1 Async ohne Bremse, 3 Async mit Bremse,
      // 2 Sync  ohne Bremse, 4 Sync  mit Bremse
      // LEA: 5 Reluktanz ohne Bremse Effizienzgest. Ausf.
      // LEA: 6 Reluktanz mit  Bremse Effizienzgest. Ausf.
      // LEA: 7 Reluktanz ohne Bremse Leistungsgest. Ausf.
      // LEA: 8 Reluktanz mit  Bremse Leistungsgest. Ausf.
      var sMotortyp = strMLFB.charAt(7);
      if (
        sMotortyp == "3" ||
        sMotortyp == "4" ||
        sMotortyp == "6" ||
        sMotortyp == "8" ||
        ECL_GetValue("ECSI_CX_MotorBrakeRequired") == "1"
      ) {
        // Vorgabe Sizer: mit Bremse
        ECL_SelectValue("CB_HALTEBREMSE_1PH8", "T");
      } else {
        ECL_DeselectAttribute("CB_HALTEBREMSE_1PH8");
      }

      // Zuweisen der neuen MLFB und KAG-Liste
      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
      oParsing.aTokens = aComponents;
    }
    // Jetzt sollte immer eine vollständig spezifizierte MLFB zur Verfügung stehen
  } // der vorherige Abschnitt wurde nur bei IsStartConfiguration == 1 durchlaufen. Passt das ? todo

  // Ergebnis-Objekt zusammenbauen
  var oResult;
  oResult = parse_1PH8(oParsing.aTokens);
  //oResult = add_help_shortcuts(oResult);

  if (IsDriveTrain) {
    IsDriveTrain = "true";
  }

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strProductTrigger = HMK_PRODUKT_TRIG_1PH8;
    oParsing.strBaseTypeMLFB = strBaseTypeMLFB;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;
    oParsing.IsStartConfig = strStartConfiguration;
    oParsing.IsDriveTrain = IsDriveTrain;
  }

  vtTimeStop = Date.getTime();
  vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_1PH8(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };

  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4); // 1PH8
  oResult.oParsingData.MLFB.MLFB05 =
    strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5); // 5+6 Achshöhe		13,16 (LEA)
  oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt(6); // Baulänge									138, 165, 167 (LEA)
  oResult.oParsingData.MLFB.MLFB05_07 = strBaseMLFB.substring(4, 7); // HMK_RUMPF_05_07_1PH8					138, 165, 167 (LEA)
  oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt(7); // Motortyp (Sync/Async) mit/ohne Bremse		5,6,7,8
  oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt(8); // . Geber										A,E,H,J,M mit MLFB16 =2 ohne DQ | F, D, mit MLFB16 =1 mit DQ	(LEA)
  oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt(9); // Wicklungsausführung							D, F, G
  oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt(10); // (.)Kühlart										0,1,2
  oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt(11); // . Bauform (B3, B5, ...)						0,2,3 | 2 (IM B5) nicht bei Bremse
  oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt(12); // . Wellenende (glatt/Passfeder)				0,1,2
  oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt(13); // . Lagerung									A, B, C, D, F
  oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt(14); // . Leistungsanschluss						A, B, C, D
  oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt(15); // . Versionsstand (DriveCliQ (mit=1, ohne=2 (PT1000))

  // Rümpfe
  /* VT 372
    MLFB05_1PH8	MLFB07_1PH8	MLFB10_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_05_07_1PH8	HMK_RUMPF_05_07_10_1PH8	H_RUMPF_050710_0811_1PH8	HMK_RUMPF_05_08_11_1PH8	HMK_VALUE_VALID_1PH8
    */
  // HMK_RUMPF_05_07_1PH8
  var HMK_RUMPF_05_07_1PH8 = oResult.oParsingData.MLFB.MLFB05_07;
  // HMK_RUMPF_05_07_10_1PH8
  var HMK_RUMPF_05_07_10_1PH8 = HMK_RUMPF_05_07_1PH8 + "_" + oResult.oParsingData.MLFB.MLFB10;
  // H_RUMPF_050710_0811_1PH8		081_T-1_2
  var H_RUMPF_050710_0811_1PH8 = HMK_RUMPF_05_07_10_1PH8 + "-" + oResult.oParsingData.MLFB.MLFB08 + "_" + oResult.oParsingData.MLFB.MLFB11;

  // MOTOR_RUMPF_1PH8 example: 1PH8081-1.-U
  var MOTOR_RUMPF_1PH8 = strBaseMLFB.substring(0, 7) + "-" + strBaseMLFB.charAt(7) + ".-" + strBaseMLFB.charAt(9);

  oResult.oParsingData.MOTOR_RUMPF_1PH8 = MOTOR_RUMPF_1PH8;
  oResult.oParsingData.HMK_RUMPF_05_07_1PH8 = HMK_RUMPF_05_07_1PH8;
  oResult.oParsingData.HMK_RUMPF_05_07_10_1PH8 = HMK_RUMPF_05_07_10_1PH8;
  oResult.oParsingData.H_RUMPF_050710_0811_1PH8 = H_RUMPF_050710_0811_1PH8; // bei Änderung der Kühlart, aktualisieren!

  ECL_SetValue("MOTOR_RUMPF_1PH8", MOTOR_RUMPF_1PH8);
  ECL_SetValue("HMK_RUMPF_05_07_1PH8", HMK_RUMPF_05_07_1PH8);
  ECL_SetValue("HMK_RUMPF_05_07_10_1PH8", HMK_RUMPF_05_07_10_1PH8);
  ECL_SetValue("H_RUMPF_050710_0811_1PH8", H_RUMPF_050710_0811_1PH8);

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens;

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
  // ggf O_Y82_1002197, H_O_Y82_1006333

  // O_Y84_1PH8	+ H_O_Y84_1006333
  if (find(oParse.strFullMLFB, "Y84") >= 0) {
    if (oParse.oFreetext["Y84"])
      SetFreetextValue("H_O_Y84_1006333", oParse.oFreetext["Y84"]);
  }
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}

// ###############################################################################################################
// Prüfroutinen für KEEP CONFIGURATION
// ###############################################################################################################
function checkMLFB15_Parser(sMLFB, sMLFB15) {
  // -----------------------------------------------------------------------------------
  // zunächst mit VT_1PH8_M00249 die gültigen MLFB15 ermitteln
  //	H_RUMPF_050710_0811_1PH8	MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTargetAttribute = "MLFB15_1PH8";

  var H_RUMPF_050710_0811_1PH8 =
    sMLFB.substring(4, 7) +
    "_" +
    sMLFB.charAt(9) +
    "-" +
    sMLFB.charAt(7) +
    "_" +
    sMLFB.charAt(10);

  var sTable = "VT_1PH8_M00249" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB15 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00256
  //	MLFB05_1PH8		MLFB09_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var MLFB05_1PH8 = sMLFB.charAt(4) + sMLFB.charAt(5);
  var MLFB09_1PH8 = sMLFB.charAt(8);

  var sTable = "VT_1PH8_M00256" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB15 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00258
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var MLFB11_1PH8 = sMLFB.charAt(10);
  var MLFB12_1PH8 = sMLFB.charAt(11);

  var sTable = "VT_1PH8_M00258" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB15 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  return 1;
}
// ################################################################################################
function checkMLFB14_Parser(sMLFB, sMLFB14, bBrake, dKeepConfig) {
  /*
    Abhängigkeit von der Bremse über MLFB14_1PH8 Bremse 
    VT_1PH8_M00447	Bauform-MLFB12		ggf ander VT???
        MLFB05_1PH8	PMD_ABU276_001_000_1PH8	MLFB12_1PH8	MLFB14_1PH8	PMD_AAC949_001_000_1PH8	HMK_VALUE_VALID_1PH8
    */
  var sTargetAttribute = "MLFB14_1PH8";
  var PMD_ABU276_001_000_1PH8 = "F";
  if (bBrake) PMD_ABU276_001_000_1PH8 = "T";

  var MLFB05_1PH8 = sMLFB.charAt(4) + sMLFB.charAt(5);
  var MLFB12_1PH8 = sMLFB.charAt(11);

  var sTable = "VT_1PH8_M00447" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB14 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  /*
    VT_1PH8_M00252	AL BlockB: Rumpf<>MLFB12,MLFB14
        H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8
    */
  var H_RUMPF_050710_0811_1PH8 =
    sMLFB.substring(4, 7) +
    "_" +
    sMLFB.charAt(9) +
    "-" +
    sMLFB.charAt(7) +
    "_" +
    sMLFB.charAt(10);

  var sTable = "VT_1PH8_M00252" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB14 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8		MLFB14_1PH8		MLFB13_1PH8		MLFB09_1PH8		HMK_VALUE_VALID_1PH8
  if (dKeepConfig) {
    var MLFB09_1PH8 = sMLFB.charAt(8);
    var MLFB13_1PH8 = sMLFB.charAt(12);

    var sTable = "VT_1PH8_M00253" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
      "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
      "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
      sTargetAttribute + " = '" + sMLFB14 + "' AND " +
      "HMK_VALUE_VALID_1PH8 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
      return 0;
    }
  }
  // -----------------------------------------------------------------------------------
  // Wellenende
  // D: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
  //	MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8
  //var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");
  if (dKeepConfig) {
    var sTable = "VT_1PH8_M00563" + sDB_Suffix;
    //var sTargetAttribute = "PMD_AAA069_001_000_1PH8";
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
      "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
      sTargetAttribute + " = '" + sMLFB14 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
      return 0;
    }
  }
  // ----------------------------------------------------------------------------------------------------------------
  return 1;
}
function getMLFB14Default_Parser(sMLFB, bBrake) {
  /*
    VT_1PH8_M00252	AL BlockB: Rumpf<>MLFB12,MLFB14
        H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8
    */
  var MLFB12_1PH8 = sMLFB.charAt(11);
  var H_RUMPF_050710_0811_1PH8 =
    sMLFB.substring(4, 7) +
    "_" +
    sMLFB.charAt(9) +
    "-" +
    sMLFB.charAt(7) +
    "_" +
    sMLFB.charAt(10);

  var sWhereMLFB14 = "";
  if (bBrake) {
    sWhereMLFB14 = "(MLFB14_1PH8 = 'A' OR MLFB14_1PH8 = 'P') AND ";
  }

  var sTable = "VT_1PH8_M00252" + sDB_Suffix;
  var sSQL = "SELECT MLFB14_1PH8 FROM " + sTable + " WHERE " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    sWhereMLFB14 +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return aResult[0].MLFB14_1PH8;
  } else {
    return "ERROR";
  }
}

// ################################################################################################
function checkMLFB13_Parser(sMLFB, sMLFB13) {
  var sTargetAttribute = "MLFB13_1PH8";

  // Abhängigkeit Bremse auch über VT_1PH8_M00255 MLFB08
  // ----------------------------------------------------------------------------------------------------------------
  //E: VT_1PH8_M00341	U60-U68-AH-MLFB12-13-14
  /*/	MLFB05_1PH8	MLFB12_1PH8	MLFB13_1PH8	MLFB14_1PH8	O_U60_BIS_U68_1PH8
    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    
    var sTable = "VT_1PH8_M00341" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sMLFB13 + "'AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }*/
  // ----------------------------------------------------------------------------------------------------------------
  // A: VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB05_1PH8 = sMLFB.charAt(4) + sMLFB.charAt(5);
  var MLFB09_1PH8 = sMLFB.charAt(8);
  //var MLFB14_1PH8 = sMLFB.charAt(13);

  var sTable = "VT_1PH8_M00253" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB13 + "' AND " +
    //"MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // B: VT_1PH8_M00255	AL BlockC: 05_08_13
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB13_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB08_1PH8 = sMLFB.charAt(7);

  var sTable = "VT_1PH8_M00255" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB13 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // C: VT_1PH8_M00563	V90-V92-AH-MLFB13-14
  //	MLFB05_1PH8	MLFB13_1PH8	MLFB14_1PH8	PMD_AAA069_001_000_1PH8	O_V90_V91_V92_1PH8

  //var O_V90_V91_V92_1PH8 = ECL_GetValue("O_V90_V91_V92_1PH8");
  //var PMD_AAA069_001_000_1PH8 = ECL_GetValue("PMD_AAA069_001_000_1PH8");
  /*	var sTable = "VT_1PH8_M00563" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                //"MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sMLFB13 + "';";
                //"PMD_AAA069_001_000_1PH8 = '" + PMD_AAA069_001_000_1PH8 + "' AND " +
                //"O_V90_V91_V92_1PH8 = '" + O_V90_V91_V92_1PH8 + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
*/ // ----------------------------------------------------------------------------------------------------------------
  return 1;
}
// ################################################################################################
function checkMLFB12_Parser(sMLFB_BT, sMLFB12, bBrake) {
  // -----------------------------------------------------------------------------------
  // zunächst die gültigen MLFB12 ermitteln
  // VT_1PH8_M00252
  //	H_RUMPF_050710_0811_1PH8		MLFB12_1PH8		MLFB14_1PH8		HMK_VALUE_VALID_1PH8
  var sTargetAttribute = "MLFB12_1PH8";

  var H_RUMPF_050710_0811_1PH8 =
    sMLFB_BT.substring(4, 7) +
    "_" +
    sMLFB_BT.charAt(9) +
    "-" +
    sMLFB_BT.charAt(7) +
    "_" +
    sMLFB_BT.charAt(10);
  var sWhereMLFB14 = "";
  if (bBrake) {
    sWhereMLFB14 = "(MLFB14_1PH8 = 'A' OR MLFB14_1PH8 = 'P') AND ";
  }
  //var MLFB14_1PH8 = sMLFB_BT.charAt(13);

  var sTable = "VT_1PH8_M00252" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB12 + "' AND " +
    sWhereMLFB14 +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }

  // -----------------------------------------------------------------------------------
  //
  var PMD_ABU276_001_000_1PH8 = "F";
  if (bBrake) {
    PMD_ABU276_001_000_1PH8 = "T";
  }
  var MLFB05_1PH8 = sMLFB_BT.charAt(4) + sMLFB_BT.charAt(5);

  var sTable = "VT_1PH8_M00447" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB12 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  //var MLFB15_1PH8 = sMLFB_BT.charAt(14);
  var MLFB11_1PH8 = sMLFB_BT.charAt(10);
  // VT_1PH8_M00258
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00258" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB12 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  /*var PMD_ABU276_001_000_1PH8 = "F";
        if (bBrake)
            PMD_ABU276_001_000_1PH8 = "T";
    
    var sTable = "VT_1PH8_M00447" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
                //"MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
                sTargetAttribute + " = '" + MLFB12_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }*/
  // -----------------------------------------------------------------------------------
  return 1;
}

// ################################################################################################
function checkMLFB11_Parser(sMLFB_BT, sMLFB11 /*, strMLFB*/) {
  // zunächst die gültigen MLFB11 ermitteln
  // VT_1PH8_M00257
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB09_1PH8		HMK_VALUE_VALID_1PH8
  var sTargetAttribute = "MLFB11_1PH8";

  var MLFB05_1PH8 = sMLFB_BT.charAt(4) + sMLFB_BT.charAt(5);
  //var MLFB09_1PH8 = sMLFB_BT.charAt(8);
  /*var bMLFB09_undefined = false;
    if (MLFB09_1PH8 == "."){
        bMLFB09_undefined = true;
        MLFB09_1PH8 = stsMLFB.charAt(8);
    }*/
  var sTable = "VT_1PH8_M00257" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    //"MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB11 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    /*if (bMLFB09_undefined){
            // ohne Geber prüfen:
            sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sMLFB11 + "'AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length < 1){
                return 0;
            }
        }else{
        */
    return 0;
    //}
  }

  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00258
  //	MLFB05_1PH8		MLFB11_1PH8		MLFB12_1PH8		MLFB15_1PH8		HMK_VALUE_VALID_1PH8
  /*var MLFB12_1PH8 = sMLFB_BT.charAt(11);
    var bMLFB12_undefined = false;
    if (MLFB12_1PH8 == "."){
        bMLFB12_undefined = true;
        MLFB12_1PH8 = stsMLFB.charAt(11);
    }
    
    var MLFB15_1PH8 = sMLFB_BT.charAt(14);
    var bMLFB15_undefined = false;
    if (MLFB15_1PH8 == "."){
        bMLFB15_undefined = true;
        MLFB15_1PH8 = stsMLFB.charAt(14);
    }
    */
  var sTable = "VT_1PH8_M00258" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB11 + "' AND " +
    //"MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    /*if (bMLFB12_undefined){
            var sWhereMLFB12 = "";
        }else{
            var sWhereMLFB12 = "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND ";
        }
        if (bMLFB15_undefined){
            var sWhereMLFB15 = "";
        }else{
            var sWhereMLFB15 = "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND ";
        }
        
        if (bMLFB12_undefined || bMLFB15_undefined){
            sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                    sTargetAttribute + " = '" + sMLFB11 + "'AND " +
                    sWhereMLFB12 +
                    sWhereMLFB15 +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length < 1){
                return 0;
            }
        }else{
        */
    return 0;
    //}
  }
  // -----------------------------------------------------------------------------------
  // VT_1PH8_M00372 Rümpfe
  // MLFB05_1PH8	MLFB07_1PH8	MLFB10_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_RUMPF_05_07_1PH8	HMK_RUMPF_05_07_10_1PH8	H_RUMPF_050710_0811_1PH8	HMK_RUMPF_05_08_11_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB07_1PH8 = sMLFB_BT.charAt(6);
  var MLFB08_1PH8 = sMLFB_BT.charAt(7);
  var MLFB10_1PH8 = sMLFB_BT.charAt(9);

  var sTable = "VT_1PH8_M00372" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB07_1PH8 = '" + MLFB07_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB10_1PH8 = '" + MLFB10_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB11 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------
  return 1;
}

// ################################################################################################
function checkMLFB09_Parser_1PH8(sMLFB_BT, sMLFB09 /*, strMLFB*/) {
  var sTargetAttribute = "MLFB09_1PH8";

  // Abhängigkeiten von Kontext
  var ECSI_CX_EncoderTypeRough = ECL_GetValue("ECSI_CX_EncoderTypeRough");
  //ECL_ActivateAllAttributeValues("PMD_ABU278_001_000_1PH8");
  if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {
    // nur Absolutwertgeber

    var aValidValuesGeber = [/*"A",*/ "E", "F"];

    if (aValidValuesGeber.indexOf(sMLFB09) < 0) {
      return 0;
    }
  } else if (
    ECSI_CX_EncoderTypeRough &&
    parseInt(ECSI_CX_EncoderTypeRough) == 0
  ) {
    // nur Inkrementalgeber
    var sTargetAttribute = "PMD_ABU278_001_000_1PH8";
    var aValidValuesGeber = [
      /*"A",*/ "H",
      "J",
      "M",
      "T",
      "C",
      "D",
      "U",
      "S",
      "G",
      "K",
      /*"W",
      "Y",*/
    ];

    if (aValidValuesGeber.indexOf(sMLFB09) < 0) {
      return 0;
    }
  } else {
    ECL_ActivateAllAttributeValues("PMD_ABU278_001_000_1PH8");
  }
  // ----------------------------------------------------------------------------------------------------------------
  // 0: VT_1PH8_M00624	Geber-MLFB09-KonfigTyp
  //  MLFB09_1PH8 PMD_ABU278_001_000_1PH8 HMK_KONFIG_TYP_1PH8 HMK_VALUE_VALID_1PH8
  var sTable = "VT_1PH8_M00624" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "HMK_KONFIG_TYP_1PH8 = 'KONFIG' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }

  // A: VT_1PH8_M00253	AL BlockC: 14_13_09
  //	MLFB05_1PH8	MLFB14_1PH8	MLFB13_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB05_1PH8 = sMLFB_BT.charAt(4) + sMLFB_BT.charAt(5);
  //var MLFB13_1PH8 = sMLFB_BT.charAt(12);
  //var MLFB14_1PH8 = sMLFB_BT.charAt(13);

  /*	var sTable = "VT_1PH8_M00253" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sMLFB09 + "'AND " +
                //"MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
                //"MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
*/ // ----------------------------------------------------------------------------------------------------------------
  // B: VT_1PH8_M00254	AL BlockC: 05_08_09
  //	MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB08_1PH8 = sMLFB_BT.charAt(7);

  var sTable = "VT_1PH8_M00254" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB09 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // C: VT_1PH8_M00256	AL BlockD: 05_09_15
  //	MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	HMK_VALUE_VALID_1PH8
  //var MLFB15_1PH8 = sMLFB_BT.charAt(14);
  /*	
    var sTable = "VT_1PH8_M00256" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                //"MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sMLFB09 + "'AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
*/ // ----------------------------------------------------------------------------------------------------------------
  // D: VT_1PH8_M00257	AL BlockD: 05_11_09
  //	MLFB05_1PH8	MLFB11_1PH8	MLFB09_1PH8	HMK_VALUE_VALID_1PH8
  var MLFB11_1PH8 = sMLFB_BT.charAt(10);

  var sTable = "VT_1PH8_M00257" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sMLFB09 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  //--------------------------------------------------------------------------------------------------------------
  return 1;
}

function getMLFB15Default_Parser(sMLFB) {
  /* VT_1PH8_M00376
            MLFB05_1PH8  MLFB11_1PH8    MLFB15_1PH8    O_K08_1PH8    O_K09_K10_1PH8    O_K83_K84_K85_1PH8    HMK_ANSCHL_KK_1PH8
            HMK_LAGE_KK_1PH8    PMD_ABU208_001_000_1PH8    PMD_ABU203_001_000_1PH8    HMK_KK_IMG_ID_1PH8    HMK_KK_1PH8
            HMK_VALUE_VALID_1PH8

    */
  var sTargetAttribute = "MLFB15_1PH8";

  var MLFB05_1PH8 = sMLFB.charAt(4) + sMLFB.charAt(5);
  var MLFB11_1PH8 = sMLFB.charAt(10);

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_K08_1PH8 = 'F' AND " +
    "O_K09_K10_1PH8 = 'STD' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T' ORDER BY PMD_ABU208_001_000_1PH8;";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return aResult[0].MLFB15_1PH8;
  } else {
    return "ERROR";
  }
}
function getMLFB13default_1PH8(strMLFB, bBrake) {
  var MLFB05_1PH8 = strMLFB.substring(4, 6);
  var MLFB12_1PH8 = strMLFB.charAt(11);
  //var MLFB14_1PH8 = strMLFB.charAt(13);

  var sTable = "VT_1PH8_M00341" + sDB_Suffix;
  if (bBrake) {
    var sSQL = "SELECT DISTINCT MLFB13_1PH8 FROM " + sTable + " WHERE " +
      "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
      //"MLFB14_1PH8 = '" +
      // MLFB14_1PH8 +
      //"' AND " +
      "O_U60_BIS_U68_1PH8 <> 'NON' ORDER BY MLFB13_1PH8;";
  } else {
    var sSQL = "SELECT DISTINCT MLFB13_1PH8 FROM " + sTable + " WHERE " +
      "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
      "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
      //"MLFB14_1PH8 = '" +
      //MLFB14_1PH8 +
      //"' AND " +
      "O_U60_BIS_U68_1PH8 = 'NON' ORDER BY MLFB13_1PH8;";
  }

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return aResult[0].MLFB13_1PH8;
  } else {
    return "ERROR";
  }
}
