//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"


//@import "models/CFG_2KJ_BREMSE_Model.js"

//@import "../2KJ4_MLFB/SD/MLFB.MOTOX.SD.common.js"


function SetBremse_Init(strchangedAttribute,oData,oDataBremse)
{
    //Erst feststellen, ob Bremse obligatorisch oder gar nicht möglich ist
    var iResult=checkBremse(oData);
    
    if(ECL_GetValue("SCHUTZART_2KJ4")=="IP56")
        iResult=0;
    
    if(iResult==0)
    {
        //Bremse nicht erlaubt
        ECL_DeselectAttribute("MIT_BREMSE_2KJ4");
        ECL_DisableAttribute("MIT_BREMSE_2KJ4")
    }
    else if(iResult==1)
    {
        //Nur mit Bremse erlaubt
        ECL_SelectValue("MIT_BREMSE_2KJ4", "T");
        ECL_DisableAttribute("MIT_BREMSE_2KJ4");
    }
    else if(iResult==2)
    {
        //Bremsenauswahl kommt aus SIZER
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        if(strwithBrake=="")
            ECL_EnableAttribute("MIT_BREMSE_2KJ4");
        
        if(strwithBrake=="1" || strwithBrake=="Yes")
        {
            ECL_EnableAttribute("MIT_BREMSE_2KJ4");
            
            ECL_SelectValue("MIT_BREMSE_2KJ4", "T");
            ECL_DisableAttribute("MIT_BREMSE_2KJ4");
        }
        else if(strwithBrake=="0" || strwithBrake=="No")
        {
            ECL_EnableAttribute("MIT_BREMSE_2KJ4");
            
            ECL_DeselectValue("MIT_BREMSE_2KJ4", "T");
            ECL_DisableAttribute("MIT_BREMSE_2KJ4");
        }
    }
}


function SetBremse_Init_Sizer(oData,oDataBremse)
{
    Check_BREMSE_SAFETY(oData,oDataBremse);
    Bestimme_BREMSENTYP(oData,oDataBremse);
}

function SetBremse_InitOptions(strchangedAttribute,oData,oDataBremse)
{
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP_2KJ4"));

    Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
    Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
    Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
    Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
    Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
    Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
    Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
    
    if(ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4") != "-")
    {
        ECL_ActivateAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_EnableAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_DisableAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
    }
            
    Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
}

function SetBremse(strchangedAttribute,oData,oDataBremse)
{
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP_2KJ4"));
        
    var bGeber = ( strchangedAttribute=="MIT_GEBER_2KJ4" || strchangedAttribute=="GEBER_AUSFUEHRUNG_2KJ4" || strchangedAttribute=="GEBER_FUNKT_SICHERHEIT_2KJ4" || strchangedAttribute=="GEBER_IMPULSZAHL_2KJ4" || strchangedAttribute=="GEBER_ELEKTRONIK_2KJ4" || strchangedAttribute=="GEBER_EINGANGSFREQUENZ_2KJ4" || strchangedAttribute=="GEBER_AUSGANGSSIGNALE_2KJ4" || strchangedAttribute=="GEBER_MECH_VAR_2KJ4" || strchangedAttribute=="GEBER_DIREKTAUSWAHL_2KJ4" || strchangedAttribute=="GEBER_MECHSCHUTZ_2KJ4" );
                
    switch(strchangedAttribute){
        case "SCHUTZART_2KJ4" :
        case "BELUEFTUNG_2KJ4" :
        case "SCHUTZDACH_OPTION_2KJ4" :
            SetBremse_Init(strchangedAttribute,oData);
            Bestimme_BREMSENTYP(oData);
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
        case "BREMSE_SAFETY_2KJ4" :
            Bestimme_BREMSENTYP(oData);
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
            break;
        case "BREMSENTYP_2KJ4" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
            break;
        case "BREMSE_STEUERSPANNUNG_2KJ4" :
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            break;
        case "BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            break;
        case "BREMSE_AUSFUEHRUNG_2KJ4" :
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
            break;
        case "BREMSE_HANDLUEFTUNG_2KJ4" :
            break;
        case "SPEZIFIKATION_CHINA_2KJ4" :
        case "SPEZIFIKATION_EAC_2KJ4" :
            SetBremse_Init(strchangedAttribute,oData);
        case "ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ4" :
            Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
        break;
    }
    
    if(bGeber)
    {
        Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
        Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
    }
    
    if(ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4") != "-")
    {
        ECL_ActivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_EnableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_DisableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ4");
    }
}