//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"

//@import "models/CFG_2KJ_ELEKTRISCHE_AUSFUEHRUNG_Model.js"


function SetElektrischeAusfuehrung_Init(strchangedAttribute,oData)
{
    Bestimme_Betriebsart(oData);
    Bestimme_Netzspannung(oData);
    check_erhoehteLeistung(oData);
    
    //Kurzangabe für erhöhte Leistung gibt es nicht mehr in den aktuellen Daten
    ECL_SetValue ("ECSI_MOTORSPANNUNG_P_KA_2KJ4", "-");

    check_Spannungstoleranz(oData);
    
    Bestimme_Motorschutz(oData);
    var test = ECL_GetValue("GEBER_ZUB_GATEWAYS_2KJ4");
    Bestimme_Stillstandsheizung(oData);
    var test = ECL_GetValue("GEBER_ZUB_GATEWAYS_2KJ4");
    
    Bestimme_Waermeklasse(oData);
     
    Bestimme_MotorZusatzKAs(oData);
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        ECL_ActivateAttribute("ATEX_ZONE_2KJ4");
        ECL_DisableAttribute("ATEX_ZONE_2KJ4");
        
        ECL_EnableAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_ActivateAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        
        ECL_ActivateAttribute("ATEX_Umrichter_2KJ4");
        ECL_DisableAttribute("ATEX_Umrichter_2KJ4");
        
        Bestimme_ATEX_Zone(oData);
        Bestimme_ATEX_Explosionsgruppe(oData);
        Bestimme_ATEX_Umrichter(oData);
    }
    else
    {
        ECL_DisableAttribute("ATEX_ZONE_2KJ4");
        ECL_DeactivateAttribute("ATEX_ZONE_2KJ4");
        
        ECL_DisableAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_DeactivateAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        
        ECL_DisableAttribute("ATEX_Umrichter_2KJ4");
        ECL_DeactivateAttribute("ATEX_Umrichter_2KJ4");
    }
    
}


function SetElektrischeAusfuehrung(strchangedAttribute,oData)
{
    if(strchangedAttribute == "BETRIEBSART_2KJ4")
    {
        Bestimme_Netzspannung(oData);
        check_erhoehteLeistung(oData);
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
    if(strchangedAttribute == "BETRIEBSART_2KJ4" || strchangedAttribute == "MOTORSPANNUNG_2KJ4")
    {
        check_erhoehteLeistung(oData);
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
    if(strchangedAttribute == "BETRIEBSART_2KJ4" || strchangedAttribute == "MOTORSPANNUNG_2KJ4" || strchangedAttribute == "ERHOEHTE_LEISTUNG_OPTION_2KJ4")
    {
        
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
	if(strchangedAttribute == "MIT_GEBER_2KJ4" || strchangedAttribute == "GEBER_AUSFUEHRUNG_2KJ4" || strchangedAttribute == "GEBER_FUNKT_SICHERHEIT_2KJ4" || strchangedAttribute == "GEBER_ELEKTRONIK_2KJ4" || strchangedAttribute == "ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ4" || strchangedAttribute == "MIT_BREMSE_2KJ4" || strchangedAttribute == "BREMSE_SAFETY_2KJ4")
	{
        Bestimme_Motorschutz(oData);
    }
    
    if(strchangedAttribute == "SPEZIFIKATION_CHINA_2KJ4" || strchangedAttribute == "SPEZIFIKATION_ULR_CSA_2KJ4" || strchangedAttribute == "SPEZIFIKATION_EAC_2KJ4")
        Bestimme_Waermeklasse(oData);
        
    if( ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED" && (strchangedAttribute == "STILLSTANDSHEIZUNG_2KJ4" || strchangedAttribute == "MIT_BREMSE_2KJ4"))
        Bestimme_Motorschutz(oData);
     
    if( ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED" && (strchangedAttribute == "MOTORSCHUTZ_2KJ4" || strchangedAttribute == "MIT_BREMSE_2KJ4"))
        Bestimme_Stillstandsheizung(oData);
        
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        ECL_ActivateAttribute("ATEX_ZONE_2KJ4");
        ECL_DisableAttribute("ATEX_ZONE_2KJ4");
        
        ECL_EnableAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_ActivateAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        
        ECL_ActivateAttribute("ATEX_Umrichter_2KJ4");
        ECL_DisableAttribute("ATEX_Umrichter_2KJ4");
        
        Bestimme_ATEX_Zone(oData);
        Bestimme_ATEX_Explosionsgruppe(oData);
        Bestimme_ATEX_Umrichter(oData);
    }
    else
    {
        ECL_DisableAttribute("ATEX_ZONE_2KJ4");
        ECL_DeactivateAttribute("ATEX_ZONE_2KJ4");
        
        ECL_DisableAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_DeactivateAttribute("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        
        ECL_DisableAttribute("ATEX_Umrichter_2KJ4");
        ECL_DeactivateAttribute("ATEX_Umrichter_2KJ4");
    }
}
