//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"

function getCHINA_Specification()
{

    var strDBName = "2KJ_DB";
    var strDBResult = "SPECCHINA";
    var strChinaSpec = "";
    
    var aChinaSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_CEL FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC"))
        strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA"))
        strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strChinaSpec = dbgetstring(strDBResult,'MOTELAUSF_CEL');
            
            aChinaSpec.push([strChinaSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox China Spec! SQL="+strSelect);
    }
    
    return aChinaSpec;
}

function getEAC_Specification()
{

    var strDBName = "2KJ_DB";
    var strDBResult = "SPECEAC";
    var strEACSpec = "";
    
    var aEACSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_EAC FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA"))
        strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA"))
        strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strEACSpec = dbgetstring(strDBResult,'MOTELAUSF_EAC');
            
            aEACSpec.push([strEACSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox EAC Spec! SQL="+strSelect);
    }
    
    return aEACSpec;
}

function getCSA_ULR_Specification()
{

    var strDBName = "2KJ_DB";
    var strDBResult = "SPECCSA_ULR";
    var strULSpec = "";
    
    var aULSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_UL FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ4") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA"))
        strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC"))
        strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strULSpec = dbgetstring(strDBResult,'MOTELAUSF_UL');
            
            aULSpec.push([strULSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox CSA/UL-R Spec! SQL="+strSelect);
    }
    
    return aULSpec;
}

function setSpecificationCheckboxes()
{
    var aCHINASpec = getCHINA_Specification();
    var aEACSpec= getEAC_Specification();
    var aCSA_UL_RSpec = getCSA_ULR_Specification();

    if(aCHINASpec.length == 2 && (aCHINASpec[0][0] == "CHINA" || aCHINASpec[1][0] == "CHINA") && (aCHINASpec[0][0] == "-" || aCHINASpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
    }
    else if(aCHINASpec.length == 1 && aCHINASpec[0][0] == "CHINA" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
    }
    else if(aCHINASpec.length == 1 && aCHINASpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
    }
    else 
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "CHINA");
    }
    
    if(aEACSpec.length == 2 && (aEACSpec[0][0] == "EAC" || aEACSpec[1][0] == "EAC") && (aEACSpec[0][0] == "-" || aEACSpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
    }
    else if(aEACSpec.length == 1 && aEACSpec[0][0] == "EAC" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
    }
    else if(aEACSpec.length == 1 && aEACSpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
    }
    else 
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "EAC");
    }
    
    if(aCSA_UL_RSpec.length == 2 && (aCSA_UL_RSpec[0][0] == "UL-R/CSA" || aCSA_UL_RSpec[1][0] == "UL-R/CSA") && (aCSA_UL_RSpec[0][0] == "-" || aCSA_UL_RSpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
    }
    else if(aCSA_UL_RSpec.length == 1 && aCSA_UL_RSpec[0][0] == "ULR_CSA" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
    }
    else if(aCSA_UL_RSpec.length == 1 && aCSA_UL_RSpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
    }
    else 
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ4", "ULR_CSA");
    }
}

function createSpecString(oData)
{
    
    var strDBName = "2KJ_DB";
    var strDBResult = "SPECSTRING";
    
    var strSpec="";
    
    var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";

            
    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
    {
        strSelect = strSelect + "MOTELAUSF_CE = '-' AND ";
    }
    else
    {
        if(ECL_GetValue("SPEZIFIKATION_CE_EXPORT_2KJ4") == "T"){
            strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
        }
        else{
            strSelect = strSelect + "MOTELAUSF_CE = '-' AND ";
        }
    }
        
    if(ECL_ValueSelected ("SPEZIFIKATION_EAC_2KJ4", "T") && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja"){
        strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
    }
    else{
        strSelect = strSelect + "MOTELAUSF_EAC = '-' AND ";
    }

    if(ECL_ValueSelected ("SPEZIFIKATION_BIS_2KJ4", "T") && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja"){
        strSelect = strSelect + "MOTELAUSF_BIS = 'BIS' AND ";
    }
    else{
        strSelect = strSelect + "MOTELAUSF_BIS = '-' AND ";
    }

    if(ECL_ValueSelected ("SPEZIFIKATION_KEMCO_2KJ4", "T") && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja"){
        strSelect = strSelect + "MOTELAUSF_KEMCO = 'KEMCO' AND ";
    }
    else{
        strSelect = strSelect + "MOTELAUSF_KEMCO = '-' AND ";
    }

    if (ECL_GetValue("ECSI_ATEX_KENNER_2KJ4")=="ATEX_INTEGRATED")
    {
        if(ECL_ValueSelected ("SPEZIFIKATION_CHINA_EX_2KJ4", "T")){
            strSelect = strSelect + "MOTELAUSF_CEL = 'CCC_Ex' AND ";
        }
        else{
            strSelect = strSelect + "MOTELAUSF_CEL = '-' AND ";
        }
    }
    else
    {
        if(ECL_ValueSelected ("SPEZIFIKATION_CHINA_2KJ4", "T") && oData.oRow.VSDMOTOR!="V"){
            strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        }
        else{
            strSelect = strSelect + "MOTELAUSF_CEL = '-' AND ";
        }
    }
    
    if(ECL_ValueSelected ("SPEZIFIKATION_ULR_CSA_2KJ4", "T") && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja"){
        strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
    }
    else{
        strSelect = strSelect + "MOTELAUSF_UL = '-' AND ";
    }

    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja"){
    strSelect = strSelect + "MOTELAUSF_WM_FU = 'WM_FU' AND ";
    }
    else{
        strSelect = strSelect + "MOTELAUSF_WM_FU = '-' AND ";
    }
    
    strSelect = strSelect + "AKTIV = '1' AND ";
    
    if(Object.keys(oData).length !=0){//prüfem ob das Object leer ist
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    }
    
    strSelect = strSelect + "MOTOR = '1' AND ";
    strSelect = strSelect + "G110M = '0' AND ";
    strSelect = strSelect + "G115M = '0' AND ";
    strSelect = strSelect + "G115D = '0' AND ";

    if (ECL_GetValue("ECSI_ATEX_KENNER_2KJ4")=="ATEX_INTEGRATED")
        strSelect = strSelect + "ATEX = '1' AND ";
    else
        strSelect = strSelect + "ATEX = '0' AND ";
    
    
    strSelect = strSelect + "REGION = 'C' ";
    
    if (dbselect( strDBName, strSelect, strDBResult ) == 1)
    {
        strSpec = dbgetstring(strDBResult,'MOTELAUSF');
    }
    else
    {
        logtraceln("Fehler Bestimmung Spezifikation String! SQL="+strSelect);
    }
    
    return strSpec;
    
}
