//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function Bestimme_Betriebsart(oData)
{
    //Betriebsart
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    
    if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4") =="87" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="104")
    {
    }
    else{
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:oData.oRow.MOT_EFFIZIENZKL_KNZ});
    }
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ4")});
    	
	if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="50" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="87")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_1});
		}
		else if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="60" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="104")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_2});
		}
	}
	else
	{
		awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")});
	}
	
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    awhere.push({TMP_MOT_DATEN:"MOT_LEISTUNG",Value:oData.oRow.LEISTUNG});
   	
	if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("-")});
	}
	else
	{
		awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P91;P92")});
	}
	
    var aAttributes = new Array();
    aAttributes.push({IDENT:"BETRIEBSART_2KJ4",DB:"MOT_BETRIEBSART_KEY"});
    ExecSQL_Standard("2KJ4_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("BETRIEBSART_2KJ4");
        ECL_DeactivateAttribute("BETRIEBSART_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("BETRIEBSART_2KJ4");
        ECL_EnableAttribute("BETRIEBSART_2KJ4");
    }
}

function Bestimme_Netzspannung(oData)
{
    //Spannung
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:oData.oRow.MOT_EFFIZIENZKL_KNZ});
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ4")});
	if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="50" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="87")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_1});
		}
		else if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="60" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="104")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_2});
		}
	}
	else
	{
		awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")});
	}
	
    awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART_KEY",Value:ECL_GetValue("BETRIEBSART_2KJ4")});
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    awhere.push({TMP_MOT_DATEN:"MOT_LEISTUNG",Value:oData.oRow.LEISTUNG});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"MOTORSPANNUNG_2KJ4",DB:"MOT_SPANNUNG_UI"});
    ExecSQL_Standard("2KJ4_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("MOTORSPANNUNG_2KJ4");
        ECL_DeactivateAttribute("MOTORSPANNUNG_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("MOTORSPANNUNG_2KJ4");
        ECL_EnableAttribute("MOTORSPANNUNG_2KJ4");
    }
}


function check_erhoehteLeistung(oData)
{
    //Checken, ob erhöhte Leistung möglich
    var sFrequenz	= ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4");
    var Wirkungsgradklasse = ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ4");
    var Betriebsart = ECL_GetValue("BETRIEBSART_2KJ4");
    var strMotortable = "TMP_MOT_DATEN";
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ4");
    
    var strSelect = "SELECT MOT_LEISTUNG_ERH_TF FROM "+strMotortable+" WHERE ";
    strSelect = strSelect + "MOT_FREQUENZ='"+sFrequenz+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+createSpecString(oData)+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+Betriebsart+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    var bNichterhoehteLeistungmoeglich=false;
    for(var i=0; i<aResultTable.length;i++)
    {
        if(aResultTable[i].MOT_LEISTUNG_ERH_TF == "Ja")
            ECL_EnableValue("ERHOEHTE_LEISTUNG_OPTION_2KJ4", "T");
        else if(aResultTable[i].MOT_LEISTUNG_ERH_TF == "Nein")
            bNichterhoehteLeistungmoeglich=true;
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        ECL_DeactivateAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ4");
        ECL_DisableAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ4");
        ECL_EnableAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ4");
    }
    
}

function check_Spannungstoleranz(oData)
{
    //Checken, ob Spannungstoleranz möglich ist
    
    var sFrequenz	= ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4");
    var Wirkungsgradklasse = ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ4");
    var Betriebsart = ECL_GetValue("BETRIEBSART_2KJ4");
    var strMotortable = "TMP_MOT_DATEN";
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ4");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION_2KJ4", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
    
    var strSelect = "SELECT MOT_SPANNUNG_TOL,MOT_LEISTUNG FROM "+strMotortable+" WHERE ";
    strSelect = strSelect + "MOT_FREQUENZ='"+sFrequenz+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+createSpecString(oData)+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+Betriebsart+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    var bohneSpannungToleranzmoeglich=false;
    for(var i=0; i<aResultTable.length;i++)
    {
        if(aResultTable[i].MOT_SPANNUNG_TOL == "+-10")
            ECL_ActivateValue("SPANNUNGSTOLERANZ_OPTION_2KJ4", "T");
        else if(aResultTable[i].MOT_SPANNUNG_TOL == "-")
            bohneSpannungToleranzmoeglich=true;
    }
    
    //Leistung neu setzen
    //oData.oRow.LEISTUNG = aResultTable[0].MOT_LEISTUNG;
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        ECL_DeactivateAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ4");
        ECL_DisableAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ4");
        ECL_EnableAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ4");
    }
}

function Bestimme_Motorschutz(oData)
{
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        var strSelect="";
        strSelect= strSelect+"SELECT WIELART FROM MOWSART_ATEX WHERE ";
        strSelect= strSelect+"POLZAHL='"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' AND ";
        strSelect= strSelect+"MOTOR_HERSTELLER='-' AND ";
        strSelect= strSelect+"CDROM_REL='1' AND ";
        strSelect= strSelect+"SONDER='-' AND ";
        strSelect= strSelect+"(MOTART='"+ECL_GetValue("ATEX_Umrichter_2KJ4")+"' OR MOTART='ALL') AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
            
        
        ECL_DeactivateAllAttributeValues("MOTORSCHUTZ_2KJ4");
    
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if ( aResult.length > 0 )
        {
            if ( aResult.length > 0 )
            {
                for(var i=0;i<aResult.length;i++)
                {
                    if(CheckAnzahlKlemmenATEX(oData, "WIELART", aResult[i].WIELART))
                        ECL_ActivateValue("MOTORSCHUTZ_2KJ4", aResult[i].WIELART);
                }
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Motorschutz ATEX, SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("MOTORSCHUTZ_2KJ4"))
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ4_DB", strSelect+" AND DEFLT = '1'");
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("MOTORSCHUTZ_2KJ4", aResultDefault[0].WIELART);
            }
            else
            {
                ECL_SelectValue("MOTORSCHUTZ_2KJ4", (aResult.length>0?aResult[0].WIELART:''));
            }
        }
        
    }
    else
    {
        var strKKABDICH="ohne";
        if(ECL_ValueSelected("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ4", "T"))
            strKKABDICH="vergossen";
        
        var strHEMOTOR="-";
        var strMotbez=oData.oRow.MOT_BZ_LANG;
        if(oData.oRow.VSDMOTOR=="V")
        {
            strMotbez=trimright(strMotbez,"V");
            if(strMotbez.right(1)=="S"){
                strHEMOTOR="S";
            }
            else if(strMotbez.right(1)=="P"){
				strHEMOTOR="P";	
            }
        }
        else
        {
            if(strMotbez.right(1) == "E"){
                strHEMOTOR = 'E';
            }
            else if(strMotbez.right(1) == "P"){
                strHEMOTOR = 'P';
            }
            else if(strMotbez.right(1) == "S"){
                strHEMOTOR = 'S';
            }
        }
        
        var awhere = new Array();
        awhere.push({MOWSART:"POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ4")});
        awhere.push({MOWSART:"KKABDICH",Value:strKKABDICH});
        awhere.push({MOWSART:"G110M",Value:'0'});
        awhere.push({MOWSART:"SONDER",Value:'-'});
        awhere.push({MOWSART:"G115",Value:'0'});
        awhere.push({MOWSART:"FK7",Value:'0'});
        awhere.push({MOWSART:"M3",Value:oData.oRow.M3});
        awhere.push({MOWSART:"ANWTYP",Value:oData.oRow.ANWTYP});
        awhere.push({MOWSART:"S09",Value:oData.oRow.S09});	
        awhere.push({MOWSART:"VSDMOTOR",Value:oData.oRow.VSDMOTOR});
        awhere.push({MOWSART:"REGION",Value:'S;SAD;SCADE;SCE;SCIADE;SCIE;SI;SIAD'});
        awhere.push({MOWSART:"MOTTYP",Value:oData.oRow.MOTTYP+';ALL'});
        awhere.push({MOWSART:"MOTDIM",Value:oData.oRow.MOTDIM+';ALL'});
        awhere.push({MOWSART:"HEMOTOR",Value:strHEMOTOR+';ALL'});
        
        awhere.push({MOWSART:"CAST(MOWSART.DATUM_ENDE AS INT)",Value:parseInt(oData.oRow.DATUM_ENDE)});
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        {
            //Abfrage Temperatur
            awhere.push({MOWSART:"CAST(MOWSART.UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
        }
        
        awhere.push({MOWSART:"AKTIV",Value:'1'});
		
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			awhere.push({MOWSART:"WM_FU",Value:'1'});
		}
		else
		{
			awhere.push({MOWSART:"WM_FU",Value:'0'});
		}
		
		if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
		{
			if(ECL_ValueSelected("BREMSE_SAFETY_2KJ4", "T"))
			{
				awhere.push({MOWSART:"KONSTAFS_BRE",Value:'Kauf'});
			}
			else
			{
				awhere.push({MOWSART:"KONSTAFS_BRE",Value:'-'});
			}
		}
		else
		{
			awhere.push({MOWSART:"KONSTAFS_BRE",Value:'-'});
		}
		
		
		if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
		{
			if(ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4") == "-")
			{
				awhere.push({MOWSART:"KONSTAFS_GEB",Value:'-'});
			}
			else	
			{
				awhere.push({MOWSART:"KONSTAFS_GEB",Value:'Kauf'});
			}
			
			var strElectronics = ECL_GetValue("GEBER_ELEKTRONIK_2KJ4");
			if(strElectronics=="DRIVE-CLIQ")
			{
				awhere.push({MOWSART:"IA_DQ",Value:'ALL;1'});
			}
			else
			{
				awhere.push({MOWSART:"IA_DQ",Value:'ALL;0'});
			}
		}
		else
		{
			awhere.push({MOWSART:"KONSTAFS_GEB",Value:'-'});
			awhere.push({MOWSART:"IA_DQ",Value:'ALL;0'});
		}
 
        var aAttributes = new Array();
        aAttributes.push({IDENT:"MOTORSCHUTZ_2KJ4",DB:"WIELART"});
        ExecSQL_Standard("2KJ4_DB", "MOWSART", aAttributes, awhere);
        
        var strDefaultSQL = " AND DEFLT='1' ";
        ExecSQL_GetDefaultStandard("2KJ4_DB", "MOWSART", aAttributes, awhere, strDefaultSQL);
    }
}

function Bestimme_Stillstandsheizung(oData)
{
    var strSelect="SELECT DISTINCT HEIZSPG FROM MOHEIZSPG WHERE ";
    strSelect = strSelect +"G115D='0' AND G115M='0' AND G115D='0' AND AKTIV='1' AND CDROM_REL='1' AND ";
    strSelect = strSelect +"M3='"+oData.oRow.M3+"' AND ";
    strSelect = strSelect +"GM3='"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect +"S09='"+oData.oRow.S09+"' AND ";
    strSelect = strSelect +"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect +"REGION IN ('S','SI') AND " ;
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "ATEX='0' AND ";
    }
    
    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "WM_FU='1' AND ";
	}
	else
	{
		strSelect = strSelect + "WM_FU='0' AND ";
	}
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    }
    
    ECL_DeactivateAllAttributeValues("STILLSTANDSHEIZUNG_2KJ4");
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
                {
                    if(CheckAnzahlKlemmenATEX(oData, "HEIZSPG", aResult[i].HEIZSPG))
                        ECL_ActivateValue("STILLSTANDSHEIZUNG_2KJ4", aResult[i].HEIZSPG);
                }
                else
                    ECL_ActivateValue("STILLSTANDSHEIZUNG_2KJ4", aResult[i].HEIZSPG);
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Heizspannung ATEX, SQL="+strSelect);
    }
    
    //Ohne geht immer
    ECL_ActivateValue("STILLSTANDSHEIZUNG_2KJ4", "ohne");
    //Default ist ohne
    ExecSetStandardifValueEmpty("STILLSTANDSHEIZUNG_2KJ4","ohne");
}

function Bestimme_Waermeklasse(oData)
{
    //Wärmeklasse
    
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    //MLFB Stelle 13 ergänzt. Sonst ist die Wärmeklasse nicht eiundeutig //tfreichel 13.08.2021
    var strMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var strMLFB_13=strMLFB.charAt(12);		// motor voltage
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:oData.oRow.MOT_EFFIZIENZKL_KNZ});
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ4")});
	if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="50" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="87")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_1});
		}
		else if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="60" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")=="104")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:oData.oRow.ORIG_MOTFHT_FREQUENZ_2});
		}
	}
	else
	{
		awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")});
	}
	
    awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART_KEY",Value:ECL_GetValue("BETRIEBSART_2KJ4")});
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    awhere.push({TMP_MOT_DATEN:"MOT_LEISTUNG",Value:oData.oRow.LEISTUNG});
    awhere.push({TMP_MOT_DATEN:"MLFB_13_KA",Value:ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_KA_2KJ4")});
    awhere.push({TMP_MOT_DATEN:"MLFB_13",Value:strMLFB_13});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        if(ECL_GetValue("ATEX_Umrichter")=="G120_PM240")
        {
            awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P94")});
        }
        else if(ECL_GetValue("ATEX_Umrichter_2KJ4")=="S120_ALM")
        {
            awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P95")});
        }
        else if (ECL_GetValue("ATEX_Umrichter_2KJ4")=="G120_PM250")
        {
            awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P96")});
        }
    }
    else
	{
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("-")});
		}
		else
		{
			awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P91;P92")});
		}
	}
    
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"WAERMEKLASSE_2KJ4",DB:"MOT_WAERMEKLASSE_KEY"});
    ExecSQL_Standard("2KJ4_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    ExecSetStandardifValueEmpty("WAERMEKLASSE_2KJ4","F");
    
}

function Bestimme_MotorZusatzKAs(oData)
{
    //Hier werden die Spannungszusatz-Kurzangaben bestimmt, die für die nachgelagerte Konfiguration erforderlich sind
    
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ4");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION_2KJ4", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
        
    var	SpannungsTol="";
    var bSpannungsTol = ECL_ValueSelected ("SPANNUNGSTOLERANZ_OPTION_2KJ4", "T");
    if(bSpannungsTol)
        SpannungsTol = "+-10";
    else
        SpannungsTol = "-";
        
    var strSpecString=  createSpecString(oData);
    
    var strSelect="SELECT DISTINCT MLFB_13_KA FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' AND ";
    strSelect = strSelect + "MOT_FREQUENZ='"+ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ4")+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG='"+oData.oRow.LEISTUNG+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART_2KJ4")+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_TOL='"+SpannungsTol+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' ";
    
    //Bei SIZER IMPORT darf KA für Spannung nicht geändert werden
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "EASYKAT_CONFIG")
    {
        var aResultTable = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if(aResultTable.length>0)
        {
            ECL_SetValue ("ECSI_MOTORSPANNUNG_SPG_KA_2KJ4", aResultTable[0].MLFB_13_KA);
        }
    }
}

function Bestimme_ATEX_Zone(oData)
{
    //Kann nicht geändert werden
    //Wird vom SIZER festgelegt
}

function Bestimme_ATEX_Explosionsgruppe(oData)
{
    if(ECL_GetValue("ATEX_ZONE_2KJ4")=="2")
    {
        ECL_DeactivateAllAttributeValues("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_ActivateValue("ATEX_EXPLOSIONSGRUPPE_2KJ4", "IIB");
        ECL_ActivateValue("ATEX_EXPLOSIONSGRUPPE_2KJ4", "IIC");
        ExecSetStandardifValueEmpty("ATEX_EXPLOSIONSGRUPPE_2KJ4","IIC");
    }
    else if(ECL_GetValue("ATEX_ZONE_2KJ4")=="22")
    {
        ECL_DeactivateAllAttributeValues("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        ECL_ActivateValue("ATEX_EXPLOSIONSGRUPPE_2KJ4", "IIIB");
        ExecSetStandardifValueEmpty("ATEX_EXPLOSIONSGRUPPE_2KJ4","IIIB");
    }
    else
    {
        logtraceln("Fehler beim Setzen der Explosionsgruppe ATEX, ZONE unbekannt!");
    }
}

function Bestimme_ATEX_Umrichter(oData)
{
    //Kann nicht geändert werden
    //Wird vom SIZER festgelegt
}