//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

//@import "CFG_2KJ_MECHANISCHE_AUSFUEHRUNG_Model.js"

    
function Bestimme_GEBER_AUSFUEHRUNG(oData)
{
    //Gebertyp bestimmen, wenn es einen gibt, ist auch Geber nöglich.
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    var awhere = new Array();
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }
    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        var iSizerEncoderType=oData.oRow.SIZER_EncoderTypeRough;
        
        if(iSizerEncoderType==0)
            awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IN"});
        else if(iSizerEncoderType==1)
            awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST"});
        
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        {
            //Bei Schwungradlüfter kein IV
            //Bei S09 kein IV
            if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter" || oData.oRow.ANWTYP=="KleinSchnecke")
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN"});
                awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
            }
            else
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
                awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
            }
        }
        else
        {
            if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IR"});
            }
            else
            {
                awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
            }
        }
    }
    else
    {	
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        {
            //Bei Schwungradlüfter kein IV
            //Bei Schnecke kein IV
            if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter" || oData.oRow.ANWTYP=="KleinSchnecke")
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN"});
                awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
            }
            else
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
                awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
            }
        }
        else
        {
            if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
            {
                awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IR"});
            }
            else
            {
                awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
            }
        }
    }
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_AUSFUEHRUNG_2KJ4",DB:"GEBTYP_CONFIG"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    ExecSetStandardifValueEmpty("GEBER_AUSFUEHRUNG_2KJ4","IA_MT");
    
    var aAttributeValues = ECL_GetAllActiveAttributeValues ("GEBER_AUSFUEHRUNG_2KJ4");
    if(aAttributeValues.length > 0)
    {
         ECL_EnableAttribute("MIT_GEBER_2KJ4");
    }
    else
    {
        ECL_DeselectValue("MIT_GEBER_2KJ4");
        ECL_DisableAttribute("MIT_GEBER_2KJ4");
    }
}	
    
//Funktionale Sicherheit	
function Bestimme_GEBER_FUNKT_SICHERHEIT(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
    
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	
    else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
    
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_FUNKT_SICHERHEIT_2KJ4",DB:"KONSTAFS"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    ExecSetStandardifValueEmpty("GEBER_FUNKT_SICHERHEIT_2KJ4","-");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_FUNKT_SICHERHEIT_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_FUNKT_SICHERHEIT_2KJ4");
        
        // Bei Safety Functions SS2, SOS, SLA, SP, SLP, SCA, SBT wird die Geberauswahl die Funktional sichere Geber eingeschränkt.
        var strSafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
        
        if( strSafetyFunctions.indexOf("5") > -1 || strSafetyFunctions.indexOf("6") > -1 || strSafetyFunctions.indexOf("7") > -1 || strSafetyFunctions.indexOf("8") > -1 || strSafetyFunctions.indexOf("9") > -1 || strSafetyFunctions.indexOf("10") > -1 || strSafetyFunctions.indexOf("12") > -1)
        {
            // "-" deaktivieren
            ECL_DeactivateValue("GEBER_FUNKT_SICHERHEIT_2KJ4","-");
            ExecSetStandardifValueEmpty("GEBER_FUNKT_SICHERHEIT_2KJ4","Kauf");
        }
    }
}

//Impulszahl
function Bestimme_GEBER_IMPULSZAHL(oData,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }

    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MOD_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_IMPULSZAHL_2KJ4",DB:"IMPULSZAHL"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_IMPULSZAHL_2KJ4","2048");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_IMPULSZAHL_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_IMPULSZAHL_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_IMPULSZAHL_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_IMPULSZAHL_2KJ4");
    }
}

//Elektronik		
function Bestimme_GEBER_ELEKTRONIK(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }

    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
    
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
	
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CAST(CD_GEBER.GEBELEKTR_UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});

    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_ELEKTRONIK_2KJ4",DB:"ELEKTRONIK_PROTOKOLL"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_ELEKTRONIK_2KJ4","HTL");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_ELEKTRONIK_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_ELEKTRONIK_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_ELEKTRONIK_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_ELEKTRONIK_2KJ4");
    }
}

//Eingangsfrequenz
function Bestimme_GEBER_EINGANGSFREQUENZ(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }

    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }

	if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}

	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
        
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_EINGANGSFREQUENZ_2KJ4",DB:"FREQEINGANG"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_EINGANGSFREQUENZ_2KJ4","-");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_EINGANGSFREQUENZ_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_EINGANGSFREQUENZ_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_EINGANGSFREQUENZ_2KJ4");
    }
}		

//Signale
function Bestimme_GEBER_AUSGANGSSIGNALE(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
	
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	
    else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
	
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
        
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_AUSGANGSSIGNALE_2KJ4",DB:"SIGNAL"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_AUSGANGSSIGNALE_2KJ4","-");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_AUSGANGSSIGNALE_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_AUSGANGSSIGNALE_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_AUSGANGSSIGNALE_2KJ4");
    }
}

//Mechanische Variante
function Bestimmme_GEBER_MECH_VAR(oData,strGEBTYPX_M3)	
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }

    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
    
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	
    else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
	
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }
    
    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
        
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_MECH_VAR_2KJ4",DB:"MECH_VAR"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_MECH_VAR_2KJ4","Flanschdose");
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_MECH_VAR_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_MECH_VAR_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_MECH_VAR_2KJ4");
    }
    else
    {
        ECL_ActivateAttribute("GEBER_MECH_VAR_2KJ4");
    }
}

//Geber Direktwahl
function Bestimmung_GEBER_DIREKTAUSWAHL(oData,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    /*
    var bFSDGeber = true;
    if(parseInt(oData.oRow.MOTORDREHZAHL) > 3000)
        bFSDGeber=false;
    */
    
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }

    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }

    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}

	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}
	
    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_DIREKTAUSWAHL_2KJ4",DB:"MOT_GEB_BZ"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
        
}

//Elektronik		
function Bestimme_GEBER_TECHNISCHEAUSWAHL(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }

    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }
	
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	
    else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }

    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CAST(CD_GEBER.GEBELEKTR_UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:"IA_MT;IA_ST;IN;IV"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_TECHNISCHEAUSWAHL_2KJ4",DB:"MOT_GEB_BZ_TECHN"});
    ExecSQL_Standard("2KJ4_DB", "CD_GEBER", aAttributes, awhere);
    
    /*
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    */
    ExecSetStandardifValueEmpty("GEBER_TECHNISCHEAUSWAHL_2KJ4","(Q79) SSI+HTL2048 A/B KD");
}

//Mechanischer Schutz			
function Bestimme_GEBER_MECHSCHUTZ(oData,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
        
    var strSelect = "SELECT DISTINCT GEBHAUBE,GEBHAUBE_ERF FROM CD_GEBER WHERE ";
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND "
    strSelect = strSelect + "GEBTYP_CONFIG = '"+ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")+"' AND ";
    strSelect = strSelect + "MOT_GEB_BZ = '"+ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4")+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BELART = '"+strBelArt+"' AND ";
    strSelect = strSelect + "SCHUTZDACH = '"+strSchutzdach+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART_2KJ4")+"' AND ";
    strSelect = strSelect + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
    strSelect = strSelect + "(EGPOSHL = '"+ECL_GetValue("BAUFORM_2KJ4")+"' OR EGPOSHL = 'ALL') AND ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        strSelect = strSelect + "ATEX='1' AND ";
    }
    else{
        strSelect = strSelect + "ATEX='0' AND ";
    }
	
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "WM_FU IN ('ALL','1') AND ";
	}
	else
	{
		strSelect = strSelect + "WM_FU IN ('ALL','0') AND ";
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        strSelect = strSelect + "GEBTYP IN ('IA','IN','IR','IV') AND "; 
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        strSelect = strSelect + "SHWG='I' AND ";
    }
    else{
        strSelect = strSelect + "SHWG='-' AND ";
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX>="+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }

    strSelect = strSelect + "KONSTAFS='"+ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")+"' AND ";
        
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "KONSTBREM = 'Kauf' AND ";
        strSelect = strSelect + " GEBGRD IN "+strGEBTYPX_M3;
    }
    else
    {
        strSelect = strSelect + "KONSTBREM = '-' ";
    }
    
    strSelect = strSelect + "AND ANWTYP='"+oData.oRow.ANWTYP+"' ";
            
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    var bSchutzblech = false;
    var bHaube = false;
    
    ECL_DeactivateAllAttributeValues("GEBER_MECHSCHUTZ_2KJ4");
    
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            var strGEBHAUBE = aResult[i].GEBHAUBE;
            var strGEBHAUBE_ERF = aResult[i].GEBHAUBE_ERF;
            
            if(strGEBHAUBE == "0" && strGEBHAUBE_ERF == "0")
            {
                bSchutzblech = true;
                
            }
            else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "0")
            {
                bSchutzblech = true;
                bHaube = true;
            }
            else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "1")
            {
                bHaube = true;
            }
            else
                logtraceln("Fehler Bestimmung mechanischer Schutz");
                
        }
            
        if(bSchutzblech)
        {
            if(parseInt(oData.oRow.MOTDIM) <= 90)
                ECL_ActivateValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZBLECH");
            else
                ECL_ActivateValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZDACH");
            
        }
        
        if(bHaube)
        {	
            ECL_ActivateValue("GEBER_MECHSCHUTZ_2KJ4","UNTER_HAUBE");
        }
    }
    else
    {
        logtraceln("Fehler mechanischer Schutz Geber! SQL="+strSelect);
    }
    
    //Default Wert setzen für mechanischen Schutz
    var bGeberMechSchutzDefault=true;
    var aAttributeValues = ECL_GetAllActiveAttributeValues ("GEBER_MECHSCHUTZ_2KJ4");
    if(aAttributeValues.length > 0)
    {
        var strSelectedValue = ECL_GetValue ("GEBER_MECHSCHUTZ_2KJ4");
        
        for(var i=0;i<aAttributeValues.length;i++)
        {	
            if(strSelectedValue == aAttributeValues[i])
                bGeberMechSchutzDefault=false;
        }
        
        if(bGeberMechSchutzDefault)
            ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4", aAttributeValues[0]);
    }
    
}

//Geber Zubehör Kabel
function Bestimme_GEBER_ZUB_KABEL(oData)
{
    var strGeber=ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4");
    strGeber=replace(strGeber,"|-","");
    strGeber=replace(strGeber,"|Kauf","");
    
    var awhere = new Array();
    awhere.push({GEBMECHZUB:"GEBER",Value:strGeber});
    awhere.push({GEBMECHZUB:"MECH_VAR",Value:ECL_GetValue("GEBER_MECH_VAR_2KJ4")});
    awhere.push({GEBMECHZUB:"S09",Value:oData.oRow.S09});
    awhere.push({GEBMECHZUB:"G115M",Value:'0'});
    awhere.push({GEBMECHZUB:"G115D",Value:'0'});
    awhere.push({GEBMECHZUB:"G110M",Value:'0'});
    awhere.push({GEBMECHZUB:"REGION",Value:'S;SA;SAC'});
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({GEBMECHZUB:"CAST(GEBMECHZUB.UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_ZUB_KABEL_2KJ4",DB:"GEBMECHZUB"});
    ExecSQL_Standard("2KJ4_DB", "GEBMECHZUB", aAttributes, awhere);
    
    var aDefaultSQL = "AND DEFLT='1'";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "GEBMECHZUB", aAttributes, awhere, aDefaultSQL);
    
    
    //Undef Tabelle bearbeiten
    var strSelect = "SELECT GEBMECHZUB FROM GEBMECHZUB_UNDEF WHERE MOTDIM='"+oData.oRow.MOTDIM+"' AND AKTIV='1' ";
            
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    if(aResult.length>0)
    {
        ECL_DeactivateValue("GEBER_ZUB_KABEL_2KJ4",aResult[0].MECH_ZUB);
    }
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_ZUB_KABEL_2KJ4");
    if(aSelections.length==1 && ECL_GetValue("GEBER_ZUB_KABEL_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_ZUB_KABEL_2KJ4");
    }
    else
    {
        //Bei Schnecke und Geber vorbereitet zur Zeit kein Zubehör
        if(oData.oRow.ANWTYP=="KleinSchnecke"  && ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")=="IV")
        {
            ECL_DeactivateAttribute("GEBER_ZUB_KABEL_2KJ4");
        }
        else
        {
            ECL_ActivateAttribute("GEBER_ZUB_KABEL_2KJ4");
        }
    }
    var test = ECL_GetAllActiveAttributeValues("GEBER_ZUB_KABEL_2KJ4");
}

//Geber Zubehör Gateways		
function Bestimme_GEBER_ZUB_GATEWAYS(oData)
{
    var strSpecString=  createSpecString(oData);
    
    var strGeber=ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4");
    strGeber=replace(strGeber,"|-","");
    strGeber=replace(strGeber,"|Kauf","");
    
    var awhere = new Array();
    awhere.push({GEBELZUB:"GEBER",Value:strGeber});
    awhere.push({GEBELZUB:"GEBMECHZUB",Value:ECL_GetValue("GEBER_ZUB_KABEL_2KJ4")});
    awhere.push({GEBELZUB:"MOTELAUSF",Value:strSpecString+";ALL"});
    awhere.push({GEBELZUB:"S09",Value:oData.oRow.S09});
    awhere.push({GEBELZUB:"M3",Value:oData.oRow.M3});
    awhere.push({GEBELZUB:"GM3",Value:oData.oRow.GM3});
    awhere.push({GEBELZUB:"REGION",Value:'S;SC'});
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({GEBELZUB:"CAST(GEBELZUB.UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_ZUB_GATEWAYS_2KJ4",DB:"EL_ZUB"});
    ExecSQL_Standard("2KJ4_DB", "GEBELZUB", aAttributes, awhere);
    
    var aDefaultSQL = "AND DEFLT='1'";
    ExecSQL_GetDefaultStandard("2KJ4_DB", "GEBELZUB", aAttributes, awhere, aDefaultSQL);
    
    //Deaktivieren falls nur "-" zur Auswahl
    var aSelections = ECL_GetAllActiveAttributeValues("GEBER_ZUB_GATEWAYS_2KJ4");
    
    if(aSelections.length==0)
    {
        ECL_ActivateValue("GEBER_ZUB_GATEWAYS_2KJ4","-");
        ECL_SetValue("GEBER_ZUB_GATEWAYS_2KJ4", "-");
        ECL_DeactivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
    }
    else if(aSelections.length==1 && ECL_GetValue("GEBER_ZUB_GATEWAYS_2KJ4")=="-")
    {
        ECL_DeactivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
    }
    else
    {
        //Bei Schnecke und Geber vorbereitet zur Zeit kein Zubehör
        if(oData.oRow.ANWTYP=="KleinSchnecke" && (ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")=="IV" || ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4")=="TTL1024S/R KD|-"))
        {
            ECL_DeactivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
        }
        else
        {
            ECL_ActivateAttribute("GEBER_ZUB_GATEWAYS_2KJ4");
        }
    }
    var test = ECL_GetValue("GEBER_ZUB_GATEWAYS_2KJ4");
}

function Bestimme_GeberbeigeaendertenWerten(oData,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }

	if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }
    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        awhere.push({CD_GEBER:"GEBHAUBE",Value:"1"});
    }
    
    awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
    awhere.push({CD_GEBER:"IMPULSZAHL",Value:ECL_GetValue("GEBER_IMPULSZAHL_2KJ4")});
    awhere.push({CD_GEBER:"ELEKTRONIK_PROTOKOLL",Value:ECL_GetValue("GEBER_ELEKTRONIK_2KJ4")});
    awhere.push({CD_GEBER:"FREQEINGANG",Value:ECL_GetValue("GEBER_EINGANGSFREQUENZ_2KJ4")});
    awhere.push({CD_GEBER:"SIGNAL",Value:ECL_GetValue("GEBER_AUSGANGSSIGNALE_2KJ4")});
    awhere.push({CD_GEBER:"MECH_VAR",Value:ECL_GetValue("GEBER_MECH_VAR_2KJ4")});
    awhere.push({CD_GEBER:"MOT_GEB_BZ_TECHN",Value:ECL_GetValue("GEBER_TECHNISCHEAUSWAHL_2KJ4")});
        
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_DIREKTAUSWAHL_2KJ4",DB:"MOT_GEB_BZ"});
    
    var aDefaultSQL = "";
    var bResult = ExecSQL_GetDefaultStandard_Geber("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    return bResult;
}

function Bestimme_GeberbeigeaendertenWerten_Error(oData,what,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    var awhere = new Array();
    awhere.push({CD_GEBER:"GEBTYP_CONFIG",Value:ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")});
    awhere.push({CD_GEBER:"MOTELAUSF",Value:strSpecString});
    awhere.push({CD_GEBER:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({CD_GEBER:"BELART",Value:strBelArt});
    awhere.push({CD_GEBER:"SCHUTZDACH",Value:strSchutzdach});
    awhere.push({CD_GEBER:"SCHUTZART",Value:ECL_GetValue("SCHUTZART_2KJ4")});
    awhere.push({CD_GEBER:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({CD_GEBER:"MOTWK",Value:ECL_GetValue("WAERMEKLASSE_2KJ4")});
    awhere.push({CD_GEBER:"EGPOSHL",Value:ECL_GetValue("BAUFORM_2KJ4")+";ALL"});
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        awhere.push({CD_GEBER:"ATEX",Value:'1'});
    }
    else{
        awhere.push({CD_GEBER:"ATEX",Value:'0'});
    }

	if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;1"});
	}
	else
	{
		awhere.push({CD_GEBER:"WM_FU",Value:"ALL;0"});
	}

    if(!Check_VSD_DQ_Encoder(oData)){
        awhere.push({CD_GEBER:"GEBTYP",Value:"IA;IN;IR;IV"});
    }

    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        awhere.push({CD_GEBER:"SHWG",Value:"I"});
    }
    else{
        awhere.push({CD_GEBER:"SHWG",Value:"-"});
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({CD_GEBER:"CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"Kauf"});
        awhere.push({CD_GEBER:"GEBGRD",Value:strGEBTYPX_M3});
    }
    else
    {
        awhere.push({CD_GEBER:"KONSTBREM",Value:"-"});
    }
    
    if(what == "GEBER_IMPULSZAHL_2KJ4")
    {
        awhere.push({CD_GEBER:"IMPULSZAHL",Value:ECL_GetValue("GEBER_IMPULSZAHL_2KJ4")});
    }
    if(what == "GEBER_ELEKTRONIK_2KJ4")
    {
        awhere.push({CD_GEBER:"ELEKTRONIK_PROTOKOLL",Value:ECL_GetValue("GEBER_ELEKTRONIK_2KJ4")});
    }
    if(what =="GEBER_EINGANGSFREQUENZ_2KJ4")
    {
        awhere.push({CD_GEBER:"FREQEINGANG",Value:ECL_GetValue("GEBER_EINGANGSFREQUENZ_2KJ4")});
    }
    if(what == "GEBER_AUSGANGSSIGNALE_2KJ4")
    {
        awhere.push({CD_GEBER:"SIGNAL",Value:ECL_GetValue("GEBER_AUSGANGSSIGNALE_2KJ4")});
    }
    if(what == "GEBER_MECH_VAR_2KJ4")
    {
        awhere.push({CD_GEBER:"MECH_VAR",Value:ECL_GetValue("GEBER_MECH_VAR_2KJ4")});
    }
    if(what == "GEBER_FUNKT_SICHERHEIT_2KJ4")
    {
        awhere.push({CD_GEBER:"KONSTAFS",Value:ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")});
    }
    if(what =="GEBER_TECHNISCHEAUSWAHL_2KJ4")
    {
        awhere.push({CD_GEBER:"MOT_GEB_BZ_TECHN",Value:ECL_GetValue("GEBER_TECHNISCHEAUSWAHL_2KJ4")});
    }
        
    var aAttributes = new Array();
    aAttributes.push({IDENT:"GEBER_DIREKTAUSWAHL_2KJ4",DB:"MOT_GEB_BZ"});
    
    var aDefaultSQL = "";
    var bResult = ExecSQL_GetDefaultStandard_Geber_ERROR("2KJ4_DB", "CD_GEBER", aAttributes, awhere, aDefaultSQL);
    return bResult;

}

function Bestimme_WertebeigeaendertemGeber(oData,strGEBTYPX_M3)
{
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    var strSelect = "SELECT DISTINCT IMPULSZAHL,ELEKTRONIK_PROTOKOLL,FREQEINGANG,MECH_VAR,SIGNAL,GEBHAUBE,GEBHAUBE_ERF,MOT_GEB_BZ_TECHN FROM CD_GEBER WHERE ";
    
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND "
    strSelect = strSelect + "MOT_GEB_BZ = '"+ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4")+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BELART = '"+strBelArt+"' AND ";
    strSelect = strSelect + "SCHUTZDACH = '"+strSchutzdach+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART_2KJ4")+"' AND ";
    strSelect = strSelect + "ANWTYP = '"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
    strSelect = strSelect + "(EGPOSHL = '"+ECL_GetValue("BAUFORM_2KJ4")+"' OR EGPOSHL = 'ALL') AND ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED"){
        strSelect = strSelect + "ATEX='1' AND ";
    }
    else{
        strSelect = strSelect + "ATEX='0' AND ";
    }
	
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "WM_FU IN ('ALL','1') AND ";
	}
	else
	{
		strSelect = strSelect + "WM_FU IN ('ALL','0') AND ";
	}
	
    if(!Check_VSD_DQ_Encoder(oData)){
        strSelect = strSelect + "GEBTYP IN ('IA','IN','IR','IV') AND "; 
    }
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter"){
        strSelect = strSelect + "SHWG='I' AND ";
    }
    else{
        strSelect = strSelect + "SHWG='-' AND ";
    }

    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX>="+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
        
    strSelect = strSelect + "KONSTAFS='"+ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")+"' AND ";
        
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "KONSTBREM = 'Kauf' AND ";
        strSelect = strSelect + "GEBGRD IN "+strGEBTYPX_M3+" ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM = '-' ";
    }
    
    var strSelectohneGeberSchutz=strSelect;
    
    var strGeber_SCHUTZ = ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4");
    if(strGeber_SCHUTZ=="UNTER_HAUBE")
    {
        strSelect = strSelect + "AND GEBHAUBE = '1' ";
    }
    else if(strGeber_SCHUTZ=="SCHUTZBLECH" || strGeber_SCHUTZ=="SCHUTZDACH")
    {
        strSelect = strSelect + "AND GEBHAUBE_ERF = '0' ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        var strIMPULSZAHL = aResult[0].IMPULSZAHL;
        var strELEKTRONIK = aResult[0].ELEKTRONIK_PROTOKOLL;
        var strFREQEINGANG = aResult[0].FREQEINGANG;
        var strMECH_VAR = aResult[0].MECH_VAR;
        var strSIGNAL = aResult[0].SIGNAL;
        var strTECHNISCHEAUSWAHL = aResult[0].MOT_GEB_BZ_TECHN;
        
        ECL_SelectValue("GEBER_IMPULSZAHL_2KJ4",strIMPULSZAHL);
        ECL_SelectValue("GEBER_ELEKTRONIK_2KJ4",strELEKTRONIK);
        ECL_SelectValue("GEBER_EINGANGSFREQUENZ_2KJ4",strFREQEINGANG);
        ECL_SelectValue("GEBER_MECH_VAR_2KJ4",strMECH_VAR);
        ECL_SelectValue("GEBER_AUSGANGSSIGNALE_2KJ4",strSIGNAL);
        ECL_SelectValue("GEBER_TECHNISCHEAUSWAHL_2KJ4",strTECHNISCHEAUSWAHL);
        
        var strGEBHAUBE = aResult[0].GEBHAUBE;
        var strGEBHAUBE_ERF = aResult[0].GEBHAUBE_ERF;
        
        if(!ECL_ValueSelected("BELUEFTUNG_2KJ4", "Zugeordneter Luefter"))
        {
            if(strGEBHAUBE == "0" && strGEBHAUBE_ERF == "0")
            {
                if(parseInt(oData.oRow.MOTDIM ) <= 90)
                    ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZBLECH");
                else
                    ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZDACH");
            }
            else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "0")
            {
                //kann so bleiben
            }
            else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "1")
            {
                ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","UNTER_HAUBE");				
            }
        }
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelectohneGeberSchutz);
        if ( aResult.length > 0 )
        {
            var strIMPULSZAHL = aResult[0].IMPULSZAHL;
            var strELEKTRONIK = aResult[0].ELEKTRONIK_PROTOKOLL;
            var strFREQEINGANG = aResult[0].FREQEINGANG;
            var strMECH_VAR = aResult[0].MECH_VAR;
            var strSIGNAL = aResult[0].SIGNAL;
            var strTECHNISCHEAUSWAHL = aResult[0].MOT_GEB_BZ_TECHN;
            
            ECL_SelectValue("GEBER_IMPULSZAHL_2KJ4",strIMPULSZAHL);
            ECL_SelectValue("GEBER_ELEKTRONIK_2KJ4",strELEKTRONIK);
            ECL_SelectValue("GEBER_EINGANGSFREQUENZ_2KJ4",strFREQEINGANG);
            ECL_SelectValue("GEBER_MECH_VAR_2KJ4",strMECH_VAR);
            ECL_SelectValue("GEBER_AUSGANGSSIGNALE_2KJ4",strSIGNAL);
            ECL_SelectValue("GEBER_TECHNISCHEAUSWAHL_2KJ4",strTECHNISCHEAUSWAHL);
            
            var strGEBHAUBE = aResult[0].GEBHAUBE;
            var strGEBHAUBE_ERF = aResult[0].GEBHAUBE_ERF;
            
            if(!ECL_ValueSelected("BELUEFTUNG_2KJ4", "Zugeordneter Luefter"))
            {
                if(strGEBHAUBE == "0" && strGEBHAUBE_ERF == "0")
                {
                    if(parseInt(oData.oRow.MOTDIM ) <= 90)
                        ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZBLECH");
                    else
                        ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","SCHUTZDACH");
                }
                else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "0")
                {
                    //kann so bleiben
                }
                else if(strGEBHAUBE == "1" && strGEBHAUBE_ERF == "1")
                {
                    ECL_SelectValue("GEBER_MECHSCHUTZ_2KJ4","UNTER_HAUBE");				
                }
            }
        }
        else
        {
            
            logtraceln("Fehler Bestimmung der Werte bei Direktauswahl Geber! SQL="+strSelect);
        }
    }
}

function getValuesForEncoderDirectSelection( strEncoderDirectSelection, strMotorSize, strMechanicalVenting, bOtherMotorProtectionCover, strSpecString, strKONSTAFS )
{
    // für Parser
    var strSelect = "SELECT DISTINCT GEBTYP_CONFIG, IMPULSZAHL, ELEKTRONIK_PROTOKOLL, FREQEINGANG, MECH_VAR, SIGNAL, KONSTAFS, MOT_GEB_BZ_TECHN FROM CD_GEBER WHERE MOT_GEB_BZ = '" + strEncoderDirectSelection +
                    "' AND MOTDIM = '" + strMotorSize +	"' AND ";
    
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND ";
    strSelect = strSelect + "KONSTAFS = '"+strKONSTAFS+"' AND ";
    
    if ( strMechanicalVenting === 'F' )
        strSelect += "BELART = 'F' AND ";
    else strSelect += "BELART = '-' AND ";
    if ( bOtherMotorProtectionCover )
        strSelect += "SCHUTZDACH = 'W' ";
    else strSelect += "SCHUTZDACH = '-' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    if ( aResult.length > 0 )
    {
        return( {
            GEBER_AUSFUEHRUNG: aResult[0].GEBTYP_CONFIG,
            GEBER_IMPULSZAHL: aResult[0].IMPULSZAHL,
            GEBER_ELEKTRONIK: aResult[0].ELEKTRONIK_PROTOKOLL,
            GEBER_EINGANGSFREQUENZ: aResult[0].FREQEINGANG,
            GEBER_AUSGANGSSIGNALE: aResult[0].SIGNAL,
            GEBER_MECH_VAR: aResult[0].MECH_VAR,
            GEBER_FUNKT_SICHERHEIT: aResult[0].KONSTAFS,
            GEBER_TECHNISCHEAUSWAHL: aResult[0].MOT_GEB_BZ_TECHN
        } );
    }
    
    return( null );
}

function checkGEBTYPX_M3(oData)
{
    var strSelect2="";
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    strSelect2 = "SELECT DISTINCT GEBGRD FROM GEBTYPX_M3 WHERE ";
    strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect2 = strSelect2 + "(PAKZUS = '"+strPAKZUS+"' OR PAKZUS = 'ALL') AND ";
    
    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T"))
        strSelect2 = strSelect2 + "MOTRLSP = 'X' AND ";
    else
        strSelect2 = strSelect2 + "MOTRLSP = '-' AND ";
        
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
        strSelect2 = strSelect2 + "BELART_KONFIG = 'F' AND ";
    else
        strSelect2 = strSelect2 + "BELART_KONFIG = '-U' AND ";
        
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
        strSelect2 = strSelect2 + "SHWG = 'I' AND ";
    else
        strSelect2 = strSelect2 + "SHWG = '-' AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
            strSelect2 = strSelect2 + "SCHUTZDACH = 'W' AND ";
    else
        strSelect2 = strSelect2 + "SCHUTZDACH = '-' AND ";
    
    strSelect2 = strSelect2 + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4")+"' AND ";
    strSelect2 = strSelect2 + "(BREGERRED = '"+ECL_GetValue("BREMSE_REIBBELAG_2KJ4")+"' OR BREGERRED = 'normal') AND ";
    
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "ohne")
        strSelect2 = strSelect2 + "(FKTGLR_KNZ = '0' OR FKTGLR_KNZ = '-') AND ";
    else
        strSelect2 = strSelect2 + "(FKTGLR_KNZ = '1' OR FKTGLR_KNZ = '-') AND ";
        
    strSelect2 = strSelect2 + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
    strSelect2 = strSelect2 + "S09 = '"+oData.oRow.S09+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect2 = strSelect2 + "GEBTYPX_M3.UMGEB_TEMP_MAX>="+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        strSelect2 = strSelect2 + "KONSTBREM = 'Kauf' AND ";
    else
        strSelect2 = strSelect2 + "KONSTBREM = '-' AND ";
        
    strSelect2 = strSelect2 + "GEBTYPX_M3.AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect2);
            
    var RetString="";		
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            RetString=RetString+aResult[i].GEBGRD+";";
        }
        
        RetString=trimright(RetString,";");
        return RetString;
    }
    else
    {
        return ('');
    }
}

function checkGEBTYPX_M3_2(oData)
{
    var strSelect2="";
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    strSelect2 = "SELECT DISTINCT GEBGRD FROM GEBTYPX_M3 WHERE ";
    strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect2 = strSelect2 + "(PAKZUS = '"+strPAKZUS+"' OR PAKZUS = 'ALL') AND ";
    
    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T"))
        strSelect2 = strSelect2 + "MOTRLSP = 'X' AND ";
    else
        strSelect2 = strSelect2 + "MOTRLSP = '-' AND ";
        
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
        strSelect2 = strSelect2 + "BELART_KONFIG = 'F' AND ";
    else
        strSelect2 = strSelect2 + "BELART_KONFIG = '-U' AND ";
        
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
        strSelect2 = strSelect2 + "SHWG = 'I' AND ";
    else
        strSelect2 = strSelect2 + "SHWG = '-' AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
            strSelect2 = strSelect2 + "SCHUTZDACH = 'W' AND ";
    else
        strSelect2 = strSelect2 + "SCHUTZDACH = '-' AND ";
    
    strSelect2 = strSelect2 + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4")+"' AND ";
    strSelect2 = strSelect2 + "(BREGERRED = '"+ECL_GetValue("BREMSE_REIBBELAG_2KJ4")+"' OR BREGERRED = 'normal') AND ";
    
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "ohne")
        strSelect2 = strSelect2 + "(FKTGLR_KNZ = '0' OR FKTGLR_KNZ = '-') AND ";
    else
        strSelect2 = strSelect2 + "(FKTGLR_KNZ = '1' OR FKTGLR_KNZ = '-') AND ";
        
    strSelect2 = strSelect2 + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
    strSelect2 = strSelect2 + "S09 = '"+oData.oRow.S09+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect2 = strSelect2 + "GEBTYPX_M3.UMGEB_TEMP_MAX>="+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
        
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
        strSelect2 = strSelect2 + "KONSTBREM = 'Kauf' AND ";
    else
        strSelect2 = strSelect2 + "KONSTBREM = '-' AND ";
        
    strSelect2 = strSelect2 + "GEBTYPX_M3.AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect2);
            
    var RetString="(";		
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            RetString=RetString+"'"+aResult[i].GEBGRD+"',";
        }
        
        RetString=trimright(RetString,",");
        RetString=RetString +")";
        
        return RetString;
    }
    else
    {
        return ('');
    }
}

//Funktionale Sicherheit	
function Check_GEBER_FUNKT_SICHERHEIT(oData,strGEBTYPX_M3)
{		
    var strSpecString=  createSpecString(oData);
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG_2KJ4")=="Zugeordneter Luefter")
        strBelArt="F";
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSchutzdach="W";
    
    
    var strSelect="SELECT KONSTAFS FROM CD_GEBER WHERE ";
    strSelect = strSelect + "GEBTYP_CONFIG='"+ECL_GetValue("GEBER_AUSFUEHRUNG_2KJ4")+"' AND ";
    strSelect = strSelect + "MOTELAUSF='"+strSpecString+"' AND ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BELART='"+strBelArt+"' AND ";
    strSelect = strSelect + "SCHUTZDACH='"+strSchutzdach+"' AND ";
    strSelect = strSelect + "SCHUTZART='"+ECL_GetValue("SCHUTZART_2KJ4")+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "MOTWK='"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ4")+"' OR EGPOSHL='ALL') AND ";
    
    if(ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "WM_FU IN ('ALL','1') AND ";
	}
	else
	{
		strSelect = strSelect + "WM_FU IN ('ALL','0') AND ";
	}

    if(!Check_VSD_DQ_Encoder(oData))
        strSelect = strSelect + "GEBTYP IN ('IA','IN','IR','IV') AND "; 
    
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
    {
        strSelect = strSelect + "SHWG='I' AND ";
    }
    else
    {
        strSelect = strSelect + "SHWG='-' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(CD_GEBER.GEBTYPX_M3_UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "KONSTBREM='Kauf' AND ";
        strSelect = strSelect + "GEBTYP_CONFIG IN ('IA_MT','IA_ST','IN','IV') AND ";
        strSelect = strSelect + "GEBGRD IN ('"+replace(strGEBTYPX_M3,";","','")+"') AND ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='-' AND ";
    }
    
    if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
    {
        strSelect = strSelect + "GEBHAUBE='1' AND ";
    }
    
    strSelect=strSelect+"KONSTAFS<>'-' "
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    if(aResult.length>0)
        return true;
    else
        return false;
}

function Check_VSD_DQ_Encoder(oData)
{
    //Ist Drive-Cliq Geber möglich?
    //Anhand Wickelblattnummer und Wickelblattauslegung prüfen
    /*
    var strWIBLNR=oData.oRow.WIBLNR;
    var strWIBLAUSLG=oData.oRow.WIBLAUSLG;
    strWIBLNR=trimright(strWIBLNR,"H");
    
    if(ECL_GetValue("WAERMEKLASSE_2KJ4")=="H")
        strWIBLNR=strWIBLNR+"H";
    
    var strSelect = "SELECT * FROM GEBTYP_FCDS_M3 WHERE WIBLNR='"+strWIBLNR+"' AND WIBLAUSLG='"+strWIBLAUSLG+"' ";
    var aResult = Object.fromDatabase( '2KJ4_DB', strSelect );
    if(aResult.length>0)
    {
        return true;
    }
    else
    {
        return false;
    }
    */

     // Sonderlogik Torsten Engfer
    // mit N3C ==> kein DRIVE-CLIQ erlaubt
    if(ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_KA_2KJ4")=="N3C")
    {
        return false;
    }

    if(oData.oRow.VSDMOTOR=="V"){
        return true;
    }
    else
    {
        return false;
    }
}