//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function Bestimme_Oberflaechenbehandlung(oData,strchangedAttribute)
{
    
    //Drive Train Implementierung
	if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1PH8"))
	{
        //1FK2
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "LACKIERT");
        
        if(strchangedAttribute == "ISDRIVETRAIN_OPTION_2KJ4")
        {
            ECL_SelectValue("OBERFLAECHENBEHANDLUNG_2KJ4","LACKIERT");
        }
        else
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ4","LACKIERT");
        }
    }
    else if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1LE1")
    {
        //1LE1
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "LACKIERT");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "GRUNDIERT");
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ4","LACKIERT");
    }
    else if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB5"))
    {
        //1LE1
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "LACKIERT");
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ4","LACKIERT");
    }
    else
    {
    
        // Fest codiert
        ECL_EnableAttribute("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG_2KJ4");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "LACKIERT");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "UNLACKIERT");
        
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "GRUNDIERT");
        
        //Bei Schnecken kein Grundiert
        if(oData.oRow.ANWTYP=="KleinSchnecke")
            ECL_DeactivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "GRUNDIERT");
            
        // Bei ATEX Adapter kein Grundiert	
        if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_ADAPTER" || (ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED" && ECL_GetValue("ATEX_EXPLOSIONSGRUPPE_2KJ4")=='IIC'))
            ECL_DeactivateValue("OBERFLAECHENBEHANDLUNG_2KJ4", "GRUNDIERT");
        
        var strSelect = "SELECT * FROM FARBE_UNLACKIERT WHERE ";
        strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR")
            strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
        else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
            strSelect = strSelect + "MOTTYP='-' AND ";
        
       
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if ( aResult.length>0 )
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ4","UNLACKIERT");
        }
        else
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ4","LACKIERT");
        }
    }
}

function Bestimme_Beschichtung(oData)
{
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2") && ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4") == "LACKIERT")
    {
        //1FK2
        ECL_ActivateAttribute("BESCHICHTUNG_2KJ4");
        ECL_DeactivateAllAttributeValues("BESCHICHTUNG_2KJ4");
        ECL_ActivateValue("BESCHICHTUNG_2KJ4", "C1");
        ECL_SelectValue("BESCHICHTUNG_2KJ4","C1");
        ECL_DisableAttribute("BESCHICHTUNG_2KJ4");
    }
    else
    {
        ECL_EnableAttribute("BESCHICHTUNG_2KJ4");
        
        var strSelect = "SELECT DISTINCT NORM FROM FARBNORM WHERE ";
        strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
        strSelect = strSelect + "CDROM_REL = '1' AND ";
        strSelect = strSelect + "AKTIV = '1' AND ";
        strSelect = strSelect + "SONDER = '-' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "FARBNORM.ATEX = '1' AND ";
        }
        else
        {
            strSelect = strSelect + "FARBNORM.ATEX = '0' AND ";
        }
        
        if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_ADAPTER")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ECSI_ATEX_EGRUPPE_2KJ4")+"' AND ";
        }
        else if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ATEX_EXPLOSIONSGRUPPE_2KJ4")+"' AND ";
        }
        else
        {
            strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
        }
        
        
        strSelect = strSelect + "REGION IN ('S','SA','SACE','SACEI','SACEMI','SACEMNI','SAM','SAMN','SN') AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        
            if( (ECL_ValueSelected("MIT_GEBER_2KJ4", "T") && ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4") != "-") || (ECL_ValueSelected("MIT_BREMSE_2KJ4", "T") && ECL_ValueSelected("BREMSE_SAFETY_2KJ4", "T")) )
            strSelect = strSelect + "FKTSICHERHEIT_KNR='SI' ";
        else
            strSelect = strSelect + "FKTSICHERHEIT_KNR='-' ";
        
        
        ECL_DeactivateAllAttributeValues("BESCHICHTUNG_2KJ4");
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if ( aResult.length > 1 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BESCHICHTUNG_2KJ4", aResult[i].NORM);
            }
            
            if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")=="GRUNDIERT")
            {
                //Normen für lackiert wieder deaktivieren
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C1");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C2");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C3");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C4");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C5");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "ohne");
            }
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")=="LACKIERT")
            {
                //Normen für grundiert wieder deaktivieren
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C2-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C3-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C4-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "C5-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG_2KJ4", "ohne");
            }
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")=="UNLACKIERT")
            {
                ECL_DeactivateAllAttributeValues("BESCHICHTUNG_2KJ4");
                ECL_ActivateValue("BESCHICHTUNG_2KJ4", "ohne");
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Beschichtung! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("BESCHICHTUNG_2KJ4"))
        {
            var aResultDefault="";
            if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")=="LACKIERT")
                aResultDefault = ExecSQL_Standard_SO("2KJ4_DB", strSelect+" AND DEFLT = '1' AND NORM NOT LIKE '%Grundiert'");
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")=="GRUNDIERT")
                aResultDefault = ExecSQL_Standard_SO("2KJ4_DB", strSelect+" AND DEFLT = '1' AND NORM LIKE '%Grundiert'");
                
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("BESCHICHTUNG_2KJ4", aResultDefault[0].NORM);
            }
            else if(aResult.length>0)
            {
                var aBeschichtungen=ECL_GetAllActiveAttributeValues("BESCHICHTUNG_2KJ4");
                ECL_SelectValue("BESCHICHTUNG_2KJ4", aBeschichtungen[0]);
            }
            else
                ECL_SelectValue("BESCHICHTUNG_2KJ4", "ohne");
        }
    }
}

function Bestimme_Farbe(oData)
{
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2") && ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4") == "LACKIERT")
    {
        //1FK2
        ECL_ActivateAttribute("FARBE_2KJ4");
        ECL_DeactivateAllAttributeValues("FARBE_2KJ4");
        ECL_ActivateValue("FARBE_2KJ4", "7016");
        ECL_SelectValue("FARBE_2KJ4","7016");
        ECL_DisableAttribute("FARBE_2KJ4");
    }
    else
    {
        ECL_EnableAttribute("FARBE_2KJ4");
        
        var strSelect = "SELECT DISTINCT RALNR FROM FARBRAL WHERE ";
        strSelect = strSelect + "NORM='"+ECL_GetValue("BESCHICHTUNG_2KJ4")+"' AND ";
        strSelect = strSelect + "SONDER = '-' AND ";
        strSelect = strSelect + "M3 = '1' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "FARBRAL.ATEX = '1' AND ";
        }
        else
        {
            strSelect = strSelect + "FARBRAL.ATEX = '0' AND ";
        }
        
        strSelect = strSelect + "AKTIV='1' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_ADAPTER")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ECSI_ATEX_EGRUPPE_2KJ4")+"' AND ";
            
        }
        else if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ATEX_EXPLOSIONSGRUPPE_2KJ4")+"' AND ";
            
        }
        else
        {
            strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
        }
        
        
        strSelect = strSelect + "REGION like'S%' AND ";
        
        //erweiterter Standard
        strSelect = strSelect + "CDROM_REL ='1' ";
        
        ECL_DeactivateAllAttributeValues("FARBE_2KJ4");
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if ( aResult.length > 0 )
        {	
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("FARBE_2KJ4", aResult[i].RALNR);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Farbe! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("FARBE_2KJ4"))
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ4_DB", strSelect+" AND FARB_MISCH='-' AND DEFLT = '1'");
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("FARBE_2KJ4", aResultDefault[0].RALNR);
            }
            if(aResult.length > 0 && aResultDefault.length<=0)
            {
                ECL_SelectValue("FARBE_2KJ4", aResult[0].RALNR);
            }
        }
    }
}

function istVorbehandlungmoeglich(oData)
{
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2"))
    {
        //nicht möglich
        ECL_DeselectValue("VORBEHANDLUNG_OPTION_2KJ4", "T");
        ECL_DisableAttribute("VORBEHANDLUNG_OPTION_2KJ4");
    }
    else
    {
        //Abhängigkeiten unklar
        if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4")== "UNLACKIERT")
        {
            //nicht möglich
            ECL_DeselectValue("VORBEHANDLUNG_OPTION_2KJ4", "T");
            ECL_DisableAttribute("VORBEHANDLUNG_OPTION_2KJ4");
        }
        else
        {
            //möglich
            ECL_EnableAttribute("VORBEHANDLUNG_OPTION_2KJ4");
            ECL_EnableValue("VORBEHANDLUNG_OPTION_2KJ4", "T");
        }
    }
}

function istLangzeitkonservierungmoeglich(oData)
{	
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB5"))
    {
        //1FK2//1LE1//1MB1
        ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION_2KJ4", "T");
        ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ4");
    }
    else if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION_2KJ4", "T");
        ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ4");
    }
    else
    {
        var strANTRIEB = "";
        var strMOTOR = "";
            
        if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR_2KJ4")
        {
            //Für Getriebemotoren
            strANTRIEB = "0";
            strMOTOR = "1";
        }
        else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
        {
            //Für Getriebe mit Adapter
            strANTRIEB = "1";
            strMOTOR = "0";
        }
        
        var strMotInnenKorrSchutz="nein";
        if(ECL_ValueSelected("INNENKORROSIONSSCHUTZ_OPTION_2KJ4", "T"))
        {
            strMotInnenKorrSchutz="ja";
        }
        
        var strSelect = "SELECT * FROM KONSERVIERUNG,OELSORTE_M3 WHERE ";
        strSelect = strSelect +"ANTRIEB = '"+strANTRIEB+"' AND ";
        strSelect = strSelect +"MOTOR = '"+strMOTOR+"' AND ";
        strSelect = strSelect +"MOINNENKORSCH = '"+strMotInnenKorrSchutz+"' AND ";
        strSelect = strSelect +"KONSERVIERUNG.KONS_VCI = OELSORTE_M3.KONS_VCI AND ";
        strSelect = strSelect +"OELSORTE = '"+ECL_GetValue("GETRIEBEOEL_2KJ4")+"' AND ";
        strSelect = strSelect +"KONSERVIERUNG.S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect +"OELSORTE_M3.AKTIV = '1' AND ";
        strSelect = strSelect +"KONSERVIERUNG.AKTIV = '1' AND ";
        strSelect = strSelect +"KONSERVIERUNG.M3 = '1' AND ";
        strSelect = strSelect +"OELSORTE_M3.G115 IN ('ALL','0') AND ";
        strSelect = strSelect +"MOTOX_N = '0' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("LANGZEITKONSERVIERUNG_OPTION_2KJ4", "T");
            ECL_EnableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ4");
        }
        else
        {
            ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION_2KJ4", "T");
            ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ4");
        }
    }
}

function BestimmeMaengelhaftung(oData)
{
    
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION_2KJ4", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FT7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1FK7"))  // || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR_2KJ4") == "1MB5"))
    {
        //1FK2 // 1LE1 // 1MB1 // 1MB5
        ECL_DeactivateAllAttributeValues("MAENGELHAFTUNG_2KJ4");
        ECL_ActivateValue("MAENGELHAFTUNG_2KJ4", "0");
        ECL_SelectValue("MAENGELHAFTUNG_2KJ4","0");
        ECL_DisableAttribute("MAENGELHAFTUNG_2KJ4");
    }
    else
    {
        //geht auch bei Drivetrain 1PH8
        ECL_EnableAttribute("MAENGELHAFTUNG_2KJ4");
        
        var strAdapterTyp="-";
        if(ECL_GetValue("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
            strAdapterTyp=ECL_GetValue("ANTRIEBSGRUPPE_TYP_2KJ4");

        var strSelect = "SELECT MAENGELHAFT_KEY FROM M_ADAPTER_M_MAENGELHAFTUNG WHERE ";
        strSelect = strSelect +"ADAP_TYP='"+strAdapterTyp+"' ";
        
        ECL_DeactivateAllAttributeValues("MAENGELHAFTUNG_2KJ4");
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("MAENGELHAFTUNG_2KJ4", aResult[i].MAENGELHAFT_KEY);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Mängelhaftung! SQL="+strSelect);
        }
        
        ExecSetStandardifValueEmpty("MAENGELHAFTUNG_2KJ4","0");
    }
}

function Bestimme_Flanschlackierung(oData)
{

    ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH_2KJ4");
    
    if(ECL_GetValue("BEFESTIGUNGSART_2KJ4") == "F" || ECL_GetValue("BEFESTIGUNGSART_2KJ4") == "Z")
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ4", "Standard");
    }
    
    //L11 und L12
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4") != "UNLACKIERT" && (ECL_GetValue("BEFESTIGUNGSART_2KJ4") == "F" || ECL_GetValue("BEFESTIGUNGSART_2KJ4") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ4", "FKL");
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ4", "FLZN");
    }
    
    //L27
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ4") != "UNLACKIERT" && ((oData.oRow.EGBEZTYP == "K" || oData.oRow.EGBEZTYP == "B") && ECL_GetValue("BEFESTIGUNGSART_2KJ4") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ4", "FLZBN");
    }
    
    var aAttributeValues = ECL_GetAllActiveAttributeValues ("LACKIERUNG_FLANSCH_2KJ4");
    if(aAttributeValues.length>0)
    {
        ECL_ActivateAttribute ("LACKIERUNG_FLANSCH_2KJ4");
        ECL_EnableAttribute("LACKIERUNG_FLANSCH_2KJ4");
        ExecSetStandardifValueEmpty("LACKIERUNG_FLANSCH_2KJ4","Standard");
    }
    else
    {
        ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH_2KJ4");
        ECL_DisableAttribute("LACKIERUNG_FLANSCH_2KJ4");
        ECL_DeactivateAttribute ("LACKIERUNG_FLANSCH_2KJ4");
        ECL_SelectValue("LACKIERUNG_FLANSCH_2KJ4", "Standard");
    }
}