//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

//@import "CFG_2KJ_MECHANISCHE_AUSFUEHRUNG_Model.js"

    
function Bestimme_MotorRLSP(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
        
    strSelect = strSelect + "MOTRLSP = 'X' AND ";
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";
        
    if(ECL_ValueSelected("HANDRAD_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";

    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOTYPX.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOTYPX.ATEX = '0' AND ";
    }
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
        else if(strMotbez.right(1) == "S"){
            strHEMOTOR = 'S';
        }
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";

    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MOTYPX.BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELSDACH = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
	strSelect = strSelect + "MOTYPX.REGION IN ('C','SAC','SACM','SACMTR','SACTR','SAMC','SAMCI','SAMCITR','SAMCTR') AND ";    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL')) ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='ALL') ";
    }
        
    
    var strSelect2="";
    
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    //Weitere Abhängigkeiten über GEBTYPX_M3
    if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
    {
        strSelect2 = "SELECT * FROM GEBTYPX_M3,GEBTYP_M3 WHERE ";
        strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect2 = strSelect2 + "(PAKZUS = '"+strPAKZUS+"' OR PAKZUS = 'ALL') AND ";
        
        if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
            strSelect2 = strSelect2 + "SCHUTZDACH = 'W' AND ";
        else
            strSelect2 = strSelect2 + "SCHUTZDACH = '-' AND ";
            
        if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
            strSelect2 = strSelect2 + "BELART_KONFIG = 'F' AND ";
        else
            strSelect2 = strSelect2 + "BELART_KONFIG = '-U' AND ";
            
        if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
            strSelect2 = strSelect2 + "SHWG = 'I' AND ";
        else
            strSelect2 = strSelect2 + "SHWG = '-' AND ";
        
        strSelect2 = strSelect2 + "MOTRLSP='X' AND ";
        
        strSelect2 = strSelect2 + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4")+"' AND ";
        strSelect2 = strSelect2 + "(BREGERRED = '"+ECL_GetValue("BREMSE_REIBBELAG_2KJ4")+"' OR BREGERRED = '-') AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "ohne")
            strSelect2 = strSelect2 + "(FKTGLR_KNZ = '0' OR FKTGLR_KNZ = '-') AND ";
        else
            strSelect2 = strSelect2 + "(FKTGLR_KNZ = '1' OR FKTGLR_KNZ = '-') AND ";
            
        strSelect2 = strSelect2 + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE_2KJ4")+"' AND ";
        
        if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
            strSelect2 = strSelect2 + "upper(GEB_SHTZ_MECH) = '-' AND ";
        else
            strSelect2 = strSelect2 + "upper(GEB_SHTZ_MECH) = '"+ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4")+"' AND ";
        
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
            strSelect2 = strSelect2 + "KONSTBREM = 'Kauf' AND ";
        else
            strSelect2 = strSelect2 + "KONSTBREM = '-' AND ";
            
        strSelect2 = strSelect2 + "GEBTYP_M3.GEBGRD = GEBTYPX_M3.GEBGRD AND ";
        strSelect2 = strSelect2 + "GEBTYPX_M3.AKTIV='1' AND ";
        strSelect2 = strSelect2 + "GEBTYP_M3.AKTIV='1' AND ";
        
        var strGeber=ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4");
        strGeber=replace(strGeber,"|-","");
        strGeber=replace(strGeber,"|Kauf","");
    
        strSelect2 = strSelect2 + "GEBTYP_M3.GEBER='"+strGeber+"' ";
    }
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T") || ECL_ValueSelected("LANGZEITKONSERVIERUNG_OPTION_2KJ4", "T"))
    {
        //erste Abhängigkeiten
        ECL_DeselectValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T");
        ECL_DisableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if(aResult.length>0)
        {
            if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
            {
                var aResult2 = ExecSQL_Standard_SO("2KJ4_DB", strSelect2);
                if(aResult2.length>0)
                {
                    //Rücklaufsperre möglich
                    ECL_EnableValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T");
                    ECL_EnableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4");
                }
                else
                {
                    ECL_DeselectValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T");
                    ECL_DisableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4");
                }
            }
            else
            {
                //Rücklaufsperre möglich
                ECL_EnableValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T");
                ECL_EnableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4");
            }
        }
        else
        {
            ECL_DeselectValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T");
            ECL_DisableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4");
        }
    }
}

function Bestimme_AbtriebsDrehrichtung(oData,what)
{

    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS;
    strEGTYP = replace(strEGTYP, "-", "");
    
    if(what == "MOTOR")
    {
        var strSelect = "SELECT DISTINCT ANTRIEBSDREHRICHTUNG_MOTOR FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
        
        if(strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '"+ECL_GetValue("ABTRIEBSSEITE_2KJ4")+"' AND ";
        
        if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4") == "links")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4") == "rechts")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CW' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if(aResult.length==1)
        {
            var strRichtung = aResult[0].ANTRIEBSDREHRICHTUNG_MOTOR;
            
            if(strRichtung == "CW")
            {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_2KJ4", "rechts");
            }
            else
            {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_2KJ4", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Motor, SQL="+strSelect);
    }
    else //Getriebe
    {
        var strSelect = "SELECT DISTINCT ABTRIEBSDREHRICHTUNG_GETRIEBE FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
        
        if(strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '"+ECL_GetValue("ABTRIEBSSEITE_2KJ4")+"' AND ";
        
        if(ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ4") == "links")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ4") == "rechts")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CW' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        if(aResult.length==1)
        {
            var strRichtung = aResult[0].ABTRIEBSDREHRICHTUNG_GETRIEBE;
            
            if(strRichtung == "CW")
            {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4", "rechts");
            }
            else
            {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Getriebe, SQL="+strSelect);
    }
}


function Bestimme_MotorZweitesWellenende(oData)
{
    var strSelect = "SELECT DISTINCT MOBSANBZM_ANZ FROM MOZWE WHERE ";
    strSelect = strSelect + "(MOTTYP = '"+oData.oRow.MOTTYP+"' OR MOTTYP = 'ALL') AND ";
    strSelect = strSelect + "(MOTDIM = '"+oData.oRow.MOTDIM+"' OR MOTDIM = 'ALL') AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' OR POLZAHL = 'ALL') AND ";
    strSelect = strSelect + "MOZWE.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOZWE.MOBSANBZM_ANZ <> '-' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";

    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "WM_FU = '0' AND ";
	}
    
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "G115M = '0' AND ";
    strSelect = strSelect + "G115D = '0' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSelect = strSelect + "BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "BELSDACH = '-' AND ";
        
    if(ECL_ValueSelected("BELUEFTUNG_2KJ4", "Zugeordneter Luefter"))
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
        
    if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
        strSelect = strSelect + "KONSTAGEBER = 'Kauf' AND ";
    else
        strSelect = strSelect + "KONSTAGEBER = '-' AND ";
    
    strSelect = strSelect + "REGION IN ('S','SCE') ";
        
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        ECL_EnableValue("ZWEITES_WELLENENDE_OPTION_2KJ4", "T");
        ECL_EnableAttribute("ZWEITES_WELLENENDE_OPTION_2KJ4");
    }
    else
    {
        ECL_DeselectValue("ZWEITES_WELLENENDE_OPTION_2KJ4", "T");
        ECL_DisableAttribute("ZWEITES_WELLENENDE_OPTION_2KJ4");
    }
}

function Bestimme_MotorHandrad(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    
    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}
	
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOTYPX.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOTYPX.ATEX = '0' AND ";
    }
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";

    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTRLSP = '-' AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
        else if(strMotbez.right(1) == "S"){
            strHEMOTOR = 'S';
        }
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ4", "T"))
        strSelect = strSelect + "BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "BELSDACH = '-' AND ";
            
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    //strSelect = strSelect + "MOTYPX.CDROM_REL='1' AND ";
	strSelect = strSelect + "MOTYPX.REGION IN ('C','SAC','SACM','SACMTR','SACTR','SAMC','SAMCI','SAMCITR','SAMCTR') AND ";    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"'AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL')) ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='ALL') ";
    }
    
	if(!ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ4", "T") || ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
	    {
        //Handrad nur bei zweitem Wellenende
        //Handrad nicht bei Geber
        ECL_DeselectValue("HANDRAD_OPTION_2KJ4", "T");
        ECL_DisableAttribute("HANDRAD_OPTION_2KJ4");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("HANDRAD_OPTION_2KJ4", "T");
            ECL_EnableAttribute("HANDRAD_OPTION_2KJ4");
        }
        else
        {
            ECL_DeselectValue("HANDRAD_OPTION_2KJ4", "T");
            ECL_DisableAttribute("HANDRAD_OPTION_2KJ4");
        }
    }
}

function Bestimme_MotorSchutzdach(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";

    if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOTYPX.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOTYPX.ATEX = '0' AND ";
    }
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";

    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTRLSP = '-' AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
        else if(strMotbez.right(1) == "S"){
            strHEMOTOR = 'S';
        }
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    strSelect = strSelect + "BELSDACH = 'W' AND ";
    
    if(ECL_ValueSelected("HANDRAD_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
    
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    //strSelect = strSelect + "MOTYPX.CDROM_REL='1' AND ";
	strSelect = strSelect + "MOTYPX.REGION IN ('C','SAC','SACM','SACMTR','SACTR','SAMC','SAMCI','SAMCITR','SAMCTR') AND ";    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
        
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";

    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ4")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
    {
        strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL')) ";
    }
    else
    {
        strSelect = strSelect + "KONSTBREM='ALL') ";
    }
    
    var strSelect2="";
    var strPAKZUS = Bestimme_PAKZUS(oData);
    //Weitere Abhängigkeiten über GEBTYPX_M3
    if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
    {
        strSelect2 = "SELECT * FROM GEBTYPX_M3,GEBTYP_M3 WHERE ";
        strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
        strSelect2 = strSelect2 + "(PAKZUS = '"+strPAKZUS+"' OR PAKZUS = 'ALL') AND ";
        
        if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ4", "T"))
            strSelect2 = strSelect2 + "MOTRLSP = 'X' AND ";
        else
            strSelect2 = strSelect2 + "MOTRLSP = '-' AND ";
            
        if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Zugeordneter Luefter")
            strSelect2 = strSelect2 + "BELART_KONFIG = 'F' AND ";
        else
            strSelect2 = strSelect2 + "BELART_KONFIG = '-U' AND ";
            
        if(ECL_GetValue("BELUEFTUNG_2KJ4") == "Schwungradluefter")
            strSelect2 = strSelect2 + "SHWG = 'I' AND ";
        else
            strSelect2 = strSelect2 + "SHWG = '-' AND ";
        
        strSelect2 = strSelect2 + "SCHUTZDACH='W' AND ";
        
        strSelect2 = strSelect2 + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ4")+"' AND ";
        strSelect2 = strSelect2 + "(BREGERRED = '"+ECL_GetValue("BREMSE_REIBBELAG_2KJ4")+"' OR BREGERRED = '-') AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ4") == "ohne")
            strSelect2 = strSelect2 + "(FKTGLR_KNZ = '0' OR FKTGLR_KNZ = '-') AND ";
        else
            strSelect2 = strSelect2 + "(FKTGLR_KNZ = '1' OR FKTGLR_KNZ = '-') AND ";
            
        strSelect2 = strSelect2 + "MOTWK = '"+ECL_GetValue("WAERMEKLASSE")+"' AND ";
        
        if(ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4") == "UNTER_HAUBE")
            strSelect2 = strSelect2 + "upper(GEB_SHTZ_MECH) = '-' AND ";
        else
            strSelect2 = strSelect2 + "upper(GEB_SHTZ_MECH) = '"+ECL_GetValue("GEBER_MECHSCHUTZ_2KJ4")+"' AND ";
        
        if(ECL_ValueSelected("MIT_BREMSE_2KJ4", "T"))
            strSelect2 = strSelect2 + "KONSTBREM = 'Kauf' AND ";
        else
            strSelect2 = strSelect2 + "KONSTBREM = '-' AND ";
            
        strSelect2 = strSelect2 + "GEBTYP_M3.GEBGRD = GEBTYPX_M3.GEBGRD AND ";
        strSelect2 = strSelect2 + "GEBTYPX_M3.AKTIV='1' AND ";
        strSelect2 = strSelect2 + "GEBTYP_M3.AKTIV='1' AND ";
        
        strSelect2 = strSelect2 + "GEBTYP_M3.GEBER='"+ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ4")+"' ";
    }
    
    if(ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ4", "T"))
    {
        ECL_DeselectValue("SCHUTZDACH_OPTION_2KJ4", "T");
        ECL_DisableAttribute("SCHUTZDACH_OPTION_2KJ4");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        if ( aResult.length > 0 )
        {
            if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
            {
                var aResult2 = ExecSQL_Standard_SO("2KJ4_DB", strSelect2);
                if(aResult2.length>0)
                {
                    ECL_EnableValue("SCHUTZDACH_OPTION_2KJ4", "T");
                    ECL_EnableAttribute("SCHUTZDACH_OPTION_2KJ4");
                }
                else
                {
                    ECL_DeselectValue("SCHUTZDACH_OPTION_2KJ4", "T");
                    ECL_DisableAttribute("SCHUTZDACH_OPTION_2KJ4");
                }
            }
            else
            {
                    ECL_EnableValue("SCHUTZDACH_OPTION_2KJ4", "T");
                    ECL_EnableAttribute("SCHUTZDACH_OPTION_2KJ4");
            }
        }
        else
        {
            ECL_DeselectValue("SCHUTZDACH_OPTION_2KJ4", "T");
            ECL_DisableAttribute("SCHUTZDACH_OPTION_2KJ4");
        }
    }
}

function Bestimme_MotorKondenswasserbohrung(oData)
{	
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strSelect = "SELECT * FROM MOKOWALO WHERE ";
    strSelect = strSelect + "EGBEZTYP = '"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "(EGBEZDIM = '"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM = 'ALL') AND ";
    strSelect = strSelect + "(EGPOSHL = '"+ECL_GetValue("BAUFORM_2KJ4")+"' OR EGPOSHL = 'ALL') AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOABFLDM = '"+oData.oRow.EGANFLDM+"' AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    strSelect = strSelect + "PAKZUS='"+strPAKZUS+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART_2KJ4")+"' AND ";
    strSelect = strSelect + "(MOKOWALO_AS = '1' OR MOKOWALO_BS = '1') AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    
    
    strSelect = strSelect + "SONDER = '-' AND ";
    strSelect = strSelect + "G115M = '0' AND ";
    strSelect = strSelect + "G115D = '0' AND ";
    strSelect = strSelect + "AKTIV = '1' ";
    
    //Kondenswasserbohrung bei Sondereinbaulage nicht möglich
    
    var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
    if ( aResult.length > 0 )
    {
        ECL_EnableValue("KONDENSWASSERBOHRUNG_OPTION_2KJ4", "T");
        ECL_EnableAttribute("KONDENSWASSERBOHRUNG_OPTION_2KJ4");
    }
    else
    {
        ECL_DeselectValue("KONDENSWASSERBOHRUNG_OPTION_2KJ4", "T");
        ECL_DisableAttribute("KONDENSWASSERBOHRUNG_OPTION_2KJ4");
    }
}

function Bestimme_MotorInnenkorrosionsschutz(oData)
{	
    var strSelect = "SELECT DISTINCT MOINNENKORSCH FROM MOINNENKORSCH WHERE ";
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOINNENKORSCH.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOINNENKORSCH.ATEX = '0' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    
    //BRANCHE abfragen
    if(oData.oRow.ANWTYP=="Kuehlturm")
        strSelect = strSelect + "BRANCHE = 'Kuehlturm' AND ";
    else if(oData.oRow.ANWTYP=="Haengebahn")
        strSelect = strSelect + "BRANCHE = 'Haengebahn' AND ";
    else
        strSelect = strSelect + "BRANCHE = 'Standard' AND ";
    
    if(ECL_ValueSelected("MIT_GEBER_2KJ4", "T"))
    {
        if(ECL_GetValue("GEBER_FUNKT_SICHERHEIT_2KJ4")=="Kauf")
            strSelect = strSelect + "FKTSICHERHEIT IN ('ja','SIL3/PLe','SIL2/PLd') AND ";
        else
            strSelect = strSelect + "FKTSICHERHEIT = '-' AND ";
    }
    else
        strSelect = strSelect + "FKTSICHERHEIT = '-' AND ";
        
    strSelect = strSelect + "REGION IN ('S','SCE') "
    
    if(ECL_GetValue("WAERMEKLASSE_2KJ4")=="H")
    {
        ECL_DeselectValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ4", "T");
        ECL_DisableAttribute("INNENKORROSIONSSCHUTZ_OPTION_2KJ4");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ4_DB", strSelect);
        
        var Abwahlmoeglich=false;
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                if(aResult[i].MOINNENKORSCH=="ja")
                {
                    ECL_EnableValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ4", "T");
                }
                else
                {
                    Abwahlmoeglich=true;
                }
            }
        }
        else
        {
            logtraceln("Fehler bei Bestimmung des Motorinnenkorrosionschutzes! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(!Abwahlmoeglich && ECL_ValueEnabled("INNENKORROSIONSSCHUTZ_OPTION_2KJ4", "T"))
        {
            ECL_SelectValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ4", "T");
        }
            
    }
}
