//@legacy
//#mode(full-ecma)



//@import "../2KJ4_CONFIG/VT_TF.js"

//@import "../2KJ4_CONFIG/2KJ_Functions.js"



/**
 * get the MLFB part for the geared motor product area (digit 1-4)
 * @param bSimogear - SimoGear (true) or MOTOX-N (false)
 *
 * @return string - MLFB-part for the product area (4 digits)
 */
function getPraefixMLFB()
{
    return( '2KJ4' );
}


/**
 * get the MLFB part for the gear of the geared motor (digits 5-7)
 *
 * @param strEGBEZTYP - gear base type
 * @param strEGBEZUEBS - gear ratio stage
 * @param strEGBEZEI - gear development index
 * @param strEGBEZDIM - gear size
 * @param strZGBEZDIM - gear size fo secondary gear
 * @param strZGBEZEI - development index for secondary gear
 * @param strZGBEZUEBS - ratio stage for secondary gear
 *
 * @return string - MLFB-part for the gear of the geared motor (3 digits)
 */
function getGearMLFB( strEGBEZTYP, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strZGBEZDIM, strZGBEZEI, strZGBEZUEBS, strEGBEZBRA )
{
    var strRegion = "";
    var strGearMLFB = '...';
    
    var strSelect;
   	
    strSelect = "SELECT MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7 from MLFB4_EGTYP where EGBEZTYP='" + strEGBEZTYP + "' and EGBEZUEBS='" + strEGBEZUEBS + "' and EGBEZEI='" + strEGBEZEI + 
                    "' and EGBEZDIM='" + strEGBEZDIM + "' and EGBEZBRA='"+strEGBEZBRA+"' ";
    if ( ( strZGBEZDIM === '' ) && ( strZGBEZEI === '' ) && ( strZGBEZUEBS === '' ) )
        strSelect += " and ZGBEZDIM='-' and ZGBEZEI ='-' and ZGBEZUEBS='-' ";
    else strSelect += " and ZGBEZDIM='" + strZGBEZDIM + "' and ZGBEZEI ='" + strZGBEZEI + "' and ZGBEZUEBS='" + strZGBEZUEBS + "' ";


    var strResultTable = 'MLFB_GEAR';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
        strGearMLFB = dbgetstring( strResultTable, 'MLFB_2KJ_5' ) + dbgetstring( strResultTable, 'MLFB_2KJ_6' ) + dbgetstring( strResultTable, 'MLFB_2KJ_7' );
    // else not decidable -> return the dots
    
    return( strGearMLFB );
}


/**
 * get the MLFB part for the shaft of the geared motor (digit 8)
 * you may get an additional necessary short description for the shaft
 *
 * @param strGearType - gear type
 * @param strShaftMass - shaft measurement
 * 
 * @return object - strMLFBPart: MLFB-Part for shaft (1 digit)
 *                  strShortDescription: necessary short description for shaft (only nonempty if the shaft part of the MLFB is 9)
 */
function getShaftMLFB( oMOTOX, strShaftMass )
{
    var oMLFB = {
        strMLFBPart: '.',
        strShortDescription: ''
    };
    
    var strWelle = ECL_GetValue("ABTRIEBSWELLENART_2KJ4");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    strShaftMass=replace(strShaftMass,'ZOLL','"');
    
    var strEGTYP = oMOTOX.oRow.EGBEZTYP+oMOTOX.oRow.EGBEZUEBS+oMOTOX.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART_2KJ4")+Verbindungsart;
    
    strEGTYP = strEGTYP + oMOTOX.oRow.EGBEZDIM+oMOTOX.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    var strSelect = "SELECT MLFB_2KJ_8, MLFB_2KJ_8_KA from EGABKD_M3 where EGTYP = '" + strEGTYP + "' and EGABW = '" + strShaftMass + "' AND ";
    
    strSelect = strSelect + "CDROM_REL = '1' AND G115='0' AND REGION='S' ";
    
    var strResultTable = 'MLFB_SHAFT';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
    {
        oMLFB.strMLFBPart = dbgetstring( strResultTable, 'MLFB_2KJ_8' );
        oMLFB.strShortDescription = dbgetstring( strResultTable, 'MLFB_2KJ_8_KA' );
        if ( ( oMLFB.strShortDescription === '-' ) || ( oMLFB.strShortDescription === ' ' ) )
            oMLFB.strShortDescription = '';
    }
    // else not decidable -> return the defaults
    
    return( oMLFB );
}


/**
 * get the MLFB part for the motor size, power, type and the motor voltage of the geared motor (digits 9-12: motor type, digits 13: motor voltage)
 * you may get an additional necessary short description for motor voltage and an additional short description for special motor powers
 *
 * @param oGear - MOTOX gear object
 * 
 * @return object - strMLFBPart: MLFB-Part for motor size, power, type and motor voltage (5 digits)
 *                  strSDVoltage: necessary short description for motor voltage (only nonempty if the motor voltage part of the MLFB is 9)
 *                  strSDPower: additional short description for motor power (may be empty)
 *                  strSDSpecification: additional short description for the selected motor specification
 */
function getMotorMLFB( oGear )
{
    var oMLFB = {
        strMLFBPart: '.....',
        strSDVoltage: '',
        strSDPower: '',
        strSDSPGTOL: '',
        strSDBART: '',
        strSDSpecification: '',
        strATEXZoneSD: ''
    };
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        // ATEX Zone Kurzangaben für Checks
        if(ECL_GetValue("ATEX_ZONE_2KJ4")=="2")
            oMLFB.strATEXZoneSD="K72";
        else if(ECL_GetValue("ATEX_ZONE_2KJ4")=="22")
            oMLFB.strATEXZoneSD="K74";
        else
        {
            logtraceln("Error; unbekannte ATEX Zone! Zone="+ECL_GetValue("ATEX_ZONE_2KJ4"));
            oMLFB.strATEXZoneSD="ERROR";
        }
    }
    else
        oMLFB.strATEXZoneSD="";
    
    var strFrequenz = oGear.oRow.FREQUENZ;
    
    var strSelect = 'SELECT DISTINCT MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, MLFB_2KJ_13_KA,MLFB_2KJ_13_KA_SPGTOL,MLFB_2KJ_BART_KA FROM CD_MOTOREN WHERE ';
    
    strSelect = strSelect + "MOTELAUSF='"+createSpecString(oGear)+"' AND ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        if(strFrequenz=="50" || strFrequenz=="60"){
            strSelect = strSelect + "(FREQUENZ_1='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ_2='"+oGear.oRow.FREQUENZ+"') AND ";
        }
        else if(strFrequenz=="87"){
            strSelect = strSelect + "FREQUENZ_1='"+oGear.oRow.FREQUENZ+"' AND ";
        }

        strSelect = strSelect + "MOTTYP='MB' AND ";
    }
    else if(oGear.oRow.VSDMOTOR=="V")
    {		
        if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
        {
            if(strFrequenz=="50" || strFrequenz=="87"){
                strSelect = strSelect + "FREQUENZ_1='"+oGear.oRow.ORIG_MOTFHT_FREQUENZ_1+"' AND ";
            }
            else if(strFrequenz=="60" || strFrequenz=="104"){
                strSelect = strSelect + "FREQUENZ_2='"+oGear.oRow.ORIG_MOTFHT_FREQUENZ_2+"' AND ";
            }
        }
    else
    {
        if(strFrequenz=="50" || strFrequenz=="60"){
            strSelect = strSelect + "(FREQUENZ_1='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ_2='"+oGear.oRow.FREQUENZ+"') AND ";
        }
        else if(strFrequenz=="87"){
            strSelect = strSelect + "(FREQUENZ_1='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ2_1='"+oGear.oRow.FREQUENZ+"') AND ";
        }
    }
    
        strSelect = strSelect + "MOTTYP='"+oGear.oRow.MOTTYP+"' AND ";
    }
    else
    {
        if(strFrequenz=="50" || strFrequenz=="60"){
            strSelect = strSelect + "(FREQUENZ_1='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ_2='"+oGear.oRow.FREQUENZ+"') AND ";
        }
        else if(strFrequenz=="87"){
            strSelect = strSelect + "(FREQUENZ_2='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ2_1='"+oGear.oRow.FREQUENZ+"') AND ";
        }
        else if(strFrequenz=="104"){
            strSelect = strSelect + "(FREQUENZ2_1='"+oGear.oRow.FREQUENZ+"' OR FREQUENZ2_2='"+oGear.oRow.FREQUENZ+"') AND ";
        }

        strSelect = strSelect + "MOTTYP='"+oGear.oRow.MOTTYP+"' AND ";
    }
    
    strSelect = strSelect + "MOTWK = '" + ECL_GetValue("WAERMEKLASSE_2KJ4") + "' AND ";
    
    
    //Spannung  auseinanderklabüstern
    var teilspannung1="";
    var teilspannung2="";
    var teilschaltung1="";
    var teilschaltung2="";
    var schaltung="";
    
    var strSpannung = ECL_GetValue("MOTORSPANNUNG_2KJ4");
    
    var i = find(strSpannung, "/");
    if(i > -1)
    {
        teilspannung1 = strSpannung.left(i-1);
        teilspannung2 = strSpannung.right(strSpannung.length-i);
        teilspannung1 = trimright(teilspannung1, " ");
        teilspannung2 = trimleft(teilspannung2, " ");
        
        if(find(teilspannung1,"D") > -1)
            teilschaltung1 = teilspannung1.right(teilspannung1.length-find(teilspannung1,"D")+1);
        else if(find(teilspannung1,"Y") > -1)
            teilschaltung1 = teilspannung1.right(teilspannung1.length-find(teilspannung1,"Y")+1);
            
        if(find(teilspannung2,"D") > -1)
            teilschaltung2 = teilspannung2.right(teilspannung2.length-find(teilspannung2,"D")+1);
        else if(find(teilspannung2,"Y") > -1)
            teilschaltung2 = teilspannung2.right(teilspannung2.length-find(teilspannung2,"Y")+1);
        schaltung=teilschaltung1+"/"+teilschaltung2;
        
        teilspannung1 = left(teilspannung1,3);
        teilspannung2 = left(teilspannung2,3);
        
    }
    else
    {
        if(find(strSpannung,"D") > -1)
            teilschaltung1 = "D";
        else if(find(strSpannung,"Y") > -1)
            teilschaltung1 = "Y";
        
        schaltung=teilschaltung1;
        
        teilspannung1 = left(strSpannung,3);
        teilspannung2 = "-";
    }
    
    //Spannung 
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        if(strFrequenz == "50")
            strSelect = strSelect + "MOTSPG_1 = '" + teilspannung1 + "' AND MOTSPG_3 = '" + teilspannung2 + "' AND ";
        else if(strFrequenz == "60")
            strSelect = strSelect + "(MOTSPG_1 = '" + teilspannung1 + "' AND MOTSPG_3 = '" + teilspannung2 + "' OR  MOTSPG_5 = '" + teilspannung1 + "' AND MOTSPG_7 = '" + teilspannung2 + "') AND ";
        else if(strFrequenz == "87")
            strSelect = strSelect + "MOTSPG_1 = '" + teilspannung1 + "' AND ";
        

    }
    else
    {
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			strSelect = strSelect + "MOTSPG_1 = '" + oGear.oRow.ORIG_MOTFHT_MOTSPG_1 + "' AND MOTSPG_5 = '" + oGear.oRow.ORIG_MOTFHT_MOTSPG_5 + "' AND ";
		}
		else
		{
			if(strFrequenz == "50"){
				strSelect = strSelect + "MOTSPG_1 = '" + teilspannung1 + "' AND MOTSPG_3 = '" + teilspannung2 + "' AND ";
            }
            else if(strFrequenz == "60"){
				strSelect = strSelect + "(MOTSPG_1 = '" + teilspannung1 + "' AND MOTSPG_3 = '" + teilspannung2 + "' OR  MOTSPG_5 = '" + teilspannung1 + "' AND MOTSPG_7 = '" + teilspannung2 + "') AND ";
            }
            else if(strFrequenz == "87"){
				strSelect = strSelect + "(MOTSPG_5 = '" + teilspannung1 + "' AND MOTSPG_7 = '" + teilspannung2 + "' OR  MOTSPG2_1 = '" + teilspannung1 + "' AND MOTSPG2_3 = '" + teilspannung2 + "') AND ";
            }
            else if(strFrequenz == "104"){
				strSelect = strSelect + "MOTSPG2_5 = '" + teilspannung1 + "' AND MOTSPG2_7 = '" + teilspannung2 + "' AND ";
            }
        }
    }
    
    //Schaltung
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        if(oGear.oRow.FREQUENZ == "50"){
            strSelect = strSelect + "MOTSHLT1_1 = '" + schaltung + "' AND "; 
        }
        else if(oGear.oRow.FREQUENZ == "60"){
            strSelect = strSelect + "(MOTSHLT1_1 = '" + schaltung + "' OR MOTSHLT12_1 = '" + schaltung + "') AND "; 
        }
        else if(oGear.oRow.FREQUENZ == "87"){
            strSelect = strSelect + "MOTSHLT1_1 = '" + schaltung + "' AND "; 
        }
    }
    else if(oGear.oRow.VSDMOTOR=="V")
    {
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			strSelect = strSelect + "MOTSHLT1_1 = '" + oGear.oRow.ORIG_MOTFHT_MOTSHLT1_1 + "' AND "; 
			strSelect = strSelect + "MOTSHLT12_1 = '" + oGear.oRow.ORIG_MOTFHT_MOTSHLT12_1 + "' AND "; 
		}
		else
		{
			if(oGear.oRow.FREQUENZ == "50"){
				strSelect = strSelect + "MOTSHLT1_1 = '" + schaltung + "' AND "; 
            }
            else if(oGear.oRow.FREQUENZ == "60"){
				strSelect = strSelect + "(MOTSHLT1_1 = '" + schaltung + "' OR MOTSHLT12_1 = '" + schaltung + "') AND "; 
            }
            else if(oGear.oRow.FREQUENZ == "87"){
				strSelect = strSelect + "(MOTSHLT1_1 = '" + schaltung + "' OR MOTSHLT2_1 = '" + schaltung + "') AND "; 
            }
        }
    }
    else
    {
        if(oGear.oRow.FREQUENZ == "50"){
            strSelect = strSelect + "MOTSHLT1_1 = '" + schaltung + "' AND "; 
        }
        else if(oGear.oRow.FREQUENZ == "60"){
            strSelect = strSelect + "(MOTSHLT1_1 = '" + schaltung + "' OR MOTSHLT12_1 = '" + schaltung + "') AND "; 
        }
        else if(oGear.oRow.FREQUENZ == "87"){
            strSelect = strSelect + "(MOTSHLT12_1 = '" + schaltung + "' OR MOTSHLT2_1 = '" + schaltung + "') AND "; 
        }
        else if(oGear.oRow.FREQUENZ == "104"){
            strSelect = strSelect + "MOTSHLT2_1 = '" + schaltung + "' AND "; 
        }
    }
    
    //Motor Betriebsart
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        if(oGear.oRow.FREQUENZ == "50")
            strSelect = strSelect + "(MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "60")
            strSelect = strSelect + "( MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "87")
            strSelect = strSelect + "MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' AND "; 
    }
    else if(oGear.oRow.VSDMOTOR=="V")
    {
        if(oGear.oRow.FREQUENZ == "50")
            strSelect = strSelect + "(MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "60")
            strSelect = strSelect + "( MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "87")
            strSelect = strSelect + "(MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART21 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
    }
    else
    {
        if(oGear.oRow.FREQUENZ == "50")
            strSelect = strSelect + "(MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "60")
            strSelect = strSelect + "( MOTBART11 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "87")
            strSelect = strSelect + "(MOTBART12 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' OR MOTBART21 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "') AND "; 
        else if(oGear.oRow.FREQUENZ == "104")
            strSelect = strSelect + "MOTBART22 = '" + ECL_GetValue("BETRIEBSART_2KJ4") + "' AND "; 
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
        strSelect = strSelect + "MLFB_2KJ_13_KA = '" + ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_KA_2KJ4") + "' AND "; 
        
        //Bei Spezifikation CHINA gibt es noch Zusatzangaben bei der Wirkungsggradklasse
        
        var strEFFKlasse_China="";
        var strEFFKlasse_China_2="";
        if(oGear.oRow.MOTFHT_EFFKLASSE.indexOf("grade")==-1)
        {
            if(oGear.oRow.MOTFHT_EFFKLASSE.left(3)=="IE2")
            {
                strEFFKlasse_China=oGear.oRow.MOTFHT_EFFKLASSE.substring(0,3)+"_grade3"+oGear.oRow.MOTFHT_EFFKLASSE.substring(3,oGear.oRow.MOTFHT_EFFKLASSE.length);
            }
            else if(oGear.oRow.MOTFHT_EFFKLASSE.left(3)=="IE3")
            {
                strEFFKlasse_China=oGear.oRow.MOTFHT_EFFKLASSE.substring(0,3)+"_grade2"+oGear.oRow.MOTFHT_EFFKLASSE.substring(3,oGear.oRow.MOTFHT_EFFKLASSE.length);
                strEFFKlasse_China_2=oGear.oRow.MOTFHT_EFFKLASSE.substring(0,3)+"_grade3"+oGear.oRow.MOTFHT_EFFKLASSE.substring(3,oGear.oRow.MOTFHT_EFFKLASSE.length);
            }
            
            strSelect = strSelect + "(EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE+"' OR EFFKLASSE = '"+strEFFKlasse_China+"' OR EFFKLASSE = '"+strEFFKlasse_China_2+"')  AND "; 
        }
        else if(oGear.oRow.MOTFHT_EFFKLASSE.indexOf("grade")>-1)
        {
            if(oGear.oRow.MOTFHT_EFFKLASSE.left(3)=="IE2")
            {
                strSelect = strSelect + "(EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE+"' OR EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE.replace("_grade3","")+"')  AND "; 
            }
            else if(oGear.oRow.MOTFHT_EFFKLASSE.left(3)=="IE3")
            {
                strSelect = strSelect + "(EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE+"' OR EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE.replace("_grade2","")+"' OR EFFKLASSE = '"+oGear.oRow.MOTFHT_EFFKLASSE.replace("_grade3","")+"')  AND "; 
            }
        }
        
        strSelect = strSelect + "HEMOTOR = '"+oGear.oRow.MOTFHT_HEMOTOR+"' AND "; 
        
        strSelect = strSelect + "VSDMOTOR='"+oGear.oRow.VSDMOTOR+"' AND ";
    }
    else
    {
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ4","VSD_4000"))
            strSelect = strSelect + "VSDMOTOR='V' AND ";
        else
            strSelect = strSelect + "VSDMOTOR='-' AND ";
            
        if(ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK_2KJ4","ULR_CSA"))
            strSelect = strSelect + "MOTELAUSF IN ('UL-R/CSA') AND ";
    }
    
    if(ECL_ValueSelected("SPANNUNGSTOLERANZ_OPTION_2KJ4", "T"))
        strSelect = strSelect + "MLFB_2KJ_13_KA_SPGTOL = 'P80' AND "; 
    else
        strSelect = strSelect + "MLFB_2KJ_13_KA_SPGTOL = '-' AND "; 
    
    strSelect = strSelect + "MLFB_2KJ_P_KA = '" + ECL_GetValue("ECSI_MOTORSPANNUNG_P_KA_2KJ4") + "' AND "; 
    
    strSelect = strSelect + "POLZAHL = '" + ECL_GetValue("ECSI_POLZAHL_2KJ4") + "' AND "; 
    strSelect = strSelect + "MOTDIM = '" + oGear.oRow.MOTDIM + "' AND ";  
    
    var ERH_Leistung="";
    if(ECL_ValueSelected("ERHOEHTE_LEISTUNG_OPTION_2KJ4", "T"))
        ERH_Leistung = "true";
    else
        ERH_Leistung = "false";
    
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
    {
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			strSelect = strSelect + "LEISTUNG1 = '" + oGear.oRow.MOTFHT_LEISTUNG1 + "' AND LEISTUNG4 = '" + oGear.oRow.MOTFHT_LEISTUNG4 + "'  AND "; 
		}
		else
		{
			strSelect = strSelect + "( LEISTUNG1 = '" + oGear.oRow.MOTFHT_LEISTUNG1 + "' AND (LEISTUNG4 = '" + oGear.oRow.MOTFHT_LEISTUNG4 + "' OR LEISTUNG4 isnull ) AND (LEISTUNG21 = '" + oGear.oRow.MOTFHT_LEISTUNG21 + "' OR LEISTUNG21 isnull ) AND (LEISTUNG24 = '" + oGear.oRow.MOTFHT_LEISTUNG24 + "'  OR LEISTUNG24 isnull) ) AND "; 
		}
    }
    else
    {
        if(strFrequenz == "50")
        {
            strSelect = strSelect + "LEISTUNG1 = '" + oGear.oRow.LEISTUNG + "' AND ";  
        }
        else if(strFrequenz == "60")
        {
            strSelect = strSelect + "( LEISTUNG1 = '" + oGear.oRow.LEISTUNG + "' OR LEISTUNG2 = '" + oGear.oRow.LEISTUNG + "' OR LEISTUNG4 = '" + oGear.oRow.LEISTUNG + "') AND ";  
        }
        else if(strFrequenz == "87")
        {
            strSelect = strSelect + "(LEISTUNG21 = '" + oGear.oRow.LEISTUNG + "' OR LEISTUNG4 = '" + oGear.oRow.LEISTUNG + "') AND ";  
        }
        else if(strFrequenz == "104")
        {
            strSelect = strSelect + "LEISTUNG24 = '" + oGear.oRow.LEISTUNG + "' AND ";  
        }
    }
    
    var strMOTBEZ = oGear.oRow.MOT_BZ_LANG;
    var strPAKLGE = trimright(strMOTBEZ,"SV");
    var strPAKLGE = trimright(strPAKLGE,"PV");
    strPAKLGE = trimright(strPAKLGE,"S");
    strPAKLGE = trimright(strPAKLGE,"E");
    strPAKLGE = trimright(strPAKLGE,"P");
    strPAKLGE = trimright(strPAKLGE,"4");
    
    strPAKLGE = trimleft(strPAKLGE,"LH");
    strPAKLGE = trimleft(strPAKLGE,"LJ");
    strPAKLGE = trimleft(strPAKLGE,"MB");
    strPAKLGE = trimleft(strPAKLGE,"S");
    strPAKLGE = trimleft(strPAKLGE,"N");
    strPAKLGE = trimleft(strPAKLGE,"I");

    strPAKLGE = strPAKLGE.replace(/[^a-zA-Z]/g, '');
    
    strPAKLGE = trimleft(strPAKLGE,"Y");
    strPAKLGE = trimleft(strPAKLGE,"Z");
    
    
    strSelect = strSelect + "PAKLGE = '" + strPAKLGE + "' AND ";
    
    
    var strATEXZone="";
    var strATEXExplosionsgruppe="";
    var strATEXUmrichter="";
    var strATEXKNZ_MOTFHT="";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strATEXZone=ECL_GetValue("ATEX_ZONE_2KJ4");
        strATEXExplosionsgruppe=ECL_GetValue("ATEX_EXPLOSIONSGRUPPE_2KJ4");
        strATEXUmrichter=ECL_GetValue("ATEX_Umrichter_2KJ4");
        
        var strSelectATEX="";
        
        strSelectATEX="Select DISTINCT EX_SCHUTZ FROM ATEXKNZMOTOR WHERE ZONE='"+strATEXZone+"' AND ATEXKATEGORIE='"+strATEXExplosionsgruppe+"' AND M3='1' AND INFO_MOTTYP='MB' AND AKTIV='1' ";
        var aResult =  Object.fromDatabase( '2KJ4_DB', strSelectATEX );
    
        if(aResult.length>0)
            strATEXKNZ_MOTFHT=left(aResult[0].EX_SCHUTZ,20)+"%";
        else
            logtraceln("Fehler beim Generieren der Motor MLFB ATEX!");
        
    }
    
    if(ECL_GetValue("ECSI_ATEX_KENNER_2KJ4") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "EX_SCHUTZ like '"+strATEXKNZ_MOTFHT+"' AND "; 
        
        if(strATEXUmrichter=="G120_PM240")
        {
            strSelect = strSelect + "MLFB_2KJ_BART_KA = 'P94' "; 
        }
        else if(strATEXUmrichter=="S120_ALM")
        {
            strSelect = strSelect + "MLFB_2KJ_BART_KA = 'P95' "; 
        }
        else if (strATEXUmrichter=="G120_PM250")
        {
            strSelect = strSelect + "MLFB_2KJ_BART_KA = 'P96' "; 
        }
    }
    else
    {
		if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja")
		{
			strSelect = strSelect + "MLFB_2KJ_BART_KA = '-' "; 
		}
		else
		{
			//nur KA P91 und P92 aktiv, da zur Zeit nur Umrichtermotoren
			strSelect = strSelect + "(MLFB_2KJ_BART_KA = 'P91' OR MLFB_2KJ_BART_KA = 'P92') "; 
		}
    }
        
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "EASYKAT_CONFIG")
        strSelect = strSelect + "ORDER BY MLFB_2KJ_13_KA";

    //BugTesting
    //var aResult = Object.fromDatabase( '2KJ4_DB', strSelect );

    var strResultTable = 'MLFB_MOTOR';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
    {
        oMLFB.strMLFBPart = dbgetstring( strResultTable, 'MLFB_2KJ_9' ) + dbgetstring( strResultTable, 'MLFB_2KJ_10' ) + dbgetstring( strResultTable, 'MLFB_2KJ_11' ) + 
                            dbgetstring( strResultTable, 'MLFB_2KJ_12' ) + dbgetstring( strResultTable, 'MLFB_2KJ_13' );
        
        oMLFB.strSDVoltage = dbgetstring( strResultTable, 'MLFB_2KJ_13_KA' );
        if ( oMLFB.strSDVoltage === '-' )
            oMLFB.strSDVoltage = '';
        oMLFB.strSDPower = dbgetstring( strResultTable, 'MLFB_2KJ_P_KA' );
        if ( ( oMLFB.strSDPower === '-' ) || ( oMLFB.strSDPower === '#' ) )
            oMLFB.strSDPower = '';
        oMLFB.strSDSPGTOL = dbgetstring( strResultTable, 'MLFB_2KJ_13_KA_SPGTOL' );
        if ( ( oMLFB.strSDSPGTOL === '-' ) )
            oMLFB.strSDSPGTOL = '';
        oMLFB.strSDBART = dbgetstring( strResultTable, 'MLFB_2KJ_BART_KA' );
        if ( ( oMLFB.strSDBART === '-' ) )
            oMLFB.strSDBART = '';

        //Werte setzen
        ECL_SetValue ("ECSI_MOTORSPANNUNG_SPG_KA_2KJ4", dbgetstring( strResultTable, 'MLFB_2KJ_13_KA' ));
        ECL_SetValue ("ECSI_MOTORSPANNUNG_BART_KA_2KJ4", dbgetstring( strResultTable, 'MLFB_2KJ_BART_KA' ));
        ECL_SetValue ("ECSI_MOTORSPANNUNG_P_KA_2KJ4", dbgetstring( strResultTable, 'MLFB_2KJ_P_KA' ));
        ECL_SetValue ("ECSI_MOTORSPANNUNG_SPGTOL_KA_2KJ4", dbgetstring( strResultTable, 'MLFB_2KJ_13_KA_SPGTOL' ));
        
        //KA für Spezifikation
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ4") == "SIZER_CONFIG")
        {
            oMLFB.strEXPORT="";
            
            if( ECL_GetValue("SPEZIFIKATION_CHINA_2KJ4") == "T" && oGear.oRow.VSDMOTOR != "V")
            {
                oMLFB.strCHINA = "";
            }
            else{
                oMLFB.strCHINA = "";
            }
            
            if( ECL_GetValue("SPEZIFIKATION_CHINA_EX_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strCCC_Ex = "N32";
            }
            else{
                oMLFB.strCCC_Ex = "";
            }

            if(ECL_GetValue("SPEZIFIKATION_EAC_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strEAC = "N30";
            }
            else{ 
                oMLFB.strEAC = "";
            }

            if(ECL_GetValue("SPEZIFIKATION_BIS_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strBIS = "N27";
            }
            else{ 
                oMLFB.strBIS = "";
            }

            if(ECL_GetValue("SPEZIFIKATION_KEMCO_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strKEMCO = "N33";
            }
            else{ 
                oMLFB.strKEMCO = "";
            }

            if(ECL_GetValue("SPEZIFIKATION_ULR_CSA_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strULR_CSA = "N38";
            }
            else{
                oMLFB.strULR_CSA = "";
            }

            if(ECL_GetValue("SPEZIFIKATION_CE_EXPORT_2KJ4") == "T" && ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")!="ja")
            {
                oMLFB.strCE = "N69";
            }
            else{
                oMLFB.strCE = "";
            }
           
        }
    }
    else
    {
        logtraceln("SQL ERROR, SQL="+strSelect);
    }
    
    return( oMLFB );
}

function getAdapterMLFB( oGear )
{
    var oMLFB = {
        strMLFBPart: '.....',
        strSDVoltage: '',
        strSDPower: '',
        strSDSPGTOL: '',
        strSDBART: '',
        strSDSpecification: ''
    };
    
    var strMLFB_AVTYP = "MLFB4_AVTYP"

    /*
    if ( oGear.strSpecification === 'EAC' )
        oMLFB.strSDSpecification = 'N30';
    
    //Für Region China, KA N69 für CE Spezifikation ausgeben
    if ( oGear.strSpecification === 'CE' && strMLFB_AVTYP == "MLFB4_AVTYP")
        oMLFB.strSDSpecification = 'N69';
    */	
        
    var strSelect = "SELECT DISTINCT MLFB_2KJ_9, MLFB_2KJ_12 FROM "+strMLFB_AVTYP+" WHERE ";
    strSelect = strSelect + "AVMLFBTYP = '"+ECL_GetValue("ANTRIEBSGRUPPE_TYP_2KJ4")+"' AND ";
    strSelect = strSelect + "AVTYPDIM = '"+ECL_GetValue("ANTRIEBSGRUPPE_SIZE_2KJ4")+"' AND ";
    strSelect = strSelect + "LKB = '-' ";
    
    var strResultTable = 'MLFB_ADAPTER';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) == 1 )
    {
        oMLFB.strMLFBPart = dbgetstring( strResultTable, 'MLFB_2KJ_9' ) + 'A' + '0' + dbgetstring( strResultTable, 'MLFB_2KJ_12' ) + '0';
    }
    
    return( oMLFB );
}

/**
 * get the MLFB part for the fastening (digit 14)
 * you may get an additional necessary short description for fastening
 *
 * @param strFasteningType - fastening type
 * 
 * @return object - strMLFBPart: MLFB-Part for fastening (1 digit)
 *                  strShortDescription: necessary short description for fastening (only nonempty if the fastening part of the MLFB is Z)
 */
function getFasteningMLFB( strFasteningType, strFigur, strEGBEZTYP )
{ 
    var strRegion = "TUB";
    
    var oMLFB = {
        strMLFBPart: '.',
        strShortDescription: ''
    };
    
    var strSelect = "";
    strSelect = "SELECT MLFB_2KJ_14, MLFB_2KJ_14_KA from MLFB4_EGBEF where EGBEZBEF = '" + strFasteningType + "' AND EGBEZTYP = '"+strEGBEZTYP+"' AND EGABDMSTFIG = '" + strFigur + "' ";
   
     var strResultTable = 'MLFB_FASTENING';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
    {
        oMLFB.strMLFBPart = dbgetstring( strResultTable, 'MLFB_2KJ_14' );
        oMLFB.strShortDescription = dbgetstring( strResultTable, 'MLFB_2KJ_14_KA' );
        if ( ( oMLFB.strShortDescription === '-' ) || ( oMLFB.strShortDescription === ' ' ) )
            oMLFB.strShortDescription = '';
    }
    else
    {
        logtraceln("Fehler Bestimmung MLFB Befestigung Stelle 14! SQL="+strSelect);
    }
    // else not decidable -> return the defaults
    
    return( oMLFB );
}

 
/**
 * get the MLFB part for the ratio of the geared motor (digits 15+16)
 *
 * @param strEGBEZTYP - gear base type
 * @param strEGBEZUEBS - gear ratio stage
 * @param strEGBEZEI - gear development index
 * @param strEGBEZDIM - gear size
 * @param strEGUEB - gear ratio
 * @param strZGBEZDIM - gear size for secondary gear
 * @param strZGBEZEI - development index for secondary gear
 * @param strZGBEZUEBS - ratio stage for secondary gear
 * @param strZGUEB - ratio of secondary gear
 *
 * @return string - MLFB-part for the ratio of the geared motor (2 digits)
 */
function getRatioMLFB( strEGBEZTYP, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strEGUEB, strZGBEZDIM, strZGBEZEI, strZGBEZUEBS, strZGUEB, strEGBEZBRA )
{
    var strRatioMLFB = '..';
    var strSelect = "SELECT DISTINCT MLFB_2KJ_15,MLFB_2KJ_16 from IGES_M3 where EGBEZTYP='" + strEGBEZTYP + "' and EGBEZUEBS='" + strEGBEZUEBS + "' and EGBEZEI='" + strEGBEZEI + "' and EGBEZBRA='" + strEGBEZBRA + 
                    "' and EGBEZDIM='" + strEGBEZDIM + "' and abs(EGUEB) = " + strEGUEB;
    if ( ( strZGBEZDIM === '' ) && ( strZGBEZEI === '' ) && ( strZGBEZUEBS === '' ) )
        strSelect += " and ZGBEZDIM='-' and ZGBEZEI ='-' and ZGBEZUEBS='-' ";
    else strSelect += " and ZGBEZDIM='" + strZGBEZDIM + "' and ZGBEZEI ='" + strZGBEZEI + "' and ZGBEZUEBS='" + strZGBEZUEBS + "' ";
    if ( ( strZGUEB === '-' ) || ( strZGUEB === '' ) )
        strSelect += " and ZGUEB = '-'";
    else strSelect += " and abs(ZGUEB) = " + strZGUEB;
    strSelect += " and EINZELGETR = '1' ";
    strSelect += " and G115 = '0' AND G115D='0' AND G115M='0' AND SONDER='-' AND AKTIV='1' AND REGION IN ('SAC','SACN') ";

    var strResultTable = 'MLFB_RATIO';
    if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
        strRatioMLFB = dbgetstring( strResultTable, 'MLFB_2KJ_15' ) + dbgetstring( strResultTable, 'MLFB_2KJ_16' );
    // else not decidable -> return the dots
        
    return( strRatioMLFB );
}
