//@legacy
//#mode(full-ecma)


//@import "../../2KJ4_CONFIG/2KJ_Functions.js"

/**
 * @category   MOTOX MLFB generation
 * @package    product logic
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * @constructor
 * get short descriptions for the gear attributes
 * 
 * @param oGear - geared motor object
 *
 * @return array - short descriptions for the gear attributes,
 *                 each index contains a string with one short description (may be empty)
 */
function getGearDescriptions( oGear )
{
    var aShortDescriptions = [];
    
    _addMountingDescriptions( oGear, aShortDescriptions );
    _addOilRelatedDescriptions( oGear, aShortDescriptions );
    _addOtherGearOptionsDescriptions( oGear, aShortDescriptions );
    _addMonoRailGearOptionsDescriptions( oGear, aShortDescriptions );
    
    return( aShortDescriptions );
}


/**
 * @constructor
 * add short descriptions for the gear mounting-related options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for gear mounting-related descriptions
 */
function _addMountingDescriptions( oGear, aShortDescriptions )
{
    // mounting position
    var strEGPos = ECL_GetValue("BAUFORM_2KJ4");
    var strSide = ECL_GetValue("ABTRIEBSSEITE_2KJ4");
    if ( strSide !== '-' )
        strEGPos += '-' + strSide;
    addShortDescription( aShortDescriptions, 'EGPOS', strEGPos );
    
    //Sondereinbaulage
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ4", "T"))
    {
        var strAchse=ECL_GetValue("SE_ACHSE_WAHL_2KJ4");
        var strSETYP;
        if(strAchse == "X")
            strSETYP = "X_ACHSE";
        else if(strAchse == "Y")
            strSETYP = "Y_ACHSE";
        else if(strAchse == "Z")
            strSETYP = "Z_ACHSE";
        
        var strRotationAngle=ECL_GetValue("SE_ROTATIONSWINKEL_2KJ4");
        strRotationAngle=replace(strRotationAngle,strSETYP+"_","");
        
        addShortDescription( aShortDescriptions, strSETYP, strRotationAngle );
    }
    
    
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ4", "T"))
        addShortDescription( aShortDescriptions, 'ZUL_EINBAULAGE_ABW', "1" );
    
    // flange mass for foot-mounted housing
    var strMounting = ECL_GetValue("BEFESTIGUNGSART_2KJ4");
    var strMass = ECL_GetValue("BEFESTIGUNGSMASS_2KJ4");
    
    if ( ( strMass !== '' ) && ( strMass !== '-' ) )
    {
        var strShaftDimensions = ECL_GetValue("ABTRIEBSWELLENMASS_2KJ4");
        var strEGABFLDM = strMass;
        
        var Abtriebswellentyp = GetEGBEZANWTYP();
        var Verbindungsart = GetEGBEZWNV();

        // build select statement
        var strSelect = "SELECT DISTINCT MLFB_OPTION FROM EGABFLD_M3 WHERE EGBEZTYP = '" + oGear.oRow.EGBEZTYP;
        strSelect += "' AND EGBEZUEBS = '" + oGear.oRow.EGBEZUEBS;
        strSelect += "' AND EGBEZBRA = '" + oGear.oRow.EGBEZBRA;
        strSelect += "' AND EGBEZDIM = '" + oGear.oRow.EGBEZDIM;
        strSelect += "' AND EGBEZEI = '" + oGear.oRow.EGBEZEI;
        strSelect += "' AND EGBEZAWTYP = '" +Abtriebswellentyp;
        strSelect += "' AND EGABFLFIG = '" +ECL_GetValue("FIGUR_2KJ4");
        strSelect += "' AND EGABFLDM='" + strEGABFLDM;
        strSelect += "' AND EGBEZBEF='" + strMounting;
        strSelect += "' AND EGBEZWNV='"+ Verbindungsart;
        
        strSelect = strSelect + "' AND EGABFLD_M3.CDROM_REL = '1' ";
        
        // get short description from database
        var strSD = '';
        var strResultTable = 'MLFB_EGABFLD';
        
        if ( dbselect( '2KJ4_DB', strSelect, strResultTable ) > 0 )
            strSD = dbgetstring( strResultTable, 'MLFB_OPTION' );
            
        if ( ( strSD !== '' ) && ( strSD !== '#' ) && ( strSD !== '-' ) )
            aShortDescriptions.push( '+' + strSD );
    }
    
    // additional short description for flange figur - none defined for simogear
    
    // additional short description for figur of torque arm
    if ( ( strMounting === 'D' ) || ( strMounting === 'L' ) )
        addShortDescription( aShortDescriptions, 'EGABDMSTFIG', ECL_GetValue("FIGUR") );
        
    // additional short description for water drain hole on flange
    if ( ECL_ValueSelected("WASSERABLAUF_OPTION_2KJ4","T") )
        addShortDescription( aShortDescriptions, 'EGABFLAWALO', '1' );
}


/**
 * @constructor
 * add short descriptions for the gear oil-related options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - array with short descriptions that should be enhanced for gear oil-related descriptions
 */
function _addOilRelatedDescriptions( oGear, aShortDescriptions )
{
    // sealings
    var strSeal = ECL_GetValue("ABTRIEBSWELLENABDICHTUNG_2KJ4");
    addShortDescription( aShortDescriptions, 'EGDICHTART', strSeal );
    
    // oil type
    var strOil = ECL_GetValue("GETRIEBEOEL_2KJ4");
    addShortDescription( aShortDescriptions, 'OELSORTE', strOil );
    
    // gear breather
    var strBreather = ECL_GetValue("GETRIEBEENTLUEFTUNG_2KJ4");
    if( (oGear.oRow.EGBEZDIM=="19" || oGear.oRow.EGBEZDIM=="29") && strBreather=="Druckentlueftungsventil" &&  oGear.oRow.EGBEZTYP!="C")
        aShortDescriptions.push("+G45");
    else
        addShortDescription( aShortDescriptions, 'EGGEHENT', strBreather );
 
    // oil level control
    var strControl = ECL_GetValue("OELSTANDSKONTROLLE_2KJ4");
    if(strControl=="Oelschauglas")
        addShortDescription( aShortDescriptions, 'EGGEHOLK', strControl, 'EGGEHOLK_OELSTAND', '-' );
    else
        addShortDescription( aShortDescriptions, 'EGGEHOLK', strControl );
    
    // oil drain
    var strDrain = ECL_GetValue("OELABLASS_2KJ4");
    if(strDrain != "ohne")
        addShortDescription( aShortDescriptions, 'EGGEHOLA', strDrain );
}


/**
 * @constructor
 * add short descriptions for the other gear options to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - arary with short descriptions that should be enhanced for other gear descriptions
 */
function _addOtherGearOptionsDescriptions( oGear, aShortDescriptions )
{
    if ( ECL_ValueSelected("DREHRICHTUNG_MOTOR_OPTION_2KJ4","T") || ECL_ValueSelected("DREHRICHTUNG_ADAPTER_OPTION_2KJ4","T") )
    {
        // rotation direction of output side
        var strSD = get_AbtriebsrichtungKA(oGear);
        if ( strSD !== '-' )
        {
            aShortDescriptions.push( '+' + strSD );
        }
    }
    
    // backlash design
    if (  ECL_ValueSelected("SPIELREDUZIERT_OPTION_2KJ4","T") )
        addShortDescription( aShortDescriptions, 'EGBEZSO', 'W' );
        
    if (  ECL_ValueSelected("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ4","T") )
        addShortDescription( aShortDescriptions, 'EGSPRED_WNV', 'schrumpfkleben' );
    
    // output shaft bearing
    var strBearing = ECL_GetValue("ABTRIEBSWELLENLAGERUNG_2KJ4");
    if(strBearing == "XLplus Lagerung")
        addShortDescription( aShortDescriptions, 'EGABALAG', strBearing, "EGABAUSF", "XLplus" );
    else if(strBearing == "VLplus Lagerung")
        addShortDescription( aShortDescriptions, 'EGABALAG', strBearing, "EGABAUSF", "VLplus" );
    else
        addShortDescription( aShortDescriptions, 'EGABALAG', strBearing );
    
    // hollow shaft cover (only for hollow shaft)
    var strOutputShaftType = GetEGBEZANWTYP();
    if ( strOutputShaftType === 'A' )
    {
        var strCover = ECL_GetValue("HOHLWELLENABDECKUNG_2KJ4");
        addShortDescription( aShortDescriptions, 'EGABABDW', strCover );
    }
    
    // housing material
    var strMaterial = ECL_GetValue("GEHAEUSEMATERIAL_2KJ4");
    addShortDescription( aShortDescriptions, 'EGGEHWS', strMaterial );
}

function get_AbtriebsrichtungKA(oMOTOX)
{
    var strDBName = "2KJ4_DB";
    var strRichtungKA = "";
    var strDBResult = "ABTRIEBSRICHTUNG_KA";
    
    var strEGTYP = oMOTOX.oRow.EGBEZTYP+oMOTOX.oRow.EGBEZUEBS;
    strEGTYP = replace(strEGTYP, "-", "");

    var strSelect = "SELECT DISTINCT KA_RLSP FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
    strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
    
    if(strEGTYP == "FD" || strEGTYP == "FZ")
        strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
    else
        strSelect = strSelect + "ABTRIEBSSEITE = '"+ECL_GetValue("ABTRIEBSSEITE_2KJ4")+"' AND ";
    
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBEMOTOR")
    {
        if( ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ4") == "links")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CCW' AND ";
        else if( ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ4") == "rechts")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CW' AND ";

        if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4") == "links")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ4") == "rechts")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CW' ";
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ4") == "GETRIEBE.ADAPTER")
    {
        if( ECL_GetValue("DREHRICHTUNG_MOTOR_ADAPTER_2KJ4") == "links")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CCW' AND ";
        else if( ECL_GetValue("DREHRICHTUNG_MOTOR_ADAPTER_2KJ4") == "rechts")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CW' AND ";

        if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER_2KJ4") == "links")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER_2KJ4") == "rechts")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CW' ";
    }
    
    
    if ( dbselect( strDBName, strSelect, strDBResult ) == 1 )
    {
        strRichtungKA = dbgetstring( strDBResult, 'KA_RLSP' );
        
    }
    else
    {
        logtraceln("Fehler Bestimmung Abtriebsdrehrichtung KA! SQL="+strSelect);
    }
    
    return(strRichtungKA);
}

function _addMonoRailGearOptionsDescriptions( oGear, aShortDescriptions )
{
    //Zusatzoptionen für Hängebahnantriebe
    
    // Kupplungshebel Ausführung
    var strKuppAusF = ECL_GetValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ4");
    if(strKuppAusF != "-")
        addShortDescription( aShortDescriptions, 'HEBEL_AUSF', strKuppAusF );
    
    // Kupplungshebel Schaltweg
    var strKuppSchaltweg = ECL_GetValue("KUPPLUNGSHEBEL_SCHALTWEG_2KJ4");
    if(strKuppSchaltweg != "-")
        addShortDescription( aShortDescriptions, 'HEBEL_LAGE', strKuppSchaltweg );
    
    // Kupplungshebel Lage
    var strKuppLage = ECL_GetValue("KUPPLUNGSHEBEL_LAGE_2KJ4");
    if(strKuppLage != "-")
        addShortDescription( aShortDescriptions, 'HEBEL_GRIFF', strKuppLage );
}
