//@legacy
//#mode(full-ecma)


/**
 * @category   MOTOX MLFB generation
 * @package    product logic
 * @copyright  Copyright (c) 2012-2013 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * @constructor
 * get the short description for gear attribute and their actual values
 * 
 * @param strKey1 - attribute key 1
 * @param strValue1 - actual attribute value for key 1
 * @param strKey2 - attribute key 2 (optional)
 * @param strValue2 - actual attribute value for key 2 (optional)
 * @param strKey3 - attribute key 3 (optional)
 * @param strValue3 - actual attribute value for key 3 (optional)
 * @param strKey4 - attribute key 4 (optional)
 * @param strValue4 - actual attribute value for key 4 (optional)
 * @param strKey5 - attribute key 5 (optional)
 * @param strValue5 - actual attribute value for key 5 (optional)
 *
 * @return string - short description for parameters
 *                  will be empty if no short description have been found
 */
// test cases:
// var strSD = MLFB.MOTOX.SD.getShortDescription( 'FARBNORM', 'ohne' );																					// L00
// var strSD2 = MLFB.MOTOX.SD.getShortDescription( 'LSTGSMENGE', '2', 'LSTGS2LOSE', '-' );																// K68
// var strSD3 = MLFB.MOTOX.SD.getShortDescription( 'GGM', 'GGM', 'GEBTYP', 'IV', 'GEBBEZ', '1XP8000-12' );												// N50
// var strSD4 = MLFB.MOTOX.SD.getShortDescription( 'GGM', '-', 'GEBTYP', 'IN' , 'GEBBEZ', 'ITD21A4', 'GEBVORB', 'nein' );								// Q01
// var strSD5 = MLFB.MOTOX.SD.getShortDescription( 'GGM', 'GGM', 'GEBTYP', 'IR' , 'GEBBEZ', '1XP8013-11', 'GEBMECH', 'Flanschdose', 'GEBELEKT', '-' );	// Q87
// var strSD6 = MLFB.MOTOX.SD.getShortDescription( 'LSTGSMENGE', '2', 'LSTGS2LOSE' );																	// no short description, one parameter missing

function getShortDescription( strKey1, strValue1, strKey2, strValue2, strKey3, strValue3, strKey4, strValue4, strKey5, strValue5 )
{
    const startTime = new Date().getTime();
	if (typeof __global === "undefined") {
		globalThis.__global = {};
	}

	if (!__global.shortDescriptions) {
		var shortDescriptions = ECL_GetCacheValue("2kj4_short_descriptions");
        
        if (shortDescriptions) {
            shortDescriptions = JSON.parse(shortDescriptions);
        } else {
            var data = Object.fromDatabase("2KJ4_DB", "SELECT MLFB_OPTION, MERKMAL_1, MERKMAL_2, MERKMAL_3, MERKMAL_4, MERKMAL_5, WERT_1, WERT_2, WERT_3, WERT_4, WERT_5 FROM MLFB4_OPTIONEN WHERE AKTIV = '1' and MERKMAL_1 <> '' AND KA_GEN_KNZ <> '0'");
            
            shortDescriptions = {};

            for (var i=0; i<data.length; ++i) {
                var mlfbOption = data[i].MLFB_OPTION;
                var key = "";

                for (var j=1; j<=5; ++j) {
                    var k = data[i]["MERKMAL_"+j];
                    var v = data[i]["WERT_"+j];

                    if (j > 1) {
                        key += "&&";
                    }

                    key += k + "===" + v;

                    shortDescriptions[key] = mlfbOption;
                }
            }

            ECL_SetCacheValue("2kj4_short_descriptions", JSON.stringify(shortDescriptions));
        }

		__global.shortDescriptions = shortDescriptions;
	}

	var key = "";

	for (var i=0; i<5; ++i) {
		var k = arguments[2*i];
		var v = arguments[2*i+1];

		if (!k) {
			break;
		}

		if (i > 0) {
			key += "&&";
		}

		key += k + "===" + v;
	}

    const deltaTime = (new Date().getTime()) - startTime;

	if (key in __global.shortDescriptions) {
		return __global.shortDescriptions[key];
	}

	return "";
}


/**
 * @constructor
 * get the short description for gear attribute and their actual values
 * and add them to an array of short descriptions, if nonempty
 * 
 * @param aShortDescriptions - array of short descriptions where to add the new short description, if it exists
 * @param strKey1 - attribute key 1
 * @param strValue1 - actual attribute value for key 1
 * @param strKey2 - attribute key 2 (optional)
 * @param strValue2 - actual attribute value for key 2 (optional)
 * @param strKey3 - attribute key 3 (optional)
 * @param strValue3 - actual attribute value for key 3 (optional)
 * @param strKey4 - attribute key 4 (optional)
 * @param strValue4 - actual attribute value for key 4 (optional)
 * @param strKey5 - attribute key 5 (optional)
 * @param strValue5 - actual attribute value for key 5 (optional)
 *
 * @return array - (possibly enhanced) short descriptions for the geared motor attributes,
 *                 each index contains a string with one short description (may be empty)
 *                 since the parameter array is modified in-place, the returned array if the same object as the parameter array
 *                 (i.e. is null if the parameter array is null)
 */
function addShortDescription( aShortDescriptions, strKey1, strValue1, strKey2, strValue2, strKey3, strValue3, strKey4, strValue4, strKey5, strValue5 )
{
    var strSD = getShortDescription( strKey1, strValue1, strKey2, strValue2, strKey3, strValue3, strKey4, strValue4, strKey5, strValue5 );
    if ( aShortDescriptions && ( strSD !== '' ) ){
        aShortDescriptions.push( '+' + strSD );
    }
    return( aShortDescriptions );
}

function splitSelectedBrake( strSelBrake )
{
    var res = 
    {
        BREART: '-',
        BRENENMO: '-',
        BREREDMO: '-'
    };

    var nFirstDigitPos = findFirstNumber( strSelBrake );
    if ( nFirstDigitPos > 0 )	// at least the first position must be part of the type specifier
    {
        // nominal torque (and sometimes reduced torque) are encoded in the selected brake ID
        res.BREART = replace(strSelBrake.substring( 0, nFirstDigitPos ),"S","");
        var strNominalTorque = '-';
        var strReducedTorque = '-';
        var nSeparatorPos = strSelBrake.indexOf( '/' );
        if ( nSeparatorPos < 0 )
            strNominalTorque = strSelBrake.substring( nFirstDigitPos );
        else
        {
            strNominalTorque = strSelBrake.substr( nFirstDigitPos, nSeparatorPos - nFirstDigitPos );
            // nice bug in EasyScript: if you replace the following line with strReducedTorque = strSelBrake.substr( nSeparatorPos + 1 ) you would only get the last character of the string, no matter
            // how many characters are left
            strReducedTorque = strSelBrake.substr( nSeparatorPos + 1, strSelBrake.length - nSeparatorPos - 1 );
        }
        
        if ( res.BREART === 'FDX' )
        {
            if(strNominalTorque == "30")
                strNominalTorque = "500"
            else if(strNominalTorque == "40")
                strNominalTorque = "1000"
        }
        
        res.BRENENMO = strNominalTorque;
        res.BREREDMO = strReducedTorque;
    }
    
    return( res );
}

