//@legacy
//#mode(full-ecma)


//@import "ShortDescriptionParser.js"

//@import "../2KJ4_CONFIG/utils.js"

//@import "StringHandler.js"


/**
 *
 @category   Parser
 * @package    Core
 * @copyright  Copyright (c) 2009-2013 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * normalize MLFB (trim spaces, adjust to upper case, add additional spaces between plus if necessary, delete surplus tabs and spaces)
 *
 * @param strMLFB - MLFB input from user to normalize
 *
 * @return string - the normaized MLFB
 */
function normalizeMLFB( strMLFB )
{
    // trim spaces and adjust to upper case
    strMLFB = toupper( trimright( trimleft( strMLFB, ' ' ), ' ' ) );
    
    // add additional spaces between plusses if necessary
    strMLFB = replace( strMLFB, '-Z', '-Z ' );
    strMLFB = replace( strMLFB, '+', ' +' );
    
    // delete surplus tabs and spaces
    strMLFB = replace( strMLFB, '\t', ' ' );
    while ( strMLFB.indexOf( '  ' ) > -1 )
        strMLFB = replace( strMLFB, '  ', ' ' );
    
    return( strMLFB );
}


function sanatizeSizerMLFB( strBaseMLFB, strKA1, strKA2, strKA3, strKA4, strKA5 )
{
    var oMLFB={
        strMLFB: '',
        strSpecificationSD: '',
        strVoltageSD: '',
        strBetriebsartSD: '',
        strATEXZoneSD: '',
        strVentilationSD: ''
    };
    
    if(find(strBaseMLFB,"-")==-1)
    {
        //Bindestriche ergänzen
        
        oMLFB.strMLFB=strBaseMLFB.slice(0,7)+"-"+strBaseMLFB.slice(7,12)+"-"+strBaseMLFB.slice(12,16);
    }
    
    if(strKA1)
    {
        if(strKA1 == "M23")
            oMLFB.strVentilationSD=strKA1;
        else if(strKA1.left(1)=="P")
            oMLFB.strBetriebsartSD=strKA1;
        else if(strKA1.left(1)=="K")
            oMLFB.strATEXZoneSD=strKA1;
        else if(isLetter(strKA1.right(1)))
            oMLFB.strVoltageSD=strKA1;
        else if(isDigit(strKA1.right(1)))
            oMLFB.strSpecificationSD=strKA1;
    }
    
    if(strKA2)
    {
        if(strKA2 == "M23")
            oMLFB.strVentilationSD=strKA2;
        else if(strKA2.left(1)=="P")
            oMLFB.strBetriebsartSD=strKA2;
        else if(strKA2.left(1)=="K")
            oMLFB.strATEXZoneSD=strKA2;
        else if(isLetter(strKA2.right(1)))
            oMLFB.strVoltageSD=strKA2;
        else if(isDigit(strKA2.right(1)))
            oMLFB.strSpecificationSD=strKA2;
    }
    
    if(strKA3)
    {
        if(strKA3 == "M23")
            oMLFB.strVentilationSD=strKA3;
        else if(strKA3.left(1)=="P")
            oMLFB.strBetriebsartSD=strKA3;
        else if(strKA3.left(1)=="K")
            oMLFB.strATEXZoneSD=strKA3;
        else if(isLetter(strKA3.right(1)))
            oMLFB.strVoltageSD=strKA3;
        else if(isDigit(strKA3.right(1)))
            oMLFB.strSpecificationSD=strKA3;
    }
    
    if(strKA4)
    {
        if(strKA4 == "M23")
            oMLFB.strVentilationSD=strKA4;
        else if(strKA4.left(1)=="P")
            oMLFB.strBetriebsartSD=strKA4;
        else if(strKA4.left(1)=="K")
            oMLFB.strATEXZoneSD=strKA4;
        else if(isLetter(strKA4.right(1)))
            oMLFB.strVoltageSD=strKA4;
        else if(isDigit(strKA4.right(1)))
            oMLFB.strSpecificationSD=strKA4;
    }
    
    if(strKA5)
    {
        if(strKA5 == "M23")
            oMLFB.strVentilationSD=strKA5;
        else if(strKA5.left(1)=="P")
            oMLFB.strBetriebsartSD=strKA5;
        else if(strKA5.left(1)=="K")
            oMLFB.strATEXZoneSD=strKA5;
        else if(isLetter(strKA5.right(1)))
            oMLFB.strVoltageSD=strKA5;
        else if(isDigit(strKA5.right(1)))
            oMLFB.strSpecificationSD=strKA5;
    }
    
    return( oMLFB );
}


/**
 * Parse freetext string to object structure
 *
 * @param strFreetext - freetext input from user (may be empty)
 * @param bDontModifyText - don't modify the case of the option text (optional)
 *
 * @return object - contains a attribute-value pair for each short description and its freetext value
 *                  strError (optional): additional error message (only available in case an error occured)
 *                  example: oShortDescriptions['L1Y'] == '4 IN'
 */
function parseFreetext( strFreetext, bDontModifyText )
{
    var oShortDescriptions = {
        strError: ''
    };
    var oParts = ShortDescriptionParser_getParts( strFreetext );
    if ( oParts.strError !== '' )
        oShortDescriptions.strError = oParts.strError;
    var part, idx, val;
    for ( var i = 0; i < oParts.aParts.length; ++i ) 
    {
        part = new StringHandler( oParts.aParts[i] );
        part = part.split( ':' );
        
        idx = trimright( trimleft( toupper( part[0] ), ' ' ), ' ' );
        if ( part.length > 2 )
        {
            // -og- 130225 if a freetext contains multiple colons, we must use the whole freetext and not only the text up to the first colon
            for ( var j = 2; j < part.length; ++j )			
                part[1] += ':' + part[j];
        }
        if ( bDontModifyText )
            val = trimright( trimleft( part[1], ' ' ), ' ' );
        else val = trimright( trimleft( tolower( part[1] ), ' ' ), ' ' );
        
        if(!val && part[1] && part[1].length > 0)
            val = part[1];
        
        if ( idx in oShortDescriptions )
            oShortDescriptions.strError += ( oShortDescriptions.strError ? ', ' : '' ) + translate( 'ERRORMSG_2KJ___MLFB_OPTION_DUPLICATE' ) + ' ' + idx;
        oShortDescriptions[idx] = val;
    }
    
    return( oShortDescriptions );
}


/**
 * decode the encoded short descriptions in the free text for Y66, to add them to the short descriptions of the MLFB
 * and to remove all references to Y66 from the full MLFB and the full freetext
 *
 * @param strMLFB - normalized MLFB
 * @param oYDescriptions - contains a attribute-value pair for each short description and its freetext value
 *                         example: oShortDescriptions['L1Y'] == '4 IN'
 *
 * @return object: strMLFB - in case the decoding was successful, this value contains the modified MLFB
 *                 strFreetext - in case the decoding was successful, this value contains the modified freetext else it is empty
 *         null if no decoding was performed
 */
function decodeY66( strMLFB, oYDescriptions )
{
    // the freetext for Y66 contains the encoded short descriptions
    if ( 'Y66' in oYDescriptions )
    {
        var strEncoded = oYDescriptions[ 'Y66' ];
        
        // adjust MLFB
        var strNewMLFB = replace( strMLFB, '+Y66', '' );
        strNewMLFB += toupper( strEncoded );
        
        // rebuild MLFB
        var aSD = strNewMLFB.split( ' ' );
        strNewMLFB = aSD.shift();
        // make sure that each SD starts with a '+'
        for( var i = 0; i < aSD.length; ++i )
        {
            if ( aSD[i].charAt( 0 ) === ' ' )
                aSD[i] = aSD[i].substring( 1 );
            if ( aSD[i].charAt( 0 ) !== '+' )
                aSD[i] = '+' + aSD[i];
        }
        aSD.sort();
        strNewMLFB += ' ' + aSD.join( ' ' );
        
        // adjust freetext
        var strNewFreetext = '';
        for ( var strSD in oYDescriptions )
        {
            if ( ( strSD !== 'Y66' ) && ( strSD !== 'strError' ) )
                strNewFreetext += '{' + strSD + ': ' + oYDescriptions[strSD] + '}';
        }
        
        return( {
            strMLFB: strNewMLFB,
            strFreetext: strNewFreetext
        } );
    }
    
    return( null );
}


/**
 * splits a text into rows with the maximal number of characters give
 *
 * @param str - text to split
 * @param nMaxChars - maximum number of characters for a row
 *
 * @return array - rows of splitted texts
 */
function splitText( str, nMaxChars )
{
    var output = [];
    var c = '';
    var w = '';
    var index1 = 0;
    var index2 = 0;
    var MAX_CHARS = ( nMaxChars || 32 );
    
    for (var i=0; i<str.length; i++)
    {
        c = str.charAt(i);
        
        if (c == '.' || c == ',' || c == '-' || c == ':' || c == ';' || c == '\t' || c == ' ' || c == '\r' || c == '\n' || i == str.length-1)
        {
            if (i-index1+1 > MAX_CHARS)
            {
                if (index1 != index2 && c != '\r' && c != '\n')
                {
                    if (str.charAt(index2) == ' ' || str.charAt(index2) == '\t')
                        w = str.substring(index1, index2);
                    else
                        w = str.substring(index1, index2+1);
                    
                    index1 = index2+1;
                }
                else
                {
                    w = str.substring(index1, i+1);
                    
                    if (str.charAt(index2) == '\n')
                        index1 = i+1;
                    else
                        index1 = i+2;
                }
                
                output.push(w);
            }
            
            index2 = i;
        }
    }
    
    w = str.substring(index1, str.length);
    if (w != '')
        output.push(w);

    return output;
}


/**
 * @constructor
 * test if a short description is of form ANA with the given starting character x (=necessary short description for MLFB position x)
 *
 * @param strShortDescription - short description to test
 * @param strStartChar - short description must begin with this char
 *
 * @return boolean - true: short description is an ANA description that begins with the start chararcter
 *                   false: short description is not an ANA description that begins with the start chararcter
 */
function isANA( strShortDescription, strStartChar )
{
    return( ( strShortDescription.length === 3 ) && ( strStartChar === strShortDescription.charAt( 0 ) ) &&
              strShortDescription.charAt( 1 ).isDigit() && strShortDescription.charAt( 2 ).isLetter() );
}

    
/**
 * @constructor
 * test if a short description is of form ANN with the given starting character x (=optional short description)
 *
 * @param strShortDescription - short description to test
 * @param strStartChar - short description must begin with this char
 *
 * @return boolean - true: short description is an ANN description that begins with the start chararcter
 *                   false: short description is not an ANN description that begins with the start chararcter
 */
function isANN( strShortDescription, strStartChar )
{
    return( ( strShortDescription.length === 3 ) && ( strStartChar === strShortDescription.charAt( 0 ) ) &&
              strShortDescription.charAt( 1 ).isDigit() && strShortDescription.charAt( 2 ).isDigit() );
}

function BestimmeMoeglicheZertifikate(aResult)
{
    var strSpec="(";
    for(var i=0;i<aResult.length;i++)
    {
        if(strSpec.indexOf(aResult[i].MOTELAUSF)==-1)
            strSpec = strSpec + "'"+aResult[i].MOTELAUSF+"',";
    }
    
    strSpec = trimright(strSpec,",");
    strSpec=strSpec+")";
    logtraceln("Specification String Parser="+strSpec);
    
    return strSpec;
}
    
function createSpecStringforParser(strRegion,oGearType,strMOTELAUSF_CE_MLFB,strMOTELAUSF_UL_MLFB,strMOTELAUSF_CEL_MLFB,strMOTELAUSF_EAC_MLFB,strMOTELAUSF_EXP_MLFB,strMOTELAUSF_EX_CEL_MLFB,strMOTELAUSF_WM_FU_MLFB,strMOTELAUSF_BIS_MLFB,strMOTELAUSF_KEMCO_MLFB)
{
    var strDBName = "2KJ4_DB";
    var strDBResult = "SPECSTRING_PARSER";
    
    var strSpec="(";
    
    var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";
    
    strSelect = strSelect + "MOTELAUSF_CE_MLFB = '"+strMOTELAUSF_CE_MLFB+"' ";
    
    if(strMOTELAUSF_UL_MLFB!=""){
        strSelect = strSelect + "AND MOTELAUSF_UL_MLFB = '"+strMOTELAUSF_UL_MLFB+"' ";
    }
    if(strMOTELAUSF_CEL_MLFB!=""){
        strSelect = strSelect + "AND MOTELAUSF_CEL = '"+strMOTELAUSF_CEL_MLFB+"' ";
    }

    if(strMOTELAUSF_EAC_MLFB!=""){
        strSelect = strSelect + "AND MOTELAUSF_EAC_MLFB = '"+strMOTELAUSF_EAC_MLFB+"' ";
    }

    if(strMOTELAUSF_EXP_MLFB!=""){
        strSelect = strSelect + "AND MOTELAUSF_EXP_MLFB = '"+strMOTELAUSF_EXP_MLFB+"' ";
    }

    if(strMOTELAUSF_EX_CEL_MLFB!=""){
        strSelect = strSelect + "AND MOTELAUSF_CEL_MLFB = '"+strMOTELAUSF_EX_CEL_MLFB+"' ";
    }

	if(strMOTELAUSF_WM_FU_MLFB!=""){
		strSelect = strSelect + "AND MOTELAUSF_WM_FU_MLFB = '"+strMOTELAUSF_WM_FU_MLFB+"' ";
    }

    if(strMOTELAUSF_BIS_MLFB!=""){
		strSelect = strSelect + "AND MOTELAUSF_BIS_MLFB = '"+strMOTELAUSF_BIS_MLFB+"' ";
    }

    if(strMOTELAUSF_KEMCO_MLFB!=""){
		strSelect = strSelect + "AND MOTELAUSF_KEMCO_MLFB = '"+strMOTELAUSF_KEMCO_MLFB+"' ";
    }

	if (ECL_GetValue("ECSI_WMFU_KENNER_2KJ4")=="ja"){
		strSelect = strSelect + "AND MOTELAUSF_WM_FU = 'WM_FU' ";
    }
    else{
		strSelect = strSelect + "AND MOTELAUSF_WM_FU = '-' ";
    }

    strSelect = strSelect + "AND AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    
    if(oGearType.ANWTYP=="KleinSchnecke")
        strSelect = strSelect + "AND S09='1' ";
    else
        strSelect = strSelect + "AND S09='0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    strSelect = strSelect + "AND G115M = '0' ";
    strSelect = strSelect + "AND G115D = '0' ";

    if (ECL_GetValue("ECSI_ATEX_KENNER_2KJ4")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "AND ATEX = '1' ";
    }
    else
    {
        strSelect = strSelect + "AND ATEX = '0' ";
    }
    
    strSelect = strSelect + "AND REGION = 'C' ";
    
    var aResult= Object.fromDatabase("2KJ4_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            var strSearchSprecString="'"+aResult[i].MOTELAUSF+"'";
            if(strSpec.indexOf(strSearchSprecString)==-1)
                strSpec = strSpec + "'"+aResult[i].MOTELAUSF+"',";
        
        }
        strSpec = trimright(strSpec,",");
        strSpec=strSpec+")";
        logtraceln("Specification String Parser="+strSpec);
        
    }
    else
    {
        logtraceln("Fehler Bestimmung Spezifikation String PARSER! SQL="+strSelect);
    }
    
    return strSpec;
}

function getWirkungsgradSchneckengetriebe( strEGBEZTYP, strEGBEZBRA, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strZGBEZUEBS, strZGBEZDIM, strZGBEZEI, strUebersetzung, dbDrehzahl, MMSystem)
{
    logtraceln("****************************************************");
    logtraceln("Berechnung Wirkungsgrad Schneckengetriebe");
        
    strUebersetzung = replace(strUebersetzung, ",", ".");
    var dWirkungsgrad = 1;
    var strGetriebetyp = strEGBEZTYP + strEGBEZBRA + strEGBEZUEBS + strEGBEZDIM + strEGBEZEI;
    strGetriebetyp = replace(strGetriebetyp, "-", "");
    
    logtraceln("Getriebetyp="+strGetriebetyp);
    
    //Konstanten
    var dConstantE = 2.718281828459;
    var dConstantPI = 3.14159;
    
    //Fehlende Werte aus Datenbank
    var strSQLStmtIGES_C = "SELECT DISTINCT * FROM IGES_C_M3 WHERE ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZTYP = '"	+ strEGBEZTYP +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZUEBS ='"	+ strEGBEZUEBS +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZBRA ='"	+ strEGBEZBRA +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZEI = '"	+ strEGBEZEI + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZDIM = '"	+ strEGBEZDIM +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZUEBS = '"+ strZGBEZUEBS + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZDIM = '"	+ strZGBEZDIM +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZEI ='"	+ strZGBEZEI + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"DGUEB = "		+ strUebersetzung+" ";
    
    logtraceln( "SEARCH FOR DATA IN IGES_C_M3:");
    logtraceln( strSQLStmtIGES_C );
    
    var dbI1;
    var dbIS;
    var dbA1;
    var dbB1;
    var dbC1;
    var dbD1;
    var dbA2;
    var dbB2;
    var dbC2;
    var dbA3;
    var dbB3;
    var dbC3;
    var dPvmax;
    var dPvLD;
    
    var dbT1Fest;
    var dbT1LH10;
    
    var strDBName = "2KJ4_DB";
    var strDBResult = "SCHNECKENDATA";
    
    if (dbselect(strDBName, strSQLStmtIGES_C, strDBResult) == 1)
    {
        dbI1 	 = dbgetdouble(strDBResult, "I1");
        dbIS 	 = dbgetdouble(strDBResult, "IS");
        dbA1 	 = dbgetdouble(strDBResult, "A1");
        dbB1 	 = dbgetdouble(strDBResult, "B1");
        dbC1 	 = dbgetdouble(strDBResult, "C1");
        dPvmax 	 = dbgetdouble(strDBResult, "Pvmax_Getriebe");
        dPvLD 	 = dbgetdouble(strDBResult, "PvLD");
        
        var dN2 = parseFloat(dbDrehzahl)/parseFloat(strUebersetzung);
        logtraceln("Abtriebsdrehzahl=dbDrehzahl/strUebersetzung");
        logtraceln("Abtriebsdrehzahl="+parseFloat(dbDrehzahl)+"/"+parseFloat(strUebersetzung)+"="+dN2);
        
        var dNc = dN2*parseFloat(dbIS);
        
        logtraceln("Schneckendrehzahl=dN2*dbIS");
        logtraceln("Schneckendrehzahl="+dN2+"*"+parseFloat(dbIS)+"="+dNc);
        
        var dnuec  = getNennmoentSchneckengetriebe_HF ( dNc, dbA1, dbB1, dbC1, "F1" );
        logtraceln("dnuec = C1 / (1 + A1 * e^(-B1*nc))");
        logtraceln("dnuec = "+dbC1+" / (1 + "+dbA1+" * e^(-"+dbB1+"*"+dNc+")) = "+dnuec);
                
        var dnue1 = 0.985;
        
        var dPvLDn = (dPvLD*parseFloat(dbDrehzahl))/1450.0;
        
        var dNennmoment = getNennmomentSchneckengetriebe( dnuec, strEGBEZTYP, strEGBEZBRA, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strZGBEZUEBS, strZGBEZDIM, strZGBEZEI, strUebersetzung, dbDrehzahl, MMSystem)
        var P2 = dNennmoment*dN2/9550.0;
        
        var dWirkungsgrad = dnue1 * dnuec/(1+(dPvLDn/P2));
        logtraceln("Gesamtwirkungsgrad=dnue1*dnuec/(1+(PvLDn/P2))");
        logtraceln("Gesamtwirkungsgrad="+dnue1+"*"+dnuec+"/(1+"+dPvLDn+"/"+P2+"))"+"="+dWirkungsgrad);
        
    }
    else
    {
        logtraceln("Keinen Datenbankeintrag für Schneckengetriebe gefunden!");
    }

    return (dWirkungsgrad);
}

function getNennmomentSchneckengetriebe( dnuec, strEGBEZTYP, strEGBEZBRA, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strZGBEZUEBS, strZGBEZDIM, strZGBEZEI, strUebersetzung, dbDrehzahl, MMSystem)
{
    logtraceln("****************************************************");
    logtraceln("Berechnung Nennmoment Schneckengetriebe");
    
    strUebersetzung = replace(strUebersetzung, ",", ".");
    var dNennmnoment=0;
    var strGetriebetyp = strEGBEZTYP + strEGBEZBRA + strEGBEZUEBS + strEGBEZDIM + strEGBEZEI;
    strGetriebetyp = replace(strGetriebetyp, "-", "");
    
    logtraceln("Getriebetyp="+strGetriebetyp);
    
    //Konstanten
    var dConstantE = 2.718281828459;
    var dConstantPI = 3.14159;
    
    //Fehlende Werte aus Datenbank
    var strSQLStmtIGES_C = "SELECT DISTINCT * FROM IGES_C_M3 WHERE ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZTYP = '"	+ strEGBEZTYP +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZUEBS ='"	+ strEGBEZUEBS +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZBRA ='"	+ strEGBEZBRA +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZEI = '"	+ strEGBEZEI + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"EGBEZDIM = '"	+ strEGBEZDIM +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZUEBS = '"+ strZGBEZUEBS + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZDIM = '"	+ strZGBEZDIM +	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"ZGBEZEI ='"	+ strZGBEZEI + 	"' AND ";
        strSQLStmtIGES_C = strSQLStmtIGES_C +"DGUEB = "		+ strUebersetzung+" ";
    
    logtraceln( "SEARCH FOR DATA IN IGES_C_M3:");
    logtraceln( strSQLStmtIGES_C );
    
    var dbI1;
    var dbIS;
    var dbA1;
    var dbB1;
    var dbC1;
    var dbD1;
    var dbA2;
    var dbB2;
    var dbC2;
    var dbA3;
    var dbB3;
    var dbC3;
    var dPvmax;
    
    var dbT1Fest;
    var dbT1LH10;
    
    var dbT2max_a;
    
    var dbA2C2;
    var dbA3C3;
    var dbA4C4;
    
    var strDBName = "2KJ4_DB";
    var strDBResult = "SCHNECKENDATA";
    
    if (dbselect(strDBName, strSQLStmtIGES_C, strDBResult) == 1)
    {
        dbI1 	 = dbgetdouble(strDBResult, "I1");
        dbIS 	 = dbgetdouble(strDBResult, "IS");
        dbA1 	 = dbgetdouble(strDBResult, "A1");
        dbB1 	 = dbgetdouble(strDBResult, "B1");
        dbC1 	 = dbgetdouble(strDBResult, "C1");
        dbD1 	 = dbgetdouble(strDBResult, "D1");
        dbA2	 = dbgetdouble(strDBResult, "A2");
        dbB2	 = dbgetdouble(strDBResult, "B2");
        dbC2	 = dbgetdouble(strDBResult, "C2");
        dbA3	 = dbgetdouble(strDBResult, "A3");
        dbB3	 = dbgetdouble(strDBResult, "B3");
        dbC3	 = dbgetdouble(strDBResult, "C3");
        dbA4	 = dbgetdouble(strDBResult, "A4");
        dbB4	 = dbgetdouble(strDBResult, "B4");
        dbC4	 = dbgetdouble(strDBResult, "C4");
        dbT1Fest = dbgetdouble(strDBResult, "T1_FEST");
        dbT1LH10 = dbgetdouble(strDBResult, "T1_LH10");
        dPvmax 	 = dbgetdouble(strDBResult, "Pvmax_Getriebe");
        
        dbT2max_a = dbgetdouble(strDBResult, "T2max_a");
        
        dbA2C2 = dbgetstring(strDBResult, "A2_C2");
        dbA3C3 = dbgetstring(strDBResult, "A3_C3");
        dbA4C4 = dbgetstring(strDBResult, "A4_C4");
        
        var dN2 = parseFloat(dbDrehzahl)/parseFloat(strUebersetzung);
        var dNc = dN2*parseFloat(dbIS);
        
        var dnue1 = 0.985;
        
        logtraceln("Schneckendrehzahl=dN2*dbIS");
        logtraceln("Schneckendrehzahl="+dN2+"*"+parseFloat(dbIS)+"="+dNc);
        
        if(dnuec < 0)
        {
            logtraceln("dnuec muss berechnet werden!")
            dnuec  = getNennmoentSchneckengetriebe_HF ( dNc, dbA1, dbB1, dbC1, "F1" );
            logtraceln("dnuec = C1 / (1 + A1 * e^(-B1*nc))");
            logtraceln("dnuec = "+dbC1+" / (1 + "+dbA1+" * e^(-"+dbB1+"*"+dNc+")) = "+dnuec);
        }
        
        logtraceln("Eingangsdrehzahl="+dbDrehzahl);
        
        logtraceln("T1LH10="+dbT1LH10);
        
        var dT2LH10 = dbT1LH10 * ( pow ( (1450.0/dbDrehzahl), (1/3))) * parseFloat(strUebersetzung) * dnuec * dnue1;
        logtraceln("T2LH10 = T1_LH10 * 3teWurzel(1450/Eingangsdrehzahl) * Uebersetzung * dnuec * dnue1");
        logtraceln("T2LH10 = "+dbT1LH10+" * "+( pow ( (1450.0/dbDrehzahl), (1/3)))+" * "+parseFloat(strUebersetzung)+" * "+dnuec+"*"+dnue1+" = "+dT2LH10 );
        
        logtraceln("T1Fest="+dbT1Fest);
        var dT2Fest = dbT1Fest * parseFloat(strUebersetzung) * dnuec * dnue1;
        logtraceln("T2Fest = T1Fest * Uebersetzung * dnuec * dnue1");
        logtraceln("numT2Fest = "+dbT1Fest+" * "+parseFloat(strUebersetzung)+" * "+dnuec+"*"+dnue1+" = "+dT2Fest);
        
        logtraceln("T2max_a="+dbT2max_a);
        
        var dT2max_b = getNennmoentSchneckengetriebe_HF ( dNc, dbA2, dbB2, dbC2, dbA2C2 );
        logtraceln("T2max_b="+dT2max_b);
        
        var dT2max_c = getNennmoentSchneckengetriebe_HF ( dNc, dbA3, dbB3, dbC3, dbA3C3 );
        logtraceln("T2max_c="+dT2max_c);
        
        var dT2max_d = getNennmoentSchneckengetriebe_HF ( dNc, dbA4, dbB4, dbC4, dbA4C4 );
        logtraceln("T2max_d="+dT2max_d);
        
        var dPemax = dPvmax/(1.0-(dnuec*dnue1));
        logtraceln("PeMax="+dPemax);
        var dT2max_e = (dPemax*9550.0/dN2)*dnuec*dnue1;
        logtraceln("T2max_e="+dT2max_e);
        
        dNennmnoment = min(min(min(min(min(min(min(dT2LH10,dT2Fest),dbT2max_a),dT2max_b),dT2max_b),dT2max_c),dT2max_d),dT2max_e);
        logtraceln("Schneckengetriebe Nennmoment="+dNennmnoment);
    }
    else
    {
        logtraceln("Keinen Datenbankeintrag für Schneckengetriebe gefunden!");
    }

    dNennmnoment = RoundMotox( dNennmnoment,'SI',"DREHMOMENT" );
    
    dNennmnoment = replace (dNennmnoment, ",", ".");
    dNennmnoment = parseFloat(dNennmnoment);
    
    logtraceln("gerundeter Wert des Nennmoments="+dNennmnoment);
    return (dNennmnoment);
}

function getNennmoentSchneckengetriebe_HF( dNc, dA, dB, dC, strTyp )
{
    //Konstanten
    var dConstantE = 2.718281828459;
    var dConstantPI = 3.14159;
    
    logtraceln("Typ="+strTyp);
    
    var dwrt;
    switch (strTyp)
    {
        case "F1" :
            dwrt= 1+ dA * pow(dConstantE, (dB * -1 * dNc));
            if(dwrt != 0)
            {
                dwrt = dC/dwrt;
            }
            else
            {
                dwrt = 0;
            }
        break;
        
        case "F2" :
            dwrt = dA*dNc*dNc+dB*dNc+dC;
        break;
        
        case "F3" :
            if(dNc < 0.1)
                dNc = 0.1;
            dwrt=dA*pow(dNc,dB)+dC;
        break;
        case "F4" :
            if(dNc < 0.1)
                dNc = 0.1;
            dwrt = dA*log(dNc)+dB
    }
    
    if(dwrt < 0 )
        dwrt = 0;
        
    return(dwrt);
}

function Bestimme_LeistungDrehzahl_Motor(oMOTOX,DatenArray)
{	
    var strFrequenz_Auswahl = oMOTOX.ECSI_FREQUENZ_VORAUSWAHL;
    
    var dbDREHZAHL;
    var dbDREHZAHL_1;
    var dbDREHZAHL_2;
    var dbDREHZAHL_MIN;
    
    var dbLEISTUNG;
    var dbLEISTUNG_1;
    var dbLEISTUNG_2;
    var dbLEISTUNG;
    
    
    if(strFrequenz_Auswahl == "50")
    {
        dbDREHZAHL 			= DatenArray[0];
        dbDREHZAHL_MIN 		= DatenArray[0];
        dbDREHZAHL_1		= DatenArray[0];
        dbDREHZAHL_2 		= 0
        
        dbLEISTUNG 			= DatenArray[4];
        dbLEISTUNG_1		= DatenArray[4];
        dbLEISTUNG_2		= 0

    }
    else if (strFrequenz_Auswahl == "60")
    {
        dbDREHZAHL 			= DatenArray[1];
        dbDREHZAHL_MIN 		= DatenArray[1];
        dbDREHZAHL_1		= DatenArray[1];
        dbDREHZAHL_2 		= 0
        
        dbLEISTUNG 			= DatenArray[5];
        dbLEISTUNG_1		= DatenArray[5];
        dbLEISTUNG_2		= 0
    }
    else if (strFrequenz_Auswahl == "87")
    {		
        dbDREHZAHL 			= DatenArray[2];
        dbDREHZAHL_MIN 		= DatenArray[2];
        dbDREHZAHL_1		= DatenArray[2];
        dbDREHZAHL_2 		= 0
        
        dbLEISTUNG 			= DatenArray[6];
        dbLEISTUNG_1		= DatenArray[6];
        dbLEISTUNG_2		= 0
    
    }
    else if (strFrequenz_Auswahl == "104")
    {		
        dbDREHZAHL 			= DatenArray[3];
        dbDREHZAHL_MIN 		= DatenArray[3];
        dbDREHZAHL_1		= DatenArray[3];
        dbDREHZAHL_2 		= 0
        
        dbLEISTUNG 			= DatenArray[7];
        dbLEISTUNG_1		= DatenArray[7];
        dbLEISTUNG_2		= 0
    
    }
    
    var ergObject = [];
    ergObject.push(dbDREHZAHL);
    ergObject.push(dbDREHZAHL_MIN);
    ergObject.push(dbDREHZAHL_1);
    ergObject.push(dbDREHZAHL_2);
    ergObject.push(dbLEISTUNG);
    ergObject.push(dbLEISTUNG_1);
    ergObject.push(dbLEISTUNG_2);
    
    return ergObject;

}

function Bestimme_LeistungAusgabe_Motor(oMOTOX,DatenArray)
{
    if(oMOTOX.ECSI_FREQUENZ_VORAUSWAHL == "50")
    {	
        var strLeistung = DatenArray[0];
    }
    else if(oMOTOX.ECSI_FREQUENZ_VORAUSWAHL == "60" || oMOTOX.ECSI_FREQUENZ_VORAUSWAHL == "60_L50")
    {	
        var strLeistung = DatenArray[1];
    }
    else if(oMOTOX.ECSI_FREQUENZ_VORAUSWAHL == "87")
    {	
        var strLeistung = DatenArray[2];
    }
    var MMSystem = "SI";
    if(MMSystem == "SI")
    {
        strLeistung = replace(strLeistung, ".", ",");
        strLeistung = trimright(strLeistung, ",0");
        
    }
    else if(MMSystem == "US")
    {
        strLeistung = replace(strLeistung, ",", ".");
        strLeistung = trimright(strLeistung, ".0");
    }
    return strLeistung;
}

function isValidTechValue( aGivenValue, aUserValue, aTolerance )
{

    var bValue_OK = false;
            
    if (aTolerance > 0)
        var numTOLERANZ = aUserValue * (aTolerance/100);
    else
        var numTOLERANZ = 0;
        
        
    if (aUserValue >= 0)
    {
        if ( aGivenValue > (aUserValue - numTOLERANZ)  )
        {
            if ( aGivenValue < (aUserValue + numTOLERANZ))
                bValue_OK = true	
        }
    }
    
    else 
        bValue_OK = true
    
    
    return bValue_OK
}

function isValidTechValue_Akzeptanz( aGivenValue,alow, ahigh )
{

    var bValue_OK = false;
            
    if ( parseFloat(replace(aGivenValue,",",".")) >= parseFloat(replace(alow,",",".")) )
    {
        if ( parseFloat(replace(aGivenValue,",",".")) <= parseFloat(replace(ahigh,",",".")) )
            bValue_OK = true	
    }

    return bValue_OK
}

function isValidTechValue_Special( aGivenValue,Format,alow, ahigh )
{
    var bValue_OK = false;

    if(Format == "between")
    {
        if( (parseFloat(replace(aGivenValue,",",".")) >= parseFloat(replace(alow,",","."))) &&  ( parseFloat(replace(aGivenValue,",",".")) <= parseFloat(replace(ahigh,",",".")) ))
        bValue_OK = true;
    }
    else if(Format == "greater_equal")
    {
        if( (parseFloat(replace(aGivenValue,",",".")) >= parseFloat(replace(ahigh,",","."))) )
        bValue_OK = true;
    }
    else if(Format == "less_equal")
    {
        if( (parseFloat(replace(aGivenValue,",",".")) <= parseFloat(replace(ahigh,",","."))) )
        bValue_OK = true;
    }
    else if(Format == "equal")
    {
        var unten = parseFloat(replace(ahigh,",","."));
        unten = unten - (unten/10);
        
        var oben =  parseFloat(replace(ahigh,",","."));
        oben = oben + (oben/10);
        
        if( (parseFloat(replace(aGivenValue,",",".")) >= unten) &&  ( parseFloat(replace(aGivenValue,",",".")) <= oben ))
        bValue_OK = true;
        
    }
    
    return bValue_OK
}

function applyValues( base, dialogObject )
{
    if( base && dialogObject && ( typeof( dialogObject ) === 'object' ) )
    {
        var t;
        for( var property in dialogObject )
        {
            t = typeof( dialogObject[property] );			
            if ( ( t !== 'function' ) && ( t !== 'object' ) )
                base[property] = dialogObject[property];
            else if ( t === 'object' )
            {
                if(dialogObject[property] == null)
                    base[property] = null;
                else if((base[property] == null) && (dialogObject[property] != null))
                    base[property] = deepClone(dialogObject[property]);
                
                // recursive deep value copy (don't change references to preserve OK/Cancel semantics for dialog objects)
                applyValues( base[property], dialogObject[property] );
            }
        
        }
    }
}

function isLetter(strValue)
{
    var objRegExp  = /^[a-zA-Z]$/;
    return objRegExp.test(strValue);
}
    
function isDigit(strValue)
{
    var objRegExp  = /^\d/;
    return objRegExp.test(strValue);
}