//@legacy
//#mode(full-ecma)


/**
 * @category   utils
 * @package    core
 * @copyright  Copyright (c) 2009-2012 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * This Class parses a given Short Description String
 * There are public methods to get all needed informations
 */
 
function ShortDescriptionParser_getParts( shortDescription )
{
    var parts = [];
    var parse = 0;
    var token = '';
    var len = shortDescription.length;
    var lastChar = '', currentChar = '', strError = '';
    
    for ( var i=1; i <= len; i++ )
    {
        currentChar = mid( shortDescription, i, 1 );
        
        if ( currentChar === '{' ) {
            if ( parse == 1 )	// zwei öffnende Klammern nacheinander
                strError = translate( 'ERRORMSG_2KJ___YPARSER_TOO_MANY_BRACKETS' );
            parse = 1;
        }
        else if ( currentChar === '}' ) {
            if ( parse == 0 )	// schließende Klammer ohne öffnende
                strError = translate( 'ERRORMSG_2KJ___YPARSER_NO_OPENING_BRACKET' );
                
            parse = 0;
            parts.push( token );
            token = '';
        }		
        else if ( parse ) {
            if ( lastChar == " " && currentChar == " " ) {
                ;
            } else {
                token += currentChar;
            }
        }
            
        lastChar = currentChar;	
    }
    
    return( {
        aParts: parts,
        strError : strError
    } );
}


