//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"


//@import "models/CFG_2KJ_BREMSE_Model.js"



function SetBremse_Init(strchangedAttribute,oData)
{
    //Erst feststellen, ob Bremse obligatorisch oder gar nicht möglich ist
    var iResult=checkBremse(oData);
    
    if(ECL_GetValue("SCHUTZART_2KJ8")=="IP56")
        iResult=0;
    
    if(iResult==0)
    {
        //Bremse nicht erlaubt
        ECL_DeselectAttribute("MIT_BREMSE_2KJ8");
        ECL_DisableAttribute("MIT_BREMSE_2KJ8")
    }
    else if(iResult==1)
    {
        //Nur mit Bremse erlaubt
        ECL_SelectValue("MIT_BREMSE_2KJ8", "T");
        ECL_DisableAttribute("MIT_BREMSE_2KJ8");
    }
    else if(iResult==2)
    {
        //Bremsenauswahl kommt aus SIZER
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        
        if(strwithBrake=="1" || strwithBrake=="Yes")
        {
            ECL_EnableAttribute("MIT_BREMSE_2KJ8");
            
            ECL_SelectValue("MIT_BREMSE_2KJ8", "T");
            ECL_DisableAttribute("MIT_BREMSE_2KJ8");
        }
        else if(strwithBrake=="0" || strwithBrake=="No")
        {
            ECL_EnableAttribute("MIT_BREMSE_2KJ8");
            
            ECL_DeselectValue("MIT_BREMSE_2KJ8", "T");
            ECL_DisableAttribute("MIT_BREMSE_2KJ8");
        }
    }
    
    //keine Bremsenüberwachung
    ECL_ActivateValue("BREMSE_UEBERWACHUNG_2KJ8", "ohne");
    ECL_SelectValue("BREMSE_UEBERWACHUNG_2KJ8", "ohne");
    ECL_DisableAttribute("BREMSE_UEBERWACHUNG_2KJ8");
    ECL_DeactivateAttribute("BREMSE_UEBERWACHUNG_2KJ8");
    
    //kein Funktionsgleichrichter
    ECL_SetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8", "ohne");
    ECL_DisableAttribute("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8");
    ECL_DeactivateAttribute("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8");
    
    //Kein Bremskabelschutz / C80
    ECL_DeselectValue("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8", "T");
    ECL_DisableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8");
    ECL_DeactivateAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8");
    
}

function SetBremse_Init_Sizer(oData)
{
    Bestimme_BREMSENTYP(oData);
}

function SetBremse_InitOptions(strchangedAttribute,oData,oDataBremse)
{
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP_2KJ8"));
    
    Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
    //Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
    Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
    //Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
    Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
    Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
    Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
    
    if(ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ8") != "-")
    {
        ECL_ActivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_EnableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_DisableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
    }
            
    //Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
}

function SetBremse(strchangedAttribute,oData,oDataBremse)
{   
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP_2KJ8"));

    switch(strchangedAttribute){
        case "SCHUTZART_2KJ8" :
        case "BELUEFTUNG_2KJ8" :
        case "SCHUTZDACH_OPTION_2KJ8" :
            SetBremse_Init(strchangedAttribute,oData);
            Bestimme_BREMSENTYP(oData);
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            //Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            //Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
        case "BREMSENTYP_2KJ8" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            //Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            //Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
            break;
        case "BREMSE_STEUERSPANNUNG_2KJ8" :
            //Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            break;
        case "BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            break;
        case "BREMSE_AUSFUEHRUNG_2KJ8" :
            //Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            //Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
            break;
        case "BREMSE_HANDLUEFTUNG_2KJ8" :
            break;
        case "SPEZIFIKATION_CHINA_2KJ8" :
        case "SPEZIFIKATION_EAC_2KJ8" :
            SetBremse_Init(strchangedAttribute,oData);
        break;
    }

    if(ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ8") != "-")
    {
        ECL_ActivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_EnableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_DisableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
    }
}