//@legacy
//#mode(full-ecma)








function setDefaultValues(oDataGear)
{
    //wichtige Default Werte setzen, bei Attributen wichtiug, die ausgewertet werden sollen ohne gesetzt zu sein.
    //Motorstecker wird vorher in Kabelverschraubung ausgewertet
    ExecSetStandardifValueEmpty("MOTORSTECKER_2KJ8","Aluminium");
    ExecSetStandardifValueEmpty("GEGENSTECKER_2KJ8","ohne");
    
    //Schutzart setzen für Getriebeentlüftung
    ExecSetStandardifValueEmpty("SCHUTZART_2KJ8","IP55");
    ExecSetStandardifValueEmpty("G115_SPEICHERKARTE_2KJ8","ohne");
        
    //Wird für Motor Rücklaufsperre benötigt
    ExecSetStandardifValueEmpty("BREMSE_HANDLUEFTUNG_2KJ8","-");
    ExecSetStandardifValueEmpty("BREMSE_REIBBELAG_2KJ8","normal");
    ExecSetStandardifValueEmpty("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8","ohne");
    
    ExecSetStandardifValueEmpty("BELUEFTUNG_2KJ8","Kunststoff");
    
    //Bei Kühlturmantrieben ist Anschlusskasten vergossen Default.
    if(oDataGear.oRow.EGBEZBRA=="K")
    {
        ECL_DeselectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8","T");
    }
    
    
    //Checkboxen mit Default Werten laden
    if(!ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
    
    if(!ECL_ValueSelected("WASSERABLAUF_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("WASSERABLAUF_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("SPIELREDUZIERT_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("SPIELREDUZIERT_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("RUTSCHKUPPLUNG_ADAPTER_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("RUTSCHKUPPLUNG_ADAPTER_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("RUECKLAUFSPERRE_ADAPTER_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("RUECKLAUFSPERRE_ADAPTER_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("DREHRICHTUNG_ADAPTER_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("DREHRICHTUNG_ADAPTER_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("KONDENSWASSERLOCH_ADAPTER_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("KONDENSWASSERLOCH_ADAPTER_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_CHINA_2KJ8", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_CHINA_2KJ8");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_ULR_CSA_2KJ8", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_ULR_CSA_2KJ8");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_EAC_2KJ8", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_EAC_2KJ8");
        
    if(!ECL_ValueSelected("ERHOEHTE_LEISTUNG_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ERHOEHTE_LEISTUNG_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("SPANNUNGSTOLERANZ_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("SPANNUNGSTOLERANZ_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("SAEURESCHUTZ_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("SAEURESCHUTZ_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("ERDUNGSSCHRAUBE_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ERDUNGSSCHRAUBE_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("ANSCHLUSSKASTEN_NEUTRAL_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ANSCHLUSSKASTEN_NEUTRAL_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        ECL_DeselectAttribute ("MIT_BREMSE_2KJ8");
        
    if(!ECL_ValueSelected("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8");
                
    if(!ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("DREHRICHTUNG_MOTOR_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("DREHRICHTUNG_MOTOR_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("ZWEITES_WELLENENDE_OPTION_2KJ8");

    if(!ECL_ValueSelected("HANDRAD_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("HANDRAD_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("SCHUTZDACH_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("KONDENSWASSERBOHRUNG_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("KONDENSWASSERBOHRUNG_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("INNENKORROSIONSSCHUTZ_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("VORBEHANDLUNG_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("VORBEHANDLUNG_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("LANGZEITKONSERVIERUNG_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("LANGZEITKONSERVIERUNG_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_DEUTSCH_2KJ8", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_DEUTSCH_2KJ8");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_ENGLISCH_2KJ8", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_ENGLISCH_2KJ8");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_CHINA_2KJ8", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_CHINA_2KJ8");
        
    if(!ECL_ValueSelected("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_MOTOR_2KJ8", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_MOTOR_2KJ8");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_GETRIEBE_2KJ8", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_GETRIEBE_2KJ8");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_ANSTRICH_2KJ8", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_ANSTRICH_2KJ8");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_PROJEKTE_2KJ8", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_PROJEKTE_2KJ8");
        
    if(!ECL_ValueSelected("SCHNELLSCHIENE_OPTION_2KJ8", "T"))
        ECL_DeselectAttribute ("SCHNELLSCHIENE_OPTION_2KJ8");
}

function checkMLFBandConfiguration(onewMLFB)
{
    //2KJ3104-.GJ27-9.L1-Z +N1N
    //check the MLFB and the configuration
    var stroldMLFB=ECL_GetValue("ECSI_MLFB");
    
    if(find(stroldMLFB.left(16),".")>-1)
    {
        stroldMLFB=normalizeMLFB( stroldMLFB );
        var aoldMLFB=tokenize( stroldMLFB, true );
    
        if(aoldMLFB.length > 5)
        {
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_TOO_MANY_SHORTDESCRIPTIONS"));
            
            return;
        }
        
        var ooldMLFB=sanatizeSizerMLFB( aoldMLFB[0], aoldMLFB[1], aoldMLFB[2], aoldMLFB[3], aoldMLFB[4] );
    
        //teilqualifizierte MLFB, relevante Stellen vergleichen
        //zuerst Base MLFB so umbauen, dass an Stelle 8 und 14 Punkte stehen
        var strnewMLFB=onewMLFB.strBaseMLFB;
        
        strnewMLFB=strnewMLFB.slice(0,7)+'-'+strnewMLFB.slice(8,11)+".."+'-'+strnewMLFB.slice(14,15)+"."+strnewMLFB.slice(16,18);
        
        if(ooldMLFB.strMLFB != strnewMLFB)
        {
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_BASE"));
            
            return;
        }
        
        if(!checkBAUFORM())
        {
            ECL_SelectValue ("ECSI_STATUS", "E");
            ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_BAUFORM"));
            
            return;
        }
        
    }
    else
    {
        //2KJ3104-1GJ27-9AL1-Z D03 +K01 +K06 +L02 +M16 +M55 +N1N +P92 +Y80 {Y80: *RAL(a)6029*}
        //KomplettMLFB
        
        var strFreetextColor="";
        if(find(stroldMLFB,'{Y80')>-1)
        {
            strFreetextColor = stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y80')+1);
            stroldMLFB = replace(stroldMLFB,strFreetextColor,"");
            strFreetextColor = replace(strFreetextColor,"{","");
            strFreetextColor = replace(strFreetextColor,"*}","*'");
            strFreetextColor = replace(strFreetextColor,": *","'*");
            strFreetextColor = replace(strFreetextColor,":*","'*");
        }
        
        var strFreetext="";
        if(find(stroldMLFB,'{Y00')>-1)
        {
            strFreetext = stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y00')+1);
            stroldMLFB = replace(stroldMLFB,stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y00')+1),"")
            strFreetext = replace(strFreetext,"{","");
            strFreetext = replace(strFreetext,"*}","*'");
            strFreetext = replace(strFreetext,": *","'*");
            strFreetext = replace(strFreetext,":*","'*");
        }
        
        stroldMLFB=normalizeMLFB( stroldMLFB );
        var aoldMLFB=tokenize( stroldMLFB, false );
        var stroldMLFB=aoldMLFB[0];
        var newMLFB=replace(onewMLFB.strBaseMLFB,"-","");
        
        var aShortDescriptions=[];
        for(var i=1;i<aoldMLFB.length;i++)
        {
            if(aoldMLFB[i]!="Y80" && aoldMLFB[i]!="Y00")
            {
                 // Nur existierende KA's übernehmen
                var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
                if(strStartConfiguration=="1")
                {
                    var strSelect_Test;
                    strSelect_Test = "SELECT OPTION_ID, DICT_ID FROM OPTION_VALUES WHERE KURZANGABE = '" + aoldMLFB[i] + "' ";
                    if ( dbselect( "2KJ8_KURZANGABEN_DB", strSelect_Test, 'RS_OPTION_KA_TEST' ) > 0 )
                    {
                        aShortDescriptions.push("+"+aoldMLFB[i]);
                    }
                }
                else
                {
                    aShortDescriptions.push("+"+aoldMLFB[i]);
                }
            }
        }
        
        if(strFreetextColor!="")
        {
            aShortDescriptions.push("+"+strFreetextColor);
        }
        
        if(strFreetext!="")
        {
            aShortDescriptions.push("+"+strFreetext);
        }
        
        aShortDescriptions.sort();
        aoldMLFB = buildFormattedShortDescriptions( aShortDescriptions, 'MOTOX_' );
        
        if(aoldMLFB.strStrippedShortDescriptions!=onewMLFB.strStrippedShortDescriptions && ECL_GetValue("ECSI_MLFB_CAN_CHANGE_2KJ8") != "TRUE")
        {
                if(find(aoldMLFB.strStrippedShortDescriptions,"G45")<0 && find(onewMLFB.strStrippedShortDescriptions,"G45")>-1)
                {
                    //G45 wurde ergänzt
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_G45"));
                }
                else
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                }
                
                return;
        }
        
        if(stroldMLFB!=newMLFB && ECL_GetValue("ECSI_MLFB_CAN_CHANGE_2KJ8") != "TRUE")
        {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                
                return;
        }
        
        if(aoldMLFB.strFormattedShortDescriptions!=onewMLFB.strFormattedShortDescriptions && ECL_GetValue("ECSI_MLFB_CAN_CHANGE_2KJ8") != "TRUE")
        {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                
                return;
        }
        
    }

    
    //Attribute überprüfen
    var aAttributes=ECL_GetAllAttributes();
    
    for(var i=0;i<aAttributes.length;i++)
    {

        var controlType = ECL_GetControlType(aAttributes[i]);

        var visible = ECL_AttributeVisible(aAttributes[i]);
        
        if(ECL_AttributeActive(aAttributes[i]) && visible == true && left(aAttributes[i],5)!="ECSI_" && controlType !="EDIT" && controlType !="CHECK_H")
        {
            if (ECL_GetValue(aAttributes[i]) != "")
            {
                var aSelectedValues=ECL_GetAllActiveAttributeValues(aAttributes[i]);
                if(aSelectedValues.length>0)
                {
                    
                }
                else
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___CONFIG_ATTRIBUTES")+" ("+ECL_TranslateAttribute (aAttributes[i])+")");
                    
                    logtraceln("Attribute "+aAttributes[i]+" hat keine Werte zur Auswahl!");
                
                    return;
                }
            }
            else
            {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___CONFIG_ATTRIBUTES")+" ("+ECL_TranslateAttribute (aAttributes[i])+")");
                    
                    logtraceln("Attribute "+aAttributes[i]+" hat keinen gesetzten Wert");
                    return;
            }
        }
    }
    
    ECL_SelectValue ("ECSI_STATUS", "OK");
    ECL_SetValue ("ECSI_STATUS_MESSAGE", "");

}

function checkContextValues(oDataGear, bfull)
{
    //Contex Variablen überprüfen, ob dieser zur Konfiguration passen.
    
    var iCoolingMethod = parseInt(ECL_GetValue("ECSI_CX_CoolingMethodMotor"));
    if(isNaN(iCoolingMethod))
        iCoolingMethod=0;
    
    if(iCoolingMethod>0)
    {
        //nur 0 (Eigenbelüftet)
        return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION_NOT_SUPPORTED")
    }
    
    var strProduct=ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8");
    
    var strContextFieldBusInterface=ECL_GetValue("ECSI_CX_FieldbusInterface");
    
    //Überprüfung BremsenContext
    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    
    var iResult=checkBremse(oDataGear);
    if( (strwithBrake=="1" || strwithBrake=="Yes") && iResult==0)
        return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE")
    
    if(bfull)
    {
        if( (strwithBrake=="1" || strwithBrake=="Yes") && !ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        {
            ECL_SetValue("ECSI_MLFB_CAN_CHANGE_2KJ8", "TRUE");
            //return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE2")
        }
        else if( (strwithBrake=="0" || strwithBrake=="No") && ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
        {
            ECL_SetValue("ECSI_MLFB_CAN_CHANGE_2KJ8", "TRUE");
            //return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE2")
        }
        //tfreichel Bremsencontex 2021.04 aktiviert
    }

    //Hier kann nichts getan werden

   

//Ambient Temperature    
/*
25 ==> ≤25
30 ==> ≤30
35 ==> ≤35
40 ==> ≤40
45 ==> ≤45
50 ==> ≤50
55 ==> ≤55
60 ==> ≤60

*/
    var iAmbientTemperature = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor"));
    if(isNaN(iAmbientTemperature))
        iAmbientTemperature=25;
    
    if(iAmbientTemperature>55)
    {
        //only until 55 degrees allowed
        return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_NOT_SUPPORTED")
    }
    
    if (iAmbientTemperature <= 40) {
        //No K94 must be present
        if (bfull) {
            if (ECL_GetValue("ECSI_TEMPERATURE_SD_2KJ8") == "K94")
                return ("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_CHANGED")
        }
    }
    else if (iAmbientTemperature > 40) {
        //K94 needs to be present
        if (bfull) {
            if (ECL_GetValue("ECSI_TEMPERATURE_SD_2KJ8") != "K94")
                return ("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_CHANGED")
        }

        // K97 must not be present
        if (bfull) {
            if (ECL_GetValue("ECSI_TEMPERATURE_SD_2KJ8") == "K97")
                return ("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_CHANGED")
        }
    }

    
    oDataGear.oRow.SIZER_AmbientTemperatureMotor=iAmbientTemperature;
    
    //***********************
    //Zuerst Befestigungsart
    
    var iMountingPosition = parseInt(ECL_GetValue("ECSI_CX_MountingPosition"));
    
    if(isNaN(iMountingPosition))
    {
        iMountingPosition = 1;
    }
        
    var strCX_Bauform="";
    var strCX_Abtriebsseite="";
    var strCX_BAUFORM_EGPOS="";
    
    if(iMountingPosition < 7)
    {
        strCX_Bauform = "M"+iMountingPosition;
        
        if(oDataGear.oRow.EGBEZTYP == "-" || oDataGear.oRow.EGBEZTYP == "F")
        {
            strCX_Abtriebsseite = "-";
            strCX_BAUFORM_EGPOS = strCX_Bauform;
        }
        else
        {
            strCX_Abtriebsseite = "A";
            strCX_BAUFORM_EGPOS = strCX_Bauform + "-A";
        }
    }
    else
    {
        strCX_Bauform = "M"+(iMountingPosition-6);
            
        if(oDataGear.oRow.EGBEZTYP == "-" || oDataGear.oRow.EGBEZTYP == "F")
        {
            strCX_Abtriebsseite = "-";
            strCX_BAUFORM_EGPOS = strCX_Bauform;
        }
        else
        {
            strCX_Abtriebsseite = "B";
            strCX_BAUFORM_EGPOS = strCX_Bauform + "-B";
        }
    }

    
	// Es sind für bestimmte Getriebe nicht alle Abtriebsseiten möglich.
	// hier prüfen!
	var bpossible=checkEinbaulageContext(oDataGear, strCX_BAUFORM_EGPOS);
	
	if(bpossible)
	{
		if(!bfull)
		{
			//Teilqualifizierte MLFB, Werte können gesetzt werden.
			ECL_SetValue("BAUFORM_2KJ8",strCX_Bauform);
			ECL_SetValue("ECSI_BAUFORM_EGPOS_2KJ8",strCX_BAUFORM_EGPOS);
			ECL_SetValue("ABTRIEBSSEITE_2KJ8",strCX_Abtriebsseite);
		}
		else
		{
			//Komplett MLFB
			//aktuelle Werte aus der Konfiguration

			var strConfig_Bauform=ECL_GetValue("BAUFORM_2KJ8");
			var strConfig_BAUFORM_EGPOS=ECL_GetValue("ECSI_BAUFORM_EGPOS_2KJ8");
			var strConfig_Abtriebsseite=ECL_GetValue("ABTRIEBSSEITE_2KJ8");
		
			if(strConfig_Bauform==strCX_Bauform && strConfig_Abtriebsseite==strCX_Abtriebsseite && strConfig_BAUFORM_EGPOS==strCX_BAUFORM_EGPOS)
			{
				//Werte haben sich nicht geändert, keine Aktion nötig
			}
			else
			{
				//vorerst immer Fehler ausgeben
				return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_MOUNTING_TYPE";
				
				/*
				if( ECL_ValueEnabled ("BAUFORM",strCX_Bauform ) && ECL_ValueEnabled ("ABTRIEBSSEITE",strCX_Abtriebsseite ))
				{
					ECL_SetValue("BAUFORM",strCX_Bauform);
					ECL_SetValue("ECSI_BAUFORM_EGPOS",strCX_BAUFORM_EGPOS);
					ECL_SetValue("ABTRIEBSSEITE",strCX_Abtriebsseite);
					
					//Die MLFB in ECSI_MLFB muss noch angepasst werden, da es sonst zu einem Fehler kommt
					var oMLFB = buildFormattedMLFB( oDataGear, true);
					var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
					ECL_SetValue("ECSI_MLFB",strMLFB);
					logtraceln("MLFB="+strMLFB);
				}
				else
				{
					return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_MOUNTING_TYPE";
				}
				*/
				
			}
		}
	}
	else
	{
		return "ERROR_2KJ___CX_CONTEXT_MOUNTING_TYPE_NOTVALID";
	}
	
    return "";
}

function BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse)
{
    //Bestimmung der Getriebemotorbezeichnung
    var strGetriebeMotorBezeichnung="";
    

    var strGetriebe=oDataGear.oRow.EGBEZTYP+oDataGear.oRow.EGBEZUEBS+oDataGear.oRow.EGBEZBRA;
    
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    if(strWelle=="Einsteckwelle")
        strGetriebe=strGetriebe+"E";
    else if(strWelle=="Hohlwelle" || strWelle=="Hohlwelle_Edelstahl" || strWelle=="Hohlwelle_mit_Schrumpfscheibe" || strWelle=="Hohlwelle_mit_Vielkeilverzahnung" || strWelle=="Hohlwelle_mit_SIMOLOC")
        strGetriebe=strGetriebe+"A";
    else if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_mit_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_fuer_Kuehlturmantriebe")
        strGetriebe=strGetriebe+"-";
    else
        logtraceln("Fehler bei der Getriebemotorbezeichnung, Welle unbekannst!");
    
    strGetriebe=strGetriebe+ECL_GetValue("BEFESTIGUNGSART_2KJ8");
    strGetriebe=strGetriebe+GetEGBEZWNV();
    
    if(ECL_ValueSelected("SPIELREDUZIERT_OPTION_2KJ8","T"))
        strGetriebe=strGetriebe+"W";
    
    strGetriebe=strGetriebe+oDataGear.oRow.EGBEZDIM+oDataGear.oRow.EGBEZEI;
    
    strGetriebe=replace(strGetriebe,"-","");
    
    //MOTOR
    
    var strSchutzdach="";
	var strBremse="";
	var strMotor="";
	
	var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
	if(strG115_Type=="MM")
	{
		var strMotor=oDataGear.oRow.MOT_BZ_LANG;
		strMotor=strMotor+"-G";
		
		
		// Leistung
		var strLeistung=oDataGear.oRow.MOTFHT_LEISTUNG1;
		var strBemessungsleistung="";
		
		var strSelect = "SELECT DISTINCT converter_power FROM g115_systempower WHERE ";
		strSelect = strSelect + "g115_systemleistung="+strLeistung+" ";
		
		var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
		if(aResult.length==1)
		{
			strBemessungsleistung = aResult[0].CONVERTER_POWER;
			if(strBemessungsleistung == "0.37")
			{
				strMotor=strMotor+"003";
			}
			else if(strBemessungsleistung == "0.55")
			{
				strMotor=strMotor+"005";
			}
			else if(strBemessungsleistung == "0.75")
			{
				strMotor=strMotor+"007";
			}
			else if(strBemessungsleistung == "1.1")
			{
				strMotor=strMotor+"011";
			}
			else if(strBemessungsleistung == "1.5")
			{
				strMotor=strMotor+"015";
			}
			else if(strBemessungsleistung == "2.2")
			{
				strMotor=strMotor+"022";
			}
			else if(strBemessungsleistung == "3")
			{
				strMotor=strMotor+"030";
			}
			else if(strBemessungsleistung == "4")
			{
				strMotor=strMotor+"040";
			}
		}	
		
		//Motor Mounted
		strMotor=strMotor+"M-";
		
		
		// Kommunikation
        var strKommunikation=ECL_GetValue("G115_KOMMUNIKATION_2KJ8");
		if(strKommunikation=="Profinet")
		{
			strMotor=strMotor+"PN";
		}
		else if(strKommunikation=="AS-i")
		{
			strMotor=strMotor+"ASi";
		}
		else if(strKommunikation=="I/O control")
		{
			strMotor=strMotor+"IO";
		}
		
		//Bremse

        if(ECL_ValueSelected("MIT_BREMSE_2KJ8","T"))
		{
			strBremse=strBremse+oDataBremse.oRow.BREART;
			strBremse=strBremse+oDataBremse.oRow.BRENENMO;
			
			if(ECL_ValueSelected("BREMSE_AUSFUEHRUNG_2KJ8", "G") || ECL_ValueSelected("BREMSE_AUSFUEHRUNG_2KJ8", "GK"))
				strBremse=strBremse+"G";
			
			if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG_2KJ8", "H"))
				strBremse=strBremse+"H";
			else if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG_2KJ8", "HA"))
				strBremse=strBremse+"HA";
		}
		
		if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8","T"))
            strSchutzdach="-W";
	}
	else if(strG115_Type=="WM")
	{
		var strMotor=oDataGear.oRow.MOT_BZ_LANG;
		strMotor=strMotor+"-G";
		
        // Leistung
		var strLeistung=oDataGear.oRow.MOTFHT_LEISTUNG1;
		var strBemessungsleistung="";
		
		var strSelect = "SELECT DISTINCT converter_power FROM g115_systempower WHERE ";
		strSelect = strSelect + "g115_systemleistung="+strLeistung+" ";
		
		var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
		if(aResult.length==1)
		{
			strBemessungsleistung = aResult[0].CONVERTER_POWER;
			if(strBemessungsleistung == "0.37")
			{
				strMotor=strMotor+"003";
			}
			else if(strBemessungsleistung == "0.55")
			{
				strMotor=strMotor+"005";
			}
			else if(strBemessungsleistung == "0.75")
			{
				strMotor=strMotor+"007";
			}
			else if(strBemessungsleistung == "1.1")
			{
				strMotor=strMotor+"011";
			}
			else if(strBemessungsleistung == "1.5")
			{
				strMotor=strMotor+"015";
			}
			else if(strBemessungsleistung == "2.2")
			{
				strMotor=strMotor+"022";
			}
			else if(strBemessungsleistung == "3")
			{
				strMotor=strMotor+"030";
			}
			else if(strBemessungsleistung == "4")
			{
				strMotor=strMotor+"040";
			}
		}	
		
		//Wandmontiert
		strMotor=strMotor+"W";
		
		// Kommunikation
		//Gibts hier nicht
		
		//Bremse=
		var strBremse="";
		if(ECL_ValueSelected("MIT_BREMSE_2KJ8","T"))
		{
						
			strBremse=strBremse+oDataBremse.oRow.BREART;
			strBremse=strBremse+oDataBremse.oRow.BRENENMO;
			
			if(ECL_ValueSelected("BREMSE_AUSFUEHRUNG_2KJ8", "G") || ECL_ValueSelected("BREMSE_AUSFUEHRUNG_2KJ8", "GK"))
				strBremse=strBremse+"G";
			
			if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG_2KJ8", "H"))
				strBremse=strBremse+"H";
			else if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG_2KJ8", "HA"))
				strBremse=strBremse+"HA";
		}
		
		if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8","T"))
            strSchutzdach="-W";
	}
		
	strGetriebeMotorBezeichnung=strGetriebe+"-"+strMotor;
	if(strBremse!="")
        strGetriebeMotorBezeichnung=strGetriebeMotorBezeichnung+"-"+strBremse;

    if(strSchutzdach!="")
		strGetriebeMotorBezeichnung=strGetriebeMotorBezeichnung+strSchutzdach
	
		
    return(strGetriebeMotorBezeichnung);
}


function generateG115DMLFB(oData)
{
    // Bestimmung der MLFB des 6SL32 Umrichters zur Übertragung als Secondary MLFB
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    var strG115_MLFB_13 = ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_MLFB_2KJ8");
    
    var strSelect="Select DISTINCT MLFB_G115_7,MLFB_G115_8,MLFB_G115_10,MLFB_G115_11,MLFB_G115_14,MLFB_G115_15,MLFB_G115_16 FROM G115_ADPT WHERE ";
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_BUSSYSTEM_VS='"+replace(ECL_GetValue("G115_ANSCHLUSS_2KJ8"),'_Zoll','"')+"' AND ";
    strSelect=strSelect+"G115_BUSSYSTEM_POS='"+ECL_GetValue("G115_POSITION_KOMM_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

    // V71 interne Versorgung
    if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
    {
        strSelect=strSelect+"G115_INTERN_24V='24VDC' AND ";
    }
    else
    {
        strSelect=strSelect+"G115_INTERN_24V='-' AND ";
    }
    
    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if(aResult.length==1)
    {
        var strSelect="Select DISTINCT MLFB_G115_6,MLFB_G115_9,MLFB_G115_12,MLFB_G115_13 FROM G115_TYP WHERE ";
        
        strSelect=strSelect+"WIBLNR='"+oData.oRow.WIBLNR+"' AND ";
        strSelect=strSelect+"MLFB_2KJ8_13='"+strG115_MLFB_13+"' AND ";
        if(strG115_Type=="MM")
            strSelect = strSelect + "G115M = '1' AND ";
        else if(strG115_Type=="WM")
            strSelect = strSelect + "G115D = '1' AND ";
        
        strSelect=strSelect+"REGION like'S%' AND ";
        strSelect=strSelect+"AKTIV='1' ";
        
        var aResult2 = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResult2.length>0)
        {
            //Stelle 7 Bremsenspannung ist immer 180V, also "0"
            if(strG115_Type=="WM")
                aResult[0].MLFB_G115_7="0";
                
            //Wir immer fest gesetzt
            aResult[0].MLFB_G115_14="A";
            aResult[0].MLFB_G115_16="0";
                
            var strMLFB_komplett="6SL35"+aResult2[0].MLFB_G115_6+aResult[0].MLFB_G115_7+aResult[0].MLFB_G115_8+aResult2[0].MLFB_G115_9+aResult[0].MLFB_G115_10+aResult[0].MLFB_G115_11+aResult2[0].MLFB_G115_12+aResult2[0].MLFB_G115_13+aResult[0].MLFB_G115_14+aResult[0].MLFB_G115_15+aResult[0].MLFB_G115_16;
            return (replace(strMLFB_komplett,"~","."));
        }
        else
            logtraceln("Fehler bei Bestimmung Secondary MLFB G115D!, SQL="+strSelect);
    }
    else
        logtraceln("Fehler bei Bestimmung Secondary MLFB G115D!, SQL="+strSelect);

}
