//@legacy
//#mode(full-ecma)

//@import "VT_TF.js"

//@import "models/CFG_2KJ_UMRICHTER_Model.js"


function SetUmrichter_Init(strchangedAttribute,oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    Bestimme_G115D_Kommunikation(oData);
    Bestimme_G115D_24V_Versorgung(oData);
    Bestimme_G115D_24V_Versorgung_INTERN(oData);
    Bestimme_G115D_Anschluss_NEU(oData);
    Bestimme_G115D_Anschluss(oData);
    
    if(strG115_Type=="MM")
    {
        SetzeKKMAT(oData,oDataBremse);
        SetzeAnschluss(oData);
    }
    
    Bestimme_G115D_Kommunikation_Position(oData);
    
    if(strG115_Type=="WM")
    {
        ECL_DeactivateAttribute("G115_KOMMUNIKATION_2KJ8");
        ECL_DeactivateAttribute("G115_ANSCHLUSS_2KJ8");
        ECL_DeactivateAttribute("G115_POSITION_KOMM_2KJ8");
        ECL_DeactivateAttribute("G115_VERSORGUNG_2KJ8");
        ECL_DeactivateAttribute("G115_VERSORGUNG_INTERN_2KJ8");
        ECL_DeactivateAttribute("G115_ANSCHLUSSTECHNIK_2KJ8");
        ECL_DeactivateAttribute("G115_SPEICHERKARTE_2KJ8");
        ECL_DeactivateAttribute("G115_ADD_SPEICHERKARTE_2KJ8");
        ECL_DeactivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
    }
    else if(strG115_Type=="MM")
    {
        ECL_DeactivateAttribute("MOTORSTECKER_2KJ8");
        ECL_DeactivateAttribute("GEGENSTECKER_2KJ8");
        ECL_DeactivateAttribute("G115_ANSCHLUSS_2KJ8");
    }

    if(strG115_Type=="MM")
    {
        var strSafetySLS = ECL_GetValue("ECSI_CX_SafetyFunctions");
        if(strSafetySLS=="2")
        {
            ECL_ActivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
            
            ECL_DeactivateAllAttributeValues("G115_SPEICHERKARTE_2KJ8");
            ECL_ActivateValue("G115_SPEICHERKARTE_2KJ8","leer");
            ECL_ActivateValue("G115_SPEICHERKARTE_2KJ8","firmware");
            ExecSetStandardifValueEmpty("G115_SPEICHERKARTE_2KJ8","firmware");	
            
            ECL_SetValue("G115_FUNCTION_SAFETY_SLS_2KJ8","T");
            ECL_DisableAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
        }
        else
        {
            if(ECL_GetValue("G115_SPEICHERKARTE_2KJ8")=="ohne")
            {
                ECL_DeactivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
                ECL_DeselectAttribute ("G115_FUNCTION_SAFETY_SLS_2KJ8");
            }
            else
            {
                ECL_ActivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
            }
        }

        // zusätzliche Speicherkarte
        if(ECL_ValueSelected("G115_SPEICHERKARTE_2KJ8","ohne"))
        {
            ECL_ActivateAttribute("G115_ADD_SPEICHERKARTE_2KJ8");
            ECL_ActivateValue("G115_ADD_SPEICHERKARTE_2KJ8","ohne");
            ECL_ActivateValue("G115_ADD_SPEICHERKARTE_2KJ8","VERSION_4_7_SP13");
            ExecSetStandardifValueEmpty("G115_ADD_SPEICHERKARTE_2KJ8","ohne");	
        }
        else
        {
            ECL_SetValue("G115_ADD_SPEICHERKARTE_2KJ8","ohne");
            ECL_DeactivateAttribute("G115_ADD_SPEICHERKARTE_2KJ8");
        }
    }
}


function SetUmrichter(strchangedAttribute,oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    if(strchangedAttribute=="MOTORSTECKER_2KJ8" || strchangedAttribute=="GEGENSTECKER_2KJ8")
    {
        Bestimme_G115D_Kommunikation(oData);
        Bestimme_G115D_24V_Versorgung(oData);
        Bestimme_G115D_24V_Versorgung_INTERN(oData);
        Bestimme_G115D_Anschluss_NEU(oData)
        Bestimme_G115D_Anschluss(oData);
        
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }
    
    if(strchangedAttribute=="G115_KOMMUNIKATION_2KJ8")
    {
        Bestimme_G115D_24V_Versorgung(oData);
        Bestimme_G115D_24V_Versorgung_INTERN(oData);
        Bestimme_G115D_Anschluss_NEU(oData);
        Bestimme_G115D_Anschluss(oData);
        
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }
    
    if(strchangedAttribute=="G115_VERSORGUNG_2KJ8")
    {
        Bestimme_G115D_24V_Versorgung_INTERN(oData);
        Bestimme_G115D_Anschluss_NEU(oData);
        Bestimme_G115D_Anschluss(oData);
        
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }

    if(strchangedAttribute=="G115_VERSORGUNG_INTERN_2KJ8")
    {
        Bestimme_G115D_Anschluss_NEU(oData);
        Bestimme_G115D_Anschluss(oData);
        
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }
    
    if(strchangedAttribute=="G115_ANSCHLUSS_2KJ8")
    {
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }
    
    if(strchangedAttribute=="G115_ANSCHLUSSTECHNIK_2KJ8")
    {
        if(strG115_Type=="MM")
        {
            SetzeKKMAT(oData,oDataBremse);
            SetzeAnschluss(oData);
        }
        
        Bestimme_G115D_Kommunikation_Position(oData);
    }
    if(strG115_Type=="MM")
    {
        var strSafetySLS = ECL_GetValue("ECSI_CX_SafetyFunctions");
        if(strSafetySLS=="2")
        {
            ECL_ActivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
            
            ECL_DeactivateAllAttributeValues("G115_SPEICHERKARTE_2KJ8");
            ECL_ActivateValue("G115_SPEICHERKARTE_2KJ8","leer");
            ECL_ActivateValue("G115_SPEICHERKARTE_2KJ8","firmware");
            ExecSetStandardifValueEmpty("G115_SPEICHERKARTE_2KJ8","firmware");	
            
            ECL_SetValue("G115_FUNCTION_SAFETY_SLS_2KJ8","T");
            ECL_DisableAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
        }
        else
        {
            if(ECL_GetValue("G115_SPEICHERKARTE_2KJ8")=="ohne")
            {
                ECL_DeactivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
                ECL_DeselectAttribute ("G115_FUNCTION_SAFETY_SLS_2KJ8");
            }
            else
            {
                ECL_ActivateAttribute("G115_FUNCTION_SAFETY_SLS_2KJ8");
            }
        }

        // zusätzliche Speicherkarte
        if(ECL_ValueSelected("G115_SPEICHERKARTE_2KJ8","ohne"))
        {
            ECL_ActivateAttribute("G115_ADD_SPEICHERKARTE_2KJ8");
            ECL_ActivateValue("G115_ADD_SPEICHERKARTE_2KJ8","ohne");
            ECL_ActivateValue("G115_ADD_SPEICHERKARTE_2KJ8","VERSION_4_7_SP13");
            ExecSetStandardifValueEmpty("G115_ADD_SPEICHERKARTE_2KJ8","ohne");	
        }
        else
        {
            ECL_SetValue("G115_ADD_SPEICHERKARTE_2KJ8","ohne");
            ECL_DeactivateAttribute("G115_ADD_SPEICHERKARTE_2KJ8");
        }
    }
}
