//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"




//Defaulterte setzen
function SetVorauswahl_Init()
{
    //Initialisierung der Auswahlfelder
    ECL_SelectValue ("ECSI_GETRIEBETYP_2KJ8", "Stirnradgetriebe");
    ECL_SelectValue ("ECSI_SPEZIFIKATION_RADIO_2KJ8", "CE");
    ECL_SelectValue ("ECSI_VORAUSWAHL_2KJ8", "auswahl_motorleistung");
    
    
    //Wirkungsgradklasse
    var awhere = new Array();
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")});
    
    if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
    else
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8",DB:"MOT_EFFIZIENZKL_KNZ"});
    
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);

    
    //Polzahl
    var awhere = new Array();
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")});
    
    if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
    else
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});
        
    if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
    else
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_POLZAHL_2KJ8",DB:"MOT_POLZAHL"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "AND MOT_POLZAHL='4'";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);

    //Frequenz
    var awhere = new Array();
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")});
    
    if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
    else
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
        
    if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
    else
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});
        
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_FREQUENZ_VORAUSWAHL_2KJ8",DB:"MOT_FREQUENZ"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "AND MOT_FREQUENZ = '50' ";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);

    //Motorleistung von
    var awhere = new Array();
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")});
    
    if(ECL_ValueSelected("ECSI_VSD_MOTOREN", "VSD_4000"))
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
    else
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
    
    if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
    else
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});
    
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")});
    
    if(ECL_GetValue ("ECSI_GETRIEBETYP_2KJ8") == "Schneckengetriebe")
        awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"I"});
    else	
        awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"-"});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_MOTORLEISTUNG_VON_2KJ8",DB:"MOT_LEISTUNG"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "AND MOT_LEISTUNG='0.75' ";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);

    //Motorleistung bis
    var awhere = new Array();
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")});
    
    if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
    else
        awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
        
    if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
    else
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});

    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")});
    
    if(ECL_GetValue ("ECSI_GETRIEBETYP_2KJ8") == "Schneckengetriebe")
        awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"I"});
    else	
        awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"-"});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_MOTORLEISTUNG_BIS_2KJ8",DB:"MOT_LEISTUNG"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "AND MOT_LEISTUNG='0.75' ";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    
    ECL_SetValue ("ECSI_ABTRIEBSDREHZAHL_VON_2KJ8", 20.0);
    ECL_SetValue ("ECSI_ABTRIEBSDREHZAHL_BIS_2KJ8", 150.0);
    
    ECL_SetValue ("ECSI_ABTRIEBSMOMENT_VON_2KJ8", 0.0);
    ECL_SetValue ("ECSI_ABTRIEBSMOMENT_BIS_2KJ8", 750.0);
    
    ECL_SetValue ("ECSI_BETRIEBSFAKTOR_VON_2KJ8", 1.5);
    ECL_SetValue ("ECSI_BETRIEBSFAKTOR_BIS_2KJ8", 5.0);

}

function SetVorauswahl(strchangedAttribute)
{
    //setzen der Vorauswahl in Abhängigkeit der getroffenden Auswahl
    setSpecificationCheckboxes();
    var oData=new Object();
    var SpecString = createSpecString(oData);
    
    if(strchangedAttribute == "ECSI_BRANCHENANTRIEBE_2KJ8")
    {
        if(ECL_ValueSelected("ECSI_BRANCHENANTRIEBE_2KJ8", "HAENGEBAHN"))
        {
            ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
            var awhere = new Array();
            awhere.push({CD_GETRIEBE_GRUPPEN:"EGBEZBRA",Value:"H"});
            
            var aAttributes = new Array();
            aAttributes.push({IDENT:"ECSI_GETRIEBETYP_2KJ8",DB:"GETRIEBE_TYP_BEZ"});
            ExecSQL_Standard("2KJ8_DB", "CD_GETRIEBE_GRUPPEN", aAttributes, awhere);
            
            var aDefaultSQL = "";
            ExecSQL_GetDefaultStandard("2KJ8_DB", "CD_GETRIEBE_GRUPPEN", aAttributes, awhere, aDefaultSQL);
        }
        else
        {
            ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
            var awhere = new Array();
            awhere.push({CD_GETRIEBE_GRUPPEN:"EGBEZBRA",Value:"-"});
            
            var aAttributes = new Array();
            aAttributes.push({IDENT:"ECSI_GETRIEBETYP_2KJ8",DB:"GETRIEBE_TYP_BEZ"});
            ExecSQL_Standard("2KJ8_DB", "CD_GETRIEBE_GRUPPEN", aAttributes, awhere);
            
            var aDefaultSQL = "";
            ExecSQL_GetDefaultStandard("2KJ8_DB", "CD_GETRIEBE_GRUPPEN", aAttributes, awhere, aDefaultSQL);
        }
    }
    
    if(strchangedAttribute == "ECSI_GETRIEBETYP_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
    }
    
    if(strchangedAttribute == "ECSI_VSD_MOTOREN_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_RADIO_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_CHECK_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        var awhere = new Array();
        awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:SpecString});
        
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
        else
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8",DB:"MOT_EFFIZIENZKL_KNZ"});
        ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    }
    
    if(strchangedAttribute == "ECSI_VSD_MOTOREN_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_RADIO_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_CHECK_2KJ8" || strchangedAttribute == "ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        var awhere = new Array();
        awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:SpecString});
        
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN", "VSD_4000"))
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
        else
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
            
        if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
        else
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL")});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"ECSI_POLZAHL_2KJ8",DB:"MOT_POLZAHL"});
        ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    }
    
    if(strchangedAttribute == "ECSI_VSD_MOTOREN_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_RADIO_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_CHECK_2KJ8" || strchangedAttribute == "ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8" || strchangedAttribute == "ECSI_POLZAHL_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        var awhere = new Array();
        awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:SpecString});
        
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
        else
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
            
        if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
        else
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});
        awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"ECSI_FREQUENZ_VORAUSWAHL_2KJ8",DB:"MOT_FREQUENZ"});
        ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    }
    
    if(strchangedAttribute == "ECSI_VSD_MOTOREN_2KJ8" || strchangedAttribute == "ECSI_GETRIEBETYP_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_RADIO_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_CHECK_2KJ8" || strchangedAttribute == "ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8" || strchangedAttribute == "ECSI_POLZAHL_2KJ8" || strchangedAttribute == "ECSI_FREQUENZ_VORAUSWAHL_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        var awhere = new Array();
        awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:SpecString});
        
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
        else
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
            
        if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
        else
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8")});
            
        awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
        awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")});
        
        if(ECL_GetValue ("ECSI_GETRIEBETYP_2KJ8") == "Schneckengetriebe")
            awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"I"});
        else	
            awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"-"});
        
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"ECSI_MOTORLEISTUNG_VON_2KJ8",DB:"MOT_LEISTUNG"});
        ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
        
        var aDefaultSQL = "AND MOT_LEISTUNG='0.75' ";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    }
    
    if(strchangedAttribute == "ECSI_VSD_MOTOREN_2KJ8" || strchangedAttribute == "ECSI_GETRIEBETYP_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_RADIO_2KJ8" || strchangedAttribute == "ECSI_SPEZIFIKATION_CHECK_2KJ8" || strchangedAttribute == "ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8" || strchangedAttribute == "ECSI_POLZAHL_2KJ8" || strchangedAttribute == "ECSI_FREQUENZ_VORAUSWAHL_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
        var awhere = new Array();
        awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:SpecString});
        
        if(ECL_ValueSelected("ECSI_VSD_MOTOREN_2KJ8", "VSD_4000"))
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Ja"});
        else
            awhere.push({TMP_MOT_DATEN:"PRODUKT_VSD4000_TF",Value:"Nein"});
            
        if(ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8") == "IE1")
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:"-;IE1"});
        else
            awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL")});
            
        awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
        awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")});
        
        if(ECL_GetValue ("ECSI_GETRIEBETYP_2KJ8") == "Schneckengetriebe")
            awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"I"});
        else	
            awhere.push({TMP_MOT_DATEN:"MOT_BAUART_KEY",Value:"-"});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"ECSI_MOTORLEISTUNG_BIS_2KJ8",DB:"MOT_LEISTUNG"});
        ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
        
        var aDefaultSQL = "AND MOT_LEISTUNG='0.75' ";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    }
    
    if(strchangedAttribute=="ECSI_MOTORLEISTUNG_VON_2KJ8" || strchangedAttribute=="ECSI_MOTORLEISTUNG_BIS_2KJ8" || strchangedAttribute=="ECSI_ABTRIEBSDREHZAHL_VON_2KJ8" || strchangedAttribute=="ECSI_ABTRIEBSDREHZAHL_BIS_2KJ8" || strchangedAttribute=="ECSI_ABTRIEBSMOMENT_VON_2KJ8" || strchangedAttribute=="ECSI_ABTRIEBSMOMENT_BIS_2KJ8" || strchangedAttribute=="ECSI_BETRIEBSFAKTOR_VON_2KJ8" || strchangedAttribute=="ECSI_BETRIEBSFAKTOR_BIS_2KJ8")
    {
        ECL_SetValue ("ECSI_CFG_INIT_OPTIONS", "false");
    }
}

function getCHINA_Specification()
{

    var strDBName = "2KJ8_DB";
    var strDBResult = "SPECCHINA";
    var strChinaSpec = "";
    
    var aChinaSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_CEL FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC"))
        strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA"))
        strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strChinaSpec = dbgetstring(strDBResult,'MOTELAUSF_CEL');
            
            aChinaSpec.push([strChinaSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox China Spec! SQL="+strSelect);
    }
    
    return aChinaSpec;
}

function getEAC_Specification()
{

    var strDBName = "2KJ8_DB";
    var strDBResult = "SPECEAC";
    var strEACSpec = "";
    
    var aEACSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_EAC FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA"))
        strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA"))
        strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strEACSpec = dbgetstring(strDBResult,'MOTELAUSF_EAC');
            
            aEACSpec.push([strEACSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox EAC Spec! SQL="+strSelect);
    }
    
    return aEACSpec;
}

function getCSA_ULR_Specification()
{

    var strDBName = "2KJ8_DB";
    var strDBResult = "SPECCSA_ULR";
    var strULSpec = "";
    
    var aULSpec = [];
    
    var strSelect = "SELECT DISTINCT MOTELAUSF_UL FROM MOTELAUSF WHERE ";
    
    if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "CE")
        strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
    else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "EXPORT")
        strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
    
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA"))
        strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        
    if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC"))
        strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
    
    strSelect = strSelect + "AKTIV = '1' ";
    strSelect = strSelect + "AND M3 = '1' ";
    strSelect = strSelect + "AND MOTOR = '1' ";
    //strSelect = strSelect + "AND S09 = '0' ";
    
    strSelect = strSelect + "AND G110M = '0' ";
    
    strSelect = strSelect + "AND (REGION = 'S' OR REGION = 'SU') ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        while ( dbiseof( strDBResult) == 0 )
        {
            strULSpec = dbgetstring(strDBResult,'MOTELAUSF_UL');
            
            aULSpec.push([strULSpec]);
            dbskip( strDBResult );
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Checkbox CSA/UL-R Spec! SQL="+strSelect);
    }
    
    return aULSpec;
}

function setSpecificationCheckboxes()
{
    var aCHINASpec = getCHINA_Specification();
    var aEACSpec= getEAC_Specification();
    var aCSA_UL_RSpec = getCSA_ULR_Specification();

    if(aCHINASpec.length == 2 && (aCHINASpec[0][0] == "CHINA" || aCHINASpec[1][0] == "CHINA") && (aCHINASpec[0][0] == "-" || aCHINASpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA");
    }
    else if(aCHINASpec.length == 1 && aCHINASpec[0][0] == "CHINA" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA");
    }
    else if(aCHINASpec.length == 1 && aCHINASpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA");
    }
    else 
    {
        ECL_DeselectValue ("SPEZIFIKATION_CHECK_2KJ8", "CHINA");
        ECL_DisableValue ("SPEZIFIKATION_CHECK_2KJ8", "CHINA");
    }
    
    if(aEACSpec.length == 2 && (aEACSpec[0][0] == "EAC" || aEACSpec[1][0] == "EAC") && (aEACSpec[0][0] == "-" || aEACSpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
    }
    else if(aEACSpec.length == 1 && aEACSpec[0][0] == "EAC" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
    }
    else if(aEACSpec.length == 1 && aEACSpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
    }
    else 
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC");
    }
    
    if(aCSA_UL_RSpec.length == 2 && (aCSA_UL_RSpec[0][0] == "UL-R/CSA" || aCSA_UL_RSpec[1][0] == "UL-R/CSA") && (aCSA_UL_RSpec[0][0] == "-" || aCSA_UL_RSpec[1][0] == "-") )
    {
        ECL_EnableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
    }
    else if(aCSA_UL_RSpec.length == 1 && aCSA_UL_RSpec[0][0] == "ULR_CSA" )
    {
        ECL_SelectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
    }
    else if(aCSA_UL_RSpec.length == 1 && aCSA_UL_RSpec[0][0] == "-" )
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
    }
    else 
    {
        ECL_DeselectValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
        ECL_DisableValue ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA");
    }
}

function createSpecString(oData)
{
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "EASYKAT_CONFIG")
    {
        var strDBName = "2KJ8_DB";
        var strDBResult = "SPECSTRING";
        
        var strSpec="";
        
        var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";
        
        if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "CE")
            strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
        else if(ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8") == "EXPORT")
            strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
            
        if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "EAC"))
            strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_EAC = '-' AND ";
        
        
        if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "CHINA"))
            strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_CEL = '-' AND ";
        
        
        if(ECL_ValueSelected ("ECSI_SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA"))
            strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_UL = '-' AND ";
        
        strSelect = strSelect + "AKTIV = '1' AND ";
        strSelect = strSelect + "M3 = '1' AND ";
        strSelect = strSelect + "MOTOR = '1' AND ";
        //strSelect = strSelect + "S09 = '0' AND ";
        
        strSelect = strSelect + "G110M = '0' AND ";
        
        
        strSelect = strSelect + "(REGION = 'S' OR REGION = 'SU') ";
        
        
        if ( dbselect( strDBName, strSelect, strDBResult ) == 1 )
        {
            strSpec = dbgetstring(strDBResult,'MOTELAUSF');
            //logtraceln("Specification String="+strSpec);
        }
        else
        {
            logtraceln("Fehler Bestimmung Spezifikation String! SQL="+strSelect);
        }
        
        return strSpec;
    }
    else
    {
        var strDBName = "2KJ8_DB";
        var strDBResult = "SPECSTRING";
        
        var strSpec="";
        
        var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";
        if(ECL_GetValue("SPEZIFIKATION_CE_EXPORT_2KJ8") == "CE")
            strSelect = strSelect + "MOTELAUSF_CE = 'CE' AND ";
        else if(ECL_GetValue("SPEZIFIKATION_CE_EXPORT_2KJ8") == "EXPORT")
            strSelect = strSelect + "MOTELAUSF_EXP = 'EXPORT' AND ";
            
        if(ECL_ValueSelected ("SPEZIFIKATION_EAC_2KJ8", "T"))
            strSelect = strSelect + "MOTELAUSF_EAC = 'EAC' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_EAC = '-' AND ";
        
        
        if(ECL_ValueSelected ("SPEZIFIKATION_CHINA_2KJ8", "T"))
            strSelect = strSelect + "MOTELAUSF_CEL = 'CHINA' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_CEL = '-' AND ";
        
        
        if(ECL_ValueSelected ("SPEZIFIKATION_ULR_CSA_2KJ8", "T"))
            strSelect = strSelect + "MOTELAUSF_UL = 'UL-R/CSA' AND ";
        else
            strSelect = strSelect + "MOTELAUSF_UL = '-' AND ";
        
        strSelect = strSelect + "AKTIV = '1' AND ";
        strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
        strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
        strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect + "MOTOR = '1' AND ";
        
        strSelect = strSelect + "G110M = '0' AND ";
        
        
        strSelect = strSelect + "(REGION = 'S' OR REGION = 'SU') ";
        
        
        if ( dbselect( strDBName, strSelect, strDBResult ) == 1 )
        {
            strSpec = dbgetstring(strDBResult,'MOTELAUSF');
            //logtraceln("Specification String="+strSpec);
        }
        else
        {
            logtraceln("Fehler Bestimmung Spezifikation String! SQL="+strSelect);
        }
        
        return strSpec;
    }
}
