//@legacy
//#mode(full-ecma)




function ExecFastVT_TF(db, table, attributesObj, whereObj) {
    logtraceln('ExecFastVT - begin');

    if(whereObj.length > 0)
    {
        var strInClause="";
        for(var i=0;i<whereObj.length;i++)
        {
            var strSQL="";
            for(var clause in whereObj[i])
            {
                if(clause != "Value")
                {
                    var aAttributeValues = ECL_GetAllActiveAttributeValues (whereObj[i][clause]);
                    if(aAttributeValues.length > 0)
                    {
                        for(var j=0;j<aAttributeValues.length;j++)
                        {
                            strSQL = strSQL+",'"+aAttributeValues[j]+"'";
                        }
                        strSQL = trimleft(strSQL,",");
                        strSQL = " AND "+whereObj[i][clause]+" IN ("+strSQL+") ";
                    }
                }
                else
                {
                    if(whereObj[i][clause] != "")
                        strSQL = "";
                }
            }
            strInClause = strInClause + strSQL
        }
    }
    
    strInClause = trimleft(strInClause," AND ");
    
    var attributeSQL = "";
    var selectedAttributes = {};
    var sqlWhere = "";
    for (var i=0; i<attributesObj.length; i++) 
    {
        selectedAttributes[attributesObj[i]["IDENT"]] = {value: ECL_GetValue(attributesObj[i]["IDENT"])};
        ECL_DeactivateAllAttributeValues(attributesObj[i]["IDENT"]);
        
        
        if(ECL_GetValue(attributesObj[i]["IDENT"]) != "" && ECL_GetValue(attributesObj[i]["IDENT"]) != undefined)
            sqlWhere = sqlWhere + " AND " + attributesObj[i]["DB"]+"='"+ECL_GetValue(attributesObj[i]["IDENT"])+"'";
        
        
        attributeSQL = attributeSQL+","+attributesObj[i]["DB"];
    }
    sqlWhere = trimleft(sqlWhere," AND ");
    attributeSQL=trimleft(attributeSQL, ",");

    if(whereObj.length > 0)
    {
        for(var i=0;i<whereObj.length;i++)
        {
            var strSQL=" AND ";
            for(var clause in whereObj[i])
            {
                if(clause == "Value")
                {
                    strSQL = strSQL +"'"+ whereObj[i][clause]+"'";
                }
                else
                    strSQL = strSQL + clause+"."+whereObj[i][clause]+"=";
                
                if(find(table,clause) < 0 && clause != "Value")
                {
                    table = table +","+clause;
                }
            }
            
            if(whereObj[i][clause] == "")
                strSQL = "";
            else
            {
                strSQL = trimright(strSQL,"=");
            }
            sqlWhere = sqlWhere + strSQL
        }
        sqlWhere = trimleft(sqlWhere," AND ");
    }
    
    if (sqlWhere != "" && strInClause != "")
        sqlWhere = " WHERE " +sqlWhere+ " AND "+strInClause;
    else if (sqlWhere == "" && strInClause != "")
        sqlWhere = " WHERE "+strInClause;
    else if (sqlWhere != "" && strInClause == "")
        sqlWhere = " WHERE "+sqlWhere;
    
    var sqlSelect = 'SELECT DISTINCT '+attributeSQL;
    var sqlFrom = 'FROM '+table;
    var sql = [sqlSelect, sqlFrom, sqlWhere].join(' ');
    logtraceln("SQL="+sql);
    
    var result = new DBRecSet(db, sql);
    logtraceln("ResultSets="+result.getNumRecs());
    
    var aFieldNr=[];
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "IDENT")
            {
                aFieldNr.push(result.getFieldNr(attributesObj[i][clause]));
            }
        }
    }

    while(result.ok())
    {
        for (var i=0; i<attributesObj.length; i++) 
        {
            for(var clause in attributesObj[i])
            {
                if(clause != "DB")
                {
                    ECL_ActivateValue(attributesObj[i][clause], result.getStringFromIdx(aFieldNr[i]));
                }
            }
        }
        
        result.fetchNext();
    }
    
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "DB")
            {
                if(selectedAttributes[attributesObj[i][clause]].value != "" && selectedAttributes[attributesObj[i][clause]].value != undefined)
                {
                    ECL_SelectValue(attributesObj[i][clause], selectedAttributes[attributesObj[i][clause]].value);
                }
            }			
        }
    }
    logtraceln('ExecFastVT - end');
}

function ExecSQL_Standard(db, table, attributesObj, whereObj) 
{
    vtTimeStart	= Date.getTime();
    var attributeSQL = "";
    var selectedAttributes = {};
    var sqlWhere = "";
    for (var i=0; i<attributesObj.length; i++) 
    {
        ECL_DeactivateAllAttributeValues(attributesObj[i]["IDENT"]);
        attributeSQL = attributeSQL+","+attributesObj[i]["DB"];
    }
    attributeSQL=trimleft(attributeSQL, ",");

    if(whereObj.length > 0)
    {
        var strSQL="";
        for(var i=0;i<whereObj.length;i++)
        {
            var btest=false;
            for(var clause in whereObj[i])
            {
                if(clause == "Value")
                {
                    btest=true;
                    if(find(whereObj[i][clause],";") > -1)
                    {
                        var strMultiSQL=whereObj[i][clause];
                        var aMultiSQL = strMultiSQL.split(";");
                        strSQL=strSQL+" (";
                        for(var j=0;j<aMultiSQL.length;j++)
                        {
                            strSQL=strSQL+"'"+aMultiSQL[j]+"',";
                        }
                        strSQL=trimright(strSQL,",");
                        strSQL=strSQL+")";
                    }
                    else
                        strSQL = strSQL +"'"+ whereObj[i][clause]+"'";
                }
                else
                {
                    if(btest)
                    {
                        if(find(whereObj[i]["Value"],";") > -1)
                        {
                            strSQL = clause+"."+whereObj[i][clause]+" IN "+strSQL;
                        }
                        else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                        {
                            strSQL = whereObj[i][clause]+">="+strSQL;
                        }
                        else
                        {
                            strSQL = clause+"."+whereObj[i][clause]+"="+strSQL;
                        }
                    }
                    else
                    {
                        if(find(whereObj[i]["Value"],";") > -1)
                        {
                            strSQL = strSQL + clause+"."+whereObj[i][clause]+" IN ";
                        }
                        else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                        {
                            strSQL = whereObj[i][clause]+">="+strSQL;
                        }
                        else
                        {
                            strSQL = strSQL + clause+"."+whereObj[i][clause]+"=";
                        }
                    }
                }
                
                if(find(table,clause) < 0 && clause != "Value")
                {
                    table = table +","+clause;
                }
            }
            strSQL = strSQL +" AND ";
            
            if(whereObj[i][clause] == "")
                strSQL = "";
            else
            {
                strSQL = trimright(strSQL,"=");
            }
            sqlWhere = sqlWhere + strSQL;
            strSQL = "";
        }
        sqlWhere = trimright(sqlWhere," AND ");
    }
    
    sqlWhere = " WHERE "+sqlWhere;
    
    var sqlSelect = 'SELECT DISTINCT '+attributeSQL;
    var sqlFrom = 'FROM '+table;
    var sql = [sqlSelect, sqlFrom, sqlWhere].join(' ');
    
    sql = sql + " ORDER BY ("+attributesObj[0]["DB"]+") ASC";
    
    logtraceln("SQL="+sql);
    
    var result = new DBRecSet(db, sql);
    logtraceln("ResultSets="+result.getNumRecs());
    
    var aFieldNr=[];
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "IDENT")
            {
                aFieldNr.push(result.getFieldNr(attributesObj[i][clause]));
            }
        }
    }
    
    while(result.ok())
    {
        for (var i=0; i<attributesObj.length; i++) 
        {
            for(var clause in attributesObj[i])
            {
                if(clause != "DB")
                {
                    ECL_ActivateValue(attributesObj[i][clause], replace(result.getStringFromIdx(aFieldNr[i]),'"',''));
                }
            }
        }

        result.fetchNext();
    }
    
    /*
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "DB")
            {
                if(selectedAttributes[attributesObj[i][clause]].value != "" && selectedAttributes[attributesObj[i][clause]].value != undefined)
                {
                    ECL_SelectValue(attributesObj[i][clause], selectedAttributes[attributesObj[i][clause]].value);
                }
            }			
        }
    }
    */
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");
}

function ExecSQL_GetDefaultStandard(db, table, attributesObj, whereObj, strDefaultSQL) 
{
    vtTimeStart	= Date.getTime();
    var aAttributeValues = ECL_GetAllActiveAttributeValues (attributesObj[0]["IDENT"]);
    if(aAttributeValues.length > 0)
    {
        var strSelectedValue = ECL_GetValue (attributesObj[0]["IDENT"]);
        
        for(var i=0;i<aAttributeValues.length;i++)
        {	
            if(strSelectedValue == aAttributeValues[i])
                return true;
        }
        
        var attributeSQL = "";
        var sqlWhere = "";
        
        if(strDefaultSQL != "")
        {
            attributeSQL = attributeSQL+","+attributesObj[0]["DB"];
            attributeSQL=trimleft(attributeSQL, ",");
                        
            if(whereObj.length > 0)
            {
                var strSQL="";
                for(var i=0;i<whereObj.length;i++)
                {
                    var btest=false;
                    for(var clause in whereObj[i])
                    {
                        if(clause == "Value")
                        {
                            btest=true;
                            if(find(whereObj[i][clause],";") > -1)
                            {
                                var strMultiSQL=whereObj[i][clause];
                                var aMultiSQL = strMultiSQL.split(";");
                                strSQL=strSQL+" (";
                                for(var j=0;j<aMultiSQL.length;j++)
                                {
                                    strSQL=strSQL+"'"+aMultiSQL[j]+"',";
                                }
                                strSQL=trimright(strSQL,",");
                                strSQL=strSQL+")";
                            }
                            else
                                strSQL = strSQL +"'"+ whereObj[i][clause]+"'";
                        }
                        else
                        {
                            if(btest)
                            {
                                if(find(whereObj[i]["Value"],";") > -1)
                                {
                                    strSQL = clause+"."+whereObj[i][clause]+" IN "+strSQL;
                                }
                                else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                                {
                                    strSQL = whereObj[i][clause]+">="+strSQL;
                                }
                                else
                                {
                                    strSQL = clause+"."+whereObj[i][clause]+"="+strSQL;
                                }
                            }
                            else
                            {
                                if(find(whereObj[i]["Value"],";") > -1)
                                {
                                    strSQL = strSQL + clause+"."+whereObj[i][clause]+" IN ";
                                }
                                else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                                {
                                    strSQL = whereObj[i][clause]+">="+strSQL;
                                }
                                else
                                {
                                    strSQL = strSQL + clause+"."+whereObj[i][clause]+"=";
                                }
                            }
                        }
                        
                        if(find(table,clause) < 0 && clause != "Value")
                        {
                            table = table +","+clause;
                        }
                    }
                    strSQL = strSQL +" AND ";
                    
                    if(whereObj[i][clause] == "")
                        strSQL = "";
                    else
                    {
                        strSQL = trimright(strSQL,"=");
                    }
                    sqlWhere = sqlWhere + strSQL;
                    strSQL = "";
                }
                sqlWhere = trimright(sqlWhere," AND ");
            }
            
            sqlWhere = " WHERE "+sqlWhere+" "+strDefaultSQL;
            
            var sqlSelect = 'SELECT DISTINCT '+attributeSQL;
            var sqlFrom = 'FROM '+table;
            var sql = [sqlSelect, sqlFrom, sqlWhere].join(' ');
            logtraceln("Default SQL="+sql);
            
            var result = new DBRecSet(db, sql);
            logtraceln("ResultSets="+result.getNumRecs());
            
            vtTimeStop	= Date.getTime();
            vtTime		= (vtTimeStop - vtTimeStart) / 1000;
            logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");
            
            if(result.getNumRecs() > 0)
            {
                var strDefault = replace(result.getStringFromIdx(0),'"','');
                ECL_SelectValue(attributesObj[0]["IDENT"], strDefault);
            }
            else
            {
                ECL_SelectValue(attributesObj[0]["IDENT"], replace(aAttributeValues[0],'"',''));
            }
        }
        else
        {
            ECL_SelectValue(attributesObj[0]["IDENT"], replace(aAttributeValues[0],'"',''));
        }
    
    }
}

function ExecSQL_GetDefaultStandard_Bremse_Steuerspannung(db, ident, aDefaultAttribute, strSelect, aDefaultSQL) 
{
    vtTimeStart	= Date.getTime();
    var aAttributeValues = ECL_GetAllActiveAttributeValues (ident);
    if(aAttributeValues.length > 0)
    {
        var strSelectedValue = ECL_GetValue (ident);
        
        for(var i=0;i<aAttributeValues.length;i++)
        {	
            if(strSelectedValue == aAttributeValues[i])
                return true;
        }
        
        var sql = strSelect+" "+aDefaultSQL;
        logtraceln("Default SQL="+sql);
        
        var result = new DBRecSet(db, sql);
        logtraceln("ResultSets="+result.getNumRecs());
        
        if(result.getNumRecs() > 0)
        {
            var FieldIdx = result.getFieldNr(aDefaultAttribute[0]);
            var FieldIdx2 = result.getFieldNr(aDefaultAttribute[1]);
            
            var strDefault = parseInt(result.getStringFromIdx(FieldIdx));
            var strDefault2 = parseInt(result.getStringFromIdx(FieldIdx2));
            
            strDefault = strDefault+"-"+strDefault2;
            
            vtTimeStop	= Date.getTime();
            vtTime		= (vtTimeStop - vtTimeStart) / 1000;
            logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");
    
            if(ECL_ValueActive(ident, strDefault))
            {
                ECL_SelectValue(ident, strDefault);
                return true;
            }
            else
            {
                ECL_SelectValue(ident, aAttributeValues[0]);
                return false;
            }
        }
        else
        {
            ECL_SelectValue(ident, aAttributeValues[0]);
            return false;
        }
    }
}

function ExecSQL_GetDefaultStandard_Bremse(db, ident, aDefaultAttribute, strSelect, aDefaultSQL) 
{
    vtTimeStart	= Date.getTime();
    var aAttributeValues = ECL_GetAllActiveAttributeValues (ident);
    if(aAttributeValues.length > 0)
    {
        var strSelectedValue = ECL_GetValue (ident);
        
        for(var i=0;i<aAttributeValues.length;i++)
        {	
            if(strSelectedValue == aAttributeValues[i])
                return true;
        }
        
        var sql = strSelect+" "+aDefaultSQL;
        logtraceln("Default SQL="+sql);
        
        var result = new DBRecSet(db, sql);
        logtraceln("ResultSets="+result.getNumRecs());
        
        if(result.getNumRecs() > 0)
        {
            var FieldIdx = result.getFieldNr(aDefaultAttribute[0]);
            
            var strDefault = parseInt(result.getStringFromIdx(FieldIdx));
            
            vtTimeStop	= Date.getTime();
            vtTime		= (vtTimeStop - vtTimeStart) / 1000;
            logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");
    
            if(ECL_ValueActive(ident, strDefault))
            {
                ECL_SelectValue(ident, strDefault);
                return true;
            }
            else
            {
                ECL_SelectValue(ident, aAttributeValues[0]);
                return false;
            }
        }
        else
        {
            ECL_SelectValue(ident, aAttributeValues[0]);
            return false;
        }
    }
}

function isnewDefaultnecessary(Attribute)
{
    //falls true, muss ein neuer Defaukt Wert bestimmt werden
    var strValue = ECL_GetValue(Attribute);
    if(strValue == "")
    {
        //zur Zeit ist kein Wert eingestellt
        return true;
    }
    else
    {
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0)
        {
            for(var i=0;i<aselection.length;i++)
            {	
                if(strValue == aselection[i])
                {
                    //Wert der zur Zeit eingestellt ist, ist noch auswählbar
                    return false;
                }
            }
        }
        
        //Ansonsten muss ein neuer Default-Wert gesetzt werden
        return true;
    }
}

function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
    var strValue = ECL_GetValue(Attribute);
    if(strValue == "")
    {
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0 )
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }
    else
    {
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0)
        {
            for(var i=0;i<aselection.length;i++)
            {	
                if(strValue == aselection[i])
                    return true;
            }
        }
        
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0)
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
        
    }
}

function ExecSQL_Standard_SO(db, sql)
{
    vtTimeStart	= Date.getTime();
    var aResult = Object.fromDatabase( db, sql );
    logtraceln("SQL="+sql);
    logtraceln("ResultSets="+aResult.length);
    
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");
    
    return aResult;
}