//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

    
function Bestimme_Einbaulage(oData)
{
    ExecSetStandardifValueEmpty("BAUFORM_2KJ8",ECL_GetValue ("BAUFORM_2KJ8"));
    
    var awhere = new Array();
    awhere.push({EGPOS:"EGBEZTYP",Value:oData.oRow.EGBEZTYP});
    awhere.push({EGPOS:"EGBEZBRA",Value:oData.oRow.EGBEZBRA});
    awhere.push({EGPOS:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({EGPOS:"MOTOX_N",Value:"0"});	
    awhere.push({EGPOS:"CDROM_REL",Value:"1"});	
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ECSI_BAUFORM_EGPOS_2KJ8",DB:"EGPOS"});
    ExecSQL_Standard("2KJ8_DB", "EGPOS", aAttributes, awhere);
    
    var strDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "EGPOS", aAttributes, awhere, strDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("BAUFORM_2KJ8");
        ECL_DeactivateAttribute ("BAUFORM_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("BAUFORM_2KJ8");
        ECL_ActivateAttribute ("BAUFORM_2KJ8");
    }
}

function checkBAUFORM()
{
    var aEGPOS = ECL_GetAllActiveAttributeValues ("ECSI_BAUFORM_EGPOS_2KJ8");
    var strBAUFORM=ECL_GetValue ("BAUFORM_2KJ8");
    bfound=false;
    
    for(var i=0;i<aEGPOS.length;i++)
    {
        var strEGPOS=left(aEGPOS[i],2);
        if(strBAUFORM==strEGPOS)
            bfound=true;
    }
    
    return bfound;
}

function Bestimme_Abtriebsseite(oData)
{
    var awhere = new Array();
    awhere.push({EGPOSHL:"EGPOS",Value:ECL_GetValue("ECSI_BAUFORM_EGPOS_2KJ8")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"ABTRIEBSSEITE_2KJ8",DB:"EGABAWS"});
    ExecSQL_Standard("2KJ8_DB", "EGPOSHL", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "EGPOSHL", aAttributes, awhere, aDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("ABTRIEBSSEITE_2KJ8");
        ECL_DeactivateAttribute ("ABTRIEBSSEITE_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("ABTRIEBSSEITE_2KJ8");
        ECL_ActivateAttribute ("ABTRIEBSSEITE_2KJ8");
    }
}

function Bestimme_zulaessigeEinbaulagenabweichung(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ8", "T"))
    {
        ECL_DeselectValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T");
        ECL_DisableAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
        ECL_DeactivateAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
    }
    else
    {
        var strabwEinbaulage;
        
        var strSelect = "SELECT DISTINCT EGTYP.ZUL_EINBAULAGE_ABW FROM EGTYP WHERE ";
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
        strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
        strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
        strSelect = strSelect + "MOTOX_N='0' AND ";
        strSelect = strSelect + "EGTYP.S09 = '"+oData.oRow.S09+"' AND ";
        
        //Abfrage EGANSSART
        var strEGANSSART="BK4";
        if(oData.oRow.EGBEZDIM=="19")
            strEGANSSART="Z19";
        else if(oData.oRow.EGBEZTYP=="S")
            strEGANSSART="S09";
        
        strSelect = strSelect + "EGANSSART = '"+strEGANSSART+"' AND ";
        
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW = '1' AND ";
        strSelect = strSelect + "REGION IN ('S','SAU','SAC','SACU','SA','SACUM','SAM','SAUM') AND ";
        strSelect = strSelect + "CDROM_REL = '1' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if(aResult.length>0)
        {
            //Zusätzlich die beiden Tabellen EHHEHOLK_M3 und EGGEHOLA_M3 abfragen, da hier weitere Abhängigkeiten existieren.
            var strSelect = "SELECT DISTINCT EGGEHOLK FROM EGGEHOLK_M3 WHERE ";
            strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
            strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
            strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
            strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
            strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGBEZBEF='ALL') AND ";
            strSelect = strSelect + "(ANWTYP='"+oData.oRow.ANWTYP+"' OR ANWTYP='ALL') AND ";
            strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') AND ";
            strSelect = strSelect + "EINZELGETR = '1' AND ";
            strSelect = strSelect + "SONDER = '-' AND ";
            strSelect = strSelect + "REGION = 'S' AND ";
            strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";

            if(strG115_Type=="MM")
                strSelect = strSelect + "G115M = '1' AND ";
            
            else if(strG115_Type=="WM")
                strSelect = strSelect + "G115D = '1' AND ";
        
        
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
                strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
        
                if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
                {
                    strSelect = strSelect + "AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
                }
            }
            
            var aResult2 = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
            
            var strSelect = "SELECT DISTINCT EGGEHOLA FROM EGGEHOLA_M3 WHERE ";
            strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
            strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
            strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
            strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
            strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
            strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') AND ";
            strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' OR EGABAWS='ALL') AND ";
            strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
            strSelect = strSelect + "CDROM_REL='1' AND ";
       
            if(strG115_Type=="MM")
                 strSelect = strSelect + "G115M = '1' AND ";
            
            else if(strG115_Type=="WM")
                strSelect = strSelect + "G115D = '1' AND ";
            
            strSelect = strSelect + "EINZELGETR = '1' AND ";
            strSelect = strSelect + "SONDER='-' AND ";
            strSelect = strSelect + "REGION IN ('S','SC') AND ";
            
            if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
                strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
        
                if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
                {
                    strSelect = strSelect + "AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
                }
            }
                

            var aResult3 = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
            
            if(aResult2.length>0 && aResult3.length>0)
            {
                ECL_ActivateAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
                ECL_EnableValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8","T");
                ECL_EnableAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
            }
            else
            {
                ECL_DeselectValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T");
                ECL_DisableAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
                ECL_DeactivateAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
            }
        }
        else
        {
            ECL_DeselectValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T");
            ECL_DisableAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
            ECL_DeactivateAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8");
        }
    }
}

function Bestimme_zulEinbaulagenabweichungWinkel(oData)
{
	var strWinkel="";
	var strXAchse="";
	var strYAchse="";
	
	var strSelect = "";
	strSelect = "SELECT DISTINCT WINKEL_ANZ,X_ACHSE,Y_ACHSE FROM EGPOSWINKZUL_ZEABW WHERE ";
	strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' AND ";
	strSelect = strSelect + "REGION='S' ";
	
	ECL_DeactivateAllAttributeValues("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8");
	ECL_ActivateAttribute("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8");
	
	var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

	if(aResult.length>0)
	{
		for(var i=0;i<aResult.length;i++)
		{
			strWinkel = aResult[i].WINKEL_ANZ;
			strXAchse = aResult[i].X_ACHSE;
			strYAchse = aResult[i].Y_ACHSE;
			
			if(strWinkel.left(5)=="+/-20" && strXAchse=="1")
			{
				ECL_ActivateValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8", "X_20");
			}
			else if(strWinkel.left(5)=="+/-20" && strYAchse=="1")
			{
				ECL_ActivateValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8", "Y_20");
			}
			else if(strWinkel.left(5)=="+20-0" && strYAchse=="1")
			{
				ECL_ActivateValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8", "Y_20-0");
			}
		}
	}
	
	if(oData.oRow.EGBEZTYP=="-")
		ExecSetStandardifValueEmpty("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8", "X_20");
	else
		ExecSetStandardifValueEmpty("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8", "Y_20");
}

function isSonderEinbaulagePossible(oData)
{
    //Vorerst deaktiviert
    /*
    ECL_DeselectValue("SONDEREINBAULAGE_OPTION_2KJ8", "T");
    ECL_DisableAttribute("SONDEREINBAULAGE_OPTION_2KJ8");
    ECL_DeactivateAttribute("SONDEREINBAULAGE_OPTION_2KJ8");
    
    return;
    */
	if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T") || oData.oRow.EGBEZTYP=="S" || oData.oRow.EGBEZBRA=="H") 
    {
        ECL_DeselectValue("SONDEREINBAULAGE_OPTION_2KJ8", "T");
        ECL_DisableAttribute("SONDEREINBAULAGE_OPTION_2KJ8");
        ECL_DeactivateAttribute("SONDEREINBAULAGE_OPTION_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("SONDEREINBAULAGE_OPTION_2KJ8");
        ECL_EnableValue("SONDEREINBAULAGE_OPTION_2KJ8","T");
        ECL_EnableAttribute("SONDEREINBAULAGE_OPTION_2KJ8");	
    }
    
}

function BestimmeDrehachsen_SE(oData)
{
    var strSelect = "SELECT X_ACHSE,Y_ACHSE,Z_ACHSE FROM EGPOSWINKZUL_M3_ACHSEN WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    ECL_DeactivateAllAttributeValues("SE_ACHSE_WAHL_2KJ8");
    if(aResult.length==1)
    {
        if(aResult[0].X_ACHSE=="1")
            ECL_ActivateValue("SE_ACHSE_WAHL_2KJ8","X");
        
        if(aResult[0].Y_ACHSE=="1")
            ECL_ActivateValue("SE_ACHSE_WAHL_2KJ8","Y");
        
        if(aResult[0].Z_ACHSE=="1")
            ECL_ActivateValue("SE_ACHSE_WAHL_2KJ8","Z");
    }
    else
        logtraceln ("Fehler beim Bestimmen der Drehachsen bei Sondereinbaulage!; SQL="+strSelect);
    
    
    ExecSetStandardifValueEmpty("SE_ACHSE_WAHL_2KJ8", "X");		
}

function BestimmeZielPosition_SE(oData)
{
    var strGetriebetyp = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS;
    strGetriebetyp = replace(strGetriebetyp, "-", "");
    strGetriebetyp = left(strGetriebetyp,1);
    
    var strSelect="SELECT BILD FROM BILDER_SONDEREINBAULAGEN_NEW WHERE Getriebetyp='"+strGetriebetyp+"' AND Rotationsachse = '"+ECL_GetValue("SE_ACHSE_WAHL_2KJ8")+"'  AND 	EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("SE_ZIELPOSITION_2KJ8");
    if(aResult.length==1)
    {
        ECL_ActivateValue("SE_ZIELPOSITION_2KJ8",aResult[0].BILD);
        var strImage="2KJ8\\%LANG%\\getriebeoptionen\\Einbaulagen\\"+aResult[0].BILD+".png";
        ECL_SetValueImage ("SE_ZIELPOSITION_2KJ8", aResult[0].BILD, strImage);
    }
    else
    {
        logtraceln("Fehler beim Bestimmen der Zielposition bei Sondereinbaulagen!; SQL="+strSelect);
    }
    
    ExecSetStandardifValueEmpty("SE_ZIELPOSITION_2KJ8", "leer");		
}


function BestimmeRotationswinkel_SE(oData)
{
    var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION_2KJ8"),4);

    var strEGPOS_Start = left(strDrehung,2);
    var strEGPOS_Ziel = right(strDrehung,2);
    
    var strConfig_Abtriebsseite=ECL_GetValue("ABTRIEBSSEITE_2KJ8");
    if(strConfig_Abtriebsseite!= "" && strConfig_Abtriebsseite!= "-")
    {
        strEGPOS_Start=strEGPOS_Start+"-"+strConfig_Abtriebsseite;
        strEGPOS_Ziel=strEGPOS_Ziel+"-"+strConfig_Abtriebsseite;
    }
    
    var strAchse=ECL_GetValue("SE_ACHSE_WAHL_2KJ8");
    
    var strTableName="EGPOS_SCHRAEGBAULAGEN_"+strAchse+"_ACHSE";
    var strColumnName=strAchse+"_ACHSE";
    
    var strSelect="SELECT DISTINCT "+strColumnName+" FROM "+strTableName+" WHERE ";
    strSelect = strSelect+"EGPOS_START='"+strEGPOS_Start+"' AND ";
    strSelect = strSelect+"EGPOS_ZIEL='"+strEGPOS_Ziel+"' AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "EGBEZDIM_MIN<="+oData.oRow.EGBEZDIM+" AND EGBEZDIM_MAX>="+oData.oRow.EGBEZDIM+" ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("SE_ROTATIONSWINKEL_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(strAchse=="X")
                ECL_ActivateValue("SE_ROTATIONSWINKEL_2KJ8","X_ACHSE_"+aResult[i].X_ACHSE);
            else if(strAchse=="Y")
                ECL_ActivateValue("SE_ROTATIONSWINKEL_2KJ8","Y_ACHSE_"+aResult[i].Y_ACHSE);
            else if(strAchse=="Z")
                ECL_ActivateValue("SE_ROTATIONSWINKEL_2KJ8","Z_ACHSE_"+aResult[i].Z_ACHSE);
        }
    }
    else
    {
        logtraceln("Fehler beim Bestimmen des Rotationswinkels bei Sondereinbaulagen!; SQL="+strSelect);
    }
    
    ExecSetStandardifValueEmpty("SE_ROTATIONSWINKEL_2KJ8", strColumnName+"_5");		
}

function checkEinbaulageContext(oDataGear, strCX_BAUFORM_EGPOS)
{
	var strSelect="";
	strSelect = "SELECT * FROM EGPOS WHERE EGPOS='"+strCX_BAUFORM_EGPOS+"' AND ";
	strSelect = strSelect + "EGBEZTYP='"+oDataGear.oRow.EGBEZTYP+"' AND ";
	strSelect = strSelect + "EGBEZBRA='"+oDataGear.oRow.EGBEZBRA+"' AND ";
	strSelect = strSelect + "ANWTYP='"+oDataGear.oRow.ANWTYP+"' AND ";
	strSelect = strSelect + "MOTOX_N='0' ";
	
	var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
	if(aResult.length>0){
		return true;
    }
	else{
		return false;
    }
}