//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

    
function Bestimme_Befestigungsart(oData)
{
    //Befestigungsart
    var awhere = new Array();
    awhere.push({EGTYP:"EGBEZTYP",Value:oData.oRow.EGBEZTYP});
    awhere.push({EGTYP:"EGBEZUEBS",Value:oData.oRow.EGBEZUEBS});
    awhere.push({EGTYP:"EGBEZDIM",Value:oData.oRow.EGBEZDIM});
    awhere.push({EGTYP:"EGBEZEI",Value:oData.oRow.EGBEZEI});
    awhere.push({EGTYP:"EGBEZBRA",Value:oData.oRow.EGBEZBRA});
    awhere.push({EGTYP:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({EGTYP:"EGBEZSO",Value:"-"});
    awhere.push({EGTYP:"MOTOX_N",Value:"0"});
    awhere.push({EGTYP:"S09",Value:oData.oRow.S09});
    
    //Abfrage EGANSSART
    var strEGANSSART="BK4";
    if(oData.oRow.EGBEZDIM=="19")
        strEGANSSART="Z19";
    else if(oData.oRow.EGBEZTYP=="S")
        strEGANSSART="S09";
        
    awhere.push({EGTYP:"EGANSSART",Value:strEGANSSART});
    
    /*
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
        awhere.push({EGTYP:"ZUL_EINBAULAGE_ABW",Value:"1"});
    else
        awhere.push({EGTYP:"ZUL_EINBAULAGE_ABW",Value:"0"});
    */
    
    awhere.push({EGTYP:"CDROM_REL",Value:"1"});
    awhere.push({EGTYP:"REGION",Value:"S;SAU;SAC;SACU;SA;SACUM;SAM;SAUM"});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"BEFESTIGUNGSART_2KJ8",DB:"EGBEZBEF"});
    ExecSQL_Standard("2KJ8_DB", "EGTYP", aAttributes, awhere);
    
    if(isnewDefaultnecessary("BEFESTIGUNGSART_2KJ8"))
    {		
        var aActiveValues = ECL_GetAllActiveAttributeValues("BEFESTIGUNGSART_2KJ8");
        if(aActiveValues.indexOf('-') > 0)
            ECL_SelectValue("BEFESTIGUNGSART_2KJ8", "-");
        else
            ECL_SelectValue("BEFESTIGUNGSART_2KJ8", aActiveValues[0]);
    
    }
    
    var aBefestigungsart=ECL_GetAllActiveAttributeValues("BEFESTIGUNGSART_2KJ8");
    var strEGBEZTYP=oData.oRow.EGBEZTYP;
    var strEGBEZUEBS=oData.oRow.EGBEZUEBS;
    
    var strImage="";
    for(var i=0;i<aBefestigungsart.length;i++)
    {
        if(aBefestigungsart[i]=="-")
        {
            if(strEGBEZTYP=="F")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_F_FA.png";
            else if(strEGBEZTYP=="B")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_B_FA.png";
            else
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_FA.png";
            
            ECL_SetValueImage ("BEFESTIGUNGSART_2KJ8", "-", strImage);
        }
        else if(aBefestigungsart[i]=="B")
        {
            if(strEGBEZTYP=="F")
                strImage="notavailable";
            else
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_FF.png";
                
            ECL_SetValueImage ("BEFESTIGUNGSART_2KJ8", "B", strImage);
        }
        else if(aBefestigungsart[i]=="D")
        {
            if(strEGBEZTYP=="F")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_F_DS.png";
            else
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_DS.png";
            
            ECL_SetValueImage ("BEFESTIGUNGSART_2KJ8", "D", strImage);
        }
        else if(aBefestigungsart[i]=="Z")
        {
            if(strEGBEZTYP=="F")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_F_GF.png";
            else if(strEGBEZTYP=="B")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_B_GF.png";
            else if(strEGBEZTYP=="K")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_K_GF.png";
            else
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_GF.png";
            
            ECL_SetValueImage ("BEFESTIGUNGSART_2KJ8", "Z", strImage);
        }
        else if(aBefestigungsart[i]=="F")
        {
            if(strEGBEZTYP=="F")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_F_FL.png";
            else if(strEGBEZTYP=="B")
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_B_FL.png";
            else
                strImage="2KJ8\\%LANG%\\getriebeoptionen\\befestigung\\BEF_FL.png";
                
            ECL_SetValueImage ("BEFESTIGUNGSART_2KJ8", "F", strImage);
        }
    }
}

function Bestimme_Befestigungsmass(oData)
{
    //Befestigungsmaß
    
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    if(ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "-" || ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "D")
    {
        ECL_DeactivateAllAttributeValues("BEFESTIGUNGSMASS_2KJ8");
        ECL_ActivateValue("BEFESTIGUNGSMASS_2KJ8","-");
        ECL_SelectValue("BEFESTIGUNGSMASS_2KJ8","-");
        ECL_DeactivateAttribute("BEFESTIGUNGSMASS_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("BEFESTIGUNGSMASS_2KJ8");
        var awhere = new Array();
        awhere.push({EGABFLD_M3:"EGBEZTYP",Value:oData.oRow.EGBEZTYP});
        awhere.push({EGABFLD_M3:"EGBEZUEBS",Value:oData.oRow.EGBEZUEBS});
        awhere.push({EGABFLD_M3:"EGBEZDIM",Value:oData.oRow.EGBEZDIM+";ALL"});
        awhere.push({EGABFLD_M3:"EGBEZEI",Value:oData.oRow.EGBEZEI});
        awhere.push({EGABFLD_M3:"EGBEZBRA",Value:oData.oRow.EGBEZBRA});
        awhere.push({EGABFLD_M3:"EGBEZBEF",Value:ECL_GetValue("BEFESTIGUNGSART_2KJ8")});
        awhere.push({EGABFLD_M3:"EGBEZWNV",Value:Verbindungsart});
        awhere.push({EGABFLD_M3:"CDROM_REL",Value:"1"});
        awhere.push({EGABFLD_M3:"EINZELGETR",Value:"1"});
            
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            awhere.push({EGABFLD_M3:"UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"BEFESTIGUNGSMASS_2KJ8",DB:"EGABFLDM"});
        ExecSQL_Standard("2KJ8_DB", "EGABFLD_M3", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "EGABFLD_M3", aAttributes, awhere, aDefaultSQL);
        
        //Deaktivieren falls nur "-" zur Auswahl
        var aSelections = ECL_GetAllActiveAttributeValues("BEFESTIGUNGSMASS_2KJ8");
        if(aSelections.length==1 && ECL_GetValue("BEFESTIGUNGSMASS_2KJ8")=="-")
        {
            ECL_DeactivateAllAttributeValues("BEFESTIGUNGSMASS_2KJ8");
            ECL_DeactivateAttribute("BEFESTIGUNGSMASS_2KJ8");
        }
    }
}

function Bestimme_Figur(oData)
{
    //Figur
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    if(ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "-")
    {
        ECL_DeactivateAllAttributeValues("FIGUR_2KJ8");
        ECL_ActivateValue("FIGUR_2KJ8","-");
        ECL_SelectValue("FIGUR_2KJ8","-");
        ECL_DeactivateAttribute("FIGUR_2KJ8");
    }
    else if(ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "D")
    {
        ECL_ActivateAttribute("FIGUR_2KJ8");
        var awhere = new Array();
        awhere.push({EGABDMST:"EGBEZTYP",Value:oData.oRow.EGBEZTYP+";ALL"});
        awhere.push({EGABDMST:"EGBEZDIM",Value:oData.oRow.EGBEZDIM+";ALL"});
        awhere.push({EGABDMST:"EGBEZEI",Value:oData.oRow.EGBEZEI+";ALL"});
        awhere.push({EGABDMST:"AKTIV",Value:"1"});
        awhere.push({EGABDMST:"EINZELGETR",Value:"1"});
        awhere.push({EGABDMST:"EGBEZAWTYP",Value:Abtriebswellentyp+";ALL"});
        awhere.push({EGABDMST:"EGBEZBEF",Value:ECL_GetValue("BEFESTIGUNGSART_2KJ8")+";ALL"});
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            awhere.push({EGABDMST:"UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"FIGUR_2KJ8",DB:"EGABDMSTFIG"});
        ExecSQL_Standard("2KJ8_DB", "EGABDMST", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "EGABDMST", aAttributes, awhere, aDefaultSQL);
    }
    else
    {
        ECL_ActivateAttribute("FIGUR_2KJ8");
        var awhere = new Array();
        awhere.push({EGABFLD_M3:"EGBEZTYP",Value:oData.oRow.EGBEZTYP});
        awhere.push({EGABFLD_M3:"EGBEZUEBS",Value:oData.oRow.EGBEZUEBS});
        awhere.push({EGABFLD_M3:"EGBEZDIM",Value:oData.oRow.EGBEZDIM});
        awhere.push({EGABFLD_M3:"EGBEZEI",Value:oData.oRow.EGBEZEI});
        awhere.push({EGABFLD_M3:"EGBEZBRA",Value:oData.oRow.EGBEZBRA});
        awhere.push({EGABFLD_M3:"EGBEZWNV",Value:Verbindungsart});
        awhere.push({EGABFLD_M3:"EGBEZBEF",Value:ECL_GetValue("BEFESTIGUNGSART_2KJ8")});
        awhere.push({EGABFLD_M3:"EGABFLDM",Value:ECL_GetValue("BEFESTIGUNGSMASS_2KJ8")});
        
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
            awhere.push({EGABFLD_M3:"UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
        
        var aAttributes = new Array();
        aAttributes.push({IDENT:"FIGUR_2KJ8",DB:"EGABFLFIG"});
        ExecSQL_Standard("2KJ8_DB", "EGABFLD_M3", aAttributes, awhere);
        
        var aDefaultSQL = "";
        ExecSQL_GetDefaultStandard("2KJ8_DB", "EGABFLD_M3", aAttributes, awhere, aDefaultSQL);
        
        //Deaktivieren falls nur "-" zur Auswahl
        var aSelections = ECL_GetAllActiveAttributeValues("FIGUR_2KJ8");
        if(aSelections.length==1 && ECL_GetValue("FIGUR_2KJ8")=="-")
        {
            ECL_DeactivateAllAttributeValues("FIGUR_2KJ8");
            ECL_DeactivateAttribute("FIGUR_2KJ8");
        }
    }
    
    //unsichtbar machen
    //Auswahl wird nicht benötigt
    ECL_DeactivateAttribute("FIGUR_2KJ8");
}

function Bestimme_Abtriebswellenart(oData)
{
    //Abtriebswellenart
    var strSelect = "SELECT DISTINCT EGABKDBEZ,EGABAUSF,WELLE_BDS,WELLE_O_PF,EGBEZAWTYP,EGBEZWNV,EGBEZSO,EGABW FROM EGTYP,EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGTYP.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGTYP.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGTYP.EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "EGTYP.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGTYP.ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "EGTYP.S09='"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "EGTYP.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' AND ";
    strSelect = strSelect + "EGTYP.CDROM_REL='1' AND ";
    strSelect = strSelect + "EGTYP.MOTOX_N='0' AND ";
    strSelect = strSelect + "EGTYP.AKTIV='1' AND ";
    
    //Abfrage EGANSSART
    var strEGANSSART="BK4";
    if(oData.oRow.EGBEZDIM=="19")
        strEGANSSART="Z19";
    else if(oData.oRow.EGBEZTYP=="S")
        strEGANSSART="S09";
    
    strSelect = strSelect + "EGTYP.EGANSSART = '"+strEGANSSART+"' AND ";
        
    /*
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
    else
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
    */	
    
    strSelect = strSelect + "EGTYP.REGION LIKE 'S%' AND ";
    strSelect = strSelect + "EGTYP.TYPBEZ=EGABKD_M3.EGTYP AND ";
    strSelect = strSelect + "EGABKD_M3.AKTIV='1' AND ";
    //strSelect = strSelect + "EGABKD_M3.WELLE_GROSS='0' AND ";
    //strSelect = strSelect + "EGABKD_M3.CDROM_REL='1' AND ";
    strSelect = strSelect + "EGABKD_M3.SONDER='-' AND ";
    strSelect = strSelect + "EGABKD_M3.EINZELGETR='1' AND ";
    strSelect = strSelect + "EGABKD_M3.G115='1' ";
    
    strSelect = strSelect + "AND EGTYP.TYPBEZ NOT IN (SELECT EG_TYPBEZ FROM KONFIG_UNDEF WHERE ";
    
    var strAdapter="-";
    strSelect = strSelect + "AV_TYPBEZ='"+strAdapter+"' AND ";
    strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "ATEX='0' AND ";
    strSelect = strSelect + "REGION IN ('S') AND ";
    strSelect = strSelect + "AKTIV='1') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENART_2KJ8");
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            var strWelle = aResult[i].EGABKDBEZ;
            strWelle = strWelle.replace(/[^a-zA-Z]/g, '');
            
            var strWelle_EGABAUSF = aResult[i].EGABAUSF;
            var strWelle_WELLE_BDS = aResult[i].WELLE_BDS;
            var strWelle_WELLE_O_PF = aResult[i].WELLE_O_PF;
            var strEGBEZAWTYP = aResult[i].EGBEZAWTYP;
            var strEGBEZWNV = aResult[i].EGBEZWNV;
            var strEGBEZSO = aResult[i].EGBEZSO;
            var strEGABW = aResult[i].EGABW;
            
            var bBDSWellePossible=true;
            
            if(strWelle_WELLE_BDS=="1")
            {
                //Bei 2 Wellenenden kommt noch die EGABKB_M3_2WE ins Spiel
                var strSelectBDS = "SELECT DISTINCT EGABKD_M3_2WE.EGABW FROM EGABKD_M3_2WE WHERE ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZTYP IN ('"+oData.oRow.EGBEZTYP+"','ALL')  AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZUEBS IN ('"+oData.oRow.EGBEZUEBS+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZBRA IN ('"+oData.oRow.EGBEZBRA+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZDIM IN ('"+oData.oRow.EGBEZDIM+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZBEF IN ('"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZAWTYP IN ('"+strEGBEZAWTYP+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZWNV IN ('"+strEGBEZWNV+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGBEZSO IN  ('"+strEGBEZSO+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EGABW IN ('"+strEGABW+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.WELLE_BDS IN ('1','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.MOTDIM_IEC IN ('"+oData.oRow.MOTDIM+"','ALL') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.REGION IN ('S') AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.AKTIV='1' AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.EINZELGETR='1' AND ";
                strSelectBDS = strSelectBDS + "EGABKD_M3_2WE.SONDER='-'";
                
                var aResultBDS = ExecSQL_Standard_SO("2KJ_DB", strSelectBDS);
                if(aResultBDS.length==0)
                    bBDSWellePossible=false;
            }
            
            if(strWelle=="H" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle");
            
            if(strWelle=="HF" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle_mit_SIMOLOC");
            
            if(strWelle=="HM" && strWelle_EGABAUSF=="VLplus" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle");
            
            if(strWelle=="HS" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle_mit_Schrumpfscheibe");
                
            if(strWelle=="HX" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle_Edelstahl");
                
            if(strWelle=="N" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Hohlwelle_mit_Vielkeilverzahnung");
                
            if(strWelle=="V" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_mit_Passfeder");
                
            if(strWelle=="VC" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_fuer_Kuehlturmantriebe");
                
            if(strWelle=="VD" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="0" && bBDSWellePossible)
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_beidseitig");
                
            if(strWelle=="VDG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="1" && strWelle_WELLE_O_PF=="1" && bBDSWellePossible)
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_beidseitig_ohne_Passfeder");
                
            if(strWelle=="VE" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Einsteckwelle");
            
            if(strWelle=="VG" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="1")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_ohne_Passfeder");
                
            if(strWelle=="VM" && (strWelle_EGABAUSF=="VLplus" || strWelle_EGABAUSF=="XLplus") && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART_2KJ8","Vollwelle_mit_Passfeder");
            
            /*
            if(strWelle=="W" && strWelle_EGABAUSF=="Standard" && strWelle_WELLE_BDS=="0" && strWelle_WELLE_O_PF=="0")
                ECL_ActivateValue("ABTRIEBSWELLENART","Welle_fuer_SIP");
            */
        }
        
         if(oData.oRow.EGBEZBRA=="K")
            ExecSetStandardifValueEmpty("ABTRIEBSWELLENART_2KJ8", "Vollwelle_fuer_Kuehlturmantriebe");
         else
            ExecSetStandardifValueEmpty("ABTRIEBSWELLENART_2KJ8", "Vollwelle_mit_Passfeder");
    }
    else
    {
        logtraceln("Fehler SQL Abtriebswellentyp,SQL="+strSelect);
    }
}

function Bestimme_Abtriebswellenmass(oData)
{
    //Abtriebswellenmass
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
        
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    
    var strWELLE_BDS = "0";
    if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder")
        strWELLE_BDS = "1";
    
    var strWELLE_O_PF = "0";
    if(strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder")
        strWELLE_O_PF = "1";
    
    var strSelect = "SELECT DISTINCT EGABW,EGABKDBEZ FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND ";
    strSelect = strSelect + "WELLE_BDS='"+strWELLE_BDS+"' AND ";
    strSelect = strSelect + "WELLE_O_PF='"+strWELLE_O_PF+"' AND ";
    strSelect = strSelect + "G115='1' AND ";
    strSelect = strSelect + "SONDER='-' ";
    //strSelect = strSelect + "WELLE_GROSS='0' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENMASS_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            var strWelle = aResult[i].EGABKDBEZ;
            strWelle = strWelle.replace(/[^A-Z]/g, '');
            
            if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Hohlwelle")
            {
                if(strWelle=="H" || strWelle=="HM")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Hohlwelle_mit_SIMOLOC")
            {
                if(strWelle=="HF")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Hohlwelle_mit_Schrumpfscheibe")
            {
                if(strWelle=="HS")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Hohlwelle_Edelstahl")
            {
                if(strWelle=="HX")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Hohlwelle_mit_Vielkeilverzahnung")
            {
                if(strWelle=="N")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Vollwelle_mit_Passfeder")
            {
                if(strWelle=="V" || strWelle=="VM")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Vollwelle_fuer_Kuehlturmantriebe")
            {
                if(strWelle=="VC")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Vollwelle_beidseitig")
            {
                if(strWelle=="VD")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Vollwelle_beidseitig_ohne_Passfeder")
            {
                if(strWelle=="VDG")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Einsteckwelle")
            {
                if(strWelle=="VE")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
            else if(ECL_GetValue("ABTRIEBSWELLENART_2KJ8")=="Vollwelle_ohne_Passfeder")
            {
                if(strWelle=="VG")
                    ECL_ActivateValue("ABTRIEBSWELLENMASS_2KJ8",replace(aResult[i].EGABW,'"','ZOLL'));
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung ABTRIEBSWELLENMASS! SQL="+strSelect);
    }	
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("ABTRIEBSWELLENMASS_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1'");
        if(aResultDefault.length>0)
        {
            var aActiveValues = ECL_GetAllActiveAttributeValues("ABTRIEBSWELLENMASS_2KJ8");
            for(var i=0;i<aResultDefault.length;i++)
            {
                if( aActiveValues.indexOf(aResultDefault[i].EGABW) > -1)
                    ECL_SelectValue("ABTRIEBSWELLENMASS_2KJ8", replace(aResultDefault[i].EGABW,'"','ZOLL'));
            }
            
        }
        else if(aResult.length>0)
        {
            var aActiveValues = ECL_GetAllActiveAttributeValues("ABTRIEBSWELLENMASS_2KJ8");
            
            
            if( find(aActiveValues[0],'ZOLL')>-1)
            {
                ECL_SelectValue("ABTRIEBSWELLENMASS_2KJ8", replace(aActiveValues[1],'"','ZOLL'));
            }
            else
            {
                ECL_SelectValue("ABTRIEBSWELLENMASS_2KJ8", replace(aActiveValues[0],'"','ZOLL'));
            }
        }
    }
}

function Bestimme_Hohlwellenabdeckung(oData)
{
    //Hohlwellenabdeckung
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strWELLE_BDS = "0";
    if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder")
        strWELLE_BDS = "1";
    
    var strWELLE_O_PF = "0";
    if(strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder")
        strWELLE_O_PF = "1";
    
    if(Abtriebswellentyp =="A")
    {
        ECL_ActivateAttribute("HOHLWELLENABDECKUNG_2KJ8");
        var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
        strEGTYP = replace(strEGTYP, "-", "");
        
        var awhere = new Array();
        awhere.push({EGABABDW_M3:"EGBEZTYP",Value:oData.oRow.EGBEZTYP+";ALL"});
        awhere.push({EGABABDW_M3:"EGBEZBEF",Value:ECL_GetValue("BEFESTIGUNGSART_2KJ8")});
        awhere.push({EGABABDW_M3:"EGBEZDIM",Value:oData.oRow.EGBEZDIM+";ALL"});
        awhere.push({EGABABDW_M3:"EGBEZBRA",Value:oData.oRow.EGBEZBRA+";ALL"});
        awhere.push({EGABABDW_M3:"EGBEZAWTYP",Value:Abtriebswellentyp+";ALL"});
        awhere.push({EGABABDW_M3:"EGBEZWNV",Value:Verbindungsart+";ALL"});
        awhere.push({EGABABDW_M3:"EGBEZEI",Value:oData.oRow.EGBEZEI});
        awhere.push({EGABABDW_M3:"EGBEZSO",Value:"-"+";ALL"});
        awhere.push({EGABABDW_M3:"SONDER",Value:"-"});
        awhere.push({EGABABDW_M3:"EINZELGETR",Value:"1"});
        awhere.push({EGABABDW_M3:"WELLE_BDS",Value:strWELLE_BDS+";ALL"});
    
        var aAttributes = new Array();
        aAttributes.push({IDENT:"HOHLWELLENABDECKUNG_2KJ8",DB:"EGABABDW"});
        ExecSQL_Standard("2KJ8_DB", "EGABABDW_M3", aAttributes, awhere);
        
        if(isnewDefaultnecessary("HOHLWELLENABDECKUNG_2KJ8"))
        {
            var aActiveValues = ECL_GetAllActiveAttributeValues("HOHLWELLENABDECKUNG_2KJ8");
            
            if(aActiveValues.length==1)
            {
                if(aActiveValues[0]=="ohne")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","ohne");
                else if(aActiveValues[0]=="Verschlusskappe")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","Verschlusskappe");
            }
            else if(aActiveValues.length==2)
            {
                if(aActiveValues[0]=="ohne")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","ohne");
                else if(aActiveValues[1]=="ohne")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","ohne");
                else if(aActiveValues[0]=="Verschlusskappe")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","Verschlusskappe");
                else if(aActiveValues[1]=="Verschlusskappe")
                    ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8","Verschlusskappe");
            }
            else
            {
                ExecSetStandardifValueEmpty("HOHLWELLENABDECKUNG_2KJ8",aActiveValues[0]);
            }
        }
    }
    else
    {
        ECL_DeactivateAllAttributeValues("HOHLWELLENABDECKUNG_2KJ8");
        ECL_ActivateValue("HOHLWELLENABDECKUNG_2KJ8","ohne");
        ECL_SelectValue("HOHLWELLENABDECKUNG_2KJ8","ohne");
        ECL_DeactivateAttribute("HOHLWELLENABDECKUNG_2KJ8");
    }
}


function Bestimme_Wasserablauf(oData)
{
    //Wasserablauf
    var strSelect = "SELECT DISTINCT * FROM EGFLAWALO WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' AND ";
    
    if( ECL_GetValue("ABTRIEBSSEITE") != "-")
        strSelect = strSelect + "EGPOS='"+ECL_GetValue("BAUFORM_2KJ8")+"-"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' AND ";
    else
        strSelect = strSelect + "EGPOS='"+ECL_GetValue("BAUFORM_2KJ8")+"' AND ";
        
    strSelect = strSelect + "EGABFLFIG='"+ECL_GetValue("FIGUR_2KJ8")+"' AND ";
    strSelect = strSelect + "EGABFLDM='"+ECL_GetValue("BEFESTIGUNGSMASS_2KJ8")+"' ";
    
    var aAttributes = new Array();
    aAttributes.push("*");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    if ( aResult.length > 0 )
    {
        ECL_ActivateAttribute("WASSERABLAUF_OPTION_2KJ8");
        ECL_EnableValue("WASSERABLAUF_OPTION_2KJ8", "T");
        ECL_EnableAttribute("WASSERABLAUF_OPTION_2KJ8");
    }
    else
    {
        ECL_DeselectValue("WASSERABLAUF_OPTION_2KJ8", "T");
        ECL_DisableAttribute("WASSERABLAUF_OPTION_2KJ8");
        ECL_DeactivateAttribute("WASSERABLAUF_OPTION_2KJ8");
    }
}

function BestimmeGetriebeConsequences(oData)
{
    //ECSI_CC_GearboxOutputShaftType
    var strAbtriebswellenart=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var strAbtriebswellenmass=ECL_GetValue("ABTRIEBSWELLENMASS_2KJ8").replace('ZOLL', '');
    var strAbtriebswellenmass=strAbtriebswellenmass.replace(/[^A-Z]/g, '');
    var strBefestigungsart=ECL_GetValue("BEFESTIGUNGSART_2KJ8");
    
    if( (strAbtriebswellenmass=="V" || strAbtriebswellenmass=="VG") && strBefestigungsart=="F")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "V");
    else if(strAbtriebswellenmass=="V" || strAbtriebswellenmass=="VG")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "V");
    else if(strAbtriebswellenmass=="VD" || strAbtriebswellenmass=="VDG")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "V");
    else if(strAbtriebswellenmass=="H" || strAbtriebswellenmass=="HF" || strAbtriebswellenmass=="HS" || strAbtriebswellenmass=="HX" || strAbtriebswellenmass=="N")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "H");
    else if(strAbtriebswellenmass=="HM")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "U");
    else if(strAbtriebswellenmass=="VM")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "M");
    else if(strAbtriebswellenmass=="VC")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "C");
    else if(strAbtriebswellenmass=="VR")
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "R");
    else
        ECL_SetValue("ECSI_CC_GearboxOutputShaftType", "V");
        
    logtraceln("ECSI_CC_GearboxOutputShaftType="+ECL_GetValue("ECSI_CC_GearboxOutputShaftType"));
    
    //ECSI_CC_GearboxMountingType
    if(strBefestigungsart=="-")
        ECL_SetValue("ECSI_CC_GearboxMountingType", "F");
    else if(strBefestigungsart=="B")
        ECL_SetValue("ECSI_CC_GearboxMountingType", "B");
    else if(strBefestigungsart=="F" || strBefestigungsart=="G" || strBefestigungsart=="K" || strBefestigungsart=="M") 
        ECL_SetValue("ECSI_CC_GearboxMountingType", "P");
    else if(strBefestigungsart=="Z")
        ECL_SetValue("ECSI_CC_GearboxMountingType", "Z");
    else if(strBefestigungsart=="D")
        ECL_SetValue("ECSI_CC_GearboxMountingType", "D");
    else
        ECL_SetValue("ECSI_CC_GearboxMountingType", "F");
    
    //ECSI_CC_OutputShaftLength
    //ECSI_CC_GearboxOutputShaftDiameter
    var strAbtriebswellenmass=ECL_GetValue("ABTRIEBSWELLENMASS_2KJ8");
    //Abtriebswellenmass
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
        
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    
    var strWELLE_BDS = "0";
    if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder")
        strWELLE_BDS = "1";
    
    var strWELLE_O_PF = "0";
    if(strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder")
        strWELLE_O_PF = "1";
    
    var strSelect = "SELECT DISTINCT EGABW,EGABKDBEZ,EGABKLG,ZOLLWELLE FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND ";
    strSelect = strSelect + "WELLE_BDS='"+strWELLE_BDS+"' AND ";
    strSelect = strSelect + "WELLE_O_PF='"+strWELLE_O_PF+"' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    //strSelect = strSelect + "WELLE_GROSS='0' AND ";
    strSelect = strSelect + "EGABW='"+strAbtriebswellenmass.replace('ZOLL','"')+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var strLaenge="";
    var strDurchmesser="";
    
    if(aResult.length>0)
    {
        var strZollwelle = aResult[0].ZOLLWELLE;
        if(strZollwelle=="1")
        {
            //Zollwelle
            var strSelect="SELECT EGABKDBEZ_HYDRA, EGABKLG_HYDRA FROM EGABKD_HYDRA WHERE ";
            strSelect = strSelect + "EGABW='"+strAbtriebswellenmass.replace('ZOLL','"')+"' ";
            
            var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
            
            if(aResult.length>0)
            {
                strLaenge=aResult[0].EGABKLG_HYDRA;
                if(strLaenge=="-")
                {
                    strLaenge="0";
                }
                    
                strDurchmesser=aResult[0].EGABKDBEZ_HYDRA;
            }
        }
        else
        {
            //metrische Welle
            strLaenge = aResult[0].EGABKLG.replace(/[^0-9.]/g, '');
            if(strLaenge=="")
            {
                strLaenge="0";
            }
            
            strDurchmesser = aResult[0].EGABKDBEZ.replace(/[^0-9.]/g, '');
        }
    
        
        ECL_SetValue("ECSI_CC_OutputShaftLength", strLaenge);
        ECL_SetValue("ECSI_CC_GearboxOutputShaftDiameter", strDurchmesser);
        
        logtraceln("Consequence Länge Abtriebswelle="+strLaenge);
        logtraceln("Consequence Durchmesser Abtriebswelle="+strDurchmesser);
    }
    
    
    //verstärkte Lagerung Consequence
    var strLagerung= ECL_GetValue("ABTRIEBSWELLENLAGERUNG_2KJ8");
    if(strLagerung=="axial verstaerkte Lagerung" || strLagerung=="radial verstaerkte Lagerung")
        ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", "1");
    else if(strLagerung=="XLplus Lagerung")
        ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", "2");
    else if(strLagerung=="VLplus Lagerung")
        ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", "3");
    else
        ECL_SetValue("ECSI_CC_GearboxReinforcedBearing", "0");
}