//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

    
function checkBremse(oData)
{
    var strSpecString= createSpecString(oData);
    
    var strSelect = "SELECT DISTINCT MOT_BREMSKENNER FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG = '"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ = '"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MLFB_13 = '"+ECL_GetValue ("ECSI_MOTORSPANNUNG_SPG_MLFB_2KJ8")+"' ";
            
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if ( aResult.length == 1 )
    {
        if (aResult[0].MOT_BREMSKENNER=="Kauf")
            return 1;
        else if (aResult[0].MOT_BREMSKENNER=="-")
            return 0;
        else if (aResult[0].MOT_BREMSKENNER=="ALL")
            return 2;
    }
    else
    {
        logtraceln("Fehler Bremsencheck!, SQL="+strSelect);
        return 0;
    }
}	

function Bestimme_BREMSENTYP(oData,oDataBremse)
{
    var strSelect = "SELECT DISTINCT BREGRDTYP,BREART,BRENENMO, BREREDMO FROM BRETYP_G115,MOANBEF_M3 WHERE ";
    
    var strMOEINKL = "-";
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
        
    strSelect = strSelect + "MOANBEF_M3.MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_M3.SCHUTZART = '"+ECL_GetValue ("SCHUTZART_2KJ8")+"' AND ";
    strSelect = strSelect + "BRETYP_G115.CDROM_REL = '1' AND MOANBEF_M3.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_M3.M3 = '1' AND ";
    strSelect = strSelect + "MOANBEF_M3.MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "BRETYP_G115.WIBLNR = '"+oData.oRow.WIBLNR+"' AND ";
    strSelect = strSelect + "BRETYP_G115.WIBLAUSLG = '"+oData.oRow.WIBLAUSLG+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BRETYP_G115.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
    strSelect = strSelect + "BRETYP_G115.TYPBEZ = MOANBEF_M3.BRETYP ";

    var strSelectDefault = strSelect;

    strSelect = strSelect  +"ORDER BY abs(BRENENMO),abs(BREREDMO) DESC"
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var strBrake="";
    
    ECL_DeactivateAllAttributeValues("BREMSENTYP_2KJ8");
    if ( aResult.length > 0 )
    {		
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].BREART == "FDX")
            {
                strBrake = aResult[i].BREGRDTYP+"/"+aResult[i].BREREDMO;
            }
            else if(aResult[i].BREREDMO == "-")
            {
                strBrake = aResult[i].BREART+aResult[i].BRENENMO;
            }
            else
            {
                strBrake = aResult[i].BREART+aResult[i].BRENENMO+"/"+aResult[i].BREREDMO;
            }
            
            ECL_ActivateValue("BREMSENTYP_2KJ8", strBrake);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsentyp, SQL="+strSelect);
    }

    //Default Wert bestimmen
    var strBrakeDefault="";
    if(isnewDefaultnecessary("BREMSENTYP_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelectDefault+" AND BRETYP_G115.CDROM_DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            if(aResultDefault[0].BREART == "FDX")
            {
                strBrakeDefault = aResultDefault[0].BREGRDTYP+"/"+aResultDefault[0].BREREDMO;
            }
            else if(aResultDefault[0].BREREDMO == "-")
            {
                strBrakeDefault = aResultDefault[0].BREART+aResultDefault[0].BRENENMO;
            }
            else
            {
                strBrakeDefault = aResultDefault[0].BREART+aResultDefault[0].BRENENMO+"/"+aResultDefault[0].BREREDMO;
            }
            
            ECL_SelectValue("BREMSENTYP_2KJ8", strBrakeDefault);
        }
        else
        {
            if(aResult[0].BREART == "FDX")
            {
                strBrakeDefault = aResult[0].BREGRDTYP+"/"+aResult[0].BREREDMO;
            }
            else if(aResult[0].BREREDMO == "-")
            {
                strBrakeDefault = aResult[0].BREART+aResult[0].BRENENMO;
            }
            else
            {
                strBrakeDefault = aResult[0].BREART+aResult[0].BRENENMO+"/"+aResult[0].BREREDMO;
            }

            ECL_SelectValue("BREMSENTYP_2KJ8", strBrakeDefault);
        }
    }
}
    
function Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse)
{
    
    var strSpecString=  createSpecString(oData);
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT BREDAT_M3.IMAX_GLR,BREDAT_M3.BREFREQ,BREDAT_M3.BEREICH_1,BREDAT_M3.BEREICH_2 FROM BREDAT_M3,BREEREG,BREDATELAUSF_M3 WHERE ";
    strSelect = strSelect + "BREEREG.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    
    if(oDataBremse.oRow.BREART == "FDX")
        strSelect = strSelect + "BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    else
        strSelect = strSelect + "(BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' OR BREDAT_M3.BREART = 'ALL') AND ";
        
    strSelect = strSelect + "BREDATELAUSF_M3.MOTELAUSF = '"+strSpecString+"' AND ";
    

    strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
    strSelect = strSelect + "MOTDIM = '-' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '0' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
        
    strSelect = strSelect + "BREDAT_M3.BREEREG = BREEREG.BREEREG AND ";
    strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "BREDATELAUSF_M3.BREGLR = BREDAT_M3.BREGLR AND ";
    strSelect = strSelect + "STANDARD = '1' AND ";
    strSelect = strSelect + "BREDAT_M3.SONDER = '-' AND BREDAT_M3.SOTEC = '-' AND ";
    strSelect = strSelect + "BREDAT_M3.AKTIV = '1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" ORDER BY BREDAT_M3.BEREICH_1 ");

    ECL_DeactivateAllAttributeValues("BREMSE_STEUERSPANNUNG_2KJ8");
    var strSteuerSpannung="";
    
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            strSteuerSpannung = parseInt(aResult[i].BEREICH_1)+"-"+parseInt(aResult[i].BEREICH_2);
            ECL_ActivateValue("BREMSE_STEUERSPANNUNG_2KJ8", strSteuerSpannung);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen Steuerspannung, SQL="+strSelect);
    }
    
    
    //Default Wert bestimmen
    var strSteuerSpannung="";
    if(isnewDefaultnecessary("BREMSE_STEUERSPANNUNG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND BREDAT_M3.DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            strSteuerSpannung = parseInt(aResult[0].BEREICH_1)+"-"+parseInt(aResult[0].BEREICH_2);
            
            ECL_SelectValue("BREMSE_STEUERSPANNUNG_2KJ8", strSteuerSpannung);
        }
        else
        {
            ECL_SelectValue("BREMSE_STEUERSPANNUNG_2KJ8", parseInt(aResult[0].BEREICH_1)+"-"+parseInt(aResult[0].BEREICH_2));
        }
    }
}

function Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse)
{
    ECL_DeactivateAllAttributeValues("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8");
    ECL_ActivateValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8", "ohne");
}

function Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse)
{
    var strSelect = "SELECT DISTINCT BREAUS,BREKAPS FROM BRETYP_G115 WHERE ";
    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ8")+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BRETYP_G115.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    strSelect = strSelect + "CDROM_REL = '1' ";
        
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    ECL_DeactivateAllAttributeValues("BREMSE_AUSFUEHRUNG_2KJ8");
    
    var strNormalAusfuehrung = "";
    var strGekapseltAusfuehrung = "";
            
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            strNormalAusfuehrung = aResult[i].BREAUS;
            strGekapseltAusfuehrung = aResult[i].BREKAPS;
            
            if(strNormalAusfuehrung == "N" || strNormalAusfuehrung == "M")
                ECL_ActivateValue("BREMSE_AUSFUEHRUNG_2KJ8", "N");
            
            if(strGekapseltAusfuehrung == "G")
            {
                ECL_ActivateValue("BREMSE_AUSFUEHRUNG_2KJ8", "G");
                //ECL_ActivateValue("BREMSE_AUSFUEHRUNG_2KJ8", "GK");
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen Ausführung, SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_AUSFUEHRUNG_2KJ8"))
    {
        ECL_SelectValue("BREMSE_AUSFUEHRUNG_2KJ8", "N");
    }
}

function Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse)
{
    var strSelect = "SELECT * FROM BRETYP_G115 WHERE ";
    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ8")+"' AND ";
    
    if(ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "N")
        strSelect = strSelect + "BREKAPS = '-' AND ";
    else if(ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "G" || ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "GK")
        strSelect = strSelect + "BREKAPS = 'G' AND ";
        
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BRETYP_G115.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
        
    strSelect = strSelect + "BREAUS = 'M' AND ";
    strSelect = strSelect + "CDROM_REL = '1' ";
    
    ECL_DeactivateAllAttributeValues("BREMSE_UEBERWACHUNG_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    if(aResult.length > 0)
    {
        var strSelect = "SELECT DISTINCT BREUEB FROM BREUEB WHERE ";
        strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        
        if(ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "N")
            strSelect = strSelect + "(BREAUS = 'N' OR BREAUS = 'M') AND ";
        else if(ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "G" || ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") == "GK")
            strSelect = strSelect + "(BREAUS = '-' OR BREAUS = 'M') AND ";
        
        strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
        strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
        strSelect = strSelect + "CDROM_REL = '1' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
        
                ECL_ActivateValue("BREMSE_UEBERWACHUNG_2KJ8", aResult[i].BREUEB);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Bremsen Ausführung, SQL="+strSelect);
        }
    }
    else
    {
        //Ohne geht immer
        ECL_ActivateValue("BREMSE_UEBERWACHUNG_2KJ8", "ohne");
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_UEBERWACHUNG_2KJ8"))
    {
        ECL_SelectValue("BREMSE_UEBERWACHUNG_2KJ8", "ohne");
    }
}

function Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8"); 
    
    var awhere = new Array();
    awhere.push({BREKORR:"AKTIV",Value:"1"});
    awhere.push({BREKORR:"BREART",Value:oDataBremse.oRow.BREART});
    awhere.push({BREKORR:"MOTTYP",Value:oData.oRow.MOTTYP});
    awhere.push({BREKORR:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({BREKORR:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({BREKORR:"M3",Value:oData.oRow.M3});
    awhere.push({BREKORR:"GM3",Value:oData.oRow.GM3});
    awhere.push({BREKORR:"UMGEB_TEMP_DEFLT",Value:"Standard"});

    if(strG115_Type=="MM")
         awhere.push({BREKORR:"G115M",Value:"1"});
    else if(strG115_Type=="WM")
         awhere.push({BREKORR:"G115D",Value:"1"});
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
        awhere.push({BREKORR:"UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"BREMSE_KORROSIONSSCHUTZ_2KJ8",DB:"BREKORR"});
    ExecSQL_Standard("2KJ8_DB", "BREKORR", aAttributes, awhere);
    
    var aDefaultSQL = "AND DEFLT = '1'";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "BREKORR", aAttributes, awhere, aDefaultSQL);
    
}

function Bestimme_BREMSE_REIBBELAG(oData,oDataBremse)
{
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        strSchutzdach="W";

    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8"); 
    
    var strSelect = "SELECT DISTINCT BREGERRED FROM BREGERRED WHERE ";
    strSelect = strSelect + "BREGERRED.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BREGERRED.CDROM_REL = '1' AND ";
    strSelect = strSelect + "BREGERRED.M3 = '1' AND ";

    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' ";
    
    ECL_DeactivateAllAttributeValues("BREMSE_REIBBELAG_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BREMSE_REIBBELAG_2KJ8", aResult[i].BREGERRED);
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen Reibbelag, SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_REIBBELAG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1'");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("BREMSE_REIBBELAG_2KJ8", aResultDefault[0].BREGERRED);
        }
        else
        {
            ECL_SelectValue("BREMSE_REIBBELAG_2KJ8", (aResult.length>0?aResult[0].BREGERRED:''));
        }
    }
}

function Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse)
{
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        strSchutzdach="W";
        
    var strSelect = "SELECT DISTINCT BRETYP_G115.BREHLART FROM BRETYP_G115,MOANBEF_M3 WHERE ";
    strSelect = strSelect + "BRETYP_G115.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRETYP_G115.BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BRETYP_G115.BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "MOANBEF_M3.BRETYP = BRETYP_G115.TYPBEZ AND ";
    strSelect = strSelect + "MOANBEF_M3.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_M3.SCHUTZART = 'IP55' AND ";
    strSelect = strSelect + "BRETYP_G115.CDROM_REL = '1' AND MOANBEF_M3.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_M3.M3 = '1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BRETYP_G115.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOANBEF_M3.MOEINKL = '"+strMOEINKL+"' ";
    
    ECL_DeactivateAllAttributeValues("BREMSE_HANDLUEFTUNG_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BREMSE_HANDLUEFTUNG_2KJ8", aResult[i].BREHLART);
            }
        }
    }
    else
    {
        logtraceln("Fehler Handlüftung Bremse! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_HANDLUEFTUNG_2KJ8"))
    {
        ECL_SelectValue("BREMSE_HANDLUEFTUNG_2KJ8", "-");
    }
}

function Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse)
{
    var strKlemmkastenlage=ECL_GetValue("KLEMMKASTENLAGE_2KJ8").left(1);
    var strKlemmkastenlage2=ECL_GetValue("KLEMMKASTENLAGE_2KJ8");
    
    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "KKHL = '"+strKlemmkastenlage+"' AND ";
    
    strSelect = strSelect + "(REGION = 'S' OR REGION = 'SCE') AND ";
    
    if(ECL_ValueSelected("BELUEFTUNG_2KJ8", "Zugeordneter Luefter"))
        strSelect = strSelect + "BELART = 'F' ";
    else
        strSelect = strSelect + "BELART = '-' ";
        
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", aResult[i].BREHLLAG);
                
                var strImage="2KJ8\\%LANG%\\motoroptionen\\HDL\\HDL"+aResult[i].BREHLLAG+".png";
                ECL_SetValueImage ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", aResult[i].BREHLLAG, strImage);
            }
        }
    }
    else
    {
        logtraceln("Fehler Handlüftungslage Bremse! SQL="+strSelect);
    }

    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG_UNDEF WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";

    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG_2KJ8")+"' AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    strSelect = strSelect + "KKLAGE like '"+strKlemmkastenlage2+"%' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_DeactivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", aResult[i].BREHLLAG);
            }
        }
    }
        
    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG_UNDEF3 WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "KKLAGE like '"+strKlemmkastenlage2+"%' AND ";
    
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    
    var strMotorstecker = ECL_GetValue("MOTORSTECKER_2KJ8");
    
    if(ECL_GetValue("GEGENSTECKER_2KJ8") != "ohne")
    {
        strMotorstecker = strMotorstecker + "+Stecker";
    }
    
    strSelect = strSelect + "KKMAT = '"+strMotorstecker+"' AND ";
    strSelect = strSelect + "KKMAT_KABEL_ZUB = '-' ";
    
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_DeactivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", aResult[i].BREHLLAG);
            }
        }
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8"))
    {
        if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "1"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "1");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "2"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "2");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "3"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "3");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "4"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL_2KJ8", "4");
    }
}

function Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT * FROM BREKSHTZ_MOT_M3 WHERE "
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BREAUS = '" + ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8") + "' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' ";
        
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        //Bremskabelschutz erlaubt
        ECL_EnableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8");
        ECL_EnableValue("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8", "T");
    }
    else
    {
        //Bremskabelschutz nicht erlaubt
        ECL_DeselectValue("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8", "T");
        ECL_DisableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION_2KJ8");
    
    }
}

function Bestimme_BREMSE_BRESHLT(oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT BREDAT_M3.BRESHLT, BREDAT_M3.BRESHLT_DEFLT FROM BREDAT_M3 WHERE ";
    strSelect = strSelect + "(BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' OR BREDAT_M3.BREART = 'ALL') AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8") == "Uebererreg.+DC-Absch.Stromerf.")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'am Klemmbrett' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8") == "Uebererreg.+DC-Absch.Spgerf.")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8") == "ohne")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
    }
    
    if(ECL_ValueSelected("SPEZIFIKATION_CHECK_2KJ8", "ULR_CSA"))
    {
        strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8") != "ohne")
    {
        strSelect = strSelect + "(MOTDIM = '-' OR MOTDIM = '"+oData.oRow.MOTDIM+"') AND ";
    }
    else
    {
        strSelect = strSelect + "MOTDIM = '-' AND ";
    }
        
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER_2KJ8") == "ohne")
        strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '0' AND ";
    else
        strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '1' AND ";
        
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
        
    strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "STANDARD = '1' AND ";
    strSelect = strSelect + "BREDAT_M3.AKTIV = '1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        var strBRESHLT = aResult[0].BRESHLT;
        var strBRESHLT_DEFLT = aResult[0].BRESHLT_DEFLT;
        if(strBRESHLT_DEFLT == "1")
            return strBRESHLT;
        else
            return "";
        
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen BRESHLT, SQL="+strSelect);
        return "";
    }
}

function Bestimme_GEBGRD()
{
    var strSelect="SELECT DISTINCT GEBGRD FROM GEBTYP_M3 WHERE GEBER='"+ECL_GetValue("GEBER_DIREKTAUSWAHL_2KJ8")+"' ";
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
        return aResult[0].GEBGRD;
    else
        logtraceln("Fehler beim Bestimmen GEBGRD, SQL="+strSelect);
}