//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function Bestimme_Betriebsart(oData)
{
    //Betriebsart
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    
    if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8") =="87" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")=="104")
    {
    }
    else
        awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:oData.oRow.MOT_EFFIZIENZKL_KNZ});
    
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL")});
    awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")});
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    awhere.push({TMP_MOT_DATEN:"MOT_LEISTUNG",Value:oData.oRow.LEISTUNG});
    awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART",Value:("P91;P92")});
    
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"BETRIEBSART_2KJ8",DB:"MOT_BETRIEBSART_KEY"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("BETRIEBSART_2KJ8");
        ECL_DeactivateAttribute("BETRIEBSART_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("BETRIEBSART_2KJ8");
        ECL_EnableAttribute("BETRIEBSART_2KJ8");
    }
}

function Bestimme_Netzspannung(oData)
{
    //Spannung
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    awhere.push({TMP_MOT_DATEN:"MOT_EFFIZIENZKL_KNZ",Value:oData.oRow.MOT_EFFIZIENZKL_KNZ});
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_FREQUENZ",Value:ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_BETRIEBSART_KEY",Value:ECL_GetValue("BETRIEBSART_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    awhere.push({TMP_MOT_DATEN:"MOT_LEISTUNG",Value:oData.oRow.LEISTUNG});
    awhere.push({TMP_MOT_DATEN:"MOT_SPANNUNG_UI",Value:ECL_GetValue("ECSI_MOTORSPANNUNG_SPG")});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"MOTORSPANNUNG_2KJ8",DB:"MOT_SPANNUNG_UI"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    var aDefaultSQL = "";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere, aDefaultSQL);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DisableAttribute("MOTORSPANNUNG_2KJ8");
        ECL_DeactivateAttribute("MOTORSPANNUNG_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("MOTORSPANNUNG_2KJ8");
        ECL_EnableAttribute("MOTORSPANNUNG_2KJ8");
    }
}


function check_erhoehteLeistung(oData)
{
    //Checken, ob erhöhte Leistung möglich
    var sFrequenz	= ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8");
    var Wirkungsgradklasse = ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8");
    var Betriebsart = ECL_GetValue("BETRIEBSART_2KJ8");
    var strMotortable = "TMP_MOT_DATEN";
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ8");
    
    var strSelect = "SELECT MOT_LEISTUNG_ERH_TF FROM "+strMotortable+" WHERE ";
    strSelect = strSelect + "MOT_FREQUENZ='"+sFrequenz+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+createSpecString(oData)+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+Betriebsart+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var bNichterhoehteLeistungmoeglich=false;
    for(var i=0; i<aResultTable.length;i++)
    {
        if(aResultTable[i].MOT_LEISTUNG_ERH_TF == "Ja")
            ECL_EnableValue("ERHOEHTE_LEISTUNG_OPTION_2KJ8", "T");
        else if(aResultTable[i].MOT_LEISTUNG_ERH_TF == "Nein")
            bNichterhoehteLeistungmoeglich=true;
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DeactivateAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ8");
        ECL_DisableAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ8");
        ECL_EnableAttribute("ERHOEHTE_LEISTUNG_OPTION_2KJ8");
    }
    
}

function check_Spannungstoleranz(oData)
{
    //Checken, ob Spannungstoleranz möglich ist
    
    var sFrequenz	= ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8");
    var Wirkungsgradklasse = ECL_GetValue("ECSI_WIRKUNGSGRADKLASSE_VORAUSWAHL_2KJ8");
    var Betriebsart = ECL_GetValue("BETRIEBSART_2KJ8");
    var strMotortable = "TMP_MOT_DATEN";
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ8");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION_2KJ8", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
    
    var strSelect = "SELECT MOT_SPANNUNG_TOL,MOT_LEISTUNG FROM "+strMotortable+" WHERE ";
    strSelect = strSelect + "MOT_FREQUENZ='"+sFrequenz+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+createSpecString(oData)+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+Betriebsart+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var bohneSpannungToleranzmoeglich=false;
    for(var i=0; i<aResultTable.length;i++)
    {
        if(aResultTable[i].MOT_SPANNUNG_TOL == "+-10")
            ECL_ActivateValue("SPANNUNGSTOLERANZ_OPTION_2KJ8", "T");
        else if(aResultTable[i].MOT_SPANNUNG_TOL == "-")
            bohneSpannungToleranzmoeglich=true;
    }
    
    //Leistung neu setzen
    //oData.oRow.LEISTUNG = aResultTable[0].MOT_LEISTUNG;
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        ECL_DeactivateAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ8");
        ECL_DisableAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ8");
    }
    else
    {
        ECL_ActivateAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ8");
        ECL_EnableAttribute("SPANNUNGSTOLERANZ_OPTION_2KJ8");
    }
}

function Bestimme_Motorschutz(oData)
{
    var strKKABDICH="ohne";
    if(ECL_ValueSelected("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8", "T"))
        strKKABDICH="vergossen";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    var awhere = new Array();
    awhere.push({MOWSART:"POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    awhere.push({MOWSART:"KKABDICH",Value:strKKABDICH});
    //awhere.push({MOWSART:"VERST_ISO",Value:'0'});
    awhere.push({MOWSART:"G110M",Value:'0'});
    awhere.push({MOWSART:"G115",Value:'1'});
    awhere.push({MOWSART:"M3",Value:oData.oRow.M3});
    awhere.push({MOWSART:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({MOWSART:"S09",Value:oData.oRow.S09});	
    awhere.push({MOWSART:"VSDMOTOR",Value:oData.oRow.VSDMOTOR});
    awhere.push({MOWSART:"REGION",Value:'S;SC;SCI;SI;SCA'});
    awhere.push({MOWSART:"MOTTYP",Value:oData.oRow.MOTTYP+';ALL'});
    awhere.push({MOWSART:"HEMOTOR",Value:strHEMOTOR+';ALL'});
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        awhere.push({MOWSART:"CAST(MOWSART.UMGEB_TEMP_MAX AS INT)",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    }
    
    awhere.push({MOWSART:"AKTIV",Value:'1'});	
    awhere.push({MOWSART:"FKTSICHERHEIT_KNR",Value:'-'});
    
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"MOTORSCHUTZ_2KJ8",DB:"WIELART"});
    ExecSQL_Standard("2KJ8_DB", "MOWSART", aAttributes, awhere);
    
    var strDefaultSQL = " AND DEFLT='1' ";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "MOWSART", aAttributes, awhere, strDefaultSQL);
    
}

function Bestimme_Stillstandsheizung(oData)
{
    //gibts nicht bei 2KJ8
    /*
    var awhere = new Array();
    awhere.push({MOHEIZSPG:"G110M",Value:'0'});
    awhere.push({MOHEIZSPG:"M3",Value:oData.oRow.M3});
    awhere.push({MOHEIZSPG:"GM3",Value:oData.oRow.GM3});
    awhere.push({MOHEIZSPG:"S09",Value:oData.oRow.S09});	
    awhere.push({MOHEIZSPG:"MOTDIM",Value:oData.oRow.MOTDIM});	
    awhere.push({MOHEIZSPG:"REGION",Value:'S;SC;SCI;SI'});
    awhere.push({MOHEIZSPG:"AKTIV",Value:'1'});	
    awhere.push({MOHEIZSPG:"CDROM_REL",Value:'1'});	
    
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"STILLSTANDSHEIZUNG_2KJ8",DB:"HEIZSPG"});
    ExecSQL_Standard("2KJ8_DB", "MOHEIZSPG", aAttributes, awhere);
    */
    
    //Ohne geht immer
    ECL_ActivateValue("STILLSTANDSHEIZUNG_2KJ8", "ohne");
    //Default ist ohne
    ExecSetStandardifValueEmpty("STILLSTANDSHEIZUNG_2KJ8","ohne");
}

function Bestimme_Waermeklasse(oData)
{
    //Wärmeklasse
    
    var awhere = new Array();
    var strSpecString=  createSpecString(oData);
    
    awhere.push({TMP_MOT_DATEN:"MOT_EL_AUSFUEHRUNG",Value:strSpecString});
    awhere.push({TMP_MOT_DATEN:"MOT_POLZAHL",Value:ECL_GetValue("ECSI_POLZAHL_2KJ8")});
    awhere.push({TMP_MOT_DATEN:"MOT_BZ_LANG",Value:oData.oRow.MOT_BZ_LANG});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"WAERMEKLASSE_2KJ8",DB:"MOT_WAERMEKLASSE_KEY"});
    ExecSQL_Standard("2KJ8_DB", "TMP_MOT_DATEN", aAttributes, awhere);
    
    ExecSetStandardifValueEmpty("WAERMEKLASSE_2KJ8","F");
    
}

function Bestimme_MotorZusatzKAs(oData)
{
    //Hier werden die Spannungszusatz-Kurzangaben bestimmt, die für die nachgelagerte Konfiguration erforderlich sind
    
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ8");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION_2KJ8", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
        
    var	SpannungsTol="";
    var bSpannungsTol = ECL_ValueSelected ("SPANNUNGSTOLERANZ_OPTION_2KJ8", "T");
    if(bSpannungsTol)
        SpannungsTol = "+-10";
    else
        SpannungsTol = "-";
        
    var strSpecString=  createSpecString(oData);
    
    var strSelect="SELECT DISTINCT MLFB_13_KA FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_FREQUENZ='"+ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG='"+oData.oRow.LEISTUNG+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_TOL='"+SpannungsTol+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE_2KJ8")+"' ";
    
    //Bei SIZER IMPORT darf KA für Spannung nicht geändert werden
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "EASYKAT_CONFIG")
    {
        var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResultTable.length>0)
        {
            ECL_SetValue ("ECSI_MOTORSPANNUNG_SPG_KA_2KJ8", aResultTable[0].MLFB_13_KA);
        }
    }
}