//@legacy
//#mode(full-ecma)





function gethoechsteDrehzahlMotor(oData)
{
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ8");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION_2KJ8", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
        
    var	SpannungsTol="";
    var bSpannungsTol = ECL_ValueSelected ("SPANNUNGSTOLERANZ_OPTION_2KJ8", "T");
    if(bSpannungsTol)
        SpannungsTol = "+-10";
    else
        SpannungsTol = "-";
    
    var strSelect="SELECT DISTINCT MOT_BDRHZAHL FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+ECL_GetValue("ECSI_SPEZIFIKATION_RADIO_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_FREQUENZ='"+ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG='"+oData.oRow.LEISTUNG+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_TOL='"+SpannungsTol+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE_2KJ8")+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var iMaximumDrehzahl=0;
    if(aResultTable.length>0)
    {
        for(var i=0;i<aResultTable.length;i++)
        {
            if(iMaximumDrehzahl < parseInt(aResultTable[i].MOT_BDRHZAHL))
                iMaximumDrehzahl = parseInt(aResultTable[i].MOT_BDRHZAHL);
        }
    }
    
    return iMaximumDrehzahl;
}

function Bestimme_AVMOKDBEZ(oData)
{
    //Bestimmung von AVMOKDBEZ für EGOAB_M3
    
    var strAVMODKDEZ="";
    var strSelect = "SELECT DISTINCT AVMOKDBEZ ";
    
    strSelect = strSelect + "FROM CD_MOTOREN_ANBAU WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        strAVMODKDEZ = aResult[0].AVMOKDBEZ;
    }
    else
    {
        logtraceln("Fehler Bestimmung AVMOKDBEZ für EGOAB_M3! SQL="+strSelect);
    }
    
    return strAVMODKDEZ;
}

function Bestimme_EGABAUSF(oData)
{
    //Bestimmung EGABAUSF für Abtriebswellenlagerung
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var strWellenmass=replace(ECL_GetValue("ABTRIEBSWELLENMASS_2KJ8"),'ZOLL','"');
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    var strSelect = "SELECT DISTINCT EGABAUSF FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND EGABW='"+strWellenmass+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0){
        return aResult;
    }
    else{
        logtraceln("Fehler bei Bestimmung EGABAUSF für Abtriebswellenlagerung!, SQL="+strSelect);
    }
    return [];
}

function Bestimme_EGABKDBEZ(oData)
{
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART_2KJ8");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    var strSelect = "SELECT DISTINCT EGABKDBEZ FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND EGABW='"+replace(ECL_GetValue("ABTRIEBSWELLENMASS_2KJ8"),'ZOLL','"')+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
        return aResult[0].EGABKDBEZ;
    else
        logtraceln("Fehler bei Bestimmung EGABKDBEZ für Abtriebswellendichtung!, SQL="+strSelect);

}

function Bestimme_Abtriebswellenlagerung(oData)
{
    var aResult = Bestimme_EGABAUSF(oData);
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
            
    var strSelect = "";
    for (var i=0;i<aResult.length;i++)
    {
        if(ECL_GetValue("BEFESTIGUNGSART_2KJ8")!="-" && ECL_GetValue("BEFESTIGUNGSART_2KJ8")!="D" )
		{
		
			strSelect = strSelect + "SELECT DISTINCT EGABALAG FROM EGLAGER_M3,EGABFLD_M3 WHERE ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGLAGER_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGLAGER_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGLAGER_M3.EGPOSHL='ALL') AND ";
			
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGLAGER_M3.EGBEZBRA='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGLAGER_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGLAGER_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGLAGER_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.OELSORTE='"+ECL_GetValue("GETRIEBEOEL_2KJ8")+"' OR EGLAGER_M3.OELSORTE='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZWNV='"+Verbindungsart+"' OR EGLAGER_M3.EGBEZWNV='ALL') AND ";
			
			strSelect = strSelect + "EGABFLD_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.AKTIV='1' AND ";
			strSelect = strSelect + "EGABFLD_M3.AKTIV='1' AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGLAGER_M3.EGABAUSF='ALL') AND ";
			
			
			strSelect = strSelect + "EGABFLD_M3.EGABFLDM='"+ECL_GetValue("BEFESTIGUNGSMASS_2KJ8")+"' AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGABFLD_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGABFLD_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZBRA='ALL' OR EGABFLD_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGABFLD_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGABFLD_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGABFLD_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZWNV='"+Verbindungsart+"' OR EGABFLD_M3.EGBEZWNV='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGABFLD_M3.EGABAUSF='ALL') AND ";
			strSelect = strSelect + "EGABFLD_M3.EINZELGETR='1' AND ";
			strSelect = strSelect + "EGABFLD_M3.REGION='S' ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
				strSelect = strSelect + "AND CAST(EGLAGER_M3.EGLAGER_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
				strSelect = strSelect + "AND CAST(EGABFLD_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
	
			strSelect = strSelect + " UNION ";
		}
		else
		{
			strSelect = strSelect + "SELECT DISTINCT EGABALAG FROM EGLAGER_M3 WHERE ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGLAGER_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGLAGER_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGLAGER_M3.EGPOSHL='ALL') AND ";
			
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGLAGER_M3.EGBEZBRA='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGLAGER_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGLAGER_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGLAGER_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.OELSORTE='"+ECL_GetValue("GETRIEBEOEL_2KJ8")+"' OR EGLAGER_M3.OELSORTE='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZWNV='"+Verbindungsart+"' OR EGLAGER_M3.EGBEZWNV='ALL') AND ";
			
			strSelect = strSelect + "EGLAGER_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.AKTIV='1' AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGLAGER_M3.EGABAUSF='ALL') ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG"){
				strSelect = strSelect + "AND CAST(EGLAGER_M3.EGLAGER_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
            }
			strSelect = strSelect + " UNION ";
		}
	}
	
	strSelect = trimright(strSelect," UNION ");
	
	var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
	
	ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENLAGERUNG_2KJ8");
	if(aResult.length>0)
	{
		for(var i=0;i<aResult.length;i++)
		{
			ECL_ActivateValue("ABTRIEBSWELLENLAGERUNG_2KJ8",aResult[i].EGABALAG);
		}
	}
	else
		logtraceln("Fehler bei Bestimmung Abtriebswellenlagerung!, SQL="+strSelect);
		
	ExecSetStandardifValueEmpty("ABTRIEBSWELLENLAGERUNG_2KJ8", "zugeordnete Lagerung");			
}

function Bestimme_Getriebeoel(oData)
{
    var strSelect = "SELECT DISTINCT OELSORTE FROM OELSORTE_M3 WHERE ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    
    //Für Kühlturm und Hängebahn abfragen
    strSelect = strSelect + "(OELSORTE_M3.ANWTYP='"+oData.oRow.ANWTYP+"' OR OELSORTE_M3.ANWTYP='ALL') AND ";
    strSelect = strSelect + "OELSORTE_M3.AKTIV='1' AND ";
    strSelect = strSelect + "OELSORTE_M3.G115='ALL' ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "AND CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
        }
    }


    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GETRIEBEOEL_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GETRIEBEOEL_2KJ8",aResult[i].OELSORTE);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Getriebeöl!, SQL="+strSelect);
    
    //Default Wert bestimmen
        
    //neue Lösung von Juliane 15.03.2021
    // bis 40°C ==> K06 - CLP VG220
    // 41°C bis 50°C ==> K07 - CLP PG VG220
    // 60 °C ==> K08 - CLP PG VG460
    
    if(isnewDefaultnecessary("GETRIEBEOEL_2KJ8"))
    {
        var bSonderoel=false;
        if(oData.oRow.EGBEZTYP=="B" || oData.oRow.EGBEZTYP=="C" || (oData.oRow.EGBEZTYP=="B" && oData.oRow.EGBEZBRA=="H"))
            bSonderoel=true;
            
        var iAmbientTemerature = parseInt(oData.oRow.SIZER_AmbientTemperatureMotor);
        
        if(bSonderoel && iAmbientTemerature < 60 && ECL_ValueEnabled ("GETRIEBEOEL_2KJ8", "CLP PG VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL_2KJ8", "CLP PG VG220");
        }
        else if(iAmbientTemerature <= 40 && ECL_ValueEnabled ("GETRIEBEOEL_2KJ8", "CLP VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL_2KJ8", "CLP VG220");
        }
        else if( (iAmbientTemerature > 40 && iAmbientTemerature < 60) && ECL_ValueEnabled ("GETRIEBEOEL_2KJ8", "CLP PG VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL_2KJ8", "CLP PG VG220");
        }
        else if (ECL_ValueEnabled ("GETRIEBEOEL_2KJ8", "CLP PG VG460"))
        {
            ECL_SelectValue("GETRIEBEOEL_2KJ8", "CLP PG VG460");
        }
    }	
}

function Bestimme_Getriebeentlueftung(oData)
{
    var strSelect =     "SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "(ANWTYP='"+oData.oRow.ANWTYP+"' OR ANWTYP='ALL') AND ";
    strSelect = strSelect + "(SCHUTZART='"+ECL_GetValue("SCHUTZART_2KJ8")+"' OR SCHUTZART='ALL') AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') AND ";
    strSelect = strSelect + "REGION IN ('S','SC') AND ";
    strSelect = strSelect + "(CDROM_REL = '1' OR CDROM_REL = '2') AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "EINZELGETR = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ8", "T"))
    {
        if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "X")
            strSelect = strSelect + "X_ACHSE = '1' AND ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Y")
            strSelect = strSelect + "Y_ACHSE = '1' AND ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Z")
            strSelect = strSelect + "Z_ACHSE = '1' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
    
    
    strSelect = strSelect + "EGGEHENT NOT IN( SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3_UNDEF WHERE ";
    strSelect = strSelect + "EGBEZTYP = '"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' AND ";
   	
	if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ8", "T"))
        strSelect = strSelect + "SCHRAEGBAULAGEN='1' ) ";
    else
        strSelect = strSelect + "SCHRAEGBAULAGEN='0' ) ";
        
    strSelect = strSelect + "AND EGGEHENT NOT IN( SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3_UNDEF2 WHERE ";
    strSelect = strSelect + "EGBEZTYP = '"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' AND ";
    strSelect = strSelect + "MOTDIM_IEC='"+oData.oRow.MOTDIM+"') ";

    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GETRIEBEENTLUEFTUNG_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GETRIEBEENTLUEFTUNG_2KJ8",aResult[i].EGGEHENT);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Getriebeentlüftung!, SQL="+strSelect);
    
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GETRIEBEENTLUEFTUNG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND CDROM_DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("GETRIEBEENTLUEFTUNG_2KJ8", aResultDefault[0].EGGEHENT);
        }
        else
        {
            ECL_SelectValue("GETRIEBEENTLUEFTUNG_2KJ8", aResult[0].EGGEHENT);
        }
    }
}


function istOelausgleichsbehaelter_vorgeschrieben(oData)
{
    var strSelect = "";
    
    var strEGPOS = "";
    
    if(ECL_GetValue("ABTRIEBSSEITE_2KJ8") != "-")
        strEGPOS = ECL_GetValue("BAUFORM_2KJ8") + "-" + ECL_GetValue("ABTRIEBSSEITE_2KJ8");
    else
        strEGPOS = ECL_GetValue("BAUFORM_2KJ8");
        
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ8", "T"))
    {
        var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION_2KJ8"),4);

        var strEGPOS_Start = left(strDrehung,2);
        var strEGPOS_Ziel = right(strDrehung,2);
        
        if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "X")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_X_ACHSE WHERE ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Y")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_Y_ACHSE WHERE ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Z")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_Z_ACHSE WHERE ";
            
            
        strSelect = strSelect + "EGPOS_START = '"+strEGPOS_Start+"' AND ";
        strSelect = strSelect + "EGPOS_ZIEL = '"+strEGPOS_Ziel+"' AND ";
        
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
        strSelect = strSelect + "EGBEZDIM_MIN<="+oData.oRow.EGBEZDIM+" AND EGBEZDIM_MAX>="+oData.oRow.EGBEZDIM+" AND ";
        
        if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "X")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"X_ACHSE_","")+"' ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Y")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Y_ACHSE_","")+"' ";
        else if(ECL_GetValue("SE_ACHSE_WAHL_2KJ8") == "Z")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Z_ACHSE_","")+"' ";
    }
    else
    {
        
        strSelect = "SELECT DISTINCT OAB FROM EGPOS_BAULAGEN WHERE ";
        
        strSelect = strSelect + "EGPOS_START = '"+strEGPOS+"' AND ";
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
        
        strSelect = strSelect + "EGBEZDIM_MIN <= "+oData.oRow.EGBEZDIM+" AND ";
        strSelect = strSelect + "EGBEZDIM_MAX >= "+oData.oRow.EGBEZDIM+" AND ";
        
        strSelect = strSelect + "ZGBEZUEBS = '-' AND ";
        strSelect = strSelect + "ZGBEZDIM = '-' AND ";
        strSelect = strSelect + "EGPOS_ZIEL = '-' ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    var dN1;
    var strOAB = "0";
    if ( aResult.length == 1 )
    {		
        strOAB = aResult[0].OAB;
    }
    else
    {
        logtraceln("Fehler Bestimmung Ölausgleichsbehälter vorgeschrieben! SQL="+strSelect);
    }
    
    
    if(strOAB == "2" && ECL_GetValue("BAUFORM_2KJ8") == "M4")
    {
        var strAVMOKDBEZ = Bestimme_AVMOKDBEZ(oData);
        
        //jetzt auf Drehzahl prüfen!
        
        strSelect = "SELECT DISTINCT N1 FROM EGOAB_M3 WHERE ";
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
        strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
        strSelect = strSelect + "DGUEB='"+oData.oRow.UEBERSETZUNG+"' AND ";
        strSelect = strSelect + "AVMOKDBEZ='"+strAVMOKDBEZ+"' ";
        strSelect = strSelect + "ORDER BY cast(N1 AS FLOAT) ASC";
        
        var iDrehzahlMotor = 0;
        
        iDrehzahlMotor = gethoechsteDrehzahlMotor(oData);
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        var bOelausgleich_vorgeschrieben;
        if ( aResult.length > 0 )
        {
            dN1 = aResult[0].N1;
            
            if(iDrehzahlMotor >= dN1)
                bOelausgleich_vorgeschrieben = true;
            else
                bOelausgleich_vorgeschrieben = false;
        }
        
        if(bOelausgleich_vorgeschrieben)
        {
            logtraceln("Ölausgleich vorgeschrieben? N1="+dN1+" Bemessungsdrehzahl="+iDrehzahlMotor+" Ergebnis="+bOelausgleich_vorgeschrieben);
            return true;
        }
        else
        {
            logtraceln("Ölausgleich nicht vorgeschrieben!");
            return false;
        }
    }
    else
    {
        return false;
    }
}

function Bestimme_Abtriebswellenabdichtung(oData)
{
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGABKDBEZ=Bestimme_EGABKDBEZ(oData);
    var aEGABAUSF=Bestimme_EGABAUSF(oData);
        
    var strSelect = "SELECT DISTINCT DICHTUNGSART,DRWERK FROM DRWERK_EG_M3 WHERE ";
    strSelect = strSelect + "(OELSORTE='"+ ECL_GetValue("GETRIEBEOEL_2KJ8")+"' OR OELSORTE='ALL') AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "(EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGBEZAWTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZWNV='"+Verbindungsart+"' OR EGBEZWNV='ALL') AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(EGABKDBEZ='"+strEGABKDBEZ+"' OR EGABKDBEZ='ALL') AND ";

    if(aEGABAUSF.length !=0){
        strSelect = strSelect + "EGABAUSF='"+aEGABAUSF[0].EGABAUSF+"' AND ";
    }
    else{
        strSelect = strSelect + "EGABAUSF='undefined' AND ";    //damit in der DB nichts gefunden wird
    }
    strSelect = strSelect + "AKTIV='1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
            
    strSelect = strSelect + "EINZELGETR='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENABDICHTUNG_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("ABTRIEBSWELLENABDICHTUNG_2KJ8",aResult[i].DICHTUNGSART);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Abtriebswellendichtung!, SQL="+strSelect);
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("ABTRIEBSWELLENABDICHTUNG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("ABTRIEBSWELLENABDICHTUNG_2KJ8", aResultDefault[0].DICHTUNGSART);
        }
        else
        {
            ECL_SelectValue("ABTRIEBSWELLENABDICHTUNG_2KJ8", aResult[0].DICHTUNGSART);
        }
    }
}

function Bestimme_Oelstandskontrolle(oData) 
{
    var strSelect = "SELECT DISTINCT EGGEHOLK FROM EGGEHOLK_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='" + oData.oRow.EGBEZTYP + "' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZUEBS='" + oData.oRow.EGBEZUEBS + "' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='" + oData.oRow.EGBEZDIM + "' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGBEZEI='" + oData.oRow.EGBEZEI + "' AND ";
    strSelect = strSelect + "(EGBEZBEF='" + ECL_GetValue("BEFESTIGUNGSART_2KJ8") + "' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(ANWTYP='" + oData.oRow.ANWTYP + "' OR ANWTYP='ALL') AND ";
    strSelect = strSelect + "(EGPOSHL='" + ECL_GetValue("BAUFORM_2KJ8") + "' OR EGPOSHL='ALL') AND ";
    strSelect = strSelect + "EINZELGETR = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    strSelect = strSelect + "REGION = 'S' AND ";

    if (ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T"))
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
    else
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";

    if (ECL_GetValue("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG") {
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= " + parseInt(oData.oRow.SIZER_AmbientTemperatureMotor) + " ";

        if (ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40")) {
            strSelect = strSelect + "AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
        }
    }

    if (ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T")) {

        var strWinkeldb = "";
        var strAchse = "";
        var strWinkel = ECL_GetValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL_2KJ8");

        if (strWinkel == "X_20") {
            strWinkeldb = "+/-20°";
            strAchse = "X";
        }
        else if (strWinkel == "Y_20") {
            strWinkeldb = "+/-20°";
            strAchse = "Y";
        }
        else if (strWinkel == "Y_20-0") {
            strWinkeldb = "+20-0°";
            strAchse = "Y";
        }

        strSelect = strSelect + "AND EGGEHOLK IN (SELECT DISTINCT EGGEHOLK FROM EGPOSWINKZUL_ZEABW WHERE ";
        strSelect = strSelect + "EGBEZTYP='" + oData.oRow.EGBEZTYP + "' AND ";
        strSelect = strSelect + "EGPOSHL='" + ECL_GetValue("BAUFORM_2KJ8") + "' AND ";
        strSelect = strSelect + "REGION='S' AND ";

        if (strAchse == "X") {
            strSelect = strSelect + "X_Achse='1' AND WINKEL like '" + strWinkeldb.left(5) + "%' ";
        }
        else if (strAchse == "Y") {
            strSelect = strSelect + "Y_Achse='1' AND WINKEL like '" + strWinkeldb.left(5) + "%' ";
        }
        strSelect = strSelect + ")";

    }


    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);

    ECL_DeactivateAllAttributeValues("OELSTANDSKONTROLLE_2KJ8");
    if (aResult.length > 0) {
        for (var i = 0; i < aResult.length; i++) {
            if (aResult[i].EGGEHOLK != "Oelstand-Sensor ATEX")
                ECL_ActivateValue("OELSTANDSKONTROLLE_2KJ8", aResult[i].EGGEHOLK);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Ölstandskontrolle!, SQL=" + strSelect);


    //Default Wert bestimmen
    if (isnewDefaultnecessary("OELSTANDSKONTROLLE_2KJ8")) {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect + " AND DEFLT='1' ");
        if (aResultDefault.length > 0) {
            ECL_SelectValue("OELSTANDSKONTROLLE_2KJ8", aResultDefault[0].EGGEHOLK);
        }
        else {
            ECL_SelectValue("OELSTANDSKONTROLLE_2KJ8", aResult[0].EGGEHOLK);
        }
    }
}

function Bestimme_Oelablass(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strSelect="";
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION_2KJ8", "T"))
	{
		var strEGGEHOLA_OELSTAND_ZUL="";
		var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION_2KJ8"),4);

		var strEGPOS_Start = left(strDrehung,2);
		var strEGPOS_Ziel = right(strDrehung,2);
		
		var strConfig_Abtriebsseite=ECL_GetValue("ABTRIEBSSEITE_2KJ8");
		if(strConfig_Abtriebsseite!= "" && strConfig_Abtriebsseite!= "-")
		{
			strEGPOS_Start=strEGPOS_Start+"-"+strConfig_Abtriebsseite;
			strEGPOS_Ziel=strEGPOS_Ziel+"-"+strConfig_Abtriebsseite;
		}
		
		var strAchse=ECL_GetValue("SE_ACHSE_WAHL_2KJ8");
		
		var strTableName="EGPOS_SCHRAEGBAULAGEN_"+strAchse+"_ACHSE";
		var strColumnName=strAchse+"_ACHSE";
		
		strSelect="SELECT DISTINCT EGGEHOLA_OELSTAND_ZUL FROM "+strTableName+" WHERE ";
		strSelect = strSelect+"EGPOS_START='"+strEGPOS_Start+"' AND ";
		strSelect = strSelect+"EGPOS_ZIEL='"+strEGPOS_Ziel+"' AND ";
		strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
		strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "EGBEZDIM_MIN<="+oData.oRow.EGBEZDIM+" AND EGBEZDIM_MAX>="+oData.oRow.EGBEZDIM+" AND ";
		strSelect = strSelect + strColumnName + "='"+replace(ECL_GetValue("SE_ROTATIONSWINKEL_2KJ8"),strColumnName+"_","")+"' ";
		
		var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
		
		if(aResult.length>0)
		{
			strEGGEHOLA_OELSTAND_ZUL = aResult[0].EGGEHOLA_OELSTAND_ZUL;
		}
		else
		{
			logtraceln("Fehler beim Bestimmen Ölablassabhängigkeit bei den Sondereinbaulagen!; SQL="+strSelect);
		}
		
		strSelect = "SELECT DISTINCT EGGEHOLA FROM EGGEHOLA_M3 WHERE ";
		strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
		strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
		strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
		strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') AND ";
		strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' OR EGABAWS='ALL') AND ";
		strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
		strSelect = strSelect + "EINZELGETR = '1' AND ";
		strSelect = strSelect + "EGGEHOLTU='-' AND ";
		strSelect = strSelect + "CDROM_REL='1' AND ";
		
		if(strG115_Type=="MM")
			strSelect = strSelect + "G115M = '1' AND ";
		else if(strG115_Type=="WM")
			strSelect = strSelect + "G115D = '1' AND ";
			
		strSelect = strSelect + "SONDER='-' AND ";
		strSelect = strSelect + "REGION IN ('S','SC') AND ";
		strSelect = strSelect + "EGGEHOLA_OELSTAND_ZUL ='"+strEGGEHOLA_OELSTAND_ZUL+"' AND ";
		
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    
            if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
            {
                strSelect = strSelect + " AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
            }
        }
	}
	else
	{
		strSelect = "SELECT DISTINCT EGGEHOLA FROM EGGEHOLA_M3 WHERE ";
		strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
		strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
		strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
		strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') AND ";
		strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' OR EGABAWS='ALL') AND ";
		
		if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T"))
			strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
		else
			strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
			
		strSelect = strSelect + "CDROM_REL='1' AND ";
		
		if(strG115_Type=="MM")
			strSelect = strSelect + "G115M = '1' AND ";
		else if(strG115_Type=="WM")
			strSelect = strSelect + "G115D = '1' AND ";
			
		strSelect = strSelect + "EINZELGETR = '1' AND ";
		strSelect = strSelect + "SONDER='-' AND ";
		strSelect = strSelect + "REGION IN ('S','SC') AND ";
		strSelect = strSelect + "EGGEHOLTU='-' AND ";
		
		
        if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    
            if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
            {
                strSelect = strSelect + "AND CAST(UMGEB_TEMP_MIN AS INT) <= -30 ";
            }
        }
	}
	       
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("OELABLASS_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("OELABLASS_2KJ8",aResult[i].EGGEHOLA);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Ölablass!, SQL="+strSelect);
        
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("OELABLASS_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("OELABLASS_2KJ8", aResultDefault[0].EGGEHOLA);
        }
        else
        {
            ECL_SelectValue("OELABLASS_2KJ8", aResult[0].EGGEHOLA);
        }
    }
}

function istspielfreieAusfuehrungMoeglich(oData)
{
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
        
    var strSelect = "SELECT DISTINCT EGBEZSO FROM EGTYP,EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZAWTYP='"+Abtriebswellentyp+"' AND ";
    strSelect = strSelect + "EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' AND ";
    strSelect = strSelect + "EGBEZWNV='"+Verbindungsart+"' AND ";
    strSelect = strSelect + "EGBEZSO='W' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "EGTYP.TYPBEZ=EGABKD_M3.EGTYP AND ";
    strSelect = strSelect + "EGABKD_M3.EGABW = '"+ECL_GetValue("ABTRIEBSWELLENMASS_2KJ8")+"' AND ";
    
    //Abfrage EGANSSART
    var strEGANSSART="BK4";
    if(oData.oRow.EGBEZDIM=="19")
        strEGANSSART="Z19";
    else if(oData.oRow.EGBEZTYP=="S")
        strEGANSSART="S09";
    
    strSelect = strSelect + "EGANSSART = '"+strEGANSSART+"' AND ";
    
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION_2KJ8", "T"))
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
    else
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
        
    strSelect = strSelect + "EGTYP.REGION IN ('S','SA','SACE') AND ";
    strSelect = strSelect + "MOTOX_N='0' AND ";
    strSelect = strSelect + "EGTYP.CDROM_REL='1' AND ";
    strSelect = strSelect + "EGTYP.AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if(aResult.length>0)
    {
        //spielfreie Ausführung möglich
        ECL_EnableAttribute("SPIELREDUZIERT_OPTION_2KJ8");
    }
    else
    {
        //spielfreie Ausführung nicht möglich
        ECL_DeselectValue("SPIELREDUZIERT_OPTION_2KJ8", "T");
        ECL_DisableAttribute("SPIELREDUZIERT_OPTION_2KJ8");
    }
}

function istgeklebtesEndstufenradMoeglich(oData)
{
    var strSelect = "SELECT DISTINCT EGSPRED_WNV FROM EGSPRED_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
    
    if(ECL_ValueSelected("SPIELREDUZIERT_OPTION_2KJ8", "T"))
        strSelect = strSelect + "(EGBEZSO='W' OR EGBEZSO='ALL') AND ";
    else
        strSelect = strSelect + "(EGBEZSO='-' OR EGBEZSO='ALL') AND ";
    
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGSPRED_WNV='schrumpfkleben' AND ";
    strSelect = strSelect + "EINZELGETR='1' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    strSelect = strSelect + "AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        ECL_EnableValue("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8","T");
        ECL_EnableAttribute("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8");
    }
    else
    {
        ECL_DeselectValue("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8", "T");
        ECL_DisableAttribute("GEKLEBTES_ENDSTUFENRAD_OPTION_2KJ8");
    }
}

function Bestimme_Gehaeusematerial(oData)
{
    //Bestimmung Gehäusematerial
    
    var strSelect = "SELECT DISTINCT EGGEHWS FROM EGGEHWS WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "(EGBEZEI='"+oData.oRow.EGBEZEI+"' OR EGBEZEI='ALL') AND ";
    strSelect = strSelect + "EINZELGETR = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
        
    strSelect = strSelect + "CDROM_REL IN ('1','2') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GEHAEUSEMATERIAL_2KJ8");
    ECL_DeactivateAttribute("GEHAEUSEMATERIAL_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GEHAEUSEMATERIAL_2KJ8",aResult[i].EGGEHWS);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Gehäusematerial! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GEHAEUSEMATERIAL_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("GEHAEUSEMATERIAL_2KJ8", aResultDefault[0].EGGEHWS);
        }
        else
        {
            ECL_SelectValue("GEHAEUSEMATERIAL_2KJ8", aResult[0].EGGEHWS);
        }
    }
}

function Bestimme_KUPPLUNGSHEBEL_AUSFUEHRUNG(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_AUSF FROM EGABAKUPL_AUSF WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8",aResult[i].HEBEL_AUSF);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Ausführung! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8", aResultDefault[0].HEBEL_AUSF);
        }
        else
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8", aResult[0].HEBEL_AUSF);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8");
    }
}

function Bestimme_KUPPLUNGSHEBEL_SCHALTWEG(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_LAGE FROM EGABAKUPL_LAGE WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL='ALL') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8",aResult[i].HEBEL_LAGE);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Schaltweg! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8", aResultDefault[0].HEBEL_LAGE);
        }
        else
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8", aResult[0].HEBEL_LAGE);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_SCHALTWEG_2KJ8");
    }
}

function Bestimme_KUPPLUNGSHEBEL_LAGE(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_GRIFF FROM EGABAKUPL_GRIFF WHERE ";
    strSelect = strSelect + "HEBEL_AUSF='"+ECL_GetValue("KUPPLUNGSHEBEL_AUSFUEHRUNG_2KJ8")+"' AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_LAGE_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_LAGE_2KJ8",aResult[i].HEBEL_GRIFF);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Lage! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_LAGE_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_LAGE_2KJ8", aResultDefault[0].HEBEL_GRIFF);
        }
        else
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_LAGE_2KJ8", aResult[0].HEBEL_GRIFF);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_LAGE_2KJ8") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_LAGE_2KJ8");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_LAGE_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_LAGE_2KJ8");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_LAGE_2KJ8");
    }
}

function Bestimme_OelConsequence()
{
    var strOel=ECL_GetValue("GETRIEBEOEL_2KJ8");
    var strConsequence="";
    if(strOel=="CLP VG220")
        strConsequence="1";
    else if(strOel=="CLPH1 VG100")
        strConsequence="8";
    else if(strOel=="CLP PAO VG220")
        strConsequence="2";
    else if(strOel=="CLPH1 VG460")
        strConsequence="7";
    else if(strOel=="CLP PAO VG68")
        strConsequence="3";
    else if(strOel=="CLP PAO VG460")
        strConsequence="4";
    else if(strOel=="CLP PG VG220")
        strConsequence="6";
    else if(strOel=="CLP VG680")
        strConsequence="0";
    else if(strOel=="CLP PG VG460")
        strConsequence="5";
    else if(strOel=="CLPE VG220")
        strConsequence="9";
    
    ECL_SetValue("ECSI_CC_GearboxOil",strConsequence);
}