//@legacy
//#mode(full-ecma)




function Bestimme_Oberflaechenbehandlung(oData)
{
    // Fest codiert
    ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG_2KJ8");
    ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ8", "LACKIERT");
    ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ8", "UNLACKIERT");
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    
    if(strG115_Type=="WM")
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG_2KJ8", "GRUNDIERT");
    
    var strSelect = "SELECT * FROM FARBE_UNLACKIERT WHERE ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBEMOTOR")
        strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBE.ADAPTER")
        strSelect = strSelect + "MOTTYP='-' AND ";
    
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if ( aResult.length>0 )
    {
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ8","UNLACKIERT");
    }
    else
    {
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG_2KJ8","LACKIERT");
    }
}

function Bestimme_Beschichtung(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT NORM FROM FARBNORM WHERE ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
    strSelect = strSelect + "ATEX='0' AND ";
    strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
    strSelect = strSelect + "REGION IN ('S','SA','SACE','SACEI','SACEMI','SACEMN','SACEMNI','SAM','SAMN','SN') AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
    
    strSelect = strSelect + "FKTSICHERHEIT_KNR='-' ";	
    
    ECL_DeactivateAllAttributeValues("BESCHICHTUNG_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if ( aResult.length > 1 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("BESCHICHTUNG_2KJ8", aResult[i].NORM);
        }
        
        if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")=="GRUNDIERT")
        {
            //Normen für lackiert wieder deaktivieren
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C1");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C2");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C3");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C4");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C5");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "ohne");
        }
        else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")=="LACKIERT")
        {
            //Normen für grundiert wieder deaktivieren
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C2-Grundiert");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C3-Grundiert");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C4-Grundiert");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "C5-Grundiert");
            ECL_DeactivateValue("BESCHICHTUNG_2KJ8", "ohne");
        }
        else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")=="UNLACKIERT")
        {
            ECL_DeactivateAllAttributeValues("BESCHICHTUNG_2KJ8");
            ECL_ActivateValue("BESCHICHTUNG_2KJ8", "ohne");
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Beschichtung! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BESCHICHTUNG_2KJ8"))
    {
        var aResultDefault="";
        if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")=="LACKIERT")
            aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1' AND NORM NOT LIKE '%Grundiert'");
        else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")=="GRUNDIERT")
            aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1' AND NORM LIKE '%Grundiert'");
            
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("BESCHICHTUNG_2KJ8", aResultDefault[0].NORM);
        }
        else if(aResult.length>0)
        {
            var aBeschichtungen=ECL_GetAllActiveAttributeValues("BESCHICHTUNG_2KJ8");
            ECL_SelectValue("BESCHICHTUNG_2KJ8", aBeschichtungen[0]);
        }
        else
            ECL_SelectValue("BESCHICHTUNG_2KJ8", "ohne");
    }
}

function Bestimme_Farbe(oData)
{
    var strSelect = "SELECT DISTINCT RALNR FROM FARBRAL WHERE ";
    strSelect = strSelect + "NORM='"+ECL_GetValue("BESCHICHTUNG_2KJ8")+"' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    strSelect = strSelect + "M3 = '1' AND ";
    strSelect = strSelect + "ATEX='0' AND ";
    strSelect = strSelect + "AKTIV='1' AND ";
    strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
    strSelect = strSelect + "REGION like'S%' AND ";
    
    //erweiterter Standard
    strSelect = strSelect + "CDROM_REL ='1' ";
    
    ECL_DeactivateAllAttributeValues("FARBE_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {	
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("FARBE_2KJ8", aResult[i].RALNR);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Farbe! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("FARBE_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND FARB_MISCH='-' AND DEFLT = '1'");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("FARBE_2KJ8", aResultDefault[0].RALNR);
        }
        else
        {
            ECL_SelectValue("FARBE_2KJ8", aResult[0].RALNR);
        }
    }
}

function istVorbehandlungmoeglich(oData)
{
    //Abhängigkeiten unklar
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8")== "UNLACKIERT")
    {
        //nicht möglich
        ECL_DeselectValue("VORBEHANDLUNG_OPTION_2KJ8", "T");
        ECL_DisableAttribute("VORBEHANDLUNG_OPTION_2KJ8");
    }
    else
    {
        //möglich
        ECL_EnableAttribute("VORBEHANDLUNG_OPTION_2KJ8");
        ECL_EnableValue("VORBEHANDLUNG_OPTION_2KJ8", "T");
    }
}

function istLangzeitkonservierungmoeglich(oData)
{	
    //Für Getriebemotoren
    var strANTRIEB = "0";
    var strMOTOR = "1";
    
    //Für Getriebe mit Adapter
    //var strANTRIEB = "1";
    //var strMOTOR = "0";
    
    var strMotInnenKorrSchutz="nein";
    if(ECL_ValueSelected("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T"))
    {
        strMotInnenKorrSchutz="ja";
    }
    
    var strSelect = "SELECT * FROM KONSERVIERUNG,OELSORTE_M3 WHERE ";
    strSelect = strSelect +"ANTRIEB = '"+strANTRIEB+"' AND ";
    strSelect = strSelect +"MOTOR = '"+strMOTOR+"' AND ";
    strSelect = strSelect +"MOINNENKORSCH = '"+strMotInnenKorrSchutz+"' AND ";
    strSelect = strSelect +"KONSERVIERUNG.KONS_VCI = OELSORTE_M3.KONS_VCI AND ";
    strSelect = strSelect +"OELSORTE = '"+ECL_GetValue("GETRIEBEOEL_2KJ8")+"' AND ";
    strSelect = strSelect +"KONSERVIERUNG.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect +"OELSORTE_M3.AKTIV = '1' AND ";
    strSelect = strSelect +"OELSORTE_M3.G115 = 'ALL' AND ";
    strSelect = strSelect +"MOTOX_N = '0' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        ECL_EnableValue("LANGZEITKONSERVIERUNG_OPTION_2KJ8", "T");
        ECL_EnableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ8");
    }
    else
    {
        ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION_2KJ8", "T");
        ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION_2KJ8");
    }
}

function BestimmeMaengelhaftung(oData)
{
    
    var strAdapterTyp="-";
    var strSelect = "SELECT MAENGELHAFT_KEY FROM M_ADAPTER_M_MAENGELHAFTUNG WHERE ";
    strSelect = strSelect +"ADAP_TYP='"+strAdapterTyp+"' ";
    
    ECL_DeactivateAllAttributeValues("MAENGELHAFTUNG_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("MAENGELHAFTUNG_2KJ8", aResult[i].MAENGELHAFT_KEY);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Mängelhaftung! SQL="+strSelect);
    }
    
    ExecSetStandardifValueEmpty("MAENGELHAFTUNG_2KJ8","0");
}

function Bestimme_Flanschlackierung(oData)
{

    ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH_2KJ8");
    
    if(ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "F" || ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "Z")
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ8", "Standard");
    }
    
    //L11 und L12
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8") != "UNLACKIERT" && (ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "F" || ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ8", "FKL");
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ8", "FLZN");
    }
    
    //L27
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8") != "UNLACKIERT" && ((oData.oRow.EGBEZTYP == "K" || oData.oRow.EGBEZTYP == "B") && ECL_GetValue("BEFESTIGUNGSART_2KJ8") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH_2KJ8", "FLZBN");
    }
    
    var aAttributeValues = ECL_GetAllActiveAttributeValues ("LACKIERUNG_FLANSCH_2KJ8");
    if(aAttributeValues.length>0)
    {
        ECL_ActivateAttribute ("LACKIERUNG_FLANSCH_2KJ8");
        ECL_EnableAttribute("LACKIERUNG_FLANSCH_2KJ8");
        ExecSetStandardifValueEmpty("LACKIERUNG_FLANSCH_2KJ8","Standard");
    }
    else
    {
        ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH_2KJ8");
        ECL_DisableAttribute("LACKIERUNG_FLANSCH_2KJ8");
        ECL_DeactivateAttribute ("LACKIERUNG_FLANSCH_2KJ8");
        ECL_SelectValue("LACKIERUNG_FLANSCH_2KJ8", "Standard");
    }
}