//@legacy
//#mode(full-ecma)



//@import "CFG_2KJ_BREMSE_Model.js"


function Bestimme_Schutzart(oData)
{	
    //Schutzart
    var awhere = new Array();
    awhere.push({SCHUTZART_M3:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({SCHUTZART_M3:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({SCHUTZART_M3:"MOTTYP",Value:oData.oRow.MOTTYP});
    awhere.push({SCHUTZART_M3:"CDROM_REL",Value:'1'});
    awhere.push({SCHUTZART_M3:"EINZELGETR",Value:'1'});
    awhere.push({SCHUTZART_M3:"MOTOR",Value:'1'});
    awhere.push({SCHUTZART_M3:"AKTIV",Value:"1"});
    awhere.push({SCHUTZART_M3:"G110M",Value:"0"});
    awhere.push({SCHUTZART_M3:"SCHUTZART",Value:"IP55;IP65"});
    
    if( ECL_GetValue("ECSI_SPEZIFIKATION_CHECK_2KJ8") ==  "ULR_CSA" )
        awhere.push({SCHUTZART_M3:"SCHUTZART",Value:'IP55;IP65'});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"SCHUTZART_2KJ8",DB:"SCHUTZART"});
    ExecSQL_Standard("2KJ8_DB", "SCHUTZART_M3", aAttributes, awhere);
    
    var aDefaultSQL = " AND DEFLT='1'";
    ExecSQL_GetDefaultStandard("2KJ8_DB", "SCHUTZART_M3", aAttributes, awhere, aDefaultSQL);
}

function Bestimme_Belueftung(oData)
{
    
    // SIZER Vorgabe
    // 0 bedeutet voreingestellt Kunststofflüfter, Metalllüfter und Schwundradlüfter auswählbar
    // 1 bedeutet Fremdlüftung vorgeschrieben
    // 2,3,4 sind nur für Umrichter und dürfen hier nicht kommen.
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT BELLUEFT FROM MOLUEFTER,MOTYPX WHERE ";
    strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
    
    strSelect = strSelect + "MOLUEFTER.BELART = MOTYPX.BELART AND ";
    strSelect = strSelect + "MOLUEFTER.SHWG = MOTYPX.SHWG AND ";
    strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    strSelect = strSelect + Bestimme_MOTYPXFilter(oData);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,"-","");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,strBaseTypeMLFB.left(16),"");
        
        var ForcedVentilationMandatory=find(strBaseTypeMLFB, "M23") > -1;
        var SelfVentilatedMandatory=find(strBaseTypeMLFB, "M23") < 0;
        
        if(oData.oRow.SIZER_CoolingMethod==0 || SelfVentilatedMandatory)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT <> 'Zugeordneter Luefter' AND ";
        else if(oData.oRow.SIZER_CoolingMethod==1 || ForcedVentilationMandatory)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
    
    //MOTYPX_UNDEF mit abfragen
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    

    var	strMOEINKL = "-";
    
    strSelect = strSelect + "AND MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("BELUEFTUNG_2KJ8");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].BELLUEFT == "Schwungradluefter")
                ECL_ActivateValue("BELUEFTUNG_2KJ8",aResult[i].BELLUEFT);
            else if(aResult[i].BELLUEFT == "Metall")
                ECL_ActivateValue("BELUEFTUNG_2KJ8",aResult[i].BELLUEFT);
            else if(aResult[i].BELLUEFT == "Zugeordneter Luefter")
                ECL_ActivateValue("BELUEFTUNG_2KJ8",aResult[i].BELLUEFT);
            else if(aResult[i].BELLUEFT == "Kunststoff")
                ECL_ActivateValue("BELUEFTUNG_2KJ8",aResult[i].BELLUEFT);	
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Befüftungsart!, SQL="+strSelect);
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BELUEFTUNG_2KJ8"))
    {
        ECL_SelectValue("BELUEFTUNG_2KJ8", "Kunststoff");		
    }
}

function Check_Fremdbelueftung(oData)
{
    
    // SIZER Vorgabe
    // 0 bedeutet voreingestellt Kunststofflüfter, Metalllüfter und Schwundradlüfter auswählbar
    // 1 bedeutet Fremdlüftung vorgeschrieben
    // 2,3,4 sind nur für Umrichter und dürfen hier nicht kommen.
    
    var strSelect = "SELECT DISTINCT BELLUEFT FROM MOLUEFTER,MOTYPX WHERE ";
    strSelect = strSelect + "MOLUEFTER.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOLUEFTER.MOBSANB = '"+Bestimme_MobsAnb(oData)+"' AND ";
    
    strSelect = strSelect + "MOLUEFTER.BELART = MOTYPX.BELART AND ";
    strSelect = strSelect + "MOLUEFTER.SHWG = MOTYPX.SHWG AND ";
    strSelect = strSelect + "MOLUEFTER.REGION = 'S' AND ";
    strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        //Abfrage Temperatur
        strSelect = strSelect + "CAST(MOLUEFTER.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    }
    
    strSelect = strSelect + Bestimme_MOTYPXFilter(oData);
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG")
    {
        if(oData.oRow.SIZER_CoolingMethod==0)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT <> 'Zugeordneter Luefter' AND ";
        else if(oData.oRow.SIZER_CoolingMethod==1)
            strSelect = strSelect + "MOLUEFTER.BELLUEFT = 'Zugeordneter Luefter' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOLUEFTER.M3 = '"+oData.oRow.M3+"' ";
    
    //MOTYPX_UNDEF mit abfragen
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = "-";
    
    strSelect = strSelect + "AND MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
        return true;
    else
        return false;
    
}

function Bestimme_MOTYPXFilter(oData)
{
    var strSelect="";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELSDACH = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.UNBELUEFT = '-' AND ";
    
    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTYPX.MOTRLSP = '-' AND ";
    
    if(ECL_ValueSelected("HANDRAD_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOTYPX.M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "MOTYPX.GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    //strSelect = strSelect + "MOTYPX.CDROM_REL='1' AND ";
    strSelect = strSelect + "MOTYPX.REGION IN ('S','SC','SCM','SCMR','SCR','SM','SMC','SCM','SMCI','SMCIR','SMCR','SMR') AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
        
    return (strSelect);
}

function Bestimme_MobsAnb(oData)
{
    if( ECL_ValueSelected("MIT_BREMSE_2KJ8", "T")  && ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ8", "T") )
    {
        return ("BR_2WE");
    }
    else if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        return ("BR");
    }
    else if(ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ8", "T"))
    {
        return ("2WE");
    }
    else
        return ("-");

}

function Bestimme_Klemmkastenlage(oData)
{
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT KKLAGE FROM MOKKLPOS_M3 WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
    strSelect = strSelect + "(EGANFLDM = '"+oData.oRow.EGANFLDM+"' OR EGANFLDM = 'ALL') AND ";
    
    strSelect = strSelect + "KKLAGE NOT IN (";
    strSelect = strSelect + "SELECT DISTINCT KKLAGE FROM MOKKLPOS_UNDEF9 WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "EGBEZWNV='"+Verbindungsart+"' AND ";
    strSelect = strSelect + "EGBEZAWTYP='"+Abtriebswellentyp+"' AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART_2KJ8")+"' OR EGBEZBEF='ALL') AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"') ";
    
    strSelect = strSelect + "ORDER BY KKLAGE ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KLEMMKASTENLAGE_2KJ8");
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KLEMMKASTENLAGE_2KJ8",aResult[i].KKLAGE);
            
            var strImage="";
            if(strG115_Type=="MM")
                strImage="2KJ8\\%LANG%\\motoroptionen\\Anschlusskasten\\"+aResult[i].KKLAGE+".jpg";
            else
                strImage="2KJ8\\%LANG%\\motoroptionen\\Anschlusskasten\\"+aResult[i].KKLAGE+"_"+oData.oRow.EGBEZTYP+".png";
                
            ECL_SetValueImage ("KLEMMKASTENLAGE_2KJ8", aResult[i].KKLAGE, strImage);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Klemmkastenlage!, SQL="+strSelect);
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KLEMMKASTENLAGE_2KJ8"))
    {
        ExecSetStandardifValueEmpty("KLEMMKASTENLAGE_2KJ8","1A");
    }
}

function Bestimme_PAKZUS(oData)
{
    var strMOTBEZ = oData.oRow.MOT_BZ_LANG;
    if(find(strMOTBEZ,"Z") > -1)
        return "Z";
    else
        return "-";	
}

function Bestimme_Kabelverschraubung(oData)
{
    var strMotorstecker="";
    var strGegenstecker="";
    
    if(ECL_GetValue("MOTORSTECKER_2KJ8") != "ohne")
    {
        strMotorstecker = ECL_GetValue("MOTORSTECKER_2KJ8");
        
        strGegenstecker = ECL_GetValue("GEGENSTECKER_2KJ8");
    }
    else
    {
        if(parseInt(oData.oRow.MOTDIM) > 160)
            strMotorstecker = "GG";
        else
            strMotorstecker = "Aluminium";
        strGegenstecker = "ohne";
    }
    
    var strSelect = "SELECT DISTINCT KKVS FROM KKVS_M3 WHERE ";

    var strSpecString=  createSpecString(oData);	
    
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND ";
        strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    
    strSelect = strSelect + "G110M='0' AND ";
    strSelect = strSelect + "ATEX='0' AND ";
    
    strSelect = strSelect + "KKMAT = '"+strMotorstecker+"' AND ";
    strSelect = strSelect + "KKMAT_ZUB = '"+strGegenstecker+"' AND ";
    
    //bisher gibt es nur S und SI
    strSelect = strSelect + "REGION IN ('S','SI') AND ";
    strSelect = strSelect + "AKTIV = '1' ";
    
    ECL_DeactivateAllAttributeValues("KABELVERSCHRAUBUNG_2KJ8");
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {	
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KABELVERSCHRAUBUNG_2KJ8", aResult[i].KKVS);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kabelverschraubung! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KABELVERSCHRAUBUNG_2KJ8"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1'");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KABELVERSCHRAUBUNG_2KJ8", aResultDefault[0].KKVS);
        }
        else
        {
            ECL_SelectValue("KABELVERSCHRAUBUNG_2KJ8", aResult[0].KKVS);
        }
    }
}

function istErdung_moeglich(oData)
{
    //Tabelle MOTERD
    //0 = nicht möglich 1 = möglich 2 = vorgeschrieben
    
    
    var strMOEINKL = "-";
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
        
    var strSelect = "SELECT DISTINCT MOTERD FROM MOTERD WHERE ";
    
    strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL='"+strMOEINKL+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
        strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "REGION = 'S' ";
        
    strSelect = strSelect + "AND CDROM_REL = '1' ";
    strSelect = strSelect + "AND AKTIV = '1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    //Es sollte nur ein Ergebnis geben
    if ( aResult.length == 1 )
    {
        if(aResult[0].MOTERD == "0")
        {
            ECL_DeselectValue("ERDUNGSSCHRAUBE_OPTION_2KJ8", "T");
            ECL_DisableAttribute("ERDUNGSSCHRAUBE_OPTION_2KJ8");
        }
        else if(aResult[0].MOTERD == "1")
        {
            ECL_EnableValue("ERDUNGSSCHRAUBE_OPTION_2KJ8", "T");
            ECL_EnableAttribute("ERDUNGSSCHRAUBE_OPTION_2KJ8");
        }
        else if(aResult[0].MOTERD == "2")
        {
            ECL_EnableValue("ERDUNGSSCHRAUBE_OPTION_2KJ8", "T");
            ECL_SelectValue("ERDUNGSSCHRAUBE_OPTION_2KJ8", "T");
            ECL_DisableAttribute("ERDUNGSSCHRAUBE_OPTION_2KJ8");
        }
        else
        {
            logtraceln("Fehler Bestimmung äußere Erdungsschraube! SQL="+strSelect);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung äußere Erdungsschraube! SQL="+strSelect);
    }
}

function istAnschlusskastenVergossen_moeglich(oData)
{
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT KKABDICH FROM KKABDICH_M3 WHERE ";
    strSelect = strSelect + "ANWTYP = '"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART_2KJ8")+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTELAUSF = '"+strSpecString+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
        
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' ";
    
    var bohneAnschlusskasten_vergossen_moeglich=false;
    var bmitAnschlusskasten_vergossen_moeglich=false;
    ECL_EnableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].KKABDICH=="ohne" || aResult[i].KKABDICH=="Standard")
            {
                bohneAnschlusskasten_vergossen_moeglich=true;
            }
            else if(aResult[i].KKABDICH=="vergossen")
            {
                bmitAnschlusskasten_vergossen_moeglich=true;
            }
        }
    }
    else
    {
        logtraceln("Fehler bei Bestimmung des Anschlusskastens vergossen! SQL="+strSelect);
    } 
    
    if(!bohneAnschlusskasten_vergossen_moeglich && bmitAnschlusskasten_vergossen_moeglich)
    {
        ECL_SelectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8", "T");
        ECL_DisableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8");
    }
    else if(bohneAnschlusskasten_vergossen_moeglich && !bmitAnschlusskasten_vergossen_moeglich)
    {
        ECL_DeselectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8", "T");
        ECL_DisableAttribute("ANSCHLUSSKASTEN_VERGOSSEN_OPTION_2KJ8");
    }
}

function Bestimme_Motorstecker(oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT KKMAT_M3.KKMAT FROM KKMAT_M3,KKMAT_BRANCHE_M3 WHERE ";
    strSelect = strSelect + "KKMAT_M3.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "KKMAT_M3.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "KKMAT_M3.MECH_ZUB = '-' AND ";
    strSelect = strSelect + "KKMAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "KKMAT_M3.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "KKMAT_M3.REGION like 'S%' AND ";
    strSelect = strSelect + "KKMAT_M3.G110M = '0' AND ";
    strSelect = strSelect + "KKMAT_M3.KKMAT != 'HAN Q12-1Buegel+EMV' AND ";
    
    if(strG115_Type=="MM")
    {
        var strCertificates=ECL_GetValue("ECSI_CX_Certificates");
        if(find(strCertificates, "ULR_CSA") > -1)
        {
            strSelect = strSelect + "KKMAT_M3.KKMAT != 'Quickon' AND ";
            strSelect = strSelect + "KKMAT_M3.KKMAT != 'X15' AND ";
        }

        strSelect = strSelect + "G115M = '1' AND ";	
    }
    else if(strG115_Type=="WM")
    {
        strSelect = strSelect + "G115D = '1' AND ";
    }
        
    strSelect = strSelect + "KKMAT_M3.KKMAT=KKMAT_BRANCHE_M3.KKMAT AND ";
    strSelect = strSelect + "KKMAT_BRANCHE_M3.BRANCHE = '"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "KKMAT_BRANCHE_M3.SONDER = '-' AND ";
    strSelect = strSelect + "KKMAT_M3.AKTIV = '1' AND ";
    strSelect = strSelect + "KKMAT_BRANCHE_M3.AKTIV = '1' ";
    
    //weitere UNDEF KKMAT_M3_UNDEF
    var strWIELART = ECL_GetValue("MOTORSCHUTZ_2KJ8");
    
    var strHeizung = "-";
    if(ECL_GetValue("STILLSTANDSHEIZUNG_2KJ8") != "ohne")
        strHeizung =  "mit";
    
    var strBREAUS = "";
    var strBrakeMonitoring = "";
    var strKONSTBREM;
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        strBREAUS = ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8");
        
        //gekapselte Bremse ist "-" in der Tabelle
        if(strBREAUS == "G" || strBREAUS == "GK")
            strBREAUS = "-";
        
        strBrakeMonitoring = ECL_GetValue("BREMSE_UEBERWACHUNG_2KJ8");
        if(strBrakeMonitoring == "MS fuer Luefterkontrolle")
            strBREAUS = "M";
            
        strKONSTBREM = "Kauf";
    }
    else
    {
        strBREAUS = "-";
        strKONSTBREM = "-";
    }
    
    strSelect = strSelect + "AND KKMAT_M3.KKMAT NOT IN ( SELECT KKMAT_M3_UNDEF.KKMAT FROM KKMAT_M3_UNDEF WHERE WIELART = '"+strWIELART+"' AND HEIZUNG = '"+strHeizung+"' AND BREAUS = '"+strBREAUS+"' AND KONSTBREM = '"+strKONSTBREM+"') ";
    
    var KKMAT_KKBRETTBO = Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse);
    strSelect = strSelect +  "AND KKMAT_M3.KKMAT IN "+KKMAT_KKBRETTBO+" ";
    
    ECL_DeactivateAllAttributeValues("MOTORSTECKER_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(!ECL_ValueSelected("SCHUTZART_2KJ8", "IP56"))
    {
        if(aResult.length>0)
        {
            for(var i=0;i<aResult.length;i++)
            {
                var strKKMAT=aResult[i].KKMAT;
                ECL_ActivateValue("MOTORSTECKER_2KJ8",strKKMAT);
            }
        }
        else
            logtraceln("Fehler bei Bestimmung Motorstecker!, SQL="+strSelect);
    }
    else
        logtraceln("Motorstecker nicht nmöglich (IP56)!, SQL="+strSelect);
    
    
    //Jetzt Kabelverschraubung
    /*
    var strSelect2 = "SELECT DISTINCT KKVS FROM KKVS_M3 WHERE ";

    var strSpecString=  createSpecString(oData);	
    
    strSelect2 = strSelect2 + "MOTELAUSF = '"+strSpecString+"' AND ";
    strSelect2 = strSelect2 + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect2 = strSelect2 + "G110M='0' AND ";
    strSelect2 = strSelect2 + "ATEX='0' AND ";
    
    strSelect2 = strSelect2 + "KKMAT IN ('Verschl.stopfen M25','Aluminium','GG') AND ";
    strSelect2 = strSelect2 + "KKMAT_ZUB = 'ohne' AND ";
    
    //bisher gibt es nur S und SI
    strSelect2 = strSelect2 + "REGION IN ('S','SI') AND ";
    strSelect2 = strSelect2 + "AKTIV = '1' ";
    
    var aResult2 = ExecSQL_Standard_SO("2KJ8_DB", strSelect2);
    if ( aResult2.length > 0 )
    {	
        for(var i=0;i<aResult2.length;i++)
        {
            ECL_ActivateValue("MOTORSTECKER_2KJ8", aResult2[i].KKVS);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kabelverschraubung! SQL="+strSelect2);
    }
    */
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("MOTORSTECKER_2KJ8"))
    {
        var aResultDefault2 = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1'");
        if(aResultDefault2.length>0)
        {
            ECL_SelectValue("MOTORSTECKER_2KJ8", aResultDefault2[0].KKMAT);
        }
        else
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ8_DB", strSelect+" AND DEFLT = '1'");
            if(aResultDefault.length>0)
            {
                var strKKMAT=aResultDefault[0].KKMAT;
                ECL_SelectValue("MOTORSTECKER_2KJ8", strKKMAT);
            }
            else if(aResult.length>0)
            {
                var strKKMAT=aResult[0].KKMAT;
                ECL_SelectValue("MOTORSTECKER_2KJ8", strKKMAT);
            }
            else
            {
                ECL_SelectValue("MOTORSTECKER_2KJ8", aResult2[0].KKVS);
            }
        }
    }	
}

function Bestimme_Motorstecker_Gegenstecker(oData,oDataBremse)
{
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT KKMAT_ZUB FROM KKMAT_M3 WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MECH_ZUB = '-' AND ";
    strSelect = strSelect + "KKMAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "KKMAT_M3.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
        
    strSelect = strSelect + "REGION like 'S%' AND ";
    strSelect = strSelect + "KKMAT = '"+strKKMAT+"' AND ";
    strSelect = strSelect + "G110M = '0' ";
    
    //weitere UNDEF KKMAT_M3_UNDEF
    var strWIELART = ECL_GetValue("MOTORSCHUTZ_2KJ8");
    
    var strHeizung = "-";
    if(ECL_GetValue("STILLSTANDSHEIZUNG_2KJ8") != "ohne")
        strHeizung =  "mit";
    
    var strBREAUS = "";
    var strBrakeMonitoring = "";
    var strKONSTBREM;
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        strBREAUS = ECL_GetValue("BREMSE_AUSFUEHRUNG_2KJ8");
        
        //gekapselte Bremse ist "-" in der Tabelle
        if(strBREAUS == "G" || strBREAUS == "GK")
            strBREAUS = "-";
        
        strBrakeMonitoring = ECL_GetValue("BREMSE_UEBERWACHUNG_2KJ8");
        if(strBrakeMonitoring == "MS fuer Luefterkontrolle")
            strBREAUS = "M";
            
        strKONSTBREM = "Kauf";
    }
    else
    {
        strBREAUS = "-";
        strKONSTBREM = "-";
    }
    
    strSelect = strSelect + "AND KKMAT NOT IN ( SELECT KKMAT FROM KKMAT_M3_UNDEF WHERE WIELART = '"+strWIELART+"' AND HEIZUNG = '"+strHeizung+"' AND BREAUS = '"+strBREAUS+"' AND KONSTBREM = '"+strKONSTBREM+"') ";
    
    var KKMAT_KKBRETTBO = Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse);
    strSelect = strSelect +  "AND KKMAT IN "+KKMAT_KKBRETTBO+" ";
    
    ECL_DeactivateAllAttributeValues("GEGENSTECKER_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(!ECL_ValueSelected("SCHUTZART_2KJ8", "IP56"))
    {
        if(aResult.length>0)
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("GEGENSTECKER_2KJ8",aResult[i].KKMAT_ZUB);
            }
        }
        else
            logtraceln("Fehler bei Bestimmung Motorstecker Gegenstecker!, SQL="+strSelect);
    }
    else
        logtraceln("Motorstecker Gegenstecker nicht nmöglich (IP56)!, SQL="+strSelect);
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GEGENSTECKER_2KJ8"))
    {
        ExecSetStandardifValueEmpty("GEGENSTECKER_2KJ8","ohne");
    }
}

function Bestimme_GrenzwerteStromundSpannung(oData,oDataBremse)
{
    var strSpecString=  createSpecString(oData);	
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG_2KJ8");
        
    var strSelect="SELECT DISTINCT MOT_KEY,MOT_SCHALTUNG FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART_2KJ8")+"' AND ";
    strSelect = strSelect + "MLFB_13='"+ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_MLFB_2KJ8")+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE_2KJ8")+"' ";
    
    var minSpannung=99999;
    var maxSpannung=0;
    var minStrom=99999;
    var maxStrom=0;
    
    var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    var strMOT_KEY="";
    var strMOT_Schaltung="";
    if(aResultTable.length>0)
    {
        strMOT_KEY=aResultTable[0].MOT_KEY;
        strMOT_Schaltung=aResultTable[0].MOT_SCHALTUNG;
        var strSelect="SELECT DISTINCT MOT_SPANNUNG1,MOT_SPANNUNG2,MOT_BSTROM1,MOT_BSTROM2 FROM TMP_MOT_DATEN WHERE ";
        strSelect = strSelect + "MOT_KEY = '"+strMOT_KEY+"' ";
        var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResultTable.length>0)
        {
            //Bestimmung von Min und Max Strom und Spannung
            for(var i=0;i<aResultTable.length;i++)
            {
                if(minStrom > parseFloat(aResultTable[i].MOT_BSTROM1) && parseFloat(aResultTable[i].MOT_BSTROM1) != 0 )
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM1))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if( minStrom > parseFloat(aResultTable[i].MOT_BSTROM2) && parseFloat(aResultTable[i].MOT_BSTROM2) != 0)
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM2))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG1) && parseFloat(aResultTable[i].MOT_SPANNUNG1) != 0)
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG1))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG2) && parseFloat(aResultTable[i].MOT_SPANNUNG2) != 0)
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG2))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
            }

            /*
            //Bestimmung von Min und Max Strom und Spannung
            for(var i=0;i<aResultTable.length;i++)
            {
                if(minStrom > parseFloat(aResultTable[i].MOT_BSTROM1))
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM1))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM1);
                
                if( minStrom > parseFloat(aResultTable[i].MOT_BSTROM2))
                    minStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if(maxStrom < parseFloat(aResultTable[i].MOT_BSTROM2))
                    maxStrom = parseFloat(aResultTable[i].MOT_BSTROM2);
                    
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG1))
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG1))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG1);
                
                if( minSpannung > parseFloat(aResultTable[i].MOT_SPANNUNG2))
                    minSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
                if(maxSpannung < parseFloat(aResultTable[i].MOT_SPANNUNG2))
                    maxSpannung = parseFloat(aResultTable[i].MOT_SPANNUNG2);
                    
            }
            */
        }
    }
    
    logtraceln("min Spannung="+minSpannung+",max Spannung="+maxSpannung+",min Strom="+minStrom+",max Strom="+maxStrom);
    
    //mögliche KKMAT aus KKBRETTBO
    
    var strBRESHT="ALL";
    var strBremse="-";
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        strBremse="KAUF";
        strBRESHT = Bestimme_BREMSE_BRESHLT(oData,oDataBremse);
    }
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect = "SELECT DISTINCT KKMAT FROM KKBRETTBO WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "(BRESHLT = '"+strBRESHT+"' OR BRESHLT='ALL') AND ";
    strSelect = strSelect + "(KONSTABREM = '"+strBremse+"' OR KONSTABREM='ALL') AND ";
    strSelect = strSelect + "(MOTSHLT = '"+strMOT_Schaltung+"' OR MOTSHLT='ALL') AND ";
    strSelect = strSelect + "REGION = 'S' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    
    strSelect = strSelect + "POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "CAST(MOTSPG_BMIN AS FLOAT) <= '"+minSpannung+"' AND ";
    strSelect = strSelect + "CAST(MOTSPG_BMAX AS FLOAT) >= '"+maxSpannung+"' AND ";
    strSelect = strSelect + "CAST(MIN_BSTROM AS FLOAT) <= '"+minStrom+"' AND ";
    strSelect = strSelect + "CAST(MAX_BSTROM AS FLOAT) >= '"+maxStrom+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    var strKKMATMENGE="(";
    if(aResultTable.length>0)
    {
        //Bestimmung von Min und Max Strom und Spannung
        for(var i=0;i<aResultTable.length;i++)
        {
            strKKMATMENGE = strKKMATMENGE + "'"+aResultTable[i].KKMAT+"',";
        }
    }
    else
    {
        logtraceln("SQL für KKMAT Überprüfung Strom und Spannung, SQL="+strSelect);
    }
    
    strKKMATMENGE = trimright(strKKMATMENGE,",");
    strKKMATMENGE = strKKMATMENGE+")";
    
    logtraceln("KKMAT MENGE="+strKKMATMENGE);
    return strKKMATMENGE;
}

function Bestimme_MotorConsequences_Schutzart(oData)
{
    var strSchutzart=ECL_GetValue("SCHUTZART_2KJ8");
    strSchutzart = replace(strSchutzart,"IP","")
        
    ECL_SetValue("ECSI_CC_IpProtectionLevelMotor", strSchutzart);
}