//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

//@import "CFG_2KJ_MECHANISCHE_AUSFUEHRUNG_Model.js"

    
function Bestimme_MotorRLSP(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
        
    strSelect = strSelect + "MOTRLSP = 'X' AND ";
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";
        
    if(ECL_ValueSelected("HANDRAD_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";

    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELSDACH = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    strSelect = strSelect + "MOTYPX.REGION IN ('S','SC','SCM','SM','SMC','SCM','SMCI') AND ";
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"') ";
        
    
    var strSelect2="";
    
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T") || ECL_ValueSelected("LANGZEITKONSERVIERUNG_OPTION_2KJ8", "T"))
    {
        //erste Abhängigkeiten
        ECL_DeselectValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T");
        ECL_DisableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if(aResult.length>0)
        {
        
            //Rücklaufsperre möglich
            ECL_EnableValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T");
            ECL_EnableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8");
        
        }
        else
        {
            ECL_DeselectValue("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T");
            ECL_DisableAttribute("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8");
        }
    }
}

function Bestimme_AbtriebsDrehrichtung(oData,what)
{

    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS;
    strEGTYP = replace(strEGTYP, "-", "");
    
    if(what == "MOTOR")
    {
        var strSelect = "SELECT DISTINCT ANTRIEBSDREHRICHTUNG_MOTOR FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
        
        if(strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' AND ";
        
        if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8") == "links")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8") == "rechts")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CW' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResult.length==1)
        {
            var strRichtung = aResult[0].ANTRIEBSDREHRICHTUNG_MOTOR;
            
            if(strRichtung == "CW")
            {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_2KJ8", "rechts");
            }
            else
            {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_2KJ8", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Motor, SQL="+strSelect);
    }
    else //Getriebe
    {
        var strSelect = "SELECT DISTINCT ABTRIEBSDREHRICHTUNG_GETRIEBE FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '"+strEGTYP+"' AND ";
        
        if(strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '"+ECL_GetValue("ABTRIEBSSEITE_2KJ8")+"' AND ";
        
        if(ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ8") == "links")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CCW' ";
        else if(ECL_GetValue("DREHRICHTUNG_MOTOR_2KJ8") == "rechts")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CW' ";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResult.length==1)
        {
            var strRichtung = aResult[0].ABTRIEBSDREHRICHTUNG_GETRIEBE;
            
            if(strRichtung == "CW")
            {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8", "rechts");
            }
            else
            {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_2KJ8", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Getriebe, SQL="+strSelect);
    }
}


function Bestimme_MotorZweitesWellenende(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOZWE WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' AND ";
    strSelect = strSelect + "MOZWE.S09 = '"+oData.oRow.S09+"' AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
    
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    
    strSelect = strSelect + "REGION IN ('S','SC') ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8")=="Zugeordneter Luefter")
    {
        ECL_DeselectValue("ZWEITES_WELLENENDE_OPTION_2KJ8", "T");
        ECL_DisableAttribute("ZWEITES_WELLENENDE_OPTION_2KJ8");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("ZWEITES_WELLENENDE_OPTION_2KJ8", "T");
            ECL_EnableAttribute("ZWEITES_WELLENENDE_OPTION_2KJ8");
        }
        else
        {
            ECL_DeselectValue("ZWEITES_WELLENENDE_OPTION_2KJ8", "T");
            ECL_DisableAttribute("ZWEITES_WELLENENDE_OPTION_2KJ8");
        }
    }
}

function Bestimme_MotorHandrad(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    
    strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";

    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTRLSP = '-' AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION_2KJ8", "T"))
        strSelect = strSelect + "BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "BELSDACH = '-' AND ";
            
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    //strSelect = strSelect + "MOTYPX.CDROM_REL='1' AND ";
    strSelect = strSelect + "MOTYPX.REGION IN ('S','SC','SCM','SM','SMC','SCM','SMCI') AND ";
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"') ";
    
    if(!ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ8", "T"))
    {
        //Handrad nur bei zweitem Wellenende
        ECL_DeselectValue("HANDRAD_OPTION_2KJ8", "T");
        ECL_DisableAttribute("HANDRAD_OPTION_2KJ8");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("HANDRAD_OPTION_2KJ8", "T");
            ECL_EnableAttribute("HANDRAD_OPTION_2KJ8");
        }
        else
        {
            ECL_DeselectValue("HANDRAD_OPTION_2KJ8", "T");
            ECL_DisableAttribute("HANDRAD_OPTION_2KJ8");
        }
    }
}

function Bestimme_MotorSchutzdach(oData)
{
    var strSelect = "SELECT DISTINCT * FROM MOTYPX WHERE ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Zugeordneter Luefter")
        strSelect = strSelect + "BELART = 'F' AND ";
    else
        strSelect = strSelect + "BELART = '-' AND ";
    
    if(ECL_GetValue("BELUEFTUNG_2KJ8") == "Schwungradluefter")
        strSelect = strSelect + "SHWG = 'I' AND ";
    else
        strSelect = strSelect + "SHWG = '-' AND ";

    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTRLSP = '-' AND ";
    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S")
            strHEMOTOR="S";
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    strSelect = strSelect + "BELSDACH = 'W' AND ";
    
    if(ECL_ValueSelected("HANDRAD_OPTION_2KJ8", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
    
    strSelect = strSelect + "MOTYPX.G110M='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    //strSelect = strSelect + "MOTYPX.CDROM_REL='1' AND ";
    strSelect = strSelect + "MOTYPX.REGION IN ('S','SC','SCM','SCMR','SCR','SM','SMC','SMCI','SMCIR','SMR') AND ";
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
        
    var strMOEINKL = "-";

    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN (SELECT DISTINCT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL_2KJ8")+"' OR POLZAHL = '-') AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"') ";
    
    var strSelect2="";
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    if(ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION_2KJ8", "T"))
    {
        ECL_DeselectValue("SCHUTZDACH_OPTION_2KJ8", "T");
        ECL_DisableAttribute("SCHUTZDACH_OPTION_2KJ8");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("SCHUTZDACH_OPTION_2KJ8", "T");
            ECL_EnableAttribute("SCHUTZDACH_OPTION_2KJ8");
    
        }
        else
        {
            ECL_DeselectValue("SCHUTZDACH_OPTION_2KJ8", "T");
            ECL_DisableAttribute("SCHUTZDACH_OPTION_2KJ8");
        }
    }
}

function Bestimme_MotorKondenswasserbohrung(oData)
{	
    var strPAKZUS = Bestimme_PAKZUS(oData);
    
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strSelect = "SELECT * FROM MOKOWALO WHERE ";
    strSelect = strSelect + "(EGBEZDIM = '"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM = 'ALL') AND ";
    strSelect = strSelect + "(EGPOSHL = '"+ECL_GetValue("BAUFORM_2KJ8")+"' OR EGPOSHL = 'ALL') AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOABFLDM = '"+oData.oRow.EGANFLDM+"' AND ";
    strSelect = strSelect + "MOABSSART = '"+strMOABSSART+"' AND ";
    strSelect = strSelect + "PAKZUS='"+strPAKZUS+"' AND ";
    strSelect = strSelect + "SCHUTZART = '"+ECL_GetValue("SCHUTZART_2KJ8")+"' AND ";
    strSelect = strSelect + "(MOKOWALO_AS = '1' OR MOKOWALO_BS = '1') AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
    
    strSelect = strSelect + "SONDER = '-' AND ";
    strSelect = strSelect + "AKTIV = '1' ";
    
    //Kondenswasserbohrung bei Sondereinbaulage nicht möglich
    
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
    if ( aResult.length > 0 )
    {
        ECL_EnableValue("KONDENSWASSERBOHRUNG_OPTION_2KJ8", "T");
        ECL_EnableAttribute("KONDENSWASSERBOHRUNG_OPTION_2KJ8");
    }
    else
    {
        ECL_DeselectValue("KONDENSWASSERBOHRUNG_OPTION_2KJ8", "T");
        ECL_DisableAttribute("KONDENSWASSERBOHRUNG_OPTION_2KJ8");
    }
}

function Bestimme_MotorInnenkorrosionsschutz(oData)
{	
    var strSelect = "SELECT DISTINCT MOINNENKORSCH FROM MOINNENKORSCH WHERE ";
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "ATEX = '0' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE_2KJ8") == "SIZER_CONFIG"){
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";

        if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
        {
            strSelect = strSelect + "CAST(UMGEB_TEMP_MIN AS INT) <= -30 AND ";
        }
    }
    
    //BRANCHE abfragen
    if(oData.oRow.ANWTYP=="Kuehlturm")
        strSelect = strSelect + "BRANCHE = 'Kuehlturm' AND ";
    else if(oData.oRow.ANWTYP=="Haengebahn")
        strSelect = strSelect + "BRANCHE = 'Haengebahn' AND ";
    else
        strSelect = strSelect + "BRANCHE = 'Standard' AND ";
    
    strSelect = strSelect + "FKTSICHERHEIT = '-' AND ";
        
    strSelect = strSelect + "REGION IN ('S','SC') "
    
    if(ECL_GetValue("WAERMEKLASSE_2KJ8")=="H")
    {
        ECL_DeselectValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T");
        ECL_DisableAttribute("INNENKORROSIONSSCHUTZ_OPTION_2KJ8");
    }
    else
    {
        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
        var Abwahlmoeglich=false;
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                if(aResult[i].MOINNENKORSCH=="ja")
                {
                    ECL_EnableValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T");
                }
                else
                {
                    Abwahlmoeglich=true;
                }
            }
        }
        else
        {
            logtraceln("Fehler bei Bestimmung des Motorinnenkorrosionschutzes! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(!Abwahlmoeglich && ECL_ValueEnabled("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T"))
        {
            ECL_SelectValue("INNENKORROSIONSSCHUTZ_OPTION_2KJ8", "T");
        }
            
    }
}
