//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function Bestimme_G115D_Kommunikation(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strSelect="SELECT DISTINCT G115_BUSSYSTEM FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
        
    ECL_DeactivateAllAttributeValues("G115_KOMMUNIKATION_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("G115_KOMMUNIKATION_2KJ8",aResult[i].G115_BUSSYSTEM);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Kommunikation G115D!, SQL="+strSelect);
    
    
    var strContextFieldBusInterface=ECL_GetValue("ECSI_CX_FieldbusInterface");
    if(strContextFieldBusInterface && (strContextFieldBusInterface =="0" || strContextFieldBusInterface == "2"))
    {
        if(strContextFieldBusInterface =="0")
            ECL_SetValue("G115_KOMMUNIKATION_2KJ8", "Profinet");
        else if(strContextFieldBusInterface =="2")
            ECL_SetValue("G115_KOMMUNIKATION_2KJ8", "AS-i");
        
        ECL_DisableAttribute("G115_KOMMUNIKATION_2KJ8");
    }
    else
    {
        ECL_EnableAttribute("G115_KOMMUNIKATION_2KJ8");
    }
    
    ExecSetStandardifValueEmpty("G115_KOMMUNIKATION_2KJ8","Profinet");	
}

function Bestimme_G115D_24V_Versorgung(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strSelect="SELECT DISTINCT G115_EXTANB FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
            
    ECL_DeactivateAllAttributeValues("G115_VERSORGUNG_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("G115_VERSORGUNG_2KJ8",aResult[i].G115_EXTANB);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung 24 Versorgung G115D!, SQL="+strSelect);
        
    ExecSetStandardifValueEmpty("G115_VERSORGUNG_2KJ8","ohne");	
}

function Bestimme_G115D_24V_Versorgung_INTERN(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strSelect="SELECT DISTINCT G115_INTERN_24V FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";
    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' AND ";
    strSelect=strSelect+"G115_INTERN_24V='24VDC' ";
             
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        
    if ( aResult.length > 0 )
    {
        ECL_EnableValue("G115_VERSORGUNG_INTERN_2KJ8", "T");
        ECL_EnableAttribute("G115_VERSORGUNG_INTERN_2KJ8");
    }
    else
    {
        ECL_DeselectValue("G115_VERSORGUNG_INTERN_2KJ8", "T");
        ECL_DisableAttribute("G115_VERSORGUNG_INTERN_2KJ8");
    }
}

function Bestimme_G115D_Anschluss(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var aKKMAT=ECL_GetAllActiveAttributeValues("MOTORSTECKER_2KJ8");
    var aKKMAT_ZUB=ECL_GetAllActiveAttributeValues("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strKKMAT="(";
    for(var i=0;i<aKKMAT.length;i++)
    {
        strKKMAT=strKKMAT+"'"+aKKMAT[i]+"',";
    }
    
    strKKMAT= trimright(strKKMAT,",");
    strKKMAT=strKKMAT+")";
    
    var strSelect="SELECT DISTINCT G115_BUSSYSTEM_VS FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT IN "+strKKMAT+" AND ";
    //strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";
    
    // V71 interne Versorgung
    if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
    {
        strSelect=strSelect+"G115_INTERN_24V='24VDC' AND ";
    }
    else
    {
        strSelect=strSelect+"G115_INTERN_24V='-' AND ";
    }

    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
        
    ECL_DeactivateAllAttributeValues("G115_ANSCHLUSS_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("G115_ANSCHLUSS_2KJ8",replace(aResult[i].G115_BUSSYSTEM_VS,'"','_Zoll'));
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Kommunikation Anschluss G115D!, SQL="+strSelect);
        
    ExecSetStandardifValueEmpty("G115_ANSCHLUSS_2KJ8","M12");	
}

function Bestimme_G115D_Anschluss_NEU(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var aKKMAT=ECL_GetAllActiveAttributeValues("MOTORSTECKER_2KJ8");
    var aKKMAT_ZUB=ECL_GetAllActiveAttributeValues("GEGENSTECKER_2KJ8");
    
    var strKKMAT="(";
    for(var i=0;i<aKKMAT.length;i++)
    {
        strKKMAT=strKKMAT+"'"+aKKMAT[i]+"',";
    }
    
    strKKMAT= trimright(strKKMAT,",");
    strKKMAT=strKKMAT+")";
    
    
    var strSelect="SELECT DISTINCT G115_KLEMMK_KOMBINATION FROM M_G115_KLEMMK_M_ANSCHLUSS,G115_BUSSY_VS_M_G115_INTERN_24V WHERE "
    strSelect=strSelect+"M_G115_KLEMMK_M_ANSCHLUSS.MOT_KLEMMK_AUSF_KEY IN "+strKKMAT+" AND ";
    //strSelect=strSelect+"MOT_KLEMMK_ZUB_KEY IN '"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "M_G115_KLEMMK_M_ANSCHLUSS.PRODUKT_G115_KNZ = 'M' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "M_G115_KLEMMK_M_ANSCHLUSS.PRODUKT_G115_KNZ = 'W' AND ";
    
    strSelect=strSelect+"M_G115_KLEMMK_M_ANSCHLUSS.G115_BUSSY_KEY='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"M_G115_KLEMMK_M_ANSCHLUSS.G115_EXTANB_KEY='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

    // V71 interne Versorgung
    if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
    {
        strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='24VDC' AND ";
    }
    else
    {
        strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='-' AND ";
    }

    strSelect=strSelect+ "M_G115_KLEMMK_M_ANSCHLUSS.G115_BUSSY_VS_KEY = G115_BUSSY_VS_M_G115_INTERN_24V.G115_BUSSY_VS_KEY";
        
    ECL_DeactivateAllAttributeValues("G115_ANSCHLUSSTECHNIK_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("G115_ANSCHLUSSTECHNIK_2KJ8",aResult[i].G115_KLEMMK_KOMBINATION);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Kommunikation Anschluss NEU G115D!, SQL="+strSelect);
        
    ExecSetStandardifValueEmpty("G115_ANSCHLUSSTECHNIK_2KJ8","VS");	
}

function Bestimme_G115D_Kommunikation_Position(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strSelect="SELECT DISTINCT G115_BUSSYSTEM_POS FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

    // V71 interne Versorgung
    if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
    {
        strSelect=strSelect+"G115_INTERN_24V='24VDC' AND ";
    }
    else
    {
        strSelect=strSelect+"G115_INTERN_24V='-' AND ";
    }

    strSelect=strSelect+"G115_BUSSYSTEM_VS='"+replace(ECL_GetValue("G115_ANSCHLUSS_2KJ8"),'_Zoll','"')+"' AND ";
    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
        
    ECL_DeactivateAllAttributeValues("G115_POSITION_KOMM_2KJ8");
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("G115_POSITION_KOMM_2KJ8",aResult[i].G115_BUSSYSTEM_POS);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Kommunikation Position G115D!, SQL="+strSelect);
        
    ExecSetStandardifValueEmpty("G115_POSITION_KOMM_2KJ8","links");	
}

function SetzeKKMAT(oData,oDataBremse)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSelect="SELECT DISTINCT MOT_KLEMMK_AUSF_KEY,MOT_KLEMMK_ZUB_KEY FROM M_G115_KLEMMK_M_ANSCHLUSS,G115_BUSSY_VS_M_G115_INTERN_24V WHERE "
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "PRODUKT_G115_KNZ = 'M' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "PRODUKT_G115_KNZ = 'W' AND ";
    
    strSelect=strSelect+"G115_BUSSY_KEY='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_KLEMMK_KOMBINATION='"+ECL_GetValue("G115_ANSCHLUSSTECHNIK_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB_KEY='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

     // V71 interne Versorgung
     if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
     {
         strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='24VDC' AND ";
     }
     else
     {
         strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='-' AND ";
     }
 
     strSelect=strSelect+ "M_G115_KLEMMK_M_ANSCHLUSS.G115_BUSSY_VS_KEY = G115_BUSSY_VS_M_G115_INTERN_24V.G115_BUSSY_VS_KEY";
        
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        ECL_SetValue("MOTORSTECKER_2KJ8",aResult[0].MOT_KLEMMK_AUSF_KEY);
        Bestimme_Motorstecker_Gegenstecker(oData,oDataBremse);
        ECL_SetValue("GEGENSTECKER_2KJ8",aResult[0].MOT_KLEMMK_ZUB_KEY);
    }
    else
        logtraceln("Fehler beim Setzen des KKMAT (G115) !, SQL="+strSelect);
        
}

function SetzeAnschluss(oData)
{
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    
    var strSelect="SELECT DISTINCT M_G115_KLEMMK_M_ANSCHLUSS.G115_BUSSY_VS_KEY FROM M_G115_KLEMMK_M_ANSCHLUSS,G115_BUSSY_VS_M_G115_INTERN_24V WHERE "
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "PRODUKT_G115_KNZ = 'M' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "PRODUKT_G115_KNZ = 'W' AND ";
    
    strSelect=strSelect+"MOT_KLEMMK_AUSF_KEY='"+strKKMAT+"' AND ";
    strSelect=strSelect+"MOT_KLEMMK_ZUB_KEY='"+strKKMAT_ZUB+"' AND ";
    strSelect=strSelect+"G115_BUSSY_KEY='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_KLEMMK_KOMBINATION='"+ECL_GetValue("G115_ANSCHLUSSTECHNIK_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB_KEY='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

     // V71 interne Versorgung
     if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
     {
         strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='24VDC' AND ";
     }
     else
     {
         strSelect=strSelect+"G115_BUSSY_VS_M_G115_INTERN_24V.G115_INTERN_24V_KEY='-' AND ";
     }
 
     strSelect=strSelect+ "M_G115_KLEMMK_M_ANSCHLUSS.G115_BUSSY_VS_KEY = G115_BUSSY_VS_M_G115_INTERN_24V.G115_BUSSY_VS_KEY";
        
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length>0)
    {
        ECL_SetValue("G115_ANSCHLUSS_2KJ8",replace(aResult[0].G115_BUSSY_VS_KEY,'"','_Zoll'));
    }
    else
        logtraceln("Fehler beim Setzen des Anschluss (G115) !, SQL="+strSelect);
        
}