//@legacy
//#mode(full-ecma)


function RoundMotox( Value,MassSys,Unit )
{
    //Wert als double!
    var dValue = parseFloat(replace(String(Value),",","."));
    
    //Wert als String mit Komma!
    var strValue = String(Value);
    strValue = replace(strValue,".",",");
    
    var retValue;
    
    //Rundungsregeln für Siemens Geared Motors
    if(Unit == "DREHMOMENT")
    {
        /*
        if(MassSys == "US")
        {	
            var Torque		= checkObject(null, 'DREHMOMENT', 	dValue, 'Nm');
            dValue = getValueAsNumber( Torque, "lb.in" );
            
            strValue = String(dValue);
            strValue = replace(strValue,".",",");
        }
        */
        
        var sgn_f=1;
        var R;
        var tmpWert;
        
        if(dValue < 0)
            sgn_f = -1;
        
        dValue = dValue * sgn_f;
        
        if(dValue >= 0 && dValue <= 10)
        {
            R=0.1;
        }
        else if(dValue > 10 && dValue <= 200)
        {
            R=1.0;
        }
        else if(dValue > 200 && dValue <= 1000)
        {
            R=5.0;
        }
        else if(dValue > 1000 && dValue <= 10000)
        {
            R=10.0;
        }
        else
        {
            R=100.0;
        }
        
        tmpWert = parseInt(dValue/R)*sgn_f;
        tmpWert = tmpWert*R;
        
        return(tmpWert);
    }
    else if(Unit == "DREHZAHL")
    {
        if(dValue >= 0 && dValue < 1)
        {
            retValue = Runden(dValue,2);
        }
        else if(dValue >= 1 && dValue < 10)
        {
            retValue = Runden(dValue,1);
        }
        else if(dValue >= 10)
        {
            retValue = Runden(dValue,0);
        }
    }
    else if(Unit == "BETRIEBSFAKTOR")
    {
        if(dValue >= 0 && dValue < 2)
        {
            retValue = Runden(dValue,2);
        }
        else if(dValue >= 2 && dValue < 10)
        {
            retValue = Runden(dValue,1);
        }
        else if(dValue >= 10)
        {
            retValue = Runden(dValue,0);
        }
    }
    else if(Unit == "STROM")
    {
        if(dValue >= 0 && dValue < 2)
        {
            retValue = Runden(dValue,2);
        }
        else if(dValue >= 2 && dValue < 5)
        {
            retValue = Runden(dValue,1);
        }
        else if(dValue >= 5 && dValue < 10)
        {
            retValue = Runden(dValue,0);
        }
        else if(dValue >= 10)
        {
            retValue = Runden(dValue,0);
        }
    }
    
    
    if(MassSys == "SI")
        retValue = replace(retValue, ".", ",");
    else if(MassSys == "US")
        retValue = replace(retValue, ",", ".");
        
    
    return(retValue);
}

// Runden auf "Precision" Stellen
function Runden(dValue,Precision)
{
    var retValue;

    if(Precision == 0)
        retValue = String(parseInt(dValue));
    else if(Precision == 1)
        retValue = String(parseInt(dValue*10)/10);
    else if(Precision == 2)
        retValue = String(parseInt(dValue*100)/100);
    else if(Precision == 3)
        retValue = String(parseInt(dValue*1000)/1000);
    
    return(retValue);
}

/**
 * @category   Utils
 * @package    TechValues
 * @copyright  Copyright (c) 2009 Plan Software GmbH (http://www.plansoft.de)
 *
 */

/*
    Eine detailliertere Beschreibung des ganzen Konzepts befindet sich in TechValues.js auf der Client-Side.
    Hier eine Zusammenfassung der Stellen, an denen etwas getan werden muss, wenn ein Techwert im GUI erscheinen
    soll:
    
    A) Im Client:
        1) Bei der Definition des Eingabefelds: Dieses als Textfield deklarieren.
            Grund: wir wollen auch "," zulassen. 
            @@@ STILL  TODO: wir brauchen hier eine Komponente, die nur Zahlen sowie +-,. als Eingaben zulaesst
        2) Bei der Definition der Combo für die Einheiten:
            - Einen Store hinterlegen, den wir aus dem Init-Ajax-Request füllen können, z.B.:
                storeFuerDieCombo = new Ext.data.SimpleStore({
                    id: 'id',
                    fields: [
                        'id', 'displayValue'
                    ]
                });	
            
            - Eine Select-Handler Funktion hinterlegen, mit in etwas folgendem Inhalt:
                var inputField = Ext.getCmp(...);
                convertTechField(inputField, 'TEMPERATUR', varComboSelected, value.data.id);
                varComboSelected = value.data.id;
              Dieser Code dient dazu, bei einem Umschalten der Aufklappliste direkt den Wert umzurechnen.
              value.data.id ist dabei die ID der neu selektierten Einheit.
              'TEMPERATUR' ist als Beispiel zu sehen, es ist das Einheitenprofil für diese Combo
              varComboSelected ist eine Variable für diesen Dialog, in der wir immer die aktuell selektierte Einheiten
              speichern. Grund: Nach einer Selektion durch den Anwender brauchen wir hier die neue und die vorherige
              Selektion.
        3)	Definiton von 	var varComboSelected = '';		irgendwo oben zentral im Dialog
        4)	Bereitstellen einer Funktion, z.B. wie folgt, die es erlaubt, aus dem Init-Ajax-Handler heraus die
              "globalen" Werte zu setzen
                setInitialComboSelectedValues: function(id) {
                    varComboSelected = Ext.getCmp("...ComboId...").getValue();
                    ...
                },
        5)	Dort wo Werte an den Server geschickt werden, also z.B. im Apply-Handler:
                var techObject = getTechField(Ext.getCmp("...die Edit..."), Ext.getCmp("...die Combo..."), 'das Einheitenprofil');
              Dann dieses techObject zusammen mit den restlichen Dialogvariablen an den Server schicken:
                params: {
                    ...
                    json-property name 		: Ext.util.JSON.encode(techObject), 
                    ...
                },
        6)	In der Init-Funktion des Dialogs, wo die Daten vom Server geladen werden, folgender Code (als Beispiel):	
                setTechField(Ext.getCmp("...die Edit..."), Ext.getCmp("...die Combo..."), storeFuerDieCombo, techObject);
                XCat.dlg......setInitialComboSelectedValues(id);
    B) Im Server:
        1)	In der XCAT NG - Architektur müssen sowohl im Dialog-Objekt als auch im Handler jeweils eine Variable für den Techwert angelegt werden:
                    this.oBlaTechWert = createEmptyTechval();
            Die beiden Variablen müssen gleich heissen, sonst klappt der automatische Datenabgleich nicht.
            Der Aufruf der Create-Funktion ist obligatorisch, weil sonst ebenfalls der automatische Datenabgleich nicht geht.
        2)  Im Handler müssen die Serialize-In und -Out-Funktionen ergänzt werden:
            In:
                this.oBlaTechWert = serializeIn(strStorePath + '.OBLATECH');	
            Out:
                serializeOut(strStorePath + '.OBLATECH', this.oBlaTechWert);	
        3)  Im Controller in der getInitialAction(), die die Daten an den Client liefert:
                oDlg.oBlaTechWert = checkObject(oDlg.oBlaTechWert, 'TEMPERATUR', '-10', 'C');
            Dieser Code prüft erstmal, ob das im Dialogobjekt (Handler) vorhandene Tech-Objekt überhaupt gültig und vollständig ist.
            Bei einer neuen Auswahl wird es dass regelmässig nicht sein. Es wird dann in der Funktion angelegt mit dem übergebenen
            Einheitenprofil und Default - Wert. Die eingestellte Einheit wird dann bestimmt aus dem Mass-System, das in den Grundeinstellungen
            gewählt ist.
            Danach kann man oDlg.oBlaTechWert per Ajax an den Client liefern.
            
        4)  Im Controller in der getApply...Action (also da wo die Werte vom Client kommen und gemerkt werden sollen):
                oDlg.oBlaTechWert = getObjectFromJson(HttpRequest.get( '...json-property name...' ));
            
        5) OPTIONAL können wir serverseitig dann noch diverse Hilfsfunktionen benutzen:
            Den formatierten Wert eines Tech-Objekts als String mit / ohne Einheitensymbol, mit gegebener Einheit oder der eingestellten:
                var x = getValueFormatted(oDlg.oMinEnvironmentTemperature, 'C', true);
                var y = getValueFormatted(oDlg.oMinEnvironmentTemperature, 'F', false);
                var z = getValueFormatted(oDlg.oMinEnvironmentTemperature, '', true);

            Nur das formatierte Einheitensymbol für ein Tech-Objekt, mit gegebener Einheit oder der eingestellten:
                var a = getUnitFormatted(oDlg.oMinEnvironmentTemperature, 'F');
                var b = getUnitFormatted(oDlg.oMinEnvironmentTemperature);

            Den genauen Zahlenwert eines Tech-Objekts als Double mit gegebener Einheit oder der eingestellten:
                var x = getValueAsNumber(oDlg.oMinEnvironmentTemperature, 'C');
            
            Den Zahlenwert eines Tech-Objekts setzen, in der übergebenen Einheit (diese wird aber nicht als selektiert eingestellt):
                setValueAsNumber(oTechObject, 123.5, 'C');
            Die selektierte Einheit setzen:
                setSelectedUnit(oTechObject, 'C');
*/


var Dimensions = [
['DREHMOMENT',	'Nm',	0,	1,	1.0,		0,		'100',	'Nm'],
['DREHMOMENT',	'lb.ft',0,	0,	1.355818,	0,		'100',	'lb.ft'],
['DREHMOMENT',	'lb.in',1,	0,	0.112985,	0,		'100',	'lb.in'],

['LEISTUNG',  	'kW',	0,	1,	1000.0,		0,		'100',	'kW'],
['LEISTUNG',  	'W',	0,	0,	1.0,		0,		'100',	'W'],
['LEISTUNG',  	'hp',	1,	0,	745.7,		0,		'100',	'hp'],

['TEMPERATUR',	'C',	0,	1,	1.0,		0, 		'100',	translate('IDC_UNIT_C')],
['TEMPERATUR',	'K',	0,	0,	1.0,	-273.15,	'100',	'K'],
['TEMPERATUR',	'F',	1,	0,	0.5555555555555555555,	-32,	'100',	translate('IDC_UNIT_F')],

['FREQUENZ', 	'Hz', 	0,	1,	1.0,		0,		'100',	'Hz'],

['KRAFT',		'N',	0,  1,  1.0,		0,		'100',	'N'],
['KRAFT',		'lbf',	1,  0,  4.448222,	0,		'100',	translate("IDC_UNIT_l100]")],

['STEIGUNG',	'PROZ',	1,  0,  0.9,	0,		'100',	translate("IDC_FB_FLUDEX_BETRIEBSSCHLUPF_UNIT_LABEL")],
['STEIGUNG',	'GRAD',	0,  1,  1.0,		0,		'100',	translate("IDC_UNIT_GRAD_STEIGUNG")],

['LAENGE',		'MM',	0,	0,	0.001,		0,		'100',	translate("IDC_UNIT_MM")],
['LAENGE',		'CM',	0,	0,	0.01,		0,		'100',	translate("IDC_UNIT_CM")],
['LAENGE',		'M',	0,	1,  1.0,		0,		'1000',	translate("IDC_UNIT_M")],
['LAENGE',		'INCH',	1,	0,	0.0254,		0,	'100',	translate("IDC_UNIT_INCH")], //http://units.wikia.com/wiki/Inch_%28United_States_customary%29
['LAENGE',		'FOOT',	0,	0,	0.30478512648582749161840902163974,	0, '100',	translate("IDC_UNIT_FOOT")],

['DREHZAHL',	'1/min',0,	1,  1.0,		0,		'100',	translate("IDC_UNIT_1/min")],
['DREHZAHL',	'rpm',  1,	0,  1.0,		0,		'100',	'rpm'],

['MASSE',		'Kg'	,0,	1,  1.0,		0,		'100',	translate("IDC_UNIT_kg")],
['MASSE',		'g'		,0, 0,	0.001,	    0,		'100',	translate("IDC_UNIT_g")],
['MASSE',		't'		,0, 0,	1000.,		0,		'100',	translate("IDC_UNIT_t")],
['MASSE',		'lb'	,1, 0,  0.45359702440351991290937131452418,	0,'100',	translate("IDC_UNIT_lb")],
['MASSE',		'lbs'	,1, 0,  2.205,	0,'100',	translate("IDC_UNIT_lbs")],
['MASSE',		'oz'	,0, 0, 	0.0283286118980169971671388101983,	0,'100',	translate("IDC_UNIT_oz")],

['MASSE_PRO',	'Kg/m'	,0,	1,  1.0,		0,		'100',	translate('IDC_UNIT_kg_m')],
['MASSE_PRO',	'lb/ft'	,1,	0,  0.67197025115825408436966593513777,	0,		'100',	translate('IDC_UNIT_lb_ft')],

['WIDERSTAND',	'NKg'	,0,	1,  1.0,		0,		'10000',	translate("IDC_UNIT_N_KG")],
['WIDERSTAND',	'Nt'	,0,	0,  0.001,		0,		'10000',	translate("IDC_UNIT_N_T")],
['WIDERSTAND',	'lbf/lb',1,	0,  0.980665,	0,		'10000',	translate("IDC_UNIT_LBF_LB")],

['TRAEGHEITSMOMENT','kg-m-2' ,0,1,1.0    ,	0,		'10000', translate('IDC_UNIT_KG_M_2')],
['TRAEGHEITSMOMENT','lb-ft-2',1,0,0.04214011,0,		'10000', translate('IDC_UNIT_LB_FT_2')],

['GESCHWINDIGKEIT',	'm/s',  0,1,  1.0,		0,		'1000',	translate("IDC_UNIT_m/s")],
['GESCHWINDIGKEIT',	'm/min',0,0,  0.0166666666666666666666667,0,		'1000',	translate("IDC_UNIT_m/min")],
['GESCHWINDIGKEIT', 'km/h', 0,0,  0.2777777777777777777777778,0,		'1000',	translate("IDC_UNIT_km/h")],
['GESCHWINDIGKEIT', 'ft/s', 1,0,  0.30478512648582749161840902163974,	0,	'1000',	translate("IDC_UNIT_ft/s")],

['ZEIT',			's',  0,1,	1.0,	0,'100',	translate("IDC_UNIT_s")],
['ZEIT',			'ms', 0,0, 0.001,	0,'100',	translate("IDC_UNIT_ms")],
['ZEIT',			'min',0,0,	60.0,	0,'100',	translate("IDC_UNIT_min")],
['ZEIT',			'h',  0,0,3600.0,	0,'100',	translate("IDC_UNIT_h")],

['BESCHLEUNIGUNG',	'm/s^2',0,1,1.0,	0,'100',	translate("IDC_UNIT_m/s^2")],
['BESCHLEUNIGUNG',	'ft/s^2',1,0,0.3048,0,'100',	translate("IDC_UNIT_FT_S_2")]
];

/**
 * Checks whether a TechValue object is valid ... if not, it creates one
 * The default value can then be set using an arbitrary unit. The selected
 * unit will be taken from the measurement profile
 * @return {object}
 */
function checkObject(oTechObject, strProfile, strDefaultValue, strUnit, bSetSelectedUnit) {

    if (!oTechObject || !oTechObject.Profile || (oTechObject.Profile == '')) {
        var strMeasurementSystem = "SI";
        var colDefaultUnitSystem = 3;
        if (strMeasurementSystem == 'US')		// @@@ STILL TODO: user defined measurement system
            colDefaultUnitSystem = 2;
        var dBaseValue = convertToBase(strDefaultValue, strProfile, strUnit);
        var strSelectedUnit = '';
        if (bSetSelectedUnit) {
            strSelectedUnit = strUnit;
        }
        else {
            for (var i = 0; i < Dimensions.length; i++) {
                if ((strProfile == Dimensions[i][0]) &&
                    (Dimensions[i][colDefaultUnitSystem] == 1)) {
                    strSelectedUnit = Dimensions[i][1];
                    break;
                }
            }
        }
        
        oTechObject = {
          Profile:	    strProfile,
          SelectedUnit: strSelectedUnit,
          BaseValue:	dBaseValue,
          EnteredValue:	'',
          EnteredUnit:	''
        };
    }

    return oTechObject;
}	

/**
 * @class convertFromBaseFormat
 * Group: Base
 * Converts a given double value into another unit and returns the result as a formatted string
 * 
     dBaseValue:			double value in base unit
     Profile:				Unit Profile Id (string)
     strSelectedUnit:		unit into the base value shall be converted

     returns:		formatted value (string)
 */
function convertFromBaseFormat(dBaseValue, strProfile, strSelectedUnit){

    var strRet = '';
    for (var i = 0; i < Dimensions.length; i++) {
        if ((strProfile == Dimensions[i][0]) &&
            (strSelectedUnit == Dimensions[i][1])) {
            var convertFactor 	= Dimensions[i][4];
            var convertConstant = Dimensions[i][5];
            var formatString 	= Dimensions[i][6];
            // Requested Unit == BaseUnit: do nothing
            var dRet = 0;
            if ((convertFactor == 1.0) && (convertConstant == 0.0)) {
                dRet = dBaseValue;
            }
            else {
                dRet = (dBaseValue / convertFactor) - convertConstant;
            }
            strRet = formatNumber(dRet, formatString);	
        }
    }

    return strRet;
};

/**
 * @class convertFromBaseRaw
 * Group: Base
 * Converts a given double value into another unit and returns the result as a double
 * 
     dBaseValue:			double value in base unit
     Profile:				Unit Profile Id (string)
     strSelectedUnit:		unit into the base value shall be converted

     returns:		converted number (double)
 */
function convertFromBaseRaw(dBaseValue, strProfile, strSelectedUnit){

    var dRet = 0;
    for (var i = 0; i < Dimensions.length; i++) {
        if ((strProfile == Dimensions[i][0]) &&
            (strSelectedUnit == Dimensions[i][1])) {
            var convertFactor 	= Dimensions[i][4];
            var convertConstant = Dimensions[i][5];
            var formatString 	= Dimensions[i][6];
            // Requested Unit == BaseUnit: do nothing
            if ((convertFactor == 1.0) && (convertConstant == 0.0)) {
                dRet = dBaseValue;
            }
            else {
                dRet = (dBaseValue / convertFactor) - convertConstant;
            }
            break;
        }
    }

    return dRet;
};

/**
 * @class convertToBase
 * Group: Base
 * Converts a given string input value into the base double value, based on a profile and unit
 * 
     strInputValue:			string input value
     Profile:				Unit Profile Id (string)
     strSelectedUnit:		unit matching the input value

     returns:		base value (double)
 */
function convertToBase(strInputValue, strProfile, strSelectedUnit){

    var dBaseValue = 0;
    for (var i = 0; i < Dimensions.length; i++) {
        if ((strProfile == Dimensions[i][0]) &&
            (strSelectedUnit == Dimensions[i][1])) {
            var convertFactor 	= Dimensions[i][4];
            var convertConstant = Dimensions[i][5];
            var dInputValue = atod(strInputValue);	
            // Requested Unit == BaseUnit: do nothing
            if ((convertFactor == 1.0) && (convertConstant == 0.0)) {
                dBaseValue = dInputValue - 0;
            }
            else {
                dBaseValue = convertFactor * (dInputValue + convertConstant);
            }
            break;
        }
    }

    return dBaseValue;
};

/**
 * @class convertTechField
 * Group: Base
 * If the selected unit for a tech field changes, this function calculates the new formatted value for the edit
 * 
     inputField:			edit field to inizialize with a value
     unitCombo:				combobox to intitialize with units
     Profile:				Unit Profile Id (string)
     
    @return strValue; 
 */
function convertTechField(strInputValue, strProfile, oldUnit, newUnit){

    var dBaseValue    = convertToBase(strInputValue, strProfile, oldUnit);
    var strNewValue   = convertFromBaseFormat(dBaseValue, strProfile, newUnit);
    return strNewValue;
};

/**
 * @class atod
 * Group: Base
 * Einfache Umwandlung von String in Double 
 * Wandelt Zahlen-Strings wie etwa "100,50" oder "1.232.323,88" in entsprechende Double
 * Erkennt auch Zahlen in englischem Zahlenformat d.h. z.B. "123,456.78"
 * Akzeptiert auch "1,2,3,4" als 123.4, ist aber OK ...
 * Schnappt sich erste Zahl aus Liste (z.B. "123,45 : 17 + 4" -> 123.45
 */
function atod(strNumber)
{
    var x = typeof strNumber;
    if (x == 'number'){
        return strNumber;
    }
    if (!strNumber || (strNumber == '') || (x != 'string')){
        return 0;
    }
        
    // replace(/[^A-Za-z]/g, '')
    var strCorrectedNumber = strNumber.replace(/[^0-9,\.-]/g, '');

    // Positionen von Hinten an gezaehlt
    var nKommaPos = strCorrectedNumber.length - strCorrectedNumber.lastIndexOf(',');
    var nPunktPos = strCorrectedNumber.length - strCorrectedNumber.lastIndexOf('.');
    var nDezSepPos = Math.min(nKommaPos, nPunktPos);

    if (nDezSepPos < strCorrectedNumber.length)
    {
        // Löschen aller Trennzeichen, kann so gemacht werden, da alle Trennzeichen vor (!) nDezSepPos !
        strCorrectedNumber = strCorrectedNumber.replace(',','');
        strCorrectedNumber = strCorrectedNumber.replace('.','');

        // neues Zusammensetzen der Zahl als direkt interpretierbarer String
        // @@@ substr in EasyScript not OK when second param is missing !?!?
        var strPart1 = strCorrectedNumber.substr(0, strCorrectedNumber.length - nDezSepPos + 1);
        var strPart2 = strCorrectedNumber.substr(strCorrectedNumber.length - nDezSepPos + 1, 999);
        strCorrectedNumber = strPart1 + '.' + strPart2;
    }
    
    return parseFloat(strCorrectedNumber);
};

/**
 * @class formatNumber
 * Group: Base
 * Formatierung einer Zahl (Nachkommastellen, etc) 
 */
function formatNumber(dNumber, dezimalStelle)
{
    var x = typeof dNumber;
    if (x != 'number'){
        return '';
    }

    var strRet = parseInt(dNumber*dezimalStelle)/dezimalStelle;
        
    // formatString  @@@ STILL TODO, using locale or global setting for dec. sep etc. .....
    
    return strRet;
};

// ---------------------------------------------------------------------------------------
// Special functions for server only:
// ---------------------------------------------------------------------------------------

/**
 * @class createEmptyTechval
 * Group: Base
 * Erzeuge leeres Techval-Objekt; die Bedeutung der Members ist: 
 *	  Profile:	    '',		ID eines Einheitenprofils
 *	  SelectedUnit: '',		ID der aktuell selektierten Einheit
 *	  BaseValue:	0.0,	Wert in der Basiseinheit; diese ist durch das Einheitenprofil fest gegegeben!! 	
 *	  EnteredValue:	'',		Eventuell vorhanden: Von Benutzer eingegebener Wert
 *	  EnteredUnit:	''		Eventuell vorhanden: Einheit in der der vom Benutzer eingegebene Wert ist
 * ACHTUNG:
 *		Lesender / Schreibender Zugriff auf dieses Objekt bitte nur über die Member-Funktionen!!!
 *		Bei Fragen bitte an -mw- wenden.
 */
function createEmptyTechval()
{
    var retObj = {
      Profile:	    '',
      SelectedUnit: '',
      BaseValue:	0.0,		
      EnteredValue:	'',
      EnteredUnit:	''
    };
    
    return retObj;
};


/**
 * @class serializeOut
 * Group: Base
 * Serialisierung in den Store 
 */
function serializeOut(strStorePath, oTechObject)
{
    setstring( 'Profile', strStorePath, oTechObject.Profile );
    setstring( 'SelectedUnit', strStorePath, oTechObject.SelectedUnit );
    setdouble( 'BaseValue', strStorePath, oTechObject.BaseValue );
    setstring( 'EnteredValue', strStorePath, oTechObject.EnteredValue );
    setstring( 'EnteredUnit', strStorePath, oTechObject.EnteredUnit );
    
    return;
};

/**
 * @class serializeOut
 * Group: Base
 * Serialisierung aus dem Store 
 */
function serializeIn(strStorePath)
{
    var oTechObject = {};
    oTechObject['Profile'] 		= getstring( 'Profile', strStorePath );
    oTechObject['SelectedUnit'] = getstring( 'SelectedUnit', strStorePath );
    oTechObject['BaseValue'] 	= getdouble( 'BaseValue', strStorePath );
    oTechObject['EnteredValue'] = getstring( 'EnteredValue', strStorePath );
    oTechObject['EnteredUnit'] 	= getstring( 'EnteredUnit', strStorePath );
    
    return oTechObject;
};

/**
 * 
 * @return {object}
 */
function getObjectFromJson(strJson) {

    // @@@ STILL TODO: den Json-String untersuchen, damit uns nicht einer Code unterschiebt!
    var oTechObject = JSON.parse(strJson);


    return oTechObject;
}


/**
 * Creates a formatted string for a tech value
 * If strUnit is given, this unit will be used. If not, the selected unit will be used.
 * If bWithUnit, the textual representation of the unit will be concatenated
 * @return {string}
 */
function getValueFormatted(oTechObject, strUnit, bWithUnit,bWithCramp) {

    var strUnitToUse = strUnit;
    if (strUnit == '')
        strUnitToUse = oTechObject.SelectedUnit;
    var strRet = convertFromBaseFormat(oTechObject.BaseValue, oTechObject.Profile, strUnitToUse);
    
    if (bWithUnit) {
        var strUnitTrans = '';
        for (var i = 0; i < Dimensions.length; i++) {
            if ((oTechObject.Profile == Dimensions[i][0]) &&
                (strUnitToUse == Dimensions[i][1])) {
                strUnitTrans 	= Dimensions[i][7];
                break;
            }
        }
        if (strUnitTrans != '') {
            strUnitTrans = trimleft(trimright(strUnitTrans, '$'), '$');
            var strUnit = translate(strUnitTrans);
            if(bWithCramp){
                if(strUnit.substring(0,1) !== '[')
                    strUnit = '['+strUnit+']'; 
            }			
            strRet += ' ' + strUnit;
        }
    }
    return strRet;
}

/**
 * Returns the translated string for the unit of a tech value only
 * If strUnit is given, this unit will be used. If not, the selected unit will be used.
 * @return {string}
 */
function getUnitFormatted(oTechObject, strUnit) {

    var strUnitToUse = strUnit;
    if (!strUnit || (strUnit == ''))
        strUnitToUse = oTechObject.SelectedUnit;
    var strRet = '';
    
    var strUnitTrans = '';
    for (var i = 0; i < Dimensions.length; i++) {
        if ((oTechObject.Profile == Dimensions[i][0]) &&
            (strUnitToUse == Dimensions[i][1])) {
            strUnitTrans 	= Dimensions[i][7];
            break;
        }
    }
    if (strUnitTrans != '') {
        strUnitTrans = trimleft(trimright(strUnitTrans, '$'), '$');
        strRet = translate(strUnitTrans);
    }
    return strRet;
}
                            
                            
/**
 * Returns the number value of a tech value
 * If strUnit is given, this unit will be used. If not, the selected unit will be used.
 *
 * @return {number}
 */
function getValueAsNumber(oTechObject, strUnit) {

    var strUnitToUse = strUnit;
    if (strUnit == '')
        strUnitToUse = oTechObject.SelectedUnit;
    var dRet = convertFromBaseRaw(oTechObject.BaseValue, oTechObject.Profile, strUnitToUse);
    
    return dRet;
}

/**
 * Sets the number value of a tech value
 * If strUnit is given, this unit will be used, conversion will be done if necessary. 
 * If not, the selected unit will be used. --> But this is not ! recommended, because you never know for sure which unit is selected
 * If bSelectUnit ist false or not given: The selected unit will not!! be changed
 *
 * @return 
 */
function setValueAsNumber(oTechObject, dValue, strUnit, bSelectUnit) {

    var strUnitToUse = strUnit;
    if (strUnit == '')
        strUnitToUse = oTechObject.SelectedUnit;
    oTechObject.BaseValue = convertToBase(''+dValue, oTechObject.Profile, strUnitToUse);
    oTechObject.EnteredValue = '';
    oTechObject.EnteredUnit = '';
    if (bSelectUnit)
        oTechObject.SelectedUnit = strUnitToUse;

    return;
}

/**
 * Sets the selected unit of a tech value
 * strUnit must be given
 *
 * @return 
 */
function setSelectedUnit(oTechObject, strUnit) {

    oTechObject.SelectedUnit = strUnit;
    oTechObject.EnteredValue = '';
    oTechObject.EnteredUnit = '';

    return;
}

/**
 * get the selected unit of a tech value
 * strUnit must be given
 *
 * @return 
 */
function getSelectedUnit(oTechObject) {
    return oTechObject.SelectedUnit
}

function createSpecString(oData)
{
    var strDBName = "2KJ8_DB";
    var strDBResult = "SPECSTRING";
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    
    var strSpec="";
    
    var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";
    
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTOR = '1' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect = strSelect + "(REGION = 'S' OR REGION = 'SU') ";
    
    
    if ( dbselect( strDBName, strSelect, strDBResult ) == 1 )
    {
        strSpec = dbgetstring(strDBResult,'MOTELAUSF');
        //logtraceln("Specification String="+strSpec);
    }
    else
    {
        logtraceln("Fehler Bestimmung Spezifikation String! SQL="+strSelect);
    }
    
    return strSpec;
}

function createSpecStringParser(strG115_Type)
{
    var strDBName = "2KJ8_DB";
    var strDBResult = "SPECSTRING_PARSER";

    
    var strSpec="";
    
    var strSelect = "SELECT DISTINCT MOTELAUSF FROM MOTELAUSF WHERE ";
    
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "M3 = '1' AND ";
    strSelect = strSelect + "MOTOR = '1' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect = strSelect + "(REGION = 'S' OR REGION = 'SU') ";
    
    
    if ( dbselect( strDBName, strSelect, strDBResult ) == 1 )
    {
        strSpec = dbgetstring(strDBResult,'MOTELAUSF');
        //logtraceln("Specification String="+strSpec);
    }
    else
    {
        logtraceln("Fehler Bestimmung Spezifikation String Parser! SQL="+strSelect);
    }
    
    return strSpec;
}
