//@legacy
//#mode(full-ecma)







/**
 * get the MLFB part for the geared motor product area (digit 1-4)
 * @param bSimogear - SimoGear (true) or MOTOX-N (false)
 *
 * @return string - MLFB-part for the product area (4 digits)
 */
function getPraefixMLFB()
{
    return( '2KJ8' );
}


/**
 * get the MLFB part for the gear of the geared motor (digits 5-7)
 *
 * @param strEGBEZTYP - gear base type
 * @param strEGBEZUEBS - gear ratio stage
 * @param strEGBEZEI - gear development index
 * @param strEGBEZDIM - gear size
 * @param strZGBEZDIM - gear size fo secondary gear
 * @param strZGBEZEI - development index for secondary gear
 * @param strZGBEZUEBS - ratio stage for secondary gear
 *
 * @return string - MLFB-part for the gear of the geared motor (3 digits)
 */
function getGearMLFB( strEGBEZTYP, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strZGBEZDIM, strZGBEZEI, strZGBEZUEBS, strEGBEZBRA )
{
    var strRegion = "";
    var strGearMLFB = '...';

    var strSelect = "SELECT MLFB_2KJ8_5, MLFB_2KJ8_6, MLFB_2KJ8_7 from MLFB8_EGTYP where EGBEZTYP='" + strEGBEZTYP + "' and EGBEZUEBS='" + strEGBEZUEBS + "' and EGBEZEI='" + strEGBEZEI + 
                    "' and EGBEZDIM='" + strEGBEZDIM + "' and EGBEZBRA='"+strEGBEZBRA+"' ";
    if ( ( strZGBEZDIM === '' ) && ( strZGBEZEI === '' ) && ( strZGBEZUEBS === '' ) )
        strSelect += " and ZGBEZDIM='-' and ZGBEZEI ='-' and ZGBEZUEBS='-' ";
    else strSelect += " and ZGBEZDIM='" + strZGBEZDIM + "' and ZGBEZEI ='" + strZGBEZEI + "' and ZGBEZUEBS='" + strZGBEZUEBS + "' ";

    var strResultTable = 'MLFB_GEAR';
    if ( dbselect( '2KJ8_DB', strSelect, strResultTable ) > 0 )
        strGearMLFB = dbgetstring( strResultTable, 'MLFB_2KJ8_5' ) + dbgetstring( strResultTable, 'MLFB_2KJ8_6' ) + dbgetstring( strResultTable, 'MLFB_2KJ8_7' );
    // else not decidable -> return the dots
    
    return( strGearMLFB );
}


/**
 * get the MLFB part for the motor size, power, type and the motor voltage of the geared motor (digits 9-12: motor type, digits 13: motor voltage)
 * you may get an additional necessary short description for motor voltage and an additional short description for special motor powers
 *
 * @param oGear - MOTOX gear object
 * 
 * @return object - strMLFBPart: MLFB-Part for motor size, power, type and motor voltage (5 digits)
 *                  strSDVoltage: necessary short description for motor voltage (only nonempty if the motor voltage part of the MLFB is 9)
 *                  strSDPower: additional short description for motor power (may be empty)
 *                  strSDSpecification: additional short description for the selected motor specification
 */
function getMotorMLFB( oGear )
{
    var oMLFB = {
        strMLFBPart: '.....',
        strSDVoltage: '',
        strSDPower: '',
        strSDSPGTOL: '',
        strSDBART: '',
        strSDSpecification: ''
    };
    
    var strFrequenz = oGear.oRow.FREQUENZ;
    
    var strSelect = "SELECT DISTINCT MLFB_2KJ8_8, MLFB_2KJ8_9, MLFB_2KJ8_10, MLFB_2KJ8_13 FROM MOTFHT_2KJ8 WHERE ";
    
    strSelect = strSelect + "MOTELAUSF='"+createSpecString(oGear)+"' AND ";
    
    strSelect = strSelect + "MOTWK = '" + ECL_GetValue("WAERMEKLASSE_2KJ8") + "' AND ";
    
    
    //Spannung  auseinanderklabüstern
    var teilspannung1="";
    var teilspannung2="";
    var teilschaltung1="";
    var teilschaltung2="";
    var schaltung="";
    
    var strSpannung = ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_2KJ8");
    
    if(find(strSpannung,"D") > -1)
        teilschaltung1 = "D";
    else if(find(strSpannung,"Y") > -1)
        teilschaltung1 = "Y";
    
    schaltung=teilschaltung1;
    
    teilspannung1 = left(strSpannung,3);
    teilspannung2 = "-";

    //Spannung 
    strSelect = strSelect + "MOTSPG_1 = '" + teilspannung1 + "' AND ";
    strSelect = strSelect + "MLFB_2KJ8_13 = '" + ECL_GetValue("ECSI_MOTORSPANNUNG_SPG_MLFB_2KJ8") + "' AND ";
    
    //Schaltung
    strSelect = strSelect + "MOTSHLT1_1 = '" + schaltung + "' AND "; 
    
    strSelect = strSelect + "HEMOTOR = '"+oGear.oRow.MOTFHT_HEMOTOR+"' AND "; 
    strSelect = strSelect + "VSDMOTOR='"+oGear.oRow.VSDMOTOR+"' AND ";
    
    strSelect = strSelect + "POLZAHL = '" + ECL_GetValue("ECSI_POLZAHL_2KJ8") + "' AND "; 
    strSelect = strSelect + "MOTDIM = '" + oGear.oRow.MOTDIM + "' AND ";  
    
    strSelect = strSelect + "LEISTUNG1 = '" + oGear.oRow.MOTFHT_LEISTUNG1 + "' AND ";
    
        
    strSelect = strSelect + "PAKLGE = '" + ECL_GetValue("ECSI_PAKLGE_2KJ8") + "' AND ";
    strSelect = strSelect + "EFFKLASSE = '" + oGear.oRow.MOT_EFFIZIENZKL_KNZ + "' AND ";
    
    strSelect = strSelect + "REGION = 'S' AND AKTIV='1' ";  
    
    
    //BugTesting
    //var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );

    var strResultTable = 'MLFB_MOTOR';
    if ( dbselect( '2KJ8_DB', strSelect, strResultTable ) > 0 )
    {
        oMLFB.strMLFBPart = dbgetstring( strResultTable, 'MLFB_2KJ8_8' ) + dbgetstring( strResultTable, 'MLFB_2KJ8_9' ) + dbgetstring( strResultTable, 'MLFB_2KJ8_10' );
        
        oMLFB.strMLFB_13=dbgetstring( strResultTable, 'MLFB_2KJ8_13' );
        oMLFB.strSDVoltage = '';
        oMLFB.strSDPower = '';
        oMLFB.strSDSPGTOL = '';
        oMLFB.strSDBART = '';

        //Werte setzen
        ECL_SetValue ("ECSI_MOTORSPANNUNG_SPG_KA_2KJ8", "-");
        ECL_SetValue ("ECSI_MOTORSPANNUNG_BART_KA_2KJ8", "-");
        ECL_SetValue ("ECSI_MOTORSPANNUNG_P_KA_2KJ8", "-");
        ECL_SetValue ("ECSI_MOTORSPANNUNG_SPGTOL_KA_2KJ8", "-");
    }	

    return( oMLFB );
}

function getMOWSARTMLFB( oGear )
{
    var oMLFB = {
        strMLFBPart: '.',
    };
    
    if(ECL_ValueSelected("MOTORSCHUTZ_2KJ8", "Pt1000"))
    {
        oMLFB.strMLFBPart="1";
    }
    else
    {
        oMLFB.strMLFBPart="0";
    }
    
    return( oMLFB );
}

function getBrakeMLFB( oGear )
{
    var oMLFB = {
        strMLFBPart: '.',
    };
    
    if(ECL_ValueSelected("MIT_BREMSE_2KJ8", "T"))
    {
        var strBrake = ECL_GetValue("BREMSENTYP_2KJ8");
        var oBrakeData = splitSelectedBrake( strBrake );

        var strSelect = "SELECT DISTINCT MLFB_2KJ8_12 FROM BRETYP_G115 WHERE ";
        strSelect=strSelect + "BRETYP_G115.BREART = '" + oBrakeData.BREART + "' AND ";
        strSelect=strSelect + "BRETYP_G115.BRENENMO = '" + oBrakeData.BRENENMO + "' AND ";
        strSelect=strSelect + "BRETYP_G115.BREREDMO = '" + oBrakeData.BREREDMO + "' AND ";
        strSelect=strSelect + "BRETYP_G115.WIBLNR = '" + oGear.oRow.WIBLNR + "' AND ";
        strSelect=strSelect + "BRETYP_G115.WIBLAUSLG = '" + oGear.oRow.WIBLAUSLG + "' AND ";
        strSelect=strSelect + "BRETYP_G115.CDROM_REL = '1' AND BRETYP_G115.AKTIV = '1' ";

        var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
        if(aResult.length==1)
        {
            oMLFB.strMLFBPart=aResult[0].MLFB_2KJ8_12;
        }
    }
    else
    {
        oMLFB.strMLFBPart="0";
    }
    
    
    return( oMLFB );
}

function getG115DAdapter( oGear )
{
    var oMLFB = {
        strMLFBPart: '.',
    };
    
    var strG115_Type = ECL_GetValue("ECSI_G115_TYPE_2KJ8");
    var strKKMAT=ECL_GetValue("MOTORSTECKER_2KJ8");
    var strKKMAT_ZUB=ECL_GetValue("GEGENSTECKER_2KJ8");
    var strSCHUTZART=ECL_GetValue("SCHUTZART_2KJ8");
    
    var strSelect="SELECT DISTINCT MLFB_2KJ8_14 FROM G115_ADPT WHERE "
    strSelect=strSelect+"MOTDIM='"+oGear.oRow.MOTDIM+"' AND ";
    strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
    strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' AND ";
    
    if(strG115_Type=="MM")
        strSelect = strSelect + "G115M = '1' AND ";
    else if(strG115_Type=="WM")
        strSelect = strSelect + "G115D = '1' AND ";
    
    strSelect=strSelect+"G115_BUSSYSTEM='"+ECL_GetValue("G115_KOMMUNIKATION_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_BUSSYSTEM_VS='"+replace(ECL_GetValue("G115_ANSCHLUSS_2KJ8"),'_Zoll','"')+"' AND ";
    strSelect=strSelect+"G115_BUSSYSTEM_POS='"+ECL_GetValue("G115_POSITION_KOMM_2KJ8")+"' AND ";
    strSelect=strSelect+"G115_EXTANB='"+ECL_GetValue("G115_VERSORGUNG_2KJ8")+"' AND ";

    // V71 interne Versorgung
    if(ECL_ValueSelected("G115_VERSORGUNG_INTERN_2KJ8", "T"))
    {
        strSelect=strSelect+"G115_INTERN_24V='24VDC' AND ";
    }
    else
    {
        strSelect=strSelect+"G115_INTERN_24V='-' AND ";
    }

    strSelect=strSelect+"SCHUTZART='"+strSCHUTZART+"' AND ";
    strSelect=strSelect+"REGION like'S%' AND ";
    strSelect=strSelect+"AKTIV='1' ";
        
    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    
    if(aResult.length==1)
    {
        oMLFB.strMLFBPart=aResult[0].MLFB_2KJ8_14;
    }
    else
        logtraceln("Fehler bei Bestimmung MLFB Stelle14 G115D!, SQL="+strSelect);
    
    
    return( oMLFB );
}

/**
 * get the MLFB part for the ratio of the geared motor (digits 15+16)
 *
 * @param strEGBEZTYP - gear base type
 * @param strEGBEZUEBS - gear ratio stage
 * @param strEGBEZEI - gear development index
 * @param strEGBEZDIM - gear size
 * @param strEGUEB - gear ratio
 * @param strZGBEZDIM - gear size for secondary gear
 * @param strZGBEZEI - development index for secondary gear
 * @param strZGBEZUEBS - ratio stage for secondary gear
 * @param strZGUEB - ratio of secondary gear
 *
 * @return string - MLFB-part for the ratio of the geared motor (2 digits)
 */
function getRatioMLFB( strEGBEZTYP, strEGBEZUEBS, strEGBEZEI, strEGBEZDIM, strEGUEB, strZGBEZDIM, strZGBEZEI, strZGBEZUEBS, strZGUEB, strEGBEZBRA )
{
    var strRatioMLFB = '..';
    var strSelect = "SELECT DISTINCT MLFB_2KJ8_15,MLFB_2KJ8_16 from IGES_M3 where EGBEZTYP='" + strEGBEZTYP + "' and EGBEZUEBS='" + strEGBEZUEBS + "' and EGBEZEI='" + strEGBEZEI + "' and EGBEZBRA='" + strEGBEZBRA + 
                    "' and EGBEZDIM='" + strEGBEZDIM + "' and abs(EGUEB) = " + strEGUEB;
    if ( ( strZGBEZDIM === '' ) && ( strZGBEZEI === '' ) && ( strZGBEZUEBS === '' ) )
        strSelect += " and ZGBEZDIM='-' and ZGBEZEI ='-' and ZGBEZUEBS='-' ";
    else strSelect += " and ZGBEZDIM='" + strZGBEZDIM + "' and ZGBEZEI ='" + strZGBEZEI + "' and ZGBEZUEBS='" + strZGBEZUEBS + "' ";
    if ( ( strZGUEB === '-' ) || ( strZGUEB === '' ) )
        strSelect += " and ZGUEB = '-'";
    else strSelect += " and abs(ZGUEB) = " + strZGUEB;
    strSelect += " and EINZELGETR = '1' ";
    strSelect += " and G115 = '1' AND SONDER='-' AND AKTIV='1' AND REGION IN ('SACE','SACEN')";
    
    var strResultTable = 'MLFB_RATIO';
    if ( dbselect( '2KJ8_DB', strSelect, strResultTable ) > 0 )
        strRatioMLFB = dbgetstring( strResultTable, 'MLFB_2KJ8_15' ) + dbgetstring( strResultTable, 'MLFB_2KJ8_16' );
        
    return( strRatioMLFB );
}
