//@legacy
//#mode(full-ecma)


//@import "MLFB.MOTOX.base.js"

//@import "MLFB.MOTOX.ShortDescriptions.js"

//@import "MLFB.common.js"


/**
 * @constructor
 * build a fully specified MLFB (with/wo short descriptions) from the the geared motor object
 *
 * @param oGear - geared motor object
 * @param bWithShortDescriptions - build MLFB with short descriptions?
 * @param bFull - build MLFB with all possible short descriptions? (optional)
 *
 * @return string - fully specified MLFB of gear
 *                  empty string, if an error occured
 */
function buildFullMLFB( oGear, bWithShortDescriptions, bFull )
{
    // base MLFB
    var oBase = buildBaseMLFB( oGear );
    var strMLFB = oBase.strMLFB;
    
    if ( bWithShortDescriptions )
    {
        //--------------------------------------------------------------------------------------------------------
        // assemble additional short descriptions
        //--------------------------------------------------------------------------------------------------------
        var aShortDescriptions = getShortDescriptions( oGear );
        preventDoubledShortDescription( oBase.strSDShaft, aShortDescriptions );
        preventDoubledShortDescription( oBase.strSDVoltage, aShortDescriptions );
        preventDoubledShortDescription( oBase.strSDFastening, aShortDescriptions );
        preventDoubledShortDescription( oBase.strSDPower, aShortDescriptions );
        preventDoubledShortDescription( oBase.strCHINA, aShortDescriptions );
        preventDoubledShortDescription( oBase.strEAC, aShortDescriptions );
        preventDoubledShortDescription( oBase.strULR_CSA, aShortDescriptions );
        preventDoubledShortDescription( oBase.strCE, aShortDescriptions );
        preventDoubledShortDescription( oBase.strEXPORT, aShortDescriptions );
        preventDoubledShortDescription( oBase.strSDSPGTOL, aShortDescriptions );
        preventDoubledShortDescription( oBase.strSDBART, aShortDescriptions );
        
        if ( !bFull )
            aShortDescriptions = filterShortDescriptions( oGear, strMLFB, aShortDescriptions );
                
        if ( aShortDescriptions.length > 0 )
        {
            aShortDescriptions.sort();
            
            var strSD = aShortDescriptions.join( ' ' );
            if ( strSD.substring( 0, 1 ) == ' +' )
                strSD = strSD.substring( 1 );
        
            strMLFB += '-Z ' + strSD;
        }
    }
    
    
    return( strMLFB );
}


/**
 * @constructor
 * build a fully specified MLFB (with/wo short descriptions) from the the geared motor object
 *
 * @param oGear - geared motor object
 *
 * @return object - strBaseMLFB - base MLFB
 *                  strStrippedShortDescriptions - filtered short descriptions where all clear texts for Yxx- descriptions have been stripped
 *                  strFormattedShortDescriptions - clear texts for Yxx- descriptions that have been formatted to {<SHORT_DESCRIPTION>: <TEXT>}
 *                  strYDescription - clear texts for Y descriptions, one per row, rows are separated with #
 *                  strFullShortDescriptions - filtered short descriptions where all clear texts for Yxx- descriptions have been stripped
 */
function buildFormattedMLFB( oGear, bFull )
{
    var oMLFB = {
        strBaseMLFB : '',
        strStrippedShortDescriptions : '',
        strFormattedShortDescriptions : '',
        strYDescription : '',
        strFullShortDescriptions: '',
        strSpecificationSD: '',
        strBetriebsartSD: '',
        strVentilationSD: ''
    };

    // base MLFB
    var oBase = buildBaseMLFB( oGear );
    oMLFB.strBaseMLFB = oBase.strMLFB;
    
    // short descriptions
    var aShortDescriptions = getShortDescriptions( oGear );
    preventDoubledShortDescription( oBase.strSDShaft, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDVoltage, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDFastening, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDPower, aShortDescriptions );
    preventDoubledShortDescription( oBase.strCHINA, aShortDescriptions );
    preventDoubledShortDescription( oBase.strEAC, aShortDescriptions );
    preventDoubledShortDescription( oBase.strULR_CSA, aShortDescriptions );
    preventDoubledShortDescription( oBase.strCE, aShortDescriptions );
    preventDoubledShortDescription( oBase.strEXPORT, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDSPGTOL, aShortDescriptions );
    preventDoubledShortDescription( oBase.strSDBART, aShortDescriptions );
    
    // before filtering, we must save all possible short descriptions for printout and overview
    if ( aShortDescriptions.length > 0 )
    {
        // since the function MLFB.buildFormattedShortDescriptions modifies the original array parameter, we must construct a copy of the array and use this as parameter to the function
        var aCopy = [];
        var nLen = aShortDescriptions.length;
        for ( var i = 0; i < nLen; ++i )
        {
            if(aShortDescriptions[i]=='+M23')
                oMLFB.strVentilationSD="M23";
                
            aCopy.push( aShortDescriptions[i] );
        }	
        var oSD = buildFormattedShortDescriptions( aCopy, 'MOTOX_' );
        oMLFB.strFullShortDescriptions = oSD.strStrippedShortDescriptions;
    }

    // now filter the descriptions
    if ( bFull )
        aShortDescriptions = filterShortDescriptions( oGear, oBase.strMLFB, aShortDescriptions );
        
    if ( aShortDescriptions.length > 0 )
    {
        // build textual descriptions for short descriptions
        aShortDescriptions.sort();
        
        var oSD = buildFormattedShortDescriptions( aShortDescriptions, 'MOTOX_' );
        oMLFB.strStrippedShortDescriptions = oSD.strStrippedShortDescriptions;
        oMLFB.strFormattedShortDescriptions = oSD.strFormattedShortDescriptions;
        oMLFB.strYDescription = oSD.strYDescription;
        oMLFB.strVoltageSD = oBase.strSDVoltage;
        oMLFB.strPowerSD = oBase.strSDPower;
        oMLFB.strBetriebsartSD = oBase.strSDBART;
        
        //Zur Zeit nur UL-R/CSA aus SIZER
        oMLFB.strSpecificationSD = oBase.strULR_CSA;
        oMLFB.strShaftSD = oBase.strSDShaft;
    }
    
    return( oMLFB );
}


/**
 * @constructor
 * build base MLFB for a configured gear 
 *
 * @param oGear - geared motor object
 *
 * @return object: strMLFB - base MLFB for geared motor
 *                 strSDShaft - necessary short description for shaft (only nonempty if the shaft part of the MLFB is 9)
 *                 strSDVoltage: necessary short description for motor voltage (only nonempty if the motor voltage part of the MLFB is 9)
 *                 strSDPower: additional short description for motor power (may be empty)
 *                 strSDFastening: necessary short description for fastening (only nonempty if the fastening part of the MLFB is Z)
 */
function buildBaseMLFB ( oGear )
{
    //--------------------------------------------------------------------------------------------------------
    // assemble base MLFB
    //--------------------------------------------------------------------------------------------------------
    var strMLFB = '';
    
    // digits 1 - 4: product area and generation digit
    strMLFB += getPraefixMLFB();
    
    // digits 5-7: gear type
    strMLFB += getGearMLFB( oGear.oRow.EGBEZTYP, oGear.oRow.EGBEZUEBS, oGear.oRow.EGBEZEI, oGear.oRow.EGBEZDIM, oGear.oRow.ZGBEZDIM, oGear.oRow.ZGBEZEI, oGear.oRow.ZGBEZUEBS, oGear.oRow.EGBEZBRA );
    strMLFB += '-';
    
    var oMotor_Adapter = new Object();
    
    // digits 8-10 and 13: motor size, power, type and voltage
    oMotor_Adapter = getMotorMLFB( oGear );
    strMLFB += oMotor_Adapter.strMLFBPart;
    
    // digit 11: Motorschutz
    var oMOWSART = new Object();
    oMOWSART = getMOWSARTMLFB( oGear );
    strMLFB += oMOWSART.strMLFBPart;
    
    // digit 12: Brake
    var oBrake = new Object();
    oBrake=getBrakeMLFB( oGear );
    strMLFB += oBrake.strMLFBPart;
    strMLFB += '-';
    
    // digit 13 G115D Voltage
    strMLFB += oMotor_Adapter.strMLFB_13;
    
    // digit 14 G115D Adapter
    var oG115DAdapter = new Object();
    oG115DAdapter=getG115DAdapter( oGear );
    strMLFB += oG115DAdapter.strMLFBPart;
    
    // digits 15+16: gear ratio
    
    strMLFB += getRatioMLFB( oGear.oRow.EGBEZTYP, oGear.oRow.EGBEZUEBS, oGear.oRow.EGBEZEI, oGear.oRow.EGBEZDIM, oGear.oRow.UEBERSETZUNG, 
                                        oGear.oRow.ZGBEZDIM, oGear.oRow.ZGBEZEI, oGear.oRow.ZGBEZUEBS, '-', oGear.oRow.EGBEZBRA );
    
    if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBEMOTOR")
    {
        return( {
            strMLFB: strMLFB,
            strSDShaft: '',
            strSDVoltage: '',
            strSDFastening: '', 
            strSDPower: '',
            strSDSpecification: '',
            strSDSPGTOL: '',
            strSDBART: '',
            strCHINA: '',
            strEAC: '',
            strULR_CSA: '',
            strCE: '',
            strEXPORT: ''
        } );
    }
    else if(ECL_GetValue ("ECSI_2KJ_TYPE_2KJ8") == "GETRIEBE.ADAPTER")
    {
        return( {
            strMLFB: strMLFB,
            strSDShaft: oShaft.strShortDescription,
            strSDVoltage: '',
            strSDFastening: oFastening.strShortDescription, 
            strSDPower: '',
            strSDSpecification: '',
            strSDSPGTOL: '',
            strSDBART: '',
            strCHINA: '',
            strEAC: '',
            strULR_CSA: '',
            strCE: '',
            strEXPORT: ''
        } );
    }
}

