//@legacy
//#mode(full-ecma)


//@import "MLFB.MOTOX.SD.common.js"


/**
 * @category   MOTOX MLFB generation
 * @package    product logic
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * @constructor
 * get short descriptions for the common geared motor attributes, i.e. conservation, documentation and so on
 * 
 * @param oGear - geared motor object
 *
 * @return array - short descriptions for the common geared motor attributes,
 *                 each index contains a string with one short description (may be empty)
 */
function getGearedMotorDescriptions( oGear )
{
    var aShortDescriptions = [];

    _addRatingPlateDescriptions( oGear, aShortDescriptions );
    _addConservationDescriptions( oGear, aShortDescriptions );
    _addDocumentationDescriptions( oGear, aShortDescriptions );
    _addUmgebungDescriptions( oGear, aShortDescriptions );
    _addLieferungDescriptions( oGear, aShortDescriptions );

    return( aShortDescriptions );
}


/**
 * @constructor
 * add short descriptions for the rating plate to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - array with short descriptions that should be enhanced for rating plate descriptions
 */
function _addRatingPlateDescriptions( oGear, aShortDescriptions )
{
    // rating plate on stainless steel plate
    //if ( oGear.oConfig.bDocumentationRatingPlate )
    //	addShortDescription( aShortDescriptions, 'LSTGSAUSF', 'Niro' );
    
    // second rating plate
    var strSecondRatingPlate = ECL_GetValue("ZWEITES_LEISTUNGSCHILD_2KJ8");
    if ( strSecondRatingPlate === 'ZWEITESLEISTUNGSSCHILD_MONTIERT' )
        addShortDescription( aShortDescriptions, 'LSTGSMENGE', '2', 'LSTGS2LOSE', '-' );
    else if ( strSecondRatingPlate === 'ZWEITESLEISTUNGSSCHILD_BEIGELEGT' )
        addShortDescription( aShortDescriptions, 'LSTGS2LOSE', 'ja' );
    
    // free text on rating plate
    var strDocumentationFreeText = ECL_GetValue("LEISTUNGSSCHILD_ZUS_FREITEXT_2KJ8");
    if ( strDocumentationFreeText !== '' )
        aShortDescriptions.push( "+Y00'*LSF@" + strDocumentationFreeText + "*'" );
    
    // customer number on rating plate
    var strDocumentationCustomerNr = ECL_GetValue("LEISTUNGSSCHILD_ZUS_KUNDENNR_2KJ8");
    if ( strDocumentationCustomerNr !== '' )
        aShortDescriptions.push( "+Y00'*LSK@" + strDocumentationCustomerNr + "*'" );
    
}


/**
 * @constructor
 * add short descriptions for the conservation to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - array with short descriptions that should be enhanced for conservation descriptions
 */
function _addConservationDescriptions( oGear, aShortDescriptions )
{
    // lacquer
    var strLacquer = ECL_GetValue("OBERFLAECHENBEHANDLUNG_2KJ8");
    var strCoating = ECL_GetValue("BESCHICHTUNG_2KJ8");
    if ( strLacquer === 'UNLACKIERT' )
        strCoating = 'ohne';
    
    addShortDescription( aShortDescriptions, 'FARBNORM', strCoating );
    
    // painting color
    if ( ( strLacquer !== 'UNLACKIERT' ) && ( strLacquer !== 'GRUNDIERT' ) )
    {
        var strColor = ECL_GetValue("FARBE_2KJ8");
        var strSD = '';
        if ( strColor.length === 3 )
            strSD = strColor;
        else 
        {
            if ( strColor.indexOf( 'RAL' ) === 0 )
                strColor = replace( strColor, 'RAL', '' );
            strSD = getShortDescription( 'RALNR', strColor );
            if ( strSD === '' )
                strSD = "Y80'*RAL@" + strColor + "*'";
        }
        if ( strSD !== '' )
            aShortDescriptions.push( '+' + strSD );
    }
    
    
    // short description for pre treatment
    if ( ECL_ValueSelected("VORBEHANDLUNG_OPTION_2KJ8","T") )
        aShortDescriptions.push( '+L19' );
        
    // short description for lacquer on flange
    var strLacquerFlange = ECL_GetValue("LACKIERUNG_FLANSCH_2KJ8");
    if ( strLacquerFlange !== 'Standard' )
    {
        if ( strLacquerFlange === 'FKL' )
            strLacquerFlange = 'N716.32-02';
        else if ( strLacquerFlange === 'FLZN' )
            strLacquerFlange = 'N716.32-01';
        else if ( strLacquerFlange === 'FLZBN' )
            strLacquerFlange = 'N716.32-10';
        addShortDescription( aShortDescriptions, 'FARBMITLACK', strLacquerFlange );
    }
}


/**
 * @constructor
 * add short descriptions for the documentation to the array of short descriptions
 * 
 * @param oGear - geared motor object
 * @param aShortDescriptions - array with short descriptions that should be enhanced for documentation descriptions
 */
function _addDocumentationDescriptions( oGear, aShortDescriptions )
{
    // additional documentation for motor
    if ( ECL_ValueSelected("ZUSATZDOKUMENTATION_MOTOR_2KJ8","T") )
        addShortDescription( aShortDescriptions, 'PV_042', 'PV 042' );
        
    // additional documentation for gear
    if ( ECL_ValueSelected("ZUSATZDOKUMENTATION_GETRIEBE_2KJ8","T") )
        addShortDescription( aShortDescriptions, 'PV_043', 'PV 043' );
    
    // additional documentation for painting
    if ( ECL_ValueSelected("ZUSATZDOKUMENTATION_ANSTRICH_2KJ8","T") )
        addShortDescription( aShortDescriptions, 'PV_044', 'PV 044' );
    
    // additional documentation for projects
    if ( ECL_ValueSelected("ZUSATZDOKUMENTATION_PROJEKTE_2KJ8","T") )
        addShortDescription( aShortDescriptions, 'PV_045', 'PV 045' );
    
    // additional manual in german
    if ( ECL_ValueSelected("BETRIEBSANLEITUNG_DEUTSCH_2KJ8","T") )
        aShortDescriptions.push( '+W21' );
        
    // additional manual in chinese
    if ( ECL_ValueSelected("BETRIEBSANLEITUNG_CHINA_2KJ8","T") )
        aShortDescriptions.push( '+W23' );
    
    // additional manual in english
    if (  ECL_ValueSelected("BETRIEBSANLEITUNG_ENGLISCH_2KJ8","T" ) )
        aShortDescriptions.push( '+W22' );
    
    // Fasttrack
    if ( ECL_ValueSelected("SCHNELLSCHIENE_OPTION_2KJ8", "T" ) )
        aShortDescriptions.push( '+W50' );
}

function _addUmgebungDescriptions( oGear, aShortDescriptions )
{
    //Kurzangabe für Umgebung
    /*
    if(oGear.strAmbient == "SL")
    {
        //Säure Lauge
        if( (oGear.oConfig.strConservationCoating == "C3" || oGear.oConfig.strConservationCoating == "C4" || oGear.oConfig.strConservationCoating == "C5")  && oGear.oConfig.strOutputShaftSeal == "Dichtung erhoehte Belastung")
        {
            aShortDescriptions.push( '+N44' );
        }
    }
    else if(oGear.strAmbient == "FTU")
    {
        //Feucht tropisch
        if( (oGear.oConfig.strConservationCoating == "C2" || oGear.oConfig.strConservationCoating == "C3" || oGear.oConfig.strConservationCoating == "C4" || oGear.oConfig.strConservationCoating == "C5")  && (oGear.oConfig.strOutputShaftSeal == "Dichtung erhoehte Belastung" || oGear.oConfig.strOutputShaftSeal == "Dichtung laengere Lebensdauer") )
        {
            aShortDescriptions.push( '+N43' );
        }
    }
    */
    
    //Temperatur KA 
    if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "20_55" ))
    {
        aShortDescriptions.push( '+K94' );
    }
    else if( ECL_ValueSelected("AMBIENT_TEMPERATURE_2KJ8", "30_40" ))
    {
        aShortDescriptions.push( '+K97' );
    }
}		

function _addLieferungDescriptions( oGear, aShortDescriptions )
{
    // short description for Langzeitkonservierung
    if ( ECL_ValueSelected("LANGZEITKONSERVIERUNG_OPTION_2KJ8","T") )
        addShortDescription( aShortDescriptions, 'LZKONS', 'ja' );
        
    //Mängelhaftung
    if ( ECL_ValueSelected("MAENGELHAFTUNG_2KJ8", "12" ) )
        aShortDescriptions.push( '+W80' );
    else if ( ECL_ValueSelected("MAENGELHAFTUNG_2KJ8", "24" ) )
        aShortDescriptions.push( '+W82' );
}