//@legacy
//#mode(full-ecma)


//@import "Parser.ShortDescriptions.js"


/**
 * @category   SimoGear Parser
 * @package    Parser
 * @copyright  Copyright (c) 2012 Plan Software GmbH (http://www.plansoft.de)
 */


/**
 * @constructor
 * checks if a partial MLFB encodes a valid generation digit
 *
 * @param strGenerationDigitMLFB - partial MLFB for generation digit (MUST contain only one character)
 *
 * @return boolean - false: mlfb invalid
 *                   true: mlfb valid
 */
function checkGenerationDigit( strGenerationDigitMLFB )
{
    // must be 8 for 2KJ8
    if(strGenerationDigitMLFB === '8')
        return (true);
    else
        return (false);
}


/**
 * @constructor
 * checks if the gear type decoding of a MLFB part is valid for SimoGear
 *
 * @param strGearTypeMLFB - partial mlfb for the gear type (contains three digits)
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI if MLFB part is valid
 */
function checkGearType( strGearTypeMLFB, strRegion )
{
    // build select statement
    var strDigit5 = strGearTypeMLFB.charAt( 0 );
    var strDigit6 = strGearTypeMLFB.charAt( 1 );
    var strDigit7 = strGearTypeMLFB.charAt( 2 );
    
    var strSelect = "SELECT DISTINCT MLFB_2KJ8_5, MLFB_2KJ8_6, MLFB_2KJ8_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, EGBEZBRA, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI FROM MLFB8_EGTYP WHERE MLFB_2KJ8_5 = '" + strDigit5 + "' AND MLFB_2KJ8_6='" + strDigit6 + "' AND MLFB_2KJ8_7='" + strDigit7 + "' ";
    
    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    if ( aResult.length > 0 )
    {
        var strCheckSelect = "SELECT DISTINCT * FROM CD_GETRIEBE_BEZEICHNUNGEN WHERE EGBEZTYP='"+aResult[0].EGBEZTYP+"' AND EGBEZUEBS='"+aResult[0].EGBEZUEBS+"' AND EGBEZDIM='"+aResult[0].EGBEZDIM+"' AND EGBEZEI='"+aResult[0].EGBEZEI+"' AND EGBEZBRA='"+aResult[0].EGBEZBRA+"' AND ZGBEZUEBS='"+aResult[0].ZGBEZUEBS+"' AND ZGBEZDIM='"+aResult[0].ZGBEZDIM+"' AND ZGBEZEI='"+aResult[0].ZGBEZEI+"' ";
        
        var acheckResult = Object.fromDatabase( '2KJ8_DB', strCheckSelect );
        if(acheckResult.length > 0)
        {
            aResult[0].ANWTYP = acheckResult[0].ANWTYP;
            aResult[0].EGTYP = acheckResult[0].GETRIEBE_BEZ;
            aResult[0].EGBEZBRA = acheckResult[0].EGBEZBRA;
            return( aResult[0] );
        }
        else
            return( null );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the fastening decoding of a MLFB part is valid for SimoGear
 *
 * @param strFasteningMLFB - partial mlfb for the fastening (contains one digit)
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF if MLFB part is valid
 */
function checkFastening( strFasteningMLFB, strRegion, strEGBEZTYP, KeepConfiguration )
{
    var strSelect = "";
    if(strRegion =="CHINA")
        strSelect = "SELECT DISTINCT EGBEZBEF, EGABDMSTFIG, MLFB_2KJ_14, MLFB_2KJ_14_KA FROM MLFB4_EGBEF WHERE MLFB_2KJ_14 = '" + strFasteningMLFB + "' AND EGBEZTYP = '"+strEGBEZTYP+"' ";
    else
        strSelect = "SELECT DISTINCT EGBEZBEF, EGABDMSTFIG, MLFB_2KJ_14, MLFB_2KJ_14_KA FROM MLFB3_EGBEF WHERE MLFB_2KJ_14 = '" + strFasteningMLFB + "' AND EGBEZTYP = '"+strEGBEZTYP+"' ";
    
    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    if (KeepConfiguration)
    {
        //Bei Keep Configuration muss im Fall der Fälle die nicht funktionierende Welle mit der Default Welle überschrieben werden.
        if ( aResult.length > 0 )
        {
            aResult[0].KeepConfiguration="ok";
            return( aResult[0] );
        }
        else
        {
            //neuer Default Wert muss bestimmt werden
            //neue MLFB geht zurück
            aResult[0].KeepConfiguration="error";
            aResult[0].MLFB_2KJ_14 = "-"; //Default geht immer!
            return( aResult[0] );
        }		
    }
    else if ( aResult.length > 0 )
    {
        return( aResult[0] );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the shaft decoding of a MLFB part is valid for SimoGear
 *
 * @param strShaftMLFB - partial mlfb for the shaft (contains one digit)
 * @param strShaftSD - necessary short description for shaft (only valid if strShaftMLFB is 9)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 * @param oFastening - object that describes the fastening, attributes:
 *                     MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 * @param oShortDescriptions - object with short description information
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO if MLFB part is valid
 */
function checkShaft( strShaftMLFB, strShaftSD, oGearType, oFastening, oShortDescriptions, strRegion, KeepConfiguration )
{
    // the feature for gear industrial sector must be calculated from short descriptions at this poin
    
    // build select statement
    
    var strSelect
    if(strRegion == "CHINA")
    {
        strSelect = "SELECT EGTYP.TYPBEZ AS EGTYP, EGABKD_M3.EGABW AS EGABW, EGABKD_M3.EGABKDBEZ AS EGABKDBEZ,EGABKD_M3.WELLE_BDS AS WELLE_BDS,EGABKD_M3.WELLE_O_PF AS WELLE_O_PF,EGABKD_M3.EGABAUSF AS EGABAUSF, EGTYP.EGBEZAWTYP AS EGBEZAWTYP, EGTYP.EGBEZWNV AS EGBEZWNV, " + 
            "EGTYP.EGBEZBRA AS EGBEZBRA, EGTYP.ANWTYP AS ANWTYP, EGTYP.EGBEZSO AS EGBEZSO FROM MLFB4_EGTYP, EGTYP, EGABKD_M3 WHERE ";
    }
    else
    {
        strSelect = "SELECT EGTYP.TYPBEZ AS EGTYP, EGABKD_M3.EGABW AS EGABW, EGABKD_M3.EGABKDBEZ AS EGABKDBEZ,EGABKD_M3.WELLE_BDS AS WELLE_BDS,EGABKD_M3.WELLE_O_PF AS WELLE_O_PF,EGABKD_M3.EGABAUSF AS EGABAUSF, EGTYP.EGBEZAWTYP AS EGBEZAWTYP, EGTYP.EGBEZWNV AS EGBEZWNV, " + 
            "EGTYP.EGBEZBRA AS EGBEZBRA, EGTYP.ANWTYP AS ANWTYP, EGTYP.EGBEZSO AS EGBEZSO FROM MLFB3_EGTYP, EGTYP, EGABKD_M3 WHERE ";
    }
    
    
    strSelect = strSelect + "EGTYP.CDROM_REL = '1' AND EGABKD_M3.G115='0' AND ";
    
    
    if(strRegion == "CHINA")
    {
        strSelect = strSelect + "MLFB4_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB4_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB4_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 + 
                    "' AND EGABKD_M3.MLFB_2KJ_8 = '" + strShaftMLFB + 
                    "' AND EGTYP.EGBEZBEF = '" + oFastening.EGBEZBEF + 
                    "' AND EGTYP.EGBEZBRA = '" + oGearType.EGBEZBRA +
                    "' AND MLFB4_EGTYP.EGBEZTYP = EGTYP.EGBEZTYP AND MLFB4_EGTYP.EGBEZUEBS = EGTYP.EGBEZUEBS AND MLFB4_EGTYP.EGBEZDIM = EGTYP.EGBEZDIM AND " + 
                    "MLFB4_EGTYP.EGBEZEI = EGTYP.EGBEZEI AND EGTYP.TYPBEZ = EGABKD_M3.EGTYP ";
    }
    else
    {
        strSelect = strSelect + "MLFB3_EGTYP.MLFB_2KJ_5 = '" + oGearType.MLFB_2KJ_5 +
                    "' AND MLFB3_EGTYP.MLFB_2KJ_6 = '" + oGearType.MLFB_2KJ_6 + 
                    "' AND MLFB3_EGTYP.MLFB_2KJ_7 = '" + oGearType.MLFB_2KJ_7 + 
                    "' AND EGABKD_M3.MLFB_2KJ_8 = '" + strShaftMLFB + 
                    "' AND EGTYP.EGBEZBEF = '" + oFastening.EGBEZBEF + 
                    "' AND EGTYP.EGBEZBRA = '" + oGearType.EGBEZBRA +
                    "' AND MLFB3_EGTYP.EGBEZTYP = EGTYP.EGBEZTYP AND MLFB3_EGTYP.EGBEZUEBS = EGTYP.EGBEZUEBS AND MLFB3_EGTYP.EGBEZDIM = EGTYP.EGBEZDIM AND " + 
                    "MLFB3_EGTYP.EGBEZEI = EGTYP.EGBEZEI AND EGTYP.TYPBEZ = EGABKD_M3.EGTYP ";
    }
    
    if ( strShaftMLFB === '9' )
    {
        // necessary short description needed
        strSelect += " AND MLFB_2KJ_8_KA = '" + strShaftSD + "' ";
    }
    // we also must distinguish if a backstop or backlash design is present for the gear or not
    if ( 'G72' in oShortDescriptions )
        strSelect += " AND EGTYP.EGBEZSO = 'X' ";
    else if ( 'G99' in oShortDescriptions )
        strSelect += " AND EGTYP.EGBEZSO = 'W' ";
    else strSelect += " AND EGTYP.EGBEZSO = '-' ";
    
    //strSelect = strSelect + "AND EGTYP.S09 = '0' ";

    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    if (KeepConfiguration)
    {
        //Bei Keep Configuration muss im Fall der Fälle die nicht funktionierende Welle mit der Default Welle überschrieben werden.
        if ( aResult.length > 0 )
        {
            aResult[0].KeepConfiguration="ok";
            return( aResult[0] );
        }
        else
        {
            //neuer Default Wert muss bestimmt werden
            //neue MLFB geht zurück
            aResult[0] = Bestimme_AbtriebswellenmassforKeepConfiguration( oGearType, oFastening, oShortDescriptions);
            aResult[0].KeepConfiguration="error";
            return( aResult[0] );
        }		
    }
    else if ( aResult.length > 0 )
    {
        return( aResult[0] );
    }
    
    return( null );
}


/**
 * @constructor
 * checks if the gear ratio decoding of a MLFB part is valid for SimoGear
 *
 * @param strRatioMLFB - partial mlfb for the gear ratio (contains two digits)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2 if MLFB part is valid
 */
function checkRatio( strRatioMLFB, oGearType)
{
    var c15 = strRatioMLFB.charAt( 0 );
    var c16 = strRatioMLFB.charAt( 1 );
    
    
    var strSelect = "SELECT DISTINCT IGES_M3.DGUEB AS DGUEB, IGES_M3.EGUEB AS EGUEB, IGES_M3.ZGUEB AS ZGUEB, IGES_M3.ETA AS ETA, IGES_M3.T2FB1 AS T2FB1, IGES_M3.N2 AS N2 " + 
        "FROM MLFB8_EGTYP, IGES_M3 WHERE MLFB8_EGTYP.MLFB_2KJ8_5 = '" + oGearType.MLFB_2KJ8_5 +
        "' AND MLFB8_EGTYP.MLFB_2KJ8_6 = '" + oGearType.MLFB_2KJ8_6 + 
        "' AND MLFB8_EGTYP.MLFB_2KJ8_7 = '" + oGearType.MLFB_2KJ8_7 +
        "' AND MLFB8_EGTYP.EGBEZTYP = IGES_M3.EGBEZTYP AND MLFB8_EGTYP.EGBEZUEBS = IGES_M3.EGBEZUEBS AND MLFB8_EGTYP.EGBEZDIM = IGES_M3.EGBEZDIM AND MLFB8_EGTYP.EGBEZEI = IGES_M3.EGBEZEI AND " +
        "MLFB8_EGTYP.ZGBEZUEBS = IGES_M3.ZGBEZUEBS AND MLFB8_EGTYP.ZGBEZDIM = IGES_M3.ZGBEZDIM AND MLFB8_EGTYP.ZGBEZEI = IGES_M3.ZGBEZEI AND IGES_M3.MLFB_2KJ8_15 = '" + c15 + 
        "' AND IGES_M3.MLFB_2KJ8_16 = '" + c16 +
        "' AND IGES_M3.EGBEZBRA = '" + oGearType.EGBEZBRA + "' " +
        " AND IGES_M3.G115 = '1' " +
        " AND IGES_M3.SONDER = '-' " +
        " AND IGES_M3.REGION IN ('SACE','SACEN') ";

    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    if ( aResult.length > 0 )
        return( aResult[0] );
    
    return( null );
}


/**
 * @constructor
 * checks if the motor decoding of a MLFB part is valid for SimoGear
 *
 * @param strMotorMLFB - partial mlfb for the motor (contains five digits)
 * @param strVoltageSD - necessary short description for voltage (only valid if last digit of strMotorMLFB is 9)
 * @param oGearType - object that describes the gear type attributes:
 *                    MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI, M3
 * @param oShortDescriptions - object with short description information
 *                             each attribute name is a short description
 *                             each attribute value is an object with attributes group and freetext
 *
 * @return object - null, if MLFB part is invalid
 *                  attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, 
 *                  SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc.
 *                  (all columns of table CD_MOTOREN) if MLFB part is valid
 */
function checkMotor( strMotorMLFB, strG115PMMLFB, oGearType, oShortDescriptions, strRegion, incompleteSizerMLFB )
{
    var c8 = strMotorMLFB.charAt( 0 );		// motor size part 1
    var c9 = strMotorMLFB.charAt( 1 );		// motor size part 2
    var c10 = strMotorMLFB.charAt( 2 );		// motor type
    
    var c13 = strG115PMMLFB;
    
    var strSelect = "SELECT DISTINCT * FROM MOTFHT_2KJ8 WHERE MLFB_2KJ8_8 = '" + c8 + "' AND MLFB_2KJ8_9 = '" + c9 + "' AND MLFB_2KJ8_10 = '" + c10 + "' AND MLFB_2KJ8_13 = '" + c13 + "' ";
    strSelect = strSelect + "AND REGION = 'S' AND AKTIV='1' ";
    
    if(!incompleteSizerMLFB)
    {
        if ( 'M08' in oShortDescriptions )
            strSelect += " AND MOTWK = 'H' ";
        else strSelect += " AND MOTWK = 'F' ";
    }
    
    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    if ( aResult.length > 0 )
    {
        //Daten aus Tiegel Tabellen ergänzen
        var strSelect2="SELECT * FROM TMP_MOT_DATEN WHERE MLFB_08='"+c8+"' AND MLFB_09='"+c9+"' AND MLFB_10='"+c10+"' AND  MLFB_13='"+c13+"' ";
        var aResult2 = Object.fromDatabase( '2KJ8_DB', strSelect2 );
        if(aResult2.length > 0)
        {
            aResult[0].MOT_BZ_LANG=aResult2[0].MOT_BZ_LANG;
            aResult[0].strFrequency=aResult[0].FREQUENZ_1;
            aResult[0].strSpannung=aResult[0].MOTSPG_1+"V "+aResult[0].MOTSHLT1_1;
            aResult[0].strPAKLGE=aResult2[0].MOT_PAKLGE;
            aResult[0].strEFFKLASSE=aResult2[0].MOT_EFFIZIENZKL_KNZ;
        
            return( aResult[0] );
        }
        else
            return( null );
        
        
    }
    else
        return( null );
}

function checkBrake(strBrakeMLFB, oGearType, oMotor, oShortDescriptions, strRegion)
{
    var strSelect = "Select DISTINCT BREART, BRENENMO, BREREDMO FROM BRETYP_G115 WHERE ";
    strSelect=strSelect + "MLFB_2KJ8_12 = '" + strBrakeMLFB + "' AND ";
    strSelect=strSelect + "WIBLNR = '" + oMotor.WIBLNR + "' AND ";
    strSelect=strSelect + "WIBLAUSLG = '" + oMotor.WIBLAUSLG + "' AND ";
    strSelect=strSelect + "CDROM_REL = '1' AND AKTIV = '1' ";

    var aResult = ExecSQL_Standard_SO("2KJ8_DB", strSelect);
    if(aResult.length==1)
    {
        return aResult[0];
    }
    else
        return( null );

}

function checkG115D( strG115DMLFB, oGearType, oMotor, oShortDescriptions, strRegion)
{
    strKKMAT="";
    strKKMAT_ZUB="";
    var strG115D_KA = getSDFromGroup( oShortDescriptions, 'G115D_TYP' );
    var strG115D_24VDC_KA = getSDFromGroup( oShortDescriptions, 'G115D_24VDC' );
    
    if(strG115D_KA=="")
        strG115D_KA="-";
        
    var strSelect="SELECT DISTINCT KKMAT, KKMAT_ZUB, G115_BUSSYSTEM, G115_BUSSYSTEM_VS, G115_BUSSYSTEM_POS FROM G115_ADPT WHERE ";
    strSelect=strSelect+"MLFB_2KJ8_14='"+strG115DMLFB+"' AND ";
    strSelect=strSelect+"G115_ADPT_OPTION='"+strG115D_KA+"' AND ";
    strSelect=strSelect+"MOTDIM='"+oMotor.MOTDIM+"' AND ";
    
    if(strG115D_24VDC_KA != "")
        strSelect=strSelect+"G115_EXTANB='24VDC Anschluss' ";
    else
    {
        if(strG115D_KA=="-")
        {
            //Wallmounted
            strSelect=strSelect+"G115_EXTANB='-' AND ";
            var strKKMAT_KA = getSDFromGroup( oShortDescriptions, 'MOTORSTECKER' );
            var strKKMAT_ZUB_KA = getSDFromGroup( oShortDescriptions, 'GEGENSTECKER' );
            if(strKKMAT_KA=="")
            {
                strKKMAT="Aluminium";
                strKKMAT_ZUB="ohne";
            }
            else if(strKKMAT_KA=="N06")
            {
                strKKMAT="HAN10-1Buegel+EMV";
                strKKMAT_ZUB="ohne";
            }
            else if(strKKMAT_KA=="N13")
            {
                strKKMAT="HAN Q12-1Buegel+EMV";
                strKKMAT_ZUB="ohne";
            }
            
            strSelect=strSelect+"KKMAT='"+strKKMAT+"' AND ";
            strSelect=strSelect+"KKMAT_ZUB='"+strKKMAT_ZUB+"' ";
            
        }
        else
            strSelect=strSelect+"G115_EXTANB='ohne' ";
    }
    
    var aResult = Object.fromDatabase( '2KJ8_DB', strSelect );
    
    if(strG115D_KA!="-")
    {
        if ( aResult.length > 0 )
        {
            aResult[0].G115_BUSSYSTEM_VS=replace(aResult[0].G115_BUSSYSTEM_VS,'"','_Zoll');
            
            var strSelect="SELECT DISTINCT G115_KLEMMK_KOMBINATION FROM M_G115_KLEMMK_M_ANSCHLUSS WHERE "
            strSelect=strSelect+"MOT_KLEMMK_AUSF_KEY = '"+aResult[0].KKMAT+"' AND ";
            strSelect=strSelect+"MOT_KLEMMK_ZUB_KEY = '"+aResult[0].KKMAT_ZUB+"' AND ";
            
            if(strG115D_KA=="-")
                strSelect = strSelect + "PRODUKT_G115_KNZ = 'W' AND ";
            else
                strSelect = strSelect + "PRODUKT_G115_KNZ = 'M' AND ";
                
            if(strG115D_24VDC_KA != "")
                strSelect=strSelect+"G115_EXTANB_KEY='24VDC Anschluss' AND ";
            else
            {
                if(strG115D_KA=="-")
                    strSelect=strSelect+"G115_EXTANB_KEY='-' AND ";
                else
                    strSelect=strSelect+"G115_EXTANB_KEY='ohne' AND ";
            }
                
            strSelect=strSelect+"G115_BUSSY_KEY='"+aResult[0].G115_BUSSYSTEM+"' AND ";
            strSelect=strSelect+"G115_BUSSY_VS_KEY='"+replace(aResult[0].G115_BUSSYSTEM_VS,'_Zoll','"')+"' ";
            
            var aResult2 = Object.fromDatabase( '2KJ8_DB', strSelect );
            if ( aResult2.length == 1 )
            {
                aResult[0].G115_ANSCHLUSSTECHNIK_2KJ8=aResult2[0].G115_KLEMMK_KOMBINATION;
                return( aResult[0] );
            }
            
            return( null );
        }
        else
            return( null );
    }
    else
    {
        return( aResult[0] );
    }
}

function checkAntriebsgruppe( strMotorMLFB, strVoltageSD, oGearType, oShortDescriptions, strRegion, oRatio )
{
    /*
    Stelle 9: Baugröße des Adapters
    Stelle 10: Kenner für die Zolltarifnummer. Bei Getriebe ohne Motor ist das immer A (Stelle 11 = 0).
    Stelle 11: Bei Getriebe ohne Motor immer die 0. Die 8 benötigen wir später für den angebauten Motor.
    Stelle 12 definiert den Adaptertyp.
    Der Vollständigkeit halber: Stelle 13 ist immer 0, wir haben ja keine Spannung
    */
    
    var c9 = strMotorMLFB.charAt( 0 );		
    var c10 = strMotorMLFB.charAt( 1 );		
    var c11 = strMotorMLFB.charAt( 2 );		
    var c12 = strMotorMLFB.charAt( 3 );		
    var c13 = strMotorMLFB.charAt( 4 );	
    
    //Neuerung, Stellen 9 bis 12 kommen nicht mehr aus SIZER, nur noch "."
    
    var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if(strStartConfiguration=="" && find(strMotorMLFB, ".") >= 0)
        strStartConfiguration="1" ;
    
    if(c9 == "." && c10 == "." && c11 == "." && c12 == "." && strStartConfiguration=="1")
    {
        //Wir nehmen den Default Adapter aus dem Context
        var strDefaultAdapter = ECL_GetValue("ECSI_CX_DefaultGearboxAdapter");
        
        //for Testing
        //strDefaultAdapter="2KJ3....DA04....";
        
        if(!strDefaultAdapter)
            return( null );
            
        //Jetzt aus dem String die Stelle 9 bis 12 extrahieren
        // Beispiel 2KJ3....FA02....
        c9 = strDefaultAdapter.charAt( 8 );		
        c10 = strDefaultAdapter.charAt( 9 );		
        c11 = strDefaultAdapter.charAt( 10 );		
        c12 = strDefaultAdapter.charAt( 11 );		
        c13 = "0";
    }
    
    var strMLFB_AVTYP = "MLFB_AVTYP";
    if(strRegion == "CHINA")
        strMLFB_AVTYP = "MLFB4_AVTYP";
    
    var strBaseSelect = "SELECT * FROM CD_AVEINHEITEN,"+strMLFB_AVTYP+",CD_GETRIEBE, CD_GETRIEBE_BEZEICHNUNGEN WHERE " + 
                        " MLFB_2KJ_9 = '" + c9 + 
                        "' AND MLFB_2KJ_10 = '" + c10 + 
                        "' AND MLFB_2KJ_11 = '" + c11 + 
                        "' AND MLFB_2KJ_12 = '" + c12 + "' ";
    if ( 'A08' in oShortDescriptions )
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = 'A08' ";
    }
    else
    {
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_OPTION = '-' ";
    }
    
    if ( 'M1A' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1A' ";
    else if ( 'M1B' in oShortDescriptions )
        strBaseSelect += " AND "+strMLFB_AVTYP+".MLFB_2KJ_12_KA = 'M1B' ";
    
    
    strBaseSelect += " AND LKB = '-' ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVTYPDIM = "+strMLFB_AVTYP+".AVTYPDIM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AV_TYP_KZ = "+strMLFB_AVTYP+".AVMLFBTYP ";
    
    if ( 'A17' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT = 'Rutschkupplung' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.KUEINHEIT <> 'Rutschkupplung' ";
    
    if ( 'A15' in oShortDescriptions )
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '1' ";
    else
        strBaseSelect += " AND CD_AVEINHEITEN.AV_RLSP = '0' ";
        
    if ( 'G99' in oShortDescriptions )
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = 'W' ";
    else
        strBaseSelect += " AND CD_GETRIEBE_BEZEICHNUNGEN.EGBEZSO = '-' ";
    
    strBaseSelect += " AND CD_GETRIEBE.EGBEZTYP = '"+oGearType.EGBEZTYP+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZUEBS = '"+oGearType.EGBEZUEBS+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZDIM = '"+oGearType.EGBEZDIM+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGBEZEI = '"+oGearType.EGBEZEI+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZUEBS = '"+oGearType.ZGBEZUEBS+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZDIM = '"+oGearType.ZGBEZDIM+"' ";
    strBaseSelect += " AND CD_GETRIEBE.ZGBEZEI = '"+oGearType.ZGBEZEI+"' ";
    strBaseSelect += " AND CD_GETRIEBE.EGUEB = '"+oRatio.EGUEB+"' ";
    
    strBaseSelect += " AND CD_GETRIEBE.AVMOKDBEZ = CD_AVEINHEITEN.MAVABKD ";
    strBaseSelect += " AND CD_GETRIEBE.GETRIEBE_BEZ = CD_GETRIEBE_BEZEICHNUNGEN.GETRIEBE_BEZ ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABFLD = CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM ";
    strBaseSelect += " AND CD_AVEINHEITEN.AVABSSAR = CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART ";
    strBaseSelect += " AND CD_AVEINHEITEN.BRANCHE = '"+oGearType.ANWTYP+"' ";
    
    var aResult = Object.fromDatabase( '2KJ8_DB', strBaseSelect );
    if ( aResult.length > 0 )
    {
        var strPolzahl=ECL_GetValue("ECSI_CX_MotorPoleCount");
        
        if(strPolzahl=="")
        {
            if ( 'P20' in oShortDescriptions )
                strPolzahl="2";
            else
                strPolzahl="4";
                
            ECL_SetValue("ECSI_CX_MotorPoleCount",strPolzahl);
        }
        
        var strAVTYP = aResult[0].AV_TYP_KZ;
        var iAVDIM = parseInt(aResult[0].AV_GROESSE_KZ);
        
        //K4 Laterne geht mit Polzahl 2 nur bis BG 200
        if(strPolzahl=="2" && (strAVTYP=="K4" && iAVDIM >=225) )
            return( null );
        else
            return( aResult[0] );
    }
    
    
    return( null );
}

function checkSpannungMotorsteckerFktglr(oDlg,oMOTOX,oMOTOXHandler,strRegion)
{
    var strDBName = "2KJ8_DB";
    var aSpannung = [];
    var strSpannung;
    var strFrequenz;
    var strWIBLAUSLG_DUMMY;
    var strMotorschaltung;
    
    var strDBResult = "SPANNUNG_CHECK";
    
    var strMotorstecker = oMOTOX.oConfig.strMotorConnector;
    
    if(strMotorstecker == "ohne")
    {
        if(parseInt(oMOTOX.GearData.MOTDIM) > 160)
            strMotorstecker = "GG";
        else
            strMotorstecker = "Aluminium";
    }
    
    var MMSystem = oMOTOX.MMSystem;
    var strMotortabelle = Controller.Dlg.Motox.BaseFunctions.getSQLStatementforRegionParser(strRegion);
    
    var strSelect = "SELECT DISTINCT "+strMotortabelle+".MLFB_2KJ_13,"+strMotortabelle+".MLFB_2KJ_13_KA,"+strMotortabelle+".MLFB_2KJ_13_SPGTOL,CD_SPANNUNGEN_AUSGABE.MOTSPG,CD_SPANNUNGEN_AUSGABE.FREQUENZ,CD_SPANNUNGEN_AUSGABE.FREQUENZ_TOL,"+strMotortabelle+".SCHALTUNG_S,CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY,"+strMotortabelle+".WARMEKL FROM "+strMotortabelle+",CD_SPANNUNGEN_AUSGABE,EKAT_WIBLAUSLG_FUER_SPANNUNG WHERE ";
    
    strSelect = strSelect + "MOTELAUSF_AUSG = '"+oMOTOX.strSpecification+"' AND ";
    
    
    if(oMOTOX.strFrequency == "50")
    {	
        if(oMOTOXHandler.strProduct == "GETRIEBEMOTOR.G110M" || oMOTOXHandler.strProduct == "GETRIEBEMOTOR.G110M_SIP" || oMOTOXHandler.strProduct == "SIZER.G110M" || ((oMOTOXHandler.strProduct == 'ARCHIMEDES') && oMOTOXHandler.getDriveConfigurationHandler().bG110M))
        {
            strSelect += "("+strMotortabelle+".FREQUENZ = '50') AND ";
        }
        else
        {
            strSelect += "("+strMotortabelle+".FREQUENZ = '50' OR "+strMotortabelle+".FREQUENZ = '50 // 60' OR "+strMotortabelle+".FREQUENZ = '50 // 87') AND ";
        }
        
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_50 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_50 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_50 = '1') AND ";
    }
    else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
    {
        strSelect += "("+strMotortabelle+".FREQUENZ = '60' OR "+strMotortabelle+".FREQUENZ = '50 // 60') AND ";
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_60 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_60 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_60 = '1') AND ";
    }
    else if(oMOTOX.strFrequency == "87")
    {
        strSelect += "("+strMotortabelle+".FREQUENZ = '87' OR "+strMotortabelle+".FREQUENZ = '50 // 87') AND ";
        if(oMOTOX.strEfficiencyClass == "IE1")
            strSelect += "(IE1_OHNE_BEM = '1' OR IE1_OHNE_NETZ_87 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE2")
            strSelect += "(IE2_BEM = '1' OR IE2_NETZ_87 = '1') AND ";
        else if(oMOTOX.strEfficiencyClass == "IE3")
            strSelect += "(IE3_BEM = '1' OR IE3_NETZ_87 = '1') AND ";
    }
    
    strSelect += strMotortabelle+".POLZAHL = '"+oMOTOX.strPoles+"' AND ";
    strSelect += strMotortabelle+".MOTDIM = '"+oMOTOX.GearData.MOTDIM+"' AND ";
    
    if(oMOTOX.oConfig.bWithBrake)
        strSelect = strSelect + "(BRE_KENNER='1' OR BRE_KENNER='2') AND "
    else
        strSelect = strSelect + "(BRE_KENNER='0' OR BRE_KENNER='2') AND "
    
    if(MMSystem == "SI")
    {
        if(oMOTOX.strFrequency == "50")
        {	
            strSelect = strSelect +  "P50_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
        {
            strSelect = strSelect +  "P60_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "87")
        {
            strSelect = strSelect +  "P87_P1 = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
    }
    else if(MMSystem == "US")
    {
        if(oMOTOX.strFrequency == "50")
        {	
            strSelect = strSelect +  "P50_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "60" || oMOTOX.strFrequency == "60_L50")
        {
            strSelect = strSelect +  "P60_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
        else if(oMOTOX.strFrequency == "87")
        {
            strSelect = strSelect +  "P87_P1_IMP = cast('"+oMOTOX.GearData.LEISTUNG+"' AS FLOAT) AND ";
        }
    }
    
    strSelect += strMotortabelle+".WIBLAUSLG_DUMMY = CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY AND ";
    strSelect += strMotortabelle+".ATEX = '0' AND ";
    strSelect += strMotortabelle+".SUCHTYP = '"+oMOTOX.GearData.MOTBEZ+"' AND ";
    
    if(oMOTOX.oConfig.strBrakeFunctionRectifier == "ohne")
        strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.FKTGLR_KNZ = '0' AND ";
    else
        strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.FKTGLR_KNZ = '1' AND ";
    
    strSelect = strSelect + "EKAT_WIBLAUSLG_FUER_SPANNUNG.WIBLAUSLG_DUMMY = CD_SPANNUNGEN_AUSGABE.WIBLAUSLG_DUMMY "
    
    if(oMOTOX.strFrequency == "50")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_50 = 'P(50)' ";
    else if(oMOTOX.strFrequency == "60")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_60 = '1,2xP(50)' ";
    else if(oMOTOX.strFrequency == "60_L50")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_60 = 'P(50)' ";
    else if(oMOTOX.strFrequency == "87")
        strSelect = strSelect + "AND FAKTOR_LEISTUNG_87 = 'P(87)' ";
        
    strSelect = strSelect + "AND "+strMotortabelle+".BETR_ART_P1 = '"+oDlg.strOperatingMode+"' ";
    
    if(oMOTOX.BrakeData.BRESHLT != "")
        strSelect = strSelect + "AND "+strMotortabelle+".BRESHLT = '"+oMOTOX.BrakeData.BRESHLT+"' ";
        
    strSelect = strSelect + "AND "+strMotortabelle+".WARMEKL = '"+oDlg.strWindingTemperatureClass+"' ";	
    strSelect = strSelect + "AND EKAT_WIBLAUSLG_FUER_SPANNUNG.KKMAT = '"+strMotorstecker+"' ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        logtraceln("Spannung Parser OK! SQL="+strSelect);
        return (true);
    }
    else
    {
        logtraceln("Spannung Parser ERROR! SQL="+strSelect);
        return(false);
    }
    
}

function checkMotorGetriebeBaubarkeit( oResult, strRegion )
{
    //Überprüfung ob Motor und Getriebe mit Übersetzung zusammenpasst
    var strMotortabelle = "CD_MOTOREN_ANBAU";
    
    var strSelect = "";
    strSelect = "SELECT DISTINCT * ";
    strSelect = strSelect + "FROM CD_GETRIEBE,"+strMotortabelle+",CD_GETRIEBE_BEZEICHNUNGEN WHERE ";
    strSelect = strSelect + "CD_GETRIEBE.AVMOKDBEZ = "+strMotortabelle+".MOABKDBEZ AND ";	
    strSelect = strSelect + "CD_GETRIEBE.GETRIEBE_BEZ = CD_GETRIEBE_BEZEICHNUNGEN.GETRIEBE_BEZ AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART = "+strMotortabelle+".MOABSSAR AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM = "+strMotortabelle+".MOABFLDM AND ";
    strSelect = strSelect + strMotortabelle+".MOTDIM='"+oResult.oParsingData.oMotor.MOTDIM+"' AND ";
    
    
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZBRA = '"+oResult.oParsingData.oGearType.EGBEZBRA+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZEI = '"+oResult.oParsingData.oGearType.EGBEZEI+"' AND ";
    
    strSelect = strSelect + "CD_GETRIEBE.EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZBRA = '"+oResult.oParsingData.oGearType.EGBEZBRA+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGBEZEI = '"+oResult.oParsingData.oGearType.EGBEZEI+"' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGUEB = '"+oResult.oParsingData.oRatio.EGUEB+"' ";
    
    //bestimmte Getriebemotoren rauswerfen!
    strRegionAbfrage = " WHERE REGION like 'S%' ";
        
    strSelect = strSelect + "AND CD_GETRIEBE.EGBEZTYP||CD_GETRIEBE.EGBEZUEBS||CD_GETRIEBE.EGBEZBRA||CD_GETRIEBE.EGBEZDIM||CD_GETRIEBE.EGBEZEI||'LE'||"+strMotortabelle+".MOTDIM NOT IN (";
    strSelect = strSelect + "SELECT EGBEZTYP||EGBEZUEBS||EGBEZBRA||EGBEZDIM||EGBEZEI||MOTTYP||MOTDIM FROM KONFIG_UNDEF2 "+strRegionAbfrage+" AND KONFIG_UNDEF2.ZGBEZUEBS = '-' AND KONFIG_UNDEF2.ZGBEZDIM = '-' AND KONFIG_UNDEF2.ZGBEZEI = '-') ";

    
    strSelect = strSelect + "AND CD_GETRIEBE_BEZEICHNUNGEN.REGION = 'EUR' ";
    strSelect = strSelect + "AND CD_GETRIEBE.REGION = 'EUR' ";

    var strDBName = "2KJ8_DB"; 
    var strDBResult = "CHECKGEARMOTOR";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        if(oResult.oParsingData.oGearType.EGBEZBRA == "K" && (oResult.oParsingData.oMotor.MOTDIM=="225" || oResult.oParsingData.oMotor.MOTDIM=="250") && oResult.oParsingData.oMotor.SpecString.indexOf("UL-R/CSA")>-1)
            return false;
        
        return (true);
    }
    else
    {
        //Baubarkeit Motor-Getriebe fehlgeschlagen
        var strMOTBEZ="";
        if(oResult.oParsingData.oGearType.ANWTYP=="KleinSchnecke")
            strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+"I"+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");
        else
            strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");

        logtraceln("*************************************************");
        logtraceln("Baubarkeit Motor-Getriebe fehlgeschlagen");
        logtraceln("Getriebe:"+oResult.oParsingData.oGearType.EGTYP);
        logtraceln("Übersetzung:"+oResult.oParsingData.oRatio.EGUEB);
        logtraceln("Motorbezeichung:"+strMOTBEZ);
        logtraceln("*************************************************");
        
        return (false);
    }
}

function checkMotorGetriebeBaubarkeit2( oResult, strRegion )
{
	//Zweite Abfrage über KONFIG_UNDEF6
	var strSelect = "";
	strSelect = "SELECT DISTINCT * ";
	strSelect = strSelect + "FROM KONFIG_UNDEF6 WHERE ";
	
	strSelect = strSelect + "EGBEZTYP = '"+oResult.oParsingData.oGearType.EGBEZTYP+"' AND ";
	strSelect = strSelect + "EGBEZUEBS = '"+oResult.oParsingData.oGearType.EGBEZUEBS+"' AND ";
	strSelect = strSelect + "EGBEZDIM = '"+oResult.oParsingData.oGearType.EGBEZDIM+"' AND ";
	strSelect = strSelect + "MOTDIM = '"+oResult.oParsingData.oMotor.MOTDIM+"' AND ";
	strSelect = strSelect + "MOTTYP = '"+oResult.oParsingData.oMotor.MOTTYP+"' AND ";
	
	if(oResult.oParsingData.strG115=="WM")
		strSelect = strSelect + "G115D = '1' AND ";
	else if(oResult.oParsingData.strG115=="MM")
		strSelect = strSelect + "G115M = '1' AND ";
		
	strSelect = strSelect + "WM_FU = '1' ";
	
	var strDBName = "2KJ8_DB"; 
	var strDBResult = "CHECKGEARMOTOR2";
	if ( dbselect( strDBName, strSelect, strDBResult ) == 0 )
	{
		return (true);
	}
	else
	{
		//Baubarkeit Motor-Getriebe fehlgeschlagen
		var strMOTBEZ="";
		if(oResult.oParsingData.oGearType.ANWTYP=="KleinSchnecke")
			strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+"I"+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");
		else
			strMOTBEZ = replace((oResult.oParsingData.oMotor.MOTTYP+oResult.oParsingData.oMotor.MOEINKL+oResult.oParsingData.oMotor.MOTDIM+oResult.oParsingData.oMotor.PAKZUS+oResult.oParsingData.oMotor.PAKLGE+oResult.oParsingData.oMotor.POLZAHL+oResult.oParsingData.oMotor.HEMOTOR+oResult.oParsingData.oMotor.VSDMOTOR),"-","");

		logtraceln("*************************************************");
		logtraceln("Baubarkeit Motor-Getriebe fehlgeschlagen (KONFIG_UNDEF6");
		logtraceln("Getriebe:"+oResult.oParsingData.oGearType.EGTYP);
		logtraceln("Übersetzung:"+oResult.oParsingData.oRatio.EGUEB);
		logtraceln("Motorbezeichung:"+strMOTBEZ);
		logtraceln("*************************************************");
		
		return (false);
	}
}

function checkChinaKranAntrieb( strBaseMLFB, strMotorMLFB, oGearType, oShortDescriptions, strRegion)
{
    var strDBName = "2KJ8_DB";
    
    if(strBaseMLFB.left(4) == "2KJ8")
        return (false);
        
    var strDBResult = "KRAN_CHECK";
    
    var strMotortabelle = "MOTFHT";
    
    
    var strMLFB_9 = strMotorMLFB.left(1);
    var strMLFB_10 = strMotorMLFB.substring(1,2);
    var strMLFB_11 = strMotorMLFB.substring(2,3);
    var strMLFB_12 = strMotorMLFB.substring(3,4);
    var strMLFB_13 = strMotorMLFB.right(1);
    
    var strSelect = "SELECT DISTINCT HEMOTOR,BETR_ART_P1,MOTTYP FROM "+strMotortabelle+" WHERE MLFB_2KJ_9='"+strMLFB_9+"' AND MLFB_2KJ_10='"+strMLFB_10+"' AND MLFB_2KJ_11='"+strMLFB_11+"' AND MLFB_2KJ_12='"+strMLFB_12+"' AND MLFB_2KJ_13='"+strMLFB_13+"' ";
    
    if ( dbselect( strDBName, strSelect, strDBResult ) > 0 )
    {
        var strHEMOTOR = dbgetstring( strDBResult, 'HEMOTOR' );
        var strMOTTYP = dbgetstring( strDBResult, 'MOTTYP' );
        var strBETR_ART_P1 = dbgetstring( strDBResult, 'BETR_ART_P1' );
        
        
        if(strHEMOTOR == "-" && strBETR_ART_P1 == "S3-75%" && strMOTTYP == "LH")
        {
            logtraceln("Kranantrieb CHINA!");
            return (true);
        }
        else
            return (false);
    }
    else
    {
        logtraceln("Kranantrieb China ERROR! SQL="+strSelect);
        return(false);
    }
}