//@legacy
/**
 * @category   SimoGear Parser
 * @package    Parser
 * @copyright  Copyright (c) 2012/2013/2014 Plan Software GmbH (http://www.plansoft.de)
 */


// building the namespace
if ( typeof( Parser ) === 'undefined' )
    Parser = {};	
if ( typeof( Parser.MOTOX ) === 'undefined' )
    Parser.MOTOX = {};	

/**
 * @constructor
 * transforms the parsing results from the parsing process to the complete product and product handler hierarchy needed for further 
 * processing the product in the xCat NG catalog
 *
 * @param oParsing - results from the parsing process
 *                   strError - error message from parsing (empty, if parsing succeeded)
 *                   strWarning - additional warning message (may be nonempty even if parsing succeeded)
 *                   oShortDescriptions - object for short descriptions (and optional corresponding freetext)
 *                                        each attribute name is a short description
 *                                        each attribute value is an object with attributes group and freetext (the freetext string may be empty)
 *                                        may not be present on parsing error
 *                   oProduct - simogear geared motor product object (will not be present on parsing errors)
 *                   oParsingData - parsing data object: contains parsing data results from different parsing stages (not all subobjects may be present due to parsing errors)
 *                       			oGearType: parsing results for MLFB gear type part, contains attributes MLFB_2KJ_5, MLFB_2KJ_6, MLFB_2KJ_7, EGBEZTYP, EGBEZUEBS, EGBEZDIM, 
 *								    		   EGBEZEI, ZGBEZUEBS, ZGBEZDIM, ZGBEZEI
 *                       			oShaft: parsing results for MLFB gear output shaft part, contains attributes EGTYP, EGABW, EGBEZAWTYP, EGBEZWNV, EGBEZBRA, ANWTYP, EGBEZSO
 *                       			oFastening: parsing results for MLFB gear fastening part, contains attributes MLFB_2KJ_14, MLFB_2KJ_14_KA, EGBEZBEF
 *                       			oRatio: parsing results for MLFB gear ratio part, contains attributes DGUEB, ZGUEB, EGUEB, ETA, T2FB1, N2
 *                       			oMotor: parsing results for MLFB motor part, contains attributes MLFB_2KJ_9, MLFB_2KJ_10, MLFB_2KJ_11, MLFB_2KJ_12, MLFB_2KJ_13, MLFB_2KJ_P_KA, 
 *         					     			MLFB_2KJ_13_KA, SO_NEMA_KA, SO_NEMA, SO_CSA_UL_R_KA, SO_CSA_UL_R, SO_GOST_KA, SO_GOST, SO_CHINA_KA, SO_CHINA, SO_CE_KA, SO_CE, WARMEKL, 
 *                               			WIBLNR, WIBLAUSLG, POLZAHL, FREQUENZ, MOTDIM, FU, NETZ, SUCHTYP etc. (all columns of table CD_MOTOREN)
 *
 * @return object - FlenderProjectHandler object that is properly filled to be processed further by the catalog
 */
Parser.MOTOX.transform = function( oParsing )
{
    // product object has been created before to check the technical buildability of the MLFB
    if ( !oParsing || !oParsing.oProduct || !oParsing.oProduct.oConfig )
        return( null );
    
    // build new project handler
    var oHandler = createFlenderProjectHandler((oParsing.strRegion ? {strRegion : oParsing.strRegion} : null));
    
    // adjust drive train handler
    // remember: handlers are constructed by the getter-functions of the 'parent' handler via lazy initialisation
    var oDriveTrainHandler = oHandler.getDriveTrainHandler();
    oDriveTrainHandler.strBackwardDialog = 'DIREKTEINGABEBESTELLNUMME_WEBFORM';

    // adjust gear handler
    var oMotoxHandler = oDriveTrainHandler.getMOTOXHandler();
    oMotoxHandler.strBackwardDialog = 'DIREKTEINGABEBESTELLNUMME_WEBFORM';
    var oMotox = oMotoxHandler.getMOTOX();
    Base.applyValues(oMotox, oParsing.oProduct);
    
    //oMotoxHandler._motox = Base.deepClone( oParsing.oProduct );	// I still don't trust the EasyScript garbage collector
    
    
    oMotoxHandler.strProduct = oMotox.strProduct;
    oMotoxHandler.strDriveGroup = oMotox.strDriveGroup;
    oMotoxHandler.strGear = oMotox.strGear;
    oMotoxHandler.strMotor = oMotox.strMotor;
    
    if(oMotox.oConfig.strProtectionCover != "")
        oMotox.oConfig.bOtherMotorProtectionCover = true;
    
    oMotoxHandler.bCHINA = oParsing.oProduct.bCHINA;
    oMotoxHandler.bCSA_UL_R = oParsing.oProduct.bCSA_UL_R;
    oMotoxHandler.bEAC = oParsing.oProduct.bEAC;
    
    //Schutzart umstellen
    if(oMotoxHandler.strProduct == "GETRIEBE.ADAPTER" || oMotoxHandler.strProduct == "GETRIEBE.ADAPTER.ATEX" || oMotoxHandler.strProduct == "GETRIEBE.ADAPTER.ATEX_SIP" || oMotoxHandler.strProduct == "GETRIEBE.ADAPTER_SIP")
    {
        oMotox.oConfig.strDegreeOfProtection = '-';	
        oMotoxHandler.strAdapter = oMotox.strAdapter;
    }
    
    
    oMotoxHandler.strGearboxType = oMotox.strGearboxType;
        
    // environments (since they are not set via short descriptions, we can only guess)
    oMotoxHandler.strApplications = oParsing.oParsingData.oShaft.ANWTYP;
    oMotoxHandler.strInstallationConditions = 'INNENAUFSTELLUNG';
    
    oMotoxHandler.strAmbient = oMotox.strAmbient;
/*	
    // guess from sealing and motor options
    // N54 or N41 -> special condition for ambient, but may only be possible for 'NORMAL'
    if ( ( 'N54' in oParsing.oShortDescriptions ) || ( 'N41' in oParsing.oShortDescriptions ) )
    {
        oMotoxHandler.strInstallationConditions = 'AUSSENAUFSTELLUNG';
        // since G24 is the only sealing that can be selected for enhanced corrosion protection
        if ( 'G24' in oParsing.oShortDescriptions )
            oMotoxHandler.strAmbient = 'FTU';
        else oMotoxHandler.strAmbient = 'SL';
    }
    // others not supported in version 1
*/
    // power rating
    oMotoxHandler.strGearboxType = oMotox.strGearboxType;
    oMotoxHandler.strSpecification = oMotox.strSpecification;
    oMotoxHandler.strFrequency = oMotox.strFrequency;
    oMotoxHandler.strEfficiencyClass = oMotox.strEfficiencyClass;
    
    if ( oMotoxHandler.oDialogHistory )
    {
        oMotoxHandler.oDialogHistory.dCatalog = 1;
        oMotoxHandler.oDialogHistory.dEnvironment = 1;
        oMotoxHandler.oDialogHistory.dPowerRating_GM = 1;
        oMotoxHandler.oDialogHistory.dPowerRating_M = 1;
        oMotoxHandler.oDialogHistory.dResults = 1;
    }
    
    // adjust gear and gear configuration attributes
    
    Controller.Dlg.Motox.Config.Design._Simoloc_Sonderbehandlung_Parser(oDlg,oMotox,oMotox.GearData.NENNMOMENT);
    
    //Werte aus Vorauswahl setzen
    /*
    if(oMotoxHandler.strProduct == "GETRIEBE.ADAPTER.ATEX" || oMotoxHandler.strProduct == "GETRIEBE.ADAPTER.ATEX_SIP")
    {
        var oATEX = oMotox.getAtex();
        Utils.TechValue.setValueAsNumber(oATEX.oMaxDrehzahl, oMotox.dInputSpeed, "1/min", "1/min");
        Utils.TechValue.setValueAsNumber(oATEX.oMinDrehzahl, oMotox.dInputSpeed, "1/min", "1/min");
        Utils.TechValue.setValueAsNumber(oATEX.oMotorPower, oMotox.strMotorPowerGA, "kW", "kW");
    }
    */
    
    Base.applyValues(getFlenderProjectHandler().getDriveTrainHandler().getMOTOXHandler(),oHandler._drivetrainHandler._MOTOXHandler);

    oMotoxHandler.setDefaultConfigData();
        
    return( oHandler );
}

