//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"


//@import "models/CFG_2KJ_BREMSE_Model.js"

//@import "../2KJ_MLFB/SD/MLFB.MOTOX.SD.common.js"


function SetBremse_Init(strchangedAttribute,oData,oDataBremse)
{
    //Erst feststellen, ob Bremse obligatorisch oder gar nicht möglich ist
    var iResult=checkBremse(oData);
    
    if(ECL_GetValue("SCHUTZART")=="IP56")
        iResult=0;
    
    if(iResult==0)
    {
        //Bremse nicht erlaubt
        ECL_DeselectAttribute("MIT_BREMSE");
        ECL_DisableAttribute("MIT_BREMSE")
    }
    else if(iResult==1)
    {
        //Nur mit Bremse erlaubt
        ECL_SelectValue("MIT_BREMSE", "T");
        ECL_DisableAttribute("MIT_BREMSE");
    }
    else if(iResult==2)
    {
        //Bremsenauswahl kommt aus SIZER
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        if(strwithBrake=="")
            ECL_EnableAttribute("MIT_BREMSE");
        
        if(strwithBrake=="1" || strwithBrake=="Yes")
        {
            ECL_EnableAttribute("MIT_BREMSE");
            
            ECL_SelectValue("MIT_BREMSE", "T");
            ECL_DisableAttribute("MIT_BREMSE");
        }
        else if(strwithBrake=="0" || strwithBrake=="No")
        {
            ECL_EnableAttribute("MIT_BREMSE");
            
            ECL_DeselectValue("MIT_BREMSE", "T");
            ECL_DisableAttribute("MIT_BREMSE");
        }
    }
}


function SetBremse_Init_Sizer(oData,oDataBremse)
{
    Check_BREMSE_SAFETY(oData,oDataBremse);
    Bestimme_BREMSENTYP(oData,oDataBremse);
}

function SetBremse_InitOptions(strchangedAttribute,oData,oDataBremse)
{
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP"));

    Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
    Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
    Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
    Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
    Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
    Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
    Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
    
    if(ECL_GetValue("BREMSE_HANDLUEFTUNG") != "-")
    {
        ECL_ActivateAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_EnableAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_DisableAttribute("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
    }
            
    Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
}

function SetBremse(strchangedAttribute,oData,oDataBremse)
{
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        oDataBremse.oRow = splitSelectedBrake(ECL_GetValue("BREMSENTYP"));
        
    var bGeber = ( strchangedAttribute=="MIT_GEBER" || strchangedAttribute=="GEBER_AUSFUEHRUNG" || strchangedAttribute=="GEBER_FUNKT_SICHERHEIT" || strchangedAttribute=="GEBER_IMPULSZAHL" || strchangedAttribute=="GEBER_ELEKTRONIK" || strchangedAttribute=="GEBER_EINGANGSFREQUENZ" || strchangedAttribute=="GEBER_AUSGANGSSIGNALE" || strchangedAttribute=="GEBER_MECH_VAR" || strchangedAttribute=="GEBER_DIREKTAUSWAHL" || strchangedAttribute=="GEBER_MECHSCHUTZ" );
                
    switch(strchangedAttribute){
        case "SCHUTZART" :
        case "BELUEFTUNG" :
        case "SCHUTZDACH_OPTION" :
            SetBremse_Init(strchangedAttribute,oData);
            Bestimme_BREMSENTYP(oData);
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
        case "BREMSE_SAFETY" :
            Bestimme_BREMSENTYP(oData);
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
            break;
        case "BREMSENTYP" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse);
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse);
            Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
            Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
            break;
        case "BREMSE_STEUERSPANNUNG" :
            Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse);
            break;
        case "BREMSE_FUNKTIONSGLEICHRICHTER" :
            Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse);
            break;
        case "BREMSE_AUSFUEHRUNG" :
            Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse);
            Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
            break;
        case "BREMSE_HANDLUEFTUNG" :
            break;
        case "SPEZIFIKATION_CHINA" :
        case "SPEZIFIKATION_EAC" :
            SetBremse_Init(strchangedAttribute,oData);
        case "ANSCHLUSSKASTEN_VERGOSSEN_OPTION" :
            Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse);
        break;
    }
    
    if(bGeber)
    {
        Bestimme_BREMSE_REIBBELAG(oData,oDataBremse);
        Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse);
    }
    
    if(ECL_GetValue("BREMSE_HANDLUEFTUNG") != "-")
    {
        ECL_ActivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_EnableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse);
    }
    else
    {
        ECL_DeactivateAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_DisableAttribute ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
        ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
    }
}