//@legacy
//#mode(full-ecma)








function setDefaultValues(oDataGear)
{
    //wichtige Default Werte setzen, bei Attributen wichtiug, die ausgewertet werden sollen ohne gesetzt zu sein.
    //Motorstecker wird vorher in Kabelverschraubung ausgewertet
    ExecSetStandardifValueEmpty("MOTORSTECKER","M");
    ExecSetStandardifValueEmpty("VERSANDSCHALTUNG","-");
    ExecSetStandardifValueEmpty("GEGENSTECKER","ohne");
    
    //Schutzart setzen für Getriebeentlüftung
    ExecSetStandardifValueEmpty("SCHUTZART","IP55");
    
    //Geber Kabel Zubehör für Geber
    ExecSetStandardifValueEmpty("GEBER_ZUB_KABEL","-");

    ExecSetStandardifValueEmpty("ANTRIEBSGRUPPE_DICHTUNG","-");
    ExecSetStandardifValueEmpty("ANTRIEBSGRUPPE_LAGERUNG","-");

    //Wird für Motor Rücklaufsperre benötigt
    ExecSetStandardifValueEmpty("BREMSE_HANDLUEFTUNG","-");
    ExecSetStandardifValueEmpty("BREMSE_REIBBELAG","normal");
    ExecSetStandardifValueEmpty("BREMSE_AUSFUEHRUNG","N");
    ExecSetStandardifValueEmpty("BREMSE_UEBERWACHUNG","ohne");
    ExecSetStandardifValueEmpty("BREMSE_FUNKTIONSGLEICHRICHTER","ohne");
 
    ExecSetStandardifValueEmpty("BELUEFTUNG","Kunststoff");
    ExecSetStandardifValueEmpty("DRIVETRAIN_ANBAULAGE","1");
    
    //Bei Kühlturmantrieben ist Anschlusskasten vergossen Default.
    if(oDataGear.oRow.EGBEZBRA=="K")
    {
        ECL_DeselectValue("ANSCHLUSSKASTEN_VERGOSSEN_OPTION","T");
    }
    
    
    //Checkboxen mit Default Werten laden
    if(!ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
        ECL_DeselectAttribute ("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION");
    
    if(!ECL_ValueSelected("WASSERABLAUF_OPTION", "T"))
        ECL_DeselectAttribute ("WASSERABLAUF_OPTION");
        
    if(!ECL_ValueSelected("SPIELREDUZIERT_OPTION", "T"))
        ECL_DeselectAttribute ("SPIELREDUZIERT_OPTION");
        
    if(!ECL_ValueSelected("GEKLEBTES_ENDSTUFENRAD_OPTION", "T"))
        ECL_DeselectAttribute ("GEKLEBTES_ENDSTUFENRAD_OPTION");
        
    if(!ECL_ValueSelected("RUTSCHKUPPLUNG_ADAPTER_OPTION", "T"))
        ECL_DeselectAttribute ("RUTSCHKUPPLUNG_ADAPTER_OPTION");
        
    if(!ECL_ValueSelected("RUECKLAUFSPERRE_ADAPTER_OPTION", "T"))
        ECL_DeselectAttribute ("RUECKLAUFSPERRE_ADAPTER_OPTION");
        
    if(!ECL_ValueSelected("DREHRICHTUNG_ADAPTER_OPTION", "T"))
        ECL_DeselectAttribute ("DREHRICHTUNG_ADAPTER_OPTION");
        
    if(!ECL_ValueSelected("KONDENSWASSERLOCH_ADAPTER_OPTION", "T"))
        ECL_DeselectAttribute ("KONDENSWASSERLOCH_ADAPTER_OPTION");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_CHINA", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_CHINA");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_ULR_CSA", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_ULR_CSA");
        
    if(!ECL_ValueSelected("SPEZIFIKATION_EAC", "T"))
        ECL_DeselectAttribute ("SPEZIFIKATION_EAC");
        
    if(!ECL_ValueSelected("ERHOEHTE_LEISTUNG_OPTION", "T"))
        ECL_DeselectAttribute ("ERHOEHTE_LEISTUNG_OPTION");
        
    if(!ECL_ValueSelected("SPANNUNGSTOLERANZ_OPTION", "T"))
        ECL_DeselectAttribute ("SPANNUNGSTOLERANZ_OPTION");
        
    if(!ECL_ValueSelected("SAEURESCHUTZ_OPTION", "T"))
        ECL_DeselectAttribute ("SAEURESCHUTZ_OPTION");
        
    if(!ECL_ValueSelected("ERDUNGSSCHRAUBE_OPTION", "T"))
        ECL_DeselectAttribute ("ERDUNGSSCHRAUBE_OPTION");
        
    if(!ECL_ValueSelected("ANSCHLUSSKASTEN_NEUTRAL_OPTION", "T"))
        ECL_DeselectAttribute ("ANSCHLUSSKASTEN_NEUTRAL_OPTION");
        
    if(!ECL_ValueSelected("ANSCHLUSSKASTEN_VERGOSSEN_OPTION", "T"))
        ECL_DeselectAttribute ("ANSCHLUSSKASTEN_VERGOSSEN_OPTION");
        
    if(!ECL_ValueSelected("MIT_BREMSE", "T"))
        ECL_DeselectAttribute ("MIT_BREMSE");
        
    if(!ECL_ValueSelected("BREMSE_SAFETY", "T"))
        ECL_DeselectAttribute ("BREMSE_SAFETY");
        
    if(!ECL_ValueSelected("BREMSE_BREMSKABELSCHUTZ_OPTION", "T"))
        ECL_DeselectAttribute ("BREMSE_BREMSKABELSCHUTZ_OPTION");
        
    if(!ECL_ValueSelected("MIT_GEBER", "T"))
        ECL_DeselectAttribute ("MIT_GEBER");
        
    if(!ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION", "T"))
        ECL_DeselectAttribute ("RUECKLAUFSPERRE_MOTOR_OPTION");
        
    if(!ECL_ValueSelected("DREHRICHTUNG_MOTOR_OPTION", "T"))
        ECL_DeselectAttribute ("DREHRICHTUNG_MOTOR_OPTION");
        
    if(!ECL_ValueSelected("ZWEITES_WELLENENDE_OPTION", "T"))
        ECL_DeselectAttribute ("ZWEITES_WELLENENDE_OPTION");

    if(!ECL_ValueSelected("HANDRAD_OPTION", "T"))
        ECL_DeselectAttribute ("HANDRAD_OPTION");
        
    if(!ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
        ECL_DeselectAttribute ("SCHUTZDACH_OPTION");
        
    if(!ECL_ValueSelected("KONDENSWASSERBOHRUNG_OPTION", "T"))
        ECL_DeselectAttribute ("KONDENSWASSERBOHRUNG_OPTION");
        
    if(!ECL_ValueSelected("INNENKORROSIONSSCHUTZ_OPTION", "T"))
        ECL_DeselectAttribute ("INNENKORROSIONSSCHUTZ_OPTION");
        
    if(!ECL_ValueSelected("VORBEHANDLUNG_OPTION", "T"))
        ECL_DeselectAttribute ("VORBEHANDLUNG_OPTION");
        
    if(!ECL_ValueSelected("LANGZEITKONSERVIERUNG_OPTION", "T"))
        ECL_DeselectAttribute ("LANGZEITKONSERVIERUNG_OPTION");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_DEUTSCH", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_DEUTSCH");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_ENGLISCH", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_ENGLISCH");
        
    if(!ECL_ValueSelected("BETRIEBSANLEITUNG_CHINA", "T"))
        ECL_DeselectAttribute ("BETRIEBSANLEITUNG_CHINA");
        
    if(!ECL_ValueSelected("GEKLEBTES_ENDSTUFENRAD_OPTION", "T"))
        ECL_DeselectAttribute ("GEKLEBTES_ENDSTUFENRAD_OPTION");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_MOTOR", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_MOTOR");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_GETRIEBE", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_GETRIEBE");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_ANSTRICH", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_ANSTRICH");
        
    if(!ECL_ValueSelected("ZUSATZDOKUMENTATION_PROJEKTE", "T"))
        ECL_DeselectAttribute ("ZUSATZDOKUMENTATION_PROJEKTE");
        
    if(!ECL_ValueSelected("SCHNELLSCHIENE_OPTION", "T"))
        ECL_DeselectAttribute ("SCHNELLSCHIENE_OPTION");
        
    if(!ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T"))
        ECL_DeselectAttribute ("ISDRIVETRAIN_OPTION");
        
    if(!ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
        ECL_DeselectAttribute ("SONDEREINBAULAGE_OPTION");
}

function checkMLFBandConfiguration(onewMLFB)
{
    //2KJ3104-.GJ27-9.L1-Z +N1N
    //check the MLFB and the configuration
    if(ECL_GetValue ("ECSI_2KJ_MODE") != "EASYKAT_CONFIG")
    {
        var stroldMLFB=ECL_GetValue("ECSI_MLFB");
        
        if(find(stroldMLFB.left(16),".")>-1)
        {
            stroldMLFB=normalizeMLFB( stroldMLFB );
            var aoldMLFB=tokenize( stroldMLFB, true );
        
            if(aoldMLFB.length > 5)
            {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_TOO_MANY_SHORTDESCRIPTIONS"));
                
                return;
            }
            var ooldMLFB=sanatizeSizerMLFB( aoldMLFB[0], aoldMLFB[1], aoldMLFB[2], aoldMLFB[3], aoldMLFB[4], aoldMLFB[5] );
        
            //teilqualifizierte MLFB, relevante Stellen vergleichen
            //zuerst Base MLFB so umbauen, dass an Stelle 8 und 14 Punkte stehen
            var strnewMLFB=onewMLFB.strBaseMLFB;
            
            
            if(ECL_GetValue("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
            {
                if(stroldMLFB.charAt(9)==".")
                    strnewMLFB=strnewMLFB.slice(0,8)+"....."+strnewMLFB.slice(13,14)+".."+strnewMLFB.slice(16,18);
                else
                    strnewMLFB=strnewMLFB.slice(0,8)+"."+strnewMLFB.slice(9,14)+".."+strnewMLFB.slice(16,18);
            }
            else
                strnewMLFB=strnewMLFB.slice(0,8)+"."+strnewMLFB.slice(9,15)+"."+strnewMLFB.slice(16,18);
            
            if(ooldMLFB.strMLFB != strnewMLFB)
            {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_BASE"));
                
                return;
            }
            
            if(ooldMLFB.strVoltageSD!= "")
            {
                if(ooldMLFB.strVoltageSD!=onewMLFB.strVoltageSD)
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_VOLTAGE"));
                    
                    return;
                }
            }
            
            if(ooldMLFB.strSpecificationSD!= "")
            {
                if(ooldMLFB.strSpecificationSD!=onewMLFB.strSpecificationSD)
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_SPECIFICATION"));
                    
                    return;
                }
            }
            
            if(ooldMLFB.strVentilationSD!= "")
            {
                if(ooldMLFB.strVentilationSD!=onewMLFB.strVentilationSD)
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_VENTILATION"));
                    
                    return;
                }
            }
            
            if(!checkBAUFORM())
            {
                ECL_SelectValue ("ECSI_STATUS", "E");
                ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_BAUFORM"));
                
                return;
            }
            
            if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
            {
                //hier noch P94,P95,P96 und K72 und K74
                if(ooldMLFB.strBetriebsartSD!= "")
                {
                    if(ooldMLFB.strBetriebsartSD!=onewMLFB.strBetriebsartSD)
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_ATEX_UMRICHTER"));
                        
                        return;
                    }
                }
                
                if(ooldMLFB.strATEXZoneSD!= "")
                {
                    if(ooldMLFB.strATEXZoneSD!=onewMLFB.strATEXZoneSD)
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_ATEX_ZONE"));
                        
                        return;
                    }
                }
                    
            }
            
        }
        else
        {
            //2KJ3104-1GJ27-9AL1-Z D03 +K01 +K06 +L02 +M16 +M55 +N1N +P92 +Y80 {Y80: *RAL(a)6029*}
            //KomplettMLFB
            
            var strFreetextColor="";
            if(find(stroldMLFB,'{Y80')>-1)
            {
                strFreetextColor = stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y80')+1);
                stroldMLFB = replace(stroldMLFB,strFreetextColor,"");
                strFreetextColor = replace(strFreetextColor,"{","");
                strFreetextColor = replace(strFreetextColor,"*}","*'");
                strFreetextColor = replace(strFreetextColor,": *","'*");
                strFreetextColor = replace(strFreetextColor,":*","'*");
            }
            
            var strFreetext="";
            if(find(stroldMLFB,'{Y00')>-1)
            {
                strFreetext = stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y00')+1);
                stroldMLFB = replace(stroldMLFB,stroldMLFB.right(stroldMLFB.length-find(stroldMLFB,'{Y00')+1),"")
                strFreetext = replace(strFreetext,"{","");
                strFreetext = replace(strFreetext,"*}","*'");
                strFreetext = replace(strFreetext,": *","'*");
                strFreetext = replace(strFreetext,":*","'*");
            }
            
            stroldMLFB=normalizeMLFB( stroldMLFB );
            var aoldMLFB=tokenize( stroldMLFB, false );
            var stroldMLFB=aoldMLFB[0];
            var newMLFB=replace(onewMLFB.strBaseMLFB,"-","");
            
            var aShortDescriptions=[];
            var j=0;
            for(var i=1;i<aoldMLFB.length;i++)
            {
                if(aoldMLFB[i]!="Y80" && aoldMLFB[i]!="Y00")
                {
                    aShortDescriptions[j]="+"+aoldMLFB[i];
                    j++;
                }
            }
            
            if(strFreetextColor!="")
            {
                aShortDescriptions[j]="+"+strFreetextColor;
                j++;
            }
            
            if(strFreetext!="")
            {
                aShortDescriptions[j]="+"+strFreetext;
                j++;
            }
            
            aShortDescriptions.sort();
            aoldMLFB = buildFormattedShortDescriptions( aShortDescriptions, 'MOTOX_' );
            
            if(aoldMLFB.strStrippedShortDescriptions!=onewMLFB.strStrippedShortDescriptions && ECL_GetValue("ECSI_MLFB_CAN_CHANGE") != "TRUE")
            {
                    if(find(aoldMLFB.strStrippedShortDescriptions,"N53")>-1 && find(onewMLFB.strStrippedShortDescriptions,"N53")<0)
                    {
                        //N53 wurde entfernt
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_N53"));
                    }
                    else if(find(aoldMLFB.strStrippedShortDescriptions,"G45")<0 && find(onewMLFB.strStrippedShortDescriptions,"G45")>-1)
                    {
                        //G45 wurde ergänzt
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR_G45"));
                    }
                    else
                    {
                        ECL_SelectValue ("ECSI_STATUS", "E");
                        ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                    }
                    
                    return;
            }
            
            if(stroldMLFB!=newMLFB && ECL_GetValue("ECSI_MLFB_CAN_CHANGE") != "TRUE")
            {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                    
                    return;
            }
            
            if(aoldMLFB.strFormattedShortDescriptions!=onewMLFB.strFormattedShortDescriptions && ECL_GetValue("ECSI_MLFB_CAN_CHANGE") != "TRUE")
            {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___MLFB_GENERATING_MLFB_ERROR"));
                    
                    return;
            }
            
        }
    }
    
    //Attribute überprüfen
    var aAttributes=ECL_GetAllAttributes();
    
    for(var i=0;i<aAttributes.length;i++)
    {
        var controlType = ECL_GetControlType(aAttributes[i]);
       
        var visible = ECL_AttributeVisible(aAttributes[i]);                       
        
        if(ECL_AttributeActive(aAttributes[i]) && visible == true && left(aAttributes[i],5)!="ECSI_" && controlType!="EDIT" && controlType !="CHECK_H")
        {
            if (ECL_GetValue(aAttributes[i]) != "")
            {
                var aSelectedValues=ECL_GetAllActiveAttributeValues(aAttributes[i]);
                if(aSelectedValues.length>0)
                {
                    
                }
                else
                {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___CONFIG_ATTRIBUTES")+" ("+ECL_TranslateAttribute (aAttributes[i])+")");
                    
                    logtraceln("Attribute "+aAttributes[i]+" hat keine Werte zur Auswahl!");
                
                    return;
                }
            }
            else
            {
                    ECL_SelectValue ("ECSI_STATUS", "E");
                    ECL_SetValue ("ECSI_STATUS_MESSAGE", translate("ERROR_2KJ___CONFIG_ATTRIBUTES")+" ("+ECL_TranslateAttribute (aAttributes[i])+")");
                    
                    logtraceln("Attribute "+aAttributes[i]+" hat keinen gesetzten Wert");
                    return;
            }
        }
    }
    
    ECL_SelectValue ("ECSI_STATUS", "OK");
    ECL_SetValue ("ECSI_STATUS_MESSAGE", "");

}

function checkContextValues(oDataGear, bfull)
{
    //Contex Variablen überprüfen, ob dieser zur Konfiguration passen.
    
    //Antriebsleistung und Antriebsdrehzahl bei Adapter
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        // Fehlermeldung, falls Daten aus E-Zeile nicht mit Daten aus Context übereinstimmt
        //Context
        var strMotorRatedPower = ECL_GetValue("ECSI_CX_MotorRatedPower");
        var strMotorRatedSpeed = ECL_GetValue("ECSI_CX_MotorRatedSpeed");
        
        //aus E-Zeile
        if(bfull)
        {
            if( !strMotorRatedPower || !strMotorRatedSpeed )
            {
                //Error
                return("ERRORMSG_MLFB_SIMOGEAR_2KJ___ADAPTER_CONTEXT_ERROR");
            }
            else
            {
                var oMLFB = buildFormattedMLFB( oDataGear, true);
                var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
                ECL_SetValue("ECSI_MLFB",strMLFB);
                logtraceln("MLFB="+strMLFB);
            }
        }
        
    }
    
    
    var strProduct=ECL_GetValue ("ECSI_2KJ_TYPE");
    if(strProduct != "GETRIEBE.ADAPTER")
    {
        //Überprüfung BremsenContext
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        
        var iResult=checkBremse(oDataGear);
        if( (strwithBrake=="1" || strwithBrake=="Yes") && iResult==0)
            return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE")
        
        if(bfull)
        {
            if( (strwithBrake=="1" || strwithBrake=="Yes")&& !ECL_ValueSelected("MIT_BREMSE", "T"))
            {
                //return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE2")
                ECL_SetValue("ECSI_MLFB_CAN_CHANGE", "TRUE");
            }
            else if( (strwithBrake=="0" || strwithBrake=="No") && ECL_ValueSelected("MIT_BREMSE", "T"))
            {
                //return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_BRAKE2")
                ECL_SetValue("ECSI_MLFB_CAN_CHANGE", "TRUE");
            }
                
            //tfreichel Bremsencontex 2021.04 aktiviert
        }
    }
    
    
    //Hier kann nichts getan werden
    var iAmbientTemperature = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor"));
    if(isNaN(iAmbientTemperature))
        iAmbientTemperature=25;
    
    
    if( (ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED") && iAmbientTemperature>40)
    {
        //ATEX nur bis 40 Grad
        return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_NOT_SUPPORTED")
    }
    else if(iAmbientTemperature>45)
    {
        //Nur bis 45 Grad erlaubt!
        return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_NOT_SUPPORTED")
    }
    
    if(iAmbientTemperature > 40)
    {
        //K92 needs to be present
        if(bfull)
        {
            if(ECL_GetValue("ECSI_TEMPERATURE_SD") != "K92")
                return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_CHANGED")
        }
    }
    else if (iAmbientTemperature <= 40)
    {
        //No K92 must be present
        if(bfull)
        {
            if(ECL_GetValue("ECSI_TEMPERATURE_SD") == "K92")
                return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_TEMPERATURE_CHANGED")
        }
    }
    
    oDataGear.oRow.SIZER_AmbientTemperatureMotor = iAmbientTemperature;
    
    //***********************
    //Zuerst Befestigungsart
    
    var iMountingPosition = parseInt(ECL_GetValue("ECSI_CX_MountingPosition"));
    
    if(isNaN(iMountingPosition))
    {
        if(oDataGear.oRow.ANWTYP=="Kuehlturm")
            iMountingPosition = 2;
        else
            iMountingPosition = 1;
    }
        
    var strCX_Bauform="";
    var strCX_Abtriebsseite="";
    var strCX_BAUFORM_EGPOS="";
    
    if(iMountingPosition < 7)
    {
        strCX_Bauform = "M"+iMountingPosition;
        
        if(oDataGear.oRow.EGBEZTYP == "-" || oDataGear.oRow.EGBEZTYP == "F")
        {
            strCX_Abtriebsseite = "-";
            strCX_BAUFORM_EGPOS = strCX_Bauform;
        }
        else
        {
            strCX_Abtriebsseite = "A";
            strCX_BAUFORM_EGPOS = strCX_Bauform + "-A";
        }
    }
    else
    {
        strCX_Bauform = "M"+(iMountingPosition-6);
            
        if(oDataGear.oRow.EGBEZTYP == "-" || oDataGear.oRow.EGBEZTYP == "F")
        {
            strCX_Abtriebsseite = "-";
            strCX_BAUFORM_EGPOS = strCX_Bauform;
        }
        else
        {
            strCX_Abtriebsseite = "B";
            strCX_BAUFORM_EGPOS = strCX_Bauform + "-B";
        }
    }

	// Es sind für bestimmte Getriebe nicht alle Abtriebsseiten möglich.
	// hier prüfen!
	var bpossible=checkEinbaulageContext(oDataGear, strCX_BAUFORM_EGPOS);
	
	if(bpossible)
	{
		if(!bfull)
		{
			//Teilqualifizierte MLFB, Werte können gesetzt werden.
			ECL_SetValue("BAUFORM",strCX_Bauform);
			ECL_SetValue("ECSI_BAUFORM_EGPOS",strCX_BAUFORM_EGPOS);
			ECL_SetValue("ABTRIEBSSEITE",strCX_Abtriebsseite);
		}
		else
		{
			//Komplett MLFB
			//aktuelle Werte aus der Konfiguration
			var strConfig_Bauform=ECL_GetValue("BAUFORM");
			var strConfig_BAUFORM_EGPOS=ECL_GetValue("ECSI_BAUFORM_EGPOS");
			var strConfig_Abtriebsseite=ECL_GetValue("ABTRIEBSSEITE");
		
			if(strConfig_Bauform==strCX_Bauform && strConfig_Abtriebsseite==strCX_Abtriebsseite && strConfig_BAUFORM_EGPOS==strCX_BAUFORM_EGPOS)
			{
				//Werte haben sich nicht geändert, keine Aktion nötig
			}
			else
			{
				//vorerst immer Fehler ausgeben
				return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_MOUNTING_TYPE";
				
				/*
				if( ECL_ValueEnabled ("BAUFORM",strCX_Bauform ) && ECL_ValueEnabled ("ABTRIEBSSEITE",strCX_Abtriebsseite ))
				{
					ECL_SetValue("BAUFORM",strCX_Bauform);
					ECL_SetValue("ECSI_BAUFORM_EGPOS",strCX_BAUFORM_EGPOS);
					ECL_SetValue("ABTRIEBSSEITE",strCX_Abtriebsseite);
					
					//Die MLFB in ECSI_MLFB muss noch angepasst werden, da es sonst zu einem Fehler kommt
					var oMLFB = buildFormattedMLFB( oDataGear, true);
					var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
					ECL_SetValue("ECSI_MLFB",strMLFB);
					logtraceln("MLFB="+strMLFB);
				}
				else
				{
					return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_MOUNTING_TYPE";
				}
				*/
				
			}
		}
	}
	else
	{
		return "ERROR_2KJ___CX_CONTEXT_MOUNTING_TYPE_NOTVALID";
	}
    if(ECL_GetValue("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
    {
        
        //Test wenn M23 in BaseType kommt
        var strBaseTypeMLFB=ECL_GetValue("ECSI_MLFB_BASE_TYPE");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,"-","");
        strBaseTypeMLFB=replace(strBaseTypeMLFB,strBaseTypeMLFB.left(16),"");
        
        
        
        if(find(strBaseTypeMLFB,"M23")>-1)
        {
            var bRet = Check_Fremdbelueftung(oDataGear);
            if(!bRet)
                return "ERROR_2KJ___SHORTDESCRIPTION_FORCEDVENTILATION";
        }
        
        
        //******************
        //Belüftungs-Daten aus SIZER
        
        var iCoolingMethod = parseInt(ECL_GetValue("ECSI_CX_CoolingMethodMotor"));
        if(isNaN(iCoolingMethod))
            iCoolingMethod=0;
        
        if(iCoolingMethod>1)
        {
            //nur 0 (Eigenbelüftet)
            //und 1 (Fremdbelüftung)
            return("ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION_NOT_SUPPORTED")
        }
        else if(!bfull)
        {
            //Teilqualifizierte MLFB
            var ForcedVentilationMandatory=find(strBaseTypeMLFB, "M23") > -1;
            var SelfVentilatedMandatory=find(strBaseTypeMLFB, "M23") < 0;
            
            if( (iCoolingMethod==1 && SelfVentilatedMandatory) || (iCoolingMethod==0 && ForcedVentilationMandatory) )
                return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION";
            else
                oDataGear.oRow.SIZER_CoolingMethod=iCoolingMethod;
        }
        else
        {
            //Komplette MLFB
            oDataGear.oRow.SIZER_CoolingMethod=iCoolingMethod;
            
            var strValueSelected=ECL_GetValue("BELUEFTUNG");
            
            //Default Wert für Belüftung
            if(strValueSelected=="")
                strValueSelected="Kunststoff";
                
            //Bestimme_Belueftung(oDataGear);
            if(iCoolingMethod==0)
            {
                if(strValueSelected=="Schwungradluefter" || strValueSelected=="Metall" || strValueSelected=="Metall (Standard_ATEX)" || strValueSelected=="Kunststoff" || strValueSelected=="Standard" || strValueSelected=="Standard (Metall)")
                {
                    //schon gesetzt, nix tun
                }
                else
                {
                    //vorerst immer Fehler ausgeben
                    return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION";
                    
                    /*
                    if(ECL_ValueEnabled ("BELUEFTUNG","Kunststoff" ))
                    {
                        ECL_SelectValue("BELUEFTUNG","Kunststoff");
                    }
                    else if(ECL_ValueEnabled ("BELUEFTUNG","Metall" ))
                    {
                        ECL_SelectValue("BELUEFTUNG","Metall");
                    }
                    else if(ECL_ValueEnabled ("BELUEFTUNG","Schwungradluefter" ))
                    {
                        ECL_SelectValue("BELUEFTUNG","Schwungradluefter");
                    }
                    else
                    {
                        return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION";
                    }
                    */
                }
            }
            else if(iCoolingMethod==1)
            {
                
                if(strValueSelected=="Zugeordneter Luefter")
                {
                    //schon gesetzt, nix tun
                }
                else
                {
                    //vorerst immer Fehler ausgeben
                    return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION";
                    
                    /*
                    if(ECL_ValueEnabled ("BELUEFTUNG","Zugeordneter Luefter" ))
                    {
                        ECL_SelectValue("BELUEFTUNG","Zugeordneter Luefter");
                    }
                    else
                    {
                        return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_VENTILATION";
                    }
                    */
                }
            }
            
            //Die MLFB in ECSI_MLFB muss noch angepasst werden, da es sonst zu einem Fehler kommt
            
            /*
            var oMLFB = buildFormattedMLFB( oDataGear, true);
            var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
            ECL_SetValue("ECSI_MLFB",strMLFB);
            logtraceln("MLFB="+strMLFB);
            */
        }
        
        
        //*********************
        //Geber-Daten aus SIZER
        var iEncoderTypeRough = parseInt(ECL_GetValue("ECSI_CX_EncoderTypeRough"));
        if(isNaN(iEncoderTypeRough))
            iEncoderTypeRough=-1;
                
        if(!bfull)
        {
            //Teilqualifizierte MLFB
            oDataGear.oRow.SIZER_EncoderTypeRough=iEncoderTypeRough;
        }
        else
        {
            //Komplett MLFB
            oDataGear.oRow.SIZER_EncoderTypeRough=iEncoderTypeRough;
            if( iEncoderTypeRough != 0 && iEncoderTypeRough != 1)
            {
                //Kein Geber aus dem SIZER
                //nichts tun, Einstellungen bleiben!
            }
            else
            {
                
                var strValueSelected=ECL_GetValue("GEBER_AUSFUEHRUNG");
                var strGeberEnabled=ECL_GetValue("MIT_GEBER");
                
                if(iEncoderTypeRough==0)
                {
                    if(strValueSelected=="IN" && strGeberEnabled=="T")
                    {
                        //schon gesetzt, nix tun
                    }
                    else
                    {
                        //vorerst immer Fehler ausgeben
                        return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_ENCODER";
                        
                        /*	
                        if(ECL_ValueEnabled ("GEBER_AUSFUEHRUNG","IN" ) && ECL_ValueEnabled ("MIT_GEBER","T" ))
                        {
                            Bestimme_GEBER_AUSFUEHRUNG(oDataGearGEBER_AUSFUEHRUNG);
                            ECL_SetValue("MIT_GEBER","T");
                            ECL_SelectValue("GEBER_AUSFUEHRUNG","IN");
                            
                            Bestimme_GEBER_FUNKT_SICHERHEIT(oDataGear);
                            Bestimme_GEBER_IMPULSZAHL(oDataGear);
                            Bestimme_GEBER_ELEKTRONIK(oDataGear);
                            Bestimme_GEBER_EINGANGSFREQUENZ(oDataGear);
                            Bestimme_GEBER_AUSGANGSSIGNALE(oDataGear);
                            Bestimmme_GEBER_MECH_VAR(oDataGear)	;
                            Bestimmung_GEBER_DIREKTAUSWAHL(oDataGear);
                            
                            //Jetzt erst bestimmten Geber festlegfen aus den Default Werten!
                            var bResult = Bestimme_GeberbeigeaendertenWerten(oDataGear);
                            //************************************************************

                            //falls es Probleme gibt, also nichts gefunden wird müssen aus dem gerade selektierten geber die Werte bestimmt und gesetzt werden
                            if(!bResult)
                                Bestimme_WertebeigeaendertemGeber(oDataGear);
                            
                            Bestimme_GEBER_MECHSCHUTZ(oDataGear);
                            Bestimme_GEBER_ZUB_KABEL(oDataGear);
                            Bestimme_GEBER_ZUB_GATEWAYS(oDataGear);
            
                            //Die MLFB in ECSI_MLFG muss noch angepasst werden, da es sonst zu einem Fehler kommt
                            var oMLFB = buildFormattedMLFB( oDataGear, true);
                            var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
                            ECL_SetValue("ECSI_MLFB",strMLFB);
                            logtraceln("MLFB="+strMLFB);
                        }
                        else
                        {
                            return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_ENCODER";
                        }
                        */
                    }
                }
                else if(iEncoderTypeRough==1)
                {
                    if(strValueSelected=="IA" && strGeberEnabled=="T")
                    {
                        //schon gesetzt, nix tun
                    }
                    else
                    {
                        //vorerst immer Fehler ausgeben
                        return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_ENCODER";
                        
                        /*
                        if(ECL_ValueEnabled ("GEBER_AUSFUEHRUNG","IA" ) && ECL_ValueEnabled ("MIT_GEBER","T" ))
                        {
                            Bestimme_GEBER_AUSFUEHRUNG(oDataGearGEBER_AUSFUEHRUNG);
                            ECL_SetValue("MIT_GEBER","T");
                            ECL_SelectValue("GEBER_AUSFUEHRUNG","IA");
                            
                            Bestimme_GEBER_FUNKT_SICHERHEIT(oDataGear);
                            Bestimme_GEBER_IMPULSZAHL(oDataGear);
                            Bestimme_GEBER_ELEKTRONIK(oDataGear);
                            Bestimme_GEBER_EINGANGSFREQUENZ(oDataGear);
                            Bestimme_GEBER_AUSGANGSSIGNALE(oDataGear);
                            Bestimmme_GEBER_MECH_VAR(oDataGear)	;
                            Bestimmung_GEBER_DIREKTAUSWAHL(oDataGear);
                            
                            //Jetzt erst bestimmten Geber festlegfen aus den Default Werten!
                            var bResult = Bestimme_GeberbeigeaendertenWerten(oDataGear);
                            //************************************************************

                            //falls es Probleme gibt, also nichts gefunden wird müssen aus dem gerade selektierten geber die Werte bestimmt und gesetzt werden
                            if(!bResult)
                                Bestimme_WertebeigeaendertemGeber(oDataGear);
                            
                            Bestimme_GEBER_MECHSCHUTZ(oDataGear);
                            Bestimme_GEBER_ZUB_KABEL(oDataGear);
                            Bestimme_GEBER_ZUB_GATEWAYS(oDataGear);
                            
                            //Die MLFB in ECSI_MLFG muss noch angepasst werden, da es sonst zu einem Fehler kommt
                            var oMLFB = buildFormattedMLFB( oDataGear, true);
                            var strMLFB = oMLFB.strBaseMLFB+"-Z "+oMLFB.strStrippedShortDescriptions+" "+oMLFB.strFormattedShortDescriptions;
                            ECL_SetValue("ECSI_MLFB",strMLFB);
                            logtraceln("MLFB="+strMLFB);
                        }
                        else
                        {
                            return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_ENCODER";
                        }
                        */
                    }
                }
            }
        }
    }
    
    //Überprüfung Safety Funktion bei Geber Einschränkung
    var strSafetyFunctions = ECL_GetValue("ECSI_CX_SafetyFunctions");
    //strSafetyFunctions="5";
    
    if( strSafetyFunctions.indexOf("5") > -1 || strSafetyFunctions.indexOf("6") > -1 || strSafetyFunctions.indexOf("7") > -1 || strSafetyFunctions.indexOf("8") > -1 || strSafetyFunctions.indexOf("9") > -1 || strSafetyFunctions.indexOf("10") > -1 || strSafetyFunctions.indexOf("12") > -1)
    {
        var strGeberFunctionalSafety=ECL_GetValue("GEBER_FUNKT_SICHERHEIT");
        var strGeberEnabled=ECL_GetValue("MIT_GEBER");
        
        if(ECL_ValueSelected("MIT_GEBER", "T"))
        {
            var strGEBTYPX_M3="";
            
            if(ECL_ValueSelected("MIT_BREMSE", "T"))
            {
                strGEBTYPX_M3=checkGEBTYPX_M3(oDataGear);
            }
            
            var bRet=Check_GEBER_FUNKT_SICHERHEIT(oDataGear,strGEBTYPX_M3);
            
            
            //Context Fehler nur ausgeben, wenn funktional sicherer Geber überhaupt möglich ist
            if(strGeberFunctionalSafety== "-" && bRet)
            {
                //Context passt nicht ==> Fehlermeldung
                return "ERROR_2KJ___CX_CONTEXT_ATTRIBUTES_ENCODER";
            }
        }
    }
    
    return "";
}

function BestimmeGetriebemotorbezeichnung(oDataGear,oDataBremse)
{
    //Bestimmung der Getriebemotorbezeichnung
    var strGetriebeMotorBezeichnung="";
    
    //Getriebe
    if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
    {
        var strGetriebe=oDataGear.oRow.EGBEZTYP+oDataGear.oRow.EGBEZUEBS+oDataGear.oRow.EGBEZBRA;
        
        var strWelle=ECL_GetValue("ABTRIEBSWELLENART");
        if(strWelle=="Einsteckwelle")
            strGetriebe=strGetriebe+"E";
        else if(strWelle=="Hohlwelle" || strWelle=="Hohlwelle_Edelstahl" || strWelle=="Hohlwelle_mit_Schrumpfscheibe" || strWelle=="Hohlwelle_mit_Vielkeilverzahnung" || strWelle=="Hohlwelle_mit_SIMOLOC")
            strGetriebe=strGetriebe+"A";
        else if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_mit_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_fuer_Kuehlturmantriebe")
            strGetriebe=strGetriebe+"-";
        else
            logtraceln("Fehler bei der Getriebemotorbezeichnung, Welle unbekannst!");
        
        strGetriebe=strGetriebe+ECL_GetValue("BEFESTIGUNGSART");
        strGetriebe=strGetriebe+GetEGBEZWNV();
        
        if(ECL_ValueSelected("SPIELREDUZIERT_OPTION","T"))
            strGetriebe=strGetriebe+"W";
        
        strGetriebe=strGetriebe+oDataGear.oRow.EGBEZDIM+oDataGear.oRow.EGBEZEI;
        
        strGetriebe=replace(strGetriebe,"-","");

        var strZweitgetriebe="";
	
		strZweitgetriebe=oDataGear.oRow.ZGBEZUEBS+oDataGear.oRow.ZGBEZDIM+oDataGear.oRow.ZGBEZEI;
		strZweitgetriebe=replace(strZweitgetriebe,"-","");
		
		if(strZweitgetriebe != "")
			strGetriebe = strGetriebe+"-"+strZweitgetriebe;
        
        //Adapter
        var strAdapter="";
        strAdapter=strAdapter+oDataGear.oRow.MOTTYP+"-("+ECL_GetValue("ANTRIEBSGRUPPE_SIZE")+")";
        
        strGetriebeMotorBezeichnung=strGetriebe+"-"+strAdapter;
        
    }
    else
    {
        var strGetriebe=oDataGear.oRow.EGBEZTYP+oDataGear.oRow.EGBEZUEBS+oDataGear.oRow.EGBEZBRA;
        
        var strWelle=ECL_GetValue("ABTRIEBSWELLENART");
        if(strWelle=="Einsteckwelle")
            strGetriebe=strGetriebe+"E";
        else if(strWelle=="Hohlwelle" || strWelle=="Hohlwelle_Edelstahl" || strWelle=="Hohlwelle_mit_Schrumpfscheibe" || strWelle=="Hohlwelle_mit_Vielkeilverzahnung" || strWelle=="Hohlwelle_mit_SIMOLOC")
            strGetriebe=strGetriebe+"A";
        else if(strWelle=="Vollwelle_beidseitig" || strWelle=="Vollwelle_mit_Passfeder" || strWelle=="Vollwelle_ohne_Passfeder" || strWelle=="Vollwelle_beidseitig_ohne_Passfeder" || strWelle=="Vollwelle_fuer_Kuehlturmantriebe")
            strGetriebe=strGetriebe+"-";
        else
            logtraceln("Fehler bei der Getriebemotorbezeichnung, Welle unbekannt!");
        
        strGetriebe=strGetriebe+ECL_GetValue("BEFESTIGUNGSART");
        strGetriebe=strGetriebe+GetEGBEZWNV();
        
        if(ECL_ValueSelected("SPIELREDUZIERT_OPTION","T"))
            strGetriebe=strGetriebe+"W";
        
        strGetriebe=strGetriebe+oDataGear.oRow.EGBEZDIM+oDataGear.oRow.EGBEZEI;
        
        strGetriebe=replace(strGetriebe,"-","");
        
        var strZweitgetriebe="";
	
		strZweitgetriebe=oDataGear.oRow.ZGBEZUEBS+oDataGear.oRow.ZGBEZDIM+oDataGear.oRow.ZGBEZEI;
		strZweitgetriebe=replace(strZweitgetriebe,"-","");
		
		if(strZweitgetriebe != ""){
			strGetriebe = strGetriebe+"-"+strZweitgetriebe;
        }
        
        //MOTOR
        var strMotor=oDataGear.oRow.MOT_BZ_LANG;
        if(ECL_ValueSelected("BELUEFTUNG", "Zugeordneter Luefter"))
            strMotor=strMotor+"F";
        else if(ECL_ValueSelected("BELUEFTUNG", "Schwungradluefter"))
            strMotor=strMotor+"I";
        else
            strMotor=strMotor+"-";
        
        if(ECL_ValueSelected("SCHUTZDACH_OPTION","T"))
            strMotor=strMotor+"W";
            
        if(ECL_ValueSelected("HANDRAD_OPTION","T"))
            strMotor=strMotor+"D";
        
        if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION","T"))
            strMotor=strMotor+"X";
            
        strMotor=replace(strMotor,"-","");
        
        //Bremse
        var strBremse="";
        if(ECL_ValueSelected("MIT_BREMSE","T"))
        {
            strBremse=strBremse+oDataBremse.oRow.BREART;
            
            if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
                strBremse=strBremse+"S";
            
            strBremse=strBremse+oDataBremse.oRow.BRENENMO;
            if(oDataBremse.oRow.BREREDMO!="-")
                strBremse=strBremse+"/"+oDataBremse.oRow.BREREDMO;
            
            if(ECL_ValueSelected("BREMSE_UEBERWACHUNG", "MS fuer Luefterkontrolle"))
                strBremse=strBremse+"M";
                
            if(ECL_ValueSelected("BREMSE_AUSFUEHRUNG", "N"))
                strBremse=strBremse+"N";
            else if(ECL_ValueSelected("BREMSE_AUSFUEHRUNG", "G") || ECL_ValueSelected("BREMSE_AUSFUEHRUNG", "GK"))
                strBremse=strBremse+"G";
            
            if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG", "H"))
                strBremse=strBremse+"H";
            else if(ECL_ValueSelected("BREMSE_HANDLUEFTUNG", "HA"))
                strBremse=strBremse+"HA";
        }
        
        //Geber
        var strGeber="";
        if(ECL_ValueSelected("MIT_GEBER","T"))
        {
            strGeber=strGeber+ECL_GetValue("GEBER_AUSFUEHRUNG");
            strGeber=replace(strGeber,"_MT","");
            strGeber=replace(strGeber,"_ST","");
            
            if(ECL_GetValue("GEBER_FUNKT_SICHERHEIT") != "-")
                strGeber=strGeber+"SI04";
        }
        
        
        strGetriebeMotorBezeichnung=strGetriebe+"-"+strMotor;
        if(strBremse!="")
            strGetriebeMotorBezeichnung=strGetriebeMotorBezeichnung+"-"+strBremse;
            
        if(strGeber!="")
            strGetriebeMotorBezeichnung=strGetriebeMotorBezeichnung+"-"+strGeber;
    }
    
    return(strGetriebeMotorBezeichnung);
}