//@legacy
//#mode(full-ecma)


//@import "VT_TF.js"

//@import "models/CFG_2KJ_ELEKTRISCHE_AUSFUEHRUNG_Model.js"


function SetElektrischeAusfuehrung_Init(strchangedAttribute,oData)
{
    Bestimme_Betriebsart(oData);
    Bestimme_Netzspannung(oData);
    check_erhoehteLeistung(oData);
    
    //Kurzangabe für erhöhte Leistung gibt es nicht mehr in den aktuellen Daten
    ECL_SetValue ("ECSI_MOTORSPANNUNG_P_KA", "-");

    check_Spannungstoleranz(oData);
    
    Bestimme_Motorschutz(oData);
    var test = ECL_GetValue("GEBER_ZUB_GATEWAYS");
    Bestimme_Stillstandsheizung(oData);
    var test = ECL_GetValue("GEBER_ZUB_GATEWAYS");
    
    Bestimme_Waermeklasse(oData);
     
    Bestimme_MotorZusatzKAs(oData);
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        ECL_ActivateAttribute("ATEX_ZONE");
        ECL_DisableAttribute("ATEX_ZONE");
        
        ECL_EnableAttribute("ATEX_EXPLOSIONSGRUPPE");
        ECL_ActivateAttribute("ATEX_EXPLOSIONSGRUPPE");
        
        ECL_ActivateAttribute("ATEX_Umrichter");
        ECL_DisableAttribute("ATEX_Umrichter");
        
        Bestimme_ATEX_Zone(oData);
        Bestimme_ATEX_Explosionsgruppe(oData);
        Bestimme_ATEX_Umrichter(oData);
    }
    else
    {
        ECL_DisableAttribute("ATEX_ZONE");
        ECL_DeactivateAttribute("ATEX_ZONE");
        
        ECL_DisableAttribute("ATEX_EXPLOSIONSGRUPPE");
        ECL_DeactivateAttribute("ATEX_EXPLOSIONSGRUPPE");
        
        ECL_DisableAttribute("ATEX_Umrichter");
        ECL_DeactivateAttribute("ATEX_Umrichter");
    }
    
}


function SetElektrischeAusfuehrung(strchangedAttribute,oData)
{
    if(strchangedAttribute == "BETRIEBSART")
    {
        Bestimme_Netzspannung(oData);
        check_erhoehteLeistung(oData);
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
    if(strchangedAttribute == "BETRIEBSART" || strchangedAttribute == "MOTORSPANNUNG")
    {
        check_erhoehteLeistung(oData);
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
    if(strchangedAttribute == "BETRIEBSART" || strchangedAttribute == "MOTORSPANNUNG" || strchangedAttribute == "ERHOEHTE_LEISTUNG_OPTION")
    {
        
        check_Spannungstoleranz(oData);
        Bestimme_Waermeklasse(oData);
        Bestimme_MotorZusatzKAs(oData);
    }
    
	if(strchangedAttribute == "BELUEFTUNG" || strchangedAttribute == "MIT_GEBER" || strchangedAttribute == "GEBER_AUSFUEHRUNG" || strchangedAttribute == "GEBER_FUNKT_SICHERHEIT" || strchangedAttribute == "GEBER_ELEKTRONIK" || strchangedAttribute == "ANSCHLUSSKASTEN_VERGOSSEN_OPTION" || strchangedAttribute == "MIT_BREMSE" || strchangedAttribute == "BREMSE_SAFETY")
	{
        Bestimme_Motorschutz(oData);
    }
    
    if(strchangedAttribute == "SPEZIFIKATION_CHINA" || strchangedAttribute == "SPEZIFIKATION_ULR_CSA" || strchangedAttribute == "SPEZIFIKATION_EAC")
        Bestimme_Waermeklasse(oData);
        
    if( ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED" && (strchangedAttribute == "STILLSTANDSHEIZUNG" || strchangedAttribute == "MIT_BREMSE"))
        Bestimme_Motorschutz(oData);
     
    if( ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED" && (strchangedAttribute == "MOTORSCHUTZ" || strchangedAttribute == "MIT_BREMSE"))
        Bestimme_Stillstandsheizung(oData);
        
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        ECL_ActivateAttribute("ATEX_ZONE");
        ECL_DisableAttribute("ATEX_ZONE");
        
        ECL_EnableAttribute("ATEX_EXPLOSIONSGRUPPE");
        ECL_ActivateAttribute("ATEX_EXPLOSIONSGRUPPE");
        
        ECL_ActivateAttribute("ATEX_Umrichter");
        ECL_DisableAttribute("ATEX_Umrichter");
        
        Bestimme_ATEX_Zone(oData);
        Bestimme_ATEX_Explosionsgruppe(oData);
        Bestimme_ATEX_Umrichter(oData);
    }
    else
    {
        ECL_DisableAttribute("ATEX_ZONE");
        ECL_DeactivateAttribute("ATEX_ZONE");
        
        ECL_DisableAttribute("ATEX_EXPLOSIONSGRUPPE");
        ECL_DeactivateAttribute("ATEX_EXPLOSIONSGRUPPE");
        
        ECL_DisableAttribute("ATEX_Umrichter");
        ECL_DeactivateAttribute("ATEX_Umrichter");
    }
}
