//@legacy
//#mode(full-ecma)

//@import "../VT_TF.js"


function Bestimme_moegliche_Adapter(oData) {
    ECL_DeactivateAllAttributeValues("ANTRIEBSGRUPPE_TYP");
    if (ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K2" || ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K4" || ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "KU") {
        var bK2Moeglich = istBestimmterAdapterMoeglich("K2", oData);
        var bK4Moeglich = istBestimmterAdapterMoeglich("K4", oData);
        var bKUMoeglich = istBestimmterAdapterMoeglich("KU", oData);

        ECL_ActivateAttribute("ANTRIEBSGRUPPE_TYP");

        if (bK2Moeglich)
            ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "K2");

        if (bK4Moeglich)
            ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "K4");

        if (bKUMoeglich)
            ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "KU");


        //ECL_DisableAttribute ("ANTRIEBSGRUPPE_TYP");
    }
    else if (ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K3" || ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K5") {
        var bK3Moeglich = istBestimmterAdapterMoeglich("K3", oData);
        var bK5Moeglich = istBestimmterAdapterMoeglich("K5", oData);
        ECL_ActivateAttribute("ANTRIEBSGRUPPE_TYP");

        if (bK3Moeglich)
            ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "K3");

        if (bK5Moeglich)
            ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "K5");

        //ECL_DisableAttribute ("ANTRIEBSGRUPPE_TYP");
    }
    else if (ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "KS") {
        ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "KS");
        ECL_DisableAttribute("ANTRIEBSGRUPPE_TYP");
    }
    else if (ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K8") {
        ECL_ActivateValue("ANTRIEBSGRUPPE_TYP", "K8");
        ECL_DisableAttribute("ANTRIEBSGRUPPE_TYP");
    }

}

function Bestimme_Adapter_Groesse(oData) {
    var strMotorBaseType = ECL_GetValue("ECSI_CX_MotorBaseTypeOrderNumber");

    //Test
    //strMotorBaseType="1LE10031BB2.....";
    //strMotorBaseType="1LE10430BB2.....";
    //strMotorBaseType="1PH813????{0;1;3;4}{2;3}2???";

    var aMotorBaseTypetoken = _tokenize(strMotorBaseType, true);
    strMotorBaseType = aMotorBaseTypetoken[0];

    var strSelect = "SELECT DISTINCT AV_GROESSE_KZ,AV_BEZ FROM CD_AVEINHEITEN, CD_GETRIEBE, CD_GETRIEBE_BEZEICHNUNGEN WHERE ";
    strSelect = strSelect + "CD_GETRIEBE.GETRIEBE_BEZ='" + oData.oRow.EGTYP + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE.EGUEB='" + oData.oRow.UEBERSETZUNG + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZTYP='" + oData.oRow.EGBEZTYP + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZUEBS='" + oData.oRow.EGBEZUEBS + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZBRA='" + oData.oRow.EGBEZBRA + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZDIM='" + oData.oRow.EGBEZDIM + "' AND ";
    strSelect = strSelect + "CD_GETRIEBE_BEZEICHNUNGEN.EGBEZEI='" + oData.oRow.EGBEZEI + "' AND ";
    strSelect = strSelect + "CD_AVEINHEITEN.AV_TYP_KZ='" + ECL_GetValue("ANTRIEBSGRUPPE_TYP") + "' AND ";

    strSelect = strSelect + "CD_AVEINHEITEN.AVABSSAR=CD_GETRIEBE_BEZEICHNUNGEN.EGANSSART AND ";
    strSelect = strSelect + "CD_AVEINHEITEN.AVABFLD=CD_GETRIEBE_BEZEICHNUNGEN.EGANFLDM AND ";
    strSelect = strSelect + "CD_AVEINHEITEN.MAVABKD=CD_GETRIEBE.AVMOKDBEZ ";

    ECL_DeactivateAllAttributeValues("ANTRIEBSGRUPPE_SIZE");
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if (aResult.length > 0) {
        for (var i = 0; i < aResult.length; i++) {
            var strAdapterBez = aResult[i].AV_BEZ;
            if (strAdapterBez.left(2) == "KS")
                strAdapterBez = replace(strAdapterBez, "-", "");

            var strSelectRegEx = "SELECT * FROM TE_M_MA_MGB_Combination WHERE SZ_MMGAC_MA_ID='" + strAdapterBez + "' ";
            var aResultRegEx = ExecSQL_Standard_SO("2KJ_DB", strSelectRegEx);
            if (aResultRegEx.length > 0) {
                for (var j = 0; j < aResultRegEx.length; j++) {
                    var strRegEx = aResultRegEx[j].SZ_MMGAC_M_ORDERNUMBER;

                    if (EK_regFound(strMotorBaseType, strRegEx)) {
                        ECL_ActivateValue("ANTRIEBSGRUPPE_SIZE", aResult[i].AV_GROESSE_KZ);
                    }
                }
            }
        }
    }
    else {
        logtraceln("Fehler bei der Generierung der Adapter Baugröße, SQL=" + strSelect);
    }

    //Default Wert bestimmen
    if (isnewDefaultnecessary("ANTRIEBSGRUPPE_SIZE")) {
        var aActiveValues = ECL_GetAllActiveAttributeValues("ANTRIEBSGRUPPE_SIZE");

        if (aActiveValues.length > 0)
            ECL_SelectValue("ANTRIEBSGRUPPE_SIZE", aActiveValues[0]);
        else
            logtraceln("Fehler bei der Generierung der Adapter Baugröße");
    }

    /*
    // Bei 1FK2 darf die Adaptergröße nicht geändert werden.
    var strDefaultGearboxAdapter = ECL_GetValue("ECSI_CX_DefaultGearboxAdapter");
    if (ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER" && strMotorBaseType.left(4)=="1FK2" && strDefaultGearboxAdapter!="")
    {
        ECL_DisableAttribute ("ANTRIEBSGRUPPE_SIZE");
    }
    else
    {
        ECL_EnableAttribute ("ANTRIEBSGRUPPE_SIZE");
    }
    */
}

function istBestimmterAdapterMoeglich(strAdapter, oData) {
    var strSelect = "SELECT * FROM CD_AVEINHEITEN WHERE ";
    strSelect = strSelect + "AV_TYP_KZ='" + strAdapter + "' AND ";
    strSelect = strSelect + "AVTYPDIM='" + oData.oRow.MOTDIM + "' AND ";
    strSelect = strSelect + "AVABFLD='" + oData.oRow.MOABFLDM + "' ";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if (aResult.length > 0) {
        var strPolzahl = ECL_GetValue("ECSI_CX_MotorPoleCount");

        if (strPolzahl == "2" && (strAdapter == "K4" && parseInt(oData.oRow.MOTDIM) >= 225))
            return false;
        else
            return true;
    }
    else
        return false;

}

function Bestimme_AdapterRLSP(oData) {
    //Rücklaufsperre am Adapter vorerst deaktiviert
    ECL_DeselectValue("RUECKLAUFSPERRE_ADAPTER_OPTION", "T");
    ECL_DisableAttribute("RUECKLAUFSPERRE_ADAPTER_OPTION");
    ECL_DeactivateAttribute("RUECKLAUFSPERRE_ADAPTER_OPTION");

    /*
    var strSelect = "SELECT DISTINCT AV_RLSP FROM CD_AVEINHEITEN WHERE AV_TYP_KZ = '"+ECL_GetValue("ANTRIEBSGRUPPE_TYP")+"' AND AV_GROESSE_KZ= '"+oData.oRow.MOTDIM+"' AND AVABFLD='"+oData.oRow.MOABFLDM+"'AND AV_RLSP='1' ";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0)
    {
        //Rücklaufsperre möglich
        ECL_EnableValue("RUECKLAUFSPERRE_ADAPTER_OPTION", "T");
        ECL_EnableAttribute("RUECKLAUFSPERRE_ADAPTER_OPTION");
    }
    else
    {
        ECL_DeselectValue("RUECKLAUFSPERRE_ADAPTER_OPTION", "T");
        ECL_DisableAttribute("RUECKLAUFSPERRE_ADAPTER_OPTION");
    }
    
    */

}

function BestimmeRuecklaufsperreMinDrehzahl(oData) {

    var iAntriebsdrehzahl = 1500;  //kommt aus SIZER
    var iMinDrehzahl;

    var strSelect = "SELECT DISTINCT MIN_DREHZAHL FROM AVRLSPDZ WHERE AVANSSAR = '" + oData.oRow.MOABSSAR + "' AND AVTYPDIM= '" + oData.oRow.MOTDIM + "' AND M3='1' ";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if (aResult.length > 0) {
        iMinDrehzahl = aResult[0].MIN_DREHZAHL;
    }
    else {
        logtraceln("Min Drehzahl für Rücklaufsperre nicht gefunden! SQL=" + strSelect);
        return false;
    }

    if (iAntriebsdrehzahl < iMinDrehzahl) {
        logtraceln("Rücklaufsperre nicht möglich! Antriebsdrehzahl zu gering " + iAntriebsdrehzahl + "<" + iMinDrehzahl);
        return false;
    }
    else
        return true;

}

function Bestimme_Rutschkupplung(oData) {

    //Rutschkupplung vorerst deaktiviert
    ECL_DeselectValue("RUTSCHKUPPLUNG_ADAPTER_OPTION", "T");
    ECL_DisableAttribute("RUTSCHKUPPLUNG_ADAPTER_OPTION");
    ECL_DeactivateAttribute("RUTSCHKUPPLUNG_ADAPTER_OPTION");



    //Rutschkupplung bei Simogear nur mit Näherungsschalter
    /*
    var strRLSP;
    if(ECL_ValueSelected("RUECKLAUFSPERRE_ADAPTER_OPTION","T"))
        strRLSP = "1";
    else
        strRLSP = "0";
        
    var strSelect = "SELECT DISTINCT KUEINHEIT FROM CD_AVEINHEITEN WHERE AV_TYP_KZ = '"+ECL_GetValue("ANTRIEBSGRUPPE_TYP")+"' AND AV_GROESSE_KZ= '"+oData.oRow.MOTDIM+"' AND AV_RLSP='"+strRLSP+"' AND KUEINHEIT='Rutschkupplung' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0)
    {
        //Rutschkupplung möglich
        ECL_EnableValue("RUTSCHKUPPLUNG_ADAPTER_OPTION", "T");
        ECL_EnableAttribute("RUTSCHKUPPLUNG_ADAPTER_OPTION");
    }
    else
    {
        logtraceln("Keine Rutschkupplung möglich! SQL="+strSelect);
        ECL_DeselectValue("RUTSCHKUPPLUNG_ADAPTER_OPTION", "F");
        ECL_DisableAttribute("RUTSCHKUPPLUNG_ADAPTER_OPTION");
    }
    
    */

    //Bei ATEX keine Rutschkupplung
    /*
    if(oMOTOXHandler.strProduct == "GETRIEBE.ADAPTER.ATEX" || oMOTOXHandler.strProduct == "GETRIEBE.ADAPTER.ATEX_SIP")
    {
        return(false);
    }
    */
}

function BestimmeRutschkupplungMoment_MINMAX(oData) {
    ECL_DisableAttribute("RUTSCHKUPPLUNG_MOMENT_MINMAX");
    ECL_DeactivateAttribute("RUTSCHKUPPLUNG_MOMENT_MINMAX");

    var dRutschkupplung_Min;
    var dRutschkupplung_Max;


    var strSelect = "SELECT DISTINCT RUKUDREHMI,RUKUDREHMA FROM RUKUDREH,KEANKDBEZ WHERE ";
    strSelect = strSelect + "RUKUDREH.KEANKDBEZ = (SELECT DISTINCT KEANKDBEZ.KEANKDBEZ FROM KEANKDBEZ WHERE MOABKDBEZ = (SELECT DISTINCT MOABKDBEZ FROM MOTDIM WHERE MOTDIM = '" + oData.oRow.MOTDIM + "' AND MOABSSAR = '" + oData.oRow.MOABSSAR + "' AND MOTBAUART='-') AND ";
    strSelect = strSelect + "MOABSSAR = '" + oData.oRow.MOABSSAR + "' AND MOTBAUART = '-') AND KUEINHEIT = 'Rutschkupplung' ORDER BY(RUKUDREHMI)";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if (aResult.length > 0) {
        dRutschkupplung_Min = aResult[0].RUKUDREHMI;
        dRutschkupplung_Max = aResult[0].RUKUDREHMA;

        var strMomentHelpString = dRutschkupplung_Min + " Nm / " + dRutschkupplung_Max + " Nm";
        ECL_SetValue("RUTSCHKUPPLUNG_MOMENT_MINMAX", strMomentHelpString);
    }
    else {
        logtraceln("Fehler bei Min-Momenten der Rutschkupplung! SQL=" + strSelect);
    }

    //falls kein Wert eingestellt ist, dann mit Min Wert vorbelegen.
    if (ECL_GetValue("RUTSCHKUPPLUNG_MOMENT") == 0 || ECL_GetValue("RUTSCHKUPPLUNG_MOMENT") == "") {
        ECL_SetValue("RUTSCHKUPPLUNG_MOMENT", dRutschkupplung_Min);
    }

    if (ECL_GetValue("RUTSCHKUPPLUNG_MOMENT") < dRutschkupplung_Min) {
        ECL_SetValue("RUTSCHKUPPLUNG_MOMENT", dRutschkupplung_Min);
    }

    if (ECL_GetValue("RUTSCHKUPPLUNG_MOMENT") > dRutschkupplung_Max) {
        ECL_SetValue("RUTSCHKUPPLUNG_MOMENT", dRutschkupplung_Max);
    }
}

function Bestimme_AbtriebsDrehrichtung_Adapter(oData, what) {

    var strEGTYP = oData.oRow.EGBEZTYP + oData.oRow.EGBEZUEBS;
    strEGTYP = replace(strEGTYP, "-", "");

    if (what == "MOTOR") {
        var strSelect = "SELECT DISTINCT ANTRIEBSDREHRICHTUNG_MOTOR FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '" + strEGTYP + "' AND ";

        if (strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '" + ECL_GetValue("ABTRIEBSSEITE") + "' AND ";

        if (ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER") == "links")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CCW' ";
        else if (ECL_GetValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER") == "rechts")
            strSelect = strSelect + "ABTRIEBSDREHRICHTUNG_GETRIEBE = 'CW' ";


        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if (aResult.length == 1) {
            var strRichtung = aResult[0].ANTRIEBSDREHRICHTUNG_MOTOR;

            if (strRichtung == "CW") {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_ADAPTER", "rechts");
            }
            else {
                ECL_SelectValue("DREHRICHTUNG_MOTOR_ADAPTER", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Motor, SQL=" + strSelect);
    }
    else //Getriebe
    {
        var strSelect = "SELECT DISTINCT ABTRIEBSDREHRICHTUNG_GETRIEBE FROM ABTRIEBSDREHRICHTUNGEN WHERE ";
        strSelect = strSelect + "GETRIEBE = '" + strEGTYP + "' AND ";

        if (strEGTYP == "FD" || strEGTYP == "FZ")
            strSelect = strSelect + "ABTRIEBSSEITE = '-' AND ";
        else
            strSelect = strSelect + "ABTRIEBSSEITE = '" + ECL_GetValue("ABTRIEBSSEITE") + "' AND ";

        if (ECL_GetValue("DREHRICHTUNG_MOTOR_ADAPTER") == "links")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CCW' ";
        else if (ECL_GetValue("DREHRICHTUNG_MOTOR_ADAPTER") == "rechts")
            strSelect = strSelect + "ANTRIEBSDREHRICHTUNG_MOTOR = 'CW' ";


        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if (aResult.length == 1) {
            var strRichtung = aResult[0].ABTRIEBSDREHRICHTUNG_GETRIEBE;

            if (strRichtung == "CW") {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "rechts");
            }
            else {
                ECL_EnableAttribute("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER");
                ECL_SelectValue("DREHRICHTUNG_ABTRIEBSSEITE_ADAPTER", "links");
            }
        }
        else
            logtraceln("Fehler Bestimmung Abtriebsdrehrichtung Getriebe, SQL=" + strSelect);
    }
}

function BestimmeKondenswasserbohrung_Adapter(oData) {
    //Kondeenswasserbohrung bei Adapter
    var strAVPOSHL;
    var strAVKOWALO;
    var strAV_BEZ = oData.oRow.MOTTYP;
    if (ECL_ValueSelected("RUECKLAUFSPERRE_ADAPTER_OPTION", "T"))
        strAV_BEZ = strAV_BEZ + "X";

    //Erst AVPOSHL bestimmen (aus Bauform M1 bis M6)
    var strSelect = "SELECT AVPOSHL_KOWALO FROM AVPOSHL_M3 WHERE EGPOSHL = '" + ECL_GetValue("BAUFORM") + "' AND ";
    strSelect = strSelect + "EGBEZTYP = '" + oData.oRow.EGBEZTYP + "' AND ";
    strSelect = strSelect + "ZGPOSHL='-'";
    strSelect = strSelect + "AND REGION IN ('S') and AKTIV='1' ";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if (aResult.length == 1) {
        strAVPOSHL = aResult[0].AVPOSHL_KOWALO;

        var strSelect = "SELECT DISTINCT AVKOWALO FROM AVKOWALO WHERE AVABSSAR = 'BK4' AND ";
        strSelect = strSelect + "AVTYPDIM = '" + oData.oRow.MOTDIM + "' AND ";
        strSelect = strSelect + "AVPOSHL_KOWALO = '" + strAVPOSHL + "' AND ";
        strSelect = strSelect + "TYPBEZ = '" + strAV_BEZ + "' AND ";
        strSelect = strSelect + "SCHUTZART = '" + ECL_GetValue("SCHUTZART") + "' AND ";
        strSelect = strSelect + "AVKOWALO = '1' ";

        if (ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER") {
            strSelect = strSelect + "AND ATEX = '1' ";
        }


        var aResult2 = ExecSQL_Standard_SO("2KJ_DB", strSelect);

        if (aResult2.length > 0) {
            //Kondenswasserloch möglich
            ECL_ActivateAttribute("KONDENSWASSERLOCH_ADAPTER_OPTION");
            ECL_ActivateValue("KONDENSWASSERLOCH_ADAPTER_OPTION", "T");
            ECL_EnableAttribute("KONDENSWASSERLOCH_ADAPTER_OPTION");
        }
        else {
            logtraceln("Keine Kondenswasserbohrung Adaptermöglich! SQL=" + strSelect);
            ECL_DeselectValue("KONDENSWASSERLOCH_ADAPTER_OPTION", "T");
            ECL_DisableAttribute("KONDENSWASSERLOCH_ADAPTER_OPTION");
            ECL_DeactivateAttribute("KONDENSWASSERLOCH_ADAPTER_OPTION");
        }
    }
    else {
        logtraceln("Fehler bei Bestimmung von AVPOSHL! SQL=" + strSelect);
    }

    //Bei ATEX keine Kondenswasserbohrung
    /*
    if(oMOTOXHandler.strProduct == "GETRIEBE.ADAPTER.ATEX" || oMOTOXHandler.strProduct == "GETRIEBE.ADAPTER.ATEX_SIP")
    {
        return(false);
    }
    */
}

function BestimmeMotor2tesWellenende_Adapter(oData) {
    var strPolzahl = ECL_GetValue("ECSI_CX_MotorPoleCount");

    ECL_EnableAttribute("ECSI_2POL_MOTORABTRIEBSWELLE");
    ECL_ActivateAttribute("ECSI_2POL_MOTORABTRIEBSWELLE");
    ECL_DeactivateAllAttributeValues("ECSI_2POL_MOTORABTRIEBSWELLE");
    if (ECL_GetValue("ANTRIEBSGRUPPE_TYP") == "K2") {
        if (parseInt(oData.oRow.MOTDIM) >= 225 && strPolzahl == "2") {
            ECL_ActivateValue("ECSI_2POL_MOTORABTRIEBSWELLE", "T");
            ECL_SelectValue("ECSI_2POL_MOTORABTRIEBSWELLE", "T");
        }
        else {
            ECL_ActivateValue("ECSI_2POL_MOTORABTRIEBSWELLE", "F");
            ECL_SelectValue("ECSI_2POL_MOTORABTRIEBSWELLE", "F");
        }
    }
    else {
        ECL_ActivateValue("ECSI_2POL_MOTORABTRIEBSWELLE", "F");
        ECL_SelectValue("ECSI_2POL_MOTORABTRIEBSWELLE", "F");
    }

    ECL_DisableAttribute("ECSI_2POL_MOTORABTRIEBSWELLE");
    ECL_DeactivateAttribute("ECSI_2POL_MOTORABTRIEBSWELLE");
}

function Bestimme_AntriebsgruppeLagerung(oData) {

    ECL_DeactivateAllAttributeValues("ANTRIEBSGRUPPE_LAGERUNG");
    ECL_ActivateValue("ANTRIEBSGRUPPE_LAGERUNG", "-");

    if (parseInt(oData.oRow.MOTDIM) >= 100) {
        ECL_ActivateValue("ANTRIEBSGRUPPE_LAGERUNG", "Zylinderrollenlager");
    }  
}


function Bestimme_AntriebsgruppeDichtung(oData) {

    ECL_DeactivateAllAttributeValues("ANTRIEBSGRUPPE_DICHTUNG");
    if (ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T") || ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T")) {
        // A36 mandatory
        ECL_ActivateValue("ANTRIEBSGRUPPE_DICHTUNG", "MSS1-HS");
        ECL_SelectValue("ANTRIEBSGRUPPE_DICHTUNG", "MSS1-HS");
        ECL_DisableAttribute("ANTRIEBSGRUPPE_DICHTUNG");
    }
    else {
        ECL_ActivateValue("ANTRIEBSGRUPPE_DICHTUNG", "-");
        ECL_ActivateValue("ANTRIEBSGRUPPE_DICHTUNG", "FKM");
        ECL_ActivateValue("ANTRIEBSGRUPPE_DICHTUNG", "MSS1-HS");
    }
}

function _tokenize(strMLFB, bStripFreeText) {
    var nMLFBLen = strMLFB.length;
    var bMasked = false, bStripText = false, bBaseMLFBFinished = false;
    var strToken = '';
    var cToken = '';
    var aTokens = [];

    var i = 0;
    while (i <= nMLFBLen) {
        cToken = strMLFB.charAt(i);
        if ((cToken === ' ') && !bMasked)					// not a space in quotes
        {
            if (strToken === ' ')								// clear multiple spaces
                strToken = '';
            else if (strToken !== '')							// a single space is a separator between tokens
            {
                aTokens.push(strToken);
                strToken = '';
            }
            // now we are handling blocks of mlfbs - but the MLFB must always be sparated by a space from the short descriptions
            if (!bBaseMLFBFinished)
                bBaseMLFBFinished = true;
        }
        else if (_isQuoteChar(cToken) && !bMasked)	// text (in double or single quotes) started
        {
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            bMasked = true;
            if (!bStripFreeText)
                strToken += cToken;
            else bStripText = true;
        }
        else if (_isQuoteChar(cToken) && bMasked)		// text (in double or single quotes) ended
        {
            // } of quote means } of token
            if (!bStripFreeText)
                strToken += cToken;
            else bStripText = false;
            // if we don't want the freetext to be included, we must not add a starting double quote
            // and we must prevent following chars to be added to the token until a closing double quote
            if (strToken !== '') {
                aTokens.push(strToken);
                strToken = '';
            }
            bMasked = false;
        }
        else {
            if (!bStripText) {
                if (!_isSpecialChar(cToken, bMasked)) {
                    // the lexer now must accept blocks of short descriptions and must break them into pieces of 3 chars
                    strToken += cToken;
                    if (bBaseMLFBFinished && !bMasked && (strToken.length == 3))	// base mlfb is lexed and string is not masked
                    {
                        if ((i + 1) <= nMLFBLen)
                            cToken = strMLFB.charAt(i + 1);
                        if (!_isQuoteChar(cToken))		// don't split a MLFB and quoted freetext
                        {
                            aTokens.push(strToken);
                            strToken = '';
                        }
                    }
                }
            }
        }
        ++i;
    }

    if (strToken !== '') {
        // push the remaining string as token
        aTokens.push(strToken);
    }

    return (aTokens);
}


/**
 * determines if a character is a special char, i.e. a character that should not be included in a token
 *
 * @param cChar - char to examin
 * @param bInQuotes - are we just in double quotes?
 *
 * @return boolean - false - not a special character
 *                   true - a special character
 */
function _isSpecialChar(cChar, bInQuotes) {
    var bIsSpecial = false;
    if (!bInQuotes) {
        if ((cChar === '-') ||
            (cChar === ',') ||
            (cChar === 'Z') ||
            (cChar === ';') ||
            (cChar === ':') ||
            (cChar === '_') ||
            (cChar === '//') ||
            (cChar === '?') ||
            (cChar === '*') ||
            (cChar === '+') ||
            (cChar === "'") ||
            (cChar === '/') ||
            (cChar === '(') ||
            (cChar === ')') ||
            (cChar === '[') ||
            (cChar === ']') ||
            (cChar === '\t'))
            bIsSpecial = true;
    }
    // else characters that are in quotes are never special

    return (bIsSpecial);
}

function _isQuoteChar(cChar) {
    return ((cChar === '\"') || (cChar === "'"));
}

function EK_regPrep(s_src) {
    var s = s_src.replace("?", ".");
    s = s.replace("{", "(");
    s = s.replace("}", ")");
    s = s.replace(";", "|");
    return s;
}

function EK_regFound(s_src, s_reg) {
    var regEx = new RegExp(EK_regPrep(s_reg));
    var aM = s_src.match(regEx);
    if (aM == null)
        return false;
    if (aM.length == 0)
        return false;
    return true;
}