//@legacy
//#mode(full-ecma)

//@import "../VT_TF.js"


function checkBremseMOTTYPX(oData)
{
        
    var strSelect = "SELECT DISTINCT MOTYPX.ZUSBEZ FROM MOTYPX WHERE ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.BELSDACH = 'W' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELSDACH = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.UNBELUEFT = '-' AND ";
    
    if(ECL_ValueSelected("RUECKLAUFSPERRE_MOTOR_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.MOTRLSP = 'X' AND ";
    else
        strSelect = strSelect + "MOTYPX.MOTRLSP = '-' AND ";
    
    if(ECL_ValueSelected("HANDRAD_OPTION", "T"))
        strSelect = strSelect + "MOTYPX.HANDRAD = 'D' AND ";
    else
        strSelect = strSelect + "MOTYPX.HANDRAD = '-' AND ";
        
    strSelect = strSelect + "MOTYPX.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "MOTYPX.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' AND ";
    strSelect = strSelect + "MOTYPX.BRANCHE IN ('"+oData.oRow.ANWTYP+"','ALL') AND ";
    
	if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "MOTYPX.WM_FU = '0' AND ";
	}

    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOTYPX.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOTYPX.ATEX = '0' AND ";
    }
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "MOTYPX.M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "MOTYPX.GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "MOTYPX.G110M ='-' AND ";
    strSelect = strSelect + "MOTYPX.AKTIV IN ('1','2') AND ";
	strSelect = strSelect + "MOTYPX.REGION IN ('SA','SAC','SACM','SACMR','SACR','SAM','SAMC','SAMCI','SAMCIR','SAMCR','SAMR') AND ";    
    var strHEMOTOR="-";
    var strMotbez=oData.oRow.MOT_BZ_LANG;
    if(oData.oRow.VSDMOTOR=="V")
    {
        strMotbez=trimright(strMotbez,"V");
        if(strMotbez.right(1)=="S"){
            strHEMOTOR="S";
        }
        else if(strMotbez.right(1)=="P"){
			strHEMOTOR="P";
        }
    }
    else
    {
        if(strMotbez.right(1) == "E")
            strHEMOTOR = 'E';
        else if(strMotbez.right(1) == "P")
            strHEMOTOR = 'P';
    }
    
    strSelect = strSelect + "MOTYPX.HEMOTOR = '"+strHEMOTOR+"' AND ";
    
    if(ECL_GetValue("BELUEFTUNG")=="Zugeordneter Luefter")
        strSelect = strSelect + "MOTYPX.BELART = 'F' AND ";
    else
        strSelect = strSelect + "MOTYPX.BELART = '-' AND ";
    
        //MOTYPX_UNDEF mit abfragen
    var strMOABSSART = "BK4";
    if(oData.oRow.EGBEZDIM == "19" && (oData.oRow.EGBEZTYP == "-" || oData.oRow.EGBEZTYP == "B"))
        strMOABSSART = "Z19";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    strSelect = strSelect + "MOTYPX.ZUSBEZ NOT IN ( SELECT ZUSBEZ FROM MOTYPX_UNDEF WHERE ";
    strSelect = strSelect + "MOTYPX_UNDEF.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "MOTYPX_UNDEF.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTYPX_UNDEF.MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "(MOTYPX_UNDEF.POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' OR MOTYPX_UNDEF.POLZAHL = '-') AND ";
    strSelect = strSelect + "MOTYPX_UNDEF.MOABSSART = '"+strMOABSSART+"' AND ";
    
    strSelect = strSelect + "MOTYPX_UNDEF.ZUSBEZ = MOTYPX_UNDEF.ZUSBEZ AND ";
    
    strSelect = strSelect + "(KONSTBREM='Kauf' OR KONSTBREM='ALL'))";
    
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if(aResult.length > 0)
        return 1;
    else
        return 0;
}
    
function checkBremse(oData)
{
    var i = checkBremseMOTTYPX(oData);
    
    if(i==0)
        return i;
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        if(!CheckAnzahlKlemmenATEX(oData, "BRAKE", 'Kauf'))
            return 0;
    }
    
    var strSpecString= createSpecString(oData);
    
    var strSelect = "SELECT DISTINCT MOT_BREMSKENNER FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
   	
	if (ECL_GetValue("ECSI_WMFU_KENNER")=="ja")
	{
		if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")=="50" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")=="87")
		{
			strSelect = strSelect + "MOT_FREQUENZ = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ_1+"' AND ";
		}
		else if(ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")=="60" || ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")=="104")
		{
			strSelect = strSelect + "MOT_FREQUENZ = '"+oData.oRow.ORIG_MOTFHT_FREQUENZ_2+"' AND ";
		}
	}
	else
	{
		strSelect = strSelect + "MOT_FREQUENZ = '"+oData.oRow.FREQUENZ+"' AND ";
	}
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG = '"+strSpecString+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ = '"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MLFB_13_KA = '"+ECL_GetValue ("ECSI_MOTORSPANNUNG_SPG_KA")+"' ";
    
    if(ECL_GetValue("GEBER_AUSFUEHRUNG") == "IR" && ECL_ValueSelected("MIT_GEBER", "T"))
        return(0);
        
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if ( aResult.length == 1 )
    {
        if (aResult[0].MOT_BREMSKENNER=="Kauf")
            return 1;
        else if (aResult[0].MOT_BREMSKENNER=="-")
            return 0;
        else if (aResult[0].MOT_BREMSKENNER=="ALL")
            return 2;
    }
    else
    {
        logtraceln("Fehler Bremsencheck!, SQL="+strSelect);
        return 0;
    }
}

function Check_BREMSE_SAFETY(oData,oDataBremse)
{
    var strSelect = "SELECT DISTINCT KONSTAFS_BRE FROM MOANBEF_N WHERE ";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOANBEF_N.MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_N.SCHUTZART = '"+ECL_GetValue ("SCHUTZART")+"' AND ";
    strSelect = strSelect + "MOANBEF_N.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_N.M3 = '1' AND MOANBEF_N.G115D='0' AND MOANBEF_N.G115M='0' AND MOANBEF_N.REGION='S' AND ";
    strSelect = strSelect + "MOANBEF_N.MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='Kauf' AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='1' ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='0' ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if ( aResult.length > 0 && oData.oRow.S09=="0")
    {
        //Safety erlaubt
        ECL_EnableAttribute("BREMSE_SAFETY")
        ECL_EnableValue("BREMSE_SAFETY", "T");
    }
    else
    {
        //Safety nicht erlaubt
        logtraceln("Safety Brake not possible, SQL="+strSelect);
        ECL_DeselectValue("BREMSE_SAFETY", "T");
        ECL_DisableAttribute("BREMSE_SAFETY")
    }
}	

function Bestimme_BREMSENTYP(oData,oDataBremse)
{
    var strSelect = "SELECT DISTINCT BREGRDTYP,BREART,BRENENMO,BREREDMO FROM BRETYP,MOANBEF_N WHERE ";
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOANBEF_N.MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_N.SCHUTZART = '"+ECL_GetValue ("SCHUTZART")+"' AND ";
    strSelect = strSelect + "BRETYP.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_N.M3 = '1' AND MOANBEF_N.G115D='0' AND MOANBEF_N.G115M='0' AND MOANBEF_N.REGION='S' AND ";
    strSelect = strSelect + "MOANBEF_N.MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "BRETYP.TYPBEZ = MOANBEF_N.BRETYP AND ";
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='Kauf' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='-' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='-' AND ";
    }
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='1' ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='0' ";
    }
    
    //Bei S09 weitere Einschränkungen
    if(oData.oRow.S09=="1")
        strSelect = strSelect + "AND MOANBEF_N.BRETYP NOT IN (SELECT BRETYP FROM MOANBEF_UNDEF2 WHERE MOABSSART='S09' AND MOTDIM='"+oData.oRow.MOTDIM+"') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect+"ORDER BY abs(BRENENMO),abs(BREREDMO) ");
    
    var strBrake="";
    
    ECL_DeactivateAllAttributeValues("BREMSENTYP");
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].BREART == "FDX")
            {
                strBrake = aResult[i].BREGRDTYP+"/"+aResult[i].BREREDMO;
            }
            else if(aResult[i].BREREDMO == "-")
            {
                if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
                {
                    strBrake = aResult[i].BREART+"S"+aResult[i].BRENENMO;
                }
                else
                {
                    strBrake = aResult[i].BREART+aResult[i].BRENENMO;
                }
                
            }
            else
            {
                if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
                {
                    strBrake = aResult[i].BREART+"S"+aResult[i].BRENENMO+"/"+aResult[i].BREREDMO;
                }
                else
                {
                    strBrake = aResult[i].BREART+aResult[i].BRENENMO+"/"+aResult[i].BREREDMO;
                }
            }
            
            var dBrakeDrehzahlMax=Bestimme_Bremse_MaxDrehzahl(oData, aResult[i].BREGRDTYP, aResult[i].BREREDMO);
            if(parseInt(dBrakeDrehzahlMax) > parseInt(oData.oRow.BDRHZAHL_MOTOR))
            {
                ECL_ActivateValue("BREMSENTYP", strBrake);
            }
            else
            {
                logtraceln("MaxDrehzahlBremse übersteigt die Motordrehzahl!; MaxDrehzahlBremse="+dBrakeDrehzahlMax+" < MotorDrehzahl="+oData.oRow.BDRHZAHL_MOTOR);
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsentyp, SQL="+strSelect);
    }
        
    //Default Wert bestimmen
    var strBrakeDefault="";
    if(isnewDefaultnecessary("BREMSENTYP"))
    {
        // Default Bestimmung jetzt analog SIZER
        var aselection = ECL_GetAllActiveAttributeValues("BREMSENTYP");
        var strfirstValue=aselection[0];
        
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            ECL_SelectValue("BREMSENTYP", strfirstValue);
        }
        else
        {
            if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
            {
                if(oData.oRow.MOTDIM=="63" || oData.oRow.MOTDIM=="71")
                {
                    strBrakeDefault="LS4";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="80")
                {
                    strBrakeDefault="LS8";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="90")
                {
                    strBrakeDefault="LS16";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="100" || oData.oRow.MOTDIM=="112")
                {
                    strBrakeDefault="LS32";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="132")
                {
                    strBrakeDefault="LS80";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="160")
                {
                    strBrakeDefault="LS150";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="180" || oData.oRow.MOTDIM=="200")
                {
                    strBrakeDefault="LS260";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else
                {
                    logtraceln("Fehler Bestimmung Default Bremse!");
                    ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
            }
            else
            {
                if(oData.oRow.MOTDIM=="63" || oData.oRow.MOTDIM=="71")
                {
                    strBrakeDefault="L4";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="80")
                {
                    strBrakeDefault="L8";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="90")
                {
                    strBrakeDefault="L16";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="100" || oData.oRow.MOTDIM=="112")
                {
                    strBrakeDefault="L32";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="132")
                {
                    strBrakeDefault="L80";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="160")
                {
                    strBrakeDefault="L150";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="180" || oData.oRow.MOTDIM=="200")
                {
                    strBrakeDefault="L260";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="225")
                {
                    strBrakeDefault="FDX30/400";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else if(oData.oRow.MOTDIM=="250")
                {
                    strBrakeDefault="FDX40/850";
                    if(isValueSelectable("BREMSENTYP",strBrakeDefault))
                        ECL_SelectValue("BREMSENTYP", strBrakeDefault);
                    else
                        ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
                else
                {
                    logtraceln("Fehler Bestimmung Default Bremse!");
                    ECL_SelectValue("BREMSENTYP", strfirstValue);
                }
            }
        }
    }
}
    
function Bestimme_BREMSE_STEUERSPANNUNG(oData,oDataBremse)
{
    
    var strSpecString=  createSpecString(oData);	
    var strBRETYP_EINKL=Bestimme_Bremse_BRETYP_EINKL(oDataBremse);
    /*
    if(ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA"))
    {
        //Sonderlogik, damit bei CSA/UL-R auch die beiden Gleichstromspannungen kommen
        
        var strSelect = "SELECT DISTINCT IMAX_GLR,BREFREQ,BEREICH_1,BEREICH_2 FROM BREDAT_M3,BREEREG WHERE ";
        strSelect = strSelect + "BREDAT_M3.BREEREG = BREEREG.BREEREG AND ";
        strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect + "BREEREG.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        strSelect = strSelect + "BREDAT_M3.BRETYP_EINKL = '"+strBRETYP_EINKL+"' AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Stromerf.")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'am Klemmbrett' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Spgerf.")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
        }
        
        strSelect = strSelect + "(MOTTYP = 'ALL' OR MOTTYP='"+oData.oRow.MOTTYP+"') AND ";
        strSelect = strSelect + "MOTDIM = '-' AND ";
        strSelect = strSelect + "BREGLR = '-' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
            strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '0' AND ";
        else
            strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '1' AND ";
        
        if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
        {
            strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='Kauf' AND ";
        }
        else
        {
            strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='-' AND ";
        }
        
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            strSelect = strSelect + "BREDAT_M3.ATEX='1' AND ";
        }
        else
        {
            strSelect = strSelect + "BREDAT_M3.ATEX='0' AND ";
        }
        
        strSelect = strSelect + "BREDAT_M3.SONDER = '-' AND BREDAT_M3.G110M='0' AND BREDAT_M3.G115M='0' AND BREDAT_M3.G115D='0' AND ";
        
        strSelect = strSelect + "STANDARD = '1' AND ";
        strSelect = strSelect + "CDROM_REL = '1' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect+" ORDER BY BREDAT_M3.BEREICH_1");

        ECL_DeactivateAllAttributeValues("BREMSE_STEUERSPANNUNG");
        var strSteuerSpannung="";
        
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                strSteuerSpannung = parseInt(aResult[i].BEREICH_1)+"-"+parseInt(aResult[i].BEREICH_2);
                ECL_ActivateValue("BREMSE_STEUERSPANNUNG", strSteuerSpannung);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Bremsen Steuerspannung (UL-R/CSA), SQL="+strSelect);
        }
        
    }
    else
    {*/
        var strSelect = "SELECT DISTINCT BREDAT_M3.IMAX_GLR,BREDAT_M3.BREFREQ,BREDAT_M3.BEREICH_1,BREDAT_M3.BEREICH_2 FROM BREDAT_M3,BREEREG,BREDATELAUSF_M3 WHERE ";
        strSelect = strSelect + "BREEREG.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        strSelect = strSelect + "BREDAT_M3.BRETYP_EINKL = '"+strBRETYP_EINKL+"' AND ";
        
        if(oDataBremse.oRow.BREART == "FDX")
            strSelect = strSelect + "BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        else
            strSelect = strSelect + "(BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' OR BREDAT_M3.BREART = 'ALL') AND ";
            
        strSelect = strSelect + "BREDATELAUSF_M3.MOTELAUSF = '"+strSpecString+"' AND ";
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Stromerf.")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'am Klemmbrett' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Spgerf.")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
        }
        else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
        {
            strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
        }
        
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") != "ohne")
        {
            strSelect = strSelect + "(MOTDIM = '-' OR MOTDIM = '"+oData.oRow.MOTDIM+"') AND ";
        }
        else
        {
            strSelect = strSelect + "MOTDIM = '-' AND ";
        }
        
        strSelect = strSelect + "(MOTTYP = 'ALL' OR MOTTYP='"+oData.oRow.MOTTYP+"') AND ";
        
        
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
                strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
            
        if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
            strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '0' AND ";
        else
            strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '1' AND ";
            
        if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
        {
            strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='Kauf' AND ";
        }
        else
        {
            strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='-' AND ";
        }
        
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            strSelect = strSelect + "BREDAT_M3.ATEX='1' AND ";
        }
        else
        {
            strSelect = strSelect + "BREDAT_M3.ATEX='0' AND ";
        }
            
        strSelect = strSelect + "BREDAT_M3.BREEREG = BREEREG.BREEREG AND ";
        strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect + "BREDATELAUSF_M3.BREGLR = BREDAT_M3.BREGLR AND ";
        strSelect = strSelect + "STANDARD = '1' AND ";
        strSelect = strSelect + "CDROM_REL = '1' AND ";
        strSelect = strSelect + "BREDAT_M3.SONDER = '-' AND BREDAT_M3.G110M='0' AND BREDAT_M3.G115M='0' AND BREDAT_M3.G115D='0' AND ";
        strSelect = strSelect + "BREDAT_M3.AKTIV = '1' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect+" ORDER BY BREDAT_M3.BEREICH_1 ");

        ECL_DeactivateAllAttributeValues("BREMSE_STEUERSPANNUNG");
        var strSteuerSpannung="";
        
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                strSteuerSpannung = parseInt(aResult[i].BEREICH_1)+"-"+parseInt(aResult[i].BEREICH_2);
                ECL_ActivateValue("BREMSE_STEUERSPANNUNG", strSteuerSpannung);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Bremsen Steuerspannung, SQL="+strSelect);
        }
    //}	
    
    //Default Wert bestimmen
    
    //Bei angebauten dezentralem Umrichter ist 180 V DC Default
    var iInstallation = parseInt(ECL_GetValue("ECSI_CX_Installation"));
    if(iInstallation==1)
    {
        ExecSetStandardifValueEmpty("BREMSE_STEUERSPANNUNG", "180-180");
    }
    else
    {
        var strSteuerSpannung="";
        if(isnewDefaultnecessary("BREMSE_STEUERSPANNUNG"))
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND BREDAT_M3.DEFLT='1' ");
            if(aResultDefault.length>0)
            {
                strSteuerSpannung = parseInt(aResult[0].BEREICH_1)+"-"+parseInt(aResult[0].BEREICH_2);
                
                ECL_SelectValue("BREMSE_STEUERSPANNUNG", strSteuerSpannung);
            }
            else
            {
                    ECL_SelectValue("BREMSE_STEUERSPANNUNG", "24-24"); // Von der alten Engine übernommen
                
            }
        }
    }
}

function Bestimme_BREMSE_FUNKTIONSGLEICHRICHTER(oData,oDataBremse)
{
    var strSpecString=  createSpecString(oData);	
    var strSteuerspannung=ECL_GetValue("BREMSE_STEUERSPANNUNG");
    var strBereich_1 = left(strSteuerspannung,find(strSteuerspannung,"-")-1);
    var strBereich_2 = right(strSteuerspannung,find(strSteuerspannung,"-")-1);
    
    var strSelect = "SELECT DISTINCT BREGLR_MLFB,FKTGLR_KNZ FROM BREDAT_M3,BREDATELAUSF_M3, BREDATMOTSPG WHERE ";
    strSelect = strSelect + "BREDATELAUSF_M3.MOTELAUSF = '"+strSpecString+"' AND "
    strSelect = strSelect + "(BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' OR BREDAT_M3.BREART = 'ALL') AND ";
    
    strSelect = strSelect + "BREDAT_M3.SONDER = '-' AND BREDAT_M3.G110M='0' AND BREDAT_M3.G115M='0' AND BREDAT_M3.G115D='0' AND ";
    strSelect = strSelect + "(MOTTYP = 'ALL' OR MOTTYP='"+oData.oRow.MOTTYP+"') AND ";
    strSelect = strSelect + "BREDAT_M3.STANDARD = '1' AND ";
    strSelect = strSelect + "BREDAT_M3.BEREICH_1 = '"+strBereich_1+"' AND BREDAT_M3.BEREICH_2 = '"+strBereich_2+"' AND ";
    strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "BREDATELAUSF_M3.BREGLR = BREDAT_M3.BREGLR_MLFB AND ";
    strSelect = strSelect + "(BREDAT_M3.MOTDIM = '-' OR BREDAT_M3.MOTDIM = '"+oData.oRow.MOTDIM+"') AND ";
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='-' AND ";
    }
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "BREDAT_M3.ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "BREDAT_M3.ATEX='0' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
            
    strSelect = strSelect + "BREDAT_M3.CDROM_REL = '1' ";
    
    
    if(oData.oRow.S09 == "1")
        strSelect = strSelect + "AND BREDAT_M3.BREGLR <> 'Uebererreg.+DC-Absch.Stromerf.' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    ECL_DeactivateAllAttributeValues("BREMSE_FUNKTIONSGLEICHRICHTER");

    var bRectifierPossible=false;
    
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            if(aResult[i].FKTGLR_KNZ==1)
            {
                ECL_ActivateValue("BREMSE_FUNKTIONSGLEICHRICHTER", aResult[i].BREGLR_MLFB);
                bRectifierPossible=true;
            }
            else
                ECL_ActivateValue("BREMSE_FUNKTIONSGLEICHRICHTER", "ohne");
        }

        if(!bRectifierPossible)
        {
            ECL_DisableAttribute("BREMSE_FUNKTIONSGLEICHRICHTER");
            ECL_DeactivateAttribute("BREMSE_FUNKTIONSGLEICHRICHTER");
        }
        else
        {
            ECL_ActivateAttribute("BREMSE_FUNKTIONSGLEICHRICHTER");
            ECL_EnableAttribute("BREMSE_FUNKTIONSGLEICHRICHTER");
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen Funktionsgleichrichter, SQL="+strSelect);
    }
    
    //Defaultwert
    if(isnewDefaultnecessary("BREMSE_FUNKTIONSGLEICHRICHTER"))
    {
        ECL_SelectValue("BREMSE_FUNKTIONSGLEICHRICHTER", "ohne");
    }
}

function Bestimme_BREMSE_AUSFUEHRUNG(oData,oDataBremse)
{
    var strSelect = "SELECT DISTINCT BREAUS,BREKAPS FROM BRETYP,MOANBEF_N WHERE ";
        
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOANBEF_N.MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_N.SCHUTZART = '"+ECL_GetValue ("SCHUTZART")+"' AND ";
    strSelect = strSelect + "BRETYP.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_N.M3 = '1' AND MOANBEF_N.G115D='0' AND MOANBEF_N.G115M='0' AND MOANBEF_N.REGION='S' AND ";
    strSelect = strSelect + "MOANBEF_N.MOEINKL = '"+strMOEINKL+"' AND ";
    strSelect = strSelect + "BRETYP.TYPBEZ = MOANBEF_N.BRETYP AND ";
    strSelect = strSelect + "BRETYP.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRETYP.BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BRETYP.BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "BRETYP.BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG")+"' AND ";
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='Kauf' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='-' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='-' AND ";
    }
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='0' AND ";
    }
    
    strSelect = strSelect + "BRETYP.CDROM_REL = '1' ";
    
    //Bei S09 weitere Einschränkungen
    if(oData.oRow.S09=="1")
        strSelect = strSelect + "AND MOANBEF_N.BRETYP NOT IN (SELECT BRETYP FROM MOANBEF_UNDEF2 WHERE MOABSSART='S09' AND MOTDIM='"+oData.oRow.MOTDIM+"') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    ECL_DeactivateAllAttributeValues("BREMSE_AUSFUEHRUNG");
    
    var strNormalAusfuehrung = "";
    var strGekapseltAusfuehrung = "";
            
    if ( aResult.length > 0 )
    {
        for(var i=0;i<aResult.length;i++)
        {
            strNormalAusfuehrung = aResult[i].BREAUS;
            strGekapseltAusfuehrung = aResult[i].BREKAPS;
            
            if(strNormalAusfuehrung == "N" || strNormalAusfuehrung == "M")
                ECL_ActivateValue("BREMSE_AUSFUEHRUNG", "N");
            
            if(strGekapseltAusfuehrung == "G")
            {
                ECL_ActivateValue("BREMSE_AUSFUEHRUNG", "G");
                ECL_ActivateValue("BREMSE_AUSFUEHRUNG", "GK");
            }
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen Ausführung, SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_AUSFUEHRUNG"))
    {
        ECL_SelectValue("BREMSE_AUSFUEHRUNG", "N");
    }
}

function Bestimme_BREMSE_UEBERWACHUNG(oData,oDataBremse)
{
    var strSelect = "SELECT * FROM BRETYP WHERE ";
    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG")+"' AND ";
    
    if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "N")
        strSelect = strSelect + "BREKAPS = '-' AND ";
    else if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "G" || ECL_GetValue("BREMSE_AUSFUEHRUNG") == "GK")
        strSelect = strSelect + "BREKAPS = 'G' AND ";
        
    strSelect = strSelect + "BREAUS = 'M' AND ";
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='-' AND ";
    }
    
    strSelect = strSelect + "CDROM_REL = '1' ";
    
    //Bei S09 weitere Einschränkungen
    if(oData.oRow.S09=="1")
        strSelect = strSelect + "AND BRETYP.TYPBEZ NOT IN (SELECT BRETYP FROM MOANBEF_UNDEF2 WHERE MOABSSART='S09' AND MOTDIM='"+oData.oRow.MOTDIM+"') ";
    
    ECL_DeactivateAllAttributeValues("BREMSE_UEBERWACHUNG");
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if(aResult.length > 0)
    {
        var strSelect = "SELECT DISTINCT BREUEB FROM BREUEB WHERE ";
        strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            strSelect = strSelect + "ATEX='1' AND ";
        }
        else
        {
            strSelect = strSelect + "ATEX='0' AND ";
        }
        
        if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "N")
            strSelect = strSelect + "(BREAUS = 'N' OR BREAUS = 'M') AND ";
        else if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "G" || ECL_GetValue("BREMSE_AUSFUEHRUNG") == "GK")
            strSelect = strSelect + "(BREAUS = '-' OR BREAUS = 'M') AND ";
        
        strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
        strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
        strSelect = strSelect + "CDROM_REL='1' AND AKTIV = '1' AND G110M='0' AND G115D='0' AND G115M='0' AND SONDER='-'";
        
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
        
                ECL_ActivateValue("BREMSE_UEBERWACHUNG", aResult[i].BREUEB);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Bremsen Ausführung, SQL="+strSelect);
        }
    }
    else
    {
        //Ohne geht immer
        ECL_ActivateValue("BREMSE_UEBERWACHUNG", "ohne");
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_UEBERWACHUNG"))
    {
        ECL_SelectValue("BREMSE_UEBERWACHUNG", "ohne");
    }
}

function Bestimme_BREMSE_KORROSIONSCHUTZ(oData,oDataBremse)
{
    var awhere = new Array();
    awhere.push({BREKORR:"MOTTYP",Value:oData.oRow.MOTTYP});
    awhere.push({BREKORR:"BREART",Value:oDataBremse.oRow.BREART});
    awhere.push({BREKORR:"MOTDIM",Value:oData.oRow.MOTDIM});
    awhere.push({BREKORR:"ANWTYP",Value:oData.oRow.ANWTYP});
    awhere.push({BREKORR:"M3",Value:oData.oRow.M3});
    awhere.push({BREKORR:"G115M",Value:'0'});
    awhere.push({BREKORR:"G115D",Value:'0'});
    awhere.push({BREKORR:"GM3",Value:oData.oRow.GM3});
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        awhere.push({BREKORR:"KONSTAFS_BRE",Value:'Kauf'});
    }
    else
    {
        awhere.push({BREKORR:"KONSTAFS_BRE",Value:'-'});
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        awhere.push({BREKORR:"UMGEB_TEMP_MAX",Value:parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)});
    
    var aAttributes = new Array();
    aAttributes.push({IDENT:"BREMSE_KORROSIONSSCHUTZ",DB:"BREKORR"});
    ExecSQL_Standard("2KJ_DB", "BREKORR", aAttributes, awhere);
    
    var aDefaultSQL = "AND DEFLT = '1' AND UMGEB_TEMP_MAX='-20 ... +45°C' ";
    ExecSQL_GetDefaultStandard("2KJ_DB", "BREKORR", aAttributes, awhere, aDefaultSQL);
    
}

function Bestimme_BREMSE_REIBBELAG(oData,oDataBremse)
{
    var strBREGRDTYP = Bestimme_Bremse_BREGRDTYP(oDataBremse);
    var dBrakeDrehzahlMax=Bestimme_Bremse_MaxDrehzahl_mitReibbelag(oData, strBREGRDTYP, oDataBremse.oRow.BREREDMO);
    if(parseInt(dBrakeDrehzahlMax) < parseInt(oData.oRow.BDRHZAHL_MOTOR))
    {
        // verschleißarer Reibbelag nicht möglich
        ECL_DeactivateAllAttributeValues("BREMSE_REIBBELAG");
        ECL_ActivateValue("BREMSE_REIBBELAG", "normal");
        ECL_SelectValue("BREMSE_REIBBELAG", "normal");

        logtraceln("Maximale Bremsendrehzahl kleiner als die Motordrehzahl "+dBrakeDrehzahlMax+"<"+oData.oRow.BDRHZAHL_MOTOR);
    }
    else
    {
    
        var strSchutzdach="-";
        if(ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
            strSchutzdach="W";

        var strHEMOTOR="-";
        var strMotbez=oData.oRow.MOT_BZ_LANG;
        if(oData.oRow.VSDMOTOR=="V")
        {
            strMotbez=trimright(strMotbez,"V");
            if(strMotbez.right(1)=="S"){
                strHEMOTOR="S";
            }
            else if(strMotbez.right(1)=="P"){
                strHEMOTOR="P";	
            }
        }
        else
        {
            if(strMotbez.right(1) == "E"){
                strHEMOTOR = 'E';
            }
            else if(strMotbez.right(1) == "P"){
                strHEMOTOR = 'P';
            }
        }

        var strSelect = "SELECT DISTINCT BREGERRED.BREGERRED FROM BREGERRED,BRETYP_ERW_M3 WHERE ";
        strSelect = strSelect + "(BREGERRED.MOTDIM = '"+oData.oRow.MOTDIM+"' OR BREGERRED.MOTDIM = 'ALL') AND ";
        strSelect = strSelect + "(BREGERRED.POLZAHL = '"+ECL_GetValue("ECSI_POLZAHL")+"' OR BREGERRED.POLZAHL = 'ALL') AND ";
        strSelect = strSelect + "BREGERRED.MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
        strSelect = strSelect + "BREGERRED.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
        strSelect = strSelect + "(BREGERRED.BREGRDTYP = '"+strBREGRDTYP+"' OR BREGERRED.BREGRDTYP = 'ALL') AND ";
        strSelect = strSelect + "(BREGERRED.VSDMOTOR = '"+oData.oRow.VSDMOTOR+"' OR BREGERRED.VSDMOTOR = 'ALL') AND ";
        strSelect = strSelect + "(BREGERRED.HEMOTOR = '"+strHEMOTOR+"' OR BREGERRED.HEMOTOR = 'ALL') AND ";
        strSelect = strSelect + "BREGERRED.AKTIV = '1' AND ";
        strSelect = strSelect + "BREGERRED.M3 = '"+oData.oRow.M3+"' AND ";
        strSelect = strSelect + "BREGERRED.GM3 = '"+oData.oRow.GM3+"' AND ";
        strSelect = strSelect + "BREGERRED.G115D = '0' AND ";
        strSelect = strSelect + "BREGERRED.G115M = '0' AND ";
        strSelect = strSelect + "BREGERRED.BREGERRED = BRETYP_ERW_M3.BREGERRED AND ";

        strSelect = strSelect + "BRETYP_ERW_M3.BREGRDTYP = '"+strBREGRDTYP+"' AND ";
        strSelect = strSelect + "BRETYP_ERW_M3.BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";

        if(ECL_GetValue("BREMSE_STEUERSPANNUNG")=="24-24" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="103-103" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="180-180" || ECL_GetValue("BREMSE_STEUERSPANNUNG")=="205-205")
            strBREFREQ="00";
         else
            strBREFREQ="50/60";
        
        strSelect = strSelect + "BRETYP_ERW_M3.BREFREQ = '"+strBREFREQ+"' AND ";

        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "BRETYP_ERW_M3.ATEX = '1' AND ";
        }
        else
        {
            strSelect = strSelect + "BRETYP_ERW_M3.ATEX = '0' AND ";
        }

        strSelect = strSelect + "BRETYP_ERW_M3.AKTIV = '1' AND ";
        
        strSelect = strSelect + "(CAST(BREGERRED.BDRHZAHL_1 AS INT) >= "+parseInt(oData.oRow.BDRHZAHL_MOTOR)+ " OR BREGERRED.BDRHZAHL_1='ALL') AND ";
    

        if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
        {
            strSelect = strSelect + "BREGERRED.KONSTAFS_BRE='ALL' ";
        }
        else
        {
            strSelect = strSelect + "(BREGERRED.KONSTAFS_BRE='-' OR BREGERRED.KONSTAFS_BRE='ALL') ";
        }
        
        if(ECL_ValueSelected("MIT_GEBER", "T"))
        {
            strSelect = strSelect + "AND BREGERRED.BREGERRED IN (SELECT DISTINCT BREGERRED FROM GEBTYPX_M3 WHERE ";	
            
            var strGEBGRD=Bestimme_GEBGRD(oData);
            
            strSelect = strSelect + "GEBTYPX_M3.GEBGRD = '"+strGEBGRD+"' AND ";
            strSelect = strSelect + "GEBTYPX_M3.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
            
            strSelect = strSelect + "GEBTYPX_M3.SCHUTZDACH = '"+strSchutzdach+"' AND ";
            
            strSelect = strSelect + "GEBTYPX_M3.KONSTBREM = 'Kauf' AND ";
            strSelect = strSelect + "GEBTYPX_M3.S09 = '"+oData.oRow.S09+"' ";
            
            strSelect = strSelect + "AND GEBTYPX_M3.REGION IN ('S','SA') ";
                
            strSelect = strSelect + ")";
        }
        
        ECL_DeactivateAllAttributeValues("BREMSE_REIBBELAG");
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if ( aResult.length > 0 )
        {
            if ( aResult.length > 0 )
            {
                for(var i=0;i<aResult.length;i++)
                {
                    ECL_ActivateValue("BREMSE_REIBBELAG", aResult[i].BREGERRED);
                }
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Bremsen Reibbelag, SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("BREMSE_REIBBELAG"))
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND BREGERRED.DEFLT = '1'");
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("BREMSE_REIBBELAG", aResultDefault[0].BREGERRED);
            }
            else
            {
                ECL_SelectValue("BREMSE_REIBBELAG", (aResult.length>0?aResult[0].BREGERRED:''));
            }
        }
    }
}

function Bestimme_BREMSE_HANDLUEFTUNG(oData,oDataBremse)
{
    var strSchutzdach="-";
    if(ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
        strSchutzdach="W";
        
    var strSelect = "SELECT DISTINCT BRETYP.BREHLART FROM BRETYP,MOANBEF_N WHERE ";
    strSelect = strSelect + "BRETYP.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BRETYP.BRENENMO = '"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect + "BRETYP.BREREDMO = '"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect + "MOANBEF_N.BRETYP = BRETYP.TYPBEZ AND ";
    strSelect = strSelect + "MOANBEF_N.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOANBEF_N.SCHUTZART = 'IP55' AND ";
    strSelect = strSelect + "BRETYP.CDROM_REL = '1' AND ";
    strSelect = strSelect + "MOANBEF_N.M3 = '1' AND MOANBEF_N.G115D='0' AND MOANBEF_N.G115M='0' AND MOANBEF_N.REGION='S' AND ";
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='Kauf' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='-' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='-' AND ";
    }
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.ATEX='0' AND ";
    }
    
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
        
    strSelect = strSelect + "MOANBEF_N.MOEINKL = '"+strMOEINKL+"' ";
    
    //Bei S09 weitere Einschränkungen
    if(oData.oRow.S09=="1")
        strSelect = strSelect + "AND MOANBEF_N.BRETYP NOT IN (SELECT BRETYP FROM MOANBEF_UNDEF2 WHERE MOABSSART='S09' AND MOTDIM='"+oData.oRow.MOTDIM+"') ";

    if(ECL_ValueSelected("MIT_GEBER", "T"))
    {
        var strGeber=ECL_GetValue("GEBER_DIREKTAUSWAHL");
        
        if(strGeber != "") 
        {
            strSelect = strSelect + "AND BREHLART IN (SELECT DISTINCT BREHLART FROM GEBTYPX_M3 WHERE ";	

            var strGEBGRD=Bestimme_GEBGRD(oData);
            
            strSelect = strSelect + "GEBTYPX_M3.GEBGRD = '"+strGEBGRD+"' AND ";
            strSelect = strSelect + "GEBTYPX_M3.MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
            
            strSelect = strSelect + "GEBTYPX_M3.SCHUTZDACH = '"+strSchutzdach+"' AND ";
            
            strSelect = strSelect + "GEBTYPX_M3.KONSTBREM = 'Kauf' AND ";
            strSelect = strSelect + "GEBTYPX_M3.S09 = '"+oData.oRow.S09+"' ";
            
            strSelect = strSelect + "AND GEBTYPX_M3.REGION IN ('S','SA') ";
                
            strSelect = strSelect + ")";
        }
    }
    
    ECL_DeactivateAllAttributeValues("BREMSE_HANDLUEFTUNG");
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BREMSE_HANDLUEFTUNG", aResult[i].BREHLART);
            }
        }
    }
    else
    {
        logtraceln("Fehler Handlüftung Bremse! SQL="+strSelect);
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_HANDLUEFTUNG"))
    {
        ECL_SelectValue("BREMSE_HANDLUEFTUNG", "-");
    }
}

function Bestimme_BREMSE_HANDLUEFTUNGSLAGE(oData,oDataBremse)
{
    var strKlemmkastenlage=ECL_GetValue("KLEMMKASTENLAGE").left(1);
    var strKlemmkastenlage2=ECL_GetValue("KLEMMKASTENLAGE");
    
    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "KKHL = '"+strKlemmkastenlage+"' AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') AND ";
    strSelect = strSelect + "M3='1' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "REGION IN ('S','SCE') AND ";
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        var strMOPOSHL=Bestimme_MOPOSHL(oData);
        
        strSelect = strSelect + "MOPOSHL='"+strMOPOSHL+"' AND ";
        strSelect = strSelect + "BREHLLAG.ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "BREHLLAG.ATEX='0' AND ";
    }
    
    if(ECL_ValueSelected("BELUEFTUNG", "Zugeordneter Luefter"))
        strSelect = strSelect + "BELART = 'F' ";
    else
        strSelect = strSelect + "BELART = '-' ";
        
    var strMOEINKL = oData.oRow.MOT_BZ_LANG;
    strMOEINKL = strMOEINKL.left(3);
    if(strMOEINKL.right(1) == "N")
        strMOEINKL = "N";
    else if(strMOEINKL.right(1) == "S")
        strMOEINKL = "S";
    else
        strMOEINKL = "-";
    
    ECL_DeactivateAllAttributeValues("BREMSE_LAGE_HANDLUEFTUNGSHEBEL");
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", aResult[i].BREHLLAG);
                
                var strImage="2KJ3\\%LANG%\\motoroptionen\\HDL\\HDL"+aResult[i].BREHLLAG+".png";
                ECL_SetValueImage ("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", aResult[i].BREHLLAG, strImage);
            }
        }
    }
    else
    {
        logtraceln("Fehler Handlüftungslage Bremse! SQL="+strSelect);
    }

    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG_UNDEF WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    
    strSelect = strSelect + "MOEINKL = '"+strMOEINKL+"' AND ";

    strSelect = strSelect + "BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "BREHLART = '"+ECL_GetValue("BREMSE_HANDLUEFTUNG")+"' AND ";
    
    //Unterscheidung Großmotor oder Normalmotor
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    strSelect = strSelect + "GM3 = '"+oData.oRow.GM3+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    
    strSelect = strSelect + "KKLAGE = '"+strKlemmkastenlage2+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {		
        for(var i=0;i<aResult.length;i++)
        {
            ECL_DeactivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", aResult[i].BREHLLAG);
        }
    }
        
    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG_UNDEF3 WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "KKLAGE = '"+strKlemmkastenlage2+"' AND ";
    
    strSelect = strSelect + "M3 = '"+oData.oRow.M3+"' AND ";
    
    var strMotorstecker = ECL_GetValue("MOTORSTECKER");
    
    if(ECL_GetValue("GEGENSTECKER") != "ohne")
    {
        strMotorstecker = strMotorstecker + "+Stecker";
    }
    
    strSelect = strSelect + "KKMAT = '"+strMotorstecker+"' AND ";
    strSelect = strSelect + "KKMAT_KABEL_ZUB = '-' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_DeactivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", aResult[i].BREHLLAG);
            }
        }
    }

    var strSelect = "SELECT DISTINCT BREHLLAG FROM BREHLLAG_UNDEF4 WHERE ";
    strSelect = strSelect + "KKLAGE = '"+strKlemmkastenlage2+"' AND ";
    strSelect = strSelect + "MECH_ZUB = '"+ECL_GetValue("GEBER_ZUB_KABEL")+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_DeactivateValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", aResult[i].BREHLLAG);
            }
        }
    }
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("BREMSE_LAGE_HANDLUEFTUNGSHEBEL"))
    {
        if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "1"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "1");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "2"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "2");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "3"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "3");
        else if(ECL_ValueEnabled("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "4"))
            ECL_SelectValue("BREMSE_LAGE_HANDLUEFTUNGSHEBEL", "4");
    }
}

function Bestimme_BREMSE_BREMSKABELSCHUTZ(oData,oDataBremse)
{
    var strSelect = "SELECT * FROM BREKSHTZ_MOT_M3 WHERE "
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "BREAUS = '" + ECL_GetValue("BREMSE_AUSFUEHRUNG") + "' AND ";
    strSelect = strSelect + "G110M='0' AND G115D='0' AND G115M='0' AND ";
    
    var strKKABDICH="ohne";
    if(ECL_ValueSelected("ANSCHLUSSKASTEN_VERGOSSEN_OPTION", "T"))
        strKKABDICH="vergossen";
    strSelect = strSelect + "KKABDICH='"+strKKABDICH+"' ";
    
    //Bei S09 weitere Einschränkungen
    if(oData.oRow.S09=="1")
        strSelect = strSelect + "AND BREKSHTZ_MOT_M3.MOTDIM NOT IN (SELECT MOTDIM FROM BREKSHTZ_MOT_UNDEF WHERE MOABSSART='S09') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
        {
            //Bremskabelschutz nicht erlaubt bei ATEX
            ECL_DeselectValue("BREMSE_BREMSKABELSCHUTZ_OPTION", "T");
            ECL_DisableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION")
        }
        else
        {		
            //Bremskabelschutz erlaubt
            ECL_EnableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION")
            ECL_EnableValue("BREMSE_BREMSKABELSCHUTZ_OPTION", "T");
        }
    }
    else
    {
        //Bremskabelschutz nicht erlaubt
        ECL_DeselectValue("BREMSE_BREMSKABELSCHUTZ_OPTION", "T");
        ECL_DisableAttribute("BREMSE_BREMSKABELSCHUTZ_OPTION")
    
    }
}

function Bestimme_BREMSE_BRESHLT(oData,oDataBremse)
{
    
    var strSpecString=  createSpecString(oData);	
    
    var strSelect = "SELECT DISTINCT BREDAT_M3.BRESHLT, BREDAT_M3.BRESHLT_DEFLT FROM BREDAT_M3,BREEREG,BREDATELAUSF_M3 WHERE ";
    

    strSelect = strSelect + "BREEREG.BREART = '"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect + "(BREDAT_M3.BREART = '"+oDataBremse.oRow.BREART+"' OR BREDAT_M3.BREART = 'ALL') AND ";
    strSelect = strSelect + "BREDATELAUSF_M3.MOTELAUSF = '"+strSpecString+"' AND ";
    
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Stromerf.")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'am Klemmbrett' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "Uebererreg.+DC-Absch.Spgerf.")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
    {
        strSelect = strSelect + "BREDAT_M3.BRESHLT = 'nicht am Klemmbrett' AND ";
    }
    
    if(ECL_ValueSelected("ECSI_SPEZIFIKATION_CHECK", "ULR_CSA"))
    {
        strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    }
    else if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") != "ohne")
    {
        strSelect = strSelect + "(MOTDIM = '-' OR MOTDIM = '"+oData.oRow.MOTDIM+"') AND ";
    }
    else
    {
        strSelect = strSelect + "MOTDIM = '-' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(BREDAT_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
    
    strSelect = strSelect + "BREDAT_M3.SONDER = '-' AND BREDAT_M3.G110M='0' AND BREDAT_M3.G115M='0' AND BREDAT_M3.G115D='0' AND ";
    strSelect = strSelect + "(MOTTYP = 'ALL' OR MOTTYP='"+oData.oRow.MOTTYP+"') AND ";
        
    if(ECL_GetValue("BREMSE_FUNKTIONSGLEICHRICHTER") == "ohne")
        strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '0' AND ";
    else
        strSelect = strSelect + "BREDAT_M3.FKTGLR_KNZ = '1' AND ";
        
    strSelect = strSelect + "BREDAT_M3.BREEREG = BREEREG.BREEREG AND ";
    strSelect = strSelect + "BREDAT_M3.S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "BREDATELAUSF_M3.BREGLR = BREDAT_M3.BREGLR AND ";
    
    /*
    strSelect = strSelect + "BREDATMOTSPG.BEREICH_1 = BREDAT_M3.BEREICH_1 AND ";
    strSelect = strSelect + "BREDATMOTSPG.BEREICH_2 = BREDAT_M3.BEREICH_2 AND ";
    */
    
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "BREDAT_M3.KONSTAFS_BRE='-' AND ";
    }
    
    if (ECL_GetValue("ECSI_ATEX_KENNER")=="ATEX_INTEGRATED")
    {
        strSelect = strSelect + "BREDAT_M3.ATEX='1' AND ";
        strSelect = strSelect + "BREDATELAUSF_M3.ATEX='1' AND ";
    }
    else
    {
        strSelect = strSelect + "BREDAT_M3.ATEX='0' AND ";
        strSelect = strSelect + "BREDATELAUSF_M3.ATEX='0' AND ";
    }
    
    strSelect = strSelect + "STANDARD = '1' AND ";
    strSelect = strSelect + "CDROM_REL = '1' AND ";
    strSelect = strSelect + "BREDAT_M3.AKTIV = '1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if ( aResult.length > 0 )
    {
        var strBRESHLT = aResult[0].BRESHLT;
        var strBRESHLT_DEFLT = aResult[0].BRESHLT_DEFLT;
        if(strBRESHLT_DEFLT == "1")
            return strBRESHLT;
        else
            return "";
        
    }
    else
    {
        logtraceln("Fehler Bestimmung Bremsen BRESHLT, SQL="+strSelect);
        return "";
    }
}

function Bestimme_GEBGRD(oData)
{
    var strGeber=ECL_GetValue("GEBER_DIREKTAUSWAHL");
    strGeber=replace(strGeber,"|-","");
    strGeber=replace(strGeber,"|Kauf","");
    
    var strKonstaFS_Geber = ECL_GetValue("GEBER_FUNKT_SICHERHEIT");
	var strGeber_Ausfuehrung = ECL_GetValue("GEBER_AUSFUEHRUNG");
	
	var strSelect="SELECT DISTINCT GEBGRD FROM GEBTYP_M3 WHERE GEBER='"+strGeber+"' AND ";
	strSelect = strSelect + "SONDER = '-' AND ";
	strSelect = strSelect + "KONSTAFS_GEB = '"+strKonstaFS_Geber+"' ";
	
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0)
        return aResult[0].GEBGRD;
    else
        logtraceln("Fehler beim Bestimmen GEBGRD, SQL="+strSelect);
}

function Bestimme_MOPOSHL(oData)
{
    var strBelArt="-";
    if(ECL_GetValue("BELUEFTUNG")=="Zugeordneter Luefter")
        strBelArt="F";
    
    var strGeber="-";
    if(ECL_ValueSelected("MIT_GEBER", "T"))
        strGeber="Kauf";
    
    var strSelect="SELECT DISTINCT MOPOSHL FROM MOPOSHL_M3 WHERE ";
    strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM")+"' AND ";
    strSelect = strSelect + "ZGPOSHL='-' AND ";
    strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
    strSelect = strSelect + "(BELART='"+strBelArt+"' OR BELART='ALL') AND ";
    strSelect = strSelect + "(KONSTAGEBER='"+strGeber+"' OR KONSTAGEBER='ALL') AND ";
    
    if(ECL_ValueSelected("SCHUTZDACH_OPTION", "T"))
        strSelect = strSelect + "(BELSDACH = 'W' OR BELSDACH='ALL') AND ";
    else
        strSelect = strSelect + "(BELSDACH = '-' OR BELSDACH='ALL') AND ";
    
    strSelect = strSelect + "REGION ='S' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length==1)
        return aResult[0].MOPOSHL;
    else
        logtraceln("Fehler beim Bestimmen MOTPOSHL für ATEX, SQL="+strSelect);
}

function Bestimme_Bremse_MaxDrehzahl(oData,BREGRDTYP, BREREDMO)
{
    // Maximal Drehzahl der Bremse aus Tabelle lesen
    var strSelect="SELECT DISTINCT BREDZMAX_ARBEIT FROM BRETYP_ERW_M3 WHERE ";
    strSelect = strSelect +"BREGRDTYP='"+BREGRDTYP+"' AND ";
    strSelect = strSelect +"(BREREDMO='"+BREREDMO+"' OR BREREDMO='ALL')  ";

    var strBREGERRED=ECL_GetValue("BREMSE_REIBBELAG");
    if(strBREGERRED!="")
    {
        strSelect = strSelect +"AND BREGERRED='"+strBREGERRED+"' ";
    }
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "AND ATEX = '1' ";
    }
    else
    {
        strSelect = strSelect + "AND ATEX = '0' ";
    }

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if(aResult.length>0)
        return aResult[0].BREDZMAX_ARBEIT;
    else
        logtraceln("Fehler beim Bestimmen BREDZMAX_ARBEIT, SQL="+strSelect);

}

function Bestimme_Bremse_MaxDrehzahl_mitReibbelag(oData,BREGRDTYP, BREREDMO)
{
    // Maximal Drehzahl der Bremse aus Tabelle lesen
    var strSelect="SELECT DISTINCT BREDZMAX_ARBEIT FROM BRETYP_ERW_M3 WHERE ";
    strSelect = strSelect +"BREGRDTYP='"+BREGRDTYP+"' AND ";
    strSelect = strSelect +"(BREREDMO='"+BREREDMO+"' OR BREREDMO='ALL')  AND ";

    strSelect = strSelect +"BREGERRED='verschl.armer Belag' ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "AND ATEX = '1' ";
    }
    else
    {
        strSelect = strSelect + "AND ATEX = '0' ";
    }

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if(aResult.length>0)
        return aResult[0].BREDZMAX_ARBEIT;
    else
    {
        logtraceln("verschleißarmer Belag nicht möglich!, SQL="+strSelect);
        return "0";
    }

}

function Bestimme_Bremse_BREGRDTYP(oDataBremse)
{
    // Maximal Drehzahl der Bremse aus Tabelle lesen
    var strSelect="SELECT DISTINCT BREGRDTYP FROM BRETYP WHERE ";
    strSelect = strSelect +"BREART='"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect +"BRENENMO='"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect +"BREREDMO='"+oDataBremse.oRow.BREREDMO+"' ";

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if(aResult.length>0)
        return aResult[0].BREGRDTYP;
    else
        logtraceln("Fehler beim Bestimmen BREGRDTYP, SQL="+strSelect);

}

function Bestimme_Bremse_BRETYP_EINKL(oDataBremse)
{
    // Maximal Drehzahl der Bremse aus Tabelle lesen
    var strSelect="SELECT DISTINCT BRETYP_EINKL FROM BRETYP,MOANBEF_N WHERE ";
    strSelect = strSelect +"BRETYP.BREART='"+oDataBremse.oRow.BREART+"' AND ";
    strSelect = strSelect +"BRETYP.TYPBEZ=MOANBEF_N.BRETYP AND ";
    strSelect = strSelect +"BRETYP.BRENENMO='"+oDataBremse.oRow.BRENENMO+"' AND ";
    strSelect = strSelect +"BRETYP.BREREDMO='"+oDataBremse.oRow.BREREDMO+"' AND ";
    strSelect = strSelect +"BRETYP.BREHLART='"+ECL_GetValue("BREMSE_HANDLUEFTUNG")+"' AND ";
    
    if(ECL_GetValue("BREMSE_UEBERWACHUNG") != 'ohne')
        strSelect = strSelect +"BRETYP.BREAUS='M' AND ";
    else
        strSelect = strSelect +"(BRETYP.BREAUS='N' OR BRETYP.BREAUS='-') AND ";
  
    if(ECL_ValueSelected("BREMSE_SAFETY", "T"))
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='Kauf' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='Kauf' AND ";
    }
    else
    {
        strSelect = strSelect + "MOANBEF_N.KONSTAFS_BRE='-' AND ";
        strSelect = strSelect + "BRETYP.KONSTAFS_BRE='-' AND ";
    }

    if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "N")
        strSelect = strSelect + "BRETYP.BREKAPS = '-' ";
    else if(ECL_GetValue("BREMSE_AUSFUEHRUNG") == "G" || ECL_GetValue("BREMSE_AUSFUEHRUNG") == "GK")
        strSelect = strSelect + "BRETYP.BREKAPS = 'G' ";
        
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);

    if(aResult.length>0)
        return aResult[0].BRETYP_EINKL;
    else
        logtraceln("Fehler beim Bestimmen BRETYP_EINKL, SQL="+strSelect);

}