//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"

//@import "../2KJ_Functions.js"


function gethoechsteDrehzahlMotor(oData)
{
    var Motorspannung = ECL_GetValue ("MOTORSPANNUNG");
    
    var erhoehteLeistung="";
    var berhoehteLeistung = ECL_ValueSelected ("ERHOEHTE_LEISTUNG_OPTION", "T");
    if(berhoehteLeistung)
        erhoehteLeistung = "Ja";
    else
        erhoehteLeistung = "Nein";
        
    var	SpannungsTol="";
    var bSpannungsTol = ECL_ValueSelected ("SPANNUNGSTOLERANZ_OPTION", "T");
    if(bSpannungsTol)
        SpannungsTol = "+-10";
    else
        SpannungsTol = "-";
    
    var strSelect="SELECT DISTINCT MOT_BDRHZAHL FROM TMP_MOT_DATEN WHERE ";
    strSelect = strSelect + "MOT_EL_AUSFUEHRUNG='"+ECL_GetValue("ECSI_SPEZIFIKATION_RADIO")+"' AND ";
    strSelect = strSelect + "MOT_EFFIZIENZKL_KNZ='"+oData.oRow.MOT_EFFIZIENZKL_KNZ+"' AND ";
    strSelect = strSelect + "MOT_POLZAHL='"+ECL_GetValue("ECSI_POLZAHL")+"' AND ";
    strSelect = strSelect + "MOT_FREQUENZ='"+ECL_GetValue("ECSI_FREQUENZ_VORAUSWAHL")+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG='"+oData.oRow.LEISTUNG+"' AND ";
    strSelect = strSelect + "MOT_BZ_LANG='"+oData.oRow.MOT_BZ_LANG+"' AND ";
    strSelect = strSelect + "MOT_BETRIEBSART_KEY='"+ECL_GetValue("BETRIEBSART")+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_UI='"+Motorspannung+"' AND ";
    strSelect = strSelect + "MOT_LEISTUNG_ERH_TF='"+erhoehteLeistung+"' AND ";
    strSelect = strSelect + "MOT_SPANNUNG_TOL='"+SpannungsTol+"' AND ";
    strSelect = strSelect + "MOT_WAERMEKLASSE_KEY='"+ECL_GetValue("WAERMEKLASSE")+"' ";
    
    var aResultTable = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    var iMaximumDrehzahl=0;
    if(aResultTable.length>0)
    {
        for(var i=0;i<aResultTable.length;i++)
        {
            if(iMaximumDrehzahl < parseInt(aResultTable[i].MOT_BDRHZAHL))
                iMaximumDrehzahl = parseInt(aResultTable[i].MOT_BDRHZAHL);
        }
    }
    
    return iMaximumDrehzahl;
}

function Bestimme_AVMOKDBEZ(oData)
{
    //Bestimmung von AVMOKDBEZ für EGOAB_M3
    
    var strAVMODKDEZ="";
    var strSelect = "SELECT DISTINCT AVMOKDBEZ ";
    
    strSelect = strSelect + "FROM CD_MOTOREN_ANBAU WHERE ";
    strSelect = strSelect + "MOTDIM = '"+oData.oRow.MOTDIM+"' AND ";
    strSelect = strSelect + "MOTTYP = '"+oData.oRow.MOTTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if ( aResult.length > 0 )
    {
        strAVMODKDEZ = aResult[0].AVMOKDBEZ;
    }
    else
    {
        logtraceln("Fehler Bestimmung AVMOKDBEZ für EGOAB_M3! SQL="+strSelect);
    }
    
    return strAVMODKDEZ;
}

function Bestimme_EGABAUSF(oData)
{
    //Bestimmung EGABAUSF für Abtriebswellenlagerung
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART");
    var strWellenmass=replace(ECL_GetValue("ABTRIEBSWELLENMASS"),'ZOLL','"');
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    var strSelect = "SELECT DISTINCT EGABAUSF FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND EGABW='"+strWellenmass+"' AND REGION='S' AND G115='0' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0){
        return aResult;
    }
    else{
        logtraceln("Fehler bei Bestimmung EGABAUSF für Abtriebswellenlagerung!, SQL="+strSelect);
    }
    return [];
}

function Bestimme_EGABKDBEZ(oData)
{
    var strWelle=ECL_GetValue("ABTRIEBSWELLENART");
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGTYP = oData.oRow.EGBEZTYP+oData.oRow.EGBEZUEBS+oData.oRow.EGBEZBRA+Abtriebswellentyp+ECL_GetValue("BEFESTIGUNGSART")+Verbindungsart+oData.oRow.EGBEZDIM+oData.oRow.EGBEZEI;
    strEGTYP = replace(strEGTYP, "-", "");
    
    var strSelect = "SELECT DISTINCT EGABKDBEZ FROM EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGTYP='"+strEGTYP+"' AND EGABW='"+replace(ECL_GetValue("ABTRIEBSWELLENMASS"),'ZOLL','"')+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0){
        return aResult[0].EGABKDBEZ;
    }
    else{
        logtraceln("Fehler bei Bestimmung EGABKDBEZ für Abtriebswellendichtung!, SQL="+strSelect);
    }
    return null;
}

function Bestimme_Abtriebswellenlagerung(oData)
{
	var aResult = Bestimme_EGABAUSF(oData);
	var Abtriebswellentyp = GetEGBEZANWTYP();
	var Verbindungsart = GetEGBEZWNV();
			
	var strSelect = "";
	for (var i=0;i<aResult.length;i++)
	{
		if(ECL_GetValue("BEFESTIGUNGSART")!="-" && ECL_GetValue("BEFESTIGUNGSART")!="D" )
		{
		
			strSelect = strSelect + "SELECT DISTINCT EGABALAG FROM EGLAGER_M3,EGABFLD_M3 WHERE ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGLAGER_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGLAGER_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGLAGER_M3.EGPOSHL='ALL') AND ";
			
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGLAGER_M3.EGBEZBRA='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGLAGER_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGLAGER_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGLAGER_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.OELSORTE='"+ECL_GetValue("GETRIEBEOEL")+"' OR EGLAGER_M3.OELSORTE='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZWNV='"+Verbindungsart+"' OR EGLAGER_M3.EGBEZWNV='ALL') AND ";
			
			strSelect = strSelect + "EGABFLD_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.AKTIV='1' AND ";
			strSelect = strSelect + "EGABFLD_M3.AKTIV='1' AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGLAGER_M3.EGABAUSF='ALL') AND ";
			
			
			strSelect = strSelect + "EGABFLD_M3.EGABFLDM='"+ECL_GetValue("BEFESTIGUNGSMASS")+"' AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGABFLD_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGABFLD_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZBRA='ALL' OR EGABFLD_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGABFLD_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGABFLD_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGABFLD_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGBEZWNV='"+Verbindungsart+"' OR EGABFLD_M3.EGBEZWNV='ALL') AND ";
			strSelect = strSelect + "(EGABFLD_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGABFLD_M3.EGABAUSF='ALL') AND ";
			strSelect = strSelect + "EGABFLD_M3.EINZELGETR='1' AND ";
			strSelect = strSelect + "EGABFLD_M3.REGION='S' ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
				strSelect = strSelect + "AND CAST(EGLAGER_M3.EGLAGER_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
				strSelect = strSelect + "AND CAST(EGABFLD_M3.UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
			
			//Drive Train Implementierung
			if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FT7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB5"))
			{
				strSelect = strSelect + "AND EGABALAG NOT IN ('XLplus Lagerung','VLplus Lagerung') ";
			}
			
			strSelect = strSelect + " UNION ";
		}
		else
		{
			strSelect = strSelect + "SELECT DISTINCT EGABALAG FROM EGLAGER_M3 WHERE ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGLAGER_M3.EGBEZTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGLAGER_M3.EGBEZUEBS='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGLAGER_M3.EGPOSHL='ALL') AND ";
			
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGLAGER_M3.EGBEZBRA='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGLAGER_M3.EGBEZAWTYP='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGLAGER_M3.EGBEZBEF='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGLAGER_M3.EGBEZDIM='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.OELSORTE='"+ECL_GetValue("GETRIEBEOEL")+"' OR EGLAGER_M3.OELSORTE='ALL') AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGBEZWNV='"+Verbindungsart+"' OR EGLAGER_M3.EGBEZWNV='ALL') AND ";
			
			strSelect = strSelect + "EGLAGER_M3.SONDER='-' AND ";
			strSelect = strSelect + "EGLAGER_M3.AKTIV='1' AND ";
			strSelect = strSelect + "(EGLAGER_M3.EGABAUSF='"+aResult[i].EGABAUSF+"' OR EGLAGER_M3.EGABAUSF='ALL') ";
			
			if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
				strSelect = strSelect + "AND CAST(EGLAGER_M3.EGLAGER_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
			
			
			//Drive Train Implementierung
			if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FT7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB5"))
			{
				strSelect = strSelect + "AND EGABALAG NOT IN ('XLplus Lagerung','VLplus Lagerung') ";
			}
			
			strSelect = strSelect + " UNION ";
		}
	}
	
	strSelect = trimright(strSelect," UNION ");

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENLAGERUNG");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("ABTRIEBSWELLENLAGERUNG",aResult[i].EGABALAG);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Abtriebswellenlagerung!, SQL="+strSelect);
        
    ExecSetStandardifValueEmpty("ABTRIEBSWELLENLAGERUNG", "zugeordnete Lagerung");			
}

function Bestimme_Getriebeoel(oData)
{
    var strSelect = "SELECT DISTINCT OELSORTE FROM OELSORTE_M3 WHERE ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "OELSORTE_M3.EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    
    //Für Kühlturm und Hängebahn abfragen
    strSelect = strSelect + "(OELSORTE_M3.ANWTYP='"+oData.oRow.ANWTYP+"' OR OELSORTE_M3.ANWTYP='ALL') AND ";
    strSelect = strSelect + "OELSORTE_M3.AKTIV='1' AND ";
    strSelect = strSelect + "OELSORTE_M3.G115 IN ('ALL','0') ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "AND OELSORTE_M3.ATEX = '1' ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "AND CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GETRIEBEOEL");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GETRIEBEOEL",aResult[i].OELSORTE);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Getriebeöl!, SQL="+strSelect);
    
    //Default Wert bestimmen
    
    //neue Lösung von Juliane 15.03.2021
    // bis 40°C ==> K06 - CLP VG220
    // 41°C bis 50°C ==> K07 - CLP PG VG220
    // 60 °C ==> K08 - CLP PG VG460
        
    if(isnewDefaultnecessary("GETRIEBEOEL"))
    {
        
        var bSonderoel=false;
        if(oData.oRow.EGBEZTYP=="B" || oData.oRow.EGBEZTYP=="C" || (oData.oRow.EGBEZTYP=="B" && oData.oRow.EGBEZBRA=="H"))
            bSonderoel=true;
        
        var iAmbientTemerature = parseInt(oData.oRow.SIZER_AmbientTemperatureMotor);

        if(bSonderoel && iAmbientTemerature < 60 && ECL_ValueActive ("GETRIEBEOEL", "CLP PG VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL", "CLP PG VG220");
        }
        else if(iAmbientTemerature <= 40 && ECL_ValueActive ("GETRIEBEOEL", "CLP VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL", "CLP VG220");
        }
        else if( (iAmbientTemerature > 40 && iAmbientTemerature < 60) && ECL_ValueActive ("GETRIEBEOEL", "CLP PG VG220"))
        {
            ECL_SelectValue("GETRIEBEOEL", "CLP PG VG220");
        }
        else if (ECL_ValueActive ("GETRIEBEOEL", "CLP PG VG460"))
        {
            ECL_SelectValue("GETRIEBEOEL", "CLP PG VG460");
        }
    }
    
    //Pegasus Lösung
    /*
    var iAmbientTemerature = parseInt(oData.oRow.SIZER_AmbientTemperatureMotor);
    var strTempMin="-40";
    if(iAmbientTemerature>40)
        strTempMin="-20";
    
    if(isnewDefaultnecessary("GETRIEBEOEL"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' AND UMGEB_TEMP_MIN='"+strTempMin+"' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("GETRIEBEOEL", aResultDefault[0].OELSORTE);
        }
        else
        {
            var aResultDefault2 = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' AND UMGEB_TEMP_DEFLT='Standard' ");
            if(aResultDefault2.length>0)
            {
                ECL_SelectValue("GETRIEBEOEL", aResultDefault2[0].OELSORTE);
            }
            else
                ECL_SelectValue("GETRIEBEOEL", "CLP PG VG460");
        }
    }
    */
    
    //nach Vorgabe von Herrn Holland, wird das Default Öl CLP PG VG460 gesetzt / deaktiviert für Version 2021.04
    //if(isnewDefaultnecessary("GETRIEBEOEL"))
    //ECL_SelectValue("GETRIEBEOEL", "CLP PG VG460");
}

function Bestimme_Getriebeentlueftung(oData)
{
    var strSelect = "SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "(ANWTYP='"+oData.oRow.ANWTYP+"' OR ANWTYP='ALL') AND ";
    strSelect = strSelect + "(SCHUTZART='"+ECL_GetValue("SCHUTZART")+"' OR SCHUTZART='ALL') AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') AND ";
    strSelect = strSelect + "REGION IN ('S','SC') AND ";
    //strSelect = strSelect + "(CDROM_REL = '1' OR CDROM_REL = '2') AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    strSelect = strSelect + "EINZELGETR = '1' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    
    if(oData.oRow.ZGBEZUEBS != "-")
        strSelect = strSelect + "DOPPELGETRIEBE = '1' AND ";
    
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
    {
        if(ECL_GetValue("SE_ACHSE_WAHL") == "X")
            strSelect = strSelect + "X_ACHSE = '1' AND ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Y")
            strSelect = strSelect + "Y_ACHSE = '1' AND ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Z")
            strSelect = strSelect + "Z_ACHSE = '1' AND ";
    }
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "EGGEHENT_M3.ATEX = '1' AND ";
    }
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    
    if(!ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
    {

        strSelect = strSelect + "AND EGGEHENT NOT IN ( SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3_UNDEF WHERE ";
        strSelect = strSelect + "EGBEZTYP = '"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS = '"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
        strSelect = strSelect + "EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' AND ";
        strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
        strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM")+"' AND ";
        strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE")+"' OR EGABAWS='ALL') AND ";
        strSelect = strSelect + "SCHRAEGBAULAGEN='0' ) ";
    }

    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
    {
        
        strSelect = strSelect + "AND EGGEHENT NOT IN ( SELECT DISTINCT EGGEHENT FROM EGGEHENT_M3_UNDEF2 WHERE ";
        strSelect = strSelect + "EGBEZTYP = '"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
        strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM")+"' AND ";
        strSelect = strSelect + "MOTDIM_IEC='"+oData.oRow.MOTDIM+"' AND ";

        var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION"),4);
        var strEGPOS_Start = left(strDrehung,2);
        var strEGPOS_Ziel = right(strDrehung,2);
            
        strSelect = strSelect + "EGPOS_START = '"+strEGPOS_Start+"' AND ";
        strSelect = strSelect + "EGPOS_ZIEL = '"+strEGPOS_Ziel+"' AND ";

        if(ECL_GetValue("SE_ACHSE_WAHL") == "X")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"X_ACHSE_","")+"') ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Y")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Y_ACHSE_","")+"') ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Z")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Z_ACHSE_","")+"') ";
    }

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GETRIEBEENTLUEFTUNG");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GETRIEBEENTLUEFTUNG",aResult[i].EGGEHENT);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Getriebeentlüftung!, SQL="+strSelect);
    
    
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GETRIEBEENTLUEFTUNG"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND CDROM_DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("GETRIEBEENTLUEFTUNG", aResultDefault[0].EGGEHENT);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("GETRIEBEENTLUEFTUNG", aResult[0].EGGEHENT);
        }
    }
}


function istOelausgleichsbehaelter_vorgeschrieben(oData)
{
    var strSelect = "";
    var strEGPOS = "";
    
    if(ECL_GetValue("ABTRIEBSSEITE") != "-")
        strEGPOS = ECL_GetValue("BAUFORM") + "-" + ECL_GetValue("ABTRIEBSSEITE");
    else
        strEGPOS = ECL_GetValue("BAUFORM");
        
    
    if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
    {
        var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION"),4);

        var strEGPOS_Start = left(strDrehung,2);
        var strEGPOS_Ziel = right(strDrehung,2);
        
        if(ECL_GetValue("SE_ACHSE_WAHL") == "X")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_X_ACHSE WHERE ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Y")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_Y_ACHSE WHERE ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Z")
            strSelect = "SELECT DISTINCT OAB FROM EGPOS_SCHRAEGBAULAGEN_Z_ACHSE WHERE ";
            
            
        strSelect = strSelect + "EGPOS_START = '"+strEGPOS_Start+"' AND ";
        strSelect = strSelect + "EGPOS_ZIEL = '"+strEGPOS_Ziel+"' AND ";
        
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
        strSelect = strSelect + "EGBEZDIM_MIN<="+oData.oRow.EGBEZDIM+" AND EGBEZDIM_MAX>="+oData.oRow.EGBEZDIM+" AND ";
        
        if(ECL_GetValue("SE_ACHSE_WAHL") == "X")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"X_ACHSE_","")+"' ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Y")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Y_ACHSE_","")+"' ";
        else if(ECL_GetValue("SE_ACHSE_WAHL") == "Z")
            strSelect = strSelect + "X_ACHSE = '"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),"Z_ACHSE_","")+"' ";
    }
    else
    {
        strSelect = "SELECT DISTINCT OAB FROM EGPOS_BAULAGEN WHERE ";
        
        strSelect = strSelect + "EGPOS_START = '"+strEGPOS+"' AND ";
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
        
        strSelect = strSelect + "EGBEZDIM_MIN <= "+oData.oRow.EGBEZDIM+" AND ";
        strSelect = strSelect + "EGBEZDIM_MAX >= "+oData.oRow.EGBEZDIM+" AND ";
        
		strSelect = strSelect + "ZGBEZUEBS = '"+oData.oRow.ZGBEZUEBS+"' AND ";
		strSelect = strSelect + "ZGBEZDIM = '"+oData.oRow.ZGBEZDIM+"' AND ";
        strSelect = strSelect + "EINZELGETR = '1' AND ";
        strSelect = strSelect + "EGPOS_ZIEL = '-' ";
    }
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    var dN1;
    var strOAB = "0";
    if ( aResult.length == 1 )
    {		
        strOAB = aResult[0].OAB;
    }
    else
    {
        logtraceln("Fehler Bestimmung Ölausgleichsbehälter vorgeschrieben! SQL="+strSelect);
    }
    
    
    if(strOAB == "2" && ECL_GetValue("BAUFORM") == "M4")
    {
        var strAVMOKDBEZ = Bestimme_AVMOKDBEZ(oData);
        
        //jetzt auf Drehzahl prüfen!
        
        strSelect = "SELECT DISTINCT N1 FROM EGOAB_M3 WHERE ";
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
        strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
        strSelect = strSelect + "DGUEB='"+oData.oRow.UEBERSETZUNG+"' AND ";
        strSelect = strSelect + "AVMOKDBEZ='"+strAVMOKDBEZ+"' ";
        strSelect = strSelect + "ORDER BY cast(N1 AS FLOAT) ASC";
        
        var iDrehzahlMotor = 0;
        
        iDrehzahlMotor = gethoechsteDrehzahlMotor(oData);
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        var bOelausgleich_vorgeschrieben;
        if ( aResult.length > 0 )
        {
            dN1 = aResult[0].N1;
            
            if(iDrehzahlMotor >= dN1)
                bOelausgleich_vorgeschrieben = true;
            else
                bOelausgleich_vorgeschrieben = false;
        }
        
        if(bOelausgleich_vorgeschrieben)
        {
            logtraceln("Ölausgleich vorgeschrieben? N1="+dN1+" Bemessungsdrehzahl="+iDrehzahlMotor+" Ergebnis="+bOelausgleich_vorgeschrieben);
            return true;
        }
        else
        {
            logtraceln("Ölausgleich nicht vorgeschrieben!");
            return false;
        }
    }
    else
    {
        return false;
    }
}

function Bestimme_Abtriebswellenabdichtung(oData)
{
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
    
    var strEGABKDBEZ=Bestimme_EGABKDBEZ(oData);
    var aEGABAUSF=Bestimme_EGABAUSF(oData);
        
    var strSelect = "SELECT DISTINCT DICHTUNGSART,DRWERK FROM DRWERK_EG_M3 WHERE ";
    strSelect = strSelect + "(OELSORTE='"+ ECL_GetValue("GETRIEBEOEL")+"' OR OELSORTE='ALL') AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "(EGBEZAWTYP='"+Abtriebswellentyp+"' OR EGBEZAWTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZWNV='"+Verbindungsart+"' OR EGBEZWNV='ALL') AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(EGABKDBEZ='"+strEGABKDBEZ+"' OR EGABKDBEZ='ALL') AND ";
    
    if(aEGABAUSF.length != 0){
        strSelect = strSelect + "EGABAUSF='"+aEGABAUSF[0].EGABAUSF+"' AND ";
    }
    else{
        strSelect = strSelect + "EGABAUSF='undefined' AND "; //muss dazu, damit in der DB nichts gefunden wird        
    }

    strSelect = strSelect + "AKTIV='1' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
            
    strSelect = strSelect + "EINZELGETR='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("ABTRIEBSWELLENABDICHTUNG");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("ABTRIEBSWELLENABDICHTUNG",aResult[i].DICHTUNGSART);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Abtriebswellendichtung!, SQL="+strSelect);
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("ABTRIEBSWELLENABDICHTUNG"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("ABTRIEBSWELLENABDICHTUNG", aResultDefault[0].DICHTUNGSART);
        }
        if(aResult.length>0 && aResultDefault.length==0)
        {
            ECL_SelectValue("ABTRIEBSWELLENABDICHTUNG", aResult[0].DICHTUNGSART);
        }
    }
}

function Bestimme_Oelstandskontrolle(oData)
{
    var strSelect = "SELECT DISTINCT EGGEHOLK FROM EGGEHOLK_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(ANWTYP='"+oData.oRow.ANWTYP+"' OR ANWTYP='ALL') AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') AND ";
    strSelect = strSelect + "G115D='0' AND ";
    strSelect = strSelect + "G115M='0' AND ";
    strSelect = strSelect + "SONDER = '-' AND ";
    strSelect = strSelect + "REGION = 'S' AND ";

    if(oData.oRow.ZGBEZUEBS != "-")
        strSelect = strSelect + "DOPPELGETRIEBE = '1' AND ";

    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "EGGEHOLK_M3.ATEX = '1' AND ";
    }
    else
    {
        strSelect = strSelect + "EGGEHOLK_M3.ATEX = '0' AND ";
    }
    
	if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
	{
		strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
		strSelect = strSelect + "EINZELGETR = '1' AND ";
	}
	else
	{
		strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
		strSelect = strSelect + "EINZELGETR = '1' AND ";
	}
	
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" ";
    
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FT7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK7"))
    {
        strSelect = strSelect + "AND EGGEHOLK NOT IN ('Oelstand-Sensor') ";
    }
    // 1LE1 und 1MB Einschräkungen kommen schon über Pegasus
    
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
	{
		
		var strWinkeldb="";
		var strAchse="";
		var strWinkel =  ECL_GetValue("ZULAESSIGE_EINBAULAGENABWEICHUNG_WINKEL");
		
		if(strWinkel=="X_20")
		{
			strWinkeldb="+/-20°";
			strAchse="X";
		}
		else if(strWinkel=="Y_20")
		{
			strWinkeldb="+/-20°";
			strAchse="Y";
		}
		else if(strWinkel=="Y_20-0")
		{
			strWinkeldb="+20-0°";
			strAchse="Y";
		}
		
		strSelect = strSelect + "AND EGGEHOLK IN (SELECT DISTINCT EGGEHOLK FROM EGPOSWINKZUL_ZEABW WHERE ";
		strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
		strSelect = strSelect + "EGPOSHL='"+ECL_GetValue("BAUFORM")+"' AND ";
		strSelect = strSelect + "REGION='S' AND ";
		
		if(strAchse=="X")
		{
			strSelect = strSelect + "X_Achse='1' AND WINKEL like '"+strWinkeldb.left(5)+"%' ";
		}
		else if(strAchse=="Y")
		{
			strSelect = strSelect + "Y_Achse='1' AND WINKEL like '"+strWinkeldb.left(5)+"%' ";
		}
		strSelect = strSelect +")";
		
	}

    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("OELSTANDSKONTROLLE");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("OELSTANDSKONTROLLE",aResult[i].EGGEHOLK);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Ölstandskontrolle!, SQL="+strSelect);
        
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("OELSTANDSKONTROLLE"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("OELSTANDSKONTROLLE", aResultDefault[0].EGGEHOLK);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("OELSTANDSKONTROLLE", aResult[0].EGGEHOLK);
        }
    }	
}

function Bestimme_Oelablass(oData)
{
	var strSelect="";
	if(ECL_ValueSelected("SONDEREINBAULAGE_OPTION", "T"))
	{
		var strEGGEHOLA_OELSTAND_ZUL="";
		var strDrehung = right(ECL_GetValue("SE_ZIELPOSITION"),4);

		var strEGPOS_Start = left(strDrehung,2);
		var strEGPOS_Ziel = right(strDrehung,2);
		
		var strConfig_Abtriebsseite=ECL_GetValue("ABTRIEBSSEITE");
		if(strConfig_Abtriebsseite!= "" && strConfig_Abtriebsseite!= "-")
		{
			strEGPOS_Start=strEGPOS_Start+"-"+strConfig_Abtriebsseite;
			strEGPOS_Ziel=strEGPOS_Ziel+"-"+strConfig_Abtriebsseite;
		}
		
		var strAchse=ECL_GetValue("SE_ACHSE_WAHL");
		
		var strTableName="EGPOS_SCHRAEGBAULAGEN_"+strAchse+"_ACHSE";
		var strColumnName=strAchse+"_ACHSE";
		
		var strSelect="SELECT DISTINCT EGGEHOLA_OELSTAND_ZUL FROM "+strTableName+" WHERE ";
		strSelect = strSelect+"EGPOS_START='"+strEGPOS_Start+"' AND ";
		strSelect = strSelect+"EGPOS_ZIEL='"+strEGPOS_Ziel+"' AND ";
		strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
		strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "EGBEZDIM_MIN<="+oData.oRow.EGBEZDIM+" AND EGBEZDIM_MAX>="+oData.oRow.EGBEZDIM+" AND ";
		strSelect = strSelect + strColumnName + "='"+replace(ECL_GetValue("SE_ROTATIONSWINKEL"),strColumnName+"_","")+"' ";
		
		var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
		
		if(aResult.length>0)
		{
			strEGGEHOLA_OELSTAND_ZUL = aResult[0].EGGEHOLA_OELSTAND_ZUL;
		}
		else
		{
			logtraceln("Fehler beim Bestimmen Ölablassabhängigkeit bei den Sondereinbaulagen!; SQL="+strSelect);
		}
		
		strSelect = "SELECT DISTINCT EGGEHOLA FROM EGGEHOLA_M3 WHERE ";
		strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
		strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
		strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
		strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE")+"' OR EGABAWS='ALL') AND ";
		strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') AND ";
		strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
		strSelect = strSelect + "EINZELGETR = '1' AND ";
		strSelect = strSelect + "EGGEHOLTU='-' AND ";
		strSelect = strSelect + "CDROM_REL='1' AND ";
		strSelect = strSelect + "G115D='0' AND ";
		strSelect = strSelect + "G115M='0' AND ";
		strSelect = strSelect + "SONDER='-' AND ";
		strSelect = strSelect + "REGION IN ('S','SCE') AND ";
		strSelect = strSelect + "EGGEHOLA_OELSTAND_ZUL ='"+strEGGEHOLA_OELSTAND_ZUL+"' AND ";
		
		if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
		{
			strSelect = strSelect + "EGGEHOLA_M3.ATEX = '1' AND ";
		}
		
		if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
			strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor);
	}
	else
	{
		strSelect = "SELECT DISTINCT EGGEHOLA FROM EGGEHOLA_M3 WHERE ";
		strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
		strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
		strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
		strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
		strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
		strSelect = strSelect + "(EGABAWS='"+ECL_GetValue("ABTRIEBSSEITE")+"' OR EGABAWS='ALL') AND ";
		strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') AND ";
		
		if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
		{
			strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
			strSelect = strSelect + "EINZELGETR = '1' AND ";
		}
		else
		{
			strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
			strSelect = strSelect + "EINZELGETR = '1' AND ";
		}
		
		strSelect = strSelect + "EGGEHOLTU='-' AND ";
		strSelect = strSelect + "CDROM_REL='1' AND ";
		strSelect = strSelect + "G115D='0' AND ";
		strSelect = strSelect + "G115M='0' AND ";
		strSelect = strSelect + "SONDER='-' AND ";
		strSelect = strSelect + "REGION IN ('S','SCE') AND ";
		
		if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
		{
			strSelect = strSelect + "EGGEHOLA_M3.ATEX = '1' AND ";
		}
		
		if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
			strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor);

    }
           
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("OELABLASS");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("OELABLASS",aResult[i].EGGEHOLA);
        }
    }
    else
        logtraceln("Fehler bei Bestimmung Ölablass!, SQL="+strSelect);
        
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("OELABLASS"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("OELABLASS", aResultDefault[0].EGGEHOLA);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("OELABLASS", aResult[0].EGGEHOLA);
        }
    }
}

function istspielfreieAusfuehrungMoeglich(oData)
{
    // Bei Doppelgetriebe nicht möglich
	if(oData.oRow.ZGBEZUEBS != "-")
	{
		//spielfreie Ausführung nicht möglich
		ECL_DeselectValue("SPIELREDUZIERT_OPTION", "T");
		ECL_DisableAttribute("SPIELREDUZIERT_OPTION");
		
		return;
	}
    
    var Abtriebswellentyp = GetEGBEZANWTYP();
    var Verbindungsart = GetEGBEZWNV();
        
    var strSelect = "SELECT DISTINCT EGBEZSO FROM EGTYP,EGABKD_M3 WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZAWTYP='"+Abtriebswellentyp+"' AND ";
    strSelect = strSelect + "EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' AND ";
    strSelect = strSelect + "EGBEZWNV='"+Verbindungsart+"' AND ";
    strSelect = strSelect + "EGBEZSO='W' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "EGBEZEI='"+oData.oRow.EGBEZEI+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "S09 = '"+oData.oRow.S09+"' AND ";
    strSelect = strSelect + "EGTYP.TYPBEZ=EGABKD_M3.EGTYP AND ";
    strSelect = strSelect + "EGABKD_M3.EGABW = '"+ECL_GetValue("ABTRIEBSWELLENMASS")+"' AND ";
    
    if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        strSelect = strSelect + "EGTYP.ATEX = '1' AND ";
    }
    
    //Abfrage EGANSSART
    var strEGANSSART="BK4";
    if( (oData.oRow.EGBEZTYP=="-" || oData.oRow.EGBEZTYP=="B") && oData.oRow.EGBEZDIM=="19")
        strEGANSSART="Z19";
    else if(oData.oRow.EGBEZTYP=="S")
        strEGANSSART="S09";
    
    strSelect = strSelect + "EGANSSART = '"+strEGANSSART+"' AND ";
    
    if(ECL_ValueSelected("ZULAESSIGE_EINBAULAGENABWEICHUNG_OPTION", "T"))
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='1' AND ";
    else
        strSelect = strSelect + "ZUL_EINBAULAGE_ABW='0' AND ";
        
    strSelect = strSelect + "EGTYP.REGION IN ('S','SA','SACE') AND ";
    strSelect = strSelect + "MOTOX_N='0' AND ";
    strSelect = strSelect + "EGTYP.CDROM_REL='1' AND ";
    strSelect = strSelect + "EGTYP.AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    if(aResult.length>0)
    {
        //spielfreie Ausführung möglich
        ECL_EnableAttribute("SPIELREDUZIERT_OPTION");
    }
    else
    {
        //spielfreie Ausführung nicht möglich
        ECL_DeselectValue("SPIELREDUZIERT_OPTION", "T");
        ECL_DisableAttribute("SPIELREDUZIERT_OPTION");
    }
}

function istgeklebtesEndstufenradMoeglich(oData)
{
    var strSelect = "SELECT DISTINCT EGSPRED_WNV FROM EGSPRED_M3 WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
    
    if(ECL_ValueSelected("SPIELREDUZIERT_OPTION", "T"))
        strSelect = strSelect + "(EGBEZSO='W' OR EGBEZSO='ALL') AND ";
    else
        strSelect = strSelect + "(EGBEZSO='-' OR EGBEZSO='ALL') AND ";
    
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "EGSPRED_WNV='schrumpfkleben' AND ";
    strSelect = strSelect + "EINZELGETR='1' AND ";
    strSelect = strSelect + "SONDER='-' AND ";
    strSelect = strSelect + "AKTIV='1' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    if(aResult.length>0)
    {
        ECL_EnableValue("GEKLEBTES_ENDSTUFENRAD_OPTION","T");
        ECL_EnableAttribute("GEKLEBTES_ENDSTUFENRAD_OPTION");
    }
    else
    {
        ECL_DeselectValue("GEKLEBTES_ENDSTUFENRAD_OPTION", "T");
        ECL_DisableAttribute("GEKLEBTES_ENDSTUFENRAD_OPTION");
    }
}

function Bestimme_Gehaeusematerial(oData)
{
    //Bestimmung Gehäusematerial
    
    var strSelect = "SELECT DISTINCT EGGEHWS FROM EGGEHWS WHERE ";
    strSelect = strSelect + "(EGBEZTYP='"+oData.oRow.EGBEZTYP+"' OR EGBEZTYP='ALL') AND ";
    strSelect = strSelect + "(EGBEZUEBS='"+oData.oRow.EGBEZUEBS+"' OR EGBEZUEBS='ALL') AND ";
    strSelect = strSelect + "(EGBEZBRA='"+oData.oRow.EGBEZBRA+"' OR EGBEZBRA='ALL') AND ";
    strSelect = strSelect + "(EGBEZBEF='"+ECL_GetValue("BEFESTIGUNGSART")+"' OR EGBEZBEF='ALL') AND ";
    strSelect = strSelect + "(EGBEZDIM='"+oData.oRow.EGBEZDIM+"' OR EGBEZDIM='ALL') AND ";
    strSelect = strSelect + "(EGBEZEI='"+oData.oRow.EGBEZEI+"' OR EGBEZEI='ALL') AND ";
    strSelect = strSelect + "EINZELGETR = '1' AND ";
    strSelect = strSelect + "AKTIV = '1' AND ";
    
    if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
        strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        
    strSelect = strSelect + "CDROM_REL IN ('1','2') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("GEHAEUSEMATERIAL");
    ECL_DeactivateAttribute("GEHAEUSEMATERIAL");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("GEHAEUSEMATERIAL",aResult[i].EGGEHWS);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Gehäusematerial! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("GEHAEUSEMATERIAL"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("GEHAEUSEMATERIAL", aResultDefault[0].EGGEHWS);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("GEHAEUSEMATERIAL", aResult[0].EGGEHWS);
        }
    }
}

function Bestimme_KUPPLUNGSHEBEL_AUSFUEHRUNG(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_AUSF FROM EGABAKUPL_AUSF WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_AUSFUEHRUNG");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_AUSFUEHRUNG",aResult[i].HEBEL_AUSF);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Ausführung! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_AUSFUEHRUNG"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_AUSFUEHRUNG", aResultDefault[0].HEBEL_AUSF);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_AUSFUEHRUNG", aResult[0].HEBEL_AUSF);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_AUSFUEHRUNG") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_AUSFUEHRUNG");
    }
}

function Bestimme_KUPPLUNGSHEBEL_SCHALTWEG(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_LAGE FROM EGABAKUPL_LAGE WHERE ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
    strSelect = strSelect + "(EGPOSHL='"+ECL_GetValue("BAUFORM")+"' OR EGPOSHL='ALL') ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_SCHALTWEG");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_SCHALTWEG",aResult[i].HEBEL_LAGE);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Schaltweg! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_SCHALTWEG"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_SCHALTWEG", aResultDefault[0].HEBEL_LAGE);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_SCHALTWEG", aResult[0].HEBEL_LAGE);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_SCHALTWEG") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_SCHALTWEG");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_SCHALTWEG");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_SCHALTWEG");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_SCHALTWEG");
    }
}

function Bestimme_KUPPLUNGSHEBEL_LAGE(oData)
{
    var strSelect = "SELECT DISTINCT HEBEL_GRIFF FROM EGABAKUPL_GRIFF WHERE ";
    strSelect = strSelect + "HEBEL_AUSF='"+ECL_GetValue("KUPPLUNGSHEBEL_AUSFUEHRUNG")+"' AND ";
    strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
    strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
    strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' AND ";
    strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' ";
    
    var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
    
    ECL_DeactivateAllAttributeValues("KUPPLUNGSHEBEL_LAGE");
    if(aResult.length>0)
    {
        for(var i=0;i<aResult.length;i++)
        {
            ECL_ActivateValue("KUPPLUNGSHEBEL_LAGE",aResult[i].HEBEL_GRIFF);
        }
    }
    else
    {
        logtraceln("Fehler Bestimmung Kupplungshebel Lage! SQL="+strSelect);
    }	
        
    //Default Wert bestimmen
    if(isnewDefaultnecessary("KUPPLUNGSHEBEL_LAGE"))
    {
        var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT='1' ");
        if(aResultDefault.length>0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_LAGE", aResultDefault[0].HEBEL_GRIFF);
        }
        if(aResult.length > 0 && aResultDefault.length ==0)
        {
            ECL_SelectValue("KUPPLUNGSHEBEL_LAGE", aResult[0].HEBEL_GRIFF);
        }
    }
    
    if(ECL_GetValue("KUPPLUNGSHEBEL_LAGE") == "-")
    {
        ECL_DisableAttribute("KUPPLUNGSHEBEL_LAGE");
        ECL_DeactivateAttribute("KUPPLUNGSHEBEL_LAGE");
    }
    else
    {
        ECL_EnableAttribute("KUPPLUNGSHEBEL_LAGE");
        ECL_ActivateAttribute("KUPPLUNGSHEBEL_LAGE");
    }
}

function Bestimme_OelConsequence()
{
    var strOel=ECL_GetValue("GETRIEBEOEL");
    var strConsequence="";
    if(strOel=="CLP VG220")
        strConsequence="1";
    else if(strOel=="CLPH1 VG100")
        strConsequence="8";
    else if(strOel=="CLP PAO VG220")
        strConsequence="2";
    else if(strOel=="CLPH1 VG460")
        strConsequence="7";
    else if(strOel=="CLP PAO VG68")
        strConsequence="3";
    else if(strOel=="CLP PAO VG460")
        strConsequence="4";
    else if(strOel=="CLP PG VG220")
        strConsequence="6";
    else if(strOel=="CLP VG680")
        strConsequence="0";
    else if(strOel=="CLP PG VG460")
        strConsequence="5";
    else if(strOel=="CLPE VG220")
        strConsequence="9";
    
    ECL_SetValue("ECSI_CC_GearboxOil",strConsequence);
}