//@legacy
//#mode(full-ecma)


//@import "../VT_TF.js"


function Bestimme_Oberflaechenbehandlung(oData,strchangedAttribute)
{
    
    //Drive Train Implementierung
	if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1PH8"))
	{
        //1FK2
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "LACKIERT");
        
        if(strchangedAttribute == "ISDRIVETRAIN_OPTION")
        {
            ECL_SelectValue("OBERFLAECHENBEHANDLUNG","LACKIERT");
        }
        else
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG","LACKIERT");
        }
    }
    else if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1LE1")
    {
        //1LE1
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "LACKIERT");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "GRUNDIERT");
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG","LACKIERT");
    }
    else if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB5"))
    {
        //1LE1
        ECL_ActivateAttribute("OBERFLAECHENBEHANDLUNG");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "LACKIERT");
        ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG","LACKIERT");
    }
    else
    {
    
        // Fest codiert
        ECL_EnableAttribute("OBERFLAECHENBEHANDLUNG");
        ECL_DeactivateAllAttributeValues("OBERFLAECHENBEHANDLUNG");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "LACKIERT");
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "UNLACKIERT");
        
        ECL_ActivateValue("OBERFLAECHENBEHANDLUNG", "GRUNDIERT");
        
        //Bei Schnecken kein Grundiert
        if(oData.oRow.ANWTYP=="KleinSchnecke")
            ECL_DeactivateValue("OBERFLAECHENBEHANDLUNG", "GRUNDIERT");
            
        // Bei ATEX Adapter kein Grundiert	
        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || (ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED" && ECL_GetValue("ATEX_EXPLOSIONSGRUPPE")=='IIC'))
            ECL_DeactivateValue("OBERFLAECHENBEHANDLUNG", "GRUNDIERT");
        
        var strSelect = "SELECT * FROM FARBE_UNLACKIERT WHERE ";
        strSelect = strSelect + "MOTDIM='"+oData.oRow.MOTDIM+"' AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
            strSelect = strSelect + "MOTTYP='"+oData.oRow.MOTTYP+"' AND ";
        else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
            strSelect = strSelect + "MOTTYP='-' AND ";
        
       
        strSelect = strSelect + "EGBEZTYP='"+oData.oRow.EGBEZTYP+"' AND ";
        strSelect = strSelect + "EGBEZBRA='"+oData.oRow.EGBEZBRA+"' AND ";
        strSelect = strSelect + "EGBEZDIM='"+oData.oRow.EGBEZDIM+"' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        
        if ( aResult.length>0 )
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG","UNLACKIERT");
        }
        else
        {
            ExecSetStandardifValueEmpty("OBERFLAECHENBEHANDLUNG","LACKIERT");
        }
    }
}

function Bestimme_Beschichtung(oData)
{
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2") && ECL_GetValue("OBERFLAECHENBEHANDLUNG") == "LACKIERT")
    {
        //1FK2
        ECL_ActivateAttribute("BESCHICHTUNG");
        ECL_DeactivateAllAttributeValues("BESCHICHTUNG");
        ECL_ActivateValue("BESCHICHTUNG", "C1");
        ECL_SelectValue("BESCHICHTUNG","C1");
        ECL_DisableAttribute("BESCHICHTUNG");
    }
    else
    {
        ECL_EnableAttribute("BESCHICHTUNG");
        
        var strSelect = "SELECT DISTINCT NORM FROM FARBNORM WHERE ";
        strSelect = strSelect + "ANWTYP='"+oData.oRow.ANWTYP+"' AND ";
        strSelect = strSelect + "CDROM_REL = '1' AND ";
        strSelect = strSelect + "AKTIV = '1' AND ";
        strSelect = strSelect + "SONDER = '-' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "FARBNORM.ATEX = '1' AND ";
        }
        else
        {
            strSelect = strSelect + "FARBNORM.ATEX = '0' AND ";
        }
        
        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ECSI_ATEX_EGRUPPE")+"' AND ";
        }
        else if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ATEX_EXPLOSIONSGRUPPE")+"' AND ";
        }
        else
        {
            strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
        }
        
        
        strSelect = strSelect + "REGION IN ('S','SA','SACE','SACEI','SACEMI','SACEMNI','SAM','SAMN','SN') AND ";
        
        if(ECL_GetValue ("ECSI_2KJ_MODE") == "SIZER_CONFIG")
            strSelect = strSelect + "CAST(UMGEB_TEMP_MAX AS INT) >= "+parseInt(oData.oRow.SIZER_AmbientTemperatureMotor)+" AND ";
        
            if( (ECL_ValueSelected("MIT_GEBER", "T") && ECL_GetValue("GEBER_FUNKT_SICHERHEIT") != "-") || (ECL_ValueSelected("MIT_BREMSE", "T") && ECL_ValueSelected("BREMSE_SAFETY", "T")) )
            strSelect = strSelect + "FKTSICHERHEIT_KNR='SI' ";
        else
            strSelect = strSelect + "FKTSICHERHEIT_KNR='-' ";
        
        
        ECL_DeactivateAllAttributeValues("BESCHICHTUNG");
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        
        if ( aResult.length > 1 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("BESCHICHTUNG", aResult[i].NORM);
            }
            
            if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")=="GRUNDIERT")
            {
                //Normen für lackiert wieder deaktivieren
                ECL_DeactivateValue("BESCHICHTUNG", "C1");
                ECL_DeactivateValue("BESCHICHTUNG", "C2");
                ECL_DeactivateValue("BESCHICHTUNG", "C3");
                ECL_DeactivateValue("BESCHICHTUNG", "C4");
                ECL_DeactivateValue("BESCHICHTUNG", "C5");
                ECL_DeactivateValue("BESCHICHTUNG", "ohne");
            }
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")=="LACKIERT")
            {
                //Normen für grundiert wieder deaktivieren
                ECL_DeactivateValue("BESCHICHTUNG", "C2-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG", "C3-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG", "C4-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG", "C5-Grundiert");
                ECL_DeactivateValue("BESCHICHTUNG", "ohne");
            }
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")=="UNLACKIERT")
            {
                ECL_DeactivateAllAttributeValues("BESCHICHTUNG");
                ECL_ActivateValue("BESCHICHTUNG", "ohne");
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Beschichtung! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("BESCHICHTUNG"))
        {
            var aResultDefault="";
            if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")=="LACKIERT")
                aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT = '1' AND NORM NOT LIKE '%Grundiert'");
            else if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")=="GRUNDIERT")
                aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND DEFLT = '1' AND NORM LIKE '%Grundiert'");
                
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("BESCHICHTUNG", aResultDefault[0].NORM);
            }
            else if(aResult.length>0)
            {
                var aBeschichtungen=ECL_GetAllActiveAttributeValues("BESCHICHTUNG");
                ECL_SelectValue("BESCHICHTUNG", aBeschichtungen[0]);
            }
            else
                ECL_SelectValue("BESCHICHTUNG", "ohne");
        }
    }
}

function Bestimme_Farbe(oData)
{
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2") && ECL_GetValue("OBERFLAECHENBEHANDLUNG") == "LACKIERT")
    {
        //1FK2
        ECL_ActivateAttribute("FARBE");
        ECL_DeactivateAllAttributeValues("FARBE");
        ECL_ActivateValue("FARBE", "7016");
        ECL_SelectValue("FARBE","7016");
        ECL_DisableAttribute("FARBE");
    }
    else
    {
        ECL_EnableAttribute("FARBE");
        
        var strSelect = "SELECT DISTINCT RALNR FROM FARBRAL WHERE ";
        strSelect = strSelect + "NORM='"+ECL_GetValue("BESCHICHTUNG")+"' AND ";
        strSelect = strSelect + "SONDER = '-' AND ";
        strSelect = strSelect + "M3 = '1' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER" || ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "FARBRAL.ATEX = '1' AND ";
        }
        else
        {
            strSelect = strSelect + "FARBRAL.ATEX = '0' AND ";
        }
        
        strSelect = strSelect + "AKTIV='1' AND ";
        
        if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_ADAPTER")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ECSI_ATEX_EGRUPPE")+"' AND ";
            
        }
        else if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
        {
            strSelect = strSelect + "ATEXKATEGORIE='"+ECL_GetValue("ATEX_EXPLOSIONSGRUPPE")+"' AND ";
            
        }
        else
        {
            strSelect = strSelect + "ATEXKATEGORIE='-' AND ";
        }
        
        
        strSelect = strSelect + "REGION like'S%' AND ";
        
        //erweiterter Standard
        strSelect = strSelect + "CDROM_REL ='1' ";
        
        ECL_DeactivateAllAttributeValues("FARBE");
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if ( aResult.length > 0 )
        {	
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("FARBE", aResult[i].RALNR);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Farbe! SQL="+strSelect);
        }
        
        //Default Wert bestimmen
        if(isnewDefaultnecessary("FARBE"))
        {
            var aResultDefault = ExecSQL_Standard_SO("2KJ_DB", strSelect+" AND FARB_MISCH='-' AND DEFLT = '1'");
            if(aResultDefault.length>0)
            {
                ECL_SelectValue("FARBE", aResultDefault[0].RALNR);
            }
            if(aResult.length > 0 && aResultDefault.length<=0)
            {
                ECL_SelectValue("FARBE", aResult[0].RALNR);
            }
        }
    }
}

function istVorbehandlungmoeglich(oData)
{
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2"))
    {
        //nicht möglich
        ECL_DeselectValue("VORBEHANDLUNG_OPTION", "T");
        ECL_DisableAttribute("VORBEHANDLUNG_OPTION");
    }
    else
    {
        //Abhängigkeiten unklar
        if(ECL_GetValue("OBERFLAECHENBEHANDLUNG")== "UNLACKIERT")
        {
            //nicht möglich
            ECL_DeselectValue("VORBEHANDLUNG_OPTION", "T");
            ECL_DisableAttribute("VORBEHANDLUNG_OPTION");
        }
        else
        {
            //möglich
            ECL_EnableAttribute("VORBEHANDLUNG_OPTION");
            ECL_EnableValue("VORBEHANDLUNG_OPTION", "T");
        }
    }
}

function istLangzeitkonservierungmoeglich(oData)
{	
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB5"))
    {
        //1FK2//1LE1//1MB1
        ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION", "T");
        ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION");
    }
    else if(ECL_GetValue("ECSI_ATEX_KENNER") == "ATEX_INTEGRATED")
    {
        ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION", "T");
        ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION");
    }
    else
    {
        var strANTRIEB = "";
        var strMOTOR = "";
            
        if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBEMOTOR")
        {
            //Für Getriebemotoren
            strANTRIEB = "0";
            strMOTOR = "1";
        }
        else if(ECL_GetValue ("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
        {
            //Für Getriebe mit Adapter
            strANTRIEB = "1";
            strMOTOR = "0";
        }
        
        var strMotInnenKorrSchutz="nein";
        if(ECL_ValueSelected("INNENKORROSIONSSCHUTZ_OPTION", "T"))
        {
            strMotInnenKorrSchutz="ja";
        }
        
        var strSelect = "SELECT * FROM KONSERVIERUNG,OELSORTE_M3 WHERE ";
        strSelect = strSelect +"ANTRIEB = '"+strANTRIEB+"' AND ";
        strSelect = strSelect +"MOTOR = '"+strMOTOR+"' AND ";
        strSelect = strSelect +"MOINNENKORSCH = '"+strMotInnenKorrSchutz+"' AND ";
        strSelect = strSelect +"KONSERVIERUNG.KONS_VCI = OELSORTE_M3.KONS_VCI AND ";
        strSelect = strSelect +"OELSORTE = '"+ECL_GetValue("GETRIEBEOEL")+"' AND ";
        strSelect = strSelect +"KONSERVIERUNG.S09 = '"+oData.oRow.S09+"' AND ";
        strSelect = strSelect +"OELSORTE_M3.AKTIV = '1' AND ";
        strSelect = strSelect +"KONSERVIERUNG.AKTIV = '1' AND ";
        strSelect = strSelect +"KONSERVIERUNG.M3 = '1' AND ";
        strSelect = strSelect +"OELSORTE_M3.G115 IN ('ALL','0') AND ";
        strSelect = strSelect +"MOTOX_N = '0' ";
        
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if ( aResult.length > 0 )
        {
            ECL_EnableValue("LANGZEITKONSERVIERUNG_OPTION", "T");
            ECL_EnableAttribute("LANGZEITKONSERVIERUNG_OPTION");
        }
        else
        {
            ECL_DeselectValue("LANGZEITKONSERVIERUNG_OPTION", "T");
            ECL_DisableAttribute("LANGZEITKONSERVIERUNG_OPTION");
        }
    }
}

function BestimmeMaengelhaftung(oData)
{
    
    //Drive Train Implementierung
    if(ECL_ValueSelected("ISDRIVETRAIN_OPTION", "T") && (ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK2" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FT7" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1FK7"))  // || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1LE1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB1" || ECL_GetValue("DRIVETRAIN_SELECTED_MOTOR") == "1MB5"))
    {
        //1FK2 // 1LE1 // 1MB1 // 1MB5
        ECL_DeactivateAllAttributeValues("MAENGELHAFTUNG");
        ECL_ActivateValue("MAENGELHAFTUNG", "0");
        ECL_SelectValue("MAENGELHAFTUNG","0");
        ECL_DisableAttribute("MAENGELHAFTUNG");
    }
    else
    {
        //geht auch bei Drivetrain 1PH8
        ECL_EnableAttribute("MAENGELHAFTUNG");
        
        var strAdapterTyp="-";
        if(ECL_GetValue("ECSI_2KJ_TYPE") == "GETRIEBE.ADAPTER")
            strAdapterTyp=ECL_GetValue("ANTRIEBSGRUPPE_TYP");

        var strSelect = "SELECT MAENGELHAFT_KEY FROM M_ADAPTER_M_MAENGELHAFTUNG WHERE ";
        strSelect = strSelect +"ADAP_TYP='"+strAdapterTyp+"' ";
        
        ECL_DeactivateAllAttributeValues("MAENGELHAFTUNG");
        var aResult = ExecSQL_Standard_SO("2KJ_DB", strSelect);
        if ( aResult.length > 0 )
        {
            for(var i=0;i<aResult.length;i++)
            {
                ECL_ActivateValue("MAENGELHAFTUNG", aResult[i].MAENGELHAFT_KEY);
            }
        }
        else
        {
            logtraceln("Fehler Bestimmung Mängelhaftung! SQL="+strSelect);
        }
        
        ExecSetStandardifValueEmpty("MAENGELHAFTUNG","0");
    }
}

function Bestimme_Flanschlackierung(oData)
{

    ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH");
    
    if(ECL_GetValue("BEFESTIGUNGSART") == "F" || ECL_GetValue("BEFESTIGUNGSART") == "Z")
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH", "Standard");
    }
    
    //L11 und L12
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG") != "UNLACKIERT" && (ECL_GetValue("BEFESTIGUNGSART") == "F" || ECL_GetValue("BEFESTIGUNGSART") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH", "FKL");
        ECL_ActivateValue("LACKIERUNG_FLANSCH", "FLZN");
    }
    
    //L27
    if(ECL_GetValue("OBERFLAECHENBEHANDLUNG") != "UNLACKIERT" && ((oData.oRow.EGBEZTYP == "K" || oData.oRow.EGBEZTYP == "B") && ECL_GetValue("BEFESTIGUNGSART") == "Z"))
    {
        ECL_ActivateValue("LACKIERUNG_FLANSCH", "FLZBN");
    }
    
    var aAttributeValues = ECL_GetAllActiveAttributeValues ("LACKIERUNG_FLANSCH");
    if(aAttributeValues.length>0)
    {
        ECL_ActivateAttribute ("LACKIERUNG_FLANSCH");
        ECL_EnableAttribute("LACKIERUNG_FLANSCH");
        ExecSetStandardifValueEmpty("LACKIERUNG_FLANSCH","Standard");
    }
    else
    {
        ECL_DeactivateAllAttributeValues("LACKIERUNG_FLANSCH");
        ECL_DisableAttribute("LACKIERUNG_FLANSCH");
        ECL_DeactivateAttribute ("LACKIERUNG_FLANSCH");
        ECL_SelectValue("LACKIERUNG_FLANSCH", "Standard");
    }
}